"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _jestMatcherUtils = require("jest-matcher-utils");

var _lodash = require("lodash");

var _supportedMatchers = _interopRequireDefault(require("./supported-matchers"));

/**
 * External dependencies
 */

/**
 * Internal dependencies
 */
const createToHaveBeenCalledMatcher = (matcherName, methodName) => received => {
  const spy = received[methodName];
  const calls = spy.mock.calls;
  const pass = calls.length > 0;
  const message = pass ? () => (0, _jestMatcherUtils.matcherHint)(`.not${matcherName}`, spy.getMockName()) + '\n\n' + 'Expected mock function not to be called but it was called with:\n' + calls.map(_jestMatcherUtils.printReceived) : () => (0, _jestMatcherUtils.matcherHint)(matcherName, spy.getMockName()) + '\n\n' + 'Expected mock function to be called.';
  spy.assertionsNumber += 1;
  return {
    message,
    pass
  };
};

const createToHaveBeenCalledWith = (matcherName, methodName) => (received, ...expected) => {
  const spy = received[methodName];
  const calls = spy.mock.calls;
  const pass = (0, _lodash.some)(calls, objects => (0, _lodash.isEqual)(objects, expected));
  const message = pass ? () => (0, _jestMatcherUtils.matcherHint)(`.not${matcherName}`, spy.getMockName()) + '\n\n' + 'Expected mock function not to be called with:\n' + (0, _jestMatcherUtils.printExpected)(expected) : () => (0, _jestMatcherUtils.matcherHint)(matcherName, spy.getMockName()) + '\n\n' + 'Expected mock function to be called with:\n' + (0, _jestMatcherUtils.printExpected)(expected) + '\n' + 'but it was called with:\n' + calls.map(_jestMatcherUtils.printReceived);
  spy.assertionsNumber += 1;
  return {
    message,
    pass
  };
};

expect.extend((0, _lodash.reduce)(_supportedMatchers.default, (result, matcherName, methodName) => {
  const matcherNameWith = `${matcherName}With`;
  return { ...result,
    [matcherName]: createToHaveBeenCalledMatcher(`.${matcherName}`, methodName),
    [matcherNameWith]: createToHaveBeenCalledWith(`.${matcherNameWith}`, methodName)
  };
}, {}));
//# sourceMappingURL=matchers.js.map