'use strict';var _path = require('path');var _path2 = _interopRequireDefault(_path);
var _readPkgUp = require('read-pkg-up');var _readPkgUp2 = _interopRequireDefault(_readPkgUp);

var _resolve = require('eslint-module-utils/resolve');var _resolve2 = _interopRequireDefault(_resolve);
var _moduleVisitor = require('eslint-module-utils/moduleVisitor');var _moduleVisitor2 = _interopRequireDefault(_moduleVisitor);
var _importType = require('../core/importType');var _importType2 = _interopRequireDefault(_importType);
var _docsUrl = require('../docsUrl');var _docsUrl2 = _interopRequireDefault(_docsUrl);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { 'default': obj };}

function findNamedPackage(filePath) {
  var found = _readPkgUp2['default'].sync({ cwd: filePath, normalize: false });
  if (found.pkg && !found.pkg.name) {
    return findNamedPackage(_path2['default'].join(found.path, '../..'));
  }
  return found;
}

function checkImportForRelativePackage(context, importPath, node) {
  var potentialViolationTypes = ['parent', 'index', 'sibling'];
  if (potentialViolationTypes.indexOf((0, _importType2['default'])(importPath, context)) === -1) {
    return;
  }

  var resolvedImport = (0, _resolve2['default'])(importPath, context);
  var resolvedContext = context.getPhysicalFilename ? context.getPhysicalFilename() : context.getFilename();

  if (!resolvedImport || !resolvedContext) {
    return;
  }

  var importPkg = findNamedPackage(resolvedImport);
  var contextPkg = findNamedPackage(resolvedContext);

  if (importPkg.pkg && contextPkg.pkg && importPkg.pkg.name !== contextPkg.pkg.name) {
    var importBaseName = _path2['default'].basename(importPath);
    var importRoot = _path2['default'].dirname(importPkg.path);
    var properPath = _path2['default'].relative(importRoot, resolvedImport);
    var properImport = _path2['default'].join(
    importPkg.pkg.name,
    _path2['default'].dirname(properPath),
    importBaseName === _path2['default'].basename(importRoot) ? '' : importBaseName);

    context.report({
      node: node,
      message: 'Relative import from another package is not allowed. Use `' + String(properImport) + '` instead of `' + String(importPath) + '`' });

  }
}

module.exports = {
  meta: {
    type: 'suggestion',
    docs: {
      url: (0, _docsUrl2['default'])('no-relative-packages') },

    schema: [(0, _moduleVisitor.makeOptionsSchema)()] },


  create: function () {function create(context) {
      return (0, _moduleVisitor2['default'])(function (source) {return checkImportForRelativePackage(context, source.value, source);}, context.options[0]);
    }return create;}() };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9ydWxlcy9uby1yZWxhdGl2ZS1wYWNrYWdlcy5qcyJdLCJuYW1lcyI6WyJmaW5kTmFtZWRQYWNrYWdlIiwiZmlsZVBhdGgiLCJmb3VuZCIsInJlYWRQa2dVcCIsInN5bmMiLCJjd2QiLCJub3JtYWxpemUiLCJwa2ciLCJuYW1lIiwicGF0aCIsImpvaW4iLCJjaGVja0ltcG9ydEZvclJlbGF0aXZlUGFja2FnZSIsImNvbnRleHQiLCJpbXBvcnRQYXRoIiwibm9kZSIsInBvdGVudGlhbFZpb2xhdGlvblR5cGVzIiwiaW5kZXhPZiIsInJlc29sdmVkSW1wb3J0IiwicmVzb2x2ZWRDb250ZXh0IiwiZ2V0UGh5c2ljYWxGaWxlbmFtZSIsImdldEZpbGVuYW1lIiwiaW1wb3J0UGtnIiwiY29udGV4dFBrZyIsImltcG9ydEJhc2VOYW1lIiwiYmFzZW5hbWUiLCJpbXBvcnRSb290IiwiZGlybmFtZSIsInByb3BlclBhdGgiLCJyZWxhdGl2ZSIsInByb3BlckltcG9ydCIsInJlcG9ydCIsIm1lc3NhZ2UiLCJtb2R1bGUiLCJleHBvcnRzIiwibWV0YSIsInR5cGUiLCJkb2NzIiwidXJsIiwic2NoZW1hIiwiY3JlYXRlIiwic291cmNlIiwidmFsdWUiLCJvcHRpb25zIl0sIm1hcHBpbmdzIjoiYUFBQSw0QjtBQUNBLHdDOztBQUVBLHNEO0FBQ0Esa0U7QUFDQSxnRDtBQUNBLHFDOztBQUVBLFNBQVNBLGdCQUFULENBQTBCQyxRQUExQixFQUFvQztBQUNsQyxNQUFNQyxRQUFRQyx1QkFBVUMsSUFBVixDQUFlLEVBQUVDLEtBQUtKLFFBQVAsRUFBaUJLLFdBQVcsS0FBNUIsRUFBZixDQUFkO0FBQ0EsTUFBSUosTUFBTUssR0FBTixJQUFhLENBQUNMLE1BQU1LLEdBQU4sQ0FBVUMsSUFBNUIsRUFBa0M7QUFDaEMsV0FBT1IsaUJBQWlCUyxrQkFBS0MsSUFBTCxDQUFVUixNQUFNTyxJQUFoQixFQUFzQixPQUF0QixDQUFqQixDQUFQO0FBQ0Q7QUFDRCxTQUFPUCxLQUFQO0FBQ0Q7O0FBRUQsU0FBU1MsNkJBQVQsQ0FBdUNDLE9BQXZDLEVBQWdEQyxVQUFoRCxFQUE0REMsSUFBNUQsRUFBa0U7QUFDaEUsTUFBTUMsMEJBQTBCLENBQUMsUUFBRCxFQUFXLE9BQVgsRUFBb0IsU0FBcEIsQ0FBaEM7QUFDQSxNQUFJQSx3QkFBd0JDLE9BQXhCLENBQWdDLDZCQUFXSCxVQUFYLEVBQXVCRCxPQUF2QixDQUFoQyxNQUFxRSxDQUFDLENBQTFFLEVBQTZFO0FBQzNFO0FBQ0Q7O0FBRUQsTUFBTUssaUJBQWlCLDBCQUFRSixVQUFSLEVBQW9CRCxPQUFwQixDQUF2QjtBQUNBLE1BQU1NLGtCQUFrQk4sUUFBUU8sbUJBQVIsR0FBOEJQLFFBQVFPLG1CQUFSLEVBQTlCLEdBQThEUCxRQUFRUSxXQUFSLEVBQXRGOztBQUVBLE1BQUksQ0FBQ0gsY0FBRCxJQUFtQixDQUFDQyxlQUF4QixFQUF5QztBQUN2QztBQUNEOztBQUVELE1BQU1HLFlBQVlyQixpQkFBaUJpQixjQUFqQixDQUFsQjtBQUNBLE1BQU1LLGFBQWF0QixpQkFBaUJrQixlQUFqQixDQUFuQjs7QUFFQSxNQUFJRyxVQUFVZCxHQUFWLElBQWlCZSxXQUFXZixHQUE1QixJQUFtQ2MsVUFBVWQsR0FBVixDQUFjQyxJQUFkLEtBQXVCYyxXQUFXZixHQUFYLENBQWVDLElBQTdFLEVBQW1GO0FBQ2pGLFFBQU1lLGlCQUFpQmQsa0JBQUtlLFFBQUwsQ0FBY1gsVUFBZCxDQUF2QjtBQUNBLFFBQU1ZLGFBQWFoQixrQkFBS2lCLE9BQUwsQ0FBYUwsVUFBVVosSUFBdkIsQ0FBbkI7QUFDQSxRQUFNa0IsYUFBYWxCLGtCQUFLbUIsUUFBTCxDQUFjSCxVQUFkLEVBQTBCUixjQUExQixDQUFuQjtBQUNBLFFBQU1ZLGVBQWVwQixrQkFBS0MsSUFBTDtBQUNuQlcsY0FBVWQsR0FBVixDQUFjQyxJQURLO0FBRW5CQyxzQkFBS2lCLE9BQUwsQ0FBYUMsVUFBYixDQUZtQjtBQUduQkosdUJBQW1CZCxrQkFBS2UsUUFBTCxDQUFjQyxVQUFkLENBQW5CLEdBQStDLEVBQS9DLEdBQW9ERixjQUhqQyxDQUFyQjs7QUFLQVgsWUFBUWtCLE1BQVIsQ0FBZTtBQUNiaEIsZ0JBRGE7QUFFYmlCLHFGQUF1RUYsWUFBdkUsOEJBQXNHaEIsVUFBdEcsT0FGYSxFQUFmOztBQUlEO0FBQ0Y7O0FBRURtQixPQUFPQyxPQUFQLEdBQWlCO0FBQ2ZDLFFBQU07QUFDSkMsVUFBTSxZQURGO0FBRUpDLFVBQU07QUFDSkMsV0FBSywwQkFBUSxzQkFBUixDQURELEVBRkY7O0FBS0pDLFlBQVEsQ0FBQyx1Q0FBRCxDQUxKLEVBRFM7OztBQVNmQyxRQVRlLCtCQVNSM0IsT0FUUSxFQVNDO0FBQ2QsYUFBTyxnQ0FBYyxVQUFDNEIsTUFBRCxVQUFZN0IsOEJBQThCQyxPQUE5QixFQUF1QzRCLE9BQU9DLEtBQTlDLEVBQXFERCxNQUFyRCxDQUFaLEVBQWQsRUFBd0Y1QixRQUFROEIsT0FBUixDQUFnQixDQUFoQixDQUF4RixDQUFQO0FBQ0QsS0FYYyxtQkFBakIiLCJmaWxlIjoibm8tcmVsYXRpdmUtcGFja2FnZXMuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCByZWFkUGtnVXAgZnJvbSAncmVhZC1wa2ctdXAnO1xuXG5pbXBvcnQgcmVzb2x2ZSBmcm9tICdlc2xpbnQtbW9kdWxlLXV0aWxzL3Jlc29sdmUnO1xuaW1wb3J0IG1vZHVsZVZpc2l0b3IsIHsgbWFrZU9wdGlvbnNTY2hlbWEgfSBmcm9tICdlc2xpbnQtbW9kdWxlLXV0aWxzL21vZHVsZVZpc2l0b3InO1xuaW1wb3J0IGltcG9ydFR5cGUgZnJvbSAnLi4vY29yZS9pbXBvcnRUeXBlJztcbmltcG9ydCBkb2NzVXJsIGZyb20gJy4uL2RvY3NVcmwnO1xuXG5mdW5jdGlvbiBmaW5kTmFtZWRQYWNrYWdlKGZpbGVQYXRoKSB7XG4gIGNvbnN0IGZvdW5kID0gcmVhZFBrZ1VwLnN5bmMoeyBjd2Q6IGZpbGVQYXRoLCBub3JtYWxpemU6IGZhbHNlIH0pO1xuICBpZiAoZm91bmQucGtnICYmICFmb3VuZC5wa2cubmFtZSkge1xuICAgIHJldHVybiBmaW5kTmFtZWRQYWNrYWdlKHBhdGguam9pbihmb3VuZC5wYXRoLCAnLi4vLi4nKSk7XG4gIH1cbiAgcmV0dXJuIGZvdW5kO1xufVxuXG5mdW5jdGlvbiBjaGVja0ltcG9ydEZvclJlbGF0aXZlUGFja2FnZShjb250ZXh0LCBpbXBvcnRQYXRoLCBub2RlKSB7XG4gIGNvbnN0IHBvdGVudGlhbFZpb2xhdGlvblR5cGVzID0gWydwYXJlbnQnLCAnaW5kZXgnLCAnc2libGluZyddO1xuICBpZiAocG90ZW50aWFsVmlvbGF0aW9uVHlwZXMuaW5kZXhPZihpbXBvcnRUeXBlKGltcG9ydFBhdGgsIGNvbnRleHQpKSA9PT0gLTEpIHtcbiAgICByZXR1cm47XG4gIH1cblxuICBjb25zdCByZXNvbHZlZEltcG9ydCA9IHJlc29sdmUoaW1wb3J0UGF0aCwgY29udGV4dCk7XG4gIGNvbnN0IHJlc29sdmVkQ29udGV4dCA9IGNvbnRleHQuZ2V0UGh5c2ljYWxGaWxlbmFtZSA/IGNvbnRleHQuZ2V0UGh5c2ljYWxGaWxlbmFtZSgpIDogY29udGV4dC5nZXRGaWxlbmFtZSgpO1xuXG4gIGlmICghcmVzb2x2ZWRJbXBvcnQgfHwgIXJlc29sdmVkQ29udGV4dCkge1xuICAgIHJldHVybjtcbiAgfVxuXG4gIGNvbnN0IGltcG9ydFBrZyA9IGZpbmROYW1lZFBhY2thZ2UocmVzb2x2ZWRJbXBvcnQpO1xuICBjb25zdCBjb250ZXh0UGtnID0gZmluZE5hbWVkUGFja2FnZShyZXNvbHZlZENvbnRleHQpO1xuXG4gIGlmIChpbXBvcnRQa2cucGtnICYmIGNvbnRleHRQa2cucGtnICYmIGltcG9ydFBrZy5wa2cubmFtZSAhPT0gY29udGV4dFBrZy5wa2cubmFtZSkge1xuICAgIGNvbnN0IGltcG9ydEJhc2VOYW1lID0gcGF0aC5iYXNlbmFtZShpbXBvcnRQYXRoKTtcbiAgICBjb25zdCBpbXBvcnRSb290ID0gcGF0aC5kaXJuYW1lKGltcG9ydFBrZy5wYXRoKTtcbiAgICBjb25zdCBwcm9wZXJQYXRoID0gcGF0aC5yZWxhdGl2ZShpbXBvcnRSb290LCByZXNvbHZlZEltcG9ydCk7XG4gICAgY29uc3QgcHJvcGVySW1wb3J0ID0gcGF0aC5qb2luKFxuICAgICAgaW1wb3J0UGtnLnBrZy5uYW1lLFxuICAgICAgcGF0aC5kaXJuYW1lKHByb3BlclBhdGgpLFxuICAgICAgaW1wb3J0QmFzZU5hbWUgPT09IHBhdGguYmFzZW5hbWUoaW1wb3J0Um9vdCkgPyAnJyA6IGltcG9ydEJhc2VOYW1lXG4gICAgKTtcbiAgICBjb250ZXh0LnJlcG9ydCh7XG4gICAgICBub2RlLFxuICAgICAgbWVzc2FnZTogYFJlbGF0aXZlIGltcG9ydCBmcm9tIGFub3RoZXIgcGFja2FnZSBpcyBub3QgYWxsb3dlZC4gVXNlIFxcYCR7cHJvcGVySW1wb3J0fVxcYCBpbnN0ZWFkIG9mIFxcYCR7aW1wb3J0UGF0aH1cXGBgLFxuICAgIH0pO1xuICB9XG59XG5cbm1vZHVsZS5leHBvcnRzID0ge1xuICBtZXRhOiB7XG4gICAgdHlwZTogJ3N1Z2dlc3Rpb24nLFxuICAgIGRvY3M6IHtcbiAgICAgIHVybDogZG9jc1VybCgnbm8tcmVsYXRpdmUtcGFja2FnZXMnKSxcbiAgICB9LFxuICAgIHNjaGVtYTogW21ha2VPcHRpb25zU2NoZW1hKCldLFxuICB9LFxuXG4gIGNyZWF0ZShjb250ZXh0KSB7XG4gICAgcmV0dXJuIG1vZHVsZVZpc2l0b3IoKHNvdXJjZSkgPT4gY2hlY2tJbXBvcnRGb3JSZWxhdGl2ZVBhY2thZ2UoY29udGV4dCwgc291cmNlLnZhbHVlLCBzb3VyY2UpLCBjb250ZXh0Lm9wdGlvbnNbMF0pO1xuICB9LFxufTtcbiJdfQ==