"use strict";

exports.__esModule = true;
exports.defaultOptions = exports.getDefaultOptions = exports.setDefaultOptions = void 0;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

let defaultOptionsValue = {
  timeout: 500
};

const setDefaultOptions = options => {
  defaultOptionsValue = options;
};

exports.setDefaultOptions = setDefaultOptions;

const getDefaultOptions = () => {
  if (global.puppeteerConfig && (global.puppeteerConfig.launch && global.puppeteerConfig.launch.slowMo || global.puppeteerConfig.connect && global.puppeteerConfig.connect.slowMo) && defaultOptionsValue && defaultOptionsValue.timeout) {
    return _extends({}, defaultOptionsValue, {
      // Multiplying slowMo by 10 is just arbitrary
      // slowMo is applied on all Puppeteer internal methods, so it is just a "slow" indicator
      // we can't use it as a real value
      timeout: defaultOptionsValue.timeout + global.puppeteerConfig.launch.slowMo * 10
    });
  }

  return defaultOptionsValue;
};

exports.getDefaultOptions = getDefaultOptions;

const defaultOptions = options => _extends({}, getDefaultOptions(), {}, options);

exports.defaultOptions = defaultOptions;