// make sure to keep this as 'var'
// we don't want block scoping

var dartNodePreambleSelf = typeof global !== "undefined" ? global : window;

var self = Object.create(dartNodePreambleSelf);

self.scheduleImmediate = typeof setImmediate !== "undefined"
    ? function (cb) {
        setImmediate(cb);
      }
    : function(cb) {
        setTimeout(cb, 0);
      };

// CommonJS globals.
self.exports = exports;

// Node.js specific exports, check to see if they exist & or polyfilled

if (typeof process !== "undefined") {
  self.process = process;
}

if (typeof __dirname !== "undefined") {
  self.__dirname = __dirname;
}

if (typeof __filename !== "undefined") {
  self.__filename = __filename;
}

if (typeof Buffer !== "undefined") {
  self.Buffer = Buffer;
}

// if we're running in a browser, Dart supports most of this out of box
// make sure we only run these in Node.js environment

var dartNodeIsActuallyNode = !dartNodePreambleSelf.window

try {
  // Check if we're in a Web Worker instead.
  if ("undefined" !== typeof WorkerGlobalScope && dartNodePreambleSelf instanceof WorkerGlobalScope) {
    dartNodeIsActuallyNode = false;
  }

  // Check if we're in Electron, with Node.js integration, and override if true.
  if ("undefined" !== typeof process && process.versions && process.versions.hasOwnProperty('electron') && process.versions.hasOwnProperty('node')) {
    dartNodeIsActuallyNode = true;
  }
} catch(e) {}

if (dartNodeIsActuallyNode) {
  // This line is to:
  // 1) Prevent Webpack from bundling.
  // 2) In Webpack on Node.js, make sure we're using the native Node.js require, which is available via __non_webpack_require__
  // https://github.com/mbullington/node_preamble.dart/issues/18#issuecomment-527305561
  var url = ("undefined" !== typeof __webpack_require__ ? __non_webpack_require__ : require)("url");

  // Setting `self.location=` in Electron throws a `TypeError`, so we define it
  // as a property instead to be safe.
  Object.defineProperty(self, "location", {
    value: {
      get href() {
        if (url.pathToFileURL) {
          return url.pathToFileURL(process.cwd()).href + "/";
        } else {
          // This isn't really a correct transformation, but it's the best we have
          // for versions of Node <10.12.0 which introduced `url.pathToFileURL()`.
          // For example, it will fail for paths that contain characters that need
          // to be escaped in URLs.
          return "file://" + (function() {
            var cwd = process.cwd();
            if (process.platform != "win32") return cwd;
            return "/" + cwd.replace(/\\/g, "/");
          })() + "/"
        }
      }
    }
  });

  (function() {
    function computeCurrentScript() {
      try {
        throw new Error();
      } catch(e) {
        var stack = e.stack;
        var re = new RegExp("^ *at [^(]*\\((.*):[0-9]*:[0-9]*\\)$", "mg");
        var lastMatch = null;
        do {
          var match = re.exec(stack);
          if (match != null) lastMatch = match;
        } while (match != null);
        return lastMatch[1];
      }
    }

    // Setting `self.document=` isn't known to throw an error anywhere like
    // `self.location=` does on Electron, but it's better to be future-proof
    // just in case..
    var cachedCurrentScript = null;
    Object.defineProperty(self, "document", {
      value: {
        get currentScript() {
          if (cachedCurrentScript == null) {
            cachedCurrentScript = {src: computeCurrentScript()};
          }
          return cachedCurrentScript;
        }
      }
    });
  })();

  self.dartDeferredLibraryLoader = function(uri, successCallback, errorCallback) {
    try {
     load(uri);
      successCallback();
    } catch (error) {
      errorCallback(error);
    }
  };
}

self.chokidar = require("chokidar");
self.readline = require("readline");
self.fs = require("fs");
// Generated by dart2js (NullSafetyMode.sound, trust primitives, omit checks, lax runtime type, no-legacy-javascript), the Dart to JavaScript compiler version: 2.14.2.
// The code supports the following hooks:
// dartPrint(message):
//    if this function is defined it is called instead of the Dart [print]
//    method.
//
// dartMainRunner(main, args):
//    if this function is defined, the Dart [main] method will not be invoked
//    directly. Instead, a closure that will invoke [main], and its arguments
//    [args] is passed to [dartMainRunner].
//
// dartDeferredLibraryLoader(uri, successCallback, errorCallback, loadId):
//    if this function is defined, it will be called when a deferred library
//    is loaded. It should load and eval the javascript of `uri`, and call
//    successCallback. If it fails to do so, it should call errorCallback with
//    an error. The loadId argument is the deferred import that resulted in
//    this uri being loaded.
//
// dartCallInstrumentation(id, qualifiedName):
//    if this function is defined, it will be called at each entry of a
//    method or constructor. Used only when compiling programs with
//    --experiment-call-instrumentation.
(function dartProgram() {
  function copyProperties(from, to) {
    var keys = Object.keys(from);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      to[key] = from[key];
    }
  }
  function mixinProperties(from, to) {
    var keys = Object.keys(from);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      if (!to.hasOwnProperty(key))
        to[key] = from[key];
    }
  }
  var supportsDirectProtoAccess = function() {
    var cls = function() {
    };
    cls.prototype = {p: {}};
    var object = new cls();
    if (!(object.__proto__ && object.__proto__.p === cls.prototype.p))
      return false;
    try {
      if (typeof navigator != "undefined" && typeof navigator.userAgent == "string" && navigator.userAgent.indexOf("Chrome/") >= 0)
        return true;
      if (typeof version == "function" && version.length == 0) {
        var v = version();
        if (/^\d+\.\d+\.\d+\.\d+$/.test(v))
          return true;
      }
    } catch (_) {
    }
    return false;
  }();
  function setFunctionNamesIfNecessary(holders) {
    function t() {
    }
    ;
    if (typeof t.name == "string")
      return;
    for (var i = 0; i < holders.length; i++) {
      var holder = holders[i];
      var keys = Object.keys(holder);
      for (var j = 0; j < keys.length; j++) {
        var key = keys[j];
        var f = holder[key];
        if (typeof f == "function")
          f.name = key;
      }
    }
  }
  function inherit(cls, sup) {
    cls.prototype.constructor = cls;
    cls.prototype["$is" + cls.name] = cls;
    if (sup != null) {
      if (supportsDirectProtoAccess) {
        cls.prototype.__proto__ = sup.prototype;
        return;
      }
      var clsPrototype = Object.create(sup.prototype);
      copyProperties(cls.prototype, clsPrototype);
      cls.prototype = clsPrototype;
    }
  }
  function inheritMany(sup, classes) {
    for (var i = 0; i < classes.length; i++)
      inherit(classes[i], sup);
  }
  function mixin(cls, mixin) {
    mixinProperties(mixin.prototype, cls.prototype);
    cls.prototype.constructor = cls;
  }
  function lazyOld(holder, name, getterName, initializer) {
    var uninitializedSentinel = holder;
    holder[name] = uninitializedSentinel;
    holder[getterName] = function() {
      holder[getterName] = function() {
        H.throwCyclicInit(name);
      };
      var result;
      var sentinelInProgress = initializer;
      try {
        if (holder[name] === uninitializedSentinel) {
          result = holder[name] = sentinelInProgress;
          result = holder[name] = initializer();
        } else
          result = holder[name];
      } finally {
        if (result === sentinelInProgress)
          holder[name] = null;
        holder[getterName] = function() {
          return this[name];
        };
      }
      return result;
    };
  }
  function lazy(holder, name, getterName, initializer) {
    var uninitializedSentinel = holder;
    holder[name] = uninitializedSentinel;
    holder[getterName] = function() {
      if (holder[name] === uninitializedSentinel)
        holder[name] = initializer();
      holder[getterName] = function() {
        return this[name];
      };
      return holder[name];
    };
  }
  function lazyFinal(holder, name, getterName, initializer) {
    var uninitializedSentinel = holder;
    holder[name] = uninitializedSentinel;
    holder[getterName] = function() {
      if (holder[name] === uninitializedSentinel) {
        var value = initializer();
        if (holder[name] !== uninitializedSentinel)
          H.throwLateFieldADI(name);
        holder[name] = value;
      }
      holder[getterName] = function() {
        return this[name];
      };
      return holder[name];
    };
  }
  function makeConstList(list) {
    list.immutable$list = Array;
    list.fixed$length = Array;
    return list;
  }
  function convertToFastObject(properties) {
    function t() {
    }
    t.prototype = properties;
    new t();
    return properties;
  }
  function convertAllToFastObject(arrayOfObjects) {
    for (var i = 0; i < arrayOfObjects.length; ++i)
      convertToFastObject(arrayOfObjects[i]);
  }
  var functionCounter = 0;
  function instanceTearOffGetter(isIntercepted, parameters) {
    var name = parameters.fs[0];
    if (isIntercepted)
      return new Function("parameters, createTearOffClass, cache", "return function tearOff_" + name + functionCounter++ + "(receiver) {" + "if (cache === null) cache = createTearOffClass(parameters);" + "return new cache(receiver, this);" + "}")(parameters, H.closureFromTearOff, null);
    else
      return new Function("parameters, createTearOffClass, cache", "return function tearOff_" + name + functionCounter++ + "() {" + "if (cache === null) cache = createTearOffClass(parameters);" + "return new cache(this, null);" + "}")(parameters, H.closureFromTearOff, null);
  }
  function staticTearOffGetter(parameters) {
    var cache = null;
    return function() {
      if (cache === null)
        cache = H.closureFromTearOff(parameters).prototype;
      return cache;
    };
  }
  var typesOffset = 0;
  function tearOffParameters(container, isStatic, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex, needsDirectAccess) {
    if (typeof funType == "number")
      funType += typesOffset;
    return {co: container, iS: isStatic, iI: isIntercepted, rC: requiredParameterCount, dV: optionalParameterDefaultValues, cs: callNames, fs: funsOrNames, fT: funType, aI: applyIndex || 0, nDA: needsDirectAccess};
  }
  function installStaticTearOff(holder, getterName, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex) {
    var parameters = tearOffParameters(holder, true, false, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex, false);
    var getterFunction = staticTearOffGetter(parameters);
    holder[getterName] = getterFunction;
  }
  function installInstanceTearOff(prototype, getterName, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex, needsDirectAccess) {
    isIntercepted = !!isIntercepted;
    var parameters = tearOffParameters(prototype, false, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex, !!needsDirectAccess);
    var getterFunction = instanceTearOffGetter(isIntercepted, parameters);
    prototype[getterName] = getterFunction;
  }
  function setOrUpdateInterceptorsByTag(newTags) {
    var tags = init.interceptorsByTag;
    if (!tags) {
      init.interceptorsByTag = newTags;
      return;
    }
    copyProperties(newTags, tags);
  }
  function setOrUpdateLeafTags(newTags) {
    var tags = init.leafTags;
    if (!tags) {
      init.leafTags = newTags;
      return;
    }
    copyProperties(newTags, tags);
  }
  function updateTypes(newTypes) {
    var types = init.types;
    var length = types.length;
    types.push.apply(types, newTypes);
    return length;
  }
  function updateHolder(holder, newHolder) {
    copyProperties(newHolder, holder);
    return holder;
  }
  var hunkHelpers = function() {
    var mkInstance = function(isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, applyIndex) {
        return function(container, getterName, name, funType) {
          return installInstanceTearOff(container, getterName, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, [name], funType, applyIndex, false);
        };
      },
      mkStatic = function(requiredParameterCount, optionalParameterDefaultValues, callNames, applyIndex) {
        return function(container, getterName, name, funType) {
          return installStaticTearOff(container, getterName, requiredParameterCount, optionalParameterDefaultValues, callNames, [name], funType, applyIndex);
        };
      };
    return {inherit: inherit, inheritMany: inheritMany, mixin: mixin, installStaticTearOff: installStaticTearOff, installInstanceTearOff: installInstanceTearOff, _instance_0u: mkInstance(0, 0, null, ["call$0"], 0), _instance_1u: mkInstance(0, 1, null, ["call$1"], 0), _instance_2u: mkInstance(0, 2, null, ["call$2"], 0), _instance_0i: mkInstance(1, 0, null, ["call$0"], 0), _instance_1i: mkInstance(1, 1, null, ["call$1"], 0), _instance_2i: mkInstance(1, 2, null, ["call$2"], 0), _static_0: mkStatic(0, null, ["call$0"], 0), _static_1: mkStatic(1, null, ["call$1"], 0), _static_2: mkStatic(2, null, ["call$2"], 0), makeConstList: makeConstList, lazy: lazy, lazyFinal: lazyFinal, lazyOld: lazyOld, updateHolder: updateHolder, convertToFastObject: convertToFastObject, setFunctionNamesIfNecessary: setFunctionNamesIfNecessary, updateTypes: updateTypes, setOrUpdateInterceptorsByTag: setOrUpdateInterceptorsByTag, setOrUpdateLeafTags: setOrUpdateLeafTags};
  }();
  function initializeDeferredHunk(hunk) {
    typesOffset = init.types.length;
    hunk(hunkHelpers, init, holders, $);
  }
  var A = {MapExpression: function MapExpression(t0, t1) {
      this.pairs = t0;
      this.span = t1;
    }, MapExpression_toString_closure: function MapExpression_toString_closure() {
    }, IncludeRule: function IncludeRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.$arguments = t2;
      _.content = t3;
      _.span = t4;
    }, Configuration: function Configuration(t0) {
      this._values = t0;
    }, Configuration_toString_closure: function Configuration_toString_closure() {
    }, ExplicitConfiguration: function ExplicitConfiguration(t0, t1) {
      this.nodeWithSpan = t0;
      this._values = t1;
    },
    watch(options, graph) {
      return A.watch$body(options, graph);
    },
    watch$body(options, graph) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.void),
        $async$returnValue, t1, t2, t3, t4, t5, t6, dirWatcher, watcher;
      var $async$watch = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              options._ensureSources$0();
              t1 = type$.String;
              t2 = options.get$_sourceDirectoriesToDestinations().cast$2$0(0, t1, t1);
              t2 = P.List_List$of(t2.get$keys(t2), true, t1);
              for (options._ensureSources$0(), t3 = options._sourcesToDestinations.cast$2$0(0, t1, t1), t3 = J.get$iterator$ax(t3.get$keys(t3)); t3.moveNext$0();) {
                t4 = t3.get$current(t3);
                t2.push($.$get$context().dirname$1(t4));
              }
              t3 = options._options;
              C.JSArray_methods.addAll$1(t2, type$.List_String._as(t3.$index(0, "load-path")));
              t4 = H._asBool(t3.$index(0, "poll"));
              t5 = type$.Stream_WatchEvent;
              t6 = K.PathMap__create(null, t5);
              t5 = new L.StreamGroup(C._StreamGroupState_dormant, P.LinkedHashMap_LinkedHashMap$_empty(t5, type$.nullable_StreamSubscription_WatchEvent), type$.StreamGroup_WatchEvent);
              t5.__StreamGroup__controller = P.StreamController_StreamController(t5.get$_onCancel(), t5.get$_onListen(), t5.get$_onPause(), t5.get$_onResume(), true, type$.WatchEvent);
              dirWatcher = new U.MultiDirWatcher(new K.PathMap(t6, type$.PathMap_Stream_WatchEvent), t5, t4);
              $async$goto = 3;
              return P._asyncAwait(P.Future_wait(new H.MappedListIterable(t2, new A.watch_closure(dirWatcher), H._arrayInstanceType(t2)._eval$1("MappedListIterable<1,Future<~>>")), type$.void), $async$watch);
            case 3:
              // returning from await.
              watcher = new A._Watcher(options, graph);
              options._ensureSources$0(), t1 = options._sourcesToDestinations.cast$2$0(0, t1, t1), t1 = t1.get$entries(t1), t1 = t1.get$iterator(t1);
            case 4:
              // for condition
              if (!t1.moveNext$0()) {
                // goto after for
                $async$goto = 5;
                break;
              }
              t2 = t1.get$current(t1);
              t4 = $.$get$context();
              t5 = t4.absolute$7(".", null, null, null, null, null, null);
              t6 = t2.key;
              graph.addCanonical$4$recanonicalize(new F.FilesystemImporter(t5), t4.toUri$1(J.$eq$(J.get$platform$x(self.process), "win32") || J.$eq$(J.get$platform$x(self.process), "darwin") ? F._realCasePath(t4.absolute$7(t4.normalize$1(t6), null, null, null, null, null, null)) : t4.canonicalize$1(t6)), t4.toUri$1(t6), false);
              $async$goto = 6;
              return P._asyncAwait(watcher.compile$3$ifModified(t6, t2.value, true), $async$watch);
            case 6:
              // returning from await.
              if (!$async$result && H._asBool(t3.$index(0, "stop-on-error"))) {
                t1 = dirWatcher._group.__StreamGroup__controller;
                if (t1 == null)
                  t1 = H.throwExpression(H.LateError$fieldNI("_controller"));
                t1._subscribe$4(null, null, null, false).cancel$0();
                // goto return
                $async$goto = 1;
                break;
              }
              // goto for condition
              $async$goto = 4;
              break;
            case 5:
              // after for
              P.print("Sass is watching for changes. Press Ctrl-C to stop.\n");
              $async$goto = 7;
              return P._asyncAwait(watcher.watch$1(0, dirWatcher), $async$watch);
            case 7:
              // returning from await.
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$watch, $async$completer);
    },
    watch_closure: function watch_closure(t0) {
      this.dirWatcher = t0;
    },
    _Watcher: function _Watcher(t0, t1) {
      this._watch$_options = t0;
      this._graph = t1;
    },
    _Watcher__debounceEvents_closure: function _Watcher__debounceEvents_closure() {
    },
    MergedExtension_merge(left, right) {
      var t4, t5, t6,
        t1 = left.extender,
        t2 = t1.selector,
        t3 = C.C_ListEquality.equals$2(0, t2.components, right.extender.selector.components);
      if (!t3 || !left.target.$eq(0, right.target))
        throw H.wrapException(P.ArgumentError$(left.toString$0(0) + " and " + right.toString$0(0) + " aren't the same extension.", null));
      t3 = left.mediaContext;
      t4 = t3 == null;
      if (!t4) {
        t5 = right.mediaContext;
        t5 = t5 != null && !C.C_ListEquality.equals$2(0, t3, t5);
      } else
        t5 = false;
      if (t5)
        throw H.wrapException(E.SassException$("From " + left.span.message$1(0, "") + string$.x0aYou_m, right.span));
      if (right.isOptional && right.mediaContext == null)
        return left;
      if (left.isOptional && t4)
        return right;
      t5 = left.target;
      t6 = left.span;
      if (t4)
        t3 = right.mediaContext;
      t2.get$maxSpecificity();
      t1 = new S.Extender(t2, false, t1.span);
      return t1._extension = new A.MergedExtension(left, right, t1, t5, t3, true, t6);
    },
    MergedExtension: function MergedExtension(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.left = t0;
      _.right = t1;
      _.extender = t2;
      _.target = t3;
      _.mediaContext = t4;
      _.isOptional = t5;
      _.span = t6;
    },
    _modify(map, keys, modify, addNesting) {
      var keyIterator = J.get$iterator$ax(keys);
      return keyIterator.moveNext$0() ? new A._modify__modifyNestedMap(keyIterator, modify, addNesting).call$1(map) : modify.call$1(map);
    },
    _deepMergeImpl(map1, map2) {
      var t1 = {},
        t2 = map2.contents;
      if (t2.get$isEmpty(t2))
        return map1;
      t1.mutable = false;
      t1.result = t2;
      map1.contents.forEach$1(0, new A._deepMergeImpl_closure(t1, new A._deepMergeImpl__ensureMutable(t1)));
      if (t1.mutable) {
        t2 = type$.Value;
        t2 = new A.SassMap(H.ConstantMap_ConstantMap$from(t1.result, t2, t2));
        t1 = t2;
      } else
        t1 = map2;
      return t1;
    },
    _function2($name, $arguments, callback) {
      return Q.BuiltInCallable$function($name, $arguments, callback, "sass:map");
    },
    _get_closure: function _get_closure() {
    },
    _set_closure: function _set_closure() {
    },
    _set__closure0: function _set__closure0(t0) {
      this.$arguments = t0;
    },
    _set_closure0: function _set_closure0() {
    },
    _set__closure: function _set__closure(t0) {
      this.args = t0;
    },
    _merge_closure: function _merge_closure() {
    },
    _merge_closure0: function _merge_closure0() {
    },
    _merge__closure: function _merge__closure(t0) {
      this.map2 = t0;
    },
    _deepMerge_closure: function _deepMerge_closure() {
    },
    _deepRemove_closure: function _deepRemove_closure() {
    },
    _deepRemove__closure: function _deepRemove__closure(t0) {
      this.keys = t0;
    },
    _remove_closure: function _remove_closure() {
    },
    _remove_closure0: function _remove_closure0() {
    },
    _keys_closure: function _keys_closure() {
    },
    _values_closure: function _values_closure() {
    },
    _hasKey_closure: function _hasKey_closure() {
    },
    _modify__modifyNestedMap: function _modify__modifyNestedMap(t0, t1, t2) {
      this.keyIterator = t0;
      this.modify = t1;
      this.addNesting = t2;
    },
    _deepMergeImpl__ensureMutable: function _deepMergeImpl__ensureMutable(t0) {
      this._box_0 = t0;
    },
    _deepMergeImpl_closure: function _deepMergeImpl_closure(t0, t1) {
      this._box_0 = t0;
      this._ensureMutable = t1;
    },
    SassMap: function SassMap(t0) {
      this.contents = t0;
    },
    SassMap_asList_closure: function SassMap_asList_closure(t0) {
      this.result = t0;
    },
    _IterableExtension__search(_this, callback) {
      var t1, value;
      for (t1 = J.get$iterator$ax(_this); t1.moveNext$0();) {
        value = callback.call$1(t1.get$current(t1));
        if (value != null)
          return value;
      }
    },
    StatementSearchVisitor: function StatementSearchVisitor() {
    },
    StatementSearchVisitor_visitIfRule_closure: function StatementSearchVisitor_visitIfRule_closure(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitIfRule__closure0: function StatementSearchVisitor_visitIfRule__closure0(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitIfRule_closure0: function StatementSearchVisitor_visitIfRule_closure0(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitIfRule__closure: function StatementSearchVisitor_visitIfRule__closure(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitChildren_closure: function StatementSearchVisitor_visitChildren_closure(t0) {
      this.$this = t0;
    },
    Frame_Frame$parseVM(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseVM_closure(frame));
    },
    Frame_Frame$parseV8(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseV8_closure(frame));
    },
    Frame_Frame$_parseFirefoxEval(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$_parseFirefoxEval_closure(frame));
    },
    Frame_Frame$parseFirefox(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseFirefox_closure(frame));
    },
    Frame_Frame$parseFriendly(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseFriendly_closure(frame));
    },
    Frame__uriOrPathToUri(uriOrPath) {
      if (C.JSString_methods.contains$1(uriOrPath, $.$get$Frame__uriRegExp()))
        return P.Uri_parse(uriOrPath);
      else if (C.JSString_methods.contains$1(uriOrPath, $.$get$Frame__windowsRegExp()))
        return P._Uri__Uri$file(uriOrPath, true);
      else if (C.JSString_methods.startsWith$1(uriOrPath, "/"))
        return P._Uri__Uri$file(uriOrPath, false);
      if (C.JSString_methods.contains$1(uriOrPath, "\\"))
        return $.$get$windows().toUri$1(uriOrPath);
      return P.Uri_parse(uriOrPath);
    },
    Frame__catchFormatException(text, body) {
      var t1, exception;
      try {
        t1 = body.call$0();
        return t1;
      } catch (exception) {
        if (type$.FormatException._is(H.unwrapException(exception)))
          return new N.UnparsedFrame(P._Uri__Uri(null, "unparsed", null, null), text);
        else
          throw exception;
      }
    },
    Frame: function Frame(t0, t1, t2, t3) {
      var _ = this;
      _.uri = t0;
      _.line = t1;
      _.column = t2;
      _.member = t3;
    },
    Frame_Frame$parseVM_closure: function Frame_Frame$parseVM_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseV8_closure: function Frame_Frame$parseV8_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseV8_closure_parseLocation: function Frame_Frame$parseV8_closure_parseLocation(t0) {
      this.frame = t0;
    },
    Frame_Frame$_parseFirefoxEval_closure: function Frame_Frame$_parseFirefoxEval_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseFirefox_closure: function Frame_Frame$parseFirefox_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseFriendly_closure: function Frame_Frame$parseFriendly_closure(t0) {
      this.frame = t0;
    },
    AsciiGlyphSet: function AsciiGlyphSet() {
    },
    Configuration0: function Configuration0(t0) {
      this._configuration$_values = t0;
    },
    Configuration_toString_closure0: function Configuration_toString_closure0() {
    },
    ExplicitConfiguration0: function ExplicitConfiguration0(t0, t1) {
      this.nodeWithSpan = t0;
      this._configuration$_values = t1;
    },
    IncludeRule0: function IncludeRule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.$arguments = t2;
      _.content = t3;
      _.span = t4;
    },
    MapExpression0: function MapExpression0(t0, t1) {
      this.pairs = t0;
      this.span = t1;
    },
    MapExpression_toString_closure0: function MapExpression_toString_closure0() {
    },
    _modify0(map, keys, modify, addNesting) {
      var keyIterator = J.get$iterator$ax(keys);
      return keyIterator.moveNext$0() ? new A._modify__modifyNestedMap0(keyIterator, modify, addNesting).call$1(map) : modify.call$1(map);
    },
    _deepMergeImpl0(map1, map2) {
      var t1 = {},
        t2 = map2.contents;
      if (t2.get$isEmpty(t2))
        return map1;
      t1.mutable = false;
      t1.result = t2;
      map1.contents.forEach$1(0, new A._deepMergeImpl_closure0(t1, new A._deepMergeImpl__ensureMutable0(t1)));
      if (t1.mutable) {
        t2 = type$.Value_2;
        t2 = new A.SassMap0(H.ConstantMap_ConstantMap$from(t1.result, t2, t2));
        t1 = t2;
      } else
        t1 = map2;
      return t1;
    },
    _function9($name, $arguments, callback) {
      return Q.BuiltInCallable$function0($name, $arguments, callback, "sass:map");
    },
    _get_closure0: function _get_closure0() {
    },
    _set_closure1: function _set_closure1() {
    },
    _set__closure2: function _set__closure2(t0) {
      this.$arguments = t0;
    },
    _set_closure2: function _set_closure2() {
    },
    _set__closure1: function _set__closure1(t0) {
      this.args = t0;
    },
    _merge_closure1: function _merge_closure1() {
    },
    _merge_closure2: function _merge_closure2() {
    },
    _merge__closure0: function _merge__closure0(t0) {
      this.map2 = t0;
    },
    _deepMerge_closure0: function _deepMerge_closure0() {
    },
    _deepRemove_closure0: function _deepRemove_closure0() {
    },
    _deepRemove__closure0: function _deepRemove__closure0(t0) {
      this.keys = t0;
    },
    _remove_closure1: function _remove_closure1() {
    },
    _remove_closure2: function _remove_closure2() {
    },
    _keys_closure0: function _keys_closure0() {
    },
    _values_closure0: function _values_closure0() {
    },
    _hasKey_closure0: function _hasKey_closure0() {
    },
    _modify__modifyNestedMap0: function _modify__modifyNestedMap0(t0, t1, t2) {
      this.keyIterator = t0;
      this.modify = t1;
      this.addNesting = t2;
    },
    _deepMergeImpl__ensureMutable0: function _deepMergeImpl__ensureMutable0(t0) {
      this._box_0 = t0;
    },
    _deepMergeImpl_closure0: function _deepMergeImpl_closure0(t0, t1) {
      this._box_0 = t0;
      this._ensureMutable = t1;
    },
    _NodeSassMap: function _NodeSassMap() {
    },
    mapConstructor_closure: function mapConstructor_closure() {
    },
    mapConstructor__closure: function mapConstructor__closure() {
    },
    mapConstructor__closure0: function mapConstructor__closure0() {
    },
    mapConstructor_closure0: function mapConstructor_closure0() {
    },
    mapConstructor_closure1: function mapConstructor_closure1() {
    },
    mapConstructor_closure2: function mapConstructor_closure2() {
    },
    mapConstructor_closure3: function mapConstructor_closure3() {
    },
    mapConstructor_closure4: function mapConstructor_closure4() {
    },
    mapConstructor_closure5: function mapConstructor_closure5() {
    },
    SassMap0: function SassMap0(t0) {
      this.contents = t0;
    },
    SassMap_asList_closure0: function SassMap_asList_closure0(t0) {
      this.result = t0;
    },
    MergedExtension_merge0(left, right) {
      var t4, t5, t6,
        t1 = left.extender,
        t2 = t1.selector,
        t3 = C.C_ListEquality.equals$2(0, t2.components, right.extender.selector.components);
      if (!t3 || !left.target.$eq(0, right.target))
        throw H.wrapException(P.ArgumentError$(left.toString$0(0) + " and " + right.toString$0(0) + " aren't the same extension.", null));
      t3 = left.mediaContext;
      t4 = t3 == null;
      if (!t4) {
        t5 = right.mediaContext;
        t5 = t5 != null && !C.C_ListEquality.equals$2(0, t3, t5);
      } else
        t5 = false;
      if (t5)
        throw H.wrapException(E.SassException$0("From " + left.span.message$1(0, "") + string$.x0aYou_m, right.span));
      if (right.isOptional && right.mediaContext == null)
        return left;
      if (left.isOptional && t4)
        return right;
      t5 = left.target;
      t6 = left.span;
      if (t4)
        t3 = right.mediaContext;
      t2.get$maxSpecificity();
      t1 = new S.Extender0(t2, false, t1.span);
      return t1._extension$_extension = new A.MergedExtension0(left, right, t1, t5, t3, true, t6);
    },
    MergedExtension0: function MergedExtension0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.left = t0;
      _.right = t1;
      _.extender = t2;
      _.target = t3;
      _.mediaContext = t4;
      _.isOptional = t5;
      _.span = t6;
    },
    _IterableExtension__search0(_this, callback) {
      var t1, value;
      for (t1 = J.get$iterator$ax(_this); t1.moveNext$0();) {
        value = callback.call$1(t1.get$current(t1));
        if (value != null)
          return value;
      }
    },
    StatementSearchVisitor0: function StatementSearchVisitor0() {
    },
    StatementSearchVisitor_visitIfRule_closure1: function StatementSearchVisitor_visitIfRule_closure1(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitIfRule__closure2: function StatementSearchVisitor_visitIfRule__closure2(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitIfRule_closure2: function StatementSearchVisitor_visitIfRule_closure2(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitIfRule__closure1: function StatementSearchVisitor_visitIfRule__closure1(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitChildren_closure0: function StatementSearchVisitor_visitChildren_closure0(t0) {
      this.$this = t0;
    },
    IterableNullableExtension_whereNotNull(_this, $T) {
      return A.IterableNullableExtension_whereNotNull$body(_this, $T, $T);
    },
    IterableNullableExtension_whereNotNull$body($async$_this, $async$$T, $async$type) {
      return P._makeSyncStarIterable(function() {
        var _this = $async$_this,
          $T = $async$$T;
        var $async$goto = 0, $async$handler = 1, $async$currentError, t1, element;
        return function $async$IterableNullableExtension_whereNotNull($async$errorCode, $async$result) {
          if ($async$errorCode === 1) {
            $async$currentError = $async$result;
            $async$goto = $async$handler;
          }
          while (true)
            switch ($async$goto) {
              case 0:
                // Function start
                t1 = _this.get$iterator(_this);
              case 2:
                // for condition
                if (!t1.moveNext$0()) {
                  // goto after for
                  $async$goto = 3;
                  break;
                }
                element = t1.get$current(t1);
                $async$goto = element != null ? 4 : 5;
                break;
              case 4:
                // then
                $async$goto = 6;
                return element;
              case 6:
                // after yield
              case 5:
                // join
                // goto for condition
                $async$goto = 2;
                break;
              case 3:
                // after for
                // implicit return
                return P._IterationMarker_endOfIteration();
              case 1:
                // rethrow
                return P._IterationMarker_uncaughtError($async$currentError);
            }
        };
      }, $async$type);
    },
    IterableIntegerExtension_get_sum(_this) {
      var t1, t2, result;
      for (t1 = new H.MappedIterator(J.get$iterator$ax(_this.__internal$_iterable), _this._f), t2 = H._instanceType(t1)._rest[1], result = 0; t1.moveNext$0();)
        result += t2._as(t1.__internal$_current);
      return result;
    },
    _combine(hash, value) {
      hash = hash + value & 536870911;
      hash = hash + ((hash & 524287) << 10) & 536870911;
      return hash ^ hash >>> 6;
    },
    _finish(hash) {
      hash = hash + ((hash & 67108863) << 3) & 536870911;
      hash ^= hash >>> 11;
      return hash + ((hash & 16383) << 15) & 536870911;
    }
  },
  B = {ReplAdapter: function ReplAdapter(t0) {
      this.repl = t0;
      this.rl = null;
    }, ReplAdapter_runAsync_closure: function ReplAdapter_runAsync_closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.rl = t2;
      _.runController = t3;
    }, ReplAdapter_runAsync__closure: function ReplAdapter_runAsync__closure(t0) {
      this.lineController = t0;
    }, Stdin: function Stdin() {
    }, Stdout: function Stdout() {
    }, ReadlineModule: function ReadlineModule() {
    }, ReadlineOptions: function ReadlineOptions() {
    }, ReadlineInterface: function ReadlineInterface() {
    }, InternalStyle: function InternalStyle() {
    }, ModifiableCssNode: function ModifiableCssNode() {
    }, ModifiableCssParentNode: function ModifiableCssParentNode() {
    },
    ModifiableCssSupportsRule$(condition, span) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new B.ModifiableCssSupportsRule(condition, span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssSupportsRule: function ModifiableCssSupportsRule(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _._children = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    CssNode: function CssNode() {
    },
    CssParentNode: function CssParentNode() {
    },
    AstNode: function AstNode() {
    },
    _FakeAstNode: function _FakeAstNode(t0) {
      this._callback = t0;
    },
    ArgumentDeclaration_ArgumentDeclaration$parse(contents, url) {
      return L.ScssParser$(contents, null, url).parseArgumentDeclaration$0();
    },
    ArgumentDeclaration: function ArgumentDeclaration(t0, t1, t2) {
      this.$arguments = t0;
      this.restArgument = t1;
      this.span = t2;
    },
    ArgumentDeclaration_verify_closure: function ArgumentDeclaration_verify_closure() {
    },
    ArgumentDeclaration_verify_closure0: function ArgumentDeclaration_verify_closure0() {
    },
    DynamicImport: function DynamicImport(t0, t1) {
      this.urlString = t0;
      this.span = t1;
    },
    ForRule$(variable, from, to, children, span, exclusive) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new B.ForRule(variable, from, to, exclusive, span, t1, t2);
    },
    ForRule: function ForRule(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.variable = t0;
      _.from = t1;
      _.to = t2;
      _.isExclusive = t3;
      _.span = t4;
      _.children = t5;
      _.hasDeclarations = t6;
    },
    ImportRule: function ImportRule(t0, t1) {
      this.imports = t0;
      this.span = t1;
    },
    ReturnRule: function ReturnRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    SilentComment: function SilentComment(t0, t1) {
      this.text = t0;
      this.span = t1;
    },
    SupportsRule$(condition, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new B.SupportsRule(condition, span, t1, t2);
    },
    SupportsRule: function SupportsRule(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    ExecutableOptions__separator(text) {
      var t1 = $.$get$ExecutableOptions__separatorBar(),
        t2 = C.JSString_methods.$mul(t1, 3) + " ";
      t2 = t2 + (J.$eq$(self.process.stdout.isTTY, true) ? "\x1b[1m" : "") + text;
      return t2 + (J.$eq$(self.process.stdout.isTTY, true) ? "\x1b[0m" : "") + " " + C.JSString_methods.$mul(t1, 35 - text.length);
    },
    ExecutableOptions__fail(message) {
      return H.throwExpression(B.UsageException$(message));
    },
    ExecutableOptions_ExecutableOptions$parse(args) {
      var options, error, t1, exception;
      try {
        t1 = G.Parser$(null, $.$get$ExecutableOptions__parser(), P.ListQueue_ListQueue$of(args, type$.String), null, null).parse$0();
        if (t1.wasParsed$1("poll") && !H._asBool(t1.$index(0, "watch")))
          B.ExecutableOptions__fail("--poll may not be passed without --watch.");
        options = new B.ExecutableOptions(t1);
        if (H._asBool(options._options.$index(0, "help")))
          B.ExecutableOptions__fail("Compile Sass to CSS.");
        return options;
      } catch (exception) {
        t1 = H.unwrapException(exception);
        if (type$.FormatException._is(t1)) {
          error = t1;
          B.ExecutableOptions__fail(J.get$message$x(error));
        } else
          throw exception;
      }
    },
    UsageException$(message) {
      return new B.UsageException(message);
    },
    ExecutableOptions: function ExecutableOptions(t0) {
      var _ = this;
      _._options = t0;
      _.__ExecutableOptions__sourceDirectoriesToDestinations = _._sourcesToDestinations = _.__ExecutableOptions_interactive = null;
    },
    ExecutableOptions__parser_closure: function ExecutableOptions__parser_closure() {
    },
    ExecutableOptions_interactive_closure: function ExecutableOptions_interactive_closure(t0) {
      this.$this = t0;
    },
    ExecutableOptions_emitErrorCss_closure: function ExecutableOptions_emitErrorCss_closure() {
    },
    UsageException: function UsageException(t0) {
      this.message = t0;
    },
    AsyncImporter: function AsyncImporter() {
    },
    fromImport() {
      var t1 = H._asBoolQ($.Zone__current.$index(0, C.Symbol__inImportRule));
      return t1 === true;
    },
    resolveImportPath(path) {
      var t1,
        extension = X.ParsedPath_ParsedPath$parse(path, $.$get$context().style)._splitExtension$1(1)[1];
      if (extension === ".sass" || extension === ".scss" || extension === ".css") {
        t1 = B.fromImport() ? new B.resolveImportPath_closure(path, extension).call$0() : null;
        return t1 == null ? B._exactlyOne(B._tryPath(path)) : t1;
      }
      t1 = B.fromImport() ? new B.resolveImportPath_closure0(path).call$0() : null;
      if (t1 == null)
        t1 = B._exactlyOne(B._tryPathWithExtensions(path));
      return t1 == null ? B._tryPathAsDirectory(path) : t1;
    },
    _tryPathWithExtensions(path) {
      var result = B._tryPath(path + ".sass");
      C.JSArray_methods.addAll$1(result, B._tryPath(path + ".scss"));
      return result.length !== 0 ? result : B._tryPath(path + ".css");
    },
    _tryPath(path) {
      var t1 = $.$get$context(),
        partial = D.join(t1.dirname$1(path), "_" + X.ParsedPath_ParsedPath$parse(path, t1.style).get$basename(), null);
      t1 = H._setArrayType([], type$.JSArray_String);
      if (B.fileExists(partial))
        t1.push(partial);
      if (B.fileExists(path))
        t1.push(path);
      return t1;
    },
    _tryPathAsDirectory(path) {
      var t1;
      if (!B.dirExists(path))
        return null;
      t1 = B.fromImport() ? new B._tryPathAsDirectory_closure(path).call$0() : null;
      return t1 == null ? B._exactlyOne(B._tryPathWithExtensions(D.join(path, "index", null))) : t1;
    },
    _exactlyOne(paths) {
      var t1 = paths.length;
      if (t1 === 0)
        return null;
      if (t1 === 1)
        return C.JSArray_methods.get$first(paths);
      throw H.wrapException(string$.It_s_n + C.JSArray_methods.map$1$1(paths, new B._exactlyOne_closure(), type$.String).join$1(0, "\n"));
    },
    resolveImportPath_closure: function resolveImportPath_closure(t0, t1) {
      this.path = t0;
      this.extension = t1;
    },
    resolveImportPath_closure0: function resolveImportPath_closure0(t0) {
      this.path = t0;
    },
    _tryPathAsDirectory_closure: function _tryPathAsDirectory_closure(t0) {
      this.path = t0;
    },
    _exactlyOne_closure: function _exactlyOne_closure() {
    },
    readFile(path) {
      var sourceFile, t1, i,
        contents = H._asString(B._readFile(path, "utf8"));
      if (!C.JSString_methods.contains$1(contents, "\ufffd"))
        return contents;
      sourceFile = Y.SourceFile$fromString(contents, $.$get$context().toUri$1(path));
      for (t1 = contents.length, i = 0; i < t1; ++i) {
        if (C.JSString_methods._codeUnitAt$1(contents, i) !== 65533)
          continue;
        throw H.wrapException(E.SassException$("Invalid UTF-8.", Y.FileLocation$_(sourceFile, i).pointSpan$0()));
      }
      return contents;
    },
    _readFile(path, encoding) {
      return B._systemErrorToFileSystemException(new B._readFile_closure(path, encoding));
    },
    writeFile(path, contents) {
      return B._systemErrorToFileSystemException(new B.writeFile_closure(path, contents));
    },
    deleteFile(path) {
      return B._systemErrorToFileSystemException(new B.deleteFile_closure(path));
    },
    readStdin() {
      return B.readStdin$body();
    },
    readStdin$body() {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.String),
        $async$returnValue, sink, t1, t2, completer;
      var $async$readStdin = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = {};
              t2 = new P._Future($.Zone__current, type$._Future_String);
              completer = new P._AsyncCompleter(t2, type$._AsyncCompleter_String);
              t1.contents = null;
              sink = new P._StringCallbackSink(new B.readStdin_closure(t1, completer), new P.StringBuffer("")).asUtf8Sink$1(false);
              J.on$2$x(J.get$stdin$x(self.process), "data", P.allowInterop(new B.readStdin_closure0(sink)));
              J.on$2$x(J.get$stdin$x(self.process), "end", P.allowInterop(new B.readStdin_closure1(sink)));
              J.on$2$x(J.get$stdin$x(self.process), "error", P.allowInterop(new B.readStdin_closure2(completer)));
              $async$returnValue = t2;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$readStdin, $async$completer);
    },
    fileExists(path) {
      return B._systemErrorToFileSystemException(new B.fileExists_closure(path));
    },
    dirExists(path) {
      return B._systemErrorToFileSystemException(new B.dirExists_closure(path));
    },
    ensureDir(path) {
      return B._systemErrorToFileSystemException(new B.ensureDir_closure(path));
    },
    listDir(path, recursive) {
      return B._systemErrorToFileSystemException(new B.listDir_closure(recursive, path));
    },
    modificationTime(path) {
      return B._systemErrorToFileSystemException(new B.modificationTime_closure(path));
    },
    _systemErrorToFileSystemException(callback) {
      var error, systemError, t1, exception, t2;
      try {
        t1 = callback.call$0();
        return t1;
      } catch (exception) {
        error = H.unwrapException(exception);
        systemError = type$.JsSystemError._as(error);
        t1 = systemError;
        t2 = J.getInterceptor$x(t1);
        throw H.wrapException(new B.FileSystemException(J.substring$2$s(t2.get$message(t1), (H.S(t2.get$code(t1)) + ": ").length, J.get$length$asx(t2.get$message(t1)) - (", " + H.S(t2.get$syscall(t1)) + " '" + H.S(t2.get$path(t1)) + "'").length), J.get$path$x(systemError)));
      }
    },
    isWindows() {
      return J.$eq$(J.get$platform$x(self.process), "win32");
    },
    watchDir(path, poll) {
      var t2, t3, t1 = {},
        watcher = J.watch$2$x(self.chokidar, path, {disableGlobbing: true, usePolling: poll});
      t1.controller = null;
      t2 = J.getInterceptor$x(watcher);
      t2.on$2(watcher, "add", P.allowInterop(new B.watchDir_closure(t1)));
      t2.on$2(watcher, "change", P.allowInterop(new B.watchDir_closure0(t1)));
      t2.on$2(watcher, "unlink", P.allowInterop(new B.watchDir_closure1(t1)));
      t2.on$2(watcher, "error", P.allowInterop(new B.watchDir_closure2(t1)));
      t3 = new P._Future($.Zone__current, type$._Future_Stream_WatchEvent);
      t2.on$2(watcher, "ready", P.allowInterop(new B.watchDir_closure3(t1, watcher, new P._AsyncCompleter(t3, type$._AsyncCompleter_Stream_WatchEvent))));
      return t3;
    },
    FileSystemException: function FileSystemException(t0, t1) {
      this.message = t0;
      this.path = t1;
    },
    Stderr: function Stderr(t0) {
      this._stderr = t0;
    },
    _readFile_closure: function _readFile_closure(t0, t1) {
      this.path = t0;
      this.encoding = t1;
    },
    writeFile_closure: function writeFile_closure(t0, t1) {
      this.path = t0;
      this.contents = t1;
    },
    deleteFile_closure: function deleteFile_closure(t0) {
      this.path = t0;
    },
    readStdin_closure: function readStdin_closure(t0, t1) {
      this._box_0 = t0;
      this.completer = t1;
    },
    readStdin_closure0: function readStdin_closure0(t0) {
      this.sink = t0;
    },
    readStdin_closure1: function readStdin_closure1(t0) {
      this.sink = t0;
    },
    readStdin_closure2: function readStdin_closure2(t0) {
      this.completer = t0;
    },
    fileExists_closure: function fileExists_closure(t0) {
      this.path = t0;
    },
    dirExists_closure: function dirExists_closure(t0) {
      this.path = t0;
    },
    ensureDir_closure: function ensureDir_closure(t0) {
      this.path = t0;
    },
    listDir_closure: function listDir_closure(t0, t1) {
      this.recursive = t0;
      this.path = t1;
    },
    listDir__closure: function listDir__closure(t0) {
      this.path = t0;
    },
    listDir__closure0: function listDir__closure0() {
    },
    listDir_closure_list: function listDir_closure_list() {
    },
    listDir__list_closure: function listDir__list_closure(t0, t1) {
      this.parent = t0;
      this.list = t1;
    },
    modificationTime_closure: function modificationTime_closure(t0) {
      this.path = t0;
    },
    watchDir_closure: function watchDir_closure(t0) {
      this._box_0 = t0;
    },
    watchDir_closure0: function watchDir_closure0(t0) {
      this._box_0 = t0;
    },
    watchDir_closure1: function watchDir_closure1(t0) {
      this._box_0 = t0;
    },
    watchDir_closure2: function watchDir_closure2(t0) {
      this._box_0 = t0;
    },
    watchDir_closure3: function watchDir_closure3(t0, t1, t2) {
      this._box_0 = t0;
      this.watcher = t1;
      this.completer = t2;
    },
    watchDir__closure: function watchDir__closure(t0) {
      this.watcher = t0;
    },
    ShadowedModuleView_ifNecessary(inner, functions, mixins, variables, $T) {
      return B.ShadowedModuleView__needsBlocklist(inner.get$variables(), variables) || B.ShadowedModuleView__needsBlocklist(inner.get$functions(inner), functions) || B.ShadowedModuleView__needsBlocklist(inner.get$mixins(), mixins) ? new B.ShadowedModuleView(inner, B.ShadowedModuleView__shadowedMap(inner.get$variables(), variables, type$.Value), B.ShadowedModuleView__shadowedMap(inner.get$variableNodes(), variables, type$.AstNode), B.ShadowedModuleView__shadowedMap(inner.get$functions(inner), functions, $T), B.ShadowedModuleView__shadowedMap(inner.get$mixins(), mixins, $T), $T._eval$1("ShadowedModuleView<0>")) : null;
    },
    ShadowedModuleView__shadowedMap(map, blocklist, $V) {
      var t1 = B.ShadowedModuleView__needsBlocklist(map, blocklist);
      return !t1 ? map : K.LimitedMapView$blocklist(map, blocklist, type$.String, $V);
    },
    ShadowedModuleView__needsBlocklist(map, blocklist) {
      var t1 = map.get$isNotEmpty(map) && blocklist.any$1(0, map.get$containsKey());
      return t1;
    },
    ShadowedModuleView: function ShadowedModuleView(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._shadowed_view$_inner = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.$ti = t5;
    },
    _PropertyDescriptor: function _PropertyDescriptor() {
    },
    toSentence(iter, conjunction) {
      var t1 = iter.__internal$_iterable,
        t2 = J.getInterceptor$asx(t1);
      if (t2.get$length(t1) === 1)
        return J.toString$0$(iter._f.call$1(t2.get$first(t1)));
      return H.TakeIterable_TakeIterable(iter, t2.get$length(t1) - 1, H._instanceType(iter)._eval$1("Iterable.E")).join$1(0, ", ") + (" " + conjunction + " " + H.S(iter._f.call$1(t2.get$last(t1))));
    },
    indent(string, indentation) {
      return new H.MappedListIterable(H._setArrayType(string.split("\n"), type$.JSArray_String), new B.indent_closure(indentation), type$.MappedListIterable_String_String).join$1(0, "\n");
    },
    pluralize($name, number, plural) {
      if (number === 1)
        return $name;
      if (plural != null)
        return plural;
      return $name + "s";
    },
    trimAscii(string, excludeEscape) {
      var t1,
        start = B._firstNonWhitespace(string);
      if (start == null)
        t1 = "";
      else {
        t1 = B._lastNonWhitespace(string, true);
        t1.toString;
        t1 = C.JSString_methods.substring$2(string, start, t1 + 1);
      }
      return t1;
    },
    trimAsciiRight(string, excludeEscape) {
      var end = B._lastNonWhitespace(string, excludeEscape);
      return end == null ? "" : C.JSString_methods.substring$2(string, 0, end + 1);
    },
    _firstNonWhitespace(string) {
      var t1, i, t2;
      for (t1 = string.length, i = 0; i < t1; ++i) {
        t2 = C.JSString_methods._codeUnitAt$1(string, i);
        if (!(t2 === 32 || t2 === 9 || t2 === 10 || t2 === 13 || t2 === 12))
          return i;
      }
      return null;
    },
    _lastNonWhitespace(string, excludeEscape) {
      var t1, i, codeUnit;
      for (t1 = string.length, i = t1 - 1; i >= 0; --i) {
        codeUnit = C.JSString_methods.codeUnitAt$1(string, i);
        if (!(codeUnit === 32 || codeUnit === 9 || codeUnit === 10 || codeUnit === 13 || codeUnit === 12))
          if (excludeEscape && i !== 0 && i !== t1 && codeUnit === 92)
            return i + 1;
          else
            return i;
      }
      return null;
    },
    isPublic(member) {
      var start = C.JSString_methods._codeUnitAt$1(member, 0);
      return start !== 45 && start !== 95;
    },
    flattenVertically(iterable, $T) {
      var result,
        t1 = iterable.$ti._eval$1("@<ListIterable.E>")._bind$1($T._eval$1("QueueList<0>"))._eval$1("MappedListIterable<1,2>"),
        queues = P.List_List$of(new H.MappedListIterable(iterable, new B.flattenVertically_closure($T), t1), true, t1._eval$1("ListIterable.E"));
      if (queues.length === 1)
        return C.JSArray_methods.get$first(queues);
      result = H._setArrayType([], $T._eval$1("JSArray<0>"));
      for (; queues.length !== 0;) {
        if (!!queues.fixed$length)
          H.throwExpression(P.UnsupportedError$("removeWhere"));
        C.JSArray_methods._removeWhere$2(queues, new B.flattenVertically_closure0(result, $T), true);
      }
      return result;
    },
    firstOrNull(iterable) {
      var iterator = J.get$iterator$ax(iterable);
      return iterator.moveNext$0() ? iterator.get$current(iterator) : null;
    },
    codepointIndexToCodeUnitIndex(string, codepointIndex) {
      var codeUnitIndex, i, codeUnitIndex0;
      for (codeUnitIndex = 0, i = 0; i < codepointIndex; ++i) {
        codeUnitIndex0 = codeUnitIndex + 1;
        codeUnitIndex = C.JSString_methods._codeUnitAt$1(string, codeUnitIndex) >>> 10 === 54 ? codeUnitIndex0 + 1 : codeUnitIndex0;
      }
      return codeUnitIndex;
    },
    codeUnitIndexToCodepointIndex(string, codeUnitIndex) {
      var codepointIndex, i;
      for (codepointIndex = 0, i = 0; i < codeUnitIndex; i = (C.JSString_methods._codeUnitAt$1(string, i) >>> 10 === 54 ? i + 1 : i) + 1)
        ++codepointIndex;
      return codepointIndex;
    },
    frameForSpan(span, member, url) {
      var t2, t3, t4,
        t1 = url == null ? span.file.url : url;
      if (t1 == null)
        t1 = $.$get$_noSourceUrl();
      t2 = span.file;
      t3 = span._file$_start;
      t4 = Y.FileLocation$_(t2, t3);
      t4 = t4.file.getLine$1(t4.offset);
      t3 = Y.FileLocation$_(t2, t3);
      return new A.Frame(t1, t4 + 1, t3.file.getColumn$1(t3.offset) + 1, member);
    },
    declarationName(span) {
      var text = P.String_String$fromCharCodes(C.NativeUint32List_methods.sublist$2(span.file._decodedChars, span._file$_start, span._end), 0, null);
      return B.trimAsciiRight(C.JSString_methods.substring$2(text, 0, C.JSString_methods.indexOf$1(text, ":")), false);
    },
    unvendor($name) {
      var i,
        t1 = $name.length;
      if (t1 < 2)
        return $name;
      if (C.JSString_methods._codeUnitAt$1($name, 0) !== 45)
        return $name;
      if (C.JSString_methods._codeUnitAt$1($name, 1) === 45)
        return $name;
      for (i = 2; i < t1; ++i)
        if (C.JSString_methods._codeUnitAt$1($name, i) === 45)
          return C.JSString_methods.substring$1($name, i + 1);
      return $name;
    },
    equalsIgnoreCase(string1, string2) {
      var t1, i;
      if (string1 === string2)
        return true;
      if (string1 == null || false)
        return false;
      t1 = string1.length;
      if (t1 !== string2.length)
        return false;
      for (i = 0; i < t1; ++i)
        if (!T.characterEqualsIgnoreCase(C.JSString_methods._codeUnitAt$1(string1, i), C.JSString_methods._codeUnitAt$1(string2, i)))
          return false;
      return true;
    },
    startsWithIgnoreCase(string, prefix) {
      var i,
        t1 = prefix.length;
      if (string.length < t1)
        return false;
      for (i = 0; i < t1; ++i)
        if (!T.characterEqualsIgnoreCase(C.JSString_methods._codeUnitAt$1(string, i), C.JSString_methods._codeUnitAt$1(prefix, i)))
          return false;
      return true;
    },
    mapInPlace(list, $function) {
      var i;
      for (i = 0; i < list.length; ++i)
        list[i] = $function.call$1(list[i]);
    },
    longestCommonSubsequence(list1, list2, select, $T) {
      var t1, _length, lengths, t2, t3, _i, selections, i, i0, j, selection, j0;
      if (select == null)
        select = new B.longestCommonSubsequence_closure($T);
      t1 = J.getInterceptor$asx(list1);
      _length = t1.get$length(list1) + 1;
      lengths = J.JSArray_JSArray$allocateFixed(_length, type$.List_int);
      for (t2 = J.getInterceptor$asx(list2), t3 = type$.int, _i = 0; _i < _length; ++_i)
        lengths[_i] = P.List_List$filled(t2.get$length(list2) + 1, 0, false, t3);
      _length = t1.get$length(list1);
      selections = J.JSArray_JSArray$allocateFixed(_length, $T._eval$1("List<0?>"));
      for (t3 = $T._eval$1("0?"), _i = 0; _i < _length; ++_i)
        selections[_i] = P.List_List$filled(t2.get$length(list2), null, false, t3);
      for (i = 0; i < t1.get$length(list1); i = i0)
        for (i0 = i + 1, j = 0; j < t2.get$length(list2); j = j0) {
          selection = select.call$2(t1.$index(list1, i), t2.$index(list2, j));
          selections[i][j] = selection;
          t3 = lengths[i0];
          j0 = j + 1;
          t3[j0] = selection == null ? Math.max(t3[j], lengths[i][j0]) : lengths[i][j] + 1;
        }
      return new B.longestCommonSubsequence_backtrack(selections, lengths, $T).call$2(t1.get$length(list1) - 1, t2.get$length(list2) - 1);
    },
    removeFirstWhere(list, test, orElse) {
      var i;
      for (i = 0; i < list.length; ++i) {
        if (!test.call$1(list[i]))
          continue;
        C.JSArray_methods.removeAt$1(list, i);
        return;
      }
      orElse.call$0();
    },
    mapAddAll2(destination, source, K1, K2, $V) {
      source.forEach$1(0, new B.mapAddAll2_closure(destination, K1, K2, $V));
    },
    setAll(map, keys, value) {
      var t1;
      for (t1 = J.get$iterator$ax(keys); t1.moveNext$0();)
        map.$indexSet(0, t1.get$current(t1), value);
    },
    rotateSlice(list, start, end) {
      var i, next,
        element = list.$index(0, end - 1);
      for (i = start; i < end; ++i, element = next) {
        next = list.$index(0, i);
        list.$indexSet(0, i, element);
      }
    },
    mapAsync(iterable, callback, $E, $F) {
      return B.mapAsync$body(iterable, callback, $E, $F, $F._eval$1("Iterable<0>"));
    },
    mapAsync$body(iterable, callback, $E, $F, $async$type) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter($async$type),
        $async$returnValue, t2, _i, t1, $async$temp1;
      var $async$mapAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = H._setArrayType([], $F._eval$1("JSArray<0>"));
              t2 = iterable.length, _i = 0;
            case 3:
              // for condition
              if (!(_i < t2)) {
                // goto after for
                $async$goto = 5;
                break;
              }
              $async$temp1 = t1;
              $async$goto = 6;
              return P._asyncAwait(callback.call$1(iterable[_i]), $async$mapAsync);
            case 6:
              // returning from await.
              $async$temp1.push($async$result);
            case 4:
              // for update
              ++_i;
              // goto for condition
              $async$goto = 3;
              break;
            case 5:
              // after for
              $async$returnValue = t1;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$mapAsync, $async$completer);
    },
    putIfAbsentAsync(map, key, ifAbsent, $K, $V) {
      return B.putIfAbsentAsync$body(map, key, ifAbsent, $K, $V, $V);
    },
    putIfAbsentAsync$body(map, key, ifAbsent, $K, $V, $async$type) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter($async$type),
        $async$returnValue, value;
      var $async$putIfAbsentAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              if (map.containsKey$1(key)) {
                $async$returnValue = $V._as(map.$index(0, key));
                // goto return
                $async$goto = 1;
                break;
              }
              $async$goto = 3;
              return P._asyncAwait(ifAbsent.call$0(), $async$putIfAbsentAsync);
            case 3:
              // returning from await.
              value = $async$result;
              map.$indexSet(0, key, value);
              $async$returnValue = value;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$putIfAbsentAsync, $async$completer);
    },
    copyMapOfMap(map, K1, K2, $V) {
      var t2, t3, t4, t5,
        t1 = P.LinkedHashMap_LinkedHashMap$_empty(K1, K2._eval$1("@<0>")._bind$1($V)._eval$1("Map<1,2>"));
      for (t2 = map.get$entries(map), t2 = t2.get$iterator(t2); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t4 = t3.key;
        t3 = t3.value;
        t5 = P.LinkedHashMap_LinkedHashMap(null, null, null, K2, $V);
        t5.addAll$1(0, t3);
        t1.$indexSet(0, t4, t5);
      }
      return t1;
    },
    copyMapOfList(map, $K, $E) {
      var t2, t3,
        t1 = P.LinkedHashMap_LinkedHashMap$_empty($K, $E._eval$1("List<0>"));
      for (t2 = map.get$entries(map), t2 = t2.get$iterator(t2); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t1.$indexSet(0, t3.key, J.toList$0$ax(t3.value));
      }
      return t1;
    },
    consumeEscapedCharacter(scanner) {
      var first, value, i, next, t1;
      scanner.expectChar$1(92);
      first = scanner.peekChar$0();
      if (first == null)
        return 65533;
      else if (first === 10 || first === 13 || first === 12)
        scanner.error$1(0, "Expected escape sequence.");
      else if (T.isHex(first)) {
        for (value = 0, i = 0; i < 6; ++i) {
          next = scanner.peekChar$0();
          if (next == null || !T.isHex(next))
            break;
          value = (value << 4 >>> 0) + T.asHex(scanner.readChar$0());
        }
        t1 = scanner.peekChar$0();
        if (t1 === 32 || t1 === 9 || t1 === 10 || t1 === 13 || t1 === 12)
          scanner.readChar$0();
        if (value !== 0)
          t1 = value >= 55296 && value <= 57343 || value >= 1114111;
        else
          t1 = true;
        if (t1)
          return 65533;
        else
          return value;
      } else
        return scanner.readChar$0();
    },
    indent_closure: function indent_closure(t0) {
      this.indentation = t0;
    },
    flattenVertically_closure: function flattenVertically_closure(t0) {
      this.T = t0;
    },
    flattenVertically_closure0: function flattenVertically_closure0(t0, t1) {
      this.result = t0;
      this.T = t1;
    },
    longestCommonSubsequence_closure: function longestCommonSubsequence_closure(t0) {
      this.T = t0;
    },
    longestCommonSubsequence_backtrack: function longestCommonSubsequence_backtrack(t0, t1, t2) {
      this.selections = t0;
      this.lengths = t1;
      this.T = t2;
    },
    mapAddAll2_closure: function mapAddAll2_closure(t0, t1, t2, t3) {
      var _ = this;
      _.destination = t0;
      _.K1 = t1;
      _.K2 = t2;
      _.V = t3;
    },
    ArgumentDeclaration_ArgumentDeclaration$parse0(contents, url) {
      return L.ScssParser$0(contents, null, url).parseArgumentDeclaration$0();
    },
    ArgumentDeclaration0: function ArgumentDeclaration0(t0, t1, t2) {
      this.$arguments = t0;
      this.restArgument = t1;
      this.span = t2;
    },
    ArgumentDeclaration_verify_closure1: function ArgumentDeclaration_verify_closure1() {
    },
    ArgumentDeclaration_verify_closure2: function ArgumentDeclaration_verify_closure2() {
    },
    AsyncImporter0: function AsyncImporter0() {
    },
    DynamicImport0: function DynamicImport0(t0, t1) {
      this.urlString = t0;
      this.span = t1;
    },
    ForRule$0(variable, from, to, children, span, exclusive) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new B.ForRule0(variable, from, to, exclusive, span, t1, t2);
    },
    ForRule0: function ForRule0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.variable = t0;
      _.from = t1;
      _.to = t2;
      _.isExclusive = t3;
      _.span = t4;
      _.children = t5;
      _.hasDeclarations = t6;
    },
    ImportRule0: function ImportRule0(t0, t1) {
      this.imports = t0;
      this.span = t1;
    },
    AstNode0: function AstNode0() {
    },
    _FakeAstNode0: function _FakeAstNode0(t0) {
      this._node3$_callback = t0;
    },
    CssNode0: function CssNode0() {
    },
    CssParentNode0: function CssParentNode0() {
    },
    readFile0(path) {
      var sourceFile, t1, i,
        contents = H._asString(B._readFile0(path, "utf8"));
      if (!C.JSString_methods.contains$1(contents, "\ufffd"))
        return contents;
      sourceFile = Y.SourceFile$fromString(contents, $.$get$context().toUri$1(path));
      for (t1 = contents.length, i = 0; i < t1; ++i) {
        if (C.JSString_methods._codeUnitAt$1(contents, i) !== 65533)
          continue;
        throw H.wrapException(E.SassException$0("Invalid UTF-8.", Y.FileLocation$_(sourceFile, i).pointSpan$0()));
      }
      return contents;
    },
    _readFile0(path, encoding) {
      return B._systemErrorToFileSystemException0(new B._readFile_closure0(path, encoding));
    },
    fileExists0(path) {
      return B._systemErrorToFileSystemException0(new B.fileExists_closure0(path));
    },
    dirExists0(path) {
      return B._systemErrorToFileSystemException0(new B.dirExists_closure0(path));
    },
    listDir0(path) {
      return B._systemErrorToFileSystemException0(new B.listDir_closure0(false, path));
    },
    _systemErrorToFileSystemException0(callback) {
      var error, systemError, t1, exception, t2;
      try {
        t1 = callback.call$0();
        return t1;
      } catch (exception) {
        error = H.unwrapException(exception);
        systemError = type$.JsSystemError._as(error);
        t1 = systemError;
        t2 = J.getInterceptor$x(t1);
        throw H.wrapException(new B.FileSystemException0(J.substring$2$s(t2.get$message(t1), (H.S(t2.get$code(t1)) + ": ").length, J.get$length$asx(t2.get$message(t1)) - (", " + H.S(t2.get$syscall(t1)) + " '" + H.S(t2.get$path(t1)) + "'").length), J.get$path$x(systemError)));
      }
    },
    FileSystemException0: function FileSystemException0(t0, t1) {
      this.message = t0;
      this.path = t1;
    },
    Stderr0: function Stderr0(t0) {
      this._node1$_stderr = t0;
    },
    _readFile_closure0: function _readFile_closure0(t0, t1) {
      this.path = t0;
      this.encoding = t1;
    },
    fileExists_closure0: function fileExists_closure0(t0) {
      this.path = t0;
    },
    dirExists_closure0: function dirExists_closure0(t0) {
      this.path = t0;
    },
    listDir_closure0: function listDir_closure0(t0, t1) {
      this.recursive = t0;
      this.path = t1;
    },
    listDir__closure1: function listDir__closure1(t0) {
      this.path = t0;
    },
    listDir__closure2: function listDir__closure2() {
    },
    listDir_closure_list0: function listDir_closure_list0() {
    },
    listDir__list_closure0: function listDir__list_closure0(t0, t1) {
      this.parent = t0;
      this.list = t1;
    },
    ModifiableCssNode0: function ModifiableCssNode0() {
    },
    ModifiableCssParentNode0: function ModifiableCssParentNode0() {
    },
    _render(options, callback) {
      var fiber = J.get$fiber$x(options);
      if (fiber != null)
        J.run$0$x(fiber.call$1(P.allowInterop(new B._render_closure(callback, options))));
      else
        B._renderAsync(options).then$1$2$onError(0, new B._render_closure0(callback), new B._render_closure1(callback), type$.Null);
    },
    _renderAsync(options) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.RenderResult),
        $async$returnValue, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, result, start, t1, data, file;
      var $async$_renderAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              start = new P.DateTime(Date.now(), false);
              t1 = J.getInterceptor$x(options);
              data = t1.get$data(options);
              file = X.NullableExtension_andThen0(t1.get$file(options), D.path__absolute$closure());
              $async$goto = data != null ? 3 : 5;
              break;
            case 3:
              // then
              t2 = B._parseImporter(options, start);
              t3 = B._parseFunctions(options, start, true);
              t4 = t1.get$indentedSyntax(options);
              t4 = !J.$eq$(t4, false) && t4 != null ? C.Syntax_Sass0 : null;
              t5 = B._parseOutputStyle(t1.get$outputStyle(options));
              t6 = J.$eq$(t1.get$indentType(options), "tab");
              t7 = B._parseIndentWidth(t1.get$indentWidth(options));
              t8 = B._parseLineFeed(t1.get$linefeed(options));
              t9 = file == null ? "stdin" : $.$get$context().toUri$1(file).toString$0(0);
              t10 = t1.get$quietDeps(options);
              if (t10 == null)
                t10 = false;
              t11 = t1.get$verbose(options);
              if (t11 == null)
                t11 = false;
              t1 = t1.get$charset(options);
              if (t1 == null)
                t1 = true;
              $async$goto = 6;
              return P._asyncAwait(X.compileStringAsync0(data, t1, t3, t7, t8, t2, t10, B._enableSourceMaps(options), t5, t4, t9, !t6, t11), $async$_renderAsync);
            case 6:
              // returning from await.
              result = $async$result;
              // goto join
              $async$goto = 4;
              break;
            case 5:
              // else
              $async$goto = file != null ? 7 : 9;
              break;
            case 7:
              // then
              t2 = B._parseImporter(options, start);
              t3 = B._parseFunctions(options, start, true);
              t4 = t1.get$indentedSyntax(options);
              t4 = !J.$eq$(t4, false) && t4 != null ? C.Syntax_Sass0 : null;
              t5 = B._parseOutputStyle(t1.get$outputStyle(options));
              t6 = J.$eq$(t1.get$indentType(options), "tab");
              t7 = B._parseIndentWidth(t1.get$indentWidth(options));
              t8 = B._parseLineFeed(t1.get$linefeed(options));
              t9 = t1.get$quietDeps(options);
              if (t9 == null)
                t9 = false;
              t10 = t1.get$verbose(options);
              if (t10 == null)
                t10 = false;
              t1 = t1.get$charset(options);
              if (t1 == null)
                t1 = true;
              $async$goto = 10;
              return P._asyncAwait(X.compileAsync0(file, t1, t3, t7, t8, t2, t9, B._enableSourceMaps(options), t5, t4, !t6, t10), $async$_renderAsync);
            case 10:
              // returning from await.
              result = $async$result;
              // goto join
              $async$goto = 8;
              break;
            case 9:
              // else
              throw H.wrapException(P.ArgumentError$(string$.Either, null));
            case 8:
              // join
            case 4:
              // join
              $async$returnValue = B._newRenderResult(options, result, start);
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$_renderAsync, $async$completer);
    },
    _renderSync(options) {
      var start, result, data, file, error, error0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, terseLogger, logger, stylesheet, result0, t13, exception, _null = null;
      try {
        start = new P.DateTime(Date.now(), false);
        result = null;
        t1 = J.getInterceptor$x(options);
        data = t1.get$data(options);
        file = X.NullableExtension_andThen0(t1.get$file(options), D.path__absolute$closure());
        if (data != null) {
          t2 = B._parseImporter(options, start);
          t3 = B._parseFunctions(options, start, false);
          t4 = t1.get$indentedSyntax(options);
          t4 = !J.$eq$(t4, false) && t4 != null ? C.Syntax_Sass0 : _null;
          t5 = B._parseOutputStyle(t1.get$outputStyle(options));
          t6 = J.$eq$(t1.get$indentType(options), "tab");
          t7 = B._parseIndentWidth(t1.get$indentWidth(options));
          t8 = B._parseLineFeed(t1.get$linefeed(options));
          t9 = file == null ? "stdin" : $.$get$context().toUri$1(file).toString$0(0);
          t10 = t1.get$quietDeps(options);
          if (t10 == null)
            t10 = false;
          t11 = t1.get$verbose(options);
          if (t11 == null)
            t11 = false;
          t1 = t1.get$charset(options);
          if (t1 == null)
            t1 = true;
          t12 = B._enableSourceMaps(options);
          if (!t11) {
            terseLogger = new Y.TerseLogger0(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.int), new S.StderrLogger0());
            logger = terseLogger;
          } else {
            terseLogger = _null;
            logger = terseLogger;
          }
          if (t4 == null)
            t4 = C.Syntax_SCSS0;
          stylesheet = V.Stylesheet_Stylesheet$parse0(data, t4, logger, t9);
          t4 = $.$get$context().absolute$7(".", _null, _null, _null, _null, _null, _null);
          result0 = U._compileStylesheet1(stylesheet, logger, _null, t2, new F.FilesystemImporter0(t4), new H.CastList(t3, H._arrayInstanceType(t3)._eval$1("CastList<1,Callable0>")), t5, !t6, t7, t8, t10, t12, t1);
          if (terseLogger != null)
            terseLogger.summarize$1$node(true);
          result = result0;
        } else if (file != null) {
          t2 = file;
          t3 = B._parseImporter(options, start);
          t4 = B._parseFunctions(options, start, false);
          t5 = t1.get$indentedSyntax(options);
          t5 = !J.$eq$(t5, false) && t5 != null ? C.Syntax_Sass0 : _null;
          t6 = B._parseOutputStyle(t1.get$outputStyle(options));
          t7 = J.$eq$(t1.get$indentType(options), "tab");
          t8 = B._parseIndentWidth(t1.get$indentWidth(options));
          t9 = B._parseLineFeed(t1.get$linefeed(options));
          t10 = t1.get$quietDeps(options);
          if (t10 == null)
            t10 = false;
          t11 = t1.get$verbose(options);
          if (t11 == null)
            t11 = false;
          t1 = t1.get$charset(options);
          if (t1 == null)
            t1 = true;
          t12 = B._enableSourceMaps(options);
          if (!t11) {
            terseLogger = new Y.TerseLogger0(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.int), new S.StderrLogger0());
            logger = terseLogger;
          } else {
            terseLogger = _null;
            logger = terseLogger;
          }
          t11 = B.readFile0(t2);
          if (t5 == null)
            t5 = M.Syntax_forPath0(t2);
          t13 = $.$get$context();
          stylesheet = V.Stylesheet_Stylesheet$parse0(t11, t5, logger, t13.toUri$1(t2));
          t2 = t13;
          result0 = U._compileStylesheet1(stylesheet, logger, _null, t3, new F.FilesystemImporter0(t2.absolute$7(".", _null, _null, _null, _null, _null, _null)), new H.CastList(t4, H._arrayInstanceType(t4)._eval$1("CastList<1,Callable0>")), t6, !t7, t8, t9, t10, t12, t1);
          if (terseLogger != null)
            terseLogger.summarize$1$node(true);
          result = result0;
        } else {
          t1 = P.ArgumentError$(string$.Either, _null);
          throw H.wrapException(t1);
        }
        t1 = B._newRenderResult(options, result, start);
        return t1;
      } catch (exception) {
        t1 = H.unwrapException(exception);
        if (t1 instanceof E.SassException0) {
          error = t1;
          t1 = B._wrapException(error);
          $.$get$_jsThrow().call$1(t1);
        } else {
          error0 = t1;
          t1 = B._newRenderError(J.toString$0$(error0), _null, _null, _null, 3);
          $.$get$_jsThrow().call$1(t1);
        }
      }
      throw H.wrapException("unreachable");
    },
    _wrapException(exception) {
      var file, t1, t2, t3,
        url = G.SourceSpanException.prototype.get$span.call(exception).file.url;
      if (url == null)
        file = "stdin";
      else
        file = url.get$scheme() === "file" ? $.$get$context().style.pathFromUri$1(M._parseUri(url)) : url.toString$0(0);
      t1 = C.JSString_methods.replaceFirst$2(exception.toString$0(0), "Error: ", "");
      t2 = G.SourceSpanException.prototype.get$span.call(exception);
      t2 = Y.FileLocation$_(t2.file, t2._file$_start);
      t2 = t2.file.getLine$1(t2.offset);
      t3 = G.SourceSpanException.prototype.get$span.call(exception);
      t3 = Y.FileLocation$_(t3.file, t3._file$_start);
      return B._newRenderError(t1, t3.file.getColumn$1(t3.offset) + 1, file, t2 + 1, 1);
    },
    _parseFunctions(options, start, asynch) {
      var result,
        functions = J.get$functions$x(options);
      if (functions == null)
        return C.List_empty19;
      result = H._setArrayType([], type$.JSArray_AsyncCallable_2);
      B.jsForEach(functions, new B._parseFunctions_closure(options, start, result, asynch));
      return result;
    },
    _parseImporter(options, start) {
      var importers, t2, t3, contextOptions, fiber,
        t1 = J.getInterceptor$x(options);
      if (t1.get$importer(options) == null)
        importers = H._setArrayType([], type$.JSArray_JSFunction);
      else {
        t2 = type$.List_nullable_Object;
        t3 = type$.JSFunction;
        importers = t2._is(t1.get$importer(options)) ? J.cast$1$0$ax(t2._as(t1.get$importer(options)), t3) : H._setArrayType([t3._as(t1.get$importer(options))], type$.JSArray_JSFunction);
      }
      t2 = J.getInterceptor$asx(importers);
      contextOptions = t2.get$isNotEmpty(importers) ? B._contextOptions(options, start) : new P.Object();
      fiber = t1.get$fiber(options);
      if (fiber != null) {
        t2 = t2.map$1$1(importers, new B._parseImporter_closure(fiber), type$.JSFunction);
        importers = P.List_List$of(t2, true, t2.$ti._eval$1("ListIterable.E"));
      }
      t1 = t1.get$includePaths(options);
      if (t1 == null)
        t1 = [];
      t2 = type$.String;
      return new F.NodeImporter(contextOptions, P.List_List$unmodifiable(F.NodeImporter__addSassPath(P.List_List$from(t1, true, t2)), t2), P.List_List$unmodifiable(J.cast$1$0$ax(importers, type$.dynamic), type$.JSFunction));
    },
    _contextOptions(options, start) {
      var includePaths, t3, t4, t5, t6, t7,
        t1 = J.getInterceptor$x(options),
        t2 = t1.get$includePaths(options);
      if (t2 == null)
        t2 = [];
      includePaths = P.List_List$from(t2, true, type$.String);
      t2 = t1.get$file(options);
      t3 = t1.get$data(options);
      t4 = H._setArrayType([D.current()], type$.JSArray_String);
      C.JSArray_methods.addAll$1(t4, includePaths);
      t4 = C.JSArray_methods.join$1(t4, J.$eq$(J.get$platform$x(self.process), "win32") ? ";" : ":");
      t5 = J.$eq$(t1.get$indentType(options), "tab") ? 1 : 0;
      t6 = B._parseIndentWidth(t1.get$indentWidth(options));
      if (t6 == null)
        t6 = 2;
      t7 = B._parseLineFeed(t1.get$linefeed(options));
      t1 = t1.get$file(options);
      if (t1 == null)
        t1 = "data";
      return {file: t2, data: t3, includePaths: t4, precision: 10, style: 1, indentType: t5, indentWidth: t6, linefeed: t7.text, result: {stats: {start: start._core$_value, entry: t1}}};
    },
    _parseOutputStyle(style) {
      if (style == null || style === "expanded")
        return C.OutputStyle_expanded;
      if (style === "compressed")
        return C.OutputStyle_compressed0;
      throw H.wrapException(P.ArgumentError$('Unsupported output style "' + H.S(style) + '".', null));
    },
    _parseIndentWidth(width) {
      if (width == null)
        return null;
      return H._isInt(width) ? width : P.int_parse(J.toString$0$(width), null);
    },
    _parseLineFeed(str) {
      switch (str) {
        case "cr":
          return C.LineFeed_kMT;
        case "crlf":
          return C.LineFeed_Mss;
        case "lfcr":
          return C.LineFeed_a1Y;
        default:
          return C.LineFeed_D6m;
      }
    },
    _newRenderResult(options, result, start) {
      var t3, sourceMapOption, sourceMapPath, t4, sourceMapDir, outFile, t5, file, sourceMapDirUrl, i, source, t6, t7, sourceMapBytes, buffer, indices, url, t8, t9, _null = null,
        t1 = Date.now(),
        t2 = result._compile_result$_serialize,
        css = t2.css;
      if (B._enableSourceMaps(options)) {
        t3 = J.getInterceptor$x(options);
        sourceMapOption = t3.get$sourceMap(options);
        if (typeof sourceMapOption == "string")
          sourceMapPath = sourceMapOption;
        else {
          t4 = t3.get$outFile(options);
          t4.toString;
          sourceMapPath = J.$add$ansx(t4, ".map");
        }
        t4 = $.$get$context();
        sourceMapDir = t4.dirname$1(sourceMapPath);
        t2 = t2.sourceMap;
        t2.toString;
        t2.sourceRoot = t3.get$sourceMapRoot(options);
        outFile = t3.get$outFile(options);
        t5 = outFile == null;
        if (t5) {
          file = t3.get$file(options);
          if (file == null)
            t2.targetUrl = "stdin.css";
          else
            t2.targetUrl = t4.toUri$1(t4.withoutExtension$1(file) + ".css").toString$0(0);
        } else
          t2.targetUrl = t4.toUri$1(t4.relative$2$from(outFile, sourceMapDir)).toString$0(0);
        sourceMapDirUrl = t4.toUri$1(sourceMapDir).toString$0(0);
        for (t4 = t2.urls, i = 0; i < t4.length; ++i) {
          source = t4[i];
          if (source === "stdin")
            continue;
          t6 = $.$get$url();
          t7 = t6.style;
          if (t7.rootLength$1(source) <= 0 || t7.isRootRelative$1(source))
            continue;
          t4[i] = t6.relative$2$from(source, sourceMapDirUrl);
        }
        t4 = t3.get$sourceMapContents(options);
        sourceMapBytes = self.Buffer.from(C.C_JsonCodec.encode$2$toEncodable(t2.toJson$1$includeSourceContents(!J.$eq$(t4, false) && t4 != null), _null), "utf8");
        t2 = t3.get$omitSourceMapUrl(options);
        if (!(!J.$eq$(t2, false) && t2 != null)) {
          t2 = t3.get$sourceMapEmbed(options);
          if (!J.$eq$(t2, false) && t2 != null) {
            buffer = new P.StringBuffer("");
            indices = H._setArrayType([-1], type$.JSArray_int);
            P.UriData__writeUri("application/json", _null, _null, buffer, indices);
            indices.push(buffer._contents.length);
            t2 = buffer._contents += ";base64,";
            indices.push(t2.length - 1);
            t2 = C.C_Base64Encoder.startChunkedConversion$1(new P._StringSinkConversionSink(buffer));
            t3 = sourceMapBytes.length;
            P.RangeError_checkValidRange(0, t3, t3);
            t2._convert$_add$4(sourceMapBytes, 0, t3, true);
            t2 = buffer._contents;
            url = new P.UriData(t2.charCodeAt(0) == 0 ? t2 : t2, indices, _null).get$uri();
          } else {
            if (t5)
              t2 = sourceMapPath;
            else {
              t2 = $.$get$context();
              t2 = t2.relative$2$from(sourceMapPath, t2.dirname$1(outFile));
            }
            url = $.$get$context().toUri$1(t2);
          }
          css += "\n\n/*# sourceMappingURL=" + url.toString$0(0) + " */";
        }
      } else
        sourceMapBytes = _null;
      t2 = self.Buffer.from(css, "utf8");
      t3 = J.get$file$x(options);
      if (t3 == null)
        t3 = "data";
      t4 = start._core$_value;
      t1 = new P.DateTime(t1, false)._core$_value;
      t5 = C.JSInt_methods._tdivFast$1(P.Duration$(t1 - t4)._duration, 1000);
      t6 = H._setArrayType([], type$.JSArray_String);
      for (t7 = result._evaluate.loadedUrls, t7 = P._LinkedHashSetIterator$(t7, t7._collection$_modifications), t8 = H._instanceType(t7)._precomputed1; t7.moveNext$0();) {
        t9 = t8._as(t7._collection$_current);
        if (t9.get$scheme() === "file")
          t6.push($.$get$context().style.pathFromUri$1(M._parseUri(t9)));
        else
          t6.push(t9.toString$0(0));
      }
      return {css: t2, map: sourceMapBytes, stats: {entry: t3, start: t4, end: t1, duration: t5, includedFiles: t6}};
    },
    _enableSourceMaps(options) {
      var t2,
        t1 = J.getInterceptor$x(options);
      if (typeof t1.get$sourceMap(options) != "string") {
        t2 = t1.get$sourceMap(options);
        t1 = !J.$eq$(t2, false) && t2 != null && t1.get$outFile(options) != null;
      } else
        t1 = true;
      return t1;
    },
    _newRenderError(message, column, file, line, $status) {
      var error = new self.Error(message);
      error.formatted = "Error: " + message;
      if (line != null)
        error.line = line;
      if (column != null)
        error.column = column;
      if (file != null)
        error.file = file;
      error.status = $status;
      return error;
    },
    _render_closure: function _render_closure(t0, t1) {
      this.callback = t0;
      this.options = t1;
    },
    _render_closure0: function _render_closure0(t0) {
      this.callback = t0;
    },
    _render_closure1: function _render_closure1(t0) {
      this.callback = t0;
    },
    _parseFunctions_closure: function _parseFunctions_closure(t0, t1, t2, t3) {
      var _ = this;
      _.options = t0;
      _.start = t1;
      _.result = t2;
      _.asynch = t3;
    },
    _parseFunctions__closure: function _parseFunctions__closure(t0, t1, t2) {
      this.fiber = t0;
      this.callback = t1;
      this.context = t2;
    },
    _parseFunctions___closure0: function _parseFunctions___closure0(t0) {
      this.currentFiber = t0;
    },
    _parseFunctions____closure: function _parseFunctions____closure(t0, t1) {
      this.currentFiber = t0;
      this.result = t1;
    },
    _parseFunctions___closure1: function _parseFunctions___closure1(t0) {
      this.fiber = t0;
    },
    _parseFunctions__closure0: function _parseFunctions__closure0(t0, t1) {
      this.callback = t0;
      this.context = t1;
    },
    _parseFunctions__closure1: function _parseFunctions__closure1(t0, t1) {
      this.callback = t0;
      this.context = t1;
    },
    _parseFunctions___closure: function _parseFunctions___closure(t0) {
      this.completer = t0;
    },
    _parseImporter_closure: function _parseImporter_closure(t0) {
      this.fiber = t0;
    },
    _parseImporter__closure: function _parseImporter__closure(t0, t1) {
      this.fiber = t0;
      this.importer = t1;
    },
    _parseImporter___closure: function _parseImporter___closure(t0) {
      this.currentFiber = t0;
    },
    _parseImporter____closure: function _parseImporter____closure(t0, t1) {
      this.currentFiber = t0;
      this.result = t1;
    },
    _parseImporter___closure0: function _parseImporter___closure0(t0) {
      this.fiber = t0;
    },
    ReturnRule0: function ReturnRule0(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    ShadowedModuleView_ifNecessary0(inner, functions, mixins, variables, $T) {
      return B.ShadowedModuleView__needsBlocklist0(inner.get$variables(), variables) || B.ShadowedModuleView__needsBlocklist0(inner.get$functions(inner), functions) || B.ShadowedModuleView__needsBlocklist0(inner.get$mixins(), mixins) ? new B.ShadowedModuleView0(inner, B.ShadowedModuleView__shadowedMap0(inner.get$variables(), variables, type$.Value_2), B.ShadowedModuleView__shadowedMap0(inner.get$variableNodes(), variables, type$.AstNode_2), B.ShadowedModuleView__shadowedMap0(inner.get$functions(inner), functions, $T), B.ShadowedModuleView__shadowedMap0(inner.get$mixins(), mixins, $T), $T._eval$1("ShadowedModuleView0<0>")) : null;
    },
    ShadowedModuleView__shadowedMap0(map, blocklist, $V) {
      var t1 = B.ShadowedModuleView__needsBlocklist0(map, blocklist);
      return !t1 ? map : K.LimitedMapView$blocklist0(map, blocklist, type$.String, $V);
    },
    ShadowedModuleView__needsBlocklist0(map, blocklist) {
      var t1 = map.get$isNotEmpty(map) && blocklist.any$1(0, map.get$containsKey());
      return t1;
    },
    ShadowedModuleView0: function ShadowedModuleView0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._shadowed_view0$_inner = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.$ti = t5;
    },
    SilentComment0: function SilentComment0(t0, t1) {
      this.text = t0;
      this.span = t1;
    },
    ModifiableCssSupportsRule$0(condition, span) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode_2);
      return new B.ModifiableCssSupportsRule0(condition, span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode_2), t1);
    },
    ModifiableCssSupportsRule0: function ModifiableCssSupportsRule0(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _._node2$_children = t3;
      _._node2$_indexInParent = _._node2$_parent = null;
      _.isGroupEnd = false;
    },
    SupportsRule$0(condition, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new B.SupportsRule0(condition, span, t1, t2);
    },
    SupportsRule0: function SupportsRule0(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    fromImport0() {
      var t1 = H._asBoolQ($.Zone__current.$index(0, C.Symbol__inImportRule));
      return t1 === true;
    },
    resolveImportPath0(path) {
      var t1,
        extension = X.ParsedPath_ParsedPath$parse(path, $.$get$context().style)._splitExtension$1(1)[1];
      if (extension === ".sass" || extension === ".scss" || extension === ".css") {
        t1 = B.fromImport0() ? new B.resolveImportPath_closure1(path, extension).call$0() : null;
        return t1 == null ? B._exactlyOne0(B._tryPath0(path)) : t1;
      }
      t1 = B.fromImport0() ? new B.resolveImportPath_closure2(path).call$0() : null;
      if (t1 == null)
        t1 = B._exactlyOne0(B._tryPathWithExtensions0(path));
      return t1 == null ? B._tryPathAsDirectory0(path) : t1;
    },
    _tryPathWithExtensions0(path) {
      var result = B._tryPath0(path + ".sass");
      C.JSArray_methods.addAll$1(result, B._tryPath0(path + ".scss"));
      return result.length !== 0 ? result : B._tryPath0(path + ".css");
    },
    _tryPath0(path) {
      var t1 = $.$get$context(),
        partial = D.join(t1.dirname$1(path), "_" + X.ParsedPath_ParsedPath$parse(path, t1.style).get$basename(), null);
      t1 = H._setArrayType([], type$.JSArray_String);
      if (B.fileExists0(partial))
        t1.push(partial);
      if (B.fileExists0(path))
        t1.push(path);
      return t1;
    },
    _tryPathAsDirectory0(path) {
      var t1;
      if (!B.dirExists0(path))
        return null;
      t1 = B.fromImport0() ? new B._tryPathAsDirectory_closure0(path).call$0() : null;
      return t1 == null ? B._exactlyOne0(B._tryPathWithExtensions0(D.join(path, "index", null))) : t1;
    },
    _exactlyOne0(paths) {
      var t1 = paths.length;
      if (t1 === 0)
        return null;
      if (t1 === 1)
        return C.JSArray_methods.get$first(paths);
      throw H.wrapException(string$.It_s_n + C.JSArray_methods.map$1$1(paths, new B._exactlyOne_closure0(), type$.String).join$1(0, "\n"));
    },
    resolveImportPath_closure1: function resolveImportPath_closure1(t0, t1) {
      this.path = t0;
      this.extension = t1;
    },
    resolveImportPath_closure2: function resolveImportPath_closure2(t0) {
      this.path = t0;
    },
    _tryPathAsDirectory_closure0: function _tryPathAsDirectory_closure0(t0) {
      this.path = t0;
    },
    _exactlyOne_closure0: function _exactlyOne_closure0() {
    },
    forwardToString(klass) {
      type$.Object._as(klass.prototype).toString = P.allowInteropCaptureThis(new B.forwardToString_closure());
    },
    jsForEach(object, callback) {
      var t1, t2;
      for (t1 = J.get$iterator$ax(self.Object.keys(object)); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        callback.call$2(t2, object[t2]);
      }
    },
    createClass($name, $constructor, methods) {
      var klass = P.allowInteropCaptureThis($constructor);
      self.Object.defineProperty(klass, "name", {value: $name});
      methods.forEach$1(0, new B.createClass_closure(type$.Object._as(klass.prototype)));
      return klass;
    },
    setClassName(object, $name) {
      self.Object.defineProperty(type$.Object._as(object.constructor), "name", {value: $name});
    },
    injectSuperclass(object, $constructor) {
      var $parent,
        t1 = self.Object.getPrototypeOf(object);
      t1.toString;
      $parent = self.Object.getPrototypeOf(t1);
      if ($parent != null)
        self.Object.setPrototypeOf(type$.Object._as($constructor.prototype), $parent);
      self.Object.setPrototypeOf(t1, self.Object.create(type$.Object._as($constructor.prototype)));
    },
    forwardToString_closure: function forwardToString_closure() {
    },
    createClass_closure: function createClass_closure(t0) {
      this.$prototype = t0;
    },
    _PropertyDescriptor0: function _PropertyDescriptor0() {
    },
    toSentence0(iter, conjunction) {
      var t1 = iter.__internal$_iterable,
        t2 = J.getInterceptor$asx(t1);
      if (t2.get$length(t1) === 1)
        return J.toString$0$(iter._f.call$1(t2.get$first(t1)));
      return H.TakeIterable_TakeIterable(iter, t2.get$length(t1) - 1, H._instanceType(iter)._eval$1("Iterable.E")).join$1(0, ", ") + (" " + conjunction + " " + H.S(iter._f.call$1(t2.get$last(t1))));
    },
    indent0(string, indentation) {
      return new H.MappedListIterable(H._setArrayType(string.split("\n"), type$.JSArray_String), new B.indent_closure0(indentation), type$.MappedListIterable_String_String).join$1(0, "\n");
    },
    pluralize0($name, number, plural) {
      if (number === 1)
        return $name;
      if (plural != null)
        return plural;
      return $name + "s";
    },
    trimAscii0(string, excludeEscape) {
      var t1,
        start = B._firstNonWhitespace0(string);
      if (start == null)
        t1 = "";
      else {
        t1 = B._lastNonWhitespace0(string, true);
        t1.toString;
        t1 = C.JSString_methods.substring$2(string, start, t1 + 1);
      }
      return t1;
    },
    trimAsciiRight0(string, excludeEscape) {
      var end = B._lastNonWhitespace0(string, excludeEscape);
      return end == null ? "" : C.JSString_methods.substring$2(string, 0, end + 1);
    },
    _firstNonWhitespace0(string) {
      var t1, i, t2;
      for (t1 = string.length, i = 0; i < t1; ++i) {
        t2 = C.JSString_methods._codeUnitAt$1(string, i);
        if (!(t2 === 32 || t2 === 9 || t2 === 10 || t2 === 13 || t2 === 12))
          return i;
      }
      return null;
    },
    _lastNonWhitespace0(string, excludeEscape) {
      var t1, i, codeUnit;
      for (t1 = string.length, i = t1 - 1; i >= 0; --i) {
        codeUnit = C.JSString_methods.codeUnitAt$1(string, i);
        if (!(codeUnit === 32 || codeUnit === 9 || codeUnit === 10 || codeUnit === 13 || codeUnit === 12))
          if (excludeEscape && i !== 0 && i !== t1 && codeUnit === 92)
            return i + 1;
          else
            return i;
      }
      return null;
    },
    isPublic0(member) {
      var start = C.JSString_methods._codeUnitAt$1(member, 0);
      return start !== 45 && start !== 95;
    },
    flattenVertically0(iterable, $T) {
      var result,
        t1 = iterable.$ti._eval$1("@<ListIterable.E>")._bind$1($T._eval$1("QueueList<0>"))._eval$1("MappedListIterable<1,2>"),
        queues = P.List_List$of(new H.MappedListIterable(iterable, new B.flattenVertically_closure1($T), t1), true, t1._eval$1("ListIterable.E"));
      if (queues.length === 1)
        return C.JSArray_methods.get$first(queues);
      result = H._setArrayType([], $T._eval$1("JSArray<0>"));
      for (; queues.length !== 0;) {
        if (!!queues.fixed$length)
          H.throwExpression(P.UnsupportedError$("removeWhere"));
        C.JSArray_methods._removeWhere$2(queues, new B.flattenVertically_closure2(result, $T), true);
      }
      return result;
    },
    firstOrNull0(iterable) {
      var iterator = J.get$iterator$ax(iterable);
      return iterator.moveNext$0() ? iterator.get$current(iterator) : null;
    },
    codepointIndexToCodeUnitIndex0(string, codepointIndex) {
      var codeUnitIndex, i, codeUnitIndex0;
      for (codeUnitIndex = 0, i = 0; i < codepointIndex; ++i) {
        codeUnitIndex0 = codeUnitIndex + 1;
        codeUnitIndex = C.JSString_methods._codeUnitAt$1(string, codeUnitIndex) >>> 10 === 54 ? codeUnitIndex0 + 1 : codeUnitIndex0;
      }
      return codeUnitIndex;
    },
    codeUnitIndexToCodepointIndex0(string, codeUnitIndex) {
      var codepointIndex, i;
      for (codepointIndex = 0, i = 0; i < codeUnitIndex; i = (C.JSString_methods._codeUnitAt$1(string, i) >>> 10 === 54 ? i + 1 : i) + 1)
        ++codepointIndex;
      return codepointIndex;
    },
    frameForSpan0(span, member, url) {
      var t2, t3, t4,
        t1 = url == null ? span.file.url : url;
      if (t1 == null)
        t1 = $.$get$_noSourceUrl0();
      t2 = span.file;
      t3 = span._file$_start;
      t4 = Y.FileLocation$_(t2, t3);
      t4 = t4.file.getLine$1(t4.offset);
      t3 = Y.FileLocation$_(t2, t3);
      return new A.Frame(t1, t4 + 1, t3.file.getColumn$1(t3.offset) + 1, member);
    },
    declarationName0(span) {
      var text = P.String_String$fromCharCodes(C.NativeUint32List_methods.sublist$2(span.file._decodedChars, span._file$_start, span._end), 0, null);
      return B.trimAsciiRight0(C.JSString_methods.substring$2(text, 0, C.JSString_methods.indexOf$1(text, ":")), false);
    },
    unvendor0($name) {
      var i,
        t1 = $name.length;
      if (t1 < 2)
        return $name;
      if (C.JSString_methods._codeUnitAt$1($name, 0) !== 45)
        return $name;
      if (C.JSString_methods._codeUnitAt$1($name, 1) === 45)
        return $name;
      for (i = 2; i < t1; ++i)
        if (C.JSString_methods._codeUnitAt$1($name, i) === 45)
          return C.JSString_methods.substring$1($name, i + 1);
      return $name;
    },
    equalsIgnoreCase0(string1, string2) {
      var t1, i;
      if (string1 === string2)
        return true;
      if (string1 == null || false)
        return false;
      t1 = string1.length;
      if (t1 !== string2.length)
        return false;
      for (i = 0; i < t1; ++i)
        if (!T.characterEqualsIgnoreCase0(C.JSString_methods._codeUnitAt$1(string1, i), C.JSString_methods._codeUnitAt$1(string2, i)))
          return false;
      return true;
    },
    startsWithIgnoreCase0(string, prefix) {
      var i,
        t1 = prefix.length;
      if (string.length < t1)
        return false;
      for (i = 0; i < t1; ++i)
        if (!T.characterEqualsIgnoreCase0(C.JSString_methods._codeUnitAt$1(string, i), C.JSString_methods._codeUnitAt$1(prefix, i)))
          return false;
      return true;
    },
    mapInPlace0(list, $function) {
      var i;
      for (i = 0; i < list.length; ++i)
        list[i] = $function.call$1(list[i]);
    },
    longestCommonSubsequence0(list1, list2, select, $T) {
      var t1, _length, lengths, t2, t3, _i, selections, i, i0, j, selection, j0;
      if (select == null)
        select = new B.longestCommonSubsequence_closure0($T);
      t1 = J.getInterceptor$asx(list1);
      _length = t1.get$length(list1) + 1;
      lengths = J.JSArray_JSArray$allocateFixed(_length, type$.List_int);
      for (t2 = J.getInterceptor$asx(list2), t3 = type$.int, _i = 0; _i < _length; ++_i)
        lengths[_i] = P.List_List$filled(t2.get$length(list2) + 1, 0, false, t3);
      _length = t1.get$length(list1);
      selections = J.JSArray_JSArray$allocateFixed(_length, $T._eval$1("List<0?>"));
      for (t3 = $T._eval$1("0?"), _i = 0; _i < _length; ++_i)
        selections[_i] = P.List_List$filled(t2.get$length(list2), null, false, t3);
      for (i = 0; i < t1.get$length(list1); i = i0)
        for (i0 = i + 1, j = 0; j < t2.get$length(list2); j = j0) {
          selection = select.call$2(t1.$index(list1, i), t2.$index(list2, j));
          selections[i][j] = selection;
          t3 = lengths[i0];
          j0 = j + 1;
          t3[j0] = selection == null ? Math.max(t3[j], lengths[i][j0]) : lengths[i][j] + 1;
        }
      return new B.longestCommonSubsequence_backtrack0(selections, lengths, $T).call$2(t1.get$length(list1) - 1, t2.get$length(list2) - 1);
    },
    removeFirstWhere0(list, test, orElse) {
      var i;
      for (i = 0; i < list.length; ++i) {
        if (!test.call$1(list[i]))
          continue;
        C.JSArray_methods.removeAt$1(list, i);
        return;
      }
      orElse.call$0();
    },
    mapAddAll20(destination, source, K1, K2, $V) {
      source.forEach$1(0, new B.mapAddAll2_closure0(destination, K1, K2, $V));
    },
    setAll0(map, keys, value) {
      var t1;
      for (t1 = J.get$iterator$ax(keys); t1.moveNext$0();)
        map.$indexSet(0, t1.get$current(t1), value);
    },
    rotateSlice0(list, start, end) {
      var i, next,
        element = list.$index(0, end - 1);
      for (i = start; i < end; ++i, element = next) {
        next = list.$index(0, i);
        list.$indexSet(0, i, element);
      }
    },
    mapAsync0(iterable, callback, $E, $F) {
      return B.mapAsync$body0(iterable, callback, $E, $F, $F._eval$1("Iterable<0>"));
    },
    mapAsync$body0(iterable, callback, $E, $F, $async$type) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter($async$type),
        $async$returnValue, t2, _i, t1, $async$temp1;
      var $async$mapAsync0 = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = H._setArrayType([], $F._eval$1("JSArray<0>"));
              t2 = iterable.length, _i = 0;
            case 3:
              // for condition
              if (!(_i < t2)) {
                // goto after for
                $async$goto = 5;
                break;
              }
              $async$temp1 = t1;
              $async$goto = 6;
              return P._asyncAwait(callback.call$1(iterable[_i]), $async$mapAsync0);
            case 6:
              // returning from await.
              $async$temp1.push($async$result);
            case 4:
              // for update
              ++_i;
              // goto for condition
              $async$goto = 3;
              break;
            case 5:
              // after for
              $async$returnValue = t1;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$mapAsync0, $async$completer);
    },
    putIfAbsentAsync0(map, key, ifAbsent, $K, $V) {
      return B.putIfAbsentAsync$body0(map, key, ifAbsent, $K, $V, $V);
    },
    putIfAbsentAsync$body0(map, key, ifAbsent, $K, $V, $async$type) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter($async$type),
        $async$returnValue, value;
      var $async$putIfAbsentAsync0 = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              if (map.containsKey$1(key)) {
                $async$returnValue = $V._as(map.$index(0, key));
                // goto return
                $async$goto = 1;
                break;
              }
              $async$goto = 3;
              return P._asyncAwait(ifAbsent.call$0(), $async$putIfAbsentAsync0);
            case 3:
              // returning from await.
              value = $async$result;
              map.$indexSet(0, key, value);
              $async$returnValue = value;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$putIfAbsentAsync0, $async$completer);
    },
    copyMapOfMap0(map, K1, K2, $V) {
      var t2, t3, t4, t5,
        t1 = P.LinkedHashMap_LinkedHashMap$_empty(K1, K2._eval$1("@<0>")._bind$1($V)._eval$1("Map<1,2>"));
      for (t2 = map.get$entries(map), t2 = t2.get$iterator(t2); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t4 = t3.key;
        t3 = t3.value;
        t5 = P.LinkedHashMap_LinkedHashMap(null, null, null, K2, $V);
        t5.addAll$1(0, t3);
        t1.$indexSet(0, t4, t5);
      }
      return t1;
    },
    copyMapOfList0(map, $K, $E) {
      var t2, t3,
        t1 = P.LinkedHashMap_LinkedHashMap$_empty($K, $E._eval$1("List<0>"));
      for (t2 = map.get$entries(map), t2 = t2.get$iterator(t2); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t1.$indexSet(0, t3.key, J.toList$0$ax(t3.value));
      }
      return t1;
    },
    consumeEscapedCharacter0(scanner) {
      var first, value, i, next, t1;
      scanner.expectChar$1(92);
      first = scanner.peekChar$0();
      if (first == null)
        return 65533;
      else if (first === 10 || first === 13 || first === 12)
        scanner.error$1(0, "Expected escape sequence.");
      else if (T.isHex0(first)) {
        for (value = 0, i = 0; i < 6; ++i) {
          next = scanner.peekChar$0();
          if (next == null || !T.isHex0(next))
            break;
          value = (value << 4 >>> 0) + T.asHex0(scanner.readChar$0());
        }
        t1 = scanner.peekChar$0();
        if (t1 === 32 || t1 === 9 || t1 === 10 || t1 === 13 || t1 === 12)
          scanner.readChar$0();
        if (value !== 0)
          t1 = value >= 55296 && value <= 57343 || value >= 1114111;
        else
          t1 = true;
        if (t1)
          return 65533;
        else
          return value;
      } else
        return scanner.readChar$0();
    },
    indent_closure0: function indent_closure0(t0) {
      this.indentation = t0;
    },
    flattenVertically_closure1: function flattenVertically_closure1(t0) {
      this.T = t0;
    },
    flattenVertically_closure2: function flattenVertically_closure2(t0, t1) {
      this.result = t0;
      this.T = t1;
    },
    longestCommonSubsequence_closure0: function longestCommonSubsequence_closure0(t0) {
      this.T = t0;
    },
    longestCommonSubsequence_backtrack0: function longestCommonSubsequence_backtrack0(t0, t1, t2) {
      this.selections = t0;
      this.lengths = t1;
      this.T = t2;
    },
    mapAddAll2_closure0: function mapAddAll2_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.destination = t0;
      _.K1 = t1;
      _.K2 = t2;
      _.V = t3;
    },
    defaultCompare(value1, value2) {
      return J.compareTo$1$ns(type$.Comparable_nullable_Object._as(value1), value2);
    },
    isAlphabetic(char) {
      var t1;
      if (!(char >= 65 && char <= 90))
        t1 = char >= 97 && char <= 122;
      else
        t1 = true;
      return t1;
    },
    isDriveLetter(path, index) {
      var t1 = path.length,
        t2 = index + 2;
      if (t1 < t2)
        return false;
      if (!B.isAlphabetic(C.JSString_methods.codeUnitAt$1(path, index)))
        return false;
      if (C.JSString_methods.codeUnitAt$1(path, index + 1) !== 58)
        return false;
      if (t1 === t2)
        return true;
      return C.JSString_methods.codeUnitAt$1(path, t2) === 47;
    },
    isAllTheSame(iter) {
      var firstValue, t1, t2;
      if (iter.get$length(iter) === 0)
        return true;
      firstValue = iter.get$first(iter);
      for (t1 = H.SubListIterable$(iter, 1, null, iter.$ti._eval$1("ListIterable.E")), t1 = new H.ListIterator(t1, t1.get$length(t1)), t2 = H._instanceType(t1)._precomputed1; t1.moveNext$0();)
        if (!J.$eq$(t2._as(t1.__internal$_current), firstValue))
          return false;
      return true;
    },
    replaceFirstNull(list, element) {
      var index = C.JSArray_methods.indexOf$1(list, null);
      if (index < 0)
        throw H.wrapException(P.ArgumentError$(H.S(list) + " contains no null elements.", null));
      list[index] = element;
    },
    replaceWithNull(list, element) {
      var index = C.JSArray_methods.indexOf$1(list, element);
      if (index < 0)
        throw H.wrapException(P.ArgumentError$(H.S(list) + " contains no elements matching " + element.toString$0(0) + ".", null));
      list[index] = null;
    },
    countCodeUnits(string, codeUnit) {
      var t1, t2, count;
      for (t1 = new H.CodeUnits(string), t1 = new H.ListIterator(t1, t1.get$length(t1)), t2 = H._instanceType(t1)._precomputed1, count = 0; t1.moveNext$0();)
        if (t2._as(t1.__internal$_current) === codeUnit)
          ++count;
      return count;
    },
    findLineStart(context, text, column) {
      var beginningOfLine, index, lineStart;
      if (text.length === 0)
        for (beginningOfLine = 0; true;) {
          index = C.JSString_methods.indexOf$2(context, "\n", beginningOfLine);
          if (index === -1)
            return context.length - beginningOfLine >= column ? beginningOfLine : null;
          if (index - beginningOfLine >= column)
            return beginningOfLine;
          beginningOfLine = index + 1;
        }
      index = C.JSString_methods.indexOf$1(context, text);
      for (; index !== -1;) {
        lineStart = index === 0 ? 0 : C.JSString_methods.lastIndexOf$2(context, "\n", index - 1) + 1;
        if (column === index - lineStart)
          return lineStart;
        index = C.JSString_methods.indexOf$2(context, text, index + 1);
      }
      return null;
    },
    validateErrorArgs(string, match, position, $length) {
      var t2,
        t1 = position != null;
      if (t1)
        if (position < 0)
          throw H.wrapException(P.RangeError$("position must be greater than or equal to 0."));
        else if (position > string.length)
          throw H.wrapException(P.RangeError$("position must be less than or equal to the string length."));
      t2 = $length != null;
      if (t2 && $length < 0)
        throw H.wrapException(P.RangeError$("length must be greater than or equal to 0."));
      if (t1 && t2 && position + $length > string.length)
        throw H.wrapException(P.RangeError$("position plus length must not go beyond the end of the string."));
    }
  },
  C = {},
  D = {
    fs() {
      var t1 = $._fs;
      return t1 == null ? $._fs = self.fs : t1;
    },
    FS: function FS() {
    },
    FSConstants: function FSConstants() {
    },
    FSWatcher: function FSWatcher() {
    },
    ReadStream: function ReadStream() {
    },
    ReadStreamOptions: function ReadStreamOptions() {
    },
    WriteStream: function WriteStream() {
    },
    WriteStreamOptions: function WriteStreamOptions() {
    },
    FileOptions: function FileOptions() {
    },
    StatOptions: function StatOptions() {
    },
    MkdirOptions: function MkdirOptions() {
    },
    RmdirOptions: function RmdirOptions() {
    },
    WatchOptions: function WatchOptions() {
    },
    WatchFileOptions: function WatchFileOptions() {
    },
    Stats: function Stats() {
    },
    StreamModule: function StreamModule() {
    },
    Readable: function Readable() {
    },
    Writable: function Writable() {
    },
    Duplex: function Duplex() {
    },
    Transform: function Transform() {
    },
    WritableOptions: function WritableOptions() {
    },
    ReadableOptions: function ReadableOptions() {
    },
    ListExpression: function ListExpression(t0, t1, t2, t3) {
      var _ = this;
      _.contents = t0;
      _.separator = t1;
      _.hasBrackets = t2;
      _.span = t3;
    },
    ListExpression_toString_closure: function ListExpression_toString_closure(t0) {
      this.$this = t0;
    },
    StringExpression_quoteText(text) {
      var t1,
        quote = D.StringExpression__bestQuote(H._setArrayType([text], type$.JSArray_String)),
        buffer = new P.StringBuffer("");
      buffer._contents = "" + H.Primitives_stringFromCharCode(quote);
      D.StringExpression__quoteInnerText(text, quote, buffer, true);
      t1 = buffer._contents += H.Primitives_stringFromCharCode(quote);
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    StringExpression__quoteInnerText(text, quote, buffer, $static) {
      var t1, t2, i, codeUnit, next, t3;
      for (t1 = text.length, t2 = t1 - 1, i = 0; i < t1; ++i) {
        codeUnit = C.JSString_methods._codeUnitAt$1(text, i);
        if (codeUnit === 10 || codeUnit === 13 || codeUnit === 12) {
          buffer.writeCharCode$1(92);
          buffer.writeCharCode$1(97);
          if (i !== t2) {
            next = C.JSString_methods._codeUnitAt$1(text, i + 1);
            if (next === 32 || next === 9 || next === 10 || next === 13 || next === 12 || T.isHex(next))
              buffer.writeCharCode$1(32);
          }
        } else {
          if (codeUnit !== quote)
            if (codeUnit !== 92)
              t3 = $static && codeUnit === 35 && i < t2 && C.JSString_methods._codeUnitAt$1(text, i + 1) === 123;
            else
              t3 = true;
          else
            t3 = true;
          if (t3)
            buffer.writeCharCode$1(92);
          buffer.writeCharCode$1(codeUnit);
        }
      }
    },
    StringExpression__bestQuote(strings) {
      var t1, containsDoubleQuote, t2, t3, i, codeUnit;
      for (t1 = J.get$iterator$ax(strings), containsDoubleQuote = false; t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        for (t3 = t2.length, i = 0; i < t3; ++i) {
          codeUnit = C.JSString_methods._codeUnitAt$1(t2, i);
          if (codeUnit === 39)
            return 34;
          if (codeUnit === 34)
            containsDoubleQuote = true;
        }
      }
      return containsDoubleQuote ? 39 : 34;
    },
    StringExpression: function StringExpression(t0, t1) {
      this.text = t0;
      this.hasQuotes = t1;
    },
    ErrorRule: function ErrorRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    SelectorList$(components) {
      var t1 = P.List_List$unmodifiable(components, type$.ComplexSelector);
      if (t1.length === 0)
        H.throwExpression(P.ArgumentError$("components may not be empty.", null));
      return new D.SelectorList(t1);
    },
    SelectorList_SelectorList$parse(contents, allowParent, allowPlaceholder, logger) {
      return T.SelectorParser$(contents, allowParent, allowPlaceholder, logger, null).parse$0();
    },
    SelectorList: function SelectorList(t0) {
      this.components = t0;
    },
    SelectorList_isInvisible_closure: function SelectorList_isInvisible_closure() {
    },
    SelectorList_asSassList_closure: function SelectorList_asSassList_closure() {
    },
    SelectorList_asSassList__closure: function SelectorList_asSassList__closure() {
    },
    SelectorList_unify_closure: function SelectorList_unify_closure(t0) {
      this.other = t0;
    },
    SelectorList_unify__closure: function SelectorList_unify__closure(t0) {
      this.complex1 = t0;
    },
    SelectorList_unify___closure: function SelectorList_unify___closure() {
    },
    SelectorList_resolveParentSelectors_closure: function SelectorList_resolveParentSelectors_closure(t0, t1, t2) {
      this.$this = t0;
      this.implicitParent = t1;
      this.parent = t2;
    },
    SelectorList_resolveParentSelectors__closure: function SelectorList_resolveParentSelectors__closure(t0) {
      this.complex = t0;
    },
    SelectorList_resolveParentSelectors__closure0: function SelectorList_resolveParentSelectors__closure0(t0) {
      this._box_0 = t0;
    },
    SelectorList__complexContainsParentSelector_closure: function SelectorList__complexContainsParentSelector_closure() {
    },
    SelectorList__complexContainsParentSelector__closure: function SelectorList__complexContainsParentSelector__closure() {
    },
    SelectorList__resolveParentSelectorsCompound_closure: function SelectorList__resolveParentSelectorsCompound_closure() {
    },
    SelectorList__resolveParentSelectorsCompound_closure0: function SelectorList__resolveParentSelectorsCompound_closure0(t0) {
      this.parent = t0;
    },
    SelectorList__resolveParentSelectorsCompound_closure1: function SelectorList__resolveParentSelectorsCompound_closure1(t0, t1) {
      this.compound = t0;
      this.resolvedMembers = t1;
    },
    PseudoSelector$($name, argument, element, selector) {
      var t1 = !element,
        t2 = t1 && !D.PseudoSelector__isFakePseudoElement($name);
      return new D.PseudoSelector($name, B.unvendor($name), t2, t1, argument, selector);
    },
    PseudoSelector__isFakePseudoElement($name) {
      switch (C.JSString_methods._codeUnitAt$1($name, 0)) {
        case 97:
        case 65:
          return B.equalsIgnoreCase($name, "after");
        case 98:
        case 66:
          return B.equalsIgnoreCase($name, "before");
        case 102:
        case 70:
          return B.equalsIgnoreCase($name, "first-line") || B.equalsIgnoreCase($name, "first-letter");
        default:
          return false;
      }
    },
    PseudoSelector: function PseudoSelector(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.normalizedName = t1;
      _.isClass = t2;
      _.isSyntacticClass = t3;
      _.argument = t4;
      _.selector = t5;
      _._pseudo$_maxSpecificity = _._pseudo$_minSpecificity = null;
    },
    PseudoSelector_unify_closure: function PseudoSelector_unify_closure() {
    },
    QualifiedName: function QualifiedName(t0, t1) {
      this.name = t0;
      this.namespace = t1;
    },
    compileStylesheet(options, graph, source, destination, ifModified) {
      return D.compileStylesheet$body(options, graph, source, destination, ifModified);
    },
    compileStylesheet$body(options, graph, source, destination, ifModified) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.void),
        $async$returnValue, $async$handler = 2, $async$currentError, $async$next = [], syntax, result, importCache, error, exception, t2, t3, t4, t5, t6, t7, t8, t9, t10, result0, logger, terseLogger, stylesheet, css, buffer, sourceName, destinationName, t1, importer, $async$exception;
      var $async$compileStylesheet = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1) {
          $async$currentError = $async$result;
          $async$goto = $async$handler;
        }
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = $.$get$context();
              importer = new F.FilesystemImporter(t1.absolute$7(".", null, null, null, null, null, null));
              if (ifModified)
                try {
                  if (source != null && destination != null && !graph.modifiedSince$3(t1.toUri$1(source), B.modificationTime(destination), importer)) {
                    // goto return
                    $async$goto = 1;
                    break;
                  }
                } catch (exception) {
                  if (!(H.unwrapException(exception) instanceof B.FileSystemException))
                    throw exception;
                }
              syntax = null;
              if (H._asBoolQ(options._ifParsed$1("indented")) === true)
                syntax = C.Syntax_Sass;
              else if (source != null)
                syntax = M.Syntax_forPath(source);
              else
                syntax = C.Syntax_SCSS;
              result = null;
              $async$handler = 4;
              t2 = options._options;
              $async$goto = H._asBool(t2.$index(0, "async")) ? 7 : 9;
              break;
            case 7:
              // then
              t3 = type$.List_String._as(t2.$index(0, "load-path"));
              t4 = H._asBool(t2.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              t3 = O.AsyncImportCache__toImporters(null, t3, null);
              t5 = type$.Uri;
              importCache = new O.AsyncImportCache(t3, t4, P.LinkedHashMap_LinkedHashMap$_empty(type$.Tuple2_Uri_bool, type$.nullable_Tuple3_AsyncImporter_Uri_Uri), P.LinkedHashMap_LinkedHashMap$_empty(t5, type$.nullable_Stylesheet), P.LinkedHashMap_LinkedHashMap$_empty(t5, type$.ImporterResult));
              $async$goto = source == null ? 10 : 12;
              break;
            case 10:
              // then
              $async$goto = 13;
              return P._asyncAwait(B.readStdin(), $async$compileStylesheet);
            case 13:
              // returning from await.
              t3 = $async$result;
              t4 = syntax;
              t5 = H._asBool(t2.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              t6 = t1.absolute$7(".", null, null, null, null, null, null);
              t7 = J.$eq$(t2.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded0;
              t8 = H._asBool(t2.$index(0, "quiet-deps"));
              t9 = H._asBool(t2.$index(0, "verbose"));
              t10 = options.get$emitSourceMap();
              $async$goto = 14;
              return P._asyncAwait(X.compileStringAsync(t3, H._asBool(t2.$index(0, "charset")), importCache, new F.FilesystemImporter(t6), t5, t8, t10, t7, t4, t9), $async$compileStylesheet);
            case 14:
              // returning from await.
              result0 = $async$result;
              // goto join
              $async$goto = 11;
              break;
            case 12:
              // else
              t3 = syntax;
              t4 = H._asBool(t2.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              t5 = J.$eq$(t2.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded0;
              t6 = H._asBool(t2.$index(0, "quiet-deps"));
              t7 = H._asBool(t2.$index(0, "verbose"));
              t8 = options.get$emitSourceMap();
              $async$goto = 15;
              return P._asyncAwait(X.compileAsync(source, H._asBool(t2.$index(0, "charset")), importCache, t4, t6, t8, t5, t3, t7), $async$compileStylesheet);
            case 15:
              // returning from await.
              result0 = $async$result;
            case 11:
              // join
              result = result0;
              // goto join
              $async$goto = 8;
              break;
            case 9:
              // else
              $async$goto = source == null ? 16 : 18;
              break;
            case 16:
              // then
              $async$goto = 19;
              return P._asyncAwait(B.readStdin(), $async$compileStylesheet);
            case 19:
              // returning from await.
              t3 = $async$result;
              t4 = syntax;
              logger = H._asBool(t2.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              t5 = t1.absolute$7(".", null, null, null, null, null, null);
              t6 = J.$eq$(t2.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded0;
              t7 = H._asBool(t2.$index(0, "quiet-deps"));
              t8 = H._asBool(t2.$index(0, "verbose"));
              t9 = options.get$emitSourceMap();
              t2 = H._asBool(t2.$index(0, "charset"));
              if (!t8) {
                terseLogger = new Y.TerseLogger(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.int), logger);
                logger = terseLogger;
              } else
                terseLogger = null;
              stylesheet = V.Stylesheet_Stylesheet$parse(t3, t4 == null ? C.Syntax_SCSS : t4, logger, null);
              result0 = U._compileStylesheet(stylesheet, logger, graph.importCache, null, new F.FilesystemImporter(t5), null, t6, true, null, null, t7, t9, t2);
              if (terseLogger != null)
                terseLogger.summarize$1$node(false);
              // goto join
              $async$goto = 17;
              break;
            case 18:
              // else
              t3 = syntax;
              logger = H._asBool(t2.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              importCache = graph.importCache;
              t4 = J.$eq$(t2.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded0;
              t5 = H._asBool(t2.$index(0, "quiet-deps"));
              t6 = H._asBool(t2.$index(0, "verbose"));
              t7 = options.get$emitSourceMap();
              t2 = H._asBool(t2.$index(0, "charset"));
              if (!t6) {
                terseLogger = new Y.TerseLogger(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.int), logger);
                logger = terseLogger;
              } else
                terseLogger = null;
              t6 = t3 == null || t3 === M.Syntax_forPath(source);
              if (t6) {
                t3 = t1.absolute$7(".", null, null, null, null, null, null);
                t3 = importCache.importCanonical$3$originalUrl(new F.FilesystemImporter(t3), t1.toUri$1(J.$eq$(J.get$platform$x(self.process), "win32") || J.$eq$(J.get$platform$x(self.process), "darwin") ? F._realCasePath(t1.absolute$7(t1.normalize$1(source), null, null, null, null, null, null)) : t1.canonicalize$1(source)), t1.toUri$1(source));
                t3.toString;
                stylesheet = t3;
              } else {
                t6 = B.readFile(source);
                if (t3 == null)
                  t3 = M.Syntax_forPath(source);
                stylesheet = V.Stylesheet_Stylesheet$parse(t6, t3, logger, t1.toUri$1(source));
              }
              result0 = U._compileStylesheet(stylesheet, logger, importCache, null, new F.FilesystemImporter(t1.absolute$7(".", null, null, null, null, null, null)), null, t4, true, null, null, t5, t7, t2);
              if (terseLogger != null)
                terseLogger.summarize$1$node(false);
            case 17:
              // join
              result = result0;
            case 8:
              // join
              $async$handler = 2;
              // goto after finally
              $async$goto = 6;
              break;
            case 4:
              // catch
              $async$handler = 3;
              $async$exception = $async$currentError;
              t2 = H.unwrapException($async$exception);
              if (t2 instanceof E.SassException) {
                error = t2;
                if (options.get$emitErrorCss())
                  if (destination == null)
                    P.print(error.toCssString$0());
                  else {
                    B.ensureDir(t1.dirname$1(destination));
                    B.writeFile(destination, error.toCssString$0() + "\n");
                  }
                throw $async$exception;
              } else
                throw $async$exception;
              // goto after finally
              $async$goto = 6;
              break;
            case 3:
              // uncaught
              // goto rethrow
              $async$goto = 2;
              break;
            case 6:
              // after finally
              css = result._serialize.css + D._writeSourceMap(options, result._serialize.sourceMap, destination);
              if (destination == null) {
                if (css.length !== 0)
                  P.print(css);
              } else {
                B.ensureDir(t1.dirname$1(destination));
                B.writeFile(destination, css + "\n");
              }
              t2 = options._options;
              if (!H._asBool(t2.$index(0, "quiet")))
                t2 = !H._asBool(t2.$index(0, "update")) && !H._asBool(t2.$index(0, "watch"));
              else
                t2 = true;
              if (t2) {
                // goto return
                $async$goto = 1;
                break;
              }
              buffer = new P.StringBuffer("");
              t2 = options.get$color() ? buffer._contents = "" + "\x1b[32m" : "";
              sourceName = source == null ? "stdin" : t1.prettyUri$1(t1.toUri$1(source));
              destination.toString;
              destinationName = t1.prettyUri$1(t1.toUri$1(destination));
              t1 = t2 + ("Compiled " + sourceName + " to " + destinationName + ".");
              buffer._contents = t1;
              if (options.get$color())
                buffer._contents = t1 + "\x1b[0m";
              P.print(buffer);
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
            case 2:
              // rethrow
              return P._asyncRethrow($async$currentError, $async$completer);
          }
      });
      return P._asyncStartSync($async$compileStylesheet, $async$completer);
    },
    _writeSourceMap(options, sourceMap, destination) {
      var t1, sourceMapText, url, sourceMapPath, t2;
      if (sourceMap == null)
        return "";
      if (destination != null) {
        t1 = $.$get$context();
        sourceMap.targetUrl = t1.toUri$1(X.ParsedPath_ParsedPath$parse(destination, t1.style).get$basename()).toString$0(0);
      }
      B.mapInPlace(sourceMap.urls, new D._writeSourceMap_closure(options, destination));
      t1 = options._options;
      sourceMapText = C.C_JsonCodec.encode$2$toEncodable(sourceMap.toJson$1$includeSourceContents(H._asBool(t1.$index(0, "embed-sources"))), null);
      if (H._asBool(t1.$index(0, "embed-source-map")))
        url = P.Uri_Uri$dataFromString(sourceMapText, C.C_Utf8Codec, "application/json");
      else {
        destination.toString;
        sourceMapPath = destination + ".map";
        t2 = $.$get$context();
        B.ensureDir(t2.dirname$1(sourceMapPath));
        B.writeFile(sourceMapPath, sourceMapText);
        url = t2.toUri$1(t2.relative$2$from(sourceMapPath, t2.dirname$1(destination)));
      }
      t1 = (J.$eq$(t1.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded0) === C.OutputStyle_compressed ? "" : "\n\n";
      return t1 + ("/*# sourceMappingURL=" + url.toString$0(0) + " */");
    },
    _writeSourceMap_closure: function _writeSourceMap_closure(t0, t1) {
      this.options = t0;
      this.destination = t1;
    },
    _function3($name, $arguments, callback) {
      return Q.BuiltInCallable$function($name, $arguments, callback, "sass:list");
    },
    _length_closure0: function _length_closure0() {
    },
    _nth_closure: function _nth_closure() {
    },
    _setNth_closure: function _setNth_closure() {
    },
    _join_closure: function _join_closure() {
    },
    _append_closure0: function _append_closure0() {
    },
    _zip_closure: function _zip_closure() {
    },
    _zip__closure: function _zip__closure() {
    },
    _zip__closure0: function _zip__closure0(t0) {
      this._box_0 = t0;
    },
    _zip__closure1: function _zip__closure1(t0) {
      this._box_0 = t0;
    },
    _index_closure0: function _index_closure0() {
    },
    _separator_closure: function _separator_closure() {
    },
    _isBracketed_closure: function _isBracketed_closure() {
    },
    _slash_closure: function _slash_closure() {
    },
    _codepointForIndex(index, lengthInCodepoints, allowNegative) {
      var result;
      if (index === 0)
        return 0;
      if (index > 0)
        return Math.min(index - 1, lengthInCodepoints);
      result = lengthInCodepoints + index;
      if (result < 0 && !allowNegative)
        return 0;
      return result;
    },
    _function($name, $arguments, callback) {
      return Q.BuiltInCallable$function($name, $arguments, callback, "sass:string");
    },
    _unquote_closure: function _unquote_closure() {
    },
    _quote_closure: function _quote_closure() {
    },
    _length_closure: function _length_closure() {
    },
    _insert_closure: function _insert_closure() {
    },
    _index_closure: function _index_closure() {
    },
    _slice_closure: function _slice_closure() {
    },
    _toUpperCase_closure: function _toUpperCase_closure() {
    },
    _toLowerCase_closure: function _toLowerCase_closure() {
    },
    _uniqueId_closure: function _uniqueId_closure() {
    },
    SourceMapBuffer0: function SourceMapBuffer0(t0, t1) {
      var _ = this;
      _._source_map_buffer0$_buffer = t0;
      _._source_map_buffer0$_entries = t1;
      _._source_map_buffer0$_column = _._source_map_buffer0$_line = 0;
      _._source_map_buffer0$_inSpan = false;
    },
    SourceMapBuffer_buildSourceMap_closure: function SourceMapBuffer_buildSourceMap_closure(t0, t1) {
      this._box_0 = t0;
      this.prefixLength = t1;
    },
    SassArgumentList$(contents, keywords, separator) {
      var t1 = type$.Value;
      t1 = new D.SassArgumentList(H.ConstantMap_ConstantMap$from(keywords, type$.String, t1), P.List_List$unmodifiable(contents, t1), separator, false);
      t1.SassList$3$brackets(contents, separator, false);
      return t1;
    },
    SassArgumentList: function SassArgumentList(t0, t1, t2, t3) {
      var _ = this;
      _._keywords = t0;
      _._wereKeywordsAccessed = false;
      _._list$_contents = t1;
      _.separator = t2;
      _.hasBrackets = t3;
    },
    SassList$(contents, separator, brackets) {
      var t1 = new D.SassList(P.List_List$unmodifiable(contents, type$.Value), separator, brackets);
      t1.SassList$3$brackets(contents, separator, brackets);
      return t1;
    },
    SassList: function SassList(t0, t1, t2) {
      this._list$_contents = t0;
      this.separator = t1;
      this.hasBrackets = t2;
    },
    SassList_isBlank_closure: function SassList_isBlank_closure() {
    },
    ListSeparator: function ListSeparator(t0, t1) {
      this._list$_name = t0;
      this.separator = t1;
    },
    SassString$(text, quotes) {
      return new D.SassString(text, quotes);
    },
    SassString: function SassString(t0, t1) {
      this.text = t0;
      this.hasQuotes = t1;
      this.__SassString_sassLength = null;
    },
    RecursiveStatementVisitor: function RecursiveStatementVisitor() {
    },
    SourceLocationMixin: function SourceLocationMixin() {
    },
    SassArgumentList$0(contents, keywords, separator) {
      var t1 = type$.Value_2;
      t1 = new D.SassArgumentList0(H.ConstantMap_ConstantMap$from(keywords, type$.String, t1), P.List_List$unmodifiable(contents, t1), separator, false);
      t1.SassList$3$brackets0(contents, separator, false);
      return t1;
    },
    SassArgumentList0: function SassArgumentList0(t0, t1, t2, t3) {
      var _ = this;
      _._argument_list$_keywords = t0;
      _._argument_list$_wereKeywordsAccessed = false;
      _._list1$_contents = t1;
      _.separator = t2;
      _.hasBrackets = t3;
    },
    ErrorRule0: function ErrorRule0(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    Exports: function Exports() {
    },
    ListExpression0: function ListExpression0(t0, t1, t2, t3) {
      var _ = this;
      _.contents = t0;
      _.separator = t1;
      _.hasBrackets = t2;
      _.span = t3;
    },
    ListExpression_toString_closure0: function ListExpression_toString_closure0(t0) {
      this.$this = t0;
    },
    _function10($name, $arguments, callback) {
      return Q.BuiltInCallable$function0($name, $arguments, callback, "sass:list");
    },
    _length_closure2: function _length_closure2() {
    },
    _nth_closure0: function _nth_closure0() {
    },
    _setNth_closure0: function _setNth_closure0() {
    },
    _join_closure0: function _join_closure0() {
    },
    _append_closure2: function _append_closure2() {
    },
    _zip_closure0: function _zip_closure0() {
    },
    _zip__closure2: function _zip__closure2() {
    },
    _zip__closure3: function _zip__closure3(t0) {
      this._box_0 = t0;
    },
    _zip__closure4: function _zip__closure4(t0) {
      this._box_0 = t0;
    },
    _index_closure2: function _index_closure2() {
    },
    _separator_closure0: function _separator_closure0() {
    },
    _isBracketed_closure0: function _isBracketed_closure0() {
    },
    _slash_closure0: function _slash_closure0() {
    },
    SelectorList$0(components) {
      var t1 = P.List_List$unmodifiable(components, type$.ComplexSelector_2);
      if (t1.length === 0)
        H.throwExpression(P.ArgumentError$("components may not be empty.", null));
      return new D.SelectorList0(t1);
    },
    SelectorList_SelectorList$parse0(contents, allowParent, allowPlaceholder, logger) {
      return T.SelectorParser$0(contents, allowParent, allowPlaceholder, logger, null).parse$0();
    },
    SelectorList0: function SelectorList0(t0) {
      this.components = t0;
    },
    SelectorList_isInvisible_closure0: function SelectorList_isInvisible_closure0() {
    },
    SelectorList_asSassList_closure0: function SelectorList_asSassList_closure0() {
    },
    SelectorList_asSassList__closure0: function SelectorList_asSassList__closure0() {
    },
    SelectorList_unify_closure0: function SelectorList_unify_closure0(t0) {
      this.other = t0;
    },
    SelectorList_unify__closure0: function SelectorList_unify__closure0(t0) {
      this.complex1 = t0;
    },
    SelectorList_unify___closure0: function SelectorList_unify___closure0() {
    },
    SelectorList_resolveParentSelectors_closure0: function SelectorList_resolveParentSelectors_closure0(t0, t1, t2) {
      this.$this = t0;
      this.implicitParent = t1;
      this.parent = t2;
    },
    SelectorList_resolveParentSelectors__closure1: function SelectorList_resolveParentSelectors__closure1(t0) {
      this.complex = t0;
    },
    SelectorList_resolveParentSelectors__closure2: function SelectorList_resolveParentSelectors__closure2(t0) {
      this._box_0 = t0;
    },
    SelectorList__complexContainsParentSelector_closure0: function SelectorList__complexContainsParentSelector_closure0() {
    },
    SelectorList__complexContainsParentSelector__closure0: function SelectorList__complexContainsParentSelector__closure0() {
    },
    SelectorList__resolveParentSelectorsCompound_closure2: function SelectorList__resolveParentSelectorsCompound_closure2() {
    },
    SelectorList__resolveParentSelectorsCompound_closure3: function SelectorList__resolveParentSelectorsCompound_closure3(t0) {
      this.parent = t0;
    },
    SelectorList__resolveParentSelectorsCompound_closure4: function SelectorList__resolveParentSelectorsCompound_closure4(t0, t1) {
      this.compound = t0;
      this.resolvedMembers = t1;
    },
    _NodeSassList: function _NodeSassList() {
    },
    listConstructor_closure: function listConstructor_closure() {
    },
    listConstructor__closure: function listConstructor__closure() {
    },
    listConstructor_closure0: function listConstructor_closure0() {
    },
    listConstructor_closure1: function listConstructor_closure1() {
    },
    listConstructor_closure2: function listConstructor_closure2() {
    },
    listConstructor_closure3: function listConstructor_closure3() {
    },
    listConstructor_closure4: function listConstructor_closure4() {
    },
    listConstructor_closure5: function listConstructor_closure5() {
    },
    SassList$0(contents, separator, brackets) {
      var t1 = new D.SassList0(P.List_List$unmodifiable(contents, type$.Value_2), separator, brackets);
      t1.SassList$3$brackets0(contents, separator, brackets);
      return t1;
    },
    SassList0: function SassList0(t0, t1, t2) {
      this._list1$_contents = t0;
      this.separator = t1;
      this.hasBrackets = t2;
    },
    SassList_isBlank_closure0: function SassList_isBlank_closure0() {
    },
    ListSeparator0: function ListSeparator0(t0, t1) {
      this._list1$_name = t0;
      this.separator = t1;
    },
    PseudoSelector$0($name, argument, element, selector) {
      var t1 = !element,
        t2 = t1 && !D.PseudoSelector__isFakePseudoElement0($name);
      return new D.PseudoSelector0($name, B.unvendor0($name), t2, t1, argument, selector);
    },
    PseudoSelector__isFakePseudoElement0($name) {
      switch (C.JSString_methods._codeUnitAt$1($name, 0)) {
        case 97:
        case 65:
          return B.equalsIgnoreCase0($name, "after");
        case 98:
        case 66:
          return B.equalsIgnoreCase0($name, "before");
        case 102:
        case 70:
          return B.equalsIgnoreCase0($name, "first-line") || B.equalsIgnoreCase0($name, "first-letter");
        default:
          return false;
      }
    },
    PseudoSelector0: function PseudoSelector0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.normalizedName = t1;
      _.isClass = t2;
      _.isSyntacticClass = t3;
      _.argument = t4;
      _.selector = t5;
      _._pseudo0$_maxSpecificity = _._pseudo0$_minSpecificity = null;
    },
    PseudoSelector_unify_closure0: function PseudoSelector_unify_closure0() {
    },
    QualifiedName0: function QualifiedName0(t0, t1) {
      this.name = t0;
      this.namespace = t1;
    },
    SourceMapBuffer: function SourceMapBuffer(t0, t1) {
      var _ = this;
      _._source_map_buffer$_buffer = t0;
      _._entries = t1;
      _._column = _._line = 0;
      _._inSpan = false;
    },
    SourceMapBuffer_buildSourceMap_closure0: function SourceMapBuffer_buildSourceMap_closure0(t0, t1) {
      this._box_0 = t0;
      this.prefixLength = t1;
    },
    StringExpression_quoteText0(text) {
      var t1,
        quote = D.StringExpression__bestQuote0(H._setArrayType([text], type$.JSArray_String)),
        buffer = new P.StringBuffer("");
      buffer._contents = "" + H.Primitives_stringFromCharCode(quote);
      D.StringExpression__quoteInnerText0(text, quote, buffer, true);
      t1 = buffer._contents += H.Primitives_stringFromCharCode(quote);
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    StringExpression__quoteInnerText0(text, quote, buffer, $static) {
      var t1, t2, i, codeUnit, next, t3;
      for (t1 = text.length, t2 = t1 - 1, i = 0; i < t1; ++i) {
        codeUnit = C.JSString_methods._codeUnitAt$1(text, i);
        if (codeUnit === 10 || codeUnit === 13 || codeUnit === 12) {
          buffer.writeCharCode$1(92);
          buffer.writeCharCode$1(97);
          if (i !== t2) {
            next = C.JSString_methods._codeUnitAt$1(text, i + 1);
            if (next === 32 || next === 9 || next === 10 || next === 13 || next === 12 || T.isHex0(next))
              buffer.writeCharCode$1(32);
          }
        } else {
          if (codeUnit !== quote)
            if (codeUnit !== 92)
              t3 = $static && codeUnit === 35 && i < t2 && C.JSString_methods._codeUnitAt$1(text, i + 1) === 123;
            else
              t3 = true;
          else
            t3 = true;
          if (t3)
            buffer.writeCharCode$1(92);
          buffer.writeCharCode$1(codeUnit);
        }
      }
    },
    StringExpression__bestQuote0(strings) {
      var t1, containsDoubleQuote, t2, t3, i, codeUnit;
      for (t1 = J.get$iterator$ax(strings), containsDoubleQuote = false; t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        for (t3 = t2.length, i = 0; i < t3; ++i) {
          codeUnit = C.JSString_methods._codeUnitAt$1(t2, i);
          if (codeUnit === 39)
            return 34;
          if (codeUnit === 34)
            containsDoubleQuote = true;
        }
      }
      return containsDoubleQuote ? 39 : 34;
    },
    StringExpression0: function StringExpression0(t0, t1) {
      this.text = t0;
      this.hasQuotes = t1;
    },
    _codepointForIndex0(index, lengthInCodepoints, allowNegative) {
      var result;
      if (index === 0)
        return 0;
      if (index > 0)
        return Math.min(index - 1, lengthInCodepoints);
      result = lengthInCodepoints + index;
      if (result < 0 && !allowNegative)
        return 0;
      return result;
    },
    _function6($name, $arguments, callback) {
      return Q.BuiltInCallable$function0($name, $arguments, callback, "sass:string");
    },
    _unquote_closure0: function _unquote_closure0() {
    },
    _quote_closure0: function _quote_closure0() {
    },
    _length_closure1: function _length_closure1() {
    },
    _insert_closure0: function _insert_closure0() {
    },
    _index_closure1: function _index_closure1() {
    },
    _slice_closure0: function _slice_closure0() {
    },
    _toUpperCase_closure0: function _toUpperCase_closure0() {
    },
    _toLowerCase_closure0: function _toLowerCase_closure0() {
    },
    _uniqueId_closure0: function _uniqueId_closure0() {
    },
    _NodeSassString: function _NodeSassString() {
    },
    stringConstructor_closure: function stringConstructor_closure() {
    },
    stringConstructor_closure0: function stringConstructor_closure0() {
    },
    stringConstructor_closure1: function stringConstructor_closure1() {
    },
    stringConstructor_closure2: function stringConstructor_closure2() {
    },
    SassString$0(text, quotes) {
      return new D.SassString0(text, quotes);
    },
    SassString0: function SassString0(t0, t1) {
      this.text = t0;
      this.hasQuotes = t1;
      this._string$__SassString_sassLength = null;
    },
    current() {
      var exception, t1, path, lastIndex, uri = null;
      try {
        uri = P.Uri_base();
      } catch (exception) {
        if (type$.Exception._is(H.unwrapException(exception))) {
          t1 = $._current;
          if (t1 != null)
            return t1;
          throw exception;
        } else
          throw exception;
      }
      if (J.$eq$(uri, $._currentUriBase)) {
        t1 = $._current;
        t1.toString;
        return t1;
      }
      $._currentUriBase = uri;
      if ($.$get$Style_platform() == $.$get$Style_url())
        t1 = $._current = uri.resolve$1(".").toString$0(0);
      else {
        path = uri.toFilePath$0();
        lastIndex = path.length - 1;
        t1 = $._current = lastIndex === 0 ? path : C.JSString_methods.substring$2(path, 0, lastIndex);
      }
      return t1;
    },
    absolute(part1, part2, part3, part4, part5, part6, part7) {
      return $.$get$context().absolute$7(part1, part2, part3, part4, part5, part6, part7);
    },
    join(part1, part2, part3) {
      var _null = null;
      return $.$get$context().join$8(0, part1, part2, part3, _null, _null, _null, _null, _null);
    },
    prettyUri(uri) {
      return $.$get$context().prettyUri$1(uri);
    }
  },
  E = {Promise: function Promise() {
    }, Date: function Date() {
    }, JsError: function JsError() {
    }, Atomics: function Atomics() {
    }, PosixStyle: function PosixStyle(t0, t1, t2) {
      this.separatorPattern = t0;
      this.needsSeparatorPattern = t1;
      this.rootPattern = t2;
    }, UserDefinedCallable: function UserDefinedCallable(t0, t1, t2) {
      this.declaration = t0;
      this.environment = t1;
      this.$ti = t2;
    },
    SassException$(message, span) {
      return new E.SassException(message, span);
    },
    MultiSpanSassException$(message, span, primaryLabel, secondarySpans) {
      return new E.MultiSpanSassException(primaryLabel, H.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String), message, span);
    },
    SassRuntimeException$(message, span, trace) {
      return new E.SassRuntimeException(trace, message, span);
    },
    MultiSpanSassRuntimeException$(message, span, primaryLabel, secondarySpans, trace) {
      return new E.MultiSpanSassRuntimeException(trace, primaryLabel, H.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String), message, span);
    },
    SassFormatException$(message, span) {
      return new E.SassFormatException(message, span);
    },
    SassScriptException$(message) {
      return new E.SassScriptException(message);
    },
    MultiSpanSassScriptException$(message, primaryLabel, secondarySpans) {
      return new E.MultiSpanSassScriptException(primaryLabel, H.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String), message);
    },
    SassException: function SassException(t0, t1) {
      this._span_exception$_message = t0;
      this._span = t1;
    },
    MultiSpanSassException: function MultiSpanSassException(t0, t1, t2, t3) {
      var _ = this;
      _.primaryLabel = t0;
      _.secondarySpans = t1;
      _._span_exception$_message = t2;
      _._span = t3;
    },
    SassRuntimeException: function SassRuntimeException(t0, t1, t2) {
      this.trace = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    MultiSpanSassRuntimeException: function MultiSpanSassRuntimeException(t0, t1, t2, t3, t4) {
      var _ = this;
      _.trace = t0;
      _.primaryLabel = t1;
      _.secondarySpans = t2;
      _._span_exception$_message = t3;
      _._span = t4;
    },
    SassFormatException: function SassFormatException(t0, t1) {
      this._span_exception$_message = t0;
      this._span = t1;
    },
    SassScriptException: function SassScriptException(t0) {
      this.message = t0;
    },
    MultiSpanSassScriptException: function MultiSpanSassScriptException(t0, t1, t2) {
      this.primaryLabel = t0;
      this.secondarySpans = t1;
      this.message = t2;
    },
    ImporterResult: function ImporterResult(t0, t1, t2) {
      this.contents = t0;
      this._sourceMapUrl = t1;
      this.syntax = t2;
    },
    KeyframeSelectorParser$(contents, logger) {
      var t1 = S.SpanScanner$(contents, null);
      return new E.KeyframeSelectorParser(t1, logger);
    },
    KeyframeSelectorParser: function KeyframeSelectorParser(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    KeyframeSelectorParser_parse_closure: function KeyframeSelectorParser_parse_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor$0(functions, importCache, logger, nodeImporter, quietDeps, sourceMap) {
      var t1 = type$.Uri,
        t2 = type$.Module_AsyncCallable,
        t3 = H._setArrayType([], type$.JSArray_Tuple2_String_AstNode),
        t4 = logger == null ? C.StderrLogger_false : logger;
      t3 = new E._EvaluateVisitor0(importCache, nodeImporter, P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.AsyncCallable), P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.AstNode), t4, P.LinkedHashSet_LinkedHashSet$_empty(type$.Tuple2_String_SourceSpan), quietDeps, sourceMap, Q.AsyncEnvironment$(), P.LinkedHashSet_LinkedHashSet$_empty(t1), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.nullable_AstNode), t3, C.Configuration_Map_empty);
      t3._EvaluateVisitor$6$functions$importCache$logger$nodeImporter$quietDeps$sourceMap0(functions, importCache, logger, nodeImporter, quietDeps, sourceMap);
      return t3;
    },
    _EvaluateVisitor0: function _EvaluateVisitor0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._async_evaluate$_importCache = t0;
      _._async_evaluate$_nodeImporter = t1;
      _._async_evaluate$_builtInFunctions = t2;
      _._async_evaluate$_builtInModules = t3;
      _._async_evaluate$_modules = t4;
      _._async_evaluate$_moduleNodes = t5;
      _._async_evaluate$_logger = t6;
      _._async_evaluate$_warningsEmitted = t7;
      _._async_evaluate$_quietDeps = t8;
      _._async_evaluate$_sourceMap = t9;
      _._async_evaluate$_environment = t10;
      _._async_evaluate$_declarationName = _._async_evaluate$__parent = _._async_evaluate$_mediaQueries = _._async_evaluate$_styleRuleIgnoringAtRoot = null;
      _._async_evaluate$_member = "root stylesheet";
      _._async_evaluate$_importSpan = _._async_evaluate$_callableNode = null;
      _._async_evaluate$_inKeyframes = _._async_evaluate$_atRootExcludingStyleRule = _._async_evaluate$_inUnknownAtRule = _._async_evaluate$_inFunction = false;
      _._async_evaluate$_loadedUrls = t11;
      _._async_evaluate$_activeModules = t12;
      _._async_evaluate$_stack = t13;
      _._async_evaluate$_importer = null;
      _._async_evaluate$_inDependency = false;
      _._async_evaluate$__extensionStore = _._async_evaluate$_outOfOrderImports = _._async_evaluate$__endOfImports = _._async_evaluate$__root = _._async_evaluate$__stylesheet = null;
      _._async_evaluate$_configuration = t14;
    },
    _EvaluateVisitor_closure9: function _EvaluateVisitor_closure9(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure10: function _EvaluateVisitor_closure10(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure11: function _EvaluateVisitor_closure11(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure12: function _EvaluateVisitor_closure12(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure13: function _EvaluateVisitor_closure13(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure14: function _EvaluateVisitor_closure14(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure15: function _EvaluateVisitor_closure15(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure16: function _EvaluateVisitor_closure16(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure4: function _EvaluateVisitor__closure4(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure17: function _EvaluateVisitor_closure17(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure18: function _EvaluateVisitor_closure18(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure2: function _EvaluateVisitor__closure2(t0, t1, t2) {
      this.values = t0;
      this.span = t1;
      this.callableNode = t2;
    },
    _EvaluateVisitor__closure3: function _EvaluateVisitor__closure3(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure0: function _EvaluateVisitor_run_closure0(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor__withWarnCallback_closure0: function _EvaluateVisitor__withWarnCallback_closure0(t0, t1) {
      this.$this = t0;
      this.nodeWithSpan = t1;
    },
    _EvaluateVisitor__loadModule_closure1: function _EvaluateVisitor__loadModule_closure1(t0, t1) {
      this.callback = t0;
      this.builtInModule = t1;
    },
    _EvaluateVisitor__loadModule_closure2: function _EvaluateVisitor__loadModule_closure2(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeWithSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__loadModule__closure0: function _EvaluateVisitor__loadModule__closure0(t0, t1) {
      this.$this = t0;
      this.message = t1;
    },
    _EvaluateVisitor__execute_closure0: function _EvaluateVisitor__execute_closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.stylesheet = t2;
      _.extensionStore = t3;
      _.configuration = t4;
      _.css = t5;
    },
    _EvaluateVisitor__combineCss_closure2: function _EvaluateVisitor__combineCss_closure2() {
    },
    _EvaluateVisitor__combineCss_closure3: function _EvaluateVisitor__combineCss_closure3(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_closure4: function _EvaluateVisitor__combineCss_closure4() {
    },
    _EvaluateVisitor__extendModules_closure1: function _EvaluateVisitor__extendModules_closure1(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure2: function _EvaluateVisitor__extendModules_closure2() {
    },
    _EvaluateVisitor__topologicalModules_visitModule0: function _EvaluateVisitor__topologicalModules_visitModule0(t0, t1) {
      this.seen = t0;
      this.sorted = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure2: function _EvaluateVisitor_visitAtRootRule_closure2(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure3: function _EvaluateVisitor_visitAtRootRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure4: function _EvaluateVisitor_visitAtRootRule_closure4(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure5: function _EvaluateVisitor__scopeForAtRoot_closure5(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure6: function _EvaluateVisitor__scopeForAtRoot_closure6(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure7: function _EvaluateVisitor__scopeForAtRoot_closure7(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure0: function _EvaluateVisitor__scopeForAtRoot__closure0(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure8: function _EvaluateVisitor__scopeForAtRoot_closure8(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure9: function _EvaluateVisitor__scopeForAtRoot_closure9() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure10: function _EvaluateVisitor__scopeForAtRoot_closure10(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure0: function _EvaluateVisitor_visitContentRule_closure0(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure1: function _EvaluateVisitor_visitDeclaration_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitDeclaration_closure2: function _EvaluateVisitor_visitDeclaration_closure2(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitEachRule_closure2: function _EvaluateVisitor_visitEachRule_closure2(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure3: function _EvaluateVisitor_visitEachRule_closure3(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure4: function _EvaluateVisitor_visitEachRule_closure4(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure0: function _EvaluateVisitor_visitEachRule__closure0(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure0: function _EvaluateVisitor_visitEachRule___closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitExtendRule_closure0: function _EvaluateVisitor_visitExtendRule_closure0(t0, t1) {
      this.$this = t0;
      this.targetText = t1;
    },
    _EvaluateVisitor_visitAtRule_closure2: function _EvaluateVisitor_visitAtRule_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure3: function _EvaluateVisitor_visitAtRule_closure3(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule__closure0: function _EvaluateVisitor_visitAtRule__closure0(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule_closure4: function _EvaluateVisitor_visitAtRule_closure4() {
    },
    _EvaluateVisitor_visitForRule_closure4: function _EvaluateVisitor_visitForRule_closure4(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure5: function _EvaluateVisitor_visitForRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure6: function _EvaluateVisitor_visitForRule_closure6(t0) {
      this.fromNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure7: function _EvaluateVisitor_visitForRule_closure7(t0, t1) {
      this.toNumber = t0;
      this.fromNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure8: function _EvaluateVisitor_visitForRule_closure8(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
      _.fromNumber = t5;
    },
    _EvaluateVisitor_visitForRule__closure0: function _EvaluateVisitor_visitForRule__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure1: function _EvaluateVisitor_visitForwardRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure2: function _EvaluateVisitor_visitForwardRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIfRule_closure0: function _EvaluateVisitor_visitIfRule_closure0(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitIfRule__closure0: function _EvaluateVisitor_visitIfRule__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure0: function _EvaluateVisitor__visitDynamicImport_closure0(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure3: function _EvaluateVisitor__visitDynamicImport__closure3(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport__closure4: function _EvaluateVisitor__visitDynamicImport__closure4() {
    },
    _EvaluateVisitor__visitDynamicImport__closure5: function _EvaluateVisitor__visitDynamicImport__closure5() {
    },
    _EvaluateVisitor__visitDynamicImport__closure6: function _EvaluateVisitor__visitDynamicImport__closure6(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.result = t1;
      _.stylesheet = t2;
      _.loadsUserDefinedModules = t3;
      _.environment = t4;
      _.children = t5;
    },
    _EvaluateVisitor__visitStaticImport_closure0: function _EvaluateVisitor__visitStaticImport_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure3: function _EvaluateVisitor_visitIncludeRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure4: function _EvaluateVisitor_visitIncludeRule_closure4(t0) {
      this.node = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure6: function _EvaluateVisitor_visitIncludeRule_closure6(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure5: function _EvaluateVisitor_visitIncludeRule_closure5(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.nodeWithSpan = t3;
    },
    _EvaluateVisitor_visitIncludeRule__closure0: function _EvaluateVisitor_visitIncludeRule__closure0(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitIncludeRule___closure0: function _EvaluateVisitor_visitIncludeRule___closure0(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitIncludeRule____closure0: function _EvaluateVisitor_visitIncludeRule____closure0(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure2: function _EvaluateVisitor_visitMediaRule_closure2(t0, t1) {
      this.$this = t0;
      this.queries = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure3: function _EvaluateVisitor_visitMediaRule_closure3(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitMediaRule__closure0: function _EvaluateVisitor_visitMediaRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure0: function _EvaluateVisitor_visitMediaRule___closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure4: function _EvaluateVisitor_visitMediaRule_closure4(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor__visitMediaQueries_closure0: function _EvaluateVisitor__visitMediaQueries_closure0(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure6: function _EvaluateVisitor_visitStyleRule_closure6(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure7: function _EvaluateVisitor_visitStyleRule_closure7(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure8: function _EvaluateVisitor_visitStyleRule_closure8() {
    },
    _EvaluateVisitor_visitStyleRule_closure9: function _EvaluateVisitor_visitStyleRule_closure9(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure10: function _EvaluateVisitor_visitStyleRule_closure10(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure11: function _EvaluateVisitor_visitStyleRule_closure11(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure0: function _EvaluateVisitor_visitStyleRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure12: function _EvaluateVisitor_visitStyleRule_closure12() {
    },
    _EvaluateVisitor_visitSupportsRule_closure1: function _EvaluateVisitor_visitSupportsRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure0: function _EvaluateVisitor_visitSupportsRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure2: function _EvaluateVisitor_visitSupportsRule_closure2() {
    },
    _EvaluateVisitor_visitVariableDeclaration_closure2: function _EvaluateVisitor_visitVariableDeclaration_closure2(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.override = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure3: function _EvaluateVisitor_visitVariableDeclaration_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure4: function _EvaluateVisitor_visitVariableDeclaration_closure4(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure0: function _EvaluateVisitor_visitUseRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure0: function _EvaluateVisitor_visitWarnRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure0: function _EvaluateVisitor_visitWhileRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure0: function _EvaluateVisitor_visitWhileRule__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure0: function _EvaluateVisitor_visitBinaryOperationExpression_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure_recommendation0: function _EvaluateVisitor_visitBinaryOperationExpression_closure_recommendation0() {
    },
    _EvaluateVisitor_visitVariableExpression_closure0: function _EvaluateVisitor_visitVariableExpression_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitUnaryOperationExpression_closure0: function _EvaluateVisitor_visitUnaryOperationExpression_closure0(t0, t1) {
      this.node = t0;
      this.operand = t1;
    },
    _EvaluateVisitor__visitCalculationValue_closure0: function _EvaluateVisitor__visitCalculationValue_closure0(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.inMinMax = t2;
    },
    _EvaluateVisitor_visitListExpression_closure0: function _EvaluateVisitor_visitListExpression_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure1: function _EvaluateVisitor_visitFunctionExpression_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitFunctionExpression_closure2: function _EvaluateVisitor_visitFunctionExpression_closure2(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitInterpolatedFunctionExpression_closure0: function _EvaluateVisitor_visitInterpolatedFunctionExpression_closure0(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.$function = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure0: function _EvaluateVisitor__runUserDefinedCallable_closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure0: function _EvaluateVisitor__runUserDefinedCallable__closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure0: function _EvaluateVisitor__runUserDefinedCallable___closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure0: function _EvaluateVisitor__runUserDefinedCallable____closure0() {
    },
    _EvaluateVisitor__runFunctionCallable_closure0: function _EvaluateVisitor__runFunctionCallable_closure0(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure2: function _EvaluateVisitor__runBuiltInCallable_closure2(t0, t1, t2) {
      this.overload = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure3: function _EvaluateVisitor__runBuiltInCallable_closure3(t0, t1) {
      this.callback = t0;
      this.evaluated = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure4: function _EvaluateVisitor__runBuiltInCallable_closure4() {
    },
    _EvaluateVisitor__evaluateArguments_closure3: function _EvaluateVisitor__evaluateArguments_closure3() {
    },
    _EvaluateVisitor__evaluateArguments_closure4: function _EvaluateVisitor__evaluateArguments_closure4(t0, t1) {
      this.$this = t0;
      this.restNodeForSpan = t1;
    },
    _EvaluateVisitor__evaluateArguments_closure5: function _EvaluateVisitor__evaluateArguments_closure5(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.namedNodes = t3;
    },
    _EvaluateVisitor__evaluateArguments_closure6: function _EvaluateVisitor__evaluateArguments_closure6() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure3: function _EvaluateVisitor__evaluateMacroArguments_closure3(t0) {
      this.restArgs = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure4: function _EvaluateVisitor__evaluateMacroArguments_closure4(t0, t1, t2) {
      this.$this = t0;
      this.restNodeForSpan = t1;
      this.restArgs = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure5: function _EvaluateVisitor__evaluateMacroArguments_closure5(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.restArgs = t3;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure6: function _EvaluateVisitor__evaluateMacroArguments_closure6(t0, t1, t2) {
      this.$this = t0;
      this.keywordRestNodeForSpan = t1;
      this.keywordRestArgs = t2;
    },
    _EvaluateVisitor__addRestMap_closure0: function _EvaluateVisitor__addRestMap_closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.values = t1;
      _.convert = t2;
      _.expressionNode = t3;
      _.map = t4;
      _.nodeWithSpan = t5;
    },
    _EvaluateVisitor__verifyArguments_closure0: function _EvaluateVisitor__verifyArguments_closure0(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitStringExpression_closure0: function _EvaluateVisitor_visitStringExpression_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitCssAtRule_closure1: function _EvaluateVisitor_visitCssAtRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure2: function _EvaluateVisitor_visitCssAtRule_closure2() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure1: function _EvaluateVisitor_visitCssKeyframeBlock_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure2: function _EvaluateVisitor_visitCssKeyframeBlock_closure2() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure2: function _EvaluateVisitor_visitCssMediaRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure3: function _EvaluateVisitor_visitCssMediaRule_closure3(t0, t1, t2) {
      this.$this = t0;
      this.mergedQueries = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssMediaRule__closure0: function _EvaluateVisitor_visitCssMediaRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure0: function _EvaluateVisitor_visitCssMediaRule___closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure4: function _EvaluateVisitor_visitCssMediaRule_closure4(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure1: function _EvaluateVisitor_visitCssStyleRule_closure1(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure0: function _EvaluateVisitor_visitCssStyleRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure2: function _EvaluateVisitor_visitCssStyleRule_closure2() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure1: function _EvaluateVisitor_visitCssSupportsRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure0: function _EvaluateVisitor_visitCssSupportsRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure2: function _EvaluateVisitor_visitCssSupportsRule_closure2() {
    },
    _EvaluateVisitor__performInterpolation_closure0: function _EvaluateVisitor__performInterpolation_closure0(t0, t1, t2) {
      this.$this = t0;
      this.warnForColor = t1;
      this.interpolation = t2;
    },
    _EvaluateVisitor__serialize_closure0: function _EvaluateVisitor__serialize_closure0(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__expressionNode_closure0: function _EvaluateVisitor__expressionNode_closure0(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor__withoutSlash_recommendation0: function _EvaluateVisitor__withoutSlash_recommendation0() {
    },
    _EvaluateVisitor__stackFrame_closure0: function _EvaluateVisitor__stackFrame_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__stackTrace_closure0: function _EvaluateVisitor__stackTrace_closure0(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor0: function _ImportedCssVisitor0(t0) {
      this._async_evaluate$_visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure0: function _ImportedCssVisitor_visitCssAtRule_closure0() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure0: function _ImportedCssVisitor_visitCssMediaRule_closure0(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure0: function _ImportedCssVisitor_visitCssStyleRule_closure0() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure0: function _ImportedCssVisitor_visitCssSupportsRule_closure0() {
    },
    EvaluateResult: function EvaluateResult(t0) {
      this.stylesheet = t0;
    },
    _ArgumentResults0: function _ArgumentResults0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.positionalNodes = t1;
      _.named = t2;
      _.namedNodes = t3;
      _.separator = t4;
    },
    _LoadedStylesheet0: function _LoadedStylesheet0(t0, t1, t2) {
      this.stylesheet = t0;
      this.importer = t1;
      this.isDependency = t2;
    },
    StringScannerException$(message, span, source) {
      return new E.StringScannerException(source, message, span);
    },
    StringScannerException: function StringScannerException(t0, t1, t2) {
      this.source = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    WatchEvent: function WatchEvent(t0, t1) {
      this.type = t0;
      this.path = t1;
    },
    ChangeType: function ChangeType(t0) {
      this._watch_event$_name = t0;
    },
    _EvaluateVisitor$2(functions, importCache, logger, nodeImporter, quietDeps, sourceMap) {
      var t4, t5,
        t1 = type$.Uri,
        t2 = type$.Module_AsyncCallable_2,
        t3 = H._setArrayType([], type$.JSArray_Tuple2_String_AstNode_2);
      if (nodeImporter == null)
        t4 = importCache == null ? O.AsyncImportCache$none(logger) : importCache;
      else
        t4 = null;
      t5 = logger == null ? C.C_StderrLogger : logger;
      t3 = new E._EvaluateVisitor2(t4, nodeImporter, P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.AsyncCallable_2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.AstNode_2), t5, P.LinkedHashSet_LinkedHashSet$_empty(type$.Tuple2_String_SourceSpan), quietDeps, sourceMap, Q.AsyncEnvironment$0(), P.LinkedHashSet_LinkedHashSet$_empty(t1), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.nullable_AstNode_2), t3, C.Configuration_Map_empty0);
      t3._EvaluateVisitor$6$functions$importCache$logger$nodeImporter$quietDeps$sourceMap2(functions, importCache, logger, nodeImporter, quietDeps, sourceMap);
      return t3;
    },
    _EvaluateVisitor2: function _EvaluateVisitor2(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._async_evaluate0$_importCache = t0;
      _._async_evaluate0$_nodeImporter = t1;
      _._async_evaluate0$_builtInFunctions = t2;
      _._async_evaluate0$_builtInModules = t3;
      _._async_evaluate0$_modules = t4;
      _._async_evaluate0$_moduleNodes = t5;
      _._async_evaluate0$_logger = t6;
      _._async_evaluate0$_warningsEmitted = t7;
      _._async_evaluate0$_quietDeps = t8;
      _._async_evaluate0$_sourceMap = t9;
      _._async_evaluate0$_environment = t10;
      _._async_evaluate0$_declarationName = _._async_evaluate0$__parent = _._async_evaluate0$_mediaQueries = _._async_evaluate0$_styleRuleIgnoringAtRoot = null;
      _._async_evaluate0$_member = "root stylesheet";
      _._async_evaluate0$_importSpan = _._async_evaluate0$_callableNode = null;
      _._async_evaluate0$_inKeyframes = _._async_evaluate0$_atRootExcludingStyleRule = _._async_evaluate0$_inUnknownAtRule = _._async_evaluate0$_inFunction = false;
      _._async_evaluate0$_loadedUrls = t11;
      _._async_evaluate0$_activeModules = t12;
      _._async_evaluate0$_stack = t13;
      _._async_evaluate0$_importer = null;
      _._async_evaluate0$_inDependency = false;
      _._async_evaluate0$__extensionStore = _._async_evaluate0$_outOfOrderImports = _._async_evaluate0$__endOfImports = _._async_evaluate0$__root = _._async_evaluate0$__stylesheet = null;
      _._async_evaluate0$_configuration = t14;
    },
    _EvaluateVisitor_closure29: function _EvaluateVisitor_closure29(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure30: function _EvaluateVisitor_closure30(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure31: function _EvaluateVisitor_closure31(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure32: function _EvaluateVisitor_closure32(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure33: function _EvaluateVisitor_closure33(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure34: function _EvaluateVisitor_closure34(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure35: function _EvaluateVisitor_closure35(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure36: function _EvaluateVisitor_closure36(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure10: function _EvaluateVisitor__closure10(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure37: function _EvaluateVisitor_closure37(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure38: function _EvaluateVisitor_closure38(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure8: function _EvaluateVisitor__closure8(t0, t1, t2) {
      this.values = t0;
      this.span = t1;
      this.callableNode = t2;
    },
    _EvaluateVisitor__closure9: function _EvaluateVisitor__closure9(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure2: function _EvaluateVisitor_run_closure2(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor__withWarnCallback_closure2: function _EvaluateVisitor__withWarnCallback_closure2(t0, t1) {
      this.$this = t0;
      this.nodeWithSpan = t1;
    },
    _EvaluateVisitor__loadModule_closure5: function _EvaluateVisitor__loadModule_closure5(t0, t1) {
      this.callback = t0;
      this.builtInModule = t1;
    },
    _EvaluateVisitor__loadModule_closure6: function _EvaluateVisitor__loadModule_closure6(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeWithSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__loadModule__closure2: function _EvaluateVisitor__loadModule__closure2(t0, t1) {
      this.$this = t0;
      this.message = t1;
    },
    _EvaluateVisitor__execute_closure2: function _EvaluateVisitor__execute_closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.stylesheet = t2;
      _.extensionStore = t3;
      _.configuration = t4;
      _.css = t5;
    },
    _EvaluateVisitor__combineCss_closure8: function _EvaluateVisitor__combineCss_closure8() {
    },
    _EvaluateVisitor__combineCss_closure9: function _EvaluateVisitor__combineCss_closure9(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_closure10: function _EvaluateVisitor__combineCss_closure10() {
    },
    _EvaluateVisitor__extendModules_closure5: function _EvaluateVisitor__extendModules_closure5(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure6: function _EvaluateVisitor__extendModules_closure6() {
    },
    _EvaluateVisitor__topologicalModules_visitModule2: function _EvaluateVisitor__topologicalModules_visitModule2(t0, t1) {
      this.seen = t0;
      this.sorted = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure8: function _EvaluateVisitor_visitAtRootRule_closure8(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure9: function _EvaluateVisitor_visitAtRootRule_closure9(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure10: function _EvaluateVisitor_visitAtRootRule_closure10(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure17: function _EvaluateVisitor__scopeForAtRoot_closure17(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure18: function _EvaluateVisitor__scopeForAtRoot_closure18(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure19: function _EvaluateVisitor__scopeForAtRoot_closure19(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure2: function _EvaluateVisitor__scopeForAtRoot__closure2(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure20: function _EvaluateVisitor__scopeForAtRoot_closure20(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure21: function _EvaluateVisitor__scopeForAtRoot_closure21() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure22: function _EvaluateVisitor__scopeForAtRoot_closure22(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure2: function _EvaluateVisitor_visitContentRule_closure2(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure5: function _EvaluateVisitor_visitDeclaration_closure5(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitDeclaration_closure6: function _EvaluateVisitor_visitDeclaration_closure6(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitEachRule_closure8: function _EvaluateVisitor_visitEachRule_closure8(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure9: function _EvaluateVisitor_visitEachRule_closure9(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure10: function _EvaluateVisitor_visitEachRule_closure10(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure2: function _EvaluateVisitor_visitEachRule__closure2(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure2: function _EvaluateVisitor_visitEachRule___closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitExtendRule_closure2: function _EvaluateVisitor_visitExtendRule_closure2(t0, t1) {
      this.$this = t0;
      this.targetText = t1;
    },
    _EvaluateVisitor_visitAtRule_closure8: function _EvaluateVisitor_visitAtRule_closure8(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure9: function _EvaluateVisitor_visitAtRule_closure9(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule__closure2: function _EvaluateVisitor_visitAtRule__closure2(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule_closure10: function _EvaluateVisitor_visitAtRule_closure10() {
    },
    _EvaluateVisitor_visitForRule_closure14: function _EvaluateVisitor_visitForRule_closure14(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure15: function _EvaluateVisitor_visitForRule_closure15(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure16: function _EvaluateVisitor_visitForRule_closure16(t0) {
      this.fromNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure17: function _EvaluateVisitor_visitForRule_closure17(t0, t1) {
      this.toNumber = t0;
      this.fromNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure18: function _EvaluateVisitor_visitForRule_closure18(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
      _.fromNumber = t5;
    },
    _EvaluateVisitor_visitForRule__closure2: function _EvaluateVisitor_visitForRule__closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure5: function _EvaluateVisitor_visitForwardRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure6: function _EvaluateVisitor_visitForwardRule_closure6(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIfRule_closure2: function _EvaluateVisitor_visitIfRule_closure2(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitIfRule__closure2: function _EvaluateVisitor_visitIfRule__closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure2: function _EvaluateVisitor__visitDynamicImport_closure2(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure11: function _EvaluateVisitor__visitDynamicImport__closure11(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport__closure12: function _EvaluateVisitor__visitDynamicImport__closure12() {
    },
    _EvaluateVisitor__visitDynamicImport__closure13: function _EvaluateVisitor__visitDynamicImport__closure13() {
    },
    _EvaluateVisitor__visitDynamicImport__closure14: function _EvaluateVisitor__visitDynamicImport__closure14(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.result = t1;
      _.stylesheet = t2;
      _.loadsUserDefinedModules = t3;
      _.environment = t4;
      _.children = t5;
    },
    _EvaluateVisitor__visitStaticImport_closure2: function _EvaluateVisitor__visitStaticImport_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure11: function _EvaluateVisitor_visitIncludeRule_closure11(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure12: function _EvaluateVisitor_visitIncludeRule_closure12(t0) {
      this.node = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure14: function _EvaluateVisitor_visitIncludeRule_closure14(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure13: function _EvaluateVisitor_visitIncludeRule_closure13(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.nodeWithSpan = t3;
    },
    _EvaluateVisitor_visitIncludeRule__closure2: function _EvaluateVisitor_visitIncludeRule__closure2(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitIncludeRule___closure2: function _EvaluateVisitor_visitIncludeRule___closure2(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitIncludeRule____closure2: function _EvaluateVisitor_visitIncludeRule____closure2(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure8: function _EvaluateVisitor_visitMediaRule_closure8(t0, t1) {
      this.$this = t0;
      this.queries = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure9: function _EvaluateVisitor_visitMediaRule_closure9(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitMediaRule__closure2: function _EvaluateVisitor_visitMediaRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure2: function _EvaluateVisitor_visitMediaRule___closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure10: function _EvaluateVisitor_visitMediaRule_closure10(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor__visitMediaQueries_closure2: function _EvaluateVisitor__visitMediaQueries_closure2(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure20: function _EvaluateVisitor_visitStyleRule_closure20(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure21: function _EvaluateVisitor_visitStyleRule_closure21(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure22: function _EvaluateVisitor_visitStyleRule_closure22() {
    },
    _EvaluateVisitor_visitStyleRule_closure23: function _EvaluateVisitor_visitStyleRule_closure23(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure24: function _EvaluateVisitor_visitStyleRule_closure24(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure25: function _EvaluateVisitor_visitStyleRule_closure25(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure2: function _EvaluateVisitor_visitStyleRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure26: function _EvaluateVisitor_visitStyleRule_closure26() {
    },
    _EvaluateVisitor_visitSupportsRule_closure5: function _EvaluateVisitor_visitSupportsRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure2: function _EvaluateVisitor_visitSupportsRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure6: function _EvaluateVisitor_visitSupportsRule_closure6() {
    },
    _EvaluateVisitor_visitVariableDeclaration_closure8: function _EvaluateVisitor_visitVariableDeclaration_closure8(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.override = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure9: function _EvaluateVisitor_visitVariableDeclaration_closure9(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure10: function _EvaluateVisitor_visitVariableDeclaration_closure10(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure2: function _EvaluateVisitor_visitUseRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure2: function _EvaluateVisitor_visitWarnRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure2: function _EvaluateVisitor_visitWhileRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure2: function _EvaluateVisitor_visitWhileRule__closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure2: function _EvaluateVisitor_visitBinaryOperationExpression_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure_recommendation2: function _EvaluateVisitor_visitBinaryOperationExpression_closure_recommendation2() {
    },
    _EvaluateVisitor_visitVariableExpression_closure2: function _EvaluateVisitor_visitVariableExpression_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitUnaryOperationExpression_closure2: function _EvaluateVisitor_visitUnaryOperationExpression_closure2(t0, t1) {
      this.node = t0;
      this.operand = t1;
    },
    _EvaluateVisitor__visitCalculationValue_closure2: function _EvaluateVisitor__visitCalculationValue_closure2(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.inMinMax = t2;
    },
    _EvaluateVisitor_visitListExpression_closure2: function _EvaluateVisitor_visitListExpression_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure5: function _EvaluateVisitor_visitFunctionExpression_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitFunctionExpression_closure6: function _EvaluateVisitor_visitFunctionExpression_closure6(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitInterpolatedFunctionExpression_closure2: function _EvaluateVisitor_visitInterpolatedFunctionExpression_closure2(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.$function = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure2: function _EvaluateVisitor__runUserDefinedCallable_closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure2: function _EvaluateVisitor__runUserDefinedCallable__closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure2: function _EvaluateVisitor__runUserDefinedCallable___closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure2: function _EvaluateVisitor__runUserDefinedCallable____closure2() {
    },
    _EvaluateVisitor__runFunctionCallable_closure2: function _EvaluateVisitor__runFunctionCallable_closure2(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure8: function _EvaluateVisitor__runBuiltInCallable_closure8(t0, t1, t2) {
      this.overload = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure9: function _EvaluateVisitor__runBuiltInCallable_closure9(t0, t1) {
      this.callback = t0;
      this.evaluated = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure10: function _EvaluateVisitor__runBuiltInCallable_closure10() {
    },
    _EvaluateVisitor__evaluateArguments_closure11: function _EvaluateVisitor__evaluateArguments_closure11() {
    },
    _EvaluateVisitor__evaluateArguments_closure12: function _EvaluateVisitor__evaluateArguments_closure12(t0, t1) {
      this.$this = t0;
      this.restNodeForSpan = t1;
    },
    _EvaluateVisitor__evaluateArguments_closure13: function _EvaluateVisitor__evaluateArguments_closure13(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.namedNodes = t3;
    },
    _EvaluateVisitor__evaluateArguments_closure14: function _EvaluateVisitor__evaluateArguments_closure14() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure11: function _EvaluateVisitor__evaluateMacroArguments_closure11(t0) {
      this.restArgs = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure12: function _EvaluateVisitor__evaluateMacroArguments_closure12(t0, t1, t2) {
      this.$this = t0;
      this.restNodeForSpan = t1;
      this.restArgs = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure13: function _EvaluateVisitor__evaluateMacroArguments_closure13(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.restArgs = t3;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure14: function _EvaluateVisitor__evaluateMacroArguments_closure14(t0, t1, t2) {
      this.$this = t0;
      this.keywordRestNodeForSpan = t1;
      this.keywordRestArgs = t2;
    },
    _EvaluateVisitor__addRestMap_closure2: function _EvaluateVisitor__addRestMap_closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.values = t1;
      _.convert = t2;
      _.expressionNode = t3;
      _.map = t4;
      _.nodeWithSpan = t5;
    },
    _EvaluateVisitor__verifyArguments_closure2: function _EvaluateVisitor__verifyArguments_closure2(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitStringExpression_closure2: function _EvaluateVisitor_visitStringExpression_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitCssAtRule_closure5: function _EvaluateVisitor_visitCssAtRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure6: function _EvaluateVisitor_visitCssAtRule_closure6() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure5: function _EvaluateVisitor_visitCssKeyframeBlock_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure6: function _EvaluateVisitor_visitCssKeyframeBlock_closure6() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure8: function _EvaluateVisitor_visitCssMediaRule_closure8(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure9: function _EvaluateVisitor_visitCssMediaRule_closure9(t0, t1, t2) {
      this.$this = t0;
      this.mergedQueries = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssMediaRule__closure2: function _EvaluateVisitor_visitCssMediaRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure2: function _EvaluateVisitor_visitCssMediaRule___closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure10: function _EvaluateVisitor_visitCssMediaRule_closure10(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure5: function _EvaluateVisitor_visitCssStyleRule_closure5(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure2: function _EvaluateVisitor_visitCssStyleRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure6: function _EvaluateVisitor_visitCssStyleRule_closure6() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure5: function _EvaluateVisitor_visitCssSupportsRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure2: function _EvaluateVisitor_visitCssSupportsRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure6: function _EvaluateVisitor_visitCssSupportsRule_closure6() {
    },
    _EvaluateVisitor__performInterpolation_closure2: function _EvaluateVisitor__performInterpolation_closure2(t0, t1, t2) {
      this.$this = t0;
      this.warnForColor = t1;
      this.interpolation = t2;
    },
    _EvaluateVisitor__serialize_closure2: function _EvaluateVisitor__serialize_closure2(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__expressionNode_closure2: function _EvaluateVisitor__expressionNode_closure2(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor__withoutSlash_recommendation2: function _EvaluateVisitor__withoutSlash_recommendation2() {
    },
    _EvaluateVisitor__stackFrame_closure2: function _EvaluateVisitor__stackFrame_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__stackTrace_closure2: function _EvaluateVisitor__stackTrace_closure2(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor2: function _ImportedCssVisitor2(t0) {
      this._async_evaluate0$_visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure2: function _ImportedCssVisitor_visitCssAtRule_closure2() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure2: function _ImportedCssVisitor_visitCssMediaRule_closure2(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure2: function _ImportedCssVisitor_visitCssStyleRule_closure2() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure2: function _ImportedCssVisitor_visitCssSupportsRule_closure2() {
    },
    EvaluateResult0: function EvaluateResult0(t0, t1) {
      this.stylesheet = t0;
      this.loadedUrls = t1;
    },
    _ArgumentResults2: function _ArgumentResults2(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.positionalNodes = t1;
      _.named = t2;
      _.namedNodes = t3;
      _.separator = t4;
    },
    _LoadedStylesheet2: function _LoadedStylesheet2(t0, t1, t2) {
      this.stylesheet = t0;
      this.importer = t1;
      this.isDependency = t2;
    },
    SassException$0(message, span) {
      return new E.SassException0(message, span);
    },
    MultiSpanSassException$0(message, span, primaryLabel, secondarySpans) {
      return new E.MultiSpanSassException0(primaryLabel, H.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String), message, span);
    },
    SassRuntimeException$0(message, span, trace) {
      return new E.SassRuntimeException0(trace, message, span);
    },
    MultiSpanSassRuntimeException$0(message, span, primaryLabel, secondarySpans, trace) {
      return new E.MultiSpanSassRuntimeException0(trace, primaryLabel, H.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String), message, span);
    },
    SassFormatException$0(message, span) {
      return new E.SassFormatException0(message, span);
    },
    SassScriptException$0(message) {
      return new E.SassScriptException0(message);
    },
    MultiSpanSassScriptException$0(message, primaryLabel, secondarySpans) {
      return new E.MultiSpanSassScriptException0(primaryLabel, H.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String), message);
    },
    SassException0: function SassException0(t0, t1) {
      this._span_exception$_message = t0;
      this._span = t1;
    },
    MultiSpanSassException0: function MultiSpanSassException0(t0, t1, t2, t3) {
      var _ = this;
      _.primaryLabel = t0;
      _.secondarySpans = t1;
      _._span_exception$_message = t2;
      _._span = t3;
    },
    SassRuntimeException0: function SassRuntimeException0(t0, t1, t2) {
      this.trace = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    MultiSpanSassRuntimeException0: function MultiSpanSassRuntimeException0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.trace = t0;
      _.primaryLabel = t1;
      _.secondarySpans = t2;
      _._span_exception$_message = t3;
      _._span = t4;
    },
    SassFormatException0: function SassFormatException0(t0, t1) {
      this._span_exception$_message = t0;
      this._span = t1;
    },
    SassScriptException0: function SassScriptException0(t0) {
      this.message = t0;
    },
    MultiSpanSassScriptException0: function MultiSpanSassScriptException0(t0, t1, t2) {
      this.primaryLabel = t0;
      this.secondarySpans = t1;
      this.message = t2;
    },
    FiberClass: function FiberClass() {
    },
    Fiber: function Fiber() {
    },
    KeyframeSelectorParser$0(contents, logger) {
      var t1 = S.SpanScanner$(contents, null);
      return new E.KeyframeSelectorParser0(t1, logger);
    },
    KeyframeSelectorParser0: function KeyframeSelectorParser0(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    KeyframeSelectorParser_parse_closure0: function KeyframeSelectorParser_parse_closure0(t0) {
      this.$this = t0;
    },
    ImporterResult0: function ImporterResult0(t0, t1, t2) {
      this.contents = t0;
      this._result$_sourceMapUrl = t1;
      this.syntax = t2;
    },
    UserDefinedCallable0: function UserDefinedCallable0(t0, t1, t2) {
      this.declaration = t0;
      this.environment = t1;
      this.$ti = t2;
    }
  },
  F = {ValueResult: function ValueResult(t0, t1) {
      this.value = t0;
      this.$ti = t1;
    }, ConsoleModule: function ConsoleModule() {
    }, Console: function Console() {
    }, EventEmitter: function EventEmitter() {
    }, UrlStyle: function UrlStyle(t0, t1, t2, t3) {
      var _ = this;
      _.separatorPattern = t0;
      _.needsSeparatorPattern = t1;
      _.rootPattern = t2;
      _.relativeRootPattern = t3;
    }, CssMediaQuery: function CssMediaQuery(t0, t1, t2) {
      this.modifier = t0;
      this.type = t1;
      this.features = t2;
    }, _SingletonCssMediaQueryMergeResult: function _SingletonCssMediaQueryMergeResult(t0) {
      this._media_query$_name = t0;
    }, MediaQuerySuccessfulMergeResult: function MediaQuerySuccessfulMergeResult(t0) {
      this.query = t0;
    },
    ModifiableCssImport$(url, span, media, supports) {
      return new F.ModifiableCssImport(url, supports, media == null ? null : P.List_List$unmodifiable(media, type$.CssMediaQuery), span);
    },
    ModifiableCssImport: function ModifiableCssImport(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.supports = t1;
      _.media = t2;
      _.span = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssValue: function ModifiableCssValue(t0, t1, t2) {
      this.value = t0;
      this.span = t1;
      this.$ti = t2;
    },
    CssValue: function CssValue(t0, t1, t2) {
      this.value = t0;
      this.span = t1;
      this.$ti = t2;
    },
    FunctionExpression: function FunctionExpression(t0, t1, t2, t3) {
      var _ = this;
      _.namespace = t0;
      _.originalName = t1;
      _.$arguments = t2;
      _.span = t3;
    },
    ValueExpression: function ValueExpression(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    SupportsFunction: function SupportsFunction(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.span = t2;
    },
    TypeSelector: function TypeSelector(t0) {
      this.name = t0;
    },
    EmptyExtensionStore: function EmptyExtensionStore() {
    },
    FilesystemImporter: function FilesystemImporter(t0) {
      this._loadPath = t0;
    },
    FilesystemImporter_canonicalize_closure: function FilesystemImporter_canonicalize_closure() {
    },
    _realCasePath(path) {
      var prefix, t1;
      if (!(J.$eq$(J.get$platform$x(self.process), "win32") || J.$eq$(J.get$platform$x(self.process), "darwin")))
        return path;
      if (J.$eq$(J.get$platform$x(self.process), "win32")) {
        prefix = C.JSString_methods.substring$2(path, 0, $.$get$context().style.rootLength$1(path));
        t1 = prefix.length;
        if (t1 !== 0 && T.isAlphabetic0(C.JSString_methods._codeUnitAt$1(prefix, 0)))
          path = prefix.toUpperCase() + C.JSString_methods.substring$1(path, t1);
      }
      return new F._realCasePath_helper().call$1(path);
    },
    _realCasePath_helper: function _realCasePath_helper() {
    },
    _realCasePath_helper_closure: function _realCasePath_helper_closure(t0, t1, t2) {
      this.helper = t0;
      this.dirname = t1;
      this.path = t2;
    },
    _realCasePath_helper__closure: function _realCasePath_helper__closure(t0) {
      this.basename = t0;
    },
    _QuietLogger: function _QuietLogger() {
    },
    JSFunction: function JSFunction() {
    },
    NodeImporterResult: function NodeImporterResult() {
    },
    MediaQueryParser: function MediaQueryParser(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    MediaQueryParser_parse_closure: function MediaQueryParser_parse_closure(t0) {
      this.$this = t0;
    },
    PrefixedMapView: function PrefixedMapView(t0, t1, t2) {
      this._prefixed_map_view$_map = t0;
      this._prefix = t1;
      this.$ti = t2;
    },
    _PrefixedKeys: function _PrefixedKeys(t0) {
      this._view = t0;
    },
    _PrefixedKeys_iterator_closure: function _PrefixedKeys_iterator_closure(t0) {
      this.$this = t0;
    },
    Value: function Value() {
    },
    SassFunction: function SassFunction(t0) {
      this.callable = t0;
    },
    _FindDependenciesVisitor: function _FindDependenciesVisitor(t0, t1) {
      this._usesAndForwards = t0;
      this._imports = t1;
    },
    EmptyExtensionStore0: function EmptyExtensionStore0() {
    },
    FilesystemImporter0: function FilesystemImporter0(t0) {
      this._filesystem$_loadPath = t0;
    },
    FilesystemImporter_canonicalize_closure0: function FilesystemImporter_canonicalize_closure0() {
    },
    FunctionExpression0: function FunctionExpression0(t0, t1, t2, t3) {
      var _ = this;
      _.namespace = t0;
      _.originalName = t1;
      _.$arguments = t2;
      _.span = t3;
    },
    JSFunction0: function JSFunction0() {
    },
    SupportsFunction0: function SupportsFunction0(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.span = t2;
    },
    SassFunction0: function SassFunction0(t0) {
      this.callable = t0;
    },
    NodeImporter__addSassPath($async$includePaths) {
      return P._makeSyncStarIterable(function() {
        var includePaths = $async$includePaths;
        var $async$goto = 0, $async$handler = 2, $async$currentError, sassPath;
        return function $async$NodeImporter__addSassPath($async$errorCode, $async$result) {
          if ($async$errorCode === 1) {
            $async$currentError = $async$result;
            $async$goto = $async$handler;
          }
          while (true)
            switch ($async$goto) {
              case 0:
                // Function start
                $async$goto = 3;
                return P._IterationMarker_yieldStar(includePaths);
              case 3:
                // after yield
                sassPath = H._asStringQ(type$.Object._as(J.get$env$x(self.process)).SASS_PATH);
                if (sassPath == null) {
                  // goto return
                  $async$goto = 1;
                  break;
                }
                $async$goto = 4;
                return P._IterationMarker_yieldStar(H._setArrayType(sassPath.split(J.$eq$(J.get$platform$x(self.process), "win32") ? ";" : ":"), type$.JSArray_String));
              case 4:
                // after yield
              case 1:
                // return
                return P._IterationMarker_endOfIteration();
              case 2:
                // rethrow
                return P._IterationMarker_uncaughtError($async$currentError);
            }
        };
      }, type$.String);
    },
    NodeImporter: function NodeImporter(t0, t1, t2) {
      this._implementation$_options = t0;
      this._includePaths = t1;
      this._implementation$_importers = t2;
    },
    NodeImporter__tryPath_closure: function NodeImporter__tryPath_closure(t0) {
      this.path = t0;
    },
    NodeImporter__tryPath_closure0: function NodeImporter__tryPath_closure0() {
    },
    ModifiableCssImport$0(url, span, media, supports) {
      return new F.ModifiableCssImport0(url, supports, media == null ? null : P.List_List$unmodifiable(media, type$.CssMediaQuery_2), span);
    },
    ModifiableCssImport0: function ModifiableCssImport0(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.supports = t1;
      _.media = t2;
      _.span = t3;
      _._node2$_indexInParent = _._node2$_parent = null;
      _.isGroupEnd = false;
    },
    NodeImporterResult0: function NodeImporterResult0() {
    },
    _realCasePath0(path) {
      var prefix, t1;
      if (!(J.$eq$(J.get$platform$x(self.process), "win32") || J.$eq$(J.get$platform$x(self.process), "darwin")))
        return path;
      if (J.$eq$(J.get$platform$x(self.process), "win32")) {
        prefix = C.JSString_methods.substring$2(path, 0, $.$get$context().style.rootLength$1(path));
        t1 = prefix.length;
        if (t1 !== 0 && T.isAlphabetic1(C.JSString_methods._codeUnitAt$1(prefix, 0)))
          path = prefix.toUpperCase() + C.JSString_methods.substring$1(path, t1);
      }
      return new F._realCasePath_helper0().call$1(path);
    },
    _realCasePath_helper0: function _realCasePath_helper0() {
    },
    _realCasePath_helper_closure0: function _realCasePath_helper_closure0(t0, t1, t2) {
      this.helper = t0;
      this.dirname = t1;
      this.path = t2;
    },
    _realCasePath_helper__closure0: function _realCasePath_helper__closure0(t0) {
      this.basename = t0;
    },
    _QuietLogger0: function _QuietLogger0() {
    },
    CssMediaQuery0: function CssMediaQuery0(t0, t1, t2) {
      this.modifier = t0;
      this.type = t1;
      this.features = t2;
    },
    _SingletonCssMediaQueryMergeResult0: function _SingletonCssMediaQueryMergeResult0(t0) {
      this._media_query1$_name = t0;
    },
    MediaQuerySuccessfulMergeResult0: function MediaQuerySuccessfulMergeResult0(t0) {
      this.query = t0;
    },
    MediaQueryParser0: function MediaQueryParser0(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    MediaQueryParser_parse_closure0: function MediaQueryParser_parse_closure0(t0) {
      this.$this = t0;
    },
    PrefixedMapView0: function PrefixedMapView0(t0, t1, t2) {
      this._prefixed_map_view0$_map = t0;
      this._prefixed_map_view0$_prefix = t1;
      this.$ti = t2;
    },
    _PrefixedKeys0: function _PrefixedKeys0(t0) {
      this._prefixed_map_view0$_view = t0;
    },
    _PrefixedKeys_iterator_closure0: function _PrefixedKeys_iterator_closure0(t0) {
      this.$this = t0;
    },
    TypeSelector0: function TypeSelector0(t0) {
      this.name = t0;
    },
    CssValue0: function CssValue0(t0, t1, t2) {
      this.value = t0;
      this.span = t1;
      this.$ti = t2;
    },
    ValueExpression0: function ValueExpression0(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    ModifiableCssValue0: function ModifiableCssValue0(t0, t1, t2) {
      this.value = t0;
      this.span = t1;
      this.$ti = t2;
    },
    Value0: function Value0() {
    },
    unwrapValue(object) {
      var value, t1;
      if (object != null) {
        if (object instanceof F.Value0)
          return object;
        value = object.dartValue;
        if (value != null && value instanceof F.Value0)
          return value;
        t1 = self.Error;
        if (H._asBool($.$get$_jsInstanceOf().call$2(object, t1)))
          throw H.wrapException(object);
      }
      throw H.wrapException(H.S(object) + " must be a Sass value type.");
    },
    wrapValue(value) {
      if (value instanceof K.SassColor0)
        return P.callConstructor($.$get$colorConstructor(), [null, null, null, null, value]);
      if (value instanceof D.SassList0)
        return P.callConstructor($.$get$listConstructor(), [null, null, value]);
      if (value instanceof A.SassMap0)
        return P.callConstructor($.$get$mapConstructor(), [null, value]);
      if (value instanceof T.SassNumber0)
        return P.callConstructor($.$get$numberConstructor(), [null, null, value]);
      if (value instanceof D.SassString0)
        return P.callConstructor($.$get$stringConstructor(), [null, value]);
      return value;
    }
  },
  G = {Option: function Option(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12) {
      var _ = this;
      _.name = t0;
      _.abbr = t1;
      _.help = t2;
      _.valueHelp = t3;
      _.allowed = t4;
      _.allowedHelp = t5;
      _.defaultsTo = t6;
      _.negatable = t7;
      _.callback = t8;
      _.type = t9;
      _.splitCommas = t10;
      _.mandatory = t11;
      _.hide = t12;
    }, OptionType: function OptionType(t0) {
      this.name = t0;
    },
    Parser$(_commandName, _grammar, _args, _parent, rest) {
      var t1 = H._setArrayType([], type$.JSArray_String);
      if (rest != null)
        C.JSArray_methods.addAll$1(t1, rest);
      return new G.Parser0(_commandName, _parent, _grammar, _args, t1, P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.dynamic));
    },
    _isLetterOrDigit(codeUnit) {
      var t1;
      if (!(codeUnit >= 65 && codeUnit <= 90))
        if (!(codeUnit >= 97 && codeUnit <= 122))
          t1 = codeUnit >= 48 && codeUnit <= 57;
        else
          t1 = true;
      else
        t1 = true;
      return t1;
    },
    Parser0: function Parser0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._commandName = t0;
      _._parser$_parent = t1;
      _._grammar = t2;
      _._args = t3;
      _._parser$_rest = t4;
      _._results = t5;
    },
    Parser_parse_closure: function Parser_parse_closure(t0) {
      this.$this = t0;
    },
    Parser__setOption_closure: function Parser__setOption_closure() {
    },
    _Usage: function _Usage(t0, t1, t2) {
      var _ = this;
      _._usage$_optionsAndSeparators = t0;
      _._usage$_buffer = t1;
      _._currentColumn = 0;
      _.___Usage__columnWidths = null;
      _._newlinesNeeded = 0;
      _.lineLength = t2;
    },
    _Usage__writeOption_closure: function _Usage__writeOption_closure() {
    },
    _Usage__buildAllowedList_closure: function _Usage__buildAllowedList_closure(t0) {
      this.option = t0;
    },
    StreamQueue: function StreamQueue(t0, t1, t2, t3) {
      var _ = this;
      _._stream_queue$_source = t0;
      _._stream_queue$_subscription = null;
      _._isDone = false;
      _._eventsReceived = 0;
      _._eventQueue = t1;
      _._requestQueue = t2;
      _.$ti = t3;
    },
    StreamQueue__ensureListening_closure: function StreamQueue__ensureListening_closure(t0) {
      this.$this = t0;
    },
    StreamQueue__ensureListening_closure1: function StreamQueue__ensureListening_closure1(t0) {
      this.$this = t0;
    },
    StreamQueue__ensureListening_closure0: function StreamQueue__ensureListening_closure0(t0) {
      this.$this = t0;
    },
    _NextRequest: function _NextRequest(t0, t1) {
      this._completer = t0;
      this.$ti = t1;
    },
    ModifiableCssMediaRule$(queries, span) {
      var t1 = P.List_List$unmodifiable(queries, type$.CssMediaQuery),
        t2 = H._setArrayType([], type$.JSArray_ModifiableCssNode);
      if (J.get$isEmpty$asx(queries))
        H.throwExpression(P.ArgumentError$value(queries, "queries", "may not be empty."));
      return new G.ModifiableCssMediaRule(t1, span, new P.UnmodifiableListView(t2, type$.UnmodifiableListView_ModifiableCssNode), t2);
    },
    ModifiableCssMediaRule: function ModifiableCssMediaRule(t0, t1, t2, t3) {
      var _ = this;
      _.queries = t0;
      _.span = t1;
      _.children = t2;
      _._children = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    MediaRule$(query, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new G.MediaRule(query, span, t1, t2);
    },
    MediaRule: function MediaRule(t0, t1, t2, t3) {
      var _ = this;
      _.query = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    WhileRule$(condition, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new G.WhileRule(condition, span, t1, t2);
    },
    WhileRule: function WhileRule(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    Parser_isIdentifier(text) {
      var t1, t2, exception, logger = null;
      try {
        t1 = logger;
        t2 = S.SpanScanner$(text, null);
        new G.Parser(t2, t1 == null ? C.StderrLogger_false : t1)._parseIdentifier$0();
        return true;
      } catch (exception) {
        if (H.unwrapException(exception) instanceof E.SassFormatException)
          return false;
        else
          throw exception;
      }
    },
    Parser: function Parser(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    Parser__parseIdentifier_closure: function Parser__parseIdentifier_closure(t0) {
      this.$this = t0;
    },
    Parser_scanIdentChar_matches: function Parser_scanIdentChar_matches(t0, t1) {
      this.caseSensitive = t0;
      this.char = t1;
    },
    SourceSpanFormatException$(message, span, source) {
      return new G.SourceSpanFormatException(source, message, span);
    },
    SourceSpanException: function SourceSpanException() {
    },
    SourceSpanFormatException: function SourceSpanFormatException(t0, t1, t2) {
      this.source = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    ModifiableCssMediaRule$0(queries, span) {
      var t1 = P.List_List$unmodifiable(queries, type$.CssMediaQuery_2),
        t2 = H._setArrayType([], type$.JSArray_ModifiableCssNode_2);
      if (J.get$isEmpty$asx(queries))
        H.throwExpression(P.ArgumentError$value(queries, "queries", "may not be empty."));
      return new G.ModifiableCssMediaRule0(t1, span, new P.UnmodifiableListView(t2, type$.UnmodifiableListView_ModifiableCssNode_2), t2);
    },
    ModifiableCssMediaRule0: function ModifiableCssMediaRule0(t0, t1, t2, t3) {
      var _ = this;
      _.queries = t0;
      _.span = t1;
      _.children = t2;
      _._node2$_children = t3;
      _._node2$_indexInParent = _._node2$_parent = null;
      _.isGroupEnd = false;
    },
    MediaRule$0(query, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new G.MediaRule0(query, span, t1, t2);
    },
    MediaRule0: function MediaRule0(t0, t1, t2, t3) {
      var _ = this;
      _.query = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    Parser_isIdentifier0(text) {
      var t1, t2, exception, logger = null;
      try {
        t1 = logger;
        t2 = S.SpanScanner$(text, null);
        new G.Parser1(t2, t1 == null ? C.C_StderrLogger : t1)._parser0$_parseIdentifier$0();
        return true;
      } catch (exception) {
        if (H.unwrapException(exception) instanceof E.SassFormatException0)
          return false;
        else
          throw exception;
      }
    },
    Parser1: function Parser1(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    Parser__parseIdentifier_closure0: function Parser__parseIdentifier_closure0(t0) {
      this.$this = t0;
    },
    Parser_scanIdentChar_matches0: function Parser_scanIdentChar_matches0(t0, t1) {
      this.caseSensitive = t0;
      this.char = t1;
    },
    Types: function Types() {
    },
    WhileRule$0(condition, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new G.WhileRule0(condition, span, t1, t2);
    },
    WhileRule0: function WhileRule0(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    }
  },
  H = {JS_CONST: function JS_CONST() {
    },
    CastIterable_CastIterable(source, $S, $T) {
      if ($S._eval$1("EfficientLengthIterable<0>")._is(source))
        return new H._EfficientLengthCastIterable(source, $S._eval$1("@<0>")._bind$1($T)._eval$1("_EfficientLengthCastIterable<1,2>"));
      return new H.CastIterable(source, $S._eval$1("@<0>")._bind$1($T)._eval$1("CastIterable<1,2>"));
    },
    LateError$fieldADI(fieldName) {
      return new H.LateError("Field '" + fieldName + "' has been assigned during initialization.");
    },
    LateError$fieldNI(fieldName) {
      return new H.LateError("Field '" + fieldName + "' has not been initialized.");
    },
    LateError$localNI(localName) {
      return new H.LateError("Local '" + localName + "' has not been initialized.");
    },
    hexDigitValue(char) {
      var letter,
        digit = char ^ 48;
      if (digit <= 9)
        return digit;
      letter = char | 32;
      if (97 <= letter && letter <= 102)
        return letter - 87;
      return -1;
    },
    checkNotNullable(value, $name, $T) {
      return value;
    },
    SubListIterable$(_iterable, _start, _endOrLength, $E) {
      P.RangeError_checkNotNegative(_start, "start");
      if (_endOrLength != null) {
        P.RangeError_checkNotNegative(_endOrLength, "end");
        if (_start > _endOrLength)
          H.throwExpression(P.RangeError$range(_start, 0, _endOrLength, "start", null));
      }
      return new H.SubListIterable(_iterable, _start, _endOrLength, $E._eval$1("SubListIterable<0>"));
    },
    MappedIterable_MappedIterable(iterable, $function, $S, $T) {
      if (type$.EfficientLengthIterable_dynamic._is(iterable))
        return new H.EfficientLengthMappedIterable(iterable, $function, $S._eval$1("@<0>")._bind$1($T)._eval$1("EfficientLengthMappedIterable<1,2>"));
      return new H.MappedIterable(iterable, $function, $S._eval$1("@<0>")._bind$1($T)._eval$1("MappedIterable<1,2>"));
    },
    TakeIterable_TakeIterable(iterable, takeCount, $E) {
      P.RangeError_checkNotNegative(takeCount, "takeCount");
      if (type$.EfficientLengthIterable_dynamic._is(iterable))
        return new H.EfficientLengthTakeIterable(iterable, takeCount, $E._eval$1("EfficientLengthTakeIterable<0>"));
      return new H.TakeIterable(iterable, takeCount, $E._eval$1("TakeIterable<0>"));
    },
    SkipIterable_SkipIterable(iterable, count, $E) {
      if (type$.EfficientLengthIterable_dynamic._is(iterable)) {
        P.RangeError_checkNotNegative(count, "count");
        return new H.EfficientLengthSkipIterable(iterable, count, $E._eval$1("EfficientLengthSkipIterable<0>"));
      }
      P.RangeError_checkNotNegative(count, "count");
      return new H.SkipIterable(iterable, count, $E._eval$1("SkipIterable<0>"));
    },
    FollowedByIterable_FollowedByIterable$firstEfficient(first, second, $E) {
      if ($E._eval$1("EfficientLengthIterable<0>")._is(second))
        return new H.EfficientLengthFollowedByIterable(first, second, $E._eval$1("EfficientLengthFollowedByIterable<0>"));
      return new H.FollowedByIterable(first, second, $E._eval$1("FollowedByIterable<0>"));
    },
    IterableElementError_noElement() {
      return new P.StateError("No element");
    },
    IterableElementError_tooMany() {
      return new P.StateError("Too many elements");
    },
    IterableElementError_tooFew() {
      return new P.StateError("Too few elements");
    },
    Sort_sort(a, compare) {
      H.Sort__doSort(a, 0, J.get$length$asx(a) - 1, compare);
    },
    Sort__doSort(a, left, right, compare) {
      if (right - left <= 32)
        H.Sort__insertionSort(a, left, right, compare);
      else
        H.Sort__dualPivotQuicksort(a, left, right, compare);
    },
    Sort__insertionSort(a, left, right, compare) {
      var i, t1, el, j, j0;
      for (i = left + 1, t1 = J.getInterceptor$asx(a); i <= right; ++i) {
        el = t1.$index(a, i);
        j = i;
        while (true) {
          if (!(j > left && compare.call$2(t1.$index(a, j - 1), el) > 0))
            break;
          j0 = j - 1;
          t1.$indexSet(a, j, t1.$index(a, j0));
          j = j0;
        }
        t1.$indexSet(a, j, el);
      }
    },
    Sort__dualPivotQuicksort(a, left, right, compare) {
      var t0, less, great, k, ak, comp, great0, less0, pivots_are_equal, t2,
        sixth = C.JSInt_methods._tdivFast$1(right - left + 1, 6),
        index1 = left + sixth,
        index5 = right - sixth,
        index3 = C.JSInt_methods._tdivFast$1(left + right, 2),
        index2 = index3 - sixth,
        index4 = index3 + sixth,
        t1 = J.getInterceptor$asx(a),
        el1 = t1.$index(a, index1),
        el2 = t1.$index(a, index2),
        el3 = t1.$index(a, index3),
        el4 = t1.$index(a, index4),
        el5 = t1.$index(a, index5);
      if (compare.call$2(el1, el2) > 0) {
        t0 = el2;
        el2 = el1;
        el1 = t0;
      }
      if (compare.call$2(el4, el5) > 0) {
        t0 = el5;
        el5 = el4;
        el4 = t0;
      }
      if (compare.call$2(el1, el3) > 0) {
        t0 = el3;
        el3 = el1;
        el1 = t0;
      }
      if (compare.call$2(el2, el3) > 0) {
        t0 = el3;
        el3 = el2;
        el2 = t0;
      }
      if (compare.call$2(el1, el4) > 0) {
        t0 = el4;
        el4 = el1;
        el1 = t0;
      }
      if (compare.call$2(el3, el4) > 0) {
        t0 = el4;
        el4 = el3;
        el3 = t0;
      }
      if (compare.call$2(el2, el5) > 0) {
        t0 = el5;
        el5 = el2;
        el2 = t0;
      }
      if (compare.call$2(el2, el3) > 0) {
        t0 = el3;
        el3 = el2;
        el2 = t0;
      }
      if (compare.call$2(el4, el5) > 0) {
        t0 = el5;
        el5 = el4;
        el4 = t0;
      }
      t1.$indexSet(a, index1, el1);
      t1.$indexSet(a, index3, el3);
      t1.$indexSet(a, index5, el5);
      t1.$indexSet(a, index2, t1.$index(a, left));
      t1.$indexSet(a, index4, t1.$index(a, right));
      less = left + 1;
      great = right - 1;
      if (J.$eq$(compare.call$2(el2, el4), 0)) {
        for (k = less; k <= great; ++k) {
          ak = t1.$index(a, k);
          comp = compare.call$2(ak, el2);
          if (comp === 0)
            continue;
          if (comp < 0) {
            if (k !== less) {
              t1.$indexSet(a, k, t1.$index(a, less));
              t1.$indexSet(a, less, ak);
            }
            ++less;
          } else
            for (; true;) {
              comp = compare.call$2(t1.$index(a, great), el2);
              if (comp > 0) {
                --great;
                continue;
              } else {
                great0 = great - 1;
                if (comp < 0) {
                  t1.$indexSet(a, k, t1.$index(a, less));
                  less0 = less + 1;
                  t1.$indexSet(a, less, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  great = great0;
                  less = less0;
                  break;
                } else {
                  t1.$indexSet(a, k, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  great = great0;
                  break;
                }
              }
            }
        }
        pivots_are_equal = true;
      } else {
        for (k = less; k <= great; ++k) {
          ak = t1.$index(a, k);
          if (compare.call$2(ak, el2) < 0) {
            if (k !== less) {
              t1.$indexSet(a, k, t1.$index(a, less));
              t1.$indexSet(a, less, ak);
            }
            ++less;
          } else if (compare.call$2(ak, el4) > 0)
            for (; true;)
              if (compare.call$2(t1.$index(a, great), el4) > 0) {
                --great;
                if (great < k)
                  break;
                continue;
              } else {
                great0 = great - 1;
                if (compare.call$2(t1.$index(a, great), el2) < 0) {
                  t1.$indexSet(a, k, t1.$index(a, less));
                  less0 = less + 1;
                  t1.$indexSet(a, less, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  less = less0;
                } else {
                  t1.$indexSet(a, k, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                }
                great = great0;
                break;
              }
        }
        pivots_are_equal = false;
      }
      t2 = less - 1;
      t1.$indexSet(a, left, t1.$index(a, t2));
      t1.$indexSet(a, t2, el2);
      t2 = great + 1;
      t1.$indexSet(a, right, t1.$index(a, t2));
      t1.$indexSet(a, t2, el4);
      H.Sort__doSort(a, left, less - 2, compare);
      H.Sort__doSort(a, great + 2, right, compare);
      if (pivots_are_equal)
        return;
      if (less < index1 && great > index5) {
        for (; J.$eq$(compare.call$2(t1.$index(a, less), el2), 0);)
          ++less;
        for (; J.$eq$(compare.call$2(t1.$index(a, great), el4), 0);)
          --great;
        for (k = less; k <= great; ++k) {
          ak = t1.$index(a, k);
          if (compare.call$2(ak, el2) === 0) {
            if (k !== less) {
              t1.$indexSet(a, k, t1.$index(a, less));
              t1.$indexSet(a, less, ak);
            }
            ++less;
          } else if (compare.call$2(ak, el4) === 0)
            for (; true;)
              if (compare.call$2(t1.$index(a, great), el4) === 0) {
                --great;
                if (great < k)
                  break;
                continue;
              } else {
                great0 = great - 1;
                if (compare.call$2(t1.$index(a, great), el2) < 0) {
                  t1.$indexSet(a, k, t1.$index(a, less));
                  less0 = less + 1;
                  t1.$indexSet(a, less, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  less = less0;
                } else {
                  t1.$indexSet(a, k, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                }
                great = great0;
                break;
              }
        }
        H.Sort__doSort(a, less, great, compare);
      } else
        H.Sort__doSort(a, less, great, compare);
    },
    _CastIterableBase: function _CastIterableBase() {
    },
    CastIterator: function CastIterator(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    CastIterable: function CastIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    _EfficientLengthCastIterable: function _EfficientLengthCastIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    _CastListBase: function _CastListBase() {
    },
    _CastListBase_sort_closure: function _CastListBase_sort_closure(t0, t1) {
      this.$this = t0;
      this.compare = t1;
    },
    CastList: function CastList(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    CastSet: function CastSet(t0, t1, t2) {
      this._source = t0;
      this._emptySet = t1;
      this.$ti = t2;
    },
    CastMap: function CastMap(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    CastMap_forEach_closure: function CastMap_forEach_closure(t0, t1) {
      this.$this = t0;
      this.f = t1;
    },
    CastMap_entries_closure: function CastMap_entries_closure(t0) {
      this.$this = t0;
    },
    LateError: function LateError(t0) {
      this._message = t0;
    },
    CodeUnits: function CodeUnits(t0) {
      this._string = t0;
    },
    nullFuture_closure: function nullFuture_closure() {
    },
    EfficientLengthIterable: function EfficientLengthIterable() {
    },
    ListIterable: function ListIterable() {
    },
    SubListIterable: function SubListIterable(t0, t1, t2, t3) {
      var _ = this;
      _.__internal$_iterable = t0;
      _._start = t1;
      _._endOrLength = t2;
      _.$ti = t3;
    },
    ListIterator: function ListIterator(t0, t1) {
      var _ = this;
      _.__internal$_iterable = t0;
      _.__internal$_length = t1;
      _.__internal$_index = 0;
      _.__internal$_current = null;
    },
    MappedIterable: function MappedIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    EfficientLengthMappedIterable: function EfficientLengthMappedIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    MappedIterator: function MappedIterator(t0, t1) {
      this.__internal$_current = null;
      this._iterator = t0;
      this._f = t1;
    },
    MappedListIterable: function MappedListIterable(t0, t1, t2) {
      this._source = t0;
      this._f = t1;
      this.$ti = t2;
    },
    WhereIterable: function WhereIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    WhereIterator: function WhereIterator(t0, t1) {
      this._iterator = t0;
      this._f = t1;
    },
    ExpandIterable: function ExpandIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    ExpandIterator: function ExpandIterator(t0, t1, t2) {
      var _ = this;
      _._iterator = t0;
      _._f = t1;
      _._currentExpansion = t2;
      _.__internal$_current = null;
    },
    TakeIterable: function TakeIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._takeCount = t1;
      this.$ti = t2;
    },
    EfficientLengthTakeIterable: function EfficientLengthTakeIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._takeCount = t1;
      this.$ti = t2;
    },
    TakeIterator: function TakeIterator(t0, t1) {
      this._iterator = t0;
      this._remaining = t1;
    },
    SkipIterable: function SkipIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._skipCount = t1;
      this.$ti = t2;
    },
    EfficientLengthSkipIterable: function EfficientLengthSkipIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._skipCount = t1;
      this.$ti = t2;
    },
    SkipIterator: function SkipIterator(t0, t1) {
      this._iterator = t0;
      this._skipCount = t1;
    },
    SkipWhileIterable: function SkipWhileIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    SkipWhileIterator: function SkipWhileIterator(t0, t1) {
      this._iterator = t0;
      this._f = t1;
      this._hasSkipped = false;
    },
    EmptyIterable: function EmptyIterable(t0) {
      this.$ti = t0;
    },
    EmptyIterator: function EmptyIterator() {
    },
    FollowedByIterable: function FollowedByIterable(t0, t1, t2) {
      this.__internal$_first = t0;
      this._second = t1;
      this.$ti = t2;
    },
    EfficientLengthFollowedByIterable: function EfficientLengthFollowedByIterable(t0, t1, t2) {
      this.__internal$_first = t0;
      this._second = t1;
      this.$ti = t2;
    },
    FollowedByIterator: function FollowedByIterator(t0, t1) {
      this._currentIterator = t0;
      this._nextIterable = t1;
    },
    WhereTypeIterable: function WhereTypeIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    WhereTypeIterator: function WhereTypeIterator(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    FixedLengthListMixin: function FixedLengthListMixin() {
    },
    UnmodifiableListMixin: function UnmodifiableListMixin() {
    },
    UnmodifiableListBase: function UnmodifiableListBase() {
    },
    ReversedListIterable: function ReversedListIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    Symbol: function Symbol(t0) {
      this.__internal$_name = t0;
    },
    __CastListBase__CastIterableBase_ListMixin: function __CastListBase__CastIterableBase_ListMixin() {
    },
    ConstantMap_ConstantMap$from(other, $K, $V) {
      var allStrings, k, object, t2,
        keys = P.List_List$from(other.get$keys(other), true, $K),
        t1 = keys.length,
        _i = 0;
      while (true) {
        if (!(_i < t1)) {
          allStrings = true;
          break;
        }
        k = keys[_i];
        if (typeof k != "string" || "__proto__" === k) {
          allStrings = false;
          break;
        }
        ++_i;
      }
      if (allStrings) {
        object = {};
        for (_i = 0; t2 = keys.length, _i < t2; keys.length === t1 || (0, H.throwConcurrentModificationError)(keys), ++_i) {
          k = keys[_i];
          object[k] = other.$index(0, k);
        }
        return new H.ConstantStringMap(t2, object, keys, $K._eval$1("@<0>")._bind$1($V)._eval$1("ConstantStringMap<1,2>"));
      }
      return new H.ConstantMapView(P.LinkedHashMap_LinkedHashMap$from(other, $K, $V), $K._eval$1("@<0>")._bind$1($V)._eval$1("ConstantMapView<1,2>"));
    },
    ConstantMap__throwUnmodifiable() {
      throw H.wrapException(P.UnsupportedError$("Cannot modify unmodifiable Map"));
    },
    instantiate1(f, T1) {
      var t1 = new H.Instantiation1(f, T1._eval$1("Instantiation1<0>"));
      t1.Instantiation$1(f);
      return t1;
    },
    unminifyOrTag(rawClassName) {
      var preserved = init.mangledGlobalNames[rawClassName];
      if (preserved != null)
        return preserved;
      return rawClassName;
    },
    isJsIndexable(object, record) {
      var result;
      if (record != null) {
        result = record.x;
        if (result != null)
          return result;
      }
      return type$.JavaScriptIndexingBehavior_dynamic._is(object);
    },
    S(value) {
      var res;
      if (typeof value == "string")
        return value;
      if (typeof value == "number") {
        if (value !== 0)
          return "" + value;
      } else if (true === value)
        return "true";
      else if (false === value)
        return "false";
      else if (value == null)
        return "null";
      res = J.toString$0$(value);
      return res;
    },
    Primitives_objectHashCode(object) {
      var hash = object.$identityHash;
      if (hash == null) {
        hash = Math.random() * 0x3fffffff | 0;
        object.$identityHash = hash;
      }
      return hash;
    },
    Primitives_parseInt(source, radix) {
      var decimalMatch, maxCharCode, digitsPart, t1, i, _null = null,
        match = /^\s*[+-]?((0x[a-f0-9]+)|(\d+)|([a-z0-9]+))\s*$/i.exec(source);
      if (match == null)
        return _null;
      decimalMatch = match[3];
      if (radix == null) {
        if (decimalMatch != null)
          return parseInt(source, 10);
        if (match[2] != null)
          return parseInt(source, 16);
        return _null;
      }
      if (radix < 2 || radix > 36)
        throw H.wrapException(P.RangeError$range(radix, 2, 36, "radix", _null));
      if (radix === 10 && decimalMatch != null)
        return parseInt(source, 10);
      if (radix < 10 || decimalMatch == null) {
        maxCharCode = radix <= 10 ? 47 + radix : 86 + radix;
        digitsPart = match[1];
        for (t1 = digitsPart.length, i = 0; i < t1; ++i)
          if ((C.JSString_methods._codeUnitAt$1(digitsPart, i) | 32) > maxCharCode)
            return _null;
      }
      return parseInt(source, radix);
    },
    Primitives_parseDouble(source) {
      var result, trimmed;
      if (!/^\s*[+-]?(?:Infinity|NaN|(?:\.\d+|\d+(?:\.\d*)?)(?:[eE][+-]?\d+)?)\s*$/.test(source))
        return null;
      result = parseFloat(source);
      if (isNaN(result)) {
        trimmed = C.JSString_methods.trim$0(source);
        if (trimmed === "NaN" || trimmed === "+NaN" || trimmed === "-NaN")
          return result;
        return null;
      }
      return result;
    },
    Primitives_objectTypeName(object) {
      return H.Primitives__objectTypeNameNewRti(object);
    },
    Primitives__objectTypeNameNewRti(object) {
      var dispatchName, t1, $constructor, constructorName;
      if (object instanceof P.Object)
        return H._rtiToString(H.instanceType(object), null);
      if (J.getInterceptor$(object) === C.Interceptor_methods || type$.UnknownJavaScriptObject._is(object)) {
        dispatchName = C.C_JS_CONST(object);
        t1 = dispatchName !== "Object" && dispatchName !== "";
        if (t1)
          return dispatchName;
        $constructor = object.constructor;
        if (typeof $constructor == "function") {
          constructorName = $constructor.name;
          if (typeof constructorName == "string")
            t1 = constructorName !== "Object" && constructorName !== "";
          else
            t1 = false;
          if (t1)
            return constructorName;
        }
      }
      return H._rtiToString(H.instanceType(object), null);
    },
    Primitives_currentUri() {
      if (!!self.location)
        return self.location.href;
      return null;
    },
    Primitives__fromCharCodeApply(array) {
      var result, i, i0, chunkEnd,
        end = array.length;
      if (end <= 500)
        return String.fromCharCode.apply(null, array);
      for (result = "", i = 0; i < end; i = i0) {
        i0 = i + 500;
        chunkEnd = i0 < end ? i0 : end;
        result += String.fromCharCode.apply(null, array.slice(i, chunkEnd));
      }
      return result;
    },
    Primitives_stringFromCodePoints(codePoints) {
      var t1, _i, i,
        a = H._setArrayType([], type$.JSArray_int);
      for (t1 = codePoints.length, _i = 0; _i < codePoints.length; codePoints.length === t1 || (0, H.throwConcurrentModificationError)(codePoints), ++_i) {
        i = codePoints[_i];
        if (!H._isInt(i))
          throw H.wrapException(H.argumentErrorValue(i));
        if (i <= 65535)
          a.push(i);
        else if (i <= 1114111) {
          a.push(55296 + (C.JSInt_methods._shrOtherPositive$1(i - 65536, 10) & 1023));
          a.push(56320 + (i & 1023));
        } else
          throw H.wrapException(H.argumentErrorValue(i));
      }
      return H.Primitives__fromCharCodeApply(a);
    },
    Primitives_stringFromCharCodes(charCodes) {
      var t1, _i, i;
      for (t1 = charCodes.length, _i = 0; _i < t1; ++_i) {
        i = charCodes[_i];
        if (!H._isInt(i))
          throw H.wrapException(H.argumentErrorValue(i));
        if (i < 0)
          throw H.wrapException(H.argumentErrorValue(i));
        if (i > 65535)
          return H.Primitives_stringFromCodePoints(charCodes);
      }
      return H.Primitives__fromCharCodeApply(charCodes);
    },
    Primitives_stringFromNativeUint8List(charCodes, start, end) {
      var i, result, i0, chunkEnd;
      if (end <= 500 && start === 0 && end === charCodes.length)
        return String.fromCharCode.apply(null, charCodes);
      for (i = start, result = ""; i < end; i = i0) {
        i0 = i + 500;
        chunkEnd = i0 < end ? i0 : end;
        result += String.fromCharCode.apply(null, charCodes.subarray(i, chunkEnd));
      }
      return result;
    },
    Primitives_stringFromCharCode(charCode) {
      var bits;
      if (0 <= charCode) {
        if (charCode <= 65535)
          return String.fromCharCode(charCode);
        if (charCode <= 1114111) {
          bits = charCode - 65536;
          return String.fromCharCode((C.JSInt_methods._shrOtherPositive$1(bits, 10) | 55296) >>> 0, bits & 1023 | 56320);
        }
      }
      throw H.wrapException(P.RangeError$range(charCode, 0, 1114111, null, null));
    },
    Primitives_lazyAsJsDate(receiver) {
      if (receiver.date === void 0)
        receiver.date = new Date(receiver._core$_value);
      return receiver.date;
    },
    Primitives_getYear(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getFullYear() + 0;
      return t1;
    },
    Primitives_getMonth(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getMonth() + 1;
      return t1;
    },
    Primitives_getDay(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getDate() + 0;
      return t1;
    },
    Primitives_getHours(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getHours() + 0;
      return t1;
    },
    Primitives_getMinutes(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getMinutes() + 0;
      return t1;
    },
    Primitives_getSeconds(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getSeconds() + 0;
      return t1;
    },
    Primitives_getMilliseconds(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getMilliseconds() + 0;
      return t1;
    },
    Primitives_functionNoSuchMethod($function, positionalArguments, namedArguments) {
      var $arguments, namedArgumentList, t1 = {};
      t1.argumentCount = 0;
      $arguments = [];
      namedArgumentList = [];
      t1.argumentCount = positionalArguments.length;
      C.JSArray_methods.addAll$1($arguments, positionalArguments);
      t1.names = "";
      if (namedArguments != null && !namedArguments.get$isEmpty(namedArguments))
        namedArguments.forEach$1(0, new H.Primitives_functionNoSuchMethod_closure(t1, namedArgumentList, $arguments));
      "" + t1.argumentCount;
      return J.noSuchMethod$1$($function, new H.JSInvocationMirror(C.Symbol_call, 0, $arguments, namedArgumentList, 0));
    },
    Primitives_applyFunction($function, positionalArguments, namedArguments) {
      var t1, argumentCount, jsStub;
      if (Array.isArray(positionalArguments))
        t1 = namedArguments == null || namedArguments.get$isEmpty(namedArguments);
      else
        t1 = false;
      if (t1) {
        argumentCount = positionalArguments.length;
        if (argumentCount === 0) {
          if (!!$function.call$0)
            return $function.call$0();
        } else if (argumentCount === 1) {
          if (!!$function.call$1)
            return $function.call$1(positionalArguments[0]);
        } else if (argumentCount === 2) {
          if (!!$function.call$2)
            return $function.call$2(positionalArguments[0], positionalArguments[1]);
        } else if (argumentCount === 3) {
          if (!!$function.call$3)
            return $function.call$3(positionalArguments[0], positionalArguments[1], positionalArguments[2]);
        } else if (argumentCount === 4) {
          if (!!$function.call$4)
            return $function.call$4(positionalArguments[0], positionalArguments[1], positionalArguments[2], positionalArguments[3]);
        } else if (argumentCount === 5)
          if (!!$function.call$5)
            return $function.call$5(positionalArguments[0], positionalArguments[1], positionalArguments[2], positionalArguments[3], positionalArguments[4]);
        jsStub = $function["call" + "$" + argumentCount];
        if (jsStub != null)
          return jsStub.apply($function, positionalArguments);
      }
      return H.Primitives__generalApplyFunction($function, positionalArguments, namedArguments);
    },
    Primitives__generalApplyFunction($function, positionalArguments, namedArguments) {
      var defaultValuesClosure, t1, defaultValues, interceptor, jsFunction, maxArguments, missingDefaults, keys, _i, defaultValue, used, t2,
        $arguments = Array.isArray(positionalArguments) ? positionalArguments : P.List_List$of(positionalArguments, true, type$.dynamic),
        argumentCount = $arguments.length,
        requiredParameterCount = $function.$requiredArgCount;
      if (argumentCount < requiredParameterCount)
        return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
      defaultValuesClosure = $function.$defaultValues;
      t1 = defaultValuesClosure == null;
      defaultValues = !t1 ? defaultValuesClosure() : null;
      interceptor = J.getInterceptor$($function);
      jsFunction = interceptor["call*"];
      if (typeof jsFunction == "string")
        jsFunction = interceptor[jsFunction];
      if (t1) {
        if (namedArguments != null && namedArguments.get$isNotEmpty(namedArguments))
          return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        if (argumentCount === requiredParameterCount)
          return jsFunction.apply($function, $arguments);
        return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
      }
      if (Array.isArray(defaultValues)) {
        if (namedArguments != null && namedArguments.get$isNotEmpty(namedArguments))
          return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        maxArguments = requiredParameterCount + defaultValues.length;
        if (argumentCount > maxArguments)
          return H.Primitives_functionNoSuchMethod($function, $arguments, null);
        if (argumentCount < maxArguments) {
          missingDefaults = defaultValues.slice(argumentCount - requiredParameterCount);
          if ($arguments === positionalArguments)
            $arguments = P.List_List$of($arguments, true, type$.dynamic);
          C.JSArray_methods.addAll$1($arguments, missingDefaults);
        }
        return jsFunction.apply($function, $arguments);
      } else {
        if (argumentCount > requiredParameterCount)
          return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        if ($arguments === positionalArguments)
          $arguments = P.List_List$of($arguments, true, type$.dynamic);
        keys = Object.keys(defaultValues);
        if (namedArguments == null)
          for (t1 = keys.length, _i = 0; _i < keys.length; keys.length === t1 || (0, H.throwConcurrentModificationError)(keys), ++_i) {
            defaultValue = defaultValues[keys[_i]];
            if (C.C__Required === defaultValue)
              return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
            C.JSArray_methods.add$1($arguments, defaultValue);
          }
        else {
          for (t1 = keys.length, used = 0, _i = 0; _i < keys.length; keys.length === t1 || (0, H.throwConcurrentModificationError)(keys), ++_i) {
            t2 = keys[_i];
            if (namedArguments.containsKey$1(t2)) {
              ++used;
              C.JSArray_methods.add$1($arguments, namedArguments.$index(0, t2));
            } else {
              defaultValue = defaultValues[t2];
              if (C.C__Required === defaultValue)
                return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
              C.JSArray_methods.add$1($arguments, defaultValue);
            }
          }
          if (used !== namedArguments.get$length(namedArguments))
            return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        }
        return jsFunction.apply($function, $arguments);
      }
    },
    diagnoseIndexError(indexable, index) {
      var $length, _s5_ = "index";
      if (!H._isInt(index))
        return new P.ArgumentError(true, index, _s5_, null);
      $length = J.get$length$asx(indexable);
      if (index < 0 || index >= $length)
        return P.IndexError$(index, indexable, _s5_, null, $length);
      return P.RangeError$value(index, _s5_, null);
    },
    diagnoseRangeError(start, end, $length) {
      if (start < 0 || start > $length)
        return P.RangeError$range(start, 0, $length, "start", null);
      if (end != null)
        if (end < start || end > $length)
          return P.RangeError$range(end, start, $length, "end", null);
      return new P.ArgumentError(true, end, "end", null);
    },
    argumentErrorValue(object) {
      return new P.ArgumentError(true, object, null, null);
    },
    checkNum(value) {
      return value;
    },
    wrapException(ex) {
      var wrapper, t1;
      if (ex == null)
        ex = new P.NullThrownError();
      wrapper = new Error();
      wrapper.dartException = ex;
      t1 = H.toStringWrapper;
      if ("defineProperty" in Object) {
        Object.defineProperty(wrapper, "message", {get: t1});
        wrapper.name = "";
      } else
        wrapper.toString = t1;
      return wrapper;
    },
    toStringWrapper() {
      return J.toString$0$(this.dartException);
    },
    throwExpression(ex) {
      throw H.wrapException(ex);
    },
    throwConcurrentModificationError(collection) {
      throw H.wrapException(P.ConcurrentModificationError$(collection));
    },
    TypeErrorDecoder_extractPattern(message) {
      var match, $arguments, argumentsExpr, expr, method, receiver;
      message = H.quoteStringForRegExp(message.replace(String({}), "$receiver$"));
      match = message.match(/\\\$[a-zA-Z]+\\\$/g);
      if (match == null)
        match = H._setArrayType([], type$.JSArray_String);
      $arguments = match.indexOf("\\$arguments\\$");
      argumentsExpr = match.indexOf("\\$argumentsExpr\\$");
      expr = match.indexOf("\\$expr\\$");
      method = match.indexOf("\\$method\\$");
      receiver = match.indexOf("\\$receiver\\$");
      return new H.TypeErrorDecoder(message.replace(new RegExp("\\\\\\$arguments\\\\\\$", "g"), "((?:x|[^x])*)").replace(new RegExp("\\\\\\$argumentsExpr\\\\\\$", "g"), "((?:x|[^x])*)").replace(new RegExp("\\\\\\$expr\\\\\\$", "g"), "((?:x|[^x])*)").replace(new RegExp("\\\\\\$method\\\\\\$", "g"), "((?:x|[^x])*)").replace(new RegExp("\\\\\\$receiver\\\\\\$", "g"), "((?:x|[^x])*)"), $arguments, argumentsExpr, expr, method, receiver);
    },
    TypeErrorDecoder_provokeCallErrorOn(expression) {
      return function($expr$) {
        var $argumentsExpr$ = "$arguments$";
        try {
          $expr$.$method$($argumentsExpr$);
        } catch (e) {
          return e.message;
        }
      }(expression);
    },
    TypeErrorDecoder_provokePropertyErrorOn(expression) {
      return function($expr$) {
        try {
          $expr$.$method$;
        } catch (e) {
          return e.message;
        }
      }(expression);
    },
    JsNoSuchMethodError$(_message, match) {
      var t1 = match == null,
        t2 = t1 ? null : match.method;
      return new H.JsNoSuchMethodError(_message, t2, t1 ? null : match.receiver);
    },
    unwrapException(ex) {
      if (ex == null)
        return new H.NullThrownFromJavaScriptException(ex);
      if (ex instanceof H.ExceptionAndStackTrace)
        return H.saveStackTrace(ex, ex.dartException);
      if (typeof ex !== "object")
        return ex;
      if ("dartException" in ex)
        return H.saveStackTrace(ex, ex.dartException);
      return H._unwrapNonDartException(ex);
    },
    saveStackTrace(ex, error) {
      if (type$.Error._is(error))
        if (error.$thrownJsError == null)
          error.$thrownJsError = ex;
      return error;
    },
    _unwrapNonDartException(ex) {
      var message, number, ieErrorCode, t1, nsme, notClosure, nullCall, nullLiteralCall, undefCall, undefLiteralCall, nullProperty, undefProperty, undefLiteralProperty, match, _null = null;
      if (!("message" in ex))
        return ex;
      message = ex.message;
      if ("number" in ex && typeof ex.number == "number") {
        number = ex.number;
        ieErrorCode = number & 65535;
        if ((C.JSInt_methods._shrOtherPositive$1(number, 16) & 8191) === 10)
          switch (ieErrorCode) {
            case 438:
              return H.saveStackTrace(ex, H.JsNoSuchMethodError$(H.S(message) + " (Error " + ieErrorCode + ")", _null));
            case 445:
            case 5007:
              t1 = H.S(message) + " (Error " + ieErrorCode + ")";
              return H.saveStackTrace(ex, new H.NullError(t1, _null));
          }
      }
      if (ex instanceof TypeError) {
        nsme = $.$get$TypeErrorDecoder_noSuchMethodPattern();
        notClosure = $.$get$TypeErrorDecoder_notClosurePattern();
        nullCall = $.$get$TypeErrorDecoder_nullCallPattern();
        nullLiteralCall = $.$get$TypeErrorDecoder_nullLiteralCallPattern();
        undefCall = $.$get$TypeErrorDecoder_undefinedCallPattern();
        undefLiteralCall = $.$get$TypeErrorDecoder_undefinedLiteralCallPattern();
        nullProperty = $.$get$TypeErrorDecoder_nullPropertyPattern();
        $.$get$TypeErrorDecoder_nullLiteralPropertyPattern();
        undefProperty = $.$get$TypeErrorDecoder_undefinedPropertyPattern();
        undefLiteralProperty = $.$get$TypeErrorDecoder_undefinedLiteralPropertyPattern();
        match = nsme.matchTypeError$1(message);
        if (match != null)
          return H.saveStackTrace(ex, H.JsNoSuchMethodError$(message, match));
        else {
          match = notClosure.matchTypeError$1(message);
          if (match != null) {
            match.method = "call";
            return H.saveStackTrace(ex, H.JsNoSuchMethodError$(message, match));
          } else {
            match = nullCall.matchTypeError$1(message);
            if (match == null) {
              match = nullLiteralCall.matchTypeError$1(message);
              if (match == null) {
                match = undefCall.matchTypeError$1(message);
                if (match == null) {
                  match = undefLiteralCall.matchTypeError$1(message);
                  if (match == null) {
                    match = nullProperty.matchTypeError$1(message);
                    if (match == null) {
                      match = nullLiteralCall.matchTypeError$1(message);
                      if (match == null) {
                        match = undefProperty.matchTypeError$1(message);
                        if (match == null) {
                          match = undefLiteralProperty.matchTypeError$1(message);
                          t1 = match != null;
                        } else
                          t1 = true;
                      } else
                        t1 = true;
                    } else
                      t1 = true;
                  } else
                    t1 = true;
                } else
                  t1 = true;
              } else
                t1 = true;
            } else
              t1 = true;
            if (t1)
              return H.saveStackTrace(ex, new H.NullError(message, match == null ? _null : match.method));
          }
        }
        return H.saveStackTrace(ex, new H.UnknownJsTypeError(typeof message == "string" ? message : ""));
      }
      if (ex instanceof RangeError) {
        if (typeof message == "string" && message.indexOf("call stack") !== -1)
          return new P.StackOverflowError();
        message = function(ex) {
          try {
            return String(ex);
          } catch (e) {
          }
          return null;
        }(ex);
        return H.saveStackTrace(ex, new P.ArgumentError(false, _null, _null, typeof message == "string" ? message.replace(/^RangeError:\s*/, "") : message));
      }
      if (typeof InternalError == "function" && ex instanceof InternalError)
        if (typeof message == "string" && message === "too much recursion")
          return new P.StackOverflowError();
      return ex;
    },
    getTraceFromException(exception) {
      var trace;
      if (exception instanceof H.ExceptionAndStackTrace)
        return exception.stackTrace;
      if (exception == null)
        return new H._StackTrace(exception);
      trace = exception.$cachedTrace;
      if (trace != null)
        return trace;
      return exception.$cachedTrace = new H._StackTrace(exception);
    },
    objectHashCode(object) {
      if (object == null || typeof object != "object")
        return J.get$hashCode$(object);
      else
        return H.Primitives_objectHashCode(object);
    },
    fillLiteralMap(keyValuePairs, result) {
      var index, index0, index1,
        $length = keyValuePairs.length;
      for (index = 0; index < $length; index = index1) {
        index0 = index + 1;
        index1 = index0 + 1;
        result.$indexSet(0, keyValuePairs[index], keyValuePairs[index0]);
      }
      return result;
    },
    fillLiteralSet(values, result) {
      var index,
        $length = values.length;
      for (index = 0; index < $length; ++index)
        result.add$1(0, values[index]);
      return result;
    },
    invokeClosure(closure, numberOfArguments, arg1, arg2, arg3, arg4) {
      switch (numberOfArguments) {
        case 0:
          return closure.call$0();
        case 1:
          return closure.call$1(arg1);
        case 2:
          return closure.call$2(arg1, arg2);
        case 3:
          return closure.call$3(arg1, arg2, arg3);
        case 4:
          return closure.call$4(arg1, arg2, arg3, arg4);
      }
      throw H.wrapException(new P._Exception("Unsupported number of arguments for wrapped closure"));
    },
    convertDartClosureToJS(closure, arity) {
      var $function;
      if (closure == null)
        return null;
      $function = closure.$identity;
      if (!!$function)
        return $function;
      $function = function(closure, arity, invoke) {
        return function(a1, a2, a3, a4) {
          return invoke(closure, arity, a1, a2, a3, a4);
        };
      }(closure, arity, H.invokeClosure);
      closure.$identity = $function;
      return $function;
    },
    Closure_fromTearOff(parameters) {
      var $prototype, $constructor, t2, trampoline, applyTrampoline, i, stub, stub0, stubName, stubCallName,
        container = parameters.co,
        isStatic = parameters.iS,
        isIntercepted = parameters.iI,
        needsDirectAccess = parameters.nDA,
        applyTrampolineIndex = parameters.aI,
        funsOrNames = parameters.fs,
        callNames = parameters.cs,
        $name = funsOrNames[0],
        callName = callNames[0],
        $function = container[$name],
        t1 = parameters.fT;
      t1.toString;
      $prototype = isStatic ? Object.create(new H.StaticClosure().constructor.prototype) : Object.create(new H.BoundClosure(null, null).constructor.prototype);
      $prototype.$initialize = $prototype.constructor;
      if (isStatic)
        $constructor = function static_tear_off() {
          this.$initialize();
        };
      else {
        t2 = $.Closure_functionCounter;
        $.Closure_functionCounter = t2 + 1;
        t2 = new Function("a,b" + t2, "this.$initialize(a,b" + t2 + ")");
        $constructor = t2;
      }
      $prototype.constructor = $constructor;
      $constructor.prototype = $prototype;
      $prototype.$_name = $name;
      $prototype.$_target = $function;
      t2 = !isStatic;
      if (t2)
        trampoline = H.Closure_forwardCallTo($name, $function, isIntercepted, needsDirectAccess);
      else {
        $prototype.$static_name = $name;
        trampoline = $function;
      }
      $prototype.$signature = H.Closure__computeSignatureFunctionNewRti(t1, isStatic, isIntercepted);
      $prototype[callName] = trampoline;
      for (applyTrampoline = trampoline, i = 1; i < funsOrNames.length; ++i) {
        stub = funsOrNames[i];
        if (typeof stub == "string") {
          stub0 = container[stub];
          stubName = stub;
          stub = stub0;
        } else
          stubName = "";
        stubCallName = callNames[i];
        if (stubCallName != null) {
          if (t2)
            stub = H.Closure_forwardCallTo(stubName, stub, isIntercepted, needsDirectAccess);
          $prototype[stubCallName] = stub;
        }
        if (i === applyTrampolineIndex)
          applyTrampoline = stub;
      }
      $prototype["call*"] = applyTrampoline;
      $prototype.$requiredArgCount = parameters.rC;
      $prototype.$defaultValues = parameters.dV;
      return $constructor;
    },
    Closure__computeSignatureFunctionNewRti(functionType, isStatic, isIntercepted) {
      if (typeof functionType == "number")
        return functionType;
      if (typeof functionType == "string") {
        if (isStatic)
          throw H.wrapException("Cannot compute signature for static tearoff.");
        return function(recipe, evalOnReceiver) {
          return function() {
            return evalOnReceiver(this, recipe);
          };
        }(functionType, H.BoundClosure_evalRecipe);
      }
      throw H.wrapException("Error in functionType of tearoff");
    },
    Closure_cspForwardCall(arity, needsDirectAccess, stubName, $function) {
      var getReceiver = H.BoundClosure_receiverOf;
      switch (needsDirectAccess ? -1 : arity) {
        case 0:
          return function(entry, receiverOf) {
            return function() {
              return receiverOf(this)[entry]();
            };
          }(stubName, getReceiver);
        case 1:
          return function(entry, receiverOf) {
            return function(a) {
              return receiverOf(this)[entry](a);
            };
          }(stubName, getReceiver);
        case 2:
          return function(entry, receiverOf) {
            return function(a, b) {
              return receiverOf(this)[entry](a, b);
            };
          }(stubName, getReceiver);
        case 3:
          return function(entry, receiverOf) {
            return function(a, b, c) {
              return receiverOf(this)[entry](a, b, c);
            };
          }(stubName, getReceiver);
        case 4:
          return function(entry, receiverOf) {
            return function(a, b, c, d) {
              return receiverOf(this)[entry](a, b, c, d);
            };
          }(stubName, getReceiver);
        case 5:
          return function(entry, receiverOf) {
            return function(a, b, c, d, e) {
              return receiverOf(this)[entry](a, b, c, d, e);
            };
          }(stubName, getReceiver);
        default:
          return function(f, receiverOf) {
            return function() {
              return f.apply(receiverOf(this), arguments);
            };
          }($function, getReceiver);
      }
    },
    Closure_forwardCallTo(stubName, $function, isIntercepted, needsDirectAccess) {
      var arity, t1, selfName, t2, $arguments,
        _s8_ = "receiver";
      if (isIntercepted)
        return H.Closure_forwardInterceptedCallTo(stubName, $function, needsDirectAccess);
      arity = $function.length;
      t1 = needsDirectAccess || arity >= 27;
      if (t1)
        return H.Closure_cspForwardCall(arity, needsDirectAccess, stubName, $function);
      if (arity === 0) {
        t1 = $.Closure_functionCounter;
        $.Closure_functionCounter = t1 + 1;
        selfName = "self" + H.S(t1);
        t1 = "return function(){var " + selfName + " = this.";
        t2 = $.BoundClosure__receiverFieldNameCache;
        return new Function(t1 + (t2 == null ? $.BoundClosure__receiverFieldNameCache = H.BoundClosure__computeFieldNamed(_s8_) : t2) + ";return " + selfName + "." + stubName + "();}")();
      }
      $arguments = "abcdefghijklmnopqrstuvwxyz".split("").splice(0, arity).join(",");
      t1 = $.Closure_functionCounter;
      $.Closure_functionCounter = t1 + 1;
      $arguments += H.S(t1);
      t1 = "return function(" + $arguments + "){return this.";
      t2 = $.BoundClosure__receiverFieldNameCache;
      return new Function(t1 + (t2 == null ? $.BoundClosure__receiverFieldNameCache = H.BoundClosure__computeFieldNamed(_s8_) : t2) + "." + stubName + "(" + $arguments + ");}")();
    },
    Closure_cspForwardInterceptedCall(arity, needsDirectAccess, stubName, $function) {
      var getReceiver = H.BoundClosure_receiverOf,
        getInterceptor = H.BoundClosure_interceptorOf;
      switch (needsDirectAccess ? -1 : arity) {
        case 0:
          throw H.wrapException(new H.RuntimeError("Intercepted function with no arguments."));
        case 1:
          return function(entry, interceptorOf, receiverOf) {
            return function() {
              return interceptorOf(this)[entry](receiverOf(this));
            };
          }(stubName, getInterceptor, getReceiver);
        case 2:
          return function(entry, interceptorOf, receiverOf) {
            return function(a) {
              return interceptorOf(this)[entry](receiverOf(this), a);
            };
          }(stubName, getInterceptor, getReceiver);
        case 3:
          return function(entry, interceptorOf, receiverOf) {
            return function(a, b) {
              return interceptorOf(this)[entry](receiverOf(this), a, b);
            };
          }(stubName, getInterceptor, getReceiver);
        case 4:
          return function(entry, interceptorOf, receiverOf) {
            return function(a, b, c) {
              return interceptorOf(this)[entry](receiverOf(this), a, b, c);
            };
          }(stubName, getInterceptor, getReceiver);
        case 5:
          return function(entry, interceptorOf, receiverOf) {
            return function(a, b, c, d) {
              return interceptorOf(this)[entry](receiverOf(this), a, b, c, d);
            };
          }(stubName, getInterceptor, getReceiver);
        case 6:
          return function(entry, interceptorOf, receiverOf) {
            return function(a, b, c, d, e) {
              return interceptorOf(this)[entry](receiverOf(this), a, b, c, d, e);
            };
          }(stubName, getInterceptor, getReceiver);
        default:
          return function(f, interceptorOf, receiverOf) {
            return function() {
              var a = [receiverOf(this)];
              Array.prototype.push.apply(a, arguments);
              return f.apply(interceptorOf(this), a);
            };
          }($function, getInterceptor, getReceiver);
      }
    },
    Closure_forwardInterceptedCallTo(stubName, $function, needsDirectAccess) {
      var receiverField, arity, t1, t2, $arguments,
        interceptorField = $.BoundClosure__interceptorFieldNameCache;
      if (interceptorField == null)
        interceptorField = $.BoundClosure__interceptorFieldNameCache = H.BoundClosure__computeFieldNamed("interceptor");
      receiverField = $.BoundClosure__receiverFieldNameCache;
      if (receiverField == null)
        receiverField = $.BoundClosure__receiverFieldNameCache = H.BoundClosure__computeFieldNamed("receiver");
      arity = $function.length;
      t1 = needsDirectAccess || arity >= 28;
      if (t1)
        return H.Closure_cspForwardInterceptedCall(arity, needsDirectAccess, stubName, $function);
      if (arity === 1) {
        t1 = "return function(){return this." + interceptorField + "." + stubName + "(this." + receiverField + ");";
        t2 = $.Closure_functionCounter;
        $.Closure_functionCounter = t2 + 1;
        return new Function(t1 + H.S(t2) + "}")();
      }
      $arguments = "abcdefghijklmnopqrstuvwxyz".split("").splice(0, arity - 1).join(",");
      t1 = "return function(" + $arguments + "){return this." + interceptorField + "." + stubName + "(this." + receiverField + ", " + $arguments + ");";
      t2 = $.Closure_functionCounter;
      $.Closure_functionCounter = t2 + 1;
      return new Function(t1 + H.S(t2) + "}")();
    },
    closureFromTearOff(parameters) {
      return H.Closure_fromTearOff(parameters);
    },
    BoundClosure_evalRecipe(closure, recipe) {
      return H._Universe_evalInEnvironment(init.typeUniverse, H.instanceType(closure._receiver), recipe);
    },
    BoundClosure_receiverOf(closure) {
      return closure._receiver;
    },
    BoundClosure_interceptorOf(closure) {
      return closure._interceptor;
    },
    BoundClosure__computeFieldNamed(fieldName) {
      var t1, i, $name,
        template = new H.BoundClosure("receiver", "interceptor"),
        names = J.JSArray_markFixedList(Object.getOwnPropertyNames(template));
      for (t1 = names.length, i = 0; i < t1; ++i) {
        $name = names[i];
        if (template[$name] === fieldName)
          return $name;
      }
      throw H.wrapException(P.ArgumentError$("Field name " + fieldName + " not found.", null));
    },
    throwCyclicInit(staticName) {
      throw H.wrapException(new P.CyclicInitializationError(staticName));
    },
    getIsolateAffinityTag($name) {
      return init.getIsolateTag($name);
    },
    defineProperty(obj, property, value) {
      Object.defineProperty(obj, property, {value: value, enumerable: false, writable: true, configurable: true});
    },
    lookupAndCacheInterceptor(obj) {
      var interceptor, interceptorClass, altTag, mark, t1,
        tag = $.getTagFunction.call$1(obj),
        record = $.dispatchRecordsForInstanceTags[tag];
      if (record != null) {
        Object.defineProperty(obj, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
        return record.i;
      }
      interceptor = $.interceptorsForUncacheableTags[tag];
      if (interceptor != null)
        return interceptor;
      interceptorClass = init.interceptorsByTag[tag];
      if (interceptorClass == null) {
        altTag = $.alternateTagFunction.call$2(obj, tag);
        if (altTag != null) {
          record = $.dispatchRecordsForInstanceTags[altTag];
          if (record != null) {
            Object.defineProperty(obj, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
            return record.i;
          }
          interceptor = $.interceptorsForUncacheableTags[altTag];
          if (interceptor != null)
            return interceptor;
          interceptorClass = init.interceptorsByTag[altTag];
          tag = altTag;
        }
      }
      if (interceptorClass == null)
        return null;
      interceptor = interceptorClass.prototype;
      mark = tag[0];
      if (mark === "!") {
        record = H.makeLeafDispatchRecord(interceptor);
        $.dispatchRecordsForInstanceTags[tag] = record;
        Object.defineProperty(obj, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
        return record.i;
      }
      if (mark === "~") {
        $.interceptorsForUncacheableTags[tag] = interceptor;
        return interceptor;
      }
      if (mark === "-") {
        t1 = H.makeLeafDispatchRecord(interceptor);
        Object.defineProperty(Object.getPrototypeOf(obj), init.dispatchPropertyName, {value: t1, enumerable: false, writable: true, configurable: true});
        return t1.i;
      }
      if (mark === "+")
        return H.patchInteriorProto(obj, interceptor);
      if (mark === "*")
        throw H.wrapException(P.UnimplementedError$(tag));
      if (init.leafTags[tag] === true) {
        t1 = H.makeLeafDispatchRecord(interceptor);
        Object.defineProperty(Object.getPrototypeOf(obj), init.dispatchPropertyName, {value: t1, enumerable: false, writable: true, configurable: true});
        return t1.i;
      } else
        return H.patchInteriorProto(obj, interceptor);
    },
    patchInteriorProto(obj, interceptor) {
      var proto = Object.getPrototypeOf(obj);
      Object.defineProperty(proto, init.dispatchPropertyName, {value: J.makeDispatchRecord(interceptor, proto, null, null), enumerable: false, writable: true, configurable: true});
      return interceptor;
    },
    makeLeafDispatchRecord(interceptor) {
      return J.makeDispatchRecord(interceptor, false, null, !!interceptor.$isJavaScriptIndexingBehavior);
    },
    makeDefaultDispatchRecord(tag, interceptorClass, proto) {
      var interceptor = interceptorClass.prototype;
      if (init.leafTags[tag] === true)
        return H.makeLeafDispatchRecord(interceptor);
      else
        return J.makeDispatchRecord(interceptor, proto, null, null);
    },
    initNativeDispatch() {
      if (true === $.initNativeDispatchFlag)
        return;
      $.initNativeDispatchFlag = true;
      H.initNativeDispatchContinue();
    },
    initNativeDispatchContinue() {
      var map, tags, fun, i, tag, proto, record, interceptorClass;
      $.dispatchRecordsForInstanceTags = Object.create(null);
      $.interceptorsForUncacheableTags = Object.create(null);
      H.initHooks();
      map = init.interceptorsByTag;
      tags = Object.getOwnPropertyNames(map);
      if (typeof window != "undefined") {
        window;
        fun = function() {
        };
        for (i = 0; i < tags.length; ++i) {
          tag = tags[i];
          proto = $.prototypeForTagFunction.call$1(tag);
          if (proto != null) {
            record = H.makeDefaultDispatchRecord(tag, map[tag], proto);
            if (record != null) {
              Object.defineProperty(proto, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
              fun.prototype = proto;
            }
          }
        }
      }
      for (i = 0; i < tags.length; ++i) {
        tag = tags[i];
        if (/^[A-Za-z_]/.test(tag)) {
          interceptorClass = map[tag];
          map["!" + tag] = interceptorClass;
          map["~" + tag] = interceptorClass;
          map["-" + tag] = interceptorClass;
          map["+" + tag] = interceptorClass;
          map["*" + tag] = interceptorClass;
        }
      }
    },
    initHooks() {
      var transformers, i, transformer, getTag, getUnknownTag, prototypeForTag,
        hooks = C.C_JS_CONST0();
      hooks = H.applyHooksTransformer(C.C_JS_CONST1, H.applyHooksTransformer(C.C_JS_CONST2, H.applyHooksTransformer(C.C_JS_CONST3, H.applyHooksTransformer(C.C_JS_CONST3, H.applyHooksTransformer(C.C_JS_CONST4, H.applyHooksTransformer(C.C_JS_CONST5, H.applyHooksTransformer(C.C_JS_CONST6(C.C_JS_CONST), hooks)))))));
      if (typeof dartNativeDispatchHooksTransformer != "undefined") {
        transformers = dartNativeDispatchHooksTransformer;
        if (typeof transformers == "function")
          transformers = [transformers];
        if (transformers.constructor == Array)
          for (i = 0; i < transformers.length; ++i) {
            transformer = transformers[i];
            if (typeof transformer == "function")
              hooks = transformer(hooks) || hooks;
          }
      }
      getTag = hooks.getTag;
      getUnknownTag = hooks.getUnknownTag;
      prototypeForTag = hooks.prototypeForTag;
      $.getTagFunction = new H.initHooks_closure(getTag);
      $.alternateTagFunction = new H.initHooks_closure0(getUnknownTag);
      $.prototypeForTagFunction = new H.initHooks_closure1(prototypeForTag);
    },
    applyHooksTransformer(transformer, hooks) {
      return transformer(hooks) || hooks;
    },
    JSSyntaxRegExp_makeNative(source, multiLine, caseSensitive, unicode, dotAll, global) {
      var m = multiLine ? "m" : "",
        i = caseSensitive ? "" : "i",
        u = unicode ? "u" : "",
        s = dotAll ? "s" : "",
        g = global ? "g" : "",
        regexp = function(source, modifiers) {
          try {
            return new RegExp(source, modifiers);
          } catch (e) {
            return e;
          }
        }(source, m + i + u + s + g);
      if (regexp instanceof RegExp)
        return regexp;
      throw H.wrapException(P.FormatException$("Illegal RegExp pattern (" + String(regexp) + ")", source, null));
    },
    stringContainsUnchecked(receiver, other, startIndex) {
      var t1;
      if (typeof other == "string")
        return receiver.indexOf(other, startIndex) >= 0;
      else if (other instanceof H.JSSyntaxRegExp) {
        t1 = C.JSString_methods.substring$1(receiver, startIndex);
        return other._nativeRegExp.test(t1);
      } else {
        t1 = J.allMatches$1$s(other, C.JSString_methods.substring$1(receiver, startIndex));
        return !t1.get$isEmpty(t1);
      }
    },
    escapeReplacement(replacement) {
      if (replacement.indexOf("$", 0) >= 0)
        return replacement.replace(/\$/g, "$$$$");
      return replacement;
    },
    stringReplaceFirstRE(receiver, regexp, replacement, startIndex) {
      var match = regexp._execGlobal$2(receiver, startIndex);
      if (match == null)
        return receiver;
      return H.stringReplaceRangeUnchecked(receiver, match._match.index, match.get$end(match), replacement);
    },
    quoteStringForRegExp(string) {
      if (/[[\]{}()*+?.\\^$|]/.test(string))
        return string.replace(/[[\]{}()*+?.\\^$|]/g, "\\$&");
      return string;
    },
    stringReplaceAllUnchecked(receiver, pattern, replacement) {
      var nativeRegexp;
      if (typeof pattern == "string")
        return H.stringReplaceAllUncheckedString(receiver, pattern, replacement);
      if (pattern instanceof H.JSSyntaxRegExp) {
        nativeRegexp = pattern.get$_nativeGlobalVersion();
        nativeRegexp.lastIndex = 0;
        return receiver.replace(nativeRegexp, H.escapeReplacement(replacement));
      }
      throw H.wrapException("String.replaceAll(Pattern) UNIMPLEMENTED");
    },
    stringReplaceAllUncheckedString(receiver, pattern, replacement) {
      var $length, t1, i, index;
      if (pattern === "") {
        if (receiver === "")
          return replacement;
        $length = receiver.length;
        t1 = "" + replacement;
        for (i = 0; i < $length; ++i)
          t1 = t1 + receiver[i] + replacement;
        return t1.charCodeAt(0) == 0 ? t1 : t1;
      }
      index = receiver.indexOf(pattern, 0);
      if (index < 0)
        return receiver;
      if (receiver.length < 500 || replacement.indexOf("$", 0) >= 0)
        return receiver.split(pattern).join(replacement);
      return receiver.replace(new RegExp(H.quoteStringForRegExp(pattern), "g"), H.escapeReplacement(replacement));
    },
    stringReplaceFirstUnchecked(receiver, pattern, replacement, startIndex) {
      var index, t1, matches, match;
      if (typeof pattern == "string") {
        index = receiver.indexOf(pattern, startIndex);
        if (index < 0)
          return receiver;
        return H.stringReplaceRangeUnchecked(receiver, index, index + pattern.length, replacement);
      }
      if (pattern instanceof H.JSSyntaxRegExp)
        return startIndex === 0 ? receiver.replace(pattern._nativeRegExp, H.escapeReplacement(replacement)) : H.stringReplaceFirstRE(receiver, pattern, replacement, startIndex);
      t1 = J.allMatches$2$s(pattern, receiver, startIndex);
      matches = t1.get$iterator(t1);
      if (!matches.moveNext$0())
        return receiver;
      match = matches.get$current(matches);
      return C.JSString_methods.replaceRange$3(receiver, match.get$start(match), match.get$end(match), replacement);
    },
    stringReplaceRangeUnchecked(receiver, start, end, replacement) {
      var prefix = receiver.substring(0, start),
        suffix = receiver.substring(end);
      return prefix + replacement + suffix;
    },
    ConstantMapView: function ConstantMapView(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    ConstantMap: function ConstantMap() {
    },
    ConstantStringMap: function ConstantStringMap(t0, t1, t2, t3) {
      var _ = this;
      _.__js_helper$_length = t0;
      _._jsObject = t1;
      _.__js_helper$_keys = t2;
      _.$ti = t3;
    },
    ConstantStringMap_values_closure: function ConstantStringMap_values_closure(t0) {
      this.$this = t0;
    },
    _ConstantMapKeyIterable: function _ConstantMapKeyIterable(t0, t1) {
      this.__js_helper$_map = t0;
      this.$ti = t1;
    },
    Instantiation: function Instantiation() {
    },
    Instantiation1: function Instantiation1(t0, t1) {
      this._genericClosure = t0;
      this.$ti = t1;
    },
    JSInvocationMirror: function JSInvocationMirror(t0, t1, t2, t3, t4) {
      var _ = this;
      _.__js_helper$_memberName = t0;
      _.__js_helper$_kind = t1;
      _._arguments = t2;
      _._namedArgumentNames = t3;
      _._typeArgumentCount = t4;
    },
    Primitives_functionNoSuchMethod_closure: function Primitives_functionNoSuchMethod_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.namedArgumentList = t1;
      this.$arguments = t2;
    },
    TypeErrorDecoder: function TypeErrorDecoder(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._pattern = t0;
      _._arguments = t1;
      _._argumentsExpr = t2;
      _._expr = t3;
      _._method = t4;
      _._receiver = t5;
    },
    NullError: function NullError(t0, t1) {
      this.__js_helper$_message = t0;
      this._method = t1;
    },
    JsNoSuchMethodError: function JsNoSuchMethodError(t0, t1, t2) {
      this.__js_helper$_message = t0;
      this._method = t1;
      this._receiver = t2;
    },
    UnknownJsTypeError: function UnknownJsTypeError(t0) {
      this.__js_helper$_message = t0;
    },
    NullThrownFromJavaScriptException: function NullThrownFromJavaScriptException(t0) {
      this._irritant = t0;
    },
    ExceptionAndStackTrace: function ExceptionAndStackTrace(t0, t1) {
      this.dartException = t0;
      this.stackTrace = t1;
    },
    _StackTrace: function _StackTrace(t0) {
      this._exception = t0;
      this._trace = null;
    },
    Closure: function Closure() {
    },
    Closure0Args: function Closure0Args() {
    },
    Closure2Args: function Closure2Args() {
    },
    TearOffClosure: function TearOffClosure() {
    },
    StaticClosure: function StaticClosure() {
    },
    BoundClosure: function BoundClosure(t0, t1) {
      this._receiver = t0;
      this._interceptor = t1;
    },
    RuntimeError: function RuntimeError(t0) {
      this.message = t0;
    },
    _Required: function _Required() {
    },
    JsLinkedHashMap: function JsLinkedHashMap(t0) {
      var _ = this;
      _.__js_helper$_length = 0;
      _._last = _._first = _.__js_helper$_rest = _._nums = _._strings = null;
      _._modifications = 0;
      _.$ti = t0;
    },
    JsLinkedHashMap_values_closure: function JsLinkedHashMap_values_closure(t0) {
      this.$this = t0;
    },
    JsLinkedHashMap_addAll_closure: function JsLinkedHashMap_addAll_closure(t0) {
      this.$this = t0;
    },
    LinkedHashMapCell: function LinkedHashMapCell(t0, t1) {
      var _ = this;
      _.hashMapCellKey = t0;
      _.hashMapCellValue = t1;
      _._previous = _._next = null;
    },
    LinkedHashMapKeyIterable: function LinkedHashMapKeyIterable(t0, t1) {
      this.__js_helper$_map = t0;
      this.$ti = t1;
    },
    LinkedHashMapKeyIterator: function LinkedHashMapKeyIterator(t0, t1) {
      var _ = this;
      _.__js_helper$_map = t0;
      _._modifications = t1;
      _.__js_helper$_current = _._cell = null;
    },
    initHooks_closure: function initHooks_closure(t0) {
      this.getTag = t0;
    },
    initHooks_closure0: function initHooks_closure0(t0) {
      this.getUnknownTag = t0;
    },
    initHooks_closure1: function initHooks_closure1(t0) {
      this.prototypeForTag = t0;
    },
    JSSyntaxRegExp: function JSSyntaxRegExp(t0, t1) {
      var _ = this;
      _.pattern = t0;
      _._nativeRegExp = t1;
      _._nativeAnchoredRegExp = _._nativeGlobalRegExp = null;
    },
    _MatchImplementation: function _MatchImplementation(t0) {
      this._match = t0;
    },
    _AllMatchesIterable: function _AllMatchesIterable(t0, t1, t2) {
      this._re = t0;
      this.__js_helper$_string = t1;
      this.__js_helper$_start = t2;
    },
    _AllMatchesIterator: function _AllMatchesIterator(t0, t1, t2) {
      var _ = this;
      _._regExp = t0;
      _.__js_helper$_string = t1;
      _._nextIndex = t2;
      _.__js_helper$_current = null;
    },
    StringMatch: function StringMatch(t0, t1) {
      this.start = t0;
      this.pattern = t1;
    },
    _StringAllMatchesIterable: function _StringAllMatchesIterable(t0, t1, t2) {
      this._input = t0;
      this._pattern = t1;
      this.__js_helper$_index = t2;
    },
    _StringAllMatchesIterator: function _StringAllMatchesIterator(t0, t1, t2) {
      var _ = this;
      _._input = t0;
      _._pattern = t1;
      _.__js_helper$_index = t2;
      _.__js_helper$_current = null;
    },
    throwLateFieldADI(fieldName) {
      return H.throwExpression(H.LateError$fieldADI(fieldName));
    },
    _Cell$() {
      var t1 = new H._Cell("");
      return t1._value = t1;
    },
    _Cell$named(_name) {
      var t1 = new H._Cell(_name);
      return t1._value = t1;
    },
    _Cell: function _Cell(t0) {
      this.__late_helper$_name = t0;
      this._value = null;
    },
    _ensureNativeList(list) {
      return list;
    },
    NativeInt8List__create1(arg) {
      return new Int8Array(arg);
    },
    _checkValidIndex(index, list, $length) {
      if (index >>> 0 !== index || index >= $length)
        throw H.wrapException(H.diagnoseIndexError(list, index));
    },
    _checkValidRange(start, end, $length) {
      var t1;
      if (!(start >>> 0 !== start))
        if (end == null)
          t1 = start > $length;
        else
          t1 = end >>> 0 !== end || start > end || end > $length;
      else
        t1 = true;
      if (t1)
        throw H.wrapException(H.diagnoseRangeError(start, end, $length));
      if (end == null)
        return $length;
      return end;
    },
    NativeTypedData: function NativeTypedData() {
    },
    NativeTypedArray: function NativeTypedArray() {
    },
    NativeTypedArrayOfDouble: function NativeTypedArrayOfDouble() {
    },
    NativeTypedArrayOfInt: function NativeTypedArrayOfInt() {
    },
    NativeFloat32List: function NativeFloat32List() {
    },
    NativeFloat64List: function NativeFloat64List() {
    },
    NativeInt16List: function NativeInt16List() {
    },
    NativeInt32List: function NativeInt32List() {
    },
    NativeInt8List: function NativeInt8List() {
    },
    NativeUint16List: function NativeUint16List() {
    },
    NativeUint32List: function NativeUint32List() {
    },
    NativeUint8ClampedList: function NativeUint8ClampedList() {
    },
    NativeUint8List: function NativeUint8List() {
    },
    _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin: function _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin() {
    },
    _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin_FixedLengthListMixin: function _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin_FixedLengthListMixin() {
    },
    _NativeTypedArrayOfInt_NativeTypedArray_ListMixin: function _NativeTypedArrayOfInt_NativeTypedArray_ListMixin() {
    },
    _NativeTypedArrayOfInt_NativeTypedArray_ListMixin_FixedLengthListMixin: function _NativeTypedArrayOfInt_NativeTypedArray_ListMixin_FixedLengthListMixin() {
    },
    Rti__getQuestionFromStar(universe, rti) {
      var question = rti._precomputed1;
      return question == null ? rti._precomputed1 = H._Universe__lookupQuestionRti(universe, rti._primary, true) : question;
    },
    Rti__getFutureFromFutureOr(universe, rti) {
      var future = rti._precomputed1;
      return future == null ? rti._precomputed1 = H._Universe__lookupInterfaceRti(universe, "Future", [rti._primary]) : future;
    },
    Rti__isUnionOfFunctionType(rti) {
      var kind = rti._kind;
      if (kind === 6 || kind === 7 || kind === 8)
        return H.Rti__isUnionOfFunctionType(rti._primary);
      return kind === 11 || kind === 12;
    },
    Rti__getCanonicalRecipe(rti) {
      return rti._canonicalRecipe;
    },
    findType(recipe) {
      return H._Universe_eval(init.typeUniverse, recipe, false);
    },
    instantiatedGenericFunctionType(genericFunctionRti, instantiationRti) {
      var t1, cache, key, probe, rti;
      if (genericFunctionRti == null)
        return null;
      t1 = instantiationRti._rest;
      cache = genericFunctionRti._bindCache;
      if (cache == null)
        cache = genericFunctionRti._bindCache = new Map();
      key = instantiationRti._canonicalRecipe;
      probe = cache.get(key);
      if (probe != null)
        return probe;
      rti = H._substitute(init.typeUniverse, genericFunctionRti._primary, t1, 0);
      cache.set(key, rti);
      return rti;
    },
    _substitute(universe, rti, typeArguments, depth) {
      var baseType, substitutedBaseType, interfaceTypeArguments, substitutedInterfaceTypeArguments, base, substitutedBase, $arguments, substitutedArguments, returnType, substitutedReturnType, functionParameters, substitutedFunctionParameters, bounds, substitutedBounds, index, argument,
        kind = rti._kind;
      switch (kind) {
        case 5:
        case 1:
        case 2:
        case 3:
        case 4:
          return rti;
        case 6:
          baseType = rti._primary;
          substitutedBaseType = H._substitute(universe, baseType, typeArguments, depth);
          if (substitutedBaseType === baseType)
            return rti;
          return H._Universe__lookupStarRti(universe, substitutedBaseType, true);
        case 7:
          baseType = rti._primary;
          substitutedBaseType = H._substitute(universe, baseType, typeArguments, depth);
          if (substitutedBaseType === baseType)
            return rti;
          return H._Universe__lookupQuestionRti(universe, substitutedBaseType, true);
        case 8:
          baseType = rti._primary;
          substitutedBaseType = H._substitute(universe, baseType, typeArguments, depth);
          if (substitutedBaseType === baseType)
            return rti;
          return H._Universe__lookupFutureOrRti(universe, substitutedBaseType, true);
        case 9:
          interfaceTypeArguments = rti._rest;
          substitutedInterfaceTypeArguments = H._substituteArray(universe, interfaceTypeArguments, typeArguments, depth);
          if (substitutedInterfaceTypeArguments === interfaceTypeArguments)
            return rti;
          return H._Universe__lookupInterfaceRti(universe, rti._primary, substitutedInterfaceTypeArguments);
        case 10:
          base = rti._primary;
          substitutedBase = H._substitute(universe, base, typeArguments, depth);
          $arguments = rti._rest;
          substitutedArguments = H._substituteArray(universe, $arguments, typeArguments, depth);
          if (substitutedBase === base && substitutedArguments === $arguments)
            return rti;
          return H._Universe__lookupBindingRti(universe, substitutedBase, substitutedArguments);
        case 11:
          returnType = rti._primary;
          substitutedReturnType = H._substitute(universe, returnType, typeArguments, depth);
          functionParameters = rti._rest;
          substitutedFunctionParameters = H._substituteFunctionParameters(universe, functionParameters, typeArguments, depth);
          if (substitutedReturnType === returnType && substitutedFunctionParameters === functionParameters)
            return rti;
          return H._Universe__lookupFunctionRti(universe, substitutedReturnType, substitutedFunctionParameters);
        case 12:
          bounds = rti._rest;
          depth += bounds.length;
          substitutedBounds = H._substituteArray(universe, bounds, typeArguments, depth);
          base = rti._primary;
          substitutedBase = H._substitute(universe, base, typeArguments, depth);
          if (substitutedBounds === bounds && substitutedBase === base)
            return rti;
          return H._Universe__lookupGenericFunctionRti(universe, substitutedBase, substitutedBounds, true);
        case 13:
          index = rti._primary;
          if (index < depth)
            return rti;
          argument = typeArguments[index - depth];
          if (argument == null)
            return rti;
          return argument;
        default:
          throw H.wrapException(P.AssertionError$("Attempted to substitute unexpected RTI kind " + kind));
      }
    },
    _substituteArray(universe, rtiArray, typeArguments, depth) {
      var changed, i, rti, substitutedRti,
        $length = rtiArray.length,
        result = H._Utils_newArrayOrEmpty($length);
      for (changed = false, i = 0; i < $length; ++i) {
        rti = rtiArray[i];
        substitutedRti = H._substitute(universe, rti, typeArguments, depth);
        if (substitutedRti !== rti)
          changed = true;
        result[i] = substitutedRti;
      }
      return changed ? result : rtiArray;
    },
    _substituteNamed(universe, namedArray, typeArguments, depth) {
      var changed, i, t1, t2, rti, substitutedRti,
        $length = namedArray.length,
        result = H._Utils_newArrayOrEmpty($length);
      for (changed = false, i = 0; i < $length; i += 3) {
        t1 = namedArray[i];
        t2 = namedArray[i + 1];
        rti = namedArray[i + 2];
        substitutedRti = H._substitute(universe, rti, typeArguments, depth);
        if (substitutedRti !== rti)
          changed = true;
        result.splice(i, 3, t1, t2, substitutedRti);
      }
      return changed ? result : namedArray;
    },
    _substituteFunctionParameters(universe, functionParameters, typeArguments, depth) {
      var result,
        requiredPositional = functionParameters._requiredPositional,
        substitutedRequiredPositional = H._substituteArray(universe, requiredPositional, typeArguments, depth),
        optionalPositional = functionParameters._optionalPositional,
        substitutedOptionalPositional = H._substituteArray(universe, optionalPositional, typeArguments, depth),
        named = functionParameters._named,
        substitutedNamed = H._substituteNamed(universe, named, typeArguments, depth);
      if (substitutedRequiredPositional === requiredPositional && substitutedOptionalPositional === optionalPositional && substitutedNamed === named)
        return functionParameters;
      result = new H._FunctionParameters();
      result._requiredPositional = substitutedRequiredPositional;
      result._optionalPositional = substitutedOptionalPositional;
      result._named = substitutedNamed;
      return result;
    },
    _setArrayType(target, rti) {
      target[init.arrayRti] = rti;
      return target;
    },
    closureFunctionType(closure) {
      var signature = closure.$signature;
      if (signature != null) {
        if (typeof signature == "number")
          return H.getTypeFromTypesTable(signature);
        return closure.$signature();
      }
      return null;
    },
    instanceOrFunctionType(object, testRti) {
      var rti;
      if (H.Rti__isUnionOfFunctionType(testRti))
        if (object instanceof H.Closure) {
          rti = H.closureFunctionType(object);
          if (rti != null)
            return rti;
        }
      return H.instanceType(object);
    },
    instanceType(object) {
      var rti;
      if (object instanceof P.Object) {
        rti = object.$ti;
        return rti != null ? rti : H._instanceTypeFromConstructor(object);
      }
      if (Array.isArray(object))
        return H._arrayInstanceType(object);
      return H._instanceTypeFromConstructor(J.getInterceptor$(object));
    },
    _arrayInstanceType(object) {
      var rti = object[init.arrayRti],
        defaultRti = type$.JSArray_dynamic;
      if (rti == null)
        return defaultRti;
      if (rti.constructor !== defaultRti.constructor)
        return defaultRti;
      return rti;
    },
    _instanceType(object) {
      var rti = object.$ti;
      return rti != null ? rti : H._instanceTypeFromConstructor(object);
    },
    _instanceTypeFromConstructor(instance) {
      var $constructor = instance.constructor,
        probe = $constructor.$ccache;
      if (probe != null)
        return probe;
      return H._instanceTypeFromConstructorMiss(instance, $constructor);
    },
    _instanceTypeFromConstructorMiss(instance, $constructor) {
      var effectiveConstructor = instance instanceof H.Closure ? instance.__proto__.__proto__.constructor : $constructor,
        rti = H._Universe_findErasedType(init.typeUniverse, effectiveConstructor.name);
      $constructor.$ccache = rti;
      return rti;
    },
    getTypeFromTypesTable(index) {
      var rti,
        table = init.types,
        type = table[index];
      if (typeof type == "string") {
        rti = H._Universe_eval(init.typeUniverse, type, false);
        table[index] = rti;
        return rti;
      }
      return type;
    },
    getRuntimeType(object) {
      var rti = object instanceof H.Closure ? H.closureFunctionType(object) : null;
      return H.createRuntimeType(rti == null ? H.instanceType(object) : rti);
    },
    createRuntimeType(rti) {
      var recipe, starErasedRecipe, starErasedRti,
        type = rti._cachedRuntimeType;
      if (type != null)
        return type;
      recipe = rti._canonicalRecipe;
      starErasedRecipe = recipe.replace(/\*/g, "");
      if (starErasedRecipe === recipe)
        return rti._cachedRuntimeType = new H._Type(rti);
      starErasedRti = H._Universe_eval(init.typeUniverse, starErasedRecipe, true);
      type = starErasedRti._cachedRuntimeType;
      return rti._cachedRuntimeType = type == null ? starErasedRti._cachedRuntimeType = new H._Type(starErasedRti) : type;
    },
    typeLiteral(recipe) {
      return H.createRuntimeType(H._Universe_eval(init.typeUniverse, recipe, false));
    },
    _installSpecializedIsTest(object) {
      var t1, unstarred, isFn, $name, testRti = this;
      if (testRti === type$.Object)
        return H._finishIsFn(testRti, object, H._isObject);
      if (!H.isStrongTopType(testRti))
        if (!(testRti === type$.legacy_Object))
          t1 = false;
        else
          t1 = true;
      else
        t1 = true;
      if (t1)
        return H._finishIsFn(testRti, object, H._isTop);
      t1 = testRti._kind;
      unstarred = t1 === 6 ? testRti._primary : testRti;
      if (unstarred === type$.int)
        isFn = H._isInt;
      else if (unstarred === type$.double || unstarred === type$.num)
        isFn = H._isNum;
      else if (unstarred === type$.String)
        isFn = H._isString;
      else
        isFn = unstarred === type$.bool ? H._isBool : null;
      if (isFn != null)
        return H._finishIsFn(testRti, object, isFn);
      if (unstarred._kind === 9) {
        $name = unstarred._primary;
        if (unstarred._rest.every(H.isTopType)) {
          testRti._specializedTestResource = "$is" + $name;
          if ($name === "List")
            return H._finishIsFn(testRti, object, H._isListTestViaProperty);
          return H._finishIsFn(testRti, object, H._isTestViaProperty);
        }
      } else if (t1 === 7)
        return H._finishIsFn(testRti, object, H._generalNullableIsTestImplementation);
      return H._finishIsFn(testRti, object, H._generalIsTestImplementation);
    },
    _finishIsFn(testRti, object, isFn) {
      testRti._is = isFn;
      return testRti._is(object);
    },
    _installSpecializedAsCheck(object) {
      var t1, testRti = this,
        asFn = H._generalAsCheckImplementation;
      if (!H.isStrongTopType(testRti))
        if (!(testRti === type$.legacy_Object))
          t1 = false;
        else
          t1 = true;
      else
        t1 = true;
      if (t1)
        asFn = H._asTop;
      else if (testRti === type$.Object)
        asFn = H._asObject;
      else {
        t1 = H.isNullable(testRti);
        if (t1)
          asFn = H._generalNullableAsCheckImplementation;
      }
      testRti._as = asFn;
      return testRti._as(object);
    },
    _nullIs(testRti) {
      var t1,
        kind = testRti._kind;
      if (!H.isStrongTopType(testRti))
        if (!(testRti === type$.legacy_Object))
          if (!(testRti === type$.legacy_Never))
            if (kind !== 7)
              t1 = kind === 8 && H._nullIs(testRti._primary) || testRti === type$.Null || testRti === type$.JSNull;
            else
              t1 = true;
          else
            t1 = true;
        else
          t1 = true;
      else
        t1 = true;
      return t1;
    },
    _generalIsTestImplementation(object) {
      var testRti = this;
      if (object == null)
        return H._nullIs(testRti);
      return H._isSubtype(init.typeUniverse, H.instanceOrFunctionType(object, testRti), null, testRti, null);
    },
    _generalNullableIsTestImplementation(object) {
      if (object == null)
        return true;
      return this._primary._is(object);
    },
    _isTestViaProperty(object) {
      var tag, testRti = this;
      if (object == null)
        return H._nullIs(testRti);
      tag = testRti._specializedTestResource;
      if (object instanceof P.Object)
        return !!object[tag];
      return !!J.getInterceptor$(object)[tag];
    },
    _isListTestViaProperty(object) {
      var tag, testRti = this;
      if (object == null)
        return H._nullIs(testRti);
      if (typeof object != "object")
        return false;
      if (Array.isArray(object))
        return true;
      tag = testRti._specializedTestResource;
      if (object instanceof P.Object)
        return !!object[tag];
      return !!J.getInterceptor$(object)[tag];
    },
    _generalAsCheckImplementation(object) {
      var t1, testRti = this;
      if (object == null) {
        t1 = H.isNullable(testRti);
        if (t1)
          return object;
      } else if (testRti._is(object))
        return object;
      H._failedAsCheck(object, testRti);
    },
    _generalNullableAsCheckImplementation(object) {
      var testRti = this;
      if (object == null)
        return object;
      else if (testRti._is(object))
        return object;
      H._failedAsCheck(object, testRti);
    },
    _failedAsCheck(object, testRti) {
      throw H.wrapException(H._TypeError$fromMessage(H._Error_compose(object, H.instanceOrFunctionType(object, testRti), H._rtiToString(testRti, null))));
    },
    _Error_compose(object, objectRti, checkedTypeDescription) {
      var objectDescription = P.Error_safeToString(object),
        objectTypeDescription = H._rtiToString(objectRti == null ? H.instanceType(object) : objectRti, null);
      return objectDescription + ": type '" + objectTypeDescription + "' is not a subtype of type '" + checkedTypeDescription + "'";
    },
    _TypeError$fromMessage(message) {
      return new H._TypeError("TypeError: " + message);
    },
    _TypeError__TypeError$forType(object, type) {
      return new H._TypeError("TypeError: " + H._Error_compose(object, null, type));
    },
    _isObject(object) {
      return object != null;
    },
    _asObject(object) {
      if (object != null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "Object"));
    },
    _isTop(object) {
      return true;
    },
    _asTop(object) {
      return object;
    },
    _isBool(object) {
      return true === object || false === object;
    },
    _asBool(object) {
      if (true === object)
        return true;
      if (false === object)
        return false;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "bool"));
    },
    _asBoolS(object) {
      if (true === object)
        return true;
      if (false === object)
        return false;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "bool"));
    },
    _asBoolQ(object) {
      if (true === object)
        return true;
      if (false === object)
        return false;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "bool?"));
    },
    _asDouble(object) {
      if (typeof object == "number")
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "double"));
    },
    _asDoubleS(object) {
      if (typeof object == "number")
        return object;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "double"));
    },
    _asDoubleQ(object) {
      if (typeof object == "number")
        return object;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "double?"));
    },
    _isInt(object) {
      return typeof object == "number" && Math.floor(object) === object;
    },
    _asInt(object) {
      if (typeof object == "number" && Math.floor(object) === object)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "int"));
    },
    _asIntS(object) {
      if (typeof object == "number" && Math.floor(object) === object)
        return object;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "int"));
    },
    _asIntQ(object) {
      if (typeof object == "number" && Math.floor(object) === object)
        return object;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "int?"));
    },
    _isNum(object) {
      return typeof object == "number";
    },
    _asNum(object) {
      if (typeof object == "number")
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "num"));
    },
    _asNumS(object) {
      if (typeof object == "number")
        return object;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "num"));
    },
    _asNumQ(object) {
      if (typeof object == "number")
        return object;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "num?"));
    },
    _isString(object) {
      return typeof object == "string";
    },
    _asString(object) {
      if (typeof object == "string")
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "String"));
    },
    _asStringS(object) {
      if (typeof object == "string")
        return object;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "String"));
    },
    _asStringQ(object) {
      if (typeof object == "string")
        return object;
      if (object == null)
        return object;
      throw H.wrapException(H._TypeError__TypeError$forType(object, "String?"));
    },
    _rtiArrayToString(array, genericContext) {
      var s, sep, i;
      for (s = "", sep = "", i = 0; i < array.length; ++i, sep = ", ")
        s += sep + H._rtiToString(array[i], genericContext);
      return s;
    },
    _functionRtiToString(functionType, genericContext, bounds) {
      var boundsLength, outerContextLength, offset, i, t1, t2, typeParametersText, typeSep, boundRti, kind, t3, parameters, requiredPositional, requiredPositionalLength, optionalPositional, optionalPositionalLength, named, namedLength, returnTypeText, argumentsText, sep, _s2_ = ", ";
      if (bounds != null) {
        boundsLength = bounds.length;
        if (genericContext == null) {
          genericContext = H._setArrayType([], type$.JSArray_String);
          outerContextLength = null;
        } else
          outerContextLength = genericContext.length;
        offset = genericContext.length;
        for (i = boundsLength; i > 0; --i)
          genericContext.push("T" + (offset + i));
        for (t1 = type$.nullable_Object, t2 = type$.legacy_Object, typeParametersText = "<", typeSep = "", i = 0; i < boundsLength; ++i, typeSep = _s2_) {
          typeParametersText = C.JSString_methods.$add(typeParametersText + typeSep, genericContext[genericContext.length - 1 - i]);
          boundRti = bounds[i];
          kind = boundRti._kind;
          if (!(kind === 2 || kind === 3 || kind === 4 || kind === 5 || boundRti === t1))
            if (!(boundRti === t2))
              t3 = false;
            else
              t3 = true;
          else
            t3 = true;
          if (!t3)
            typeParametersText += " extends " + H._rtiToString(boundRti, genericContext);
        }
        typeParametersText += ">";
      } else {
        typeParametersText = "";
        outerContextLength = null;
      }
      t1 = functionType._primary;
      parameters = functionType._rest;
      requiredPositional = parameters._requiredPositional;
      requiredPositionalLength = requiredPositional.length;
      optionalPositional = parameters._optionalPositional;
      optionalPositionalLength = optionalPositional.length;
      named = parameters._named;
      namedLength = named.length;
      returnTypeText = H._rtiToString(t1, genericContext);
      for (argumentsText = "", sep = "", i = 0; i < requiredPositionalLength; ++i, sep = _s2_)
        argumentsText += sep + H._rtiToString(requiredPositional[i], genericContext);
      if (optionalPositionalLength > 0) {
        argumentsText += sep + "[";
        for (sep = "", i = 0; i < optionalPositionalLength; ++i, sep = _s2_)
          argumentsText += sep + H._rtiToString(optionalPositional[i], genericContext);
        argumentsText += "]";
      }
      if (namedLength > 0) {
        argumentsText += sep + "{";
        for (sep = "", i = 0; i < namedLength; i += 3, sep = _s2_) {
          argumentsText += sep;
          if (named[i + 1])
            argumentsText += "required ";
          argumentsText += H._rtiToString(named[i + 2], genericContext) + " " + named[i];
        }
        argumentsText += "}";
      }
      if (outerContextLength != null) {
        genericContext.toString;
        genericContext.length = outerContextLength;
      }
      return typeParametersText + "(" + argumentsText + ") => " + returnTypeText;
    },
    _rtiToString(rti, genericContext) {
      var s, questionArgument, argumentKind, $name, $arguments, t1,
        kind = rti._kind;
      if (kind === 5)
        return "erased";
      if (kind === 2)
        return "dynamic";
      if (kind === 3)
        return "void";
      if (kind === 1)
        return "Never";
      if (kind === 4)
        return "any";
      if (kind === 6) {
        s = H._rtiToString(rti._primary, genericContext);
        return s;
      }
      if (kind === 7) {
        questionArgument = rti._primary;
        s = H._rtiToString(questionArgument, genericContext);
        argumentKind = questionArgument._kind;
        return (argumentKind === 11 || argumentKind === 12 ? "(" + s + ")" : s) + "?";
      }
      if (kind === 8)
        return "FutureOr<" + H._rtiToString(rti._primary, genericContext) + ">";
      if (kind === 9) {
        $name = H._unminifyOrTag(rti._primary);
        $arguments = rti._rest;
        return $arguments.length > 0 ? $name + ("<" + H._rtiArrayToString($arguments, genericContext) + ">") : $name;
      }
      if (kind === 11)
        return H._functionRtiToString(rti, genericContext, null);
      if (kind === 12)
        return H._functionRtiToString(rti._primary, genericContext, rti._rest);
      if (kind === 13) {
        t1 = rti._primary;
        return genericContext[genericContext.length - 1 - t1];
      }
      return "?";
    },
    _unminifyOrTag(rawClassName) {
      var preserved = init.mangledGlobalNames[rawClassName];
      if (preserved != null)
        return preserved;
      return rawClassName;
    },
    _Universe_findRule(universe, targetType) {
      var rule = universe.tR[targetType];
      for (; typeof rule == "string";)
        rule = universe.tR[rule];
      return rule;
    },
    _Universe_findErasedType(universe, cls) {
      var $length, erased, $arguments, i, $interface,
        t1 = universe.eT,
        probe = t1[cls];
      if (probe == null)
        return H._Universe_eval(universe, cls, false);
      else if (typeof probe == "number") {
        $length = probe;
        erased = H._Universe__lookupTerminalRti(universe, 5, "#");
        $arguments = H._Utils_newArrayOrEmpty($length);
        for (i = 0; i < $length; ++i)
          $arguments[i] = erased;
        $interface = H._Universe__lookupInterfaceRti(universe, cls, $arguments);
        t1[cls] = $interface;
        return $interface;
      } else
        return probe;
    },
    _Universe_addRules(universe, rules) {
      return H._Utils_objectAssign(universe.tR, rules);
    },
    _Universe_addErasedTypes(universe, types) {
      return H._Utils_objectAssign(universe.eT, types);
    },
    _Universe_eval(universe, recipe, normalize) {
      var rti,
        t1 = universe.eC,
        probe = t1.get(recipe);
      if (probe != null)
        return probe;
      rti = H._Parser_parse(H._Parser_create(universe, null, recipe, normalize));
      t1.set(recipe, rti);
      return rti;
    },
    _Universe_evalInEnvironment(universe, environment, recipe) {
      var probe, rti,
        cache = environment._evalCache;
      if (cache == null)
        cache = environment._evalCache = new Map();
      probe = cache.get(recipe);
      if (probe != null)
        return probe;
      rti = H._Parser_parse(H._Parser_create(universe, environment, recipe, true));
      cache.set(recipe, rti);
      return rti;
    },
    _Universe_bind(universe, environment, argumentsRti) {
      var argumentsRecipe, probe, rti,
        cache = environment._bindCache;
      if (cache == null)
        cache = environment._bindCache = new Map();
      argumentsRecipe = argumentsRti._canonicalRecipe;
      probe = cache.get(argumentsRecipe);
      if (probe != null)
        return probe;
      rti = H._Universe__lookupBindingRti(universe, environment, argumentsRti._kind === 10 ? argumentsRti._rest : [argumentsRti]);
      cache.set(argumentsRecipe, rti);
      return rti;
    },
    _Universe__installTypeTests(universe, rti) {
      rti._as = H._installSpecializedAsCheck;
      rti._is = H._installSpecializedIsTest;
      return rti;
    },
    _Universe__lookupTerminalRti(universe, kind, key) {
      var rti, t1,
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      rti = new H.Rti(null, null);
      rti._kind = kind;
      rti._canonicalRecipe = key;
      t1 = H._Universe__installTypeTests(universe, rti);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__lookupStarRti(universe, baseType, normalize) {
      var t1,
        key = baseType._canonicalRecipe + "*",
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      t1 = H._Universe__createStarRti(universe, baseType, key, normalize);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__createStarRti(universe, baseType, key, normalize) {
      var baseKind, t1, rti;
      if (normalize) {
        baseKind = baseType._kind;
        if (!H.isStrongTopType(baseType))
          t1 = baseType === type$.Null || baseType === type$.JSNull || baseKind === 7 || baseKind === 6;
        else
          t1 = true;
        if (t1)
          return baseType;
      }
      rti = new H.Rti(null, null);
      rti._kind = 6;
      rti._primary = baseType;
      rti._canonicalRecipe = key;
      return H._Universe__installTypeTests(universe, rti);
    },
    _Universe__lookupQuestionRti(universe, baseType, normalize) {
      var t1,
        key = baseType._canonicalRecipe + "?",
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      t1 = H._Universe__createQuestionRti(universe, baseType, key, normalize);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__createQuestionRti(universe, baseType, key, normalize) {
      var baseKind, t1, starArgument, rti;
      if (normalize) {
        baseKind = baseType._kind;
        if (!H.isStrongTopType(baseType))
          if (!(baseType === type$.Null || baseType === type$.JSNull))
            if (baseKind !== 7)
              t1 = baseKind === 8 && H.isNullable(baseType._primary);
            else
              t1 = true;
          else
            t1 = true;
        else
          t1 = true;
        if (t1)
          return baseType;
        else if (baseKind === 1 || baseType === type$.legacy_Never)
          return type$.Null;
        else if (baseKind === 6) {
          starArgument = baseType._primary;
          if (starArgument._kind === 8 && H.isNullable(starArgument._primary))
            return starArgument;
          else
            return H.Rti__getQuestionFromStar(universe, baseType);
        }
      }
      rti = new H.Rti(null, null);
      rti._kind = 7;
      rti._primary = baseType;
      rti._canonicalRecipe = key;
      return H._Universe__installTypeTests(universe, rti);
    },
    _Universe__lookupFutureOrRti(universe, baseType, normalize) {
      var t1,
        key = baseType._canonicalRecipe + "/",
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      t1 = H._Universe__createFutureOrRti(universe, baseType, key, normalize);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__createFutureOrRti(universe, baseType, key, normalize) {
      var t1, t2, rti;
      if (normalize) {
        t1 = baseType._kind;
        if (!H.isStrongTopType(baseType))
          if (!(baseType === type$.legacy_Object))
            t2 = false;
          else
            t2 = true;
        else
          t2 = true;
        if (t2 || baseType === type$.Object)
          return baseType;
        else if (t1 === 1)
          return H._Universe__lookupInterfaceRti(universe, "Future", [baseType]);
        else if (baseType === type$.Null || baseType === type$.JSNull)
          return type$.nullable_Future_Null;
      }
      rti = new H.Rti(null, null);
      rti._kind = 8;
      rti._primary = baseType;
      rti._canonicalRecipe = key;
      return H._Universe__installTypeTests(universe, rti);
    },
    _Universe__lookupGenericFunctionParameterRti(universe, index) {
      var rti, t1,
        key = "" + index + "^",
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      rti = new H.Rti(null, null);
      rti._kind = 13;
      rti._primary = index;
      rti._canonicalRecipe = key;
      t1 = H._Universe__installTypeTests(universe, rti);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__canonicalRecipeJoin($arguments) {
      var s, sep, i,
        $length = $arguments.length;
      for (s = "", sep = "", i = 0; i < $length; ++i, sep = ",")
        s += sep + $arguments[i]._canonicalRecipe;
      return s;
    },
    _Universe__canonicalRecipeJoinNamed($arguments) {
      var s, sep, i, t1, nameSep, s0,
        $length = $arguments.length;
      for (s = "", sep = "", i = 0; i < $length; i += 3, sep = ",") {
        t1 = $arguments[i];
        nameSep = $arguments[i + 1] ? "!" : ":";
        s0 = $arguments[i + 2]._canonicalRecipe;
        s += sep + t1 + nameSep + s0;
      }
      return s;
    },
    _Universe__lookupInterfaceRti(universe, $name, $arguments) {
      var probe, rti, t1,
        s = $name;
      if ($arguments.length > 0)
        s += "<" + H._Universe__canonicalRecipeJoin($arguments) + ">";
      probe = universe.eC.get(s);
      if (probe != null)
        return probe;
      rti = new H.Rti(null, null);
      rti._kind = 9;
      rti._primary = $name;
      rti._rest = $arguments;
      if ($arguments.length > 0)
        rti._precomputed1 = $arguments[0];
      rti._canonicalRecipe = s;
      t1 = H._Universe__installTypeTests(universe, rti);
      universe.eC.set(s, t1);
      return t1;
    },
    _Universe__lookupBindingRti(universe, base, $arguments) {
      var newBase, newArguments, key, probe, rti, t1;
      if (base._kind === 10) {
        newBase = base._primary;
        newArguments = base._rest.concat($arguments);
      } else {
        newArguments = $arguments;
        newBase = base;
      }
      key = newBase._canonicalRecipe + (";<" + H._Universe__canonicalRecipeJoin(newArguments) + ">");
      probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      rti = new H.Rti(null, null);
      rti._kind = 10;
      rti._primary = newBase;
      rti._rest = newArguments;
      rti._canonicalRecipe = key;
      t1 = H._Universe__installTypeTests(universe, rti);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__lookupFunctionRti(universe, returnType, parameters) {
      var sep, t1, key, probe, rti,
        s = returnType._canonicalRecipe,
        requiredPositional = parameters._requiredPositional,
        requiredPositionalLength = requiredPositional.length,
        optionalPositional = parameters._optionalPositional,
        optionalPositionalLength = optionalPositional.length,
        named = parameters._named,
        namedLength = named.length,
        recipe = "(" + H._Universe__canonicalRecipeJoin(requiredPositional);
      if (optionalPositionalLength > 0) {
        sep = requiredPositionalLength > 0 ? "," : "";
        t1 = H._Universe__canonicalRecipeJoin(optionalPositional);
        recipe += sep + "[" + t1 + "]";
      }
      if (namedLength > 0) {
        sep = requiredPositionalLength > 0 ? "," : "";
        t1 = H._Universe__canonicalRecipeJoinNamed(named);
        recipe += sep + "{" + t1 + "}";
      }
      key = s + (recipe + ")");
      probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      rti = new H.Rti(null, null);
      rti._kind = 11;
      rti._primary = returnType;
      rti._rest = parameters;
      rti._canonicalRecipe = key;
      t1 = H._Universe__installTypeTests(universe, rti);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__lookupGenericFunctionRti(universe, baseFunctionType, bounds, normalize) {
      var t1,
        key = baseFunctionType._canonicalRecipe + ("<" + H._Universe__canonicalRecipeJoin(bounds) + ">"),
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      t1 = H._Universe__createGenericFunctionRti(universe, baseFunctionType, bounds, key, normalize);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__createGenericFunctionRti(universe, baseFunctionType, bounds, key, normalize) {
      var $length, typeArguments, count, i, bound, substitutedBase, substitutedBounds, rti;
      if (normalize) {
        $length = bounds.length;
        typeArguments = H._Utils_newArrayOrEmpty($length);
        for (count = 0, i = 0; i < $length; ++i) {
          bound = bounds[i];
          if (bound._kind === 1) {
            typeArguments[i] = bound;
            ++count;
          }
        }
        if (count > 0) {
          substitutedBase = H._substitute(universe, baseFunctionType, typeArguments, 0);
          substitutedBounds = H._substituteArray(universe, bounds, typeArguments, 0);
          return H._Universe__lookupGenericFunctionRti(universe, substitutedBase, substitutedBounds, bounds !== substitutedBounds);
        }
      }
      rti = new H.Rti(null, null);
      rti._kind = 12;
      rti._primary = baseFunctionType;
      rti._rest = bounds;
      rti._canonicalRecipe = key;
      return H._Universe__installTypeTests(universe, rti);
    },
    _Parser_create(universe, environment, recipe, normalize) {
      return {u: universe, e: environment, r: recipe, s: [], p: 0, n: normalize};
    },
    _Parser_parse(parser) {
      var t2, i, ch, t3, array, head, base, parameters, optionalPositional, named, item,
        source = parser.r,
        t1 = parser.s;
      for (t2 = source.length, i = 0; i < t2;) {
        ch = source.charCodeAt(i);
        if (ch >= 48 && ch <= 57)
          i = H._Parser_handleDigit(i + 1, ch, source, t1);
        else if ((((ch | 32) >>> 0) - 97 & 65535) < 26 || ch === 95 || ch === 36)
          i = H._Parser_handleIdentifier(parser, i, source, t1, false);
        else if (ch === 46)
          i = H._Parser_handleIdentifier(parser, i, source, t1, true);
        else {
          ++i;
          switch (ch) {
            case 44:
              break;
            case 58:
              t1.push(false);
              break;
            case 33:
              t1.push(true);
              break;
            case 59:
              t1.push(H._Parser_toType(parser.u, parser.e, t1.pop()));
              break;
            case 94:
              t1.push(H._Universe__lookupGenericFunctionParameterRti(parser.u, t1.pop()));
              break;
            case 35:
              t1.push(H._Universe__lookupTerminalRti(parser.u, 5, "#"));
              break;
            case 64:
              t1.push(H._Universe__lookupTerminalRti(parser.u, 2, "@"));
              break;
            case 126:
              t1.push(H._Universe__lookupTerminalRti(parser.u, 3, "~"));
              break;
            case 60:
              t1.push(parser.p);
              parser.p = t1.length;
              break;
            case 62:
              t3 = parser.u;
              array = t1.splice(parser.p);
              H._Parser_toTypes(parser.u, parser.e, array);
              parser.p = t1.pop();
              head = t1.pop();
              if (typeof head == "string")
                t1.push(H._Universe__lookupInterfaceRti(t3, head, array));
              else {
                base = H._Parser_toType(t3, parser.e, head);
                switch (base._kind) {
                  case 11:
                    t1.push(H._Universe__lookupGenericFunctionRti(t3, base, array, parser.n));
                    break;
                  default:
                    t1.push(H._Universe__lookupBindingRti(t3, base, array));
                    break;
                }
              }
              break;
            case 38:
              H._Parser_handleExtendedOperations(parser, t1);
              break;
            case 42:
              t3 = parser.u;
              t1.push(H._Universe__lookupStarRti(t3, H._Parser_toType(t3, parser.e, t1.pop()), parser.n));
              break;
            case 63:
              t3 = parser.u;
              t1.push(H._Universe__lookupQuestionRti(t3, H._Parser_toType(t3, parser.e, t1.pop()), parser.n));
              break;
            case 47:
              t3 = parser.u;
              t1.push(H._Universe__lookupFutureOrRti(t3, H._Parser_toType(t3, parser.e, t1.pop()), parser.n));
              break;
            case 40:
              t1.push(parser.p);
              parser.p = t1.length;
              break;
            case 41:
              t3 = parser.u;
              parameters = new H._FunctionParameters();
              optionalPositional = t3.sEA;
              named = t3.sEA;
              head = t1.pop();
              if (typeof head == "number")
                switch (head) {
                  case -1:
                    optionalPositional = t1.pop();
                    break;
                  case -2:
                    named = t1.pop();
                    break;
                  default:
                    t1.push(head);
                    break;
                }
              else
                t1.push(head);
              array = t1.splice(parser.p);
              H._Parser_toTypes(parser.u, parser.e, array);
              parser.p = t1.pop();
              parameters._requiredPositional = array;
              parameters._optionalPositional = optionalPositional;
              parameters._named = named;
              t1.push(H._Universe__lookupFunctionRti(t3, H._Parser_toType(t3, parser.e, t1.pop()), parameters));
              break;
            case 91:
              t1.push(parser.p);
              parser.p = t1.length;
              break;
            case 93:
              array = t1.splice(parser.p);
              H._Parser_toTypes(parser.u, parser.e, array);
              parser.p = t1.pop();
              t1.push(array);
              t1.push(-1);
              break;
            case 123:
              t1.push(parser.p);
              parser.p = t1.length;
              break;
            case 125:
              array = t1.splice(parser.p);
              H._Parser_toTypesNamed(parser.u, parser.e, array);
              parser.p = t1.pop();
              t1.push(array);
              t1.push(-2);
              break;
            default:
              throw "Bad character " + ch;
          }
        }
      }
      item = t1.pop();
      return H._Parser_toType(parser.u, parser.e, item);
    },
    _Parser_handleDigit(i, digit, source, stack) {
      var t1, ch,
        value = digit - 48;
      for (t1 = source.length; i < t1; ++i) {
        ch = source.charCodeAt(i);
        if (!(ch >= 48 && ch <= 57))
          break;
        value = value * 10 + (ch - 48);
      }
      stack.push(value);
      return i;
    },
    _Parser_handleIdentifier(parser, start, source, stack, hasPeriod) {
      var t1, ch, t2, string, environment, recipe,
        i = start + 1;
      for (t1 = source.length; i < t1; ++i) {
        ch = source.charCodeAt(i);
        if (ch === 46) {
          if (hasPeriod)
            break;
          hasPeriod = true;
        } else {
          if (!((((ch | 32) >>> 0) - 97 & 65535) < 26 || ch === 95 || ch === 36))
            t2 = ch >= 48 && ch <= 57;
          else
            t2 = true;
          if (!t2)
            break;
        }
      }
      string = source.substring(start, i);
      if (hasPeriod) {
        t1 = parser.u;
        environment = parser.e;
        if (environment._kind === 10)
          environment = environment._primary;
        recipe = H._Universe_findRule(t1, environment._primary)[string];
        if (recipe == null)
          H.throwExpression('No "' + string + '" in "' + H.Rti__getCanonicalRecipe(environment) + '"');
        stack.push(H._Universe_evalInEnvironment(t1, environment, recipe));
      } else
        stack.push(string);
      return i;
    },
    _Parser_handleExtendedOperations(parser, stack) {
      var $top = stack.pop();
      if (0 === $top) {
        stack.push(H._Universe__lookupTerminalRti(parser.u, 1, "0&"));
        return;
      }
      if (1 === $top) {
        stack.push(H._Universe__lookupTerminalRti(parser.u, 4, "1&"));
        return;
      }
      throw H.wrapException(P.AssertionError$("Unexpected extended operation " + H.S($top)));
    },
    _Parser_toType(universe, environment, item) {
      if (typeof item == "string")
        return H._Universe__lookupInterfaceRti(universe, item, universe.sEA);
      else if (typeof item == "number")
        return H._Parser_indexToType(universe, environment, item);
      else
        return item;
    },
    _Parser_toTypes(universe, environment, items) {
      var i,
        $length = items.length;
      for (i = 0; i < $length; ++i)
        items[i] = H._Parser_toType(universe, environment, items[i]);
    },
    _Parser_toTypesNamed(universe, environment, items) {
      var i,
        $length = items.length;
      for (i = 2; i < $length; i += 3)
        items[i] = H._Parser_toType(universe, environment, items[i]);
    },
    _Parser_indexToType(universe, environment, index) {
      var typeArguments, len,
        kind = environment._kind;
      if (kind === 10) {
        if (index === 0)
          return environment._primary;
        typeArguments = environment._rest;
        len = typeArguments.length;
        if (index <= len)
          return typeArguments[index - 1];
        index -= len;
        environment = environment._primary;
        kind = environment._kind;
      } else if (index === 0)
        return environment;
      if (kind !== 9)
        throw H.wrapException(P.AssertionError$("Indexed base must be an interface type"));
      typeArguments = environment._rest;
      if (index <= typeArguments.length)
        return typeArguments[index - 1];
      throw H.wrapException(P.AssertionError$("Bad index " + index + " for " + environment.toString$0(0)));
    },
    _isSubtype(universe, s, sEnv, t, tEnv) {
      var t1, sKind, leftTypeVariable, tKind, sBounds, tBounds, sLength, i, sBound, tBound;
      if (s === t)
        return true;
      if (!H.isStrongTopType(t))
        if (!(t === type$.legacy_Object))
          t1 = false;
        else
          t1 = true;
      else
        t1 = true;
      if (t1)
        return true;
      sKind = s._kind;
      if (sKind === 4)
        return true;
      if (H.isStrongTopType(s))
        return false;
      if (s._kind !== 1)
        t1 = false;
      else
        t1 = true;
      if (t1)
        return true;
      leftTypeVariable = sKind === 13;
      if (leftTypeVariable)
        if (H._isSubtype(universe, sEnv[s._primary], sEnv, t, tEnv))
          return true;
      tKind = t._kind;
      t1 = s === type$.Null || s === type$.JSNull;
      if (t1) {
        if (tKind === 8)
          return H._isSubtype(universe, s, sEnv, t._primary, tEnv);
        return t === type$.Null || t === type$.JSNull || tKind === 7 || tKind === 6;
      }
      if (t === type$.Object) {
        if (sKind === 8)
          return H._isSubtype(universe, s._primary, sEnv, t, tEnv);
        if (sKind === 6)
          return H._isSubtype(universe, s._primary, sEnv, t, tEnv);
        return sKind !== 7;
      }
      if (sKind === 6)
        return H._isSubtype(universe, s._primary, sEnv, t, tEnv);
      if (tKind === 6) {
        t1 = H.Rti__getQuestionFromStar(universe, t);
        return H._isSubtype(universe, s, sEnv, t1, tEnv);
      }
      if (sKind === 8) {
        if (!H._isSubtype(universe, s._primary, sEnv, t, tEnv))
          return false;
        return H._isSubtype(universe, H.Rti__getFutureFromFutureOr(universe, s), sEnv, t, tEnv);
      }
      if (sKind === 7) {
        t1 = H._isSubtype(universe, type$.Null, sEnv, t, tEnv);
        return t1 && H._isSubtype(universe, s._primary, sEnv, t, tEnv);
      }
      if (tKind === 8) {
        if (H._isSubtype(universe, s, sEnv, t._primary, tEnv))
          return true;
        return H._isSubtype(universe, s, sEnv, H.Rti__getFutureFromFutureOr(universe, t), tEnv);
      }
      if (tKind === 7) {
        t1 = H._isSubtype(universe, s, sEnv, type$.Null, tEnv);
        return t1 || H._isSubtype(universe, s, sEnv, t._primary, tEnv);
      }
      if (leftTypeVariable)
        return false;
      t1 = sKind !== 11;
      if ((!t1 || sKind === 12) && t === type$.Function)
        return true;
      if (tKind === 12) {
        if (s === type$.JavaScriptFunction)
          return true;
        if (sKind !== 12)
          return false;
        sBounds = s._rest;
        tBounds = t._rest;
        sLength = sBounds.length;
        if (sLength !== tBounds.length)
          return false;
        sEnv = sEnv == null ? sBounds : sBounds.concat(sEnv);
        tEnv = tEnv == null ? tBounds : tBounds.concat(tEnv);
        for (i = 0; i < sLength; ++i) {
          sBound = sBounds[i];
          tBound = tBounds[i];
          if (!H._isSubtype(universe, sBound, sEnv, tBound, tEnv) || !H._isSubtype(universe, tBound, tEnv, sBound, sEnv))
            return false;
        }
        return H._isFunctionSubtype(universe, s._primary, sEnv, t._primary, tEnv);
      }
      if (tKind === 11) {
        if (s === type$.JavaScriptFunction)
          return true;
        if (t1)
          return false;
        return H._isFunctionSubtype(universe, s, sEnv, t, tEnv);
      }
      if (sKind === 9) {
        if (tKind !== 9)
          return false;
        return H._isInterfaceSubtype(universe, s, sEnv, t, tEnv);
      }
      return false;
    },
    _isFunctionSubtype(universe, s, sEnv, t, tEnv) {
      var sParameters, tParameters, sRequiredPositional, tRequiredPositional, sRequiredPositionalLength, tRequiredPositionalLength, requiredPositionalDelta, sOptionalPositional, tOptionalPositional, sOptionalPositionalLength, tOptionalPositionalLength, i, t1, sNamed, tNamed, sNamedLength, tNamedLength, sIndex, tIndex, tName, sName, sIsRequired;
      if (!H._isSubtype(universe, s._primary, sEnv, t._primary, tEnv))
        return false;
      sParameters = s._rest;
      tParameters = t._rest;
      sRequiredPositional = sParameters._requiredPositional;
      tRequiredPositional = tParameters._requiredPositional;
      sRequiredPositionalLength = sRequiredPositional.length;
      tRequiredPositionalLength = tRequiredPositional.length;
      if (sRequiredPositionalLength > tRequiredPositionalLength)
        return false;
      requiredPositionalDelta = tRequiredPositionalLength - sRequiredPositionalLength;
      sOptionalPositional = sParameters._optionalPositional;
      tOptionalPositional = tParameters._optionalPositional;
      sOptionalPositionalLength = sOptionalPositional.length;
      tOptionalPositionalLength = tOptionalPositional.length;
      if (sRequiredPositionalLength + sOptionalPositionalLength < tRequiredPositionalLength + tOptionalPositionalLength)
        return false;
      for (i = 0; i < sRequiredPositionalLength; ++i) {
        t1 = sRequiredPositional[i];
        if (!H._isSubtype(universe, tRequiredPositional[i], tEnv, t1, sEnv))
          return false;
      }
      for (i = 0; i < requiredPositionalDelta; ++i) {
        t1 = sOptionalPositional[i];
        if (!H._isSubtype(universe, tRequiredPositional[sRequiredPositionalLength + i], tEnv, t1, sEnv))
          return false;
      }
      for (i = 0; i < tOptionalPositionalLength; ++i) {
        t1 = sOptionalPositional[requiredPositionalDelta + i];
        if (!H._isSubtype(universe, tOptionalPositional[i], tEnv, t1, sEnv))
          return false;
      }
      sNamed = sParameters._named;
      tNamed = tParameters._named;
      sNamedLength = sNamed.length;
      tNamedLength = tNamed.length;
      for (sIndex = 0, tIndex = 0; tIndex < tNamedLength; tIndex += 3) {
        tName = tNamed[tIndex];
        for (; true;) {
          if (sIndex >= sNamedLength)
            return false;
          sName = sNamed[sIndex];
          sIndex += 3;
          if (tName < sName)
            return false;
          sIsRequired = sNamed[sIndex - 2];
          if (sName < tName) {
            if (sIsRequired)
              return false;
            continue;
          }
          t1 = tNamed[tIndex + 1];
          if (sIsRequired && !t1)
            return false;
          t1 = sNamed[sIndex - 1];
          if (!H._isSubtype(universe, tNamed[tIndex + 2], tEnv, t1, sEnv))
            return false;
          break;
        }
      }
      for (; sIndex < sNamedLength;) {
        if (sNamed[sIndex + 1])
          return false;
        sIndex += 3;
      }
      return true;
    },
    _isInterfaceSubtype(universe, s, sEnv, t, tEnv) {
      var rule, recipes, $length, supertypeArgs, i, t1, t2,
        sName = s._primary,
        tName = t._primary;
      for (; sName !== tName;) {
        rule = universe.tR[sName];
        if (rule == null)
          return false;
        if (typeof rule == "string") {
          sName = rule;
          continue;
        }
        recipes = rule[tName];
        if (recipes == null)
          return false;
        $length = recipes.length;
        supertypeArgs = $length > 0 ? new Array($length) : init.typeUniverse.sEA;
        for (i = 0; i < $length; ++i)
          supertypeArgs[i] = H._Universe_evalInEnvironment(universe, s, recipes[i]);
        return H._areArgumentsSubtypes(universe, supertypeArgs, null, sEnv, t._rest, tEnv);
      }
      t1 = s._rest;
      t2 = t._rest;
      return H._areArgumentsSubtypes(universe, t1, null, sEnv, t2, tEnv);
    },
    _areArgumentsSubtypes(universe, sArgs, sVariances, sEnv, tArgs, tEnv) {
      var i, t1, t2,
        $length = sArgs.length;
      for (i = 0; i < $length; ++i) {
        t1 = sArgs[i];
        t2 = tArgs[i];
        if (!H._isSubtype(universe, t1, sEnv, t2, tEnv))
          return false;
      }
      return true;
    },
    isNullable(t) {
      var t1,
        kind = t._kind;
      if (!(t === type$.Null || t === type$.JSNull))
        if (!H.isStrongTopType(t))
          if (kind !== 7)
            if (!(kind === 6 && H.isNullable(t._primary)))
              t1 = kind === 8 && H.isNullable(t._primary);
            else
              t1 = true;
          else
            t1 = true;
        else
          t1 = true;
      else
        t1 = true;
      return t1;
    },
    isTopType(t) {
      var t1;
      if (!H.isStrongTopType(t))
        if (!(t === type$.legacy_Object))
          t1 = false;
        else
          t1 = true;
      else
        t1 = true;
      return t1;
    },
    isStrongTopType(t) {
      var kind = t._kind;
      return kind === 2 || kind === 3 || kind === 4 || kind === 5 || t === type$.nullable_Object;
    },
    _Utils_objectAssign(o, other) {
      var i, key,
        keys = Object.keys(other),
        $length = keys.length;
      for (i = 0; i < $length; ++i) {
        key = keys[i];
        o[key] = other[key];
      }
    },
    _Utils_newArrayOrEmpty($length) {
      return $length > 0 ? new Array($length) : init.typeUniverse.sEA;
    },
    Rti: function Rti(t0, t1) {
      var _ = this;
      _._as = t0;
      _._is = t1;
      _._cachedRuntimeType = _._specializedTestResource = _._precomputed1 = null;
      _._kind = 0;
      _._canonicalRecipe = _._bindCache = _._evalCache = _._rest = _._primary = null;
    },
    _FunctionParameters: function _FunctionParameters() {
      this._named = this._optionalPositional = this._requiredPositional = null;
    },
    _Type: function _Type(t0) {
      this._rti = t0;
    },
    _Error: function _Error() {
    },
    _TypeError: function _TypeError(t0) {
      this.__rti$_message = t0;
    },
    printString(string) {
      if (typeof dartPrint == "function") {
        dartPrint(string);
        return;
      }
      if (typeof console == "object" && typeof console.log != "undefined") {
        console.log(string);
        return;
      }
      if (typeof window == "object")
        return;
      if (typeof print == "function") {
        print(string);
        return;
      }
      throw "Unable to print message: " + String(string);
    }
  },
  J = {
    makeDispatchRecord(interceptor, proto, extension, indexability) {
      return {i: interceptor, p: proto, e: extension, x: indexability};
    },
    getNativeInterceptor(object) {
      var proto, objectProto, $constructor, interceptor, t1,
        record = object[init.dispatchPropertyName];
      if (record == null)
        if ($.initNativeDispatchFlag == null) {
          H.initNativeDispatch();
          record = object[init.dispatchPropertyName];
        }
      if (record != null) {
        proto = record.p;
        if (false === proto)
          return record.i;
        if (true === proto)
          return object;
        objectProto = Object.getPrototypeOf(object);
        if (proto === objectProto)
          return record.i;
        if (record.e === objectProto)
          throw H.wrapException(P.UnimplementedError$("Return interceptor for " + H.S(proto(object, record))));
      }
      $constructor = object.constructor;
      if ($constructor == null)
        interceptor = null;
      else {
        t1 = $._JS_INTEROP_INTERCEPTOR_TAG;
        if (t1 == null)
          t1 = $._JS_INTEROP_INTERCEPTOR_TAG = init.getIsolateTag("_$dart_js");
        interceptor = $constructor[t1];
      }
      if (interceptor != null)
        return interceptor;
      interceptor = H.lookupAndCacheInterceptor(object);
      if (interceptor != null)
        return interceptor;
      if (typeof object == "function")
        return C.JavaScriptFunction_methods;
      proto = Object.getPrototypeOf(object);
      if (proto == null)
        return C.PlainJavaScriptObject_methods;
      if (proto === Object.prototype)
        return C.PlainJavaScriptObject_methods;
      if (typeof $constructor == "function") {
        t1 = $._JS_INTEROP_INTERCEPTOR_TAG;
        if (t1 == null)
          t1 = $._JS_INTEROP_INTERCEPTOR_TAG = init.getIsolateTag("_$dart_js");
        Object.defineProperty($constructor, t1, {value: C.UnknownJavaScriptObject_methods, enumerable: false, writable: true, configurable: true});
        return C.UnknownJavaScriptObject_methods;
      }
      return C.UnknownJavaScriptObject_methods;
    },
    JSArray_JSArray$fixed($length, $E) {
      if ($length < 0 || $length > 4294967295)
        throw H.wrapException(P.RangeError$range($length, 0, 4294967295, "length", null));
      return J.JSArray_JSArray$markFixed(new Array($length), $E);
    },
    JSArray_JSArray$allocateFixed($length, $E) {
      if ($length > 4294967295)
        throw H.wrapException(P.RangeError$range($length, 0, 4294967295, "length", null));
      return J.JSArray_JSArray$markFixed(new Array($length), $E);
    },
    JSArray_JSArray$growable($length, $E) {
      if ($length < 0)
        throw H.wrapException(P.ArgumentError$("Length must be a non-negative integer: " + $length, null));
      return H._setArrayType(new Array($length), $E._eval$1("JSArray<0>"));
    },
    JSArray_JSArray$allocateGrowable($length, $E) {
      if ($length < 0)
        throw H.wrapException(P.ArgumentError$("Length must be a non-negative integer: " + $length, null));
      return H._setArrayType(new Array($length), $E._eval$1("JSArray<0>"));
    },
    JSArray_JSArray$markFixed(allocation, $E) {
      return J.JSArray_markFixedList(H._setArrayType(allocation, $E._eval$1("JSArray<0>")));
    },
    JSArray_markFixedList(list) {
      list.fixed$length = Array;
      return list;
    },
    JSArray_markUnmodifiableList(list) {
      list.fixed$length = Array;
      list.immutable$list = Array;
      return list;
    },
    JSArray__compareAny(a, b) {
      return J.compareTo$1$ns(a, b);
    },
    JSString__isWhitespace(codeUnit) {
      if (codeUnit < 256)
        switch (codeUnit) {
          case 9:
          case 10:
          case 11:
          case 12:
          case 13:
          case 32:
          case 133:
          case 160:
            return true;
          default:
            return false;
        }
      switch (codeUnit) {
        case 5760:
        case 8192:
        case 8193:
        case 8194:
        case 8195:
        case 8196:
        case 8197:
        case 8198:
        case 8199:
        case 8200:
        case 8201:
        case 8202:
        case 8232:
        case 8233:
        case 8239:
        case 8287:
        case 12288:
        case 65279:
          return true;
        default:
          return false;
      }
    },
    JSString__skipLeadingWhitespace(string, index) {
      var t1, codeUnit;
      for (t1 = string.length; index < t1;) {
        codeUnit = C.JSString_methods._codeUnitAt$1(string, index);
        if (codeUnit !== 32 && codeUnit !== 13 && !J.JSString__isWhitespace(codeUnit))
          break;
        ++index;
      }
      return index;
    },
    JSString__skipTrailingWhitespace(string, index) {
      var index0, codeUnit;
      for (; index > 0; index = index0) {
        index0 = index - 1;
        codeUnit = C.JSString_methods.codeUnitAt$1(string, index0);
        if (codeUnit !== 32 && codeUnit !== 13 && !J.JSString__isWhitespace(codeUnit))
          break;
      }
      return index;
    },
    getInterceptor$(receiver) {
      if (typeof receiver == "number") {
        if (Math.floor(receiver) == receiver)
          return J.JSInt.prototype;
        return J.JSNumNotInt.prototype;
      }
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return J.JSNull.prototype;
      if (typeof receiver == "boolean")
        return J.JSBool.prototype;
      if (receiver.constructor == Array)
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$ansx(receiver) {
      if (typeof receiver == "number")
        return J.JSNumber.prototype;
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (receiver.constructor == Array)
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$asx(receiver) {
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (receiver.constructor == Array)
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$ax(receiver) {
      if (receiver == null)
        return receiver;
      if (receiver.constructor == Array)
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$n(receiver) {
      if (typeof receiver == "number")
        return J.JSNumber.prototype;
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof P.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$ns(receiver) {
      if (typeof receiver == "number")
        return J.JSNumber.prototype;
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof P.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$s(receiver) {
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof P.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$u(receiver) {
      if (receiver == null)
        return J.JSNull.prototype;
      if (!(receiver instanceof P.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$x(receiver) {
      if (receiver == null)
        return receiver;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$z(receiver) {
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof P.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    set$FALSE$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$FALSE(receiver, value);
    },
    set$NULL$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$NULL(receiver, value);
    },
    set$TRUE$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$TRUE(receiver, value);
    },
    set$cli_pkg_main_0_$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$cli_pkg_main_0_(receiver, value);
    },
    set$context$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$context(receiver, value);
    },
    set$dartValue$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$dartValue(receiver, value);
    },
    set$exitCode$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$exitCode(receiver, value);
    },
    set$info$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$info(receiver, value);
    },
    set$length$asx(receiver, value) {
      return J.getInterceptor$asx(receiver).set$length(receiver, value);
    },
    set$render$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$render(receiver, value);
    },
    set$renderSync$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$renderSync(receiver, value);
    },
    set$types$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$types(receiver, value);
    },
    get$code$x(receiver) {
      return J.getInterceptor$x(receiver).get$code(receiver);
    },
    get$current$x(receiver) {
      return J.getInterceptor$x(receiver).get$current(receiver);
    },
    get$dartValue$x(receiver) {
      return J.getInterceptor$x(receiver).get$dartValue(receiver);
    },
    get$end$z(receiver) {
      return J.getInterceptor$z(receiver).get$end(receiver);
    },
    get$env$x(receiver) {
      return J.getInterceptor$x(receiver).get$env(receiver);
    },
    get$exitCode$x(receiver) {
      return J.getInterceptor$x(receiver).get$exitCode(receiver);
    },
    get$fiber$x(receiver) {
      return J.getInterceptor$x(receiver).get$fiber(receiver);
    },
    get$file$x(receiver) {
      return J.getInterceptor$x(receiver).get$file(receiver);
    },
    get$first$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$first(receiver);
    },
    get$functions$x(receiver) {
      return J.getInterceptor$x(receiver).get$functions(receiver);
    },
    get$hashCode$(receiver) {
      return J.getInterceptor$(receiver).get$hashCode(receiver);
    },
    get$isEmpty$asx(receiver) {
      return J.getInterceptor$asx(receiver).get$isEmpty(receiver);
    },
    get$isNotEmpty$asx(receiver) {
      return J.getInterceptor$asx(receiver).get$isNotEmpty(receiver);
    },
    get$isTTY$x(receiver) {
      return J.getInterceptor$x(receiver).get$isTTY(receiver);
    },
    get$iterator$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$iterator(receiver);
    },
    get$keys$z(receiver) {
      return J.getInterceptor$z(receiver).get$keys(receiver);
    },
    get$last$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$last(receiver);
    },
    get$length$asx(receiver) {
      return J.getInterceptor$asx(receiver).get$length(receiver);
    },
    get$message$x(receiver) {
      return J.getInterceptor$x(receiver).get$message(receiver);
    },
    get$mtime$x(receiver) {
      return J.getInterceptor$x(receiver).get$mtime(receiver);
    },
    get$name$x(receiver) {
      return J.getInterceptor$x(receiver).get$name(receiver);
    },
    get$options$x(receiver) {
      return J.getInterceptor$x(receiver).get$options(receiver);
    },
    get$parent$z(receiver) {
      return J.getInterceptor$z(receiver).get$parent(receiver);
    },
    get$path$x(receiver) {
      return J.getInterceptor$x(receiver).get$path(receiver);
    },
    get$platform$x(receiver) {
      return J.getInterceptor$x(receiver).get$platform(receiver);
    },
    get$reversed$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$reversed(receiver);
    },
    get$runtimeType$u(receiver) {
      return J.getInterceptor$u(receiver).get$runtimeType(receiver);
    },
    get$single$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$single(receiver);
    },
    get$stderr$x(receiver) {
      return J.getInterceptor$x(receiver).get$stderr(receiver);
    },
    get$stdin$x(receiver) {
      return J.getInterceptor$x(receiver).get$stdin(receiver);
    },
    get$values$z(receiver) {
      return J.getInterceptor$z(receiver).get$values(receiver);
    },
    $add$ansx(receiver, a0) {
      if (typeof receiver == "number" && typeof a0 == "number")
        return receiver + a0;
      return J.getInterceptor$ansx(receiver).$add(receiver, a0);
    },
    $eq$(receiver, a0) {
      if (receiver == null)
        return a0 == null;
      if (typeof receiver != "object")
        return a0 != null && receiver === a0;
      return J.getInterceptor$(receiver).$eq(receiver, a0);
    },
    $index$asx(receiver, a0) {
      if (typeof a0 === "number")
        if (receiver.constructor == Array || typeof receiver == "string" || H.isJsIndexable(receiver, receiver[init.dispatchPropertyName]))
          if (a0 >>> 0 === a0 && a0 < receiver.length)
            return receiver[a0];
      return J.getInterceptor$asx(receiver).$index(receiver, a0);
    },
    $indexSet$ax(receiver, a0, a1) {
      if (typeof a0 === "number")
        if ((receiver.constructor == Array || H.isJsIndexable(receiver, receiver[init.dispatchPropertyName])) && !receiver.immutable$list && a0 >>> 0 === a0 && a0 < receiver.length)
          return receiver[a0] = a1;
      return J.getInterceptor$ax(receiver).$indexSet(receiver, a0, a1);
    },
    add$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).add$1(receiver, a0);
    },
    addAll$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).addAll$1(receiver, a0);
    },
    allMatches$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).allMatches$1(receiver, a0);
    },
    allMatches$2$s(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).allMatches$2(receiver, a0, a1);
    },
    any$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).any$1(receiver, a0);
    },
    apply$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).apply$2(receiver, a0, a1);
    },
    cast$1$0$ax(receiver, $T1) {
      return J.getInterceptor$ax(receiver).cast$1$0(receiver, $T1);
    },
    close$0$x(receiver) {
      return J.getInterceptor$x(receiver).close$0(receiver);
    },
    codeUnitAt$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).codeUnitAt$1(receiver, a0);
    },
    compareTo$1$ns(receiver, a0) {
      return J.getInterceptor$ns(receiver).compareTo$1(receiver, a0);
    },
    contains$1$asx(receiver, a0) {
      return J.getInterceptor$asx(receiver).contains$1(receiver, a0);
    },
    createInterface$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).createInterface$1(receiver, a0);
    },
    elementAt$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).elementAt$1(receiver, a0);
    },
    endsWith$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).endsWith$1(receiver, a0);
    },
    every$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).every$1(receiver, a0);
    },
    existsSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).existsSync$1(receiver, a0);
    },
    expand$1$1$ax(receiver, a0, $T1) {
      return J.getInterceptor$ax(receiver).expand$1$1(receiver, a0, $T1);
    },
    fillRange$3$ax(receiver, a0, a1, a2) {
      return J.getInterceptor$ax(receiver).fillRange$3(receiver, a0, a1, a2);
    },
    fold$2$ax(receiver, a0, a1) {
      return J.getInterceptor$ax(receiver).fold$2(receiver, a0, a1);
    },
    getRange$2$ax(receiver, a0, a1) {
      return J.getInterceptor$ax(receiver).getRange$2(receiver, a0, a1);
    },
    getTime$0$x(receiver) {
      return J.getInterceptor$x(receiver).getTime$0(receiver);
    },
    isDirectory$0$x(receiver) {
      return J.getInterceptor$x(receiver).isDirectory$0(receiver);
    },
    isFile$0$x(receiver) {
      return J.getInterceptor$x(receiver).isFile$0(receiver);
    },
    join$0$ax(receiver) {
      return J.getInterceptor$ax(receiver).join$0(receiver);
    },
    join$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).join$1(receiver, a0);
    },
    listen$1$z(receiver, a0) {
      return J.getInterceptor$z(receiver).listen$1(receiver, a0);
    },
    map$1$1$ax(receiver, a0, $T1) {
      return J.getInterceptor$ax(receiver).map$1$1(receiver, a0, $T1);
    },
    matchAsPrefix$2$s(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).matchAsPrefix$2(receiver, a0, a1);
    },
    mkdirSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).mkdirSync$1(receiver, a0);
    },
    noSuchMethod$1$(receiver, a0) {
      return J.getInterceptor$(receiver).noSuchMethod$1(receiver, a0);
    },
    on$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).on$2(receiver, a0, a1);
    },
    readFileSync$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).readFileSync$2(receiver, a0, a1);
    },
    readdirSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).readdirSync$1(receiver, a0);
    },
    remove$1$z(receiver, a0) {
      return J.getInterceptor$z(receiver).remove$1(receiver, a0);
    },
    run$0$x(receiver) {
      return J.getInterceptor$x(receiver).run$0(receiver);
    },
    run$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).run$1(receiver, a0);
    },
    setRange$4$ax(receiver, a0, a1, a2, a3) {
      return J.getInterceptor$ax(receiver).setRange$4(receiver, a0, a1, a2, a3);
    },
    skip$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).skip$1(receiver, a0);
    },
    sort$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).sort$1(receiver, a0);
    },
    startsWith$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).startsWith$1(receiver, a0);
    },
    statSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).statSync$1(receiver, a0);
    },
    substring$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).substring$1(receiver, a0);
    },
    substring$2$s(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).substring$2(receiver, a0, a1);
    },
    take$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).take$1(receiver, a0);
    },
    then$1$1$z(receiver, a0, $T1) {
      return J.getInterceptor$z(receiver).then$1$1(receiver, a0, $T1);
    },
    then$1$2$onError$z(receiver, a0, a1, $T1) {
      return J.getInterceptor$z(receiver).then$1$2$onError(receiver, a0, a1, $T1);
    },
    toList$0$ax(receiver) {
      return J.getInterceptor$ax(receiver).toList$0(receiver);
    },
    toList$1$growable$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).toList$1$growable(receiver, a0);
    },
    toRadixString$1$n(receiver, a0) {
      return J.getInterceptor$n(receiver).toRadixString$1(receiver, a0);
    },
    toSet$0$ax(receiver) {
      return J.getInterceptor$ax(receiver).toSet$0(receiver);
    },
    toString$0$(receiver) {
      return J.getInterceptor$(receiver).toString$0(receiver);
    },
    toString$1$color$(receiver, a0) {
      return J.getInterceptor$(receiver).toString$1$color(receiver, a0);
    },
    trim$0$s(receiver) {
      return J.getInterceptor$s(receiver).trim$0(receiver);
    },
    unlinkSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).unlinkSync$1(receiver, a0);
    },
    watch$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).watch$2(receiver, a0, a1);
    },
    where$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).where$1(receiver, a0);
    },
    write$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).write$1(receiver, a0);
    },
    writeFileSync$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).writeFileSync$2(receiver, a0, a1);
    },
    yield$0$x(receiver) {
      return J.getInterceptor$x(receiver).yield$0(receiver);
    },
    Interceptor: function Interceptor() {
    },
    JSBool: function JSBool() {
    },
    JSNull: function JSNull() {
    },
    JavaScriptObject: function JavaScriptObject() {
    },
    PlainJavaScriptObject: function PlainJavaScriptObject() {
    },
    UnknownJavaScriptObject: function UnknownJavaScriptObject() {
    },
    JavaScriptFunction: function JavaScriptFunction() {
    },
    JSArray: function JSArray(t0) {
      this.$ti = t0;
    },
    JSUnmodifiableArray: function JSUnmodifiableArray(t0) {
      this.$ti = t0;
    },
    ArrayIterator: function ArrayIterator(t0, t1) {
      var _ = this;
      _._iterable = t0;
      _._length = t1;
      _._index = 0;
      _._current = null;
    },
    JSNumber: function JSNumber() {
    },
    JSInt: function JSInt() {
    },
    JSNumNotInt: function JSNumNotInt() {
    },
    JSString: function JSString() {
    }
  },
  K = {
    PathMap__create(context, $V) {
      var t1 = {};
      t1.context = context;
      t1.context = $.$get$context();
      return P.LinkedHashMap_LinkedHashMap(new K.PathMap__create_closure(t1), new K.PathMap__create_closure0(t1), new K.PathMap__create_closure1(), type$.nullable_String, $V);
    },
    PathMap: function PathMap(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    PathMap__create_closure: function PathMap__create_closure(t0) {
      this._box_0 = t0;
    },
    PathMap__create_closure0: function PathMap__create_closure0(t0) {
      this._box_0 = t0;
    },
    PathMap__create_closure1: function PathMap__create_closure1() {
    },
    ColorExpression: function ColorExpression(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    _updateComponents($arguments, adjust, change, scale) {
      var keywords, alpha, red, green, blue, hueNumber, t2, hue, saturation, lightness, whiteness, blackness, hasRgb, hasSL, hasWB, t3, t4, t5, _null = null,
        t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color"),
        argumentList = type$.SassArgumentList._as(t1.$index($arguments, 1));
      if (argumentList._list$_contents.length !== 0)
        throw H.wrapException(E.SassScriptException$(string$.Only_op));
      argumentList._wereKeywordsAccessed = true;
      keywords = P.LinkedHashMap_LinkedHashMap$of(argumentList._keywords, type$.String, type$.Value);
      t1 = new K._updateComponents_getParam(keywords, scale, change);
      alpha = t1.call$2("alpha", 1);
      red = t1.call$2("red", 255);
      green = t1.call$2("green", 255);
      blue = t1.call$2("blue", 255);
      if (scale)
        hueNumber = _null;
      else {
        t2 = keywords.remove$1(0, "hue");
        hueNumber = t2 == null ? _null : t2.assertNumber$1("hue");
      }
      t2 = hueNumber == null;
      if (!t2)
        K._checkAngle(hueNumber, "hue");
      hue = t2 ? _null : hueNumber.value;
      saturation = t1.call$3$checkPercent("saturation", 100, true);
      lightness = t1.call$3$checkPercent("lightness", 100, true);
      whiteness = t1.call$3$assertPercent("whiteness", 100, true);
      blackness = t1.call$3$assertPercent("blackness", 100, true);
      if (keywords.get$isNotEmpty(keywords))
        throw H.wrapException(E.SassScriptException$("No " + B.pluralize("argument", keywords.get$length(keywords), _null) + " named " + H.S(B.toSentence(keywords.get$keys(keywords).map$1$1(0, new K._updateComponents_closure(), type$.Object), "or")) + "."));
      hasRgb = red != null || green != null || blue != null;
      hasSL = saturation != null || lightness != null;
      hasWB = whiteness != null || blackness != null;
      if (hasRgb)
        t1 = hasSL || hasWB || hue != null;
      else
        t1 = false;
      if (t1)
        throw H.wrapException(E.SassScriptException$(string$.RGB_pa + (hasWB ? "HWB" : "HSL") + " parameters."));
      if (hasSL && hasWB)
        throw H.wrapException(E.SassScriptException$(string$.HSL_pa));
      t1 = new K._updateComponents_updateValue(change, adjust);
      t2 = new K._updateComponents_updateRgb(t1);
      if (hasRgb) {
        t3 = t2.call$2(color.get$red(), red);
        t4 = t2.call$2(color.get$green(), green);
        t2 = t2.call$2(color.get$blue(), blue);
        return color.changeRgb$4$alpha$blue$green$red(t1.call$3(color.alpha, alpha, 1), t2, t4, t3);
      } else if (hasWB) {
        if (change)
          t2 = hue;
        else {
          t2 = color.get$hue();
          t2 += hue == null ? 0 : hue;
        }
        t3 = t1.call$3(color.get$whiteness(), whiteness, 100);
        t4 = t1.call$3(color.get$blackness(), blackness, 100);
        t5 = color.alpha;
        t1 = t1.call$3(t5, alpha, 1);
        if (t2 == null)
          t2 = color.get$hue();
        if (t3 == null)
          t3 = color.get$whiteness();
        if (t4 == null)
          t4 = color.get$blackness();
        return K.SassColor_SassColor$hwb(t2, t3, t4, t1 == null ? t5 : t1);
      } else {
        t2 = hue == null;
        if (!t2 || hasSL) {
          if (change)
            t2 = hue;
          else {
            t3 = color.get$hue();
            t3 += t2 ? 0 : hue;
            t2 = t3;
          }
          t3 = t1.call$3(color.get$saturation(), saturation, 100);
          t4 = t1.call$3(color.get$lightness(), lightness, 100);
          return color.changeHsl$4$alpha$hue$lightness$saturation(t1.call$3(color.alpha, alpha, 1), t2, t4, t3);
        } else if (alpha != null)
          return color.changeAlpha$1(t1.call$3(color.alpha, alpha, 1));
        else
          return color;
      }
    },
    _functionString($name, $arguments) {
      return new D.SassString($name + "(" + J.map$1$1$ax($arguments, new K._functionString_closure(), type$.String).join$1(0, ", ") + ")", false);
    },
    _removedColorFunction($name, argument, negative) {
      return Q.BuiltInCallable$function($name, "$color, $amount", new K._removedColorFunction_closure($name, argument, negative), "sass:color");
    },
    _rgb($name, $arguments) {
      var t2, red, green, blue,
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return K._functionString($name, $arguments);
      red = t1.$index($arguments, 0).assertNumber$1("red");
      green = t1.$index($arguments, 1).assertNumber$1("green");
      blue = t1.$index($arguments, 2).assertNumber$1("blue");
      return K.SassColor$rgb(T.fuzzyRound(K._percentageOrUnitless(red, 255, "red")), T.fuzzyRound(K._percentageOrUnitless(green, 255, "green")), T.fuzzyRound(K._percentageOrUnitless(blue, 255, "blue")), X.NullableExtension_andThen(alpha, new K._rgb_closure()), null);
    },
    _rgbTwoArg($name, $arguments) {
      var first, color,
        t1 = J.getInterceptor$asx($arguments);
      if (t1.$index($arguments, 0).get$isVar())
        return K._functionString($name, $arguments);
      else if (t1.$index($arguments, 1).get$isVar()) {
        first = t1.$index($arguments, 0);
        if (first instanceof K.SassColor)
          return new D.SassString($name + "(" + first.get$red() + ", " + first.get$green() + ", " + first.get$blue() + ", " + N.serializeValue0(t1.$index($arguments, 1), false, true) + ")", false);
        else
          return K._functionString($name, $arguments);
      } else if (t1.$index($arguments, 1).get$isSpecialNumber()) {
        color = t1.$index($arguments, 0).assertColor$1("color");
        return new D.SassString($name + "(" + color.get$red() + ", " + color.get$green() + ", " + color.get$blue() + ", " + N.serializeValue0(t1.$index($arguments, 1), false, true) + ")", false);
      }
      return t1.$index($arguments, 0).assertColor$1("color").changeAlpha$1(K._percentageOrUnitless(t1.$index($arguments, 1).assertNumber$1("alpha"), 1, "alpha"));
    },
    _hsl($name, $arguments) {
      var t2, hue, saturation, lightness,
        _s10_ = "saturation",
        _s9_ = "lightness",
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return K._functionString($name, $arguments);
      hue = t1.$index($arguments, 0).assertNumber$1("hue");
      saturation = t1.$index($arguments, 1).assertNumber$1(_s10_);
      lightness = t1.$index($arguments, 2).assertNumber$1(_s9_);
      K._checkAngle(hue, "hue");
      K._checkPercent(saturation, _s10_);
      K._checkPercent(lightness, _s9_);
      return K.SassColor$hsl(hue.value, C.JSNumber_methods.clamp$2(saturation.value, 0, 100), C.JSNumber_methods.clamp$2(lightness.value, 0, 100), X.NullableExtension_andThen(alpha, new K._hsl_closure()));
    },
    _checkAngle(angle, $name) {
      var t1, t2, t3, actualUnit,
        _s31_ = "To preserve current behavior: $";
      if (!angle.get$hasUnits() || angle.hasUnit$1("deg"))
        return;
      t1 = "" + ("$" + H.S($name) + ": Passing a unit other than deg (" + angle.toString$0(0) + ") is deprecated.\n") + "\n";
      if (angle.compatibleWithUnit$1("deg")) {
        t2 = "You're passing " + angle.toString$0(0) + string$.x2c_whici;
        t3 = type$.JSArray_String;
        t3 = t1 + (t2 + new L.SingleUnitSassNumber("deg", angle.value, null).toString$0(0) + ".\n") + (string$.Soon__ + angle.coerce$2(H._setArrayType(["deg"], t3), H._setArrayType([], t3)).toString$0(0) + ".\n") + "\n";
        actualUnit = J.get$first$ax(angle.get$numeratorUnits());
        t3 = t3 + (_s31_ + H.S($name) + " * 1deg/1" + actualUnit + "\n") + ("To migrate to new behavior: 0deg + $" + H.S($name) + "\n") + "\n";
        t1 = t3;
      } else
        t1 = t1 + (_s31_ + H.S($name) + K._removeUnits(angle) + "\n") + "\n";
      t1 += "See https://sass-lang.com/d/color-units";
      N.warn(t1.charCodeAt(0) == 0 ? t1 : t1, true);
    },
    _checkPercent(number, $name) {
      if (number.hasUnit$1("%"))
        return;
      N.warn("$" + $name + ": Passing a number without unit % (" + number.toString$0(0) + string$.x29x20is_d + $name + K._removeUnits(number) + " * 1%", true);
    },
    _removeUnits(number) {
      var t1 = number.get$denominatorUnits();
      return new H.MappedListIterable(t1, new K._removeUnits_closure(), H._arrayInstanceType(t1)._eval$1("MappedListIterable<1,String>")).join$0(0) + J.map$1$1$ax(number.get$numeratorUnits(), new K._removeUnits_closure0(), type$.String).join$0(0);
    },
    _hwb($arguments) {
      var _s9_ = "whiteness",
        _s9_0 = "blackness",
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null,
        hue = t1.$index($arguments, 0).assertNumber$1("hue"),
        whiteness = t1.$index($arguments, 1).assertNumber$1(_s9_),
        blackness = t1.$index($arguments, 2).assertNumber$1(_s9_0);
      whiteness.assertUnit$2("%", _s9_);
      blackness.assertUnit$2("%", _s9_0);
      return K.SassColor_SassColor$hwb(hue.value, whiteness.valueInRange$3(0, 100, _s9_), blackness.valueInRange$3(0, 100, _s9_0), X.NullableExtension_andThen(alpha, new K._hwb_closure()));
    },
    _parseChannels($name, argumentNames, channels) {
      var list, t1, channels0, alphaFromSlashList, isCommaSeparated, isBracketed, buffer, maybeSlashSeparated, slash,
        _s17_ = "$channels must be";
      if (channels.get$isVar())
        return K._functionString($name, H._setArrayType([channels], type$.JSArray_Value));
      if (channels.get$separator() === C.ListSeparator_1gm) {
        list = channels.get$asList();
        t1 = list.length;
        if (t1 !== 2)
          throw H.wrapException(E.SassScriptException$(string$.Only_2 + t1 + " " + B.pluralize("was", list.length, "were") + " passed."));
        channels0 = list[0];
        alphaFromSlashList = list[1];
        if (!alphaFromSlashList.get$isSpecialNumber())
          alphaFromSlashList.assertNumber$1("alpha");
        if (list[0].get$isVar())
          return K._functionString($name, H._setArrayType([channels], type$.JSArray_Value));
      } else {
        channels0 = channels;
        alphaFromSlashList = null;
      }
      isCommaSeparated = channels0.get$separator() === C.ListSeparator_kWM;
      isBracketed = channels0.get$hasBrackets();
      if (isCommaSeparated || isBracketed) {
        buffer = new P.StringBuffer(_s17_);
        if (isBracketed) {
          t1 = _s17_ + " an unbracketed";
          buffer._contents = t1;
        } else
          t1 = _s17_;
        if (isCommaSeparated) {
          t1 += isBracketed ? "," : " a";
          buffer._contents = t1;
          t1 = buffer._contents = t1 + " space-separated";
        }
        buffer._contents = t1 + " list.";
        throw H.wrapException(E.SassScriptException$(buffer.toString$0(0)));
      }
      list = channels0.get$asList();
      t1 = list.length;
      if (t1 > 3)
        throw H.wrapException(E.SassScriptException$("Only 3 elements allowed, but " + t1 + " were passed."));
      else if (t1 < 3) {
        if (!C.JSArray_methods.any$1(list, new K._parseChannels_closure()))
          if (list.length !== 0) {
            t1 = C.JSArray_methods.get$last(list);
            if (t1 instanceof D.SassString)
              if (t1.hasQuotes) {
                t1 = t1.text;
                t1 = B.startsWithIgnoreCase(t1, "var(") && C.JSString_methods.contains$1(t1, "/");
              } else
                t1 = false;
            else
              t1 = false;
          } else
            t1 = false;
        else
          t1 = true;
        if (t1)
          return K._functionString($name, H._setArrayType([channels], type$.JSArray_Value));
        else
          throw H.wrapException(E.SassScriptException$("Missing element " + argumentNames[list.length] + "."));
      }
      if (alphaFromSlashList != null) {
        t1 = P.List_List$of(list, true, type$.Value);
        t1.push(alphaFromSlashList);
        return t1;
      }
      maybeSlashSeparated = list[2];
      if (maybeSlashSeparated instanceof T.SassNumber) {
        slash = maybeSlashSeparated.asSlash;
        if (slash == null)
          return list;
        return H._setArrayType([list[0], list[1], slash.item1, slash.item2], type$.JSArray_Value);
      } else if (maybeSlashSeparated instanceof D.SassString && !maybeSlashSeparated.hasQuotes && C.JSString_methods.contains$1(maybeSlashSeparated.text, "/"))
        return K._functionString($name, H._setArrayType([channels0], type$.JSArray_Value));
      else
        return list;
    },
    _percentageOrUnitless(number, max, $name) {
      var value;
      if (!number.get$hasUnits())
        value = number.value;
      else if (number.hasUnit$1("%"))
        value = max * number.value / 100;
      else
        throw H.wrapException(E.SassScriptException$("$" + $name + ": Expected " + number.toString$0(0) + ' to have no units or "%".'));
      return C.JSNumber_methods.clamp$2(value, 0, max);
    },
    _mixColors(color1, color2, weight) {
      var weightScale = weight.valueInRange$3(0, 100, "weight") / 100,
        normalizedWeight = weightScale * 2 - 1,
        t1 = color1.alpha,
        t2 = color2.alpha,
        alphaDistance = t1 - t2,
        t3 = normalizedWeight * alphaDistance,
        weight1 = ((t3 === -1 ? normalizedWeight : (normalizedWeight + alphaDistance) / (1 + t3)) + 1) / 2,
        weight2 = 1 - weight1;
      return K.SassColor$rgb(T.fuzzyRound(color1.get$red() * weight1 + color2.get$red() * weight2), T.fuzzyRound(color1.get$green() * weight1 + color2.get$green() * weight2), T.fuzzyRound(color1.get$blue() * weight1 + color2.get$blue() * weight2), t1 * weightScale + t2 * (1 - weightScale), null);
    },
    _opacify($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(C.JSNumber_methods.clamp$2(color.alpha + t1.$index($arguments, 1).assertNumber$1("amount").valueInRange$3(0, 1, "amount"), 0, 1));
    },
    _transparentize($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(C.JSNumber_methods.clamp$2(color.alpha - t1.$index($arguments, 1).assertNumber$1("amount").valueInRange$3(0, 1, "amount"), 0, 1));
    },
    _function4($name, $arguments, callback) {
      return Q.BuiltInCallable$function($name, $arguments, callback, "sass:color");
    },
    global_closure: function global_closure() {
    },
    global_closure0: function global_closure0() {
    },
    global_closure1: function global_closure1() {
    },
    global_closure2: function global_closure2() {
    },
    global_closure3: function global_closure3() {
    },
    global_closure4: function global_closure4() {
    },
    global_closure5: function global_closure5() {
    },
    global_closure6: function global_closure6() {
    },
    global_closure7: function global_closure7() {
    },
    global_closure8: function global_closure8() {
    },
    global_closure9: function global_closure9() {
    },
    global_closure10: function global_closure10() {
    },
    global_closure11: function global_closure11() {
    },
    global_closure12: function global_closure12() {
    },
    global_closure13: function global_closure13() {
    },
    global_closure14: function global_closure14() {
    },
    global_closure15: function global_closure15() {
    },
    global_closure16: function global_closure16() {
    },
    global_closure17: function global_closure17() {
    },
    global_closure18: function global_closure18() {
    },
    global_closure19: function global_closure19() {
    },
    global_closure20: function global_closure20() {
    },
    global_closure21: function global_closure21() {
    },
    global_closure22: function global_closure22() {
    },
    global_closure23: function global_closure23() {
    },
    global_closure24: function global_closure24() {
    },
    global__closure: function global__closure() {
    },
    global_closure25: function global_closure25() {
    },
    module_closure: function module_closure() {
    },
    module_closure0: function module_closure0() {
    },
    module_closure1: function module_closure1() {
    },
    module_closure2: function module_closure2() {
    },
    module_closure3: function module_closure3() {
    },
    module_closure4: function module_closure4() {
    },
    module_closure5: function module_closure5() {
    },
    module_closure6: function module_closure6() {
    },
    module__closure: function module__closure() {
    },
    module_closure7: function module_closure7() {
    },
    _red_closure: function _red_closure() {
    },
    _green_closure: function _green_closure() {
    },
    _blue_closure: function _blue_closure() {
    },
    _mix_closure: function _mix_closure() {
    },
    _hue_closure: function _hue_closure() {
    },
    _saturation_closure: function _saturation_closure() {
    },
    _lightness_closure: function _lightness_closure() {
    },
    _complement_closure: function _complement_closure() {
    },
    _adjust_closure: function _adjust_closure() {
    },
    _scale_closure: function _scale_closure() {
    },
    _change_closure: function _change_closure() {
    },
    _ieHexStr_closure: function _ieHexStr_closure() {
    },
    _ieHexStr_closure_hexString: function _ieHexStr_closure_hexString() {
    },
    _updateComponents_getParam: function _updateComponents_getParam(t0, t1, t2) {
      this.keywords = t0;
      this.scale = t1;
      this.change = t2;
    },
    _updateComponents_closure: function _updateComponents_closure() {
    },
    _updateComponents_updateValue: function _updateComponents_updateValue(t0, t1) {
      this.change = t0;
      this.adjust = t1;
    },
    _updateComponents_updateRgb: function _updateComponents_updateRgb(t0) {
      this.updateValue = t0;
    },
    _functionString_closure: function _functionString_closure() {
    },
    _removedColorFunction_closure: function _removedColorFunction_closure(t0, t1, t2) {
      this.name = t0;
      this.argument = t1;
      this.negative = t2;
    },
    _rgb_closure: function _rgb_closure() {
    },
    _hsl_closure: function _hsl_closure() {
    },
    _removeUnits_closure: function _removeUnits_closure() {
    },
    _removeUnits_closure0: function _removeUnits_closure0() {
    },
    _hwb_closure: function _hwb_closure() {
    },
    _parseChannels_closure: function _parseChannels_closure() {
    },
    _fuzzyRoundIfZero(number) {
      if (!(Math.abs(number - 0) < $.$get$epsilon()))
        return number;
      return C.JSNumber_methods.get$isNegative(number) ? -0.0 : 0;
    },
    _numberFunction($name, transform) {
      return Q.BuiltInCallable$function($name, "$number", new K._numberFunction_closure(transform), "sass:math");
    },
    _function1($name, $arguments, callback) {
      return Q.BuiltInCallable$function($name, $arguments, callback, "sass:math");
    },
    _ceil_closure: function _ceil_closure() {
    },
    _clamp_closure: function _clamp_closure() {
    },
    _floor_closure: function _floor_closure() {
    },
    _max_closure: function _max_closure() {
    },
    _min_closure: function _min_closure() {
    },
    _abs_closure: function _abs_closure() {
    },
    _hypot_closure: function _hypot_closure() {
    },
    _hypot__closure: function _hypot__closure() {
    },
    _log_closure: function _log_closure() {
    },
    _pow_closure: function _pow_closure() {
    },
    _sqrt_closure: function _sqrt_closure() {
    },
    _acos_closure: function _acos_closure() {
    },
    _asin_closure: function _asin_closure() {
    },
    _atan_closure: function _atan_closure() {
    },
    _atan2_closure: function _atan2_closure() {
    },
    _cos_closure: function _cos_closure() {
    },
    _sin_closure: function _sin_closure() {
    },
    _tan_closure: function _tan_closure() {
    },
    _compatible_closure: function _compatible_closure() {
    },
    _isUnitless_closure: function _isUnitless_closure() {
    },
    _unit_closure: function _unit_closure() {
    },
    _percentage_closure: function _percentage_closure() {
    },
    _randomFunction_closure: function _randomFunction_closure() {
    },
    _div_closure: function _div_closure() {
    },
    _numberFunction_closure: function _numberFunction_closure(t0) {
      this.transform = t0;
    },
    LimitedMapView$blocklist(_map, blocklist, $K, $V) {
      var t2, key,
        t1 = P.LinkedHashSet_LinkedHashSet$_empty($K);
      for (t2 = J.get$iterator$ax(_map.get$keys(_map)); t2.moveNext$0();) {
        key = t2.get$current(t2);
        if (!blocklist.contains$1(0, key))
          t1.add$1(0, key);
      }
      return new K.LimitedMapView(_map, t1, $K._eval$1("@<0>")._bind$1($V)._eval$1("LimitedMapView<1,2>"));
    },
    LimitedMapView: function LimitedMapView(t0, t1, t2) {
      this._limited_map_view$_map = t0;
      this._limited_map_view$_keys = t1;
      this.$ti = t2;
    },
    SassColor$rgb(_red, _green, _blue, alpha, originalSpan) {
      var t1 = new K.SassColor(_red, _green, _blue, null, null, null, alpha == null ? 1 : T.fuzzyAssertRange(alpha, 0, 1, "alpha"), originalSpan);
      P.RangeError_checkValueInInterval(t1.get$red(), 0, 255, "red");
      P.RangeError_checkValueInInterval(t1.get$green(), 0, 255, "green");
      P.RangeError_checkValueInInterval(t1.get$blue(), 0, 255, "blue");
      return t1;
    },
    SassColor$hsl(hue, saturation, lightness, alpha) {
      var _null = null,
        t1 = C.JSNumber_methods.$mod(hue, 360),
        t2 = T.fuzzyAssertRange(saturation, 0, 100, "saturation"),
        t3 = T.fuzzyAssertRange(lightness, 0, 100, "lightness");
      return new K.SassColor(_null, _null, _null, t1, t2, t3, alpha == null ? 1 : T.fuzzyAssertRange(alpha, 0, 1, "alpha"), _null);
    },
    SassColor_SassColor$hwb(hue, whiteness, blackness, alpha) {
      var t2, t1 = {},
        scaledHue = C.JSNumber_methods.$mod(hue, 360) / 360,
        scaledWhiteness = t1.scaledWhiteness = T.fuzzyAssertRange(whiteness, 0, 100, "whiteness") / 100,
        scaledBlackness = T.fuzzyAssertRange(blackness, 0, 100, "blackness") / 100,
        sum = scaledWhiteness + scaledBlackness;
      if (sum > 1) {
        t2 = t1.scaledWhiteness = scaledWhiteness / sum;
        scaledBlackness /= sum;
      } else
        t2 = scaledWhiteness;
      t2 = new K.SassColor_SassColor$hwb_toRgb(t1, 1 - t2 - scaledBlackness);
      return K.SassColor$rgb(t2.call$1(scaledHue + 0.3333333333333333), t2.call$1(scaledHue), t2.call$1(scaledHue - 0.3333333333333333), alpha, null);
    },
    SassColor__hueToRgb(m1, m2, hue) {
      if (hue < 0)
        ++hue;
      if (hue > 1)
        --hue;
      if (hue < 0.16666666666666666)
        return m1 + (m2 - m1) * hue * 6;
      else if (hue < 0.5)
        return m2;
      else if (hue < 0.6666666666666666)
        return m1 + (m2 - m1) * (0.6666666666666666 - hue) * 6;
      else
        return m1;
    },
    SassColor: function SassColor(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _._red = t0;
      _._green = t1;
      _._blue = t2;
      _._hue = t3;
      _._saturation = t4;
      _._lightness = t5;
      _.alpha = t6;
      _.originalSpan = t7;
    },
    SassColor_SassColor$hwb_toRgb: function SassColor_SassColor$hwb_toRgb(t0, t1) {
      this._box_0 = t0;
      this.factor = t1;
    },
    UnicodeGlyphSet: function UnicodeGlyphSet() {
    },
    ColorExpression0: function ColorExpression0(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    _updateComponents0($arguments, adjust, change, scale) {
      var keywords, alpha, red, green, blue, hueNumber, t2, hue, saturation, lightness, whiteness, blackness, hasRgb, hasSL, hasWB, t3, t4, t5, _null = null,
        t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color"),
        argumentList = type$.SassArgumentList_2._as(t1.$index($arguments, 1));
      if (argumentList._list1$_contents.length !== 0)
        throw H.wrapException(E.SassScriptException$0(string$.Only_op));
      argumentList._argument_list$_wereKeywordsAccessed = true;
      keywords = P.LinkedHashMap_LinkedHashMap$of(argumentList._argument_list$_keywords, type$.String, type$.Value_2);
      t1 = new K._updateComponents_getParam0(keywords, scale, change);
      alpha = t1.call$2("alpha", 1);
      red = t1.call$2("red", 255);
      green = t1.call$2("green", 255);
      blue = t1.call$2("blue", 255);
      if (scale)
        hueNumber = _null;
      else {
        t2 = keywords.remove$1(0, "hue");
        hueNumber = t2 == null ? _null : t2.assertNumber$1("hue");
      }
      t2 = hueNumber == null;
      if (!t2)
        K._checkAngle0(hueNumber, "hue");
      hue = t2 ? _null : hueNumber.value;
      saturation = t1.call$3$checkPercent("saturation", 100, true);
      lightness = t1.call$3$checkPercent("lightness", 100, true);
      whiteness = t1.call$3$assertPercent("whiteness", 100, true);
      blackness = t1.call$3$assertPercent("blackness", 100, true);
      if (keywords.get$isNotEmpty(keywords))
        throw H.wrapException(E.SassScriptException$0("No " + B.pluralize0("argument", keywords.get$length(keywords), _null) + " named " + H.S(B.toSentence0(keywords.get$keys(keywords).map$1$1(0, new K._updateComponents_closure0(), type$.Object), "or")) + "."));
      hasRgb = red != null || green != null || blue != null;
      hasSL = saturation != null || lightness != null;
      hasWB = whiteness != null || blackness != null;
      if (hasRgb)
        t1 = hasSL || hasWB || hue != null;
      else
        t1 = false;
      if (t1)
        throw H.wrapException(E.SassScriptException$0(string$.RGB_pa + (hasWB ? "HWB" : "HSL") + " parameters."));
      if (hasSL && hasWB)
        throw H.wrapException(E.SassScriptException$0(string$.HSL_pa));
      t1 = new K._updateComponents_updateValue0(change, adjust);
      t2 = new K._updateComponents_updateRgb0(t1);
      if (hasRgb) {
        t3 = t2.call$2(color.get$red(), red);
        t4 = t2.call$2(color.get$green(), green);
        t2 = t2.call$2(color.get$blue(), blue);
        return color.changeRgb$4$alpha$blue$green$red(t1.call$3(color.alpha, alpha, 1), t2, t4, t3);
      } else if (hasWB) {
        if (change)
          t2 = hue;
        else {
          t2 = color.get$hue();
          t2 += hue == null ? 0 : hue;
        }
        t3 = t1.call$3(color.get$whiteness(), whiteness, 100);
        t4 = t1.call$3(color.get$blackness(), blackness, 100);
        t5 = color.alpha;
        t1 = t1.call$3(t5, alpha, 1);
        if (t2 == null)
          t2 = color.get$hue();
        if (t3 == null)
          t3 = color.get$whiteness();
        if (t4 == null)
          t4 = color.get$blackness();
        return K.SassColor_SassColor$hwb0(t2, t3, t4, t1 == null ? t5 : t1);
      } else {
        t2 = hue == null;
        if (!t2 || hasSL) {
          if (change)
            t2 = hue;
          else {
            t3 = color.get$hue();
            t3 += t2 ? 0 : hue;
            t2 = t3;
          }
          t3 = t1.call$3(color.get$saturation(), saturation, 100);
          t4 = t1.call$3(color.get$lightness(), lightness, 100);
          return color.changeHsl$4$alpha$hue$lightness$saturation(t1.call$3(color.alpha, alpha, 1), t2, t4, t3);
        } else if (alpha != null)
          return color.changeAlpha$1(t1.call$3(color.alpha, alpha, 1));
        else
          return color;
      }
    },
    _functionString0($name, $arguments) {
      return new D.SassString0($name + "(" + J.map$1$1$ax($arguments, new K._functionString_closure0(), type$.String).join$1(0, ", ") + ")", false);
    },
    _removedColorFunction0($name, argument, negative) {
      return Q.BuiltInCallable$function0($name, "$color, $amount", new K._removedColorFunction_closure0($name, argument, negative), "sass:color");
    },
    _rgb0($name, $arguments) {
      var t2, red, green, blue,
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return K._functionString0($name, $arguments);
      red = t1.$index($arguments, 0).assertNumber$1("red");
      green = t1.$index($arguments, 1).assertNumber$1("green");
      blue = t1.$index($arguments, 2).assertNumber$1("blue");
      return K.SassColor$rgb0(T.fuzzyRound0(K._percentageOrUnitless0(red, 255, "red")), T.fuzzyRound0(K._percentageOrUnitless0(green, 255, "green")), T.fuzzyRound0(K._percentageOrUnitless0(blue, 255, "blue")), X.NullableExtension_andThen0(alpha, new K._rgb_closure0()), null);
    },
    _rgbTwoArg0($name, $arguments) {
      var first, color,
        t1 = J.getInterceptor$asx($arguments);
      if (t1.$index($arguments, 0).get$isVar())
        return K._functionString0($name, $arguments);
      else if (t1.$index($arguments, 1).get$isVar()) {
        first = t1.$index($arguments, 0);
        if (first instanceof K.SassColor0)
          return new D.SassString0($name + "(" + first.get$red() + ", " + first.get$green() + ", " + first.get$blue() + ", " + N.serializeValue(t1.$index($arguments, 1), false, true) + ")", false);
        else
          return K._functionString0($name, $arguments);
      } else if (t1.$index($arguments, 1).get$isSpecialNumber()) {
        color = t1.$index($arguments, 0).assertColor$1("color");
        return new D.SassString0($name + "(" + color.get$red() + ", " + color.get$green() + ", " + color.get$blue() + ", " + N.serializeValue(t1.$index($arguments, 1), false, true) + ")", false);
      }
      return t1.$index($arguments, 0).assertColor$1("color").changeAlpha$1(K._percentageOrUnitless0(t1.$index($arguments, 1).assertNumber$1("alpha"), 1, "alpha"));
    },
    _hsl0($name, $arguments) {
      var t2, hue, saturation, lightness,
        _s10_ = "saturation",
        _s9_ = "lightness",
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return K._functionString0($name, $arguments);
      hue = t1.$index($arguments, 0).assertNumber$1("hue");
      saturation = t1.$index($arguments, 1).assertNumber$1(_s10_);
      lightness = t1.$index($arguments, 2).assertNumber$1(_s9_);
      K._checkAngle0(hue, "hue");
      K._checkPercent0(saturation, _s10_);
      K._checkPercent0(lightness, _s9_);
      return K.SassColor$hsl0(hue.value, C.JSNumber_methods.clamp$2(saturation.value, 0, 100), C.JSNumber_methods.clamp$2(lightness.value, 0, 100), X.NullableExtension_andThen0(alpha, new K._hsl_closure0()));
    },
    _checkAngle0(angle, $name) {
      var t1, t2, t3, actualUnit,
        _s31_ = "To preserve current behavior: $";
      if (!angle.get$hasUnits() || angle.hasUnit$1("deg"))
        return;
      t1 = "" + ("$" + H.S($name) + ": Passing a unit other than deg (" + angle.toString$0(0) + ") is deprecated.\n") + "\n";
      if (angle.compatibleWithUnit$1("deg")) {
        t2 = "You're passing " + angle.toString$0(0) + string$.x2c_whici;
        t3 = type$.JSArray_String;
        t3 = t1 + (t2 + new L.SingleUnitSassNumber0("deg", angle.value, null).toString$0(0) + ".\n") + (string$.Soon__ + angle.coerce$2(H._setArrayType(["deg"], t3), H._setArrayType([], t3)).toString$0(0) + ".\n") + "\n";
        actualUnit = J.get$first$ax(angle.get$numeratorUnits());
        t3 = t3 + (_s31_ + H.S($name) + " * 1deg/1" + actualUnit + "\n") + ("To migrate to new behavior: 0deg + $" + H.S($name) + "\n") + "\n";
        t1 = t3;
      } else
        t1 = t1 + (_s31_ + H.S($name) + K._removeUnits0(angle) + "\n") + "\n";
      t1 += "See https://sass-lang.com/d/color-units";
      N.warn0(t1.charCodeAt(0) == 0 ? t1 : t1, true);
    },
    _checkPercent0(number, $name) {
      if (number.hasUnit$1("%"))
        return;
      N.warn0("$" + $name + ": Passing a number without unit % (" + number.toString$0(0) + string$.x29x20is_d + $name + K._removeUnits0(number) + " * 1%", true);
    },
    _removeUnits0(number) {
      var t1 = number.get$denominatorUnits();
      return new H.MappedListIterable(t1, new K._removeUnits_closure1(), H._arrayInstanceType(t1)._eval$1("MappedListIterable<1,String>")).join$0(0) + J.map$1$1$ax(number.get$numeratorUnits(), new K._removeUnits_closure2(), type$.String).join$0(0);
    },
    _hwb0($arguments) {
      var _s9_ = "whiteness",
        _s9_0 = "blackness",
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null,
        hue = t1.$index($arguments, 0).assertNumber$1("hue"),
        whiteness = t1.$index($arguments, 1).assertNumber$1(_s9_),
        blackness = t1.$index($arguments, 2).assertNumber$1(_s9_0);
      whiteness.assertUnit$2("%", _s9_);
      blackness.assertUnit$2("%", _s9_0);
      return K.SassColor_SassColor$hwb0(hue.value, whiteness.valueInRange$3(0, 100, _s9_), blackness.valueInRange$3(0, 100, _s9_0), X.NullableExtension_andThen0(alpha, new K._hwb_closure0()));
    },
    _parseChannels0($name, argumentNames, channels) {
      var list, t1, channels0, alphaFromSlashList, isCommaSeparated, isBracketed, buffer, maybeSlashSeparated, slash,
        _s17_ = "$channels must be";
      if (channels.get$isVar())
        return K._functionString0($name, H._setArrayType([channels], type$.JSArray_Value_2));
      if (channels.get$separator() === C.ListSeparator_1gm0) {
        list = channels.get$asList();
        t1 = list.length;
        if (t1 !== 2)
          throw H.wrapException(E.SassScriptException$0(string$.Only_2 + t1 + " " + B.pluralize0("was", list.length, "were") + " passed."));
        channels0 = list[0];
        alphaFromSlashList = list[1];
        if (!alphaFromSlashList.get$isSpecialNumber())
          alphaFromSlashList.assertNumber$1("alpha");
        if (list[0].get$isVar())
          return K._functionString0($name, H._setArrayType([channels], type$.JSArray_Value_2));
      } else {
        channels0 = channels;
        alphaFromSlashList = null;
      }
      isCommaSeparated = channels0.get$separator() === C.ListSeparator_kWM0;
      isBracketed = channels0.get$hasBrackets();
      if (isCommaSeparated || isBracketed) {
        buffer = new P.StringBuffer(_s17_);
        if (isBracketed) {
          t1 = _s17_ + " an unbracketed";
          buffer._contents = t1;
        } else
          t1 = _s17_;
        if (isCommaSeparated) {
          t1 += isBracketed ? "," : " a";
          buffer._contents = t1;
          t1 = buffer._contents = t1 + " space-separated";
        }
        buffer._contents = t1 + " list.";
        throw H.wrapException(E.SassScriptException$0(buffer.toString$0(0)));
      }
      list = channels0.get$asList();
      t1 = list.length;
      if (t1 > 3)
        throw H.wrapException(E.SassScriptException$0("Only 3 elements allowed, but " + t1 + " were passed."));
      else if (t1 < 3) {
        if (!C.JSArray_methods.any$1(list, new K._parseChannels_closure0()))
          if (list.length !== 0) {
            t1 = C.JSArray_methods.get$last(list);
            if (t1 instanceof D.SassString0)
              if (t1.hasQuotes) {
                t1 = t1.text;
                t1 = B.startsWithIgnoreCase0(t1, "var(") && C.JSString_methods.contains$1(t1, "/");
              } else
                t1 = false;
            else
              t1 = false;
          } else
            t1 = false;
        else
          t1 = true;
        if (t1)
          return K._functionString0($name, H._setArrayType([channels], type$.JSArray_Value_2));
        else
          throw H.wrapException(E.SassScriptException$0("Missing element " + argumentNames[list.length] + "."));
      }
      if (alphaFromSlashList != null) {
        t1 = P.List_List$of(list, true, type$.Value_2);
        t1.push(alphaFromSlashList);
        return t1;
      }
      maybeSlashSeparated = list[2];
      if (maybeSlashSeparated instanceof T.SassNumber0) {
        slash = maybeSlashSeparated.asSlash;
        if (slash == null)
          return list;
        return H._setArrayType([list[0], list[1], slash.item1, slash.item2], type$.JSArray_Value_2);
      } else if (maybeSlashSeparated instanceof D.SassString0 && !maybeSlashSeparated.hasQuotes && C.JSString_methods.contains$1(maybeSlashSeparated.text, "/"))
        return K._functionString0($name, H._setArrayType([channels0], type$.JSArray_Value_2));
      else
        return list;
    },
    _percentageOrUnitless0(number, max, $name) {
      var value;
      if (!number.get$hasUnits())
        value = number.value;
      else if (number.hasUnit$1("%"))
        value = max * number.value / 100;
      else
        throw H.wrapException(E.SassScriptException$0("$" + $name + ": Expected " + number.toString$0(0) + ' to have no units or "%".'));
      return C.JSNumber_methods.clamp$2(value, 0, max);
    },
    _mixColors0(color1, color2, weight) {
      var weightScale = weight.valueInRange$3(0, 100, "weight") / 100,
        normalizedWeight = weightScale * 2 - 1,
        t1 = color1.alpha,
        t2 = color2.alpha,
        alphaDistance = t1 - t2,
        t3 = normalizedWeight * alphaDistance,
        weight1 = ((t3 === -1 ? normalizedWeight : (normalizedWeight + alphaDistance) / (1 + t3)) + 1) / 2,
        weight2 = 1 - weight1;
      return K.SassColor$rgb0(T.fuzzyRound0(color1.get$red() * weight1 + color2.get$red() * weight2), T.fuzzyRound0(color1.get$green() * weight1 + color2.get$green() * weight2), T.fuzzyRound0(color1.get$blue() * weight1 + color2.get$blue() * weight2), t1 * weightScale + t2 * (1 - weightScale), null);
    },
    _opacify0($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(C.JSNumber_methods.clamp$2(color.alpha + t1.$index($arguments, 1).assertNumber$1("amount").valueInRange$3(0, 1, "amount"), 0, 1));
    },
    _transparentize0($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(C.JSNumber_methods.clamp$2(color.alpha - t1.$index($arguments, 1).assertNumber$1("amount").valueInRange$3(0, 1, "amount"), 0, 1));
    },
    _function11($name, $arguments, callback) {
      return Q.BuiltInCallable$function0($name, $arguments, callback, "sass:color");
    },
    global_closure30: function global_closure30() {
    },
    global_closure31: function global_closure31() {
    },
    global_closure32: function global_closure32() {
    },
    global_closure33: function global_closure33() {
    },
    global_closure34: function global_closure34() {
    },
    global_closure35: function global_closure35() {
    },
    global_closure36: function global_closure36() {
    },
    global_closure37: function global_closure37() {
    },
    global_closure38: function global_closure38() {
    },
    global_closure39: function global_closure39() {
    },
    global_closure40: function global_closure40() {
    },
    global_closure41: function global_closure41() {
    },
    global_closure42: function global_closure42() {
    },
    global_closure43: function global_closure43() {
    },
    global_closure44: function global_closure44() {
    },
    global_closure45: function global_closure45() {
    },
    global_closure46: function global_closure46() {
    },
    global_closure47: function global_closure47() {
    },
    global_closure48: function global_closure48() {
    },
    global_closure49: function global_closure49() {
    },
    global_closure50: function global_closure50() {
    },
    global_closure51: function global_closure51() {
    },
    global_closure52: function global_closure52() {
    },
    global_closure53: function global_closure53() {
    },
    global_closure54: function global_closure54() {
    },
    global_closure55: function global_closure55() {
    },
    global__closure0: function global__closure0() {
    },
    global_closure56: function global_closure56() {
    },
    module_closure8: function module_closure8() {
    },
    module_closure9: function module_closure9() {
    },
    module_closure10: function module_closure10() {
    },
    module_closure11: function module_closure11() {
    },
    module_closure12: function module_closure12() {
    },
    module_closure13: function module_closure13() {
    },
    module_closure14: function module_closure14() {
    },
    module_closure15: function module_closure15() {
    },
    module__closure0: function module__closure0() {
    },
    module_closure16: function module_closure16() {
    },
    _red_closure0: function _red_closure0() {
    },
    _green_closure0: function _green_closure0() {
    },
    _blue_closure0: function _blue_closure0() {
    },
    _mix_closure0: function _mix_closure0() {
    },
    _hue_closure0: function _hue_closure0() {
    },
    _saturation_closure0: function _saturation_closure0() {
    },
    _lightness_closure0: function _lightness_closure0() {
    },
    _complement_closure0: function _complement_closure0() {
    },
    _adjust_closure0: function _adjust_closure0() {
    },
    _scale_closure0: function _scale_closure0() {
    },
    _change_closure0: function _change_closure0() {
    },
    _ieHexStr_closure0: function _ieHexStr_closure0() {
    },
    _ieHexStr_closure_hexString0: function _ieHexStr_closure_hexString0() {
    },
    _updateComponents_getParam0: function _updateComponents_getParam0(t0, t1, t2) {
      this.keywords = t0;
      this.scale = t1;
      this.change = t2;
    },
    _updateComponents_closure0: function _updateComponents_closure0() {
    },
    _updateComponents_updateValue0: function _updateComponents_updateValue0(t0, t1) {
      this.change = t0;
      this.adjust = t1;
    },
    _updateComponents_updateRgb0: function _updateComponents_updateRgb0(t0) {
      this.updateValue = t0;
    },
    _functionString_closure0: function _functionString_closure0() {
    },
    _removedColorFunction_closure0: function _removedColorFunction_closure0(t0, t1, t2) {
      this.name = t0;
      this.argument = t1;
      this.negative = t2;
    },
    _rgb_closure0: function _rgb_closure0() {
    },
    _hsl_closure0: function _hsl_closure0() {
    },
    _removeUnits_closure1: function _removeUnits_closure1() {
    },
    _removeUnits_closure2: function _removeUnits_closure2() {
    },
    _hwb_closure0: function _hwb_closure0() {
    },
    _parseChannels_closure0: function _parseChannels_closure0() {
    },
    _NodeSassColor: function _NodeSassColor() {
    },
    colorConstructor_closure: function colorConstructor_closure() {
    },
    colorConstructor_closure0: function colorConstructor_closure0() {
    },
    colorConstructor_closure1: function colorConstructor_closure1() {
    },
    colorConstructor_closure2: function colorConstructor_closure2() {
    },
    colorConstructor_closure3: function colorConstructor_closure3() {
    },
    colorConstructor_closure4: function colorConstructor_closure4() {
    },
    colorConstructor_closure5: function colorConstructor_closure5() {
    },
    colorConstructor_closure6: function colorConstructor_closure6() {
    },
    colorConstructor_closure7: function colorConstructor_closure7() {
    },
    colorConstructor_closure8: function colorConstructor_closure8() {
    },
    SassColor$rgb0(_red, _green, _blue, alpha, originalSpan) {
      var t1 = new K.SassColor0(_red, _green, _blue, null, null, null, alpha == null ? 1 : T.fuzzyAssertRange0(alpha, 0, 1, "alpha"), originalSpan);
      P.RangeError_checkValueInInterval(t1.get$red(), 0, 255, "red");
      P.RangeError_checkValueInInterval(t1.get$green(), 0, 255, "green");
      P.RangeError_checkValueInInterval(t1.get$blue(), 0, 255, "blue");
      return t1;
    },
    SassColor$hsl0(hue, saturation, lightness, alpha) {
      var _null = null,
        t1 = C.JSNumber_methods.$mod(hue, 360),
        t2 = T.fuzzyAssertRange0(saturation, 0, 100, "saturation"),
        t3 = T.fuzzyAssertRange0(lightness, 0, 100, "lightness");
      return new K.SassColor0(_null, _null, _null, t1, t2, t3, alpha == null ? 1 : T.fuzzyAssertRange0(alpha, 0, 1, "alpha"), _null);
    },
    SassColor_SassColor$hwb0(hue, whiteness, blackness, alpha) {
      var t2, t1 = {},
        scaledHue = C.JSNumber_methods.$mod(hue, 360) / 360,
        scaledWhiteness = t1.scaledWhiteness = T.fuzzyAssertRange0(whiteness, 0, 100, "whiteness") / 100,
        scaledBlackness = T.fuzzyAssertRange0(blackness, 0, 100, "blackness") / 100,
        sum = scaledWhiteness + scaledBlackness;
      if (sum > 1) {
        t2 = t1.scaledWhiteness = scaledWhiteness / sum;
        scaledBlackness /= sum;
      } else
        t2 = scaledWhiteness;
      t2 = new K.SassColor_SassColor$hwb_toRgb0(t1, 1 - t2 - scaledBlackness);
      return K.SassColor$rgb0(t2.call$1(scaledHue + 0.3333333333333333), t2.call$1(scaledHue), t2.call$1(scaledHue - 0.3333333333333333), alpha, null);
    },
    SassColor__hueToRgb0(m1, m2, hue) {
      if (hue < 0)
        ++hue;
      if (hue > 1)
        --hue;
      if (hue < 0.16666666666666666)
        return m1 + (m2 - m1) * hue * 6;
      else if (hue < 0.5)
        return m2;
      else if (hue < 0.6666666666666666)
        return m1 + (m2 - m1) * (0.6666666666666666 - hue) * 6;
      else
        return m1;
    },
    SassColor0: function SassColor0(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _._color0$_red = t0;
      _._color0$_green = t1;
      _._color0$_blue = t2;
      _._color0$_hue = t3;
      _._color0$_saturation = t4;
      _._color0$_lightness = t5;
      _.alpha = t6;
      _.originalSpan = t7;
    },
    SassColor_SassColor$hwb_toRgb0: function SassColor_SassColor$hwb_toRgb0(t0, t1) {
      this._box_0 = t0;
      this.factor = t1;
    },
    LimitedMapView$blocklist0(_map, blocklist, $K, $V) {
      var t2, key,
        t1 = P.LinkedHashSet_LinkedHashSet$_empty($K);
      for (t2 = J.get$iterator$ax(_map.get$keys(_map)); t2.moveNext$0();) {
        key = t2.get$current(t2);
        if (!blocklist.contains$1(0, key))
          t1.add$1(0, key);
      }
      return new K.LimitedMapView0(_map, t1, $K._eval$1("@<0>")._bind$1($V)._eval$1("LimitedMapView0<1,2>"));
    },
    LimitedMapView0: function LimitedMapView0(t0, t1, t2) {
      this._limited_map_view0$_map = t0;
      this._limited_map_view0$_keys = t1;
      this.$ti = t2;
    },
    _fuzzyRoundIfZero0(number) {
      if (!(Math.abs(number - 0) < $.$get$epsilon0()))
        return number;
      return C.JSNumber_methods.get$isNegative(number) ? -0.0 : 0;
    },
    _numberFunction0($name, transform) {
      return Q.BuiltInCallable$function0($name, "$number", new K._numberFunction_closure0(transform), "sass:math");
    },
    _function8($name, $arguments, callback) {
      return Q.BuiltInCallable$function0($name, $arguments, callback, "sass:math");
    },
    _ceil_closure0: function _ceil_closure0() {
    },
    _clamp_closure0: function _clamp_closure0() {
    },
    _floor_closure0: function _floor_closure0() {
    },
    _max_closure0: function _max_closure0() {
    },
    _min_closure0: function _min_closure0() {
    },
    _abs_closure0: function _abs_closure0() {
    },
    _hypot_closure0: function _hypot_closure0() {
    },
    _hypot__closure0: function _hypot__closure0() {
    },
    _log_closure0: function _log_closure0() {
    },
    _pow_closure0: function _pow_closure0() {
    },
    _sqrt_closure0: function _sqrt_closure0() {
    },
    _acos_closure0: function _acos_closure0() {
    },
    _asin_closure0: function _asin_closure0() {
    },
    _atan_closure0: function _atan_closure0() {
    },
    _atan2_closure0: function _atan2_closure0() {
    },
    _cos_closure0: function _cos_closure0() {
    },
    _sin_closure0: function _sin_closure0() {
    },
    _tan_closure0: function _tan_closure0() {
    },
    _compatible_closure0: function _compatible_closure0() {
    },
    _isUnitless_closure0: function _isUnitless_closure0() {
    },
    _unit_closure0: function _unit_closure0() {
    },
    _percentage_closure0: function _percentage_closure0() {
    },
    _randomFunction_closure0: function _randomFunction_closure0() {
    },
    _div_closure0: function _div_closure0() {
    },
    _numberFunction_closure0: function _numberFunction_closure0(t0) {
      this.transform = t0;
    }
  },
  L = {StreamGroup: function StreamGroup(t0, t1, t2) {
      var _ = this;
      _.__StreamGroup__controller = null;
      _._closed = false;
      _._stream_group$_state = t0;
      _._subscriptions = t1;
      _.$ti = t2;
    }, StreamGroup_add_closure: function StreamGroup_add_closure() {
    }, StreamGroup_add_closure0: function StreamGroup_add_closure0(t0, t1) {
      this.$this = t0;
      this.stream = t1;
    }, StreamGroup__onListen_closure: function StreamGroup__onListen_closure() {
    }, StreamGroup__onCancel_closure: function StreamGroup__onCancel_closure(t0) {
      this.$this = t0;
    }, StreamGroup__listenToStream_closure: function StreamGroup__listenToStream_closure(t0, t1) {
      this.$this = t0;
      this.stream = t1;
    }, _StreamGroupState: function _StreamGroupState(t0) {
      this.name = t0;
    },
    UnmodifiableSetMixin__throw() {
      throw H.wrapException(P.UnsupportedError$("Cannot modify an unmodifiable Set"));
    },
    UnmodifiableSetView: function UnmodifiableSetView(t0, t1) {
      this._base = t0;
      this.$ti = t1;
    },
    UnmodifiableSetMixin: function UnmodifiableSetMixin() {
    },
    _UnmodifiableSetView_DelegatingSet_UnmodifiableSetMixin: function _UnmodifiableSetView_DelegatingSet_UnmodifiableSetMixin() {
    },
    Immediate: function Immediate() {
    },
    Timeout: function Timeout() {
    },
    WindowsStyle: function WindowsStyle(t0, t1, t2, t3) {
      var _ = this;
      _.separatorPattern = t0;
      _.needsSeparatorPattern = t1;
      _.rootPattern = t2;
      _.relativeRootPattern = t3;
    },
    WindowsStyle_absolutePathToUri_closure: function WindowsStyle_absolutePathToUri_closure() {
    },
    ModifiableCssDeclaration$($name, value, span, parsedAsCustomProperty, valueSpanForMap) {
      var t1 = valueSpanForMap == null ? value.get$span() : valueSpanForMap;
      if (parsedAsCustomProperty)
        if (!J.startsWith$1$s($name.get$value($name), "--"))
          H.throwExpression(P.ArgumentError$(string$.parsed, null));
        else if (!(value.get$value(value) instanceof D.SassString))
          H.throwExpression(P.ArgumentError$(string$.If_par + value.toString$0(0) + "` of type " + H.getRuntimeType(value.get$value(value)).toString$0(0) + ").", null));
      return new L.ModifiableCssDeclaration($name, value, parsedAsCustomProperty, t1, span);
    },
    ModifiableCssDeclaration: function ModifiableCssDeclaration(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.parsedAsCustomProperty = t2;
      _.valueSpanForMap = t3;
      _.span = t4;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    IfExpression: function IfExpression(t0, t1) {
      this.$arguments = t0;
      this.span = t1;
    },
    Declaration$($name, value, span) {
      if (C.JSString_methods.startsWith$1($name.get$initialPlain(), "--") && !(value instanceof D.StringExpression))
        H.throwExpression(P.ArgumentError$(string$.Declarwu + value.toString$0(0) + "` of type " + H.getRuntimeType(value).toString$0(0) + ").", null));
      return new L.Declaration($name, value, span, null, false);
    },
    Declaration$nested($name, children, span, value) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      if (C.JSString_methods.startsWith$1($name.get$initialPlain(), "--") && !(value instanceof D.StringExpression))
        H.throwExpression(P.ArgumentError$(string$.Declarwa, null));
      return new L.Declaration($name, value, span, t1, t2);
    },
    Declaration: function Declaration(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    ForwardRule: function ForwardRule(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _.url = t0;
      _.shownMixinsAndFunctions = t1;
      _.shownVariables = t2;
      _.hiddenMixinsAndFunctions = t3;
      _.hiddenVariables = t4;
      _.prefix = t5;
      _.configuration = t6;
      _.span = t7;
    },
    LoudComment: function LoudComment(t0) {
      this.text = t0;
    },
    SupportsDeclaration: function SupportsDeclaration(t0, t1, t2) {
      this.name = t0;
      this.value = t1;
      this.span = t2;
    },
    PlainCssCallable: function PlainCssCallable(t0) {
      this.name = t0;
    },
    ExtendMode: function ExtendMode(t0) {
      this.name = t0;
    },
    ScssParser$(contents, logger, url) {
      var t1 = S.SpanScanner$(contents, url),
        t2 = logger == null ? C.StderrLogger_false : logger;
      return new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.VariableDeclaration), t1, t2);
    },
    ScssParser: function ScssParser(t0, t1, t2) {
      var _ = this;
      _._isUseAllowed = true;
      _._inParentheses = _._inStyleRule = _._stylesheet$_inUnknownAtRule = _._inControlDirective = _._inContentBlock = _._stylesheet$_inMixin = false;
      _._globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
    },
    SingleUnitSassNumber: function SingleUnitSassNumber(t0, t1, t2) {
      this._unit = t0;
      this.value = t1;
      this.asSlash = t2;
    },
    SingleUnitSassNumber__coerceToUnit_closure: function SingleUnitSassNumber__coerceToUnit_closure(t0, t1) {
      this.$this = t0;
      this.unit = t1;
    },
    SingleUnitSassNumber__coerceValueToUnit_closure: function SingleUnitSassNumber__coerceValueToUnit_closure(t0) {
      this.$this = t0;
    },
    SingleUnitSassNumber_multiplyUnits_closure: function SingleUnitSassNumber_multiplyUnits_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    SingleUnitSassNumber_multiplyUnits_closure0: function SingleUnitSassNumber_multiplyUnits_closure0(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    Entry: function Entry(t0, t1, t2) {
      this.source = t0;
      this.target = t1;
      this.identifierName = t2;
    },
    TransformByHandlers_transformByHandlers(_this, onData, onDone, $S, $T) {
      var _null = null, t1 = {},
        controller = P.StreamController_StreamController(_null, _null, _null, _null, true, $T);
      t1.subscription = null;
      controller.onListen = new L.TransformByHandlers_transformByHandlers_closure(t1, _this, onData, controller, H.instantiate1(L.from_handlers__TransformByHandlers__defaultHandleError$closure(), $T), onDone, $S);
      return controller.get$stream();
    },
    TransformByHandlers__defaultHandleError(error, stackTrace, sink) {
      sink.addError$2(error, stackTrace);
    },
    TransformByHandlers_transformByHandlers_closure: function TransformByHandlers_transformByHandlers_closure(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._box_1 = t0;
      _._this = t1;
      _.handleData = t2;
      _.controller = t3;
      _.handleError = t4;
      _.handleDone = t5;
      _.S = t6;
    },
    TransformByHandlers_transformByHandlers__closure: function TransformByHandlers_transformByHandlers__closure(t0, t1, t2) {
      this.handleData = t0;
      this.controller = t1;
      this.S = t2;
    },
    TransformByHandlers_transformByHandlers__closure1: function TransformByHandlers_transformByHandlers__closure1(t0, t1) {
      this.handleError = t0;
      this.controller = t1;
    },
    TransformByHandlers_transformByHandlers__closure0: function TransformByHandlers_transformByHandlers__closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.handleDone = t1;
      this.controller = t2;
    },
    TransformByHandlers_transformByHandlers__closure2: function TransformByHandlers_transformByHandlers__closure2(t0, t1) {
      this._box_1 = t0;
      this._box_0 = t1;
    },
    ModifiableCssDeclaration$0($name, value, span, parsedAsCustomProperty, valueSpanForMap) {
      var t1 = valueSpanForMap == null ? value.get$span() : valueSpanForMap;
      if (parsedAsCustomProperty)
        if (!J.startsWith$1$s($name.get$value($name), "--"))
          H.throwExpression(P.ArgumentError$(string$.parsed, null));
        else if (!(value.get$value(value) instanceof D.SassString0))
          H.throwExpression(P.ArgumentError$(string$.If_par + value.toString$0(0) + "` of type " + H.getRuntimeType(value.get$value(value)).toString$0(0) + ").", null));
      return new L.ModifiableCssDeclaration0($name, value, parsedAsCustomProperty, t1, span);
    },
    ModifiableCssDeclaration0: function ModifiableCssDeclaration0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.parsedAsCustomProperty = t2;
      _.valueSpanForMap = t3;
      _.span = t4;
      _._node2$_indexInParent = _._node2$_parent = null;
      _.isGroupEnd = false;
    },
    Declaration$0($name, value, span) {
      if (C.JSString_methods.startsWith$1($name.get$initialPlain(), "--") && !(value instanceof D.StringExpression0))
        H.throwExpression(P.ArgumentError$(string$.Declarwu + value.toString$0(0) + "` of type " + H.getRuntimeType(value).toString$0(0) + ").", null));
      return new L.Declaration0($name, value, span, null, false);
    },
    Declaration$nested0($name, children, span, value) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      if (C.JSString_methods.startsWith$1($name.get$initialPlain(), "--") && !(value instanceof D.StringExpression0))
        H.throwExpression(P.ArgumentError$(string$.Declarwa, null));
      return new L.Declaration0($name, value, span, t1, t2);
    },
    Declaration0: function Declaration0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    SupportsDeclaration0: function SupportsDeclaration0(t0, t1, t2) {
      this.name = t0;
      this.value = t1;
      this.span = t2;
    },
    ForwardRule0: function ForwardRule0(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _.url = t0;
      _.shownMixinsAndFunctions = t1;
      _.shownVariables = t2;
      _.hiddenMixinsAndFunctions = t3;
      _.hiddenVariables = t4;
      _.prefix = t5;
      _.configuration = t6;
      _.span = t7;
    },
    IfExpression0: function IfExpression0(t0, t1) {
      this.$arguments = t0;
      this.span = t1;
    },
    LoudComment0: function LoudComment0(t0) {
      this.text = t0;
    },
    ExtendMode0: function ExtendMode0(t0) {
      this.name = t0;
    },
    PlainCssCallable0: function PlainCssCallable0(t0) {
      this.name = t0;
    },
    ScssParser$0(contents, logger, url) {
      var t1 = S.SpanScanner$(contents, url),
        t2 = logger == null ? C.C_StderrLogger : logger;
      return new L.ScssParser0(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.VariableDeclaration_2), t1, t2);
    },
    ScssParser0: function ScssParser0(t0, t1, t2) {
      var _ = this;
      _._stylesheet0$_isUseAllowed = true;
      _._stylesheet0$_inParentheses = _._stylesheet0$_inStyleRule = _._stylesheet0$_inUnknownAtRule = _._stylesheet0$_inControlDirective = _._stylesheet0$_inContentBlock = _._stylesheet0$_inMixin = false;
      _._stylesheet0$_globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
    },
    SingleUnitSassNumber0: function SingleUnitSassNumber0(t0, t1, t2) {
      this._single_unit$_unit = t0;
      this.value = t1;
      this.asSlash = t2;
    },
    SingleUnitSassNumber__coerceToUnit_closure0: function SingleUnitSassNumber__coerceToUnit_closure0(t0, t1) {
      this.$this = t0;
      this.unit = t1;
    },
    SingleUnitSassNumber__coerceValueToUnit_closure0: function SingleUnitSassNumber__coerceValueToUnit_closure0(t0) {
      this.$this = t0;
    },
    SingleUnitSassNumber_multiplyUnits_closure1: function SingleUnitSassNumber_multiplyUnits_closure1(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    SingleUnitSassNumber_multiplyUnits_closure2: function SingleUnitSassNumber_multiplyUnits_closure2(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    encodeVlq(value) {
      var res, signBit, digit, t1;
      if (value < $.$get$MIN_INT32() || value > $.$get$MAX_INT32())
        throw H.wrapException(P.ArgumentError$("expected 32 bit int, got: " + value, null));
      res = H._setArrayType([], type$.JSArray_String);
      if (value < 0) {
        value = -value;
        signBit = 1;
      } else
        signBit = 0;
      value = value << 1 | signBit;
      do {
        digit = value & 31;
        value = value >>> 5;
        t1 = value > 0;
        res.push(string$.ABCDEF[t1 ? digit | 32 : digit]);
      } while (t1);
      return res;
    }
  },
  M = {_DelegatingIterableBase: function _DelegatingIterableBase() {
    }, DelegatingSet: function DelegatingSet(t0, t1) {
      this._base = t0;
      this.$ti = t1;
    }, MapKeySet: function MapKeySet(t0, t1) {
      this._baseMap = t0;
      this.$ti = t1;
    }, MapKeySet_difference_closure: function MapKeySet_difference_closure(t0, t1) {
      this.$this = t0;
      this.other = t1;
    }, _MapKeySet__DelegatingIterableBase_UnmodifiableSetMixin: function _MapKeySet__DelegatingIterableBase_UnmodifiableSetMixin() {
    },
    futureToPromise(future, $T) {
      return new self.Promise(P.allowInterop(new M.futureToPromise_closure(future, $T)));
    },
    Util: function Util() {
    },
    futureToPromise_closure: function futureToPromise_closure(t0, t1) {
      this.future = t0;
      this.T = t1;
    },
    futureToPromise__closure: function futureToPromise__closure(t0, t1) {
      this.resolve = t0;
      this.T = t1;
    },
    Context_Context(style) {
      var current = style == null ? D.current() : ".";
      if (style == null)
        style = $.$get$Style_platform();
      return new M.Context(type$.InternalStyle._as(style), current);
    },
    _parseUri(uri) {
      if (typeof uri == "string")
        return P.Uri_parse(uri);
      if (type$.Uri._is(uri))
        return uri;
      throw H.wrapException(P.ArgumentError$value(uri, "uri", "Value must be a String or a Uri"));
    },
    _validateArgList(method, args) {
      var numArgs, i, numArgs0, message, t1, t2, t3, t4;
      for (numArgs = args.length, i = 1; i < numArgs; ++i) {
        if (args[i] == null || args[i - 1] != null)
          continue;
        for (; numArgs >= 1; numArgs = numArgs0) {
          numArgs0 = numArgs - 1;
          if (args[numArgs0] != null)
            break;
        }
        message = new P.StringBuffer("");
        t1 = "" + (method + "(");
        message._contents = t1;
        t2 = H._arrayInstanceType(args);
        t3 = t2._eval$1("SubListIterable<1>");
        t4 = new H.SubListIterable(args, 0, numArgs, t3);
        t4.SubListIterable$3(args, 0, numArgs, t2._precomputed1);
        t3 = t1 + new H.MappedListIterable(t4, new M._validateArgList_closure(), t3._eval$1("MappedListIterable<ListIterable.E,String>")).join$1(0, ", ");
        message._contents = t3;
        message._contents = t3 + ("): part " + (i - 1) + " was null, but part " + i + " was not.");
        throw H.wrapException(P.ArgumentError$(message.toString$0(0), null));
      }
    },
    Context: function Context(t0, t1) {
      this.style = t0;
      this._context$_current = t1;
    },
    Context_joinAll_closure: function Context_joinAll_closure() {
    },
    Context_split_closure: function Context_split_closure() {
    },
    _validateArgList_closure: function _validateArgList_closure() {
    },
    _PathDirection: function _PathDirection(t0) {
      this.name = t0;
    },
    _PathRelation: function _PathRelation(t0) {
      this.name = t0;
    },
    CallableDeclaration: function CallableDeclaration() {
    },
    FunctionRule$($name, $arguments, children, span, comment) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new M.FunctionRule($name, $arguments, span, t1, t2);
    },
    FunctionRule: function FunctionRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.$arguments = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    ParentStatement: function ParentStatement() {
    },
    ParentStatement_closure: function ParentStatement_closure() {
    },
    ParentStatement__closure: function ParentStatement__closure() {
    },
    SupportsNegation: function SupportsNegation(t0, t1) {
      this.condition = t0;
      this.span = t1;
    },
    ParentSelector: function ParentSelector(t0) {
      this.suffix = t0;
    },
    SimpleSelector: function SimpleSelector() {
    },
    Importer: function Importer() {
    },
    StylesheetNode$_(_stylesheet, importer, canonicalUrl, allUpstream) {
      var t1 = new M.StylesheetNode(_stylesheet, importer, canonicalUrl, allUpstream.item1, allUpstream.item2, P.LinkedHashSet_LinkedHashSet$_empty(type$.StylesheetNode));
      t1.StylesheetNode$_$4(_stylesheet, importer, canonicalUrl, allUpstream);
      return t1;
    },
    StylesheetGraph: function StylesheetGraph(t0, t1, t2) {
      this._nodes = t0;
      this.importCache = t1;
      this._transitiveModificationTimes = t2;
    },
    StylesheetGraph_modifiedSince_transitiveModificationTime: function StylesheetGraph_modifiedSince_transitiveModificationTime(t0) {
      this.$this = t0;
    },
    StylesheetGraph_modifiedSince_transitiveModificationTime_closure: function StylesheetGraph_modifiedSince_transitiveModificationTime_closure(t0, t1) {
      this.node = t0;
      this.transitiveModificationTime = t1;
    },
    StylesheetGraph__add_closure: function StylesheetGraph__add_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.baseImporter = t2;
      _.baseUrl = t3;
    },
    StylesheetGraph_addCanonical_closure: function StylesheetGraph_addCanonical_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
    },
    StylesheetGraph_reload_closure: function StylesheetGraph_reload_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.canonicalUrl = t2;
    },
    StylesheetGraph__recanonicalizeImportsForNode_closure: function StylesheetGraph__recanonicalizeImportsForNode_closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.node = t3;
      _.forImport = t4;
      _.newMap = t5;
    },
    StylesheetGraph__nodeFor_closure: function StylesheetGraph__nodeFor_closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.baseImporter = t2;
      _.baseUrl = t3;
      _.forImport = t4;
    },
    StylesheetGraph__nodeFor_closure0: function StylesheetGraph__nodeFor_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.resolvedUrl = t3;
    },
    StylesheetNode: function StylesheetNode(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._stylesheet = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _._upstream = t3;
      _._upstreamImports = t4;
      _._downstream = t5;
    },
    Syntax_forPath(path) {
      switch (X.ParsedPath_ParsedPath$parse(path, $.$get$context().style)._splitExtension$1(1)[1]) {
        case ".sass":
          return C.Syntax_Sass;
        case ".css":
          return C.Syntax_CSS;
        default:
          return C.Syntax_SCSS;
      }
    },
    Syntax: function Syntax(t0) {
      this._syntax$_name = t0;
    },
    CallableDeclaration0: function CallableDeclaration0() {
    },
    FunctionRule$0($name, $arguments, children, span, comment) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new M.FunctionRule0($name, $arguments, span, t1, t2);
    },
    FunctionRule0: function FunctionRule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.$arguments = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    Importer0: function Importer0() {
    },
    SupportsNegation0: function SupportsNegation0(t0, t1) {
      this.condition = t0;
      this.span = t1;
    },
    ParentSelector0: function ParentSelector0(t0) {
      this.suffix = t0;
    },
    ParentStatement0: function ParentStatement0() {
    },
    ParentStatement_closure0: function ParentStatement_closure0() {
    },
    ParentStatement__closure0: function ParentStatement__closure0() {
    },
    SimpleSelector0: function SimpleSelector0() {
    },
    Syntax_forPath0(path) {
      switch (X.ParsedPath_ParsedPath$parse(path, $.$get$context().style)._splitExtension$1(1)[1]) {
        case ".sass":
          return C.Syntax_Sass0;
        case ".css":
          return C.Syntax_CSS0;
        default:
          return C.Syntax_SCSS0;
      }
    },
    Syntax0: function Syntax0(t0) {
      this._syntax0$_name = t0;
    }
  },
  N = {ArgParser: function ArgParser(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._arg_parser$_options = t0;
      _._aliases = t1;
      _.options = t2;
      _.commands = t3;
      _._optionsAndSeparators = t4;
      _.allowTrailingOptions = t5;
      _.usageLineLength = t6;
    }, ArgParser__addOption_closure: function ArgParser__addOption_closure(t0) {
      this.$this = t0;
    }, TTY: function TTY() {
    }, TTYReadStream: function TTYReadStream() {
    }, TTYWriteStream: function TTYWriteStream() {
    }, InterpolatedFunctionExpression: function InterpolatedFunctionExpression(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.span = t2;
    }, AttributeSelector: function AttributeSelector(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.op = t1;
      _.value = t2;
      _.modifier = t3;
    }, AttributeOperator: function AttributeOperator(t0) {
      this._attribute$_text = t0;
    }, IDSelector: function IDSelector(t0) {
      this.name = t0;
    }, IDSelector_unify_closure: function IDSelector_unify_closure(t0) {
      this.$this = t0;
    }, PlaceholderSelector: function PlaceholderSelector(t0) {
      this.name = t0;
    }, UniversalSelector: function UniversalSelector(t0) {
      this.namespace = t0;
    }, NoSourceMapBuffer0: function NoSourceMapBuffer0(t0) {
      this._no_source_map_buffer0$_buffer = t0;
    }, UnitlessSassNumber: function UnitlessSassNumber(t0, t1) {
      this.value = t0;
      this.asSlash = t1;
    },
    serialize(node, charset, indentWidth, inspect, lineFeed, sourceMap, style, useSpaces) {
      var t1, css, t2, prefix,
        visitor = N._SerializeVisitor$0(2, inspect, lineFeed, true, sourceMap, style, true);
      node.accept$1(visitor);
      t1 = visitor._serialize$_buffer;
      css = t1.toString$0(0);
      if (charset) {
        t2 = new H.CodeUnits(css);
        t2 = t2.any$1(t2, new N.serialize_closure());
      } else
        t2 = false;
      if (t2)
        prefix = style === C.OutputStyle_compressed ? "\ufeff" : '@charset "UTF-8";\n';
      else
        prefix = "";
      t2 = prefix + css;
      return new N.SerializeResult(t2, sourceMap ? t1.buildSourceMap$1$prefix(prefix) : null);
    },
    serializeValue0(value, inspect, quote) {
      var visitor = N._SerializeVisitor$0(null, inspect, null, quote, false, null, true);
      value.accept$1(visitor);
      return visitor._serialize$_buffer.toString$0(0);
    },
    serializeSelector(selector, inspect) {
      var visitor = N._SerializeVisitor$0(null, true, null, true, false, null, true);
      selector.accept$1(visitor);
      return visitor._serialize$_buffer.toString$0(0);
    },
    _SerializeVisitor$0(indentWidth, inspect, lineFeed, quote, sourceMap, style, useSpaces) {
      var t1 = sourceMap ? new D.SourceMapBuffer0(new P.StringBuffer(""), H._setArrayType([], type$.JSArray_Entry)) : new N.NoSourceMapBuffer0(new P.StringBuffer("")),
        t2 = style == null ? C.OutputStyle_expanded0 : style,
        t3 = indentWidth == null ? 2 : indentWidth;
      P.RangeError_checkValueInInterval(t3, 0, 10, "indentWidth");
      return new N._SerializeVisitor0(t1, t2, inspect, quote, 32, t3, C.C_LineFeed);
    },
    serialize_closure: function serialize_closure() {
    },
    _SerializeVisitor0: function _SerializeVisitor0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._serialize$_buffer = t0;
      _._indentation = 0;
      _._style = t1;
      _._serialize$_inspect = t2;
      _._quote = t3;
      _._indentCharacter = t4;
      _._indentWidth = t5;
      _._serialize$_lineFeed = t6;
    },
    _SerializeVisitor_visitCssComment_closure: function _SerializeVisitor_visitCssComment_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssAtRule_closure: function _SerializeVisitor_visitCssAtRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssMediaRule_closure: function _SerializeVisitor_visitCssMediaRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssImport_closure: function _SerializeVisitor_visitCssImport_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssImport__closure: function _SerializeVisitor_visitCssImport__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssKeyframeBlock_closure: function _SerializeVisitor_visitCssKeyframeBlock_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssStyleRule_closure: function _SerializeVisitor_visitCssStyleRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssSupportsRule_closure: function _SerializeVisitor_visitCssSupportsRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssDeclaration_closure: function _SerializeVisitor_visitCssDeclaration_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssDeclaration_closure0: function _SerializeVisitor_visitCssDeclaration_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitList_closure: function _SerializeVisitor_visitList_closure() {
    },
    _SerializeVisitor_visitList_closure0: function _SerializeVisitor_visitList_closure0(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _SerializeVisitor_visitList_closure1: function _SerializeVisitor_visitList_closure1(t0) {
      this.$this = t0;
    },
    _SerializeVisitor_visitMap_closure: function _SerializeVisitor_visitMap_closure(t0) {
      this.$this = t0;
    },
    _SerializeVisitor_visitSelectorList_closure: function _SerializeVisitor_visitSelectorList_closure() {
    },
    _SerializeVisitor__write_closure: function _SerializeVisitor__write_closure(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _SerializeVisitor__visitChildren_closure: function _SerializeVisitor__visitChildren_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.children = t2;
    },
    OutputStyle: function OutputStyle(t0) {
      this._serialize$_name = t0;
    },
    LineFeed: function LineFeed() {
    },
    SerializeResult: function SerializeResult(t0, t1) {
      this.css = t0;
      this.sourceMap = t1;
    },
    warn(message, deprecation) {
      var warnDefinition = $.Zone__current.$index(0, C.Symbol__warn);
      if (warnDefinition == null)
        throw H.wrapException(P.ArgumentError$(string$.warn__, null));
      warnDefinition.call$2(message, deprecation);
    },
    withWarnCallback(warn, callback, $T) {
      var t1 = type$.nullable_Object;
      return P.runZoned(new N.withWarnCallback_closure(callback, $T), P.LinkedHashMap_LinkedHashMap$_literal([C.Symbol__warn, warn], t1, t1), $T);
    },
    withWarnCallback_closure: function withWarnCallback_closure(t0, t1) {
      this.callback = t0;
      this.T = t1;
    },
    UnparsedFrame: function UnparsedFrame(t0, t1) {
      this.uri = t0;
      this.member = t1;
    },
    AttributeSelector0: function AttributeSelector0(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.op = t1;
      _.value = t2;
      _.modifier = t3;
    },
    AttributeOperator0: function AttributeOperator0(t0) {
      this._attribute0$_text = t0;
    },
    IDSelector0: function IDSelector0(t0) {
      this.name = t0;
    },
    IDSelector_unify_closure0: function IDSelector_unify_closure0(t0) {
      this.$this = t0;
    },
    InterpolatedFunctionExpression0: function InterpolatedFunctionExpression0(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.span = t2;
    },
    NoSourceMapBuffer: function NoSourceMapBuffer(t0) {
      this._no_source_map_buffer$_buffer = t0;
    },
    PlaceholderSelector0: function PlaceholderSelector0(t0) {
      this.name = t0;
    },
    serialize0(node, charset, indentWidth, inspect, lineFeed, sourceMap, style, useSpaces) {
      var t1, css, t2, prefix,
        visitor = N._SerializeVisitor$(indentWidth == null ? 2 : indentWidth, inspect, lineFeed, true, sourceMap, style, useSpaces);
      node.accept$1(visitor);
      t1 = visitor._buffer;
      css = t1.toString$0(0);
      if (charset) {
        t2 = new H.CodeUnits(css);
        t2 = t2.any$1(t2, new N.serialize_closure0());
      } else
        t2 = false;
      if (t2)
        prefix = style === C.OutputStyle_compressed0 ? "\ufeff" : '@charset "UTF-8";\n';
      else
        prefix = "";
      t2 = prefix + css;
      return new N.SerializeResult0(t2, sourceMap ? t1.buildSourceMap$1$prefix(prefix) : null);
    },
    serializeValue(value, inspect, quote) {
      var visitor = N._SerializeVisitor$(null, inspect, null, quote, false, null, true);
      value.accept$1(visitor);
      return visitor._buffer.toString$0(0);
    },
    serializeSelector0(selector, inspect) {
      var visitor = N._SerializeVisitor$(null, true, null, true, false, null, true);
      selector.accept$1(visitor);
      return visitor._buffer.toString$0(0);
    },
    _SerializeVisitor$(indentWidth, inspect, lineFeed, quote, sourceMap, style, useSpaces) {
      var t1 = sourceMap ? new D.SourceMapBuffer(new P.StringBuffer(""), H._setArrayType([], type$.JSArray_Entry)) : new N.NoSourceMapBuffer(new P.StringBuffer("")),
        t2 = style == null ? C.OutputStyle_expanded : style,
        t3 = useSpaces ? 32 : 9,
        t4 = indentWidth == null ? 2 : indentWidth,
        t5 = lineFeed == null ? C.LineFeed_D6m : lineFeed;
      P.RangeError_checkValueInInterval(t4, 0, 10, "indentWidth");
      return new N._SerializeVisitor(t1, t2, inspect, quote, t3, t4, t5);
    },
    serialize_closure0: function serialize_closure0() {
    },
    _SerializeVisitor: function _SerializeVisitor(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._buffer = t0;
      _._serialize0$_indentation = 0;
      _._serialize0$_style = t1;
      _._inspect = t2;
      _._serialize0$_quote = t3;
      _._serialize0$_indentCharacter = t4;
      _._serialize0$_indentWidth = t5;
      _._lineFeed = t6;
    },
    _SerializeVisitor_visitCssComment_closure0: function _SerializeVisitor_visitCssComment_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssAtRule_closure0: function _SerializeVisitor_visitCssAtRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssMediaRule_closure0: function _SerializeVisitor_visitCssMediaRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssImport_closure0: function _SerializeVisitor_visitCssImport_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssImport__closure0: function _SerializeVisitor_visitCssImport__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssKeyframeBlock_closure0: function _SerializeVisitor_visitCssKeyframeBlock_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssStyleRule_closure0: function _SerializeVisitor_visitCssStyleRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssSupportsRule_closure0: function _SerializeVisitor_visitCssSupportsRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssDeclaration_closure1: function _SerializeVisitor_visitCssDeclaration_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssDeclaration_closure2: function _SerializeVisitor_visitCssDeclaration_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitList_closure2: function _SerializeVisitor_visitList_closure2() {
    },
    _SerializeVisitor_visitList_closure3: function _SerializeVisitor_visitList_closure3(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _SerializeVisitor_visitList_closure4: function _SerializeVisitor_visitList_closure4(t0) {
      this.$this = t0;
    },
    _SerializeVisitor_visitMap_closure0: function _SerializeVisitor_visitMap_closure0(t0) {
      this.$this = t0;
    },
    _SerializeVisitor_visitSelectorList_closure0: function _SerializeVisitor_visitSelectorList_closure0() {
    },
    _SerializeVisitor__write_closure0: function _SerializeVisitor__write_closure0(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _SerializeVisitor__visitChildren_closure0: function _SerializeVisitor__visitChildren_closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.children = t2;
    },
    OutputStyle0: function OutputStyle0(t0) {
      this._name = t0;
    },
    LineFeed0: function LineFeed0(t0, t1) {
      this.name = t0;
      this.text = t1;
    },
    SerializeResult0: function SerializeResult0(t0, t1) {
      this.css = t0;
      this.sourceMap = t1;
    },
    UnitlessSassNumber0: function UnitlessSassNumber0(t0, t1) {
      this.value = t0;
      this.asSlash = t1;
    },
    UniversalSelector0: function UniversalSelector0(t0) {
      this.namespace = t0;
    },
    warn0(message, deprecation) {
      var warnDefinition = $.Zone__current.$index(0, C.Symbol__warn);
      if (warnDefinition == null)
        throw H.wrapException(P.ArgumentError$(string$.warn__, null));
      warnDefinition.call$2(message, deprecation);
    },
    withWarnCallback0(warn, callback, $T) {
      var t1 = type$.nullable_Object;
      return P.runZoned(new N.withWarnCallback_closure0(callback, $T), P.LinkedHashMap_LinkedHashMap$_literal([C.Symbol__warn, warn], t1, t1), $T);
    },
    withWarnCallback_closure0: function withWarnCallback_closure0(t0, t1) {
      this.callback = t0;
      this.T = t1;
    }
  },
  O = {EmptyUnmodifiableSet: function EmptyUnmodifiableSet(t0) {
      this.$ti = t0;
    }, _EmptyUnmodifiableSet_IterableBase_UnmodifiableSetMixin: function _EmptyUnmodifiableSet_IterableBase_UnmodifiableSetMixin() {
    },
    Style__getPlatformStyle() {
      if (P.Uri_base().get$scheme() !== "file")
        return $.$get$Style_url();
      var t1 = P.Uri_base();
      if (!C.JSString_methods.endsWith$1(t1.get$path(t1), "/"))
        return $.$get$Style_url();
      if (P._Uri__Uri(null, "a/b", null, null).toFilePath$0() === "a\\b")
        return $.$get$Style_windows();
      return $.$get$Style_posix();
    },
    Style: function Style() {
    },
    NullExpression: function NullExpression(t0) {
      this.span = t0;
    },
    AsyncImportCache__toImporters(importers, loadPaths, packageConfig) {
      var t2, t3, _i, path, _null = null,
        sassPath = H._asStringQ(type$.Object._as(J.get$env$x(self.process)).SASS_PATH),
        t1 = H._setArrayType([], type$.JSArray_AsyncImporter);
      for (t2 = J.get$iterator$ax(loadPaths); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t1.push(new F.FilesystemImporter($.$get$context().absolute$7(t3, _null, _null, _null, _null, _null, _null)));
      }
      if (sassPath != null) {
        t2 = sassPath.split(J.$eq$(J.get$platform$x(self.process), "win32") ? ";" : ":");
        t3 = t2.length;
        _i = 0;
        for (; _i < t3; ++_i) {
          path = t2[_i];
          t1.push(new F.FilesystemImporter($.$get$context().absolute$7(path, _null, _null, _null, _null, _null, _null)));
        }
      }
      return t1;
    },
    AsyncImportCache: function AsyncImportCache(t0, t1, t2, t3, t4) {
      var _ = this;
      _._async_import_cache$_importers = t0;
      _._async_import_cache$_logger = t1;
      _._async_import_cache$_canonicalizeCache = t2;
      _._async_import_cache$_importCache = t3;
      _._async_import_cache$_resultsCache = t4;
    },
    AsyncImportCache_canonicalize_closure: function AsyncImportCache_canonicalize_closure(t0, t1, t2) {
      this.$this = t0;
      this.url = t1;
      this.forImport = t2;
    },
    AsyncImportCache__canonicalize_closure: function AsyncImportCache__canonicalize_closure(t0, t1) {
      this.importer = t0;
      this.url = t1;
    },
    AsyncImportCache_importCanonical_closure: function AsyncImportCache_importCanonical_closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
      _.quiet = t4;
    },
    AsyncImportCache_humanize_closure: function AsyncImportCache_humanize_closure(t0) {
      this.canonicalUrl = t0;
    },
    AsyncImportCache_humanize_closure0: function AsyncImportCache_humanize_closure0() {
    },
    AsyncImportCache_humanize_closure1: function AsyncImportCache_humanize_closure1() {
    },
    Environment$() {
      var t1 = type$.String,
        t2 = type$.Module_Callable,
        t3 = type$.AstNode,
        t4 = type$.int,
        t5 = type$.Callable,
        t6 = type$.JSArray_Map_String_Callable;
      return new O.Environment(P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), null, null, H._setArrayType([], type$.JSArray_Module_Callable), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Value)], type$.JSArray_Map_String_Value), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t3)], type$.JSArray_Map_String_AstNode), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), null);
    },
    Environment$_(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = type$.String,
        t2 = type$.int;
      return new O.Environment(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule(environment, css, extensionStore, forwarded) {
      var t1, t2, t3, t4, t5, t6;
      if (forwarded == null)
        forwarded = C.Set_empty;
      t1 = O._EnvironmentModule__makeModulesByVariable(forwarded);
      t2 = O._EnvironmentModule__memberMap(C.JSArray_methods.get$first(environment._variables), forwarded.map$1$1(0, new O._EnvironmentModule__EnvironmentModule_closure(), type$.Map_String_Value), type$.Value);
      t3 = O._EnvironmentModule__memberMap(C.JSArray_methods.get$first(environment._variableNodes), forwarded.map$1$1(0, new O._EnvironmentModule__EnvironmentModule_closure0(), type$.Map_String_AstNode), type$.AstNode);
      t4 = type$.Map_String_Callable;
      t5 = type$.Callable;
      t6 = O._EnvironmentModule__memberMap(C.JSArray_methods.get$first(environment._functions), forwarded.map$1$1(0, new O._EnvironmentModule__EnvironmentModule_closure1(), t4), t5);
      t5 = O._EnvironmentModule__memberMap(C.JSArray_methods.get$first(environment._mixins), forwarded.map$1$1(0, new O._EnvironmentModule__EnvironmentModule_closure2(), t4), t5);
      t4 = J.get$isNotEmpty$asx(css.get$children(css)) || C.JSArray_methods.any$1(environment._allModules, new O._EnvironmentModule__EnvironmentModule_closure3());
      return O._EnvironmentModule$_(environment, css, extensionStore, t1, t2, t3, t6, t5, t4, !extensionStore.get$isEmpty(extensionStore) || C.JSArray_methods.any$1(environment._allModules, new O._EnvironmentModule__EnvironmentModule_closure4()));
    },
    _EnvironmentModule__makeModulesByVariable(forwarded) {
      var modulesByVariable, t1, t2, t3, t4, t5;
      if (forwarded.get$isEmpty(forwarded))
        return C.Map_empty;
      modulesByVariable = P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Module_Callable);
      for (t1 = forwarded.get$iterator(forwarded); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        if (t2 instanceof O._EnvironmentModule) {
          for (t3 = t2._modulesByVariable, t3 = t3.get$values(t3), t3 = t3.get$iterator(t3); t3.moveNext$0();) {
            t4 = t3.get$current(t3);
            t5 = t4.get$variables();
            B.setAll(modulesByVariable, t5.get$keys(t5), t4);
          }
          B.setAll(modulesByVariable, J.get$keys$z(C.JSArray_methods.get$first(t2._environment$_environment._variables)), t2);
        } else {
          t3 = t2.get$variables();
          B.setAll(modulesByVariable, t3.get$keys(t3), t2);
        }
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new U.PublicMemberMapView(localMap, $V._eval$1("PublicMemberMapView<0>"));
      if (otherMaps.get$isEmpty(otherMaps))
        return localMap;
      t1 = H._setArrayType([], $V._eval$1("JSArray<Map<String,0>>"));
      for (t2 = otherMaps.get$iterator(otherMaps); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return Z.MergedMapView$(t1, type$.String, $V);
    },
    _EnvironmentModule$_(_environment, css, extensionStore, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new O._EnvironmentModule(_environment._allModules, variables, variableNodes, functions, mixins, extensionStore, css, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    Environment: function Environment(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._environment$_modules = t0;
      _._namespaceNodes = t1;
      _._globalModules = t2;
      _._importedModules = t3;
      _._forwardedModules = t4;
      _._nestedForwardedModules = t5;
      _._allModules = t6;
      _._variables = t7;
      _._variableNodes = t8;
      _._variableIndices = t9;
      _._functions = t10;
      _._functionIndices = t11;
      _._mixins = t12;
      _._mixinIndices = t13;
      _._content = t14;
      _._inMixin = false;
      _._inSemiGlobalScope = true;
      _._lastVariableIndex = _._lastVariableName = null;
    },
    Environment_importForwards_closure: function Environment_importForwards_closure() {
    },
    Environment_importForwards_closure0: function Environment_importForwards_closure0() {
    },
    Environment_importForwards_closure1: function Environment_importForwards_closure1() {
    },
    Environment__getVariableFromGlobalModule_closure: function Environment__getVariableFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure: function Environment_setVariable_closure(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment_setVariable_closure0: function Environment_setVariable_closure0(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure1: function Environment_setVariable_closure1(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment__getFunctionFromGlobalModule_closure: function Environment__getFunctionFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    Environment__getMixinFromGlobalModule_closure: function Environment__getMixinFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    Environment_toModule_closure: function Environment_toModule_closure() {
    },
    Environment_toDummyModule_closure: function Environment_toDummyModule_closure() {
    },
    Environment__fromOneModule_closure: function Environment__fromOneModule_closure(t0, t1) {
      this.callback = t0;
      this.T = t1;
    },
    Environment__fromOneModule__closure: function Environment__fromOneModule__closure(t0, t1) {
      this.entry = t0;
      this.T = t1;
    },
    _EnvironmentModule: function _EnvironmentModule(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extensionStore = t5;
      _.css = t6;
      _.transitivelyContainsCss = t7;
      _.transitivelyContainsExtensions = t8;
      _._environment$_environment = t9;
      _._modulesByVariable = t10;
    },
    _EnvironmentModule__EnvironmentModule_closure: function _EnvironmentModule__EnvironmentModule_closure() {
    },
    _EnvironmentModule__EnvironmentModule_closure0: function _EnvironmentModule__EnvironmentModule_closure0() {
    },
    _EnvironmentModule__EnvironmentModule_closure1: function _EnvironmentModule__EnvironmentModule_closure1() {
    },
    _EnvironmentModule__EnvironmentModule_closure2: function _EnvironmentModule__EnvironmentModule_closure2() {
    },
    _EnvironmentModule__EnvironmentModule_closure3: function _EnvironmentModule__EnvironmentModule_closure3() {
    },
    _EnvironmentModule__EnvironmentModule_closure4: function _EnvironmentModule__EnvironmentModule_closure4() {
    },
    _SassNull: function _SassNull() {
    },
    AsyncImportCache$none(logger) {
      var t1 = logger == null ? C.C_StderrLogger : logger,
        t2 = type$.Uri;
      return new O.AsyncImportCache0(t1, P.LinkedHashMap_LinkedHashMap$_empty(type$.Tuple2_Uri_bool, type$.nullable_Tuple3_AsyncImporter_Uri_Uri_2), P.LinkedHashMap_LinkedHashMap$_empty(t2, type$.nullable_Stylesheet_2), P.LinkedHashMap_LinkedHashMap$_empty(t2, type$.ImporterResult_2));
    },
    AsyncImportCache0: function AsyncImportCache0(t0, t1, t2, t3) {
      var _ = this;
      _._async_import_cache0$_logger = t0;
      _._async_import_cache0$_canonicalizeCache = t1;
      _._async_import_cache0$_importCache = t2;
      _._async_import_cache0$_resultsCache = t3;
    },
    AsyncImportCache_canonicalize_closure0: function AsyncImportCache_canonicalize_closure0(t0, t1, t2) {
      this.$this = t0;
      this.url = t1;
      this.forImport = t2;
    },
    AsyncImportCache__canonicalize_closure0: function AsyncImportCache__canonicalize_closure0(t0, t1) {
      this.importer = t0;
      this.url = t1;
    },
    AsyncImportCache_importCanonical_closure0: function AsyncImportCache_importCanonical_closure0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
      _.quiet = t4;
    },
    AsyncImportCache_humanize_closure2: function AsyncImportCache_humanize_closure2(t0) {
      this.canonicalUrl = t0;
    },
    AsyncImportCache_humanize_closure3: function AsyncImportCache_humanize_closure3() {
    },
    AsyncImportCache_humanize_closure4: function AsyncImportCache_humanize_closure4() {
    },
    Environment$0() {
      var t1 = type$.String,
        t2 = type$.Module_Callable_2,
        t3 = type$.AstNode_2,
        t4 = type$.int,
        t5 = type$.Callable_2,
        t6 = type$.JSArray_Map_String_Callable_2;
      return new O.Environment0(P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), null, null, H._setArrayType([], type$.JSArray_Module_Callable_2), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Value_2)], type$.JSArray_Map_String_Value_2), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t3)], type$.JSArray_Map_String_AstNode_2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), null);
    },
    Environment$_0(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = type$.String,
        t2 = type$.int;
      return new O.Environment0(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule1(environment, css, extensionStore, forwarded) {
      var t1, t2, t3, t4, t5, t6;
      if (forwarded == null)
        forwarded = C.Set_empty2;
      t1 = O._EnvironmentModule__makeModulesByVariable1(forwarded);
      t2 = O._EnvironmentModule__memberMap1(C.JSArray_methods.get$first(environment._environment0$_variables), forwarded.map$1$1(0, new O._EnvironmentModule__EnvironmentModule_closure11(), type$.Map_String_Value_2), type$.Value_2);
      t3 = O._EnvironmentModule__memberMap1(C.JSArray_methods.get$first(environment._environment0$_variableNodes), forwarded.map$1$1(0, new O._EnvironmentModule__EnvironmentModule_closure12(), type$.Map_String_AstNode_2), type$.AstNode_2);
      t4 = type$.Map_String_Callable_2;
      t5 = type$.Callable_2;
      t6 = O._EnvironmentModule__memberMap1(C.JSArray_methods.get$first(environment._environment0$_functions), forwarded.map$1$1(0, new O._EnvironmentModule__EnvironmentModule_closure13(), t4), t5);
      t5 = O._EnvironmentModule__memberMap1(C.JSArray_methods.get$first(environment._environment0$_mixins), forwarded.map$1$1(0, new O._EnvironmentModule__EnvironmentModule_closure14(), t4), t5);
      t4 = J.get$isNotEmpty$asx(css.get$children(css)) || C.JSArray_methods.any$1(environment._environment0$_allModules, new O._EnvironmentModule__EnvironmentModule_closure15());
      return O._EnvironmentModule$_1(environment, css, extensionStore, t1, t2, t3, t6, t5, t4, !extensionStore.get$isEmpty(extensionStore) || C.JSArray_methods.any$1(environment._environment0$_allModules, new O._EnvironmentModule__EnvironmentModule_closure16()));
    },
    _EnvironmentModule__makeModulesByVariable1(forwarded) {
      var modulesByVariable, t1, t2, t3, t4, t5;
      if (forwarded.get$isEmpty(forwarded))
        return C.Map_empty5;
      modulesByVariable = P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Module_Callable_2);
      for (t1 = forwarded.get$iterator(forwarded); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        if (t2 instanceof O._EnvironmentModule1) {
          for (t3 = t2._environment0$_modulesByVariable, t3 = t3.get$values(t3), t3 = t3.get$iterator(t3); t3.moveNext$0();) {
            t4 = t3.get$current(t3);
            t5 = t4.get$variables();
            B.setAll0(modulesByVariable, t5.get$keys(t5), t4);
          }
          B.setAll0(modulesByVariable, J.get$keys$z(C.JSArray_methods.get$first(t2._environment0$_environment._environment0$_variables)), t2);
        } else {
          t3 = t2.get$variables();
          B.setAll0(modulesByVariable, t3.get$keys(t3), t2);
        }
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap1(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new U.PublicMemberMapView0(localMap, $V._eval$1("PublicMemberMapView0<0>"));
      if (otherMaps.get$isEmpty(otherMaps))
        return localMap;
      t1 = H._setArrayType([], $V._eval$1("JSArray<Map<String,0>>"));
      for (t2 = otherMaps.get$iterator(otherMaps); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return Z.MergedMapView$0(t1, type$.String, $V);
    },
    _EnvironmentModule$_1(_environment, css, extensionStore, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new O._EnvironmentModule1(_environment._environment0$_allModules, variables, variableNodes, functions, mixins, extensionStore, css, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    Environment0: function Environment0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._environment0$_modules = t0;
      _._environment0$_namespaceNodes = t1;
      _._environment0$_globalModules = t2;
      _._environment0$_importedModules = t3;
      _._environment0$_forwardedModules = t4;
      _._environment0$_nestedForwardedModules = t5;
      _._environment0$_allModules = t6;
      _._environment0$_variables = t7;
      _._environment0$_variableNodes = t8;
      _._environment0$_variableIndices = t9;
      _._environment0$_functions = t10;
      _._environment0$_functionIndices = t11;
      _._environment0$_mixins = t12;
      _._environment0$_mixinIndices = t13;
      _._environment0$_content = t14;
      _._environment0$_inMixin = false;
      _._environment0$_inSemiGlobalScope = true;
      _._environment0$_lastVariableIndex = _._environment0$_lastVariableName = null;
    },
    Environment_importForwards_closure2: function Environment_importForwards_closure2() {
    },
    Environment_importForwards_closure3: function Environment_importForwards_closure3() {
    },
    Environment_importForwards_closure4: function Environment_importForwards_closure4() {
    },
    Environment__getVariableFromGlobalModule_closure0: function Environment__getVariableFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure2: function Environment_setVariable_closure2(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment_setVariable_closure3: function Environment_setVariable_closure3(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure4: function Environment_setVariable_closure4(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment__getFunctionFromGlobalModule_closure0: function Environment__getFunctionFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    Environment__getMixinFromGlobalModule_closure0: function Environment__getMixinFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    Environment_toModule_closure0: function Environment_toModule_closure0() {
    },
    Environment_toDummyModule_closure0: function Environment_toDummyModule_closure0() {
    },
    Environment__fromOneModule_closure0: function Environment__fromOneModule_closure0(t0, t1) {
      this.callback = t0;
      this.T = t1;
    },
    Environment__fromOneModule__closure0: function Environment__fromOneModule__closure0(t0, t1) {
      this.entry = t0;
      this.T = t1;
    },
    _EnvironmentModule1: function _EnvironmentModule1(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extensionStore = t5;
      _.css = t6;
      _.transitivelyContainsCss = t7;
      _.transitivelyContainsExtensions = t8;
      _._environment0$_environment = t9;
      _._environment0$_modulesByVariable = t10;
    },
    _EnvironmentModule__EnvironmentModule_closure11: function _EnvironmentModule__EnvironmentModule_closure11() {
    },
    _EnvironmentModule__EnvironmentModule_closure12: function _EnvironmentModule__EnvironmentModule_closure12() {
    },
    _EnvironmentModule__EnvironmentModule_closure13: function _EnvironmentModule__EnvironmentModule_closure13() {
    },
    _EnvironmentModule__EnvironmentModule_closure14: function _EnvironmentModule__EnvironmentModule_closure14() {
    },
    _EnvironmentModule__EnvironmentModule_closure15: function _EnvironmentModule__EnvironmentModule_closure15() {
    },
    _EnvironmentModule__EnvironmentModule_closure16: function _EnvironmentModule__EnvironmentModule_closure16() {
    },
    NullExpression0: function NullExpression0(t0) {
      this.span = t0;
    },
    nullConstructor_closure: function nullConstructor_closure() {
    },
    nullConstructor__closure: function nullConstructor__closure() {
    },
    nullConstructor__closure0: function nullConstructor__closure0() {
    },
    _SassNull0: function _SassNull0() {
    }
  },
  P = {
    _AsyncRun__initializeScheduleImmediate() {
      var div, span, t1 = {};
      if (self.scheduleImmediate != null)
        return P.async__AsyncRun__scheduleImmediateJsOverride$closure();
      if (self.MutationObserver != null && self.document != null) {
        div = self.document.createElement("div");
        span = self.document.createElement("span");
        t1.storedCallback = null;
        new self.MutationObserver(H.convertDartClosureToJS(new P._AsyncRun__initializeScheduleImmediate_internalCallback(t1), 1)).observe(div, {childList: true});
        return new P._AsyncRun__initializeScheduleImmediate_closure(t1, div, span);
      } else if (self.setImmediate != null)
        return P.async__AsyncRun__scheduleImmediateWithSetImmediate$closure();
      return P.async__AsyncRun__scheduleImmediateWithTimer$closure();
    },
    _AsyncRun__scheduleImmediateJsOverride(callback) {
      self.scheduleImmediate(H.convertDartClosureToJS(new P._AsyncRun__scheduleImmediateJsOverride_internalCallback(callback), 0));
    },
    _AsyncRun__scheduleImmediateWithSetImmediate(callback) {
      self.setImmediate(H.convertDartClosureToJS(new P._AsyncRun__scheduleImmediateWithSetImmediate_internalCallback(callback), 0));
    },
    _AsyncRun__scheduleImmediateWithTimer(callback) {
      P.Timer__createTimer(C.Duration_0, callback);
    },
    Timer__createTimer(duration, callback) {
      var milliseconds = C.JSInt_methods._tdivFast$1(duration._duration, 1000);
      return P._TimerImpl$(milliseconds < 0 ? 0 : milliseconds, callback);
    },
    _TimerImpl$(milliseconds, callback) {
      var t1 = new P._TimerImpl(true);
      t1._TimerImpl$2(milliseconds, callback);
      return t1;
    },
    _TimerImpl$periodic(milliseconds, callback) {
      var t1 = new P._TimerImpl(false);
      t1._TimerImpl$periodic$2(milliseconds, callback);
      return t1;
    },
    _makeAsyncAwaitCompleter($T) {
      return new P._AsyncAwaitCompleter(new P._Future($.Zone__current, $T._eval$1("_Future<0>")), $T._eval$1("_AsyncAwaitCompleter<0>"));
    },
    _asyncStartSync(bodyFunction, completer) {
      bodyFunction.call$2(0, null);
      completer.isSync = true;
      return completer._future;
    },
    _asyncAwait(object, bodyFunction) {
      P._awaitOnObject(object, bodyFunction);
    },
    _asyncReturn(object, completer) {
      completer.complete$1(object);
    },
    _asyncRethrow(object, completer) {
      completer.completeError$2(H.unwrapException(object), H.getTraceFromException(object));
    },
    _awaitOnObject(object, bodyFunction) {
      var t1, future,
        thenCallback = new P._awaitOnObject_closure(bodyFunction),
        errorCallback = new P._awaitOnObject_closure0(bodyFunction);
      if (object instanceof P._Future)
        object._thenAwait$1$2(thenCallback, errorCallback, type$.dynamic);
      else {
        t1 = type$.dynamic;
        if (type$.Future_dynamic._is(object))
          object.then$1$2$onError(0, thenCallback, errorCallback, t1);
        else {
          future = new P._Future($.Zone__current, type$._Future_dynamic);
          future._state = 8;
          future._resultOrListeners = object;
          future._thenAwait$1$2(thenCallback, errorCallback, t1);
        }
      }
    },
    _wrapJsFunctionForAsync($function) {
      var $protected = function(fn, ERROR) {
        return function(errorCode, result) {
          while (true)
            try {
              fn(errorCode, result);
              break;
            } catch (error) {
              result = error;
              errorCode = ERROR;
            }
        };
      }($function, 1);
      return $.Zone__current.registerBinaryCallback$3$1(new P._wrapJsFunctionForAsync_closure($protected), type$.void, type$.int, type$.dynamic);
    },
    _IterationMarker_yieldStar(values) {
      return new P._IterationMarker(values, 1);
    },
    _IterationMarker_endOfIteration() {
      return C._IterationMarker_null_2;
    },
    _IterationMarker_uncaughtError(error) {
      return new P._IterationMarker(error, 3);
    },
    _makeSyncStarIterable(body, $T) {
      return new P._SyncStarIterable(body, $T._eval$1("_SyncStarIterable<0>"));
    },
    AsyncError$(error, stackTrace) {
      var t1 = H.checkNotNullable(error, "error", type$.Object);
      return new P.AsyncError(t1, stackTrace == null ? P.AsyncError_defaultStackTrace(error) : stackTrace);
    },
    AsyncError_defaultStackTrace(error) {
      var stackTrace;
      if (type$.Error._is(error)) {
        stackTrace = error.get$stackTrace();
        if (stackTrace != null)
          return stackTrace;
      }
      return C._StringStackTrace_3uE;
    },
    Future_Future$value(value, $T) {
      var t1;
      $T._as(value);
      t1 = new P._Future($.Zone__current, $T._eval$1("_Future<0>"));
      t1._asyncComplete$1(value);
      return t1;
    },
    Future_Future$error(error, stackTrace, $T) {
      var t1, replacement;
      H.checkNotNullable(error, "error", type$.Object);
      t1 = $.Zone__current;
      if (t1 !== C.C__RootZone) {
        replacement = t1.errorCallback$2(error, stackTrace);
        if (replacement != null) {
          error = replacement.error;
          stackTrace = replacement.stackTrace;
        }
      }
      if (stackTrace == null)
        stackTrace = P.AsyncError_defaultStackTrace(error);
      t1 = new P._Future($.Zone__current, $T._eval$1("_Future<0>"));
      t1._asyncCompleteError$2(error, stackTrace);
      return t1;
    },
    Future_wait(futures, $T) {
      var error, stackTrace, handleError, future, pos, e, st, t1, t2, exception, _box_0 = {}, cleanUp = null,
        eagerError = false,
        _future = new P._Future($.Zone__current, $T._eval$1("_Future<List<0>>"));
      _box_0.values = null;
      _box_0.remaining = 0;
      error = H._Cell$named("error");
      stackTrace = H._Cell$named("stackTrace");
      handleError = new P.Future_wait_handleError(_box_0, cleanUp, eagerError, _future, error, stackTrace);
      try {
        for (t1 = J.get$iterator$ax(futures), t2 = type$.Null; t1.moveNext$0();) {
          future = t1.get$current(t1);
          pos = _box_0.remaining;
          J.then$1$2$onError$z(future, new P.Future_wait_closure(_box_0, pos, _future, cleanUp, eagerError, error, stackTrace, $T), handleError, t2);
          ++_box_0.remaining;
        }
        t1 = _box_0.remaining;
        if (t1 === 0) {
          t1 = _future;
          t1._completeWithValue$1(H._setArrayType([], $T._eval$1("JSArray<0>")));
          return t1;
        }
        _box_0.values = P.List_List$filled(t1, null, false, $T._eval$1("0?"));
      } catch (exception) {
        e = H.unwrapException(exception);
        st = H.getTraceFromException(exception);
        if (_box_0.remaining === 0 || eagerError)
          return P.Future_Future$error(e, st, $T._eval$1("List<0>"));
        else {
          error._value = e;
          stackTrace._value = st;
        }
      }
      return _future;
    },
    _Future$zoneValue(value, _zone, $T) {
      var t1 = new P._Future(_zone, $T._eval$1("_Future<0>"));
      t1._state = 8;
      t1._resultOrListeners = value;
      return t1;
    },
    _Future__chainCoreFuture(source, target) {
      var t1, listeners;
      for (; t1 = source._state, (t1 & 4) !== 0;)
        source = source._resultOrListeners;
      if ((t1 & 24) !== 0) {
        listeners = target._removeListeners$0();
        target._cloneResult$1(source);
        P._Future__propagateToListeners(target, listeners);
      } else {
        listeners = target._resultOrListeners;
        target._state = target._state & 1 | 4;
        target._resultOrListeners = source;
        source._prependListeners$1(listeners);
      }
    },
    _Future__propagateToListeners(source, listeners) {
      var t2, _box_0, t3, t4, hasError, nextListener, nextListener0, sourceResult, t5, zone, oldZone, result, current, _box_1 = {},
        t1 = _box_1.source = source;
      for (t2 = type$.Future_dynamic; true;) {
        _box_0 = {};
        t3 = t1._state;
        t4 = (t3 & 16) === 0;
        hasError = !t4;
        if (listeners == null) {
          if (hasError && (t3 & 1) === 0) {
            t2 = t1._resultOrListeners;
            t1._zone.handleUncaughtError$2(t2.error, t2.stackTrace);
          }
          return;
        }
        _box_0.listener = listeners;
        nextListener = listeners._nextListener;
        for (t1 = listeners; nextListener != null; t1 = nextListener, nextListener = nextListener0) {
          t1._nextListener = null;
          P._Future__propagateToListeners(_box_1.source, t1);
          _box_0.listener = nextListener;
          nextListener0 = nextListener._nextListener;
        }
        t3 = _box_1.source;
        sourceResult = t3._resultOrListeners;
        _box_0.listenerHasError = hasError;
        _box_0.listenerValueOrError = sourceResult;
        if (t4) {
          t5 = t1.state;
          t5 = (t5 & 1) !== 0 || (t5 & 15) === 8;
        } else
          t5 = true;
        if (t5) {
          zone = t1.result._zone;
          if (hasError) {
            t1 = t3._zone;
            t1 = !(t1 === zone || t1.get$errorZone() === zone.get$errorZone());
          } else
            t1 = false;
          if (t1) {
            t1 = _box_1.source;
            t2 = t1._resultOrListeners;
            t1._zone.handleUncaughtError$2(t2.error, t2.stackTrace);
            return;
          }
          oldZone = $.Zone__current;
          if (oldZone !== zone)
            $.Zone__current = zone;
          else
            oldZone = null;
          t1 = _box_0.listener.state;
          if ((t1 & 15) === 8)
            new P._Future__propagateToListeners_handleWhenCompleteCallback(_box_0, _box_1, hasError).call$0();
          else if (t4) {
            if ((t1 & 1) !== 0)
              new P._Future__propagateToListeners_handleValueCallback(_box_0, sourceResult).call$0();
          } else if ((t1 & 2) !== 0)
            new P._Future__propagateToListeners_handleError(_box_1, _box_0).call$0();
          if (oldZone != null)
            $.Zone__current = oldZone;
          t1 = _box_0.listenerValueOrError;
          if (t2._is(t1)) {
            t3 = _box_0.listener.$ti;
            t3 = t3._eval$1("Future<2>")._is(t1) || !t3._rest[1]._is(t1);
          } else
            t3 = false;
          if (t3) {
            result = _box_0.listener.result;
            if ((t1._state & 24) !== 0) {
              current = result._resultOrListeners;
              result._resultOrListeners = null;
              listeners = result._reverseListeners$1(current);
              result._state = t1._state & 30 | result._state & 1;
              result._resultOrListeners = t1._resultOrListeners;
              _box_1.source = t1;
              continue;
            } else
              P._Future__chainCoreFuture(t1, result);
            return;
          }
        }
        result = _box_0.listener.result;
        current = result._resultOrListeners;
        result._resultOrListeners = null;
        listeners = result._reverseListeners$1(current);
        t1 = _box_0.listenerHasError;
        t3 = _box_0.listenerValueOrError;
        if (!t1) {
          result._state = 8;
          result._resultOrListeners = t3;
        } else {
          result._state = result._state & 1 | 16;
          result._resultOrListeners = t3;
        }
        _box_1.source = result;
        t1 = result;
      }
    },
    _registerErrorHandler(errorHandler, zone) {
      if (type$.dynamic_Function_Object_StackTrace._is(errorHandler))
        return zone.registerBinaryCallback$3$1(errorHandler, type$.dynamic, type$.Object, type$.StackTrace);
      if (type$.dynamic_Function_Object._is(errorHandler))
        return zone.registerUnaryCallback$2$1(errorHandler, type$.dynamic, type$.Object);
      throw H.wrapException(P.ArgumentError$value(errorHandler, "onError", string$.Error_));
    },
    _microtaskLoop() {
      var entry, next;
      for (entry = $._nextCallback; entry != null; entry = $._nextCallback) {
        $._lastPriorityCallback = null;
        next = entry.next;
        $._nextCallback = next;
        if (next == null)
          $._lastCallback = null;
        entry.callback.call$0();
      }
    },
    _startMicrotaskLoop() {
      $._isInCallbackLoop = true;
      try {
        P._microtaskLoop();
      } finally {
        $._lastPriorityCallback = null;
        $._isInCallbackLoop = false;
        if ($._nextCallback != null)
          $.$get$_AsyncRun__scheduleImmediateClosure().call$1(P.async___startMicrotaskLoop$closure());
      }
    },
    _scheduleAsyncCallback(callback) {
      var newEntry = new P._AsyncCallbackEntry(callback),
        lastCallback = $._lastCallback;
      if (lastCallback == null) {
        $._nextCallback = $._lastCallback = newEntry;
        if (!$._isInCallbackLoop)
          $.$get$_AsyncRun__scheduleImmediateClosure().call$1(P.async___startMicrotaskLoop$closure());
      } else
        $._lastCallback = lastCallback.next = newEntry;
    },
    _schedulePriorityAsyncCallback(callback) {
      var entry, lastPriorityCallback, next,
        t1 = $._nextCallback;
      if (t1 == null) {
        P._scheduleAsyncCallback(callback);
        $._lastPriorityCallback = $._lastCallback;
        return;
      }
      entry = new P._AsyncCallbackEntry(callback);
      lastPriorityCallback = $._lastPriorityCallback;
      if (lastPriorityCallback == null) {
        entry.next = t1;
        $._nextCallback = $._lastPriorityCallback = entry;
      } else {
        next = lastPriorityCallback.next;
        entry.next = next;
        $._lastPriorityCallback = lastPriorityCallback.next = entry;
        if (next == null)
          $._lastCallback = entry;
      }
    },
    scheduleMicrotask(callback) {
      var t1, _null = null,
        currentZone = $.Zone__current;
      if (C.C__RootZone === currentZone) {
        P._rootScheduleMicrotask(_null, _null, C.C__RootZone, callback);
        return;
      }
      if (C.C__RootZone === currentZone.get$_scheduleMicrotask().zone)
        t1 = C.C__RootZone.get$errorZone() === currentZone.get$errorZone();
      else
        t1 = false;
      if (t1) {
        P._rootScheduleMicrotask(_null, _null, currentZone, currentZone.registerCallback$1$1(callback, type$.void));
        return;
      }
      t1 = $.Zone__current;
      t1.scheduleMicrotask$1(t1.bindCallbackGuarded$1(callback));
    },
    Stream_Stream$fromFuture(future, $T) {
      var _null = null,
        t1 = $T._eval$1("_SyncStreamController<0>"),
        controller = new P._SyncStreamController(_null, _null, _null, _null, t1);
      future.then$1$2$onError(0, new P.Stream_Stream$fromFuture_closure(controller, $T), new P.Stream_Stream$fromFuture_closure0(controller), type$.Null);
      return new P._ControllerStream(controller, t1._eval$1("_ControllerStream<1>"));
    },
    StreamIterator_StreamIterator(stream) {
      return new P._StreamIterator(H.checkNotNullable(stream, "stream", type$.Object));
    },
    StreamController_StreamController(onCancel, onListen, onPause, onResume, sync, $T) {
      return sync ? new P._SyncStreamController(onListen, onPause, onResume, onCancel, $T._eval$1("_SyncStreamController<0>")) : new P._AsyncStreamController(onListen, onPause, onResume, onCancel, $T._eval$1("_AsyncStreamController<0>"));
    },
    _runGuarded(notificationHandler) {
      var e, s, exception;
      if (notificationHandler == null)
        return;
      try {
        notificationHandler.call$0();
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        $.Zone__current.handleUncaughtError$2(e, s);
      }
    },
    _ControllerSubscription$(_controller, onData, onError, onDone, cancelOnError, $T) {
      var t1 = $.Zone__current,
        t2 = cancelOnError ? 1 : 0,
        t3 = P._BufferingStreamSubscription__registerDataHandler(t1, onData, $T),
        t4 = P._BufferingStreamSubscription__registerErrorHandler(t1, onError),
        t5 = onDone == null ? P.async___nullDoneHandler$closure() : onDone;
      return new P._ControllerSubscription(_controller, t3, t4, t1.registerCallback$1$1(t5, type$.void), t1, t2, $T._eval$1("_ControllerSubscription<0>"));
    },
    _BufferingStreamSubscription__registerDataHandler(zone, handleData, $T) {
      var t1 = handleData == null ? P.async___nullDataHandler$closure() : handleData;
      return zone.registerUnaryCallback$2$1(t1, type$.void, $T);
    },
    _BufferingStreamSubscription__registerErrorHandler(zone, handleError) {
      if (handleError == null)
        handleError = P.async___nullErrorHandler$closure();
      if (type$.void_Function_Object_StackTrace._is(handleError))
        return zone.registerBinaryCallback$3$1(handleError, type$.dynamic, type$.Object, type$.StackTrace);
      if (type$.void_Function_Object._is(handleError))
        return zone.registerUnaryCallback$2$1(handleError, type$.dynamic, type$.Object);
      throw H.wrapException(P.ArgumentError$("handleError callback must take either an Object (the error), or both an Object (the error) and a StackTrace.", null));
    },
    _nullDataHandler(value) {
    },
    _nullErrorHandler(error, stackTrace) {
      $.Zone__current.handleUncaughtError$2(error, stackTrace);
    },
    _nullDoneHandler() {
    },
    Timer_Timer(duration, callback) {
      var t1 = $.Zone__current;
      if (t1 === C.C__RootZone)
        return t1.createTimer$2(duration, callback);
      return t1.createTimer$2(duration, t1.bindCallbackGuarded$1(callback));
    },
    _rootHandleUncaughtError($self, $parent, zone, error, stackTrace) {
      P._rootHandleError(error, stackTrace);
    },
    _rootHandleError(error, stackTrace) {
      P._schedulePriorityAsyncCallback(new P._rootHandleError_closure(error, stackTrace));
    },
    _rootRun($self, $parent, zone, f) {
      var old,
        t1 = $.Zone__current;
      if (t1 === zone)
        return f.call$0();
      $.Zone__current = zone;
      old = t1;
      try {
        t1 = f.call$0();
        return t1;
      } finally {
        $.Zone__current = old;
      }
    },
    _rootRunUnary($self, $parent, zone, f, arg) {
      var old,
        t1 = $.Zone__current;
      if (t1 === zone)
        return f.call$1(arg);
      $.Zone__current = zone;
      old = t1;
      try {
        t1 = f.call$1(arg);
        return t1;
      } finally {
        $.Zone__current = old;
      }
    },
    _rootRunBinary($self, $parent, zone, f, arg1, arg2) {
      var old,
        t1 = $.Zone__current;
      if (t1 === zone)
        return f.call$2(arg1, arg2);
      $.Zone__current = zone;
      old = t1;
      try {
        t1 = f.call$2(arg1, arg2);
        return t1;
      } finally {
        $.Zone__current = old;
      }
    },
    _rootRegisterCallback($self, $parent, zone, f) {
      return f;
    },
    _rootRegisterUnaryCallback($self, $parent, zone, f) {
      return f;
    },
    _rootRegisterBinaryCallback($self, $parent, zone, f) {
      return f;
    },
    _rootErrorCallback($self, $parent, zone, error, stackTrace) {
      return null;
    },
    _rootScheduleMicrotask($self, $parent, zone, f) {
      var t1, t2;
      if (C.C__RootZone !== zone) {
        t1 = C.C__RootZone.get$errorZone();
        t2 = zone.get$errorZone();
        f = t1 !== t2 ? zone.bindCallbackGuarded$1(f) : zone.bindCallback$1$1(f, type$.void);
      }
      P._scheduleAsyncCallback(f);
    },
    _rootCreateTimer($self, $parent, zone, duration, callback) {
      return P.Timer__createTimer(duration, C.C__RootZone !== zone ? zone.bindCallback$1$1(callback, type$.void) : callback);
    },
    _rootCreatePeriodicTimer($self, $parent, zone, duration, callback) {
      var milliseconds;
      if (C.C__RootZone !== zone)
        callback = zone.bindUnaryCallback$2$1(callback, type$.void, type$.Timer);
      milliseconds = C.JSInt_methods._tdivFast$1(duration._duration, 1000);
      return P._TimerImpl$periodic(milliseconds < 0 ? 0 : milliseconds, callback);
    },
    _rootPrint($self, $parent, zone, line) {
      H.printString(line);
    },
    _printToZone(line) {
      $.Zone__current.print$1(line);
    },
    _rootFork($self, $parent, zone, specification, zoneValues) {
      var valueMap, t1, handleUncaughtError;
      $.printToZone = P.async___printToZone$closure();
      if (specification == null)
        specification = C._ZoneSpecification_ALf;
      if (zoneValues == null)
        valueMap = zone.get$_async$_map();
      else {
        t1 = type$.nullable_Object;
        valueMap = P.HashMap_HashMap$from(zoneValues, t1, t1);
      }
      t1 = new P._CustomZone(zone.get$_run(), zone.get$_runUnary(), zone.get$_runBinary(), zone.get$_registerCallback(), zone.get$_registerUnaryCallback(), zone.get$_registerBinaryCallback(), zone.get$_errorCallback(), zone.get$_scheduleMicrotask(), zone.get$_createTimer(), zone.get$_createPeriodicTimer(), zone.get$_print(), zone.get$_fork(), zone.get$_handleUncaughtError(), zone, valueMap);
      handleUncaughtError = specification.handleUncaughtError;
      if (handleUncaughtError != null)
        t1._handleUncaughtError = new P._ZoneFunction(t1, handleUncaughtError);
      return t1;
    },
    runZoned(body, zoneValues, $R) {
      H.checkNotNullable(body, "body", $R._eval$1("0()"));
      return P._runZoned(body, zoneValues, null, $R);
    },
    _runZoned(body, zoneValues, specification, $R) {
      return $.Zone__current.fork$2$specification$zoneValues(specification, zoneValues).run$1$1(0, body, $R);
    },
    _AsyncRun__initializeScheduleImmediate_internalCallback: function _AsyncRun__initializeScheduleImmediate_internalCallback(t0) {
      this._box_0 = t0;
    },
    _AsyncRun__initializeScheduleImmediate_closure: function _AsyncRun__initializeScheduleImmediate_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.div = t1;
      this.span = t2;
    },
    _AsyncRun__scheduleImmediateJsOverride_internalCallback: function _AsyncRun__scheduleImmediateJsOverride_internalCallback(t0) {
      this.callback = t0;
    },
    _AsyncRun__scheduleImmediateWithSetImmediate_internalCallback: function _AsyncRun__scheduleImmediateWithSetImmediate_internalCallback(t0) {
      this.callback = t0;
    },
    _TimerImpl: function _TimerImpl(t0) {
      this._once = t0;
      this._handle = null;
      this._tick = 0;
    },
    _TimerImpl_internalCallback: function _TimerImpl_internalCallback(t0, t1) {
      this.$this = t0;
      this.callback = t1;
    },
    _TimerImpl$periodic_closure: function _TimerImpl$periodic_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.milliseconds = t1;
      _.start = t2;
      _.callback = t3;
    },
    _AsyncAwaitCompleter: function _AsyncAwaitCompleter(t0, t1) {
      this._future = t0;
      this.isSync = false;
      this.$ti = t1;
    },
    _awaitOnObject_closure: function _awaitOnObject_closure(t0) {
      this.bodyFunction = t0;
    },
    _awaitOnObject_closure0: function _awaitOnObject_closure0(t0) {
      this.bodyFunction = t0;
    },
    _wrapJsFunctionForAsync_closure: function _wrapJsFunctionForAsync_closure(t0) {
      this.$protected = t0;
    },
    _IterationMarker: function _IterationMarker(t0, t1) {
      this.value = t0;
      this.state = t1;
    },
    _SyncStarIterator: function _SyncStarIterator(t0) {
      var _ = this;
      _._body = t0;
      _._suspendedBodies = _._nestedIterator = _._async$_current = null;
    },
    _SyncStarIterable: function _SyncStarIterable(t0, t1) {
      this._outerHelper = t0;
      this.$ti = t1;
    },
    AsyncError: function AsyncError(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
    },
    Future_wait_handleError: function Future_wait_handleError(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.cleanUp = t1;
      _.eagerError = t2;
      _._future = t3;
      _.error = t4;
      _.stackTrace = t5;
    },
    Future_wait_closure: function Future_wait_closure(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _._box_0 = t0;
      _.pos = t1;
      _._future = t2;
      _.cleanUp = t3;
      _.eagerError = t4;
      _.error = t5;
      _.stackTrace = t6;
      _.T = t7;
    },
    _Completer: function _Completer() {
    },
    _AsyncCompleter: function _AsyncCompleter(t0, t1) {
      this.future = t0;
      this.$ti = t1;
    },
    _FutureListener: function _FutureListener(t0, t1, t2, t3, t4) {
      var _ = this;
      _._nextListener = null;
      _.result = t0;
      _.state = t1;
      _.callback = t2;
      _.errorCallback = t3;
      _.$ti = t4;
    },
    _Future: function _Future(t0, t1) {
      var _ = this;
      _._state = 0;
      _._zone = t0;
      _._resultOrListeners = null;
      _.$ti = t1;
    },
    _Future__addListener_closure: function _Future__addListener_closure(t0, t1) {
      this.$this = t0;
      this.listener = t1;
    },
    _Future__prependListeners_closure: function _Future__prependListeners_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _Future__chainForeignFuture_closure: function _Future__chainForeignFuture_closure(t0) {
      this.$this = t0;
    },
    _Future__chainForeignFuture_closure0: function _Future__chainForeignFuture_closure0(t0) {
      this.$this = t0;
    },
    _Future__chainForeignFuture_closure1: function _Future__chainForeignFuture_closure1(t0, t1, t2) {
      this.$this = t0;
      this.e = t1;
      this.s = t2;
    },
    _Future__asyncCompleteWithValue_closure: function _Future__asyncCompleteWithValue_closure(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _Future__chainFuture_closure: function _Future__chainFuture_closure(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _Future__asyncCompleteError_closure: function _Future__asyncCompleteError_closure(t0, t1, t2) {
      this.$this = t0;
      this.error = t1;
      this.stackTrace = t2;
    },
    _Future__propagateToListeners_handleWhenCompleteCallback: function _Future__propagateToListeners_handleWhenCompleteCallback(t0, t1, t2) {
      this._box_0 = t0;
      this._box_1 = t1;
      this.hasError = t2;
    },
    _Future__propagateToListeners_handleWhenCompleteCallback_closure: function _Future__propagateToListeners_handleWhenCompleteCallback_closure(t0) {
      this.originalSource = t0;
    },
    _Future__propagateToListeners_handleValueCallback: function _Future__propagateToListeners_handleValueCallback(t0, t1) {
      this._box_0 = t0;
      this.sourceResult = t1;
    },
    _Future__propagateToListeners_handleError: function _Future__propagateToListeners_handleError(t0, t1) {
      this._box_1 = t0;
      this._box_0 = t1;
    },
    _AsyncCallbackEntry: function _AsyncCallbackEntry(t0) {
      this.callback = t0;
      this.next = null;
    },
    Stream: function Stream() {
    },
    Stream_Stream$fromFuture_closure: function Stream_Stream$fromFuture_closure(t0, t1) {
      this.controller = t0;
      this.T = t1;
    },
    Stream_Stream$fromFuture_closure0: function Stream_Stream$fromFuture_closure0(t0) {
      this.controller = t0;
    },
    Stream_length_closure: function Stream_length_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    Stream_length_closure0: function Stream_length_closure0(t0, t1) {
      this._box_0 = t0;
      this.future = t1;
    },
    StreamTransformerBase: function StreamTransformerBase() {
    },
    _StreamController: function _StreamController() {
    },
    _StreamController__subscribe_closure: function _StreamController__subscribe_closure(t0) {
      this.$this = t0;
    },
    _StreamController__recordCancel_complete: function _StreamController__recordCancel_complete(t0) {
      this.$this = t0;
    },
    _SyncStreamControllerDispatch: function _SyncStreamControllerDispatch() {
    },
    _AsyncStreamControllerDispatch: function _AsyncStreamControllerDispatch() {
    },
    _AsyncStreamController: function _AsyncStreamController(t0, t1, t2, t3, t4) {
      var _ = this;
      _._varData = null;
      _._state = 0;
      _._doneFuture = null;
      _.onListen = t0;
      _.onPause = t1;
      _.onResume = t2;
      _.onCancel = t3;
      _.$ti = t4;
    },
    _SyncStreamController: function _SyncStreamController(t0, t1, t2, t3, t4) {
      var _ = this;
      _._varData = null;
      _._state = 0;
      _._doneFuture = null;
      _.onListen = t0;
      _.onPause = t1;
      _.onResume = t2;
      _.onCancel = t3;
      _.$ti = t4;
    },
    _ControllerStream: function _ControllerStream(t0, t1) {
      this._controller = t0;
      this.$ti = t1;
    },
    _ControllerSubscription: function _ControllerSubscription(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._controller = t0;
      _._onData = t1;
      _._onError = t2;
      _._onDone = t3;
      _._zone = t4;
      _._state = t5;
      _._pending = _._cancelFuture = null;
      _.$ti = t6;
    },
    _AddStreamState: function _AddStreamState() {
    },
    _AddStreamState_cancel_closure: function _AddStreamState_cancel_closure(t0) {
      this.$this = t0;
    },
    _StreamControllerAddStreamState: function _StreamControllerAddStreamState(t0, t1, t2) {
      this.varData = t0;
      this.addStreamFuture = t1;
      this.addSubscription = t2;
    },
    _BufferingStreamSubscription: function _BufferingStreamSubscription() {
    },
    _BufferingStreamSubscription__sendError_sendError: function _BufferingStreamSubscription__sendError_sendError(t0, t1, t2) {
      this.$this = t0;
      this.error = t1;
      this.stackTrace = t2;
    },
    _BufferingStreamSubscription__sendDone_sendDone: function _BufferingStreamSubscription__sendDone_sendDone(t0) {
      this.$this = t0;
    },
    _StreamImpl: function _StreamImpl() {
    },
    _DelayedEvent: function _DelayedEvent() {
    },
    _DelayedData: function _DelayedData(t0) {
      this.value = t0;
      this.next = null;
    },
    _DelayedError: function _DelayedError(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
      this.next = null;
    },
    _DelayedDone: function _DelayedDone() {
    },
    _PendingEvents: function _PendingEvents() {
    },
    _PendingEvents_schedule_closure: function _PendingEvents_schedule_closure(t0, t1) {
      this.$this = t0;
      this.dispatch = t1;
    },
    _StreamImplEvents: function _StreamImplEvents() {
      this.lastPendingEvent = this.firstPendingEvent = null;
      this._state = 0;
    },
    _StreamIterator: function _StreamIterator(t0) {
      this._subscription = null;
      this._stateData = t0;
      this._async$_hasValue = false;
    },
    _ForwardingStream: function _ForwardingStream() {
    },
    _ForwardingStreamSubscription: function _ForwardingStreamSubscription(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._stream = t0;
      _._subscription = null;
      _._onData = t1;
      _._onError = t2;
      _._onDone = t3;
      _._zone = t4;
      _._state = t5;
      _._pending = _._cancelFuture = null;
      _.$ti = t6;
    },
    _ExpandStream: function _ExpandStream(t0, t1, t2) {
      this._expand = t0;
      this._async$_source = t1;
      this.$ti = t2;
    },
    _ZoneFunction: function _ZoneFunction(t0, t1) {
      this.zone = t0;
      this.$function = t1;
    },
    _RunNullaryZoneFunction: function _RunNullaryZoneFunction(t0, t1) {
      this.zone = t0;
      this.$function = t1;
    },
    _RunUnaryZoneFunction: function _RunUnaryZoneFunction(t0, t1) {
      this.zone = t0;
      this.$function = t1;
    },
    _RunBinaryZoneFunction: function _RunBinaryZoneFunction(t0, t1) {
      this.zone = t0;
      this.$function = t1;
    },
    _RegisterNullaryZoneFunction: function _RegisterNullaryZoneFunction(t0, t1) {
      this.zone = t0;
      this.$function = t1;
    },
    _RegisterUnaryZoneFunction: function _RegisterUnaryZoneFunction(t0, t1) {
      this.zone = t0;
      this.$function = t1;
    },
    _RegisterBinaryZoneFunction: function _RegisterBinaryZoneFunction(t0, t1) {
      this.zone = t0;
      this.$function = t1;
    },
    _ZoneSpecification: function _ZoneSpecification(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12) {
      var _ = this;
      _.handleUncaughtError = t0;
      _.run = t1;
      _.runUnary = t2;
      _.runBinary = t3;
      _.registerCallback = t4;
      _.registerUnaryCallback = t5;
      _.registerBinaryCallback = t6;
      _.errorCallback = t7;
      _.scheduleMicrotask = t8;
      _.createTimer = t9;
      _.createPeriodicTimer = t10;
      _.print = t11;
      _.fork = t12;
    },
    _ZoneDelegate: function _ZoneDelegate(t0) {
      this._delegationTarget = t0;
    },
    _Zone: function _Zone() {
    },
    _CustomZone: function _CustomZone(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._run = t0;
      _._runUnary = t1;
      _._runBinary = t2;
      _._registerCallback = t3;
      _._registerUnaryCallback = t4;
      _._registerBinaryCallback = t5;
      _._errorCallback = t6;
      _._scheduleMicrotask = t7;
      _._createTimer = t8;
      _._createPeriodicTimer = t9;
      _._print = t10;
      _._fork = t11;
      _._handleUncaughtError = t12;
      _._delegateCache = null;
      _.parent = t13;
      _._async$_map = t14;
    },
    _CustomZone_bindCallback_closure: function _CustomZone_bindCallback_closure(t0, t1, t2) {
      this.$this = t0;
      this.registered = t1;
      this.R = t2;
    },
    _CustomZone_bindUnaryCallback_closure: function _CustomZone_bindUnaryCallback_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.registered = t1;
      _.T = t2;
      _.R = t3;
    },
    _CustomZone_bindCallbackGuarded_closure: function _CustomZone_bindCallbackGuarded_closure(t0, t1) {
      this.$this = t0;
      this.registered = t1;
    },
    _rootHandleError_closure: function _rootHandleError_closure(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
    },
    _RootZone: function _RootZone() {
    },
    _RootZone_bindCallback_closure: function _RootZone_bindCallback_closure(t0, t1, t2) {
      this.$this = t0;
      this.f = t1;
      this.R = t2;
    },
    _RootZone_bindUnaryCallback_closure: function _RootZone_bindUnaryCallback_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.f = t1;
      _.T = t2;
      _.R = t3;
    },
    _RootZone_bindCallbackGuarded_closure: function _RootZone_bindCallbackGuarded_closure(t0, t1) {
      this.$this = t0;
      this.f = t1;
    },
    HashMap_HashMap($K, $V) {
      return new P._HashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("_HashMap<1,2>"));
    },
    _HashMap__getTableEntry(table, key) {
      var entry = table[key];
      return entry === table ? null : entry;
    },
    _HashMap__setTableEntry(table, key, value) {
      if (value == null)
        table[key] = table;
      else
        table[key] = value;
    },
    _HashMap__newHashTable() {
      var table = Object.create(null);
      P._HashMap__setTableEntry(table, "<non-identifier-key>", table);
      delete table["<non-identifier-key>"];
      return table;
    },
    LinkedHashMap_LinkedHashMap(equals, hashCode, isValidKey, $K, $V) {
      if (isValidKey == null)
        if (hashCode == null) {
          if (equals == null)
            return new H.JsLinkedHashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("JsLinkedHashMap<1,2>"));
          hashCode = P.collection___defaultHashCode$closure();
        } else {
          if (P.core__identityHashCode$closure() === hashCode && P.core__identical$closure() === equals)
            return P._LinkedIdentityHashMap__LinkedIdentityHashMap$es6($K, $V);
          if (equals == null)
            equals = P.collection___defaultEquals$closure();
        }
      else {
        if (hashCode == null)
          hashCode = P.collection___defaultHashCode$closure();
        if (equals == null)
          equals = P.collection___defaultEquals$closure();
      }
      return P._LinkedCustomHashMap$(equals, hashCode, isValidKey, $K, $V);
    },
    LinkedHashMap_LinkedHashMap$_literal(keyValuePairs, $K, $V) {
      return H.fillLiteralMap(keyValuePairs, new H.JsLinkedHashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("JsLinkedHashMap<1,2>")));
    },
    LinkedHashMap_LinkedHashMap$_empty($K, $V) {
      return new H.JsLinkedHashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("JsLinkedHashMap<1,2>"));
    },
    _LinkedIdentityHashMap__LinkedIdentityHashMap$es6($K, $V) {
      return new P._LinkedIdentityHashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("_LinkedIdentityHashMap<1,2>"));
    },
    _LinkedCustomHashMap$(_equals, _hashCode, validKey, $K, $V) {
      var t1 = validKey != null ? validKey : new P._LinkedCustomHashMap_closure($K);
      return new P._LinkedCustomHashMap(_equals, _hashCode, t1, $K._eval$1("@<0>")._bind$1($V)._eval$1("_LinkedCustomHashMap<1,2>"));
    },
    LinkedHashSet_LinkedHashSet($E) {
      return new P._LinkedHashSet($E._eval$1("_LinkedHashSet<0>"));
    },
    LinkedHashSet_LinkedHashSet$_empty($E) {
      return new P._LinkedHashSet($E._eval$1("_LinkedHashSet<0>"));
    },
    LinkedHashSet_LinkedHashSet$_literal(values, $E) {
      return H.fillLiteralSet(values, new P._LinkedHashSet($E._eval$1("_LinkedHashSet<0>")));
    },
    _LinkedHashSet__newHashTable() {
      var table = Object.create(null);
      table["<non-identifier-key>"] = table;
      delete table["<non-identifier-key>"];
      return table;
    },
    _LinkedHashSetIterator$(_set, _modifications) {
      var t1 = new P._LinkedHashSetIterator(_set, _modifications);
      t1._collection$_cell = _set._collection$_first;
      return t1;
    },
    UnmodifiableListView$(source, $E) {
      return new P.UnmodifiableListView(source, $E._eval$1("UnmodifiableListView<0>"));
    },
    _defaultEquals(a, b) {
      return J.$eq$(a, b);
    },
    _defaultHashCode(a) {
      return J.get$hashCode$(a);
    },
    HashMap_HashMap$from(other, $K, $V) {
      var result = P.HashMap_HashMap($K, $V);
      other.forEach$1(0, new P.HashMap_HashMap$from_closure(result, $K, $V));
      return result;
    },
    IterableBase_iterableToShortString(iterable, leftDelimiter, rightDelimiter) {
      var parts, t1;
      if (P._isToStringVisiting(iterable)) {
        if (leftDelimiter === "(" && rightDelimiter === ")")
          return "(...)";
        return leftDelimiter + "..." + rightDelimiter;
      }
      parts = H._setArrayType([], type$.JSArray_String);
      $._toStringVisiting.push(iterable);
      try {
        P._iterablePartsToStrings(iterable, parts);
      } finally {
        $._toStringVisiting.pop();
      }
      t1 = P.StringBuffer__writeAll(leftDelimiter, parts, ", ") + rightDelimiter;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    IterableBase_iterableToFullString(iterable, leftDelimiter, rightDelimiter) {
      var buffer, t1;
      if (P._isToStringVisiting(iterable))
        return leftDelimiter + "..." + rightDelimiter;
      buffer = new P.StringBuffer(leftDelimiter);
      $._toStringVisiting.push(iterable);
      try {
        t1 = buffer;
        t1._contents = P.StringBuffer__writeAll(t1._contents, iterable, ", ");
      } finally {
        $._toStringVisiting.pop();
      }
      buffer._contents += rightDelimiter;
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _isToStringVisiting(o) {
      var t1, i;
      for (t1 = $._toStringVisiting.length, i = 0; i < t1; ++i)
        if (o === $._toStringVisiting[i])
          return true;
      return false;
    },
    _iterablePartsToStrings(iterable, parts) {
      var next, ultimateString, penultimateString, penultimate, ultimate, ultimate0, elision,
        it = iterable.get$iterator(iterable),
        $length = 0, count = 0;
      while (true) {
        if (!($length < 80 || count < 3))
          break;
        if (!it.moveNext$0())
          return;
        next = H.S(it.get$current(it));
        parts.push(next);
        $length += next.length + 2;
        ++count;
      }
      if (!it.moveNext$0()) {
        if (count <= 5)
          return;
        ultimateString = parts.pop();
        penultimateString = parts.pop();
      } else {
        penultimate = it.get$current(it);
        ++count;
        if (!it.moveNext$0()) {
          if (count <= 4) {
            parts.push(H.S(penultimate));
            return;
          }
          ultimateString = H.S(penultimate);
          penultimateString = parts.pop();
          $length += ultimateString.length + 2;
        } else {
          ultimate = it.get$current(it);
          ++count;
          for (; it.moveNext$0(); penultimate = ultimate, ultimate = ultimate0) {
            ultimate0 = it.get$current(it);
            ++count;
            if (count > 100) {
              while (true) {
                if (!($length > 75 && count > 3))
                  break;
                $length -= parts.pop().length + 2;
                --count;
              }
              parts.push("...");
              return;
            }
          }
          penultimateString = H.S(penultimate);
          ultimateString = H.S(ultimate);
          $length += ultimateString.length + penultimateString.length + 4;
        }
      }
      if (count > parts.length + 2) {
        $length += 5;
        elision = "...";
      } else
        elision = null;
      while (true) {
        if (!($length > 80 && parts.length > 3))
          break;
        $length -= parts.pop().length + 2;
        if (elision == null) {
          $length += 5;
          elision = "...";
        }
      }
      if (elision != null)
        parts.push(elision);
      parts.push(penultimateString);
      parts.push(ultimateString);
    },
    LinkedHashMap_LinkedHashMap$from(other, $K, $V) {
      var result = P.LinkedHashMap_LinkedHashMap(null, null, null, $K, $V);
      other.forEach$1(0, new P.LinkedHashMap_LinkedHashMap$from_closure(result, $K, $V));
      return result;
    },
    LinkedHashMap_LinkedHashMap$of(other, $K, $V) {
      var t1 = P.LinkedHashMap_LinkedHashMap(null, null, null, $K, $V);
      t1.addAll$1(0, other);
      return t1;
    },
    LinkedHashSet_LinkedHashSet$from(elements, $E) {
      var t1, _i,
        result = P.LinkedHashSet_LinkedHashSet($E);
      for (t1 = elements.length, _i = 0; _i < elements.length; elements.length === t1 || (0, H.throwConcurrentModificationError)(elements), ++_i)
        result.add$1(0, $E._as(elements[_i]));
      return result;
    },
    LinkedHashSet_LinkedHashSet$of(elements, $E) {
      var t1 = P.LinkedHashSet_LinkedHashSet($E);
      t1.addAll$1(0, elements);
      return t1;
    },
    ListMixin__compareAny(a, b) {
      var t1 = type$.Comparable_dynamic;
      return J.compareTo$1$ns(t1._as(a), t1._as(b));
    },
    MapBase_mapToString(m) {
      var result, t1 = {};
      if (P._isToStringVisiting(m))
        return "{...}";
      result = new P.StringBuffer("");
      try {
        $._toStringVisiting.push(m);
        result._contents += "{";
        t1.first = true;
        m.forEach$1(0, new P.MapBase_mapToString_closure(t1, result));
        result._contents += "}";
      } finally {
        $._toStringVisiting.pop();
      }
      t1 = result._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    MapBase__fillMapWithIterables(map, keys, values) {
      var keyIterator = keys.get$iterator(keys),
        valueIterator = values.get$iterator(values),
        hasNextKey = keyIterator.moveNext$0(),
        hasNextValue = valueIterator.moveNext$0();
      while (true) {
        if (!(hasNextKey && hasNextValue))
          break;
        map.$indexSet(0, keyIterator.get$current(keyIterator), valueIterator.get$current(valueIterator));
        hasNextKey = keyIterator.moveNext$0();
        hasNextValue = valueIterator.moveNext$0();
      }
      if (hasNextKey || hasNextValue)
        throw H.wrapException(P.ArgumentError$("Iterables do not have same length.", null));
    },
    ListQueue$($E) {
      return new P.ListQueue(P.List_List$filled(P.ListQueue__calculateCapacity(null), null, false, $E._eval$1("0?")), $E._eval$1("ListQueue<0>"));
    },
    ListQueue__calculateCapacity(initialCapacity) {
      return 8;
    },
    ListQueue_ListQueue$of(elements, $E) {
      var t1 = P.ListQueue$($E);
      t1.addAll$1(0, elements);
      return t1;
    },
    ListQueue__nextPowerOf2(number) {
      var nextNumber;
      number = (number << 1 >>> 0) - 1;
      for (; true; number = nextNumber) {
        nextNumber = (number & number - 1) >>> 0;
        if (nextNumber === 0)
          return number;
      }
    },
    _ListQueueIterator$(queue) {
      return new P._ListQueueIterator(queue, queue._collection$_tail, queue._modificationCount, queue._collection$_head);
    },
    _UnmodifiableSetMixin__throwUnmodifiable() {
      throw H.wrapException(P.UnsupportedError$("Cannot change an unmodifiable set"));
    },
    _HashMap: function _HashMap(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._keys = _._collection$_rest = _._collection$_nums = _._collection$_strings = null;
      _.$ti = t0;
    },
    _HashMap_values_closure: function _HashMap_values_closure(t0) {
      this.$this = t0;
    },
    _HashMap_addAll_closure: function _HashMap_addAll_closure(t0) {
      this.$this = t0;
    },
    _HashMapKeyIterable: function _HashMapKeyIterable(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    _HashMapKeyIterator: function _HashMapKeyIterator(t0, t1) {
      var _ = this;
      _._map = t0;
      _._keys = t1;
      _._offset = 0;
      _._collection$_current = null;
    },
    _LinkedIdentityHashMap: function _LinkedIdentityHashMap(t0) {
      var _ = this;
      _.__js_helper$_length = 0;
      _._last = _._first = _.__js_helper$_rest = _._nums = _._strings = null;
      _._modifications = 0;
      _.$ti = t0;
    },
    _LinkedCustomHashMap: function _LinkedCustomHashMap(t0, t1, t2, t3) {
      var _ = this;
      _._equals = t0;
      _._hashCode = t1;
      _._validKey = t2;
      _.__js_helper$_length = 0;
      _._last = _._first = _.__js_helper$_rest = _._nums = _._strings = null;
      _._modifications = 0;
      _.$ti = t3;
    },
    _LinkedCustomHashMap_closure: function _LinkedCustomHashMap_closure(t0) {
      this.K = t0;
    },
    _LinkedHashSet: function _LinkedHashSet(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._collection$_last = _._collection$_first = _._collection$_rest = _._collection$_nums = _._collection$_strings = null;
      _._collection$_modifications = 0;
      _.$ti = t0;
    },
    _LinkedIdentityHashSet: function _LinkedIdentityHashSet(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._collection$_last = _._collection$_first = _._collection$_rest = _._collection$_nums = _._collection$_strings = null;
      _._collection$_modifications = 0;
      _.$ti = t0;
    },
    _LinkedHashSetCell: function _LinkedHashSetCell(t0) {
      this._element = t0;
      this._collection$_previous = this._collection$_next = null;
    },
    _LinkedHashSetIterator: function _LinkedHashSetIterator(t0, t1) {
      var _ = this;
      _._set = t0;
      _._collection$_modifications = t1;
      _._collection$_current = _._collection$_cell = null;
    },
    UnmodifiableListView: function UnmodifiableListView(t0, t1) {
      this._collection$_source = t0;
      this.$ti = t1;
    },
    HashMap_HashMap$from_closure: function HashMap_HashMap$from_closure(t0, t1, t2) {
      this.result = t0;
      this.K = t1;
      this.V = t2;
    },
    IterableBase: function IterableBase() {
    },
    LinkedHashMap_LinkedHashMap$from_closure: function LinkedHashMap_LinkedHashMap$from_closure(t0, t1, t2) {
      this.result = t0;
      this.K = t1;
      this.V = t2;
    },
    ListBase: function ListBase() {
    },
    ListMixin: function ListMixin() {
    },
    MapBase: function MapBase() {
    },
    MapBase_mapToString_closure: function MapBase_mapToString_closure(t0, t1) {
      this._box_0 = t0;
      this.result = t1;
    },
    MapMixin: function MapMixin() {
    },
    MapMixin_entries_closure: function MapMixin_entries_closure(t0) {
      this.$this = t0;
    },
    UnmodifiableMapBase: function UnmodifiableMapBase() {
    },
    _MapBaseValueIterable: function _MapBaseValueIterable(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    _MapBaseValueIterator: function _MapBaseValueIterator(t0, t1) {
      this._keys = t0;
      this._map = t1;
      this._collection$_current = null;
    },
    _UnmodifiableMapMixin: function _UnmodifiableMapMixin() {
    },
    MapView: function MapView() {
    },
    UnmodifiableMapView: function UnmodifiableMapView(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    ListQueue: function ListQueue(t0, t1) {
      var _ = this;
      _._collection$_table = t0;
      _._modificationCount = _._collection$_tail = _._collection$_head = 0;
      _.$ti = t1;
    },
    _ListQueueIterator: function _ListQueueIterator(t0, t1, t2, t3) {
      var _ = this;
      _._queue = t0;
      _._collection$_end = t1;
      _._modificationCount = t2;
      _._collection$_position = t3;
      _._collection$_current = null;
    },
    SetMixin: function SetMixin() {
    },
    _SetBase: function _SetBase() {
    },
    _UnmodifiableSetMixin: function _UnmodifiableSetMixin() {
    },
    _UnmodifiableSet: function _UnmodifiableSet(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    _ListBase_Object_ListMixin: function _ListBase_Object_ListMixin() {
    },
    _UnmodifiableMapView_MapView__UnmodifiableMapMixin: function _UnmodifiableMapView_MapView__UnmodifiableMapMixin() {
    },
    __SetBase_Object_SetMixin: function __SetBase_Object_SetMixin() {
    },
    __UnmodifiableSet__SetBase__UnmodifiableSetMixin: function __UnmodifiableSet__SetBase__UnmodifiableSetMixin() {
    },
    Utf8Decoder__convertIntercepted(allowMalformed, codeUnits, start, end) {
      var casted, result;
      if (codeUnits instanceof Uint8Array) {
        casted = codeUnits;
        end = casted.length;
        if (end - start < 15)
          return null;
        result = P.Utf8Decoder__convertInterceptedUint8List(allowMalformed, casted, start, end);
        if (result != null && allowMalformed)
          if (result.indexOf("\ufffd") >= 0)
            return null;
        return result;
      }
      return null;
    },
    Utf8Decoder__convertInterceptedUint8List(allowMalformed, codeUnits, start, end) {
      var decoder = allowMalformed ? $.$get$Utf8Decoder__decoderNonfatal() : $.$get$Utf8Decoder__decoder();
      if (decoder == null)
        return null;
      if (0 === start && end === codeUnits.length)
        return P.Utf8Decoder__useTextDecoder(decoder, codeUnits);
      return P.Utf8Decoder__useTextDecoder(decoder, codeUnits.subarray(start, P.RangeError_checkValidRange(start, end, codeUnits.length)));
    },
    Utf8Decoder__useTextDecoder(decoder, codeUnits) {
      var t1, exception;
      try {
        t1 = decoder.decode(codeUnits);
        return t1;
      } catch (exception) {
        H.unwrapException(exception);
      }
      return null;
    },
    Base64Codec__checkPadding(source, sourceIndex, sourceEnd, firstPadding, paddingCount, $length) {
      if (C.JSInt_methods.$mod($length, 4) !== 0)
        throw H.wrapException(P.FormatException$("Invalid base64 padding, padded length must be multiple of four, is " + $length, source, sourceEnd));
      if (firstPadding + paddingCount !== $length)
        throw H.wrapException(P.FormatException$("Invalid base64 padding, '=' not at the end", source, sourceIndex));
      if (paddingCount > 2)
        throw H.wrapException(P.FormatException$("Invalid base64 padding, more than two '=' characters", source, sourceIndex));
    },
    _Base64Encoder_encodeChunk(alphabet, bytes, start, end, isLast, output, outputIndex, state) {
      var t1, i, byteOr, byte, outputIndex0, outputIndex1,
        bits = state >>> 2,
        expectedChars = 3 - (state & 3);
      for (t1 = J.getInterceptor$asx(bytes), i = start, byteOr = 0; i < end; ++i) {
        byte = t1.$index(bytes, i);
        byteOr = (byteOr | byte) >>> 0;
        bits = (bits << 8 | byte) & 16777215;
        --expectedChars;
        if (expectedChars === 0) {
          outputIndex0 = outputIndex + 1;
          output[outputIndex] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 18 & 63);
          outputIndex = outputIndex0 + 1;
          output[outputIndex0] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 12 & 63);
          outputIndex0 = outputIndex + 1;
          output[outputIndex] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 6 & 63);
          outputIndex = outputIndex0 + 1;
          output[outputIndex0] = C.JSString_methods._codeUnitAt$1(alphabet, bits & 63);
          bits = 0;
          expectedChars = 3;
        }
      }
      if (byteOr >= 0 && byteOr <= 255) {
        if (isLast && expectedChars < 3) {
          outputIndex0 = outputIndex + 1;
          outputIndex1 = outputIndex0 + 1;
          if (3 - expectedChars === 1) {
            output[outputIndex] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 2 & 63);
            output[outputIndex0] = C.JSString_methods._codeUnitAt$1(alphabet, bits << 4 & 63);
            output[outputIndex1] = 61;
            output[outputIndex1 + 1] = 61;
          } else {
            output[outputIndex] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 10 & 63);
            output[outputIndex0] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 4 & 63);
            output[outputIndex1] = C.JSString_methods._codeUnitAt$1(alphabet, bits << 2 & 63);
            output[outputIndex1 + 1] = 61;
          }
          return 0;
        }
        return (bits << 2 | 3 - expectedChars) >>> 0;
      }
      for (i = start; i < end;) {
        byte = t1.$index(bytes, i);
        if (byte < 0 || byte > 255)
          break;
        ++i;
      }
      throw H.wrapException(P.ArgumentError$value(bytes, "Not a byte value at index " + i + ": 0x" + J.toRadixString$1$n(t1.$index(bytes, i), 16), null));
    },
    JsonUnsupportedObjectError$(unsupportedObject, cause, partialResult) {
      return new P.JsonUnsupportedObjectError(unsupportedObject, cause);
    },
    _defaultToEncodable(object) {
      return object.toJson$0();
    },
    _JsonStringStringifier$(_sink, _toEncodable) {
      return new P._JsonStringStringifier(_sink, [], P.convert___defaultToEncodable$closure());
    },
    _JsonStringStringifier_stringify(object, toEncodable, indent) {
      var t1,
        output = new P.StringBuffer(""),
        stringifier = P._JsonStringStringifier$(output, toEncodable);
      stringifier.writeObject$1(object);
      t1 = output._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Utf8Decoder_errorDescription(state) {
      switch (state) {
        case 65:
          return "Missing extension byte";
        case 67:
          return "Unexpected extension byte";
        case 69:
          return "Invalid UTF-8 byte";
        case 71:
          return "Overlong encoding";
        case 73:
          return "Out of unicode range";
        case 75:
          return "Encoded surrogate";
        case 77:
          return "Unfinished UTF-8 octet sequence";
        default:
          return "";
      }
    },
    _Utf8Decoder__makeUint8List(codeUnits, start, end) {
      var t1, i, b,
        $length = end - start,
        bytes = new Uint8Array($length);
      for (t1 = J.getInterceptor$asx(codeUnits), i = 0; i < $length; ++i) {
        b = t1.$index(codeUnits, start + i);
        bytes[i] = (b & 4294967040) >>> 0 !== 0 ? 255 : b;
      }
      return bytes;
    },
    Utf8Decoder__decoder_closure: function Utf8Decoder__decoder_closure() {
    },
    Utf8Decoder__decoderNonfatal_closure: function Utf8Decoder__decoderNonfatal_closure() {
    },
    AsciiCodec: function AsciiCodec() {
    },
    _UnicodeSubsetEncoder: function _UnicodeSubsetEncoder() {
    },
    AsciiEncoder: function AsciiEncoder(t0) {
      this._subsetMask = t0;
    },
    Base64Codec: function Base64Codec() {
    },
    Base64Encoder: function Base64Encoder() {
    },
    _Base64Encoder: function _Base64Encoder(t0) {
      this._convert$_state = 0;
      this._alphabet = t0;
    },
    _Base64EncoderSink: function _Base64EncoderSink() {
    },
    _Utf8Base64EncoderSink: function _Utf8Base64EncoderSink(t0, t1) {
      this._sink = t0;
      this._encoder = t1;
    },
    ByteConversionSink: function ByteConversionSink() {
    },
    ByteConversionSinkBase: function ByteConversionSinkBase() {
    },
    ChunkedConversionSink: function ChunkedConversionSink() {
    },
    Codec: function Codec() {
    },
    Converter: function Converter() {
    },
    Encoding: function Encoding() {
    },
    JsonUnsupportedObjectError: function JsonUnsupportedObjectError(t0, t1) {
      this.unsupportedObject = t0;
      this.cause = t1;
    },
    JsonCyclicError: function JsonCyclicError(t0, t1) {
      this.unsupportedObject = t0;
      this.cause = t1;
    },
    JsonCodec: function JsonCodec() {
    },
    JsonEncoder: function JsonEncoder(t0) {
      this._toEncodable = t0;
    },
    _JsonStringifier: function _JsonStringifier() {
    },
    _JsonStringifier_writeMap_closure: function _JsonStringifier_writeMap_closure(t0, t1) {
      this._box_0 = t0;
      this.keyValueList = t1;
    },
    _JsonStringStringifier: function _JsonStringStringifier(t0, t1, t2) {
      this._sink = t0;
      this._seen = t1;
      this._toEncodable = t2;
    },
    StringConversionSinkBase: function StringConversionSinkBase() {
    },
    StringConversionSinkMixin: function StringConversionSinkMixin() {
    },
    _StringSinkConversionSink: function _StringSinkConversionSink(t0) {
      this._stringSink = t0;
    },
    _StringCallbackSink: function _StringCallbackSink(t0, t1) {
      this._convert$_callback = t0;
      this._stringSink = t1;
    },
    _Utf8StringSinkAdapter: function _Utf8StringSinkAdapter(t0, t1, t2) {
      this._decoder = t0;
      this._sink = t1;
      this._stringSink = t2;
    },
    Utf8Codec: function Utf8Codec() {
    },
    Utf8Encoder: function Utf8Encoder() {
    },
    _Utf8Encoder: function _Utf8Encoder(t0) {
      this._bufferIndex = 0;
      this._convert$_buffer = t0;
    },
    Utf8Decoder: function Utf8Decoder(t0) {
      this._allowMalformed = t0;
    },
    _Utf8Decoder: function _Utf8Decoder(t0) {
      this.allowMalformed = t0;
      this._convert$_state = 16;
      this._charOrIndex = 0;
    },
    identityHashCode(object) {
      return H.objectHashCode(object);
    },
    Function_apply($function, positionalArguments) {
      return H.Primitives_applyFunction($function, positionalArguments, null);
    },
    int_parse(source, radix) {
      var value = H.Primitives_parseInt(source, radix);
      if (value != null)
        return value;
      throw H.wrapException(P.FormatException$(source, null, null));
    },
    double_parse(source) {
      var value = H.Primitives_parseDouble(source);
      if (value != null)
        return value;
      throw H.wrapException(P.FormatException$("Invalid double", source, null));
    },
    Error__objectToString(object) {
      if (object instanceof H.Closure)
        return object.toString$0(0);
      return "Instance of '" + H.Primitives_objectTypeName(object) + "'";
    },
    List_List$filled($length, fill, growable, $E) {
      var i,
        result = growable ? J.JSArray_JSArray$growable($length, $E) : J.JSArray_JSArray$fixed($length, $E);
      if ($length !== 0 && fill != null)
        for (i = 0; i < result.length; ++i)
          result[i] = fill;
      return result;
    },
    List_List$from(elements, growable, $E) {
      var t1,
        list = H._setArrayType([], $E._eval$1("JSArray<0>"));
      for (t1 = J.get$iterator$ax(elements); t1.moveNext$0();)
        list.push(t1.get$current(t1));
      if (growable)
        return list;
      return J.JSArray_markFixedList(list);
    },
    List_List$of(elements, growable, $E) {
      var t1;
      if (growable)
        return P.List_List$_of(elements, $E);
      t1 = J.JSArray_markFixedList(P.List_List$_of(elements, $E));
      return t1;
    },
    List_List$_of(elements, $E) {
      var list, t1;
      if (Array.isArray(elements))
        return H._setArrayType(elements.slice(0), $E._eval$1("JSArray<0>"));
      list = H._setArrayType([], $E._eval$1("JSArray<0>"));
      for (t1 = J.get$iterator$ax(elements); t1.moveNext$0();)
        list.push(t1.get$current(t1));
      return list;
    },
    List_List$unmodifiable(elements, $E) {
      return J.JSArray_markUnmodifiableList(P.List_List$from(elements, false, $E));
    },
    String_String$fromCharCodes(charCodes, start, end) {
      var array, len;
      if (Array.isArray(charCodes)) {
        array = charCodes;
        len = array.length;
        end = P.RangeError_checkValidRange(start, end, len);
        return H.Primitives_stringFromCharCodes(start > 0 || end < len ? array.slice(start, end) : array);
      }
      if (type$.NativeUint8List._is(charCodes))
        return H.Primitives_stringFromNativeUint8List(charCodes, start, P.RangeError_checkValidRange(start, end, charCodes.length));
      return P.String__stringFromIterable(charCodes, start, end);
    },
    String_String$fromCharCode(charCode) {
      return H.Primitives_stringFromCharCode(charCode);
    },
    String__stringFromIterable(charCodes, start, end) {
      var t1, it, i, list, _null = null;
      if (start < 0)
        throw H.wrapException(P.RangeError$range(start, 0, J.get$length$asx(charCodes), _null, _null));
      t1 = end == null;
      if (!t1 && end < start)
        throw H.wrapException(P.RangeError$range(end, start, J.get$length$asx(charCodes), _null, _null));
      it = J.get$iterator$ax(charCodes);
      for (i = 0; i < start; ++i)
        if (!it.moveNext$0())
          throw H.wrapException(P.RangeError$range(start, 0, i, _null, _null));
      list = [];
      if (t1)
        for (; it.moveNext$0();)
          list.push(it.get$current(it));
      else
        for (i = start; i < end; ++i) {
          if (!it.moveNext$0())
            throw H.wrapException(P.RangeError$range(end, start, i, _null, _null));
          list.push(it.get$current(it));
        }
      return H.Primitives_stringFromCharCodes(list);
    },
    RegExp_RegExp(source, multiLine) {
      return new H.JSSyntaxRegExp(source, H.JSSyntaxRegExp_makeNative(source, multiLine, true, false, false, false));
    },
    identical(a, b) {
      return a == null ? b == null : a === b;
    },
    StringBuffer__writeAll(string, objects, separator) {
      var iterator = J.get$iterator$ax(objects);
      if (!iterator.moveNext$0())
        return string;
      if (separator.length === 0) {
        do
          string += H.S(iterator.get$current(iterator));
        while (iterator.moveNext$0());
      } else {
        string += H.S(iterator.get$current(iterator));
        for (; iterator.moveNext$0();)
          string = string + separator + H.S(iterator.get$current(iterator));
      }
      return string;
    },
    NoSuchMethodError$(receiver, memberName, positionalArguments, namedArguments) {
      return new P.NoSuchMethodError(receiver, memberName, positionalArguments, namedArguments);
    },
    Uri_base() {
      var uri = H.Primitives_currentUri();
      if (uri != null)
        return P.Uri_parse(uri);
      throw H.wrapException(P.UnsupportedError$("'Uri.base' is not supported"));
    },
    _Uri__uriEncode(canonicalTable, text, encoding, spaceToPlus) {
      var t1, bytes, i, t2, byte,
        _s16_ = "0123456789ABCDEF";
      if (encoding === C.C_Utf8Codec) {
        t1 = $.$get$_Uri__needsNoEncoding()._nativeRegExp;
        t1 = t1.test(text);
      } else
        t1 = false;
      if (t1)
        return text;
      bytes = encoding.get$encoder().convert$1(text);
      for (t1 = bytes.length, i = 0, t2 = ""; i < t1; ++i) {
        byte = bytes[i];
        if (byte < 128 && (canonicalTable[byte >>> 4] & 1 << (byte & 15)) !== 0)
          t2 += H.Primitives_stringFromCharCode(byte);
        else
          t2 = spaceToPlus && byte === 32 ? t2 + "+" : t2 + "%" + _s16_[byte >>> 4 & 15] + _s16_[byte & 15];
      }
      return t2.charCodeAt(0) == 0 ? t2 : t2;
    },
    StackTrace_current() {
      var stackTrace, exception;
      if ($.$get$_hasErrorStackProperty())
        return H.getTraceFromException(new Error());
      try {
        throw H.wrapException("");
      } catch (exception) {
        H.unwrapException(exception);
        stackTrace = H.getTraceFromException(exception);
        return stackTrace;
      }
    },
    DateTime$_withValue(_value, isUtc) {
      var t1;
      if (Math.abs(_value) <= 864e13)
        t1 = false;
      else
        t1 = true;
      if (t1)
        H.throwExpression(P.ArgumentError$("DateTime is outside valid range: " + _value, null));
      H.checkNotNullable(false, "isUtc", type$.bool);
      return new P.DateTime(_value, false);
    },
    DateTime__fourDigits(n) {
      var absN = Math.abs(n),
        sign = n < 0 ? "-" : "";
      if (absN >= 1000)
        return "" + n;
      if (absN >= 100)
        return sign + "0" + absN;
      if (absN >= 10)
        return sign + "00" + absN;
      return sign + "000" + absN;
    },
    DateTime__threeDigits(n) {
      if (n >= 100)
        return "" + n;
      if (n >= 10)
        return "0" + n;
      return "00" + n;
    },
    DateTime__twoDigits(n) {
      if (n >= 10)
        return "" + n;
      return "0" + n;
    },
    Duration$(milliseconds) {
      return new P.Duration(1000 * milliseconds);
    },
    Error_safeToString(object) {
      if (typeof object == "number" || H._isBool(object) || object == null)
        return J.toString$0$(object);
      if (typeof object == "string")
        return JSON.stringify(object);
      return P.Error__objectToString(object);
    },
    AssertionError$(message) {
      return new P.AssertionError(message);
    },
    ArgumentError$(message, $name) {
      return new P.ArgumentError(false, null, $name, message);
    },
    ArgumentError$value(value, $name, message) {
      return new P.ArgumentError(true, value, $name, message);
    },
    RangeError$(message) {
      var _null = null;
      return new P.RangeError(_null, _null, false, _null, _null, message);
    },
    RangeError$value(value, $name, message) {
      return new P.RangeError(null, null, true, value, $name, message == null ? "Value not in range" : message);
    },
    RangeError$range(invalidValue, minValue, maxValue, $name, message) {
      return new P.RangeError(minValue, maxValue, true, invalidValue, $name, message == null ? "Invalid value" : message);
    },
    RangeError_checkValueInInterval(value, minValue, maxValue, $name) {
      if (value < minValue || value > maxValue)
        throw H.wrapException(P.RangeError$range(value, minValue, maxValue, $name, null));
      return value;
    },
    RangeError_checkValidIndex(index, indexable, $name) {
      var $length = indexable.get$length(indexable);
      if (0 > index || index >= $length)
        throw H.wrapException(P.IndexError$(index, indexable, $name == null ? "index" : $name, null, $length));
      return index;
    },
    RangeError_checkValidRange(start, end, $length) {
      if (0 > start || start > $length)
        throw H.wrapException(P.RangeError$range(start, 0, $length, "start", null));
      if (end != null) {
        if (start > end || end > $length)
          throw H.wrapException(P.RangeError$range(end, start, $length, "end", null));
        return end;
      }
      return $length;
    },
    RangeError_checkNotNegative(value, $name) {
      if (value < 0)
        throw H.wrapException(P.RangeError$range(value, 0, null, $name, null));
      return value;
    },
    IndexError$(invalidValue, indexable, $name, message, $length) {
      var t1 = $length == null ? J.get$length$asx(indexable) : $length;
      return new P.IndexError(t1, true, invalidValue, $name, "Index out of range");
    },
    UnsupportedError$(message) {
      return new P.UnsupportedError(message);
    },
    UnimplementedError$(message) {
      return new P.UnimplementedError(message);
    },
    StateError$(message) {
      return new P.StateError(message);
    },
    ConcurrentModificationError$(modifiedObject) {
      return new P.ConcurrentModificationError(modifiedObject);
    },
    FormatException$(message, source, offset) {
      return new P.FormatException(message, source, offset);
    },
    Iterable_Iterable$generate(count, generator, $E) {
      if (count <= 0)
        return new H.EmptyIterable($E._eval$1("EmptyIterable<0>"));
      return new P._GeneratorIterable(count, generator, $E._eval$1("_GeneratorIterable<0>"));
    },
    Map_castFrom(source, $K, $V, K2, V2) {
      return new H.CastMap(source, $K._eval$1("@<0>")._bind$1($V)._bind$1(K2)._bind$1(V2)._eval$1("CastMap<1,2,3,4>"));
    },
    print(object) {
      var line = J.toString$0$(object),
        toZone = $.printToZone;
      if (toZone == null)
        H.printString(line);
      else
        toZone.call$1(line);
    },
    Set_castFrom(source, newSet, $S, $T) {
      return new H.CastSet(source, newSet, $S._eval$1("@<0>")._bind$1($T)._eval$1("CastSet<1,2>"));
    },
    _combineSurrogatePair(start, end) {
      return 65536 + ((start & 1023) << 10) + (end & 1023);
    },
    Uri_Uri$dataFromString($content, encoding, mimeType) {
      var encodingName, t1,
        buffer = new P.StringBuffer(""),
        indices = H._setArrayType([-1], type$.JSArray_int);
      if (encoding == null)
        encodingName = null;
      else
        encodingName = "utf-8";
      if (encoding == null)
        encoding = C.C_AsciiCodec;
      P.UriData__writeUri(mimeType, encodingName, null, buffer, indices);
      indices.push(buffer._contents.length);
      buffer._contents += ",";
      P.UriData__uriEncodeBytes(C.List_CVk, encoding.encode$1($content), buffer);
      t1 = buffer._contents;
      return new P.UriData(t1.charCodeAt(0) == 0 ? t1 : t1, indices, null).get$uri();
    },
    Uri_parse(uri) {
      var delta, indices, schemeEnd, hostStart, portStart, pathStart, queryStart, fragmentStart, isSimple, scheme, t1, t2, schemeAuth, queryStart0, pathStart0, userInfoStart, userInfo, host, portNumber, port, path, query, _null = null,
        end = uri.length;
      if (end >= 5) {
        delta = ((C.JSString_methods._codeUnitAt$1(uri, 4) ^ 58) * 3 | C.JSString_methods._codeUnitAt$1(uri, 0) ^ 100 | C.JSString_methods._codeUnitAt$1(uri, 1) ^ 97 | C.JSString_methods._codeUnitAt$1(uri, 2) ^ 116 | C.JSString_methods._codeUnitAt$1(uri, 3) ^ 97) >>> 0;
        if (delta === 0)
          return P.UriData__parse(end < end ? C.JSString_methods.substring$2(uri, 0, end) : uri, 5, _null).get$uri();
        else if (delta === 32)
          return P.UriData__parse(C.JSString_methods.substring$2(uri, 5, end), 0, _null).get$uri();
      }
      indices = P.List_List$filled(8, 0, false, type$.int);
      indices[0] = 0;
      indices[1] = -1;
      indices[2] = -1;
      indices[7] = -1;
      indices[3] = 0;
      indices[4] = 0;
      indices[5] = end;
      indices[6] = end;
      if (P._scan(uri, 0, end, 0, indices) >= 14)
        indices[7] = end;
      schemeEnd = indices[1];
      if (schemeEnd >= 0)
        if (P._scan(uri, 0, schemeEnd, 20, indices) === 20)
          indices[7] = schemeEnd;
      hostStart = indices[2] + 1;
      portStart = indices[3];
      pathStart = indices[4];
      queryStart = indices[5];
      fragmentStart = indices[6];
      if (fragmentStart < queryStart)
        queryStart = fragmentStart;
      if (pathStart < hostStart)
        pathStart = queryStart;
      else if (pathStart <= schemeEnd)
        pathStart = schemeEnd + 1;
      if (portStart < hostStart)
        portStart = pathStart;
      isSimple = indices[7] < 0;
      if (isSimple)
        if (hostStart > schemeEnd + 3) {
          scheme = _null;
          isSimple = false;
        } else {
          t1 = portStart > 0;
          if (t1 && portStart + 1 === pathStart) {
            scheme = _null;
            isSimple = false;
          } else {
            if (!(queryStart < end && queryStart === pathStart + 2 && C.JSString_methods.startsWith$2(uri, "..", pathStart)))
              t2 = queryStart > pathStart + 2 && C.JSString_methods.startsWith$2(uri, "/..", queryStart - 3);
            else
              t2 = true;
            if (t2) {
              scheme = _null;
              isSimple = false;
            } else {
              if (schemeEnd === 4)
                if (C.JSString_methods.startsWith$2(uri, "file", 0)) {
                  if (hostStart <= 0) {
                    if (!C.JSString_methods.startsWith$2(uri, "/", pathStart)) {
                      schemeAuth = "file:///";
                      delta = 3;
                    } else {
                      schemeAuth = "file://";
                      delta = 2;
                    }
                    uri = schemeAuth + C.JSString_methods.substring$2(uri, pathStart, end);
                    schemeEnd -= 0;
                    t1 = delta - 0;
                    queryStart += t1;
                    fragmentStart += t1;
                    end = uri.length;
                    hostStart = 7;
                    portStart = 7;
                    pathStart = 7;
                  } else if (pathStart === queryStart) {
                    ++fragmentStart;
                    queryStart0 = queryStart + 1;
                    uri = C.JSString_methods.replaceRange$3(uri, pathStart, queryStart, "/");
                    ++end;
                    queryStart = queryStart0;
                  }
                  scheme = "file";
                } else if (C.JSString_methods.startsWith$2(uri, "http", 0)) {
                  if (t1 && portStart + 3 === pathStart && C.JSString_methods.startsWith$2(uri, "80", portStart + 1)) {
                    fragmentStart -= 3;
                    pathStart0 = pathStart - 3;
                    queryStart -= 3;
                    uri = C.JSString_methods.replaceRange$3(uri, portStart, pathStart, "");
                    end -= 3;
                    pathStart = pathStart0;
                  }
                  scheme = "http";
                } else
                  scheme = _null;
              else if (schemeEnd === 5 && C.JSString_methods.startsWith$2(uri, "https", 0)) {
                if (t1 && portStart + 4 === pathStart && C.JSString_methods.startsWith$2(uri, "443", portStart + 1)) {
                  fragmentStart -= 4;
                  pathStart0 = pathStart - 4;
                  queryStart -= 4;
                  uri = C.JSString_methods.replaceRange$3(uri, portStart, pathStart, "");
                  end -= 3;
                  pathStart = pathStart0;
                }
                scheme = "https";
              } else
                scheme = _null;
              isSimple = true;
            }
          }
        }
      else
        scheme = _null;
      if (isSimple) {
        if (end < uri.length) {
          uri = C.JSString_methods.substring$2(uri, 0, end);
          schemeEnd -= 0;
          hostStart -= 0;
          portStart -= 0;
          pathStart -= 0;
          queryStart -= 0;
          fragmentStart -= 0;
        }
        return new P._SimpleUri(uri, schemeEnd, hostStart, portStart, pathStart, queryStart, fragmentStart, scheme);
      }
      if (scheme == null)
        if (schemeEnd > 0)
          scheme = P._Uri__makeScheme(uri, 0, schemeEnd);
        else {
          if (schemeEnd === 0)
            P._Uri__fail(uri, 0, "Invalid empty scheme");
          scheme = "";
        }
      if (hostStart > 0) {
        userInfoStart = schemeEnd + 3;
        userInfo = userInfoStart < hostStart ? P._Uri__makeUserInfo(uri, userInfoStart, hostStart - 1) : "";
        host = P._Uri__makeHost(uri, hostStart, portStart, false);
        t1 = portStart + 1;
        if (t1 < pathStart) {
          portNumber = H.Primitives_parseInt(C.JSString_methods.substring$2(uri, t1, pathStart), _null);
          port = P._Uri__makePort(portNumber == null ? H.throwExpression(P.FormatException$("Invalid port", uri, t1)) : portNumber, scheme);
        } else
          port = _null;
      } else {
        port = _null;
        host = port;
        userInfo = "";
      }
      path = P._Uri__makePath(uri, pathStart, queryStart, _null, scheme, host != null);
      query = queryStart < fragmentStart ? P._Uri__makeQuery(uri, queryStart + 1, fragmentStart, _null) : _null;
      return new P._Uri(scheme, userInfo, host, port, path, query, fragmentStart < end ? P._Uri__makeFragment(uri, fragmentStart + 1, end) : _null);
    },
    Uri_decodeComponent(encodedComponent) {
      return P._Uri__uriDecode(encodedComponent, 0, encodedComponent.length, C.C_Utf8Codec, false);
    },
    Uri__parseIPv4Address(host, start, end) {
      var i, partStart, partIndex, char, part, partIndex0,
        _s43_ = "IPv4 address should contain exactly 4 parts",
        _s37_ = "each part must be in the range 0..255",
        error = new P.Uri__parseIPv4Address_error(host),
        result = new Uint8Array(4);
      for (i = start, partStart = i, partIndex = 0; i < end; ++i) {
        char = C.JSString_methods.codeUnitAt$1(host, i);
        if (char !== 46) {
          if ((char ^ 48) > 9)
            error.call$2("invalid character", i);
        } else {
          if (partIndex === 3)
            error.call$2(_s43_, i);
          part = P.int_parse(C.JSString_methods.substring$2(host, partStart, i), null);
          if (part > 255)
            error.call$2(_s37_, partStart);
          partIndex0 = partIndex + 1;
          result[partIndex] = part;
          partStart = i + 1;
          partIndex = partIndex0;
        }
      }
      if (partIndex !== 3)
        error.call$2(_s43_, end);
      part = P.int_parse(C.JSString_methods.substring$2(host, partStart, end), null);
      if (part > 255)
        error.call$2(_s37_, partStart);
      result[partIndex] = part;
      return result;
    },
    Uri_parseIPv6Address(host, start, end) {
      var parts, i, partStart, wildcardSeen, seenDot, char, atEnd, t1, last, bytes, wildCardLength, index, value, j,
        error = new P.Uri_parseIPv6Address_error(host),
        parseHex = new P.Uri_parseIPv6Address_parseHex(error, host);
      if (host.length < 2)
        error.call$1("address is too short");
      parts = H._setArrayType([], type$.JSArray_int);
      for (i = start, partStart = i, wildcardSeen = false, seenDot = false; i < end; ++i) {
        char = C.JSString_methods.codeUnitAt$1(host, i);
        if (char === 58) {
          if (i === start) {
            ++i;
            if (C.JSString_methods.codeUnitAt$1(host, i) !== 58)
              error.call$2("invalid start colon.", i);
            partStart = i;
          }
          if (i === partStart) {
            if (wildcardSeen)
              error.call$2("only one wildcard `::` is allowed", i);
            parts.push(-1);
            wildcardSeen = true;
          } else
            parts.push(parseHex.call$2(partStart, i));
          partStart = i + 1;
        } else if (char === 46)
          seenDot = true;
      }
      if (parts.length === 0)
        error.call$1("too few parts");
      atEnd = partStart === end;
      t1 = C.JSArray_methods.get$last(parts);
      if (atEnd && t1 !== -1)
        error.call$2("expected a part after last `:`", end);
      if (!atEnd)
        if (!seenDot)
          parts.push(parseHex.call$2(partStart, end));
        else {
          last = P.Uri__parseIPv4Address(host, partStart, end);
          parts.push((last[0] << 8 | last[1]) >>> 0);
          parts.push((last[2] << 8 | last[3]) >>> 0);
        }
      if (wildcardSeen) {
        if (parts.length > 7)
          error.call$1("an address with a wildcard must have less than 7 parts");
      } else if (parts.length !== 8)
        error.call$1("an address without a wildcard must contain exactly 8 parts");
      bytes = new Uint8Array(16);
      for (t1 = parts.length, wildCardLength = 9 - t1, i = 0, index = 0; i < t1; ++i) {
        value = parts[i];
        if (value === -1)
          for (j = 0; j < wildCardLength; ++j) {
            bytes[index] = 0;
            bytes[index + 1] = 0;
            index += 2;
          }
        else {
          bytes[index] = C.JSInt_methods._shrOtherPositive$1(value, 8);
          bytes[index + 1] = value & 255;
          index += 2;
        }
      }
      return bytes;
    },
    _Uri__Uri(host, path, pathSegments, scheme) {
      var userInfo, query, fragment, port, isFile, t1, hasAuthority, t2, _null = null;
      scheme = scheme == null ? "" : P._Uri__makeScheme(scheme, 0, scheme.length);
      userInfo = P._Uri__makeUserInfo(_null, 0, 0);
      host = P._Uri__makeHost(host, 0, host == null ? 0 : host.length, false);
      query = P._Uri__makeQuery(_null, 0, 0, _null);
      fragment = P._Uri__makeFragment(_null, 0, 0);
      port = P._Uri__makePort(_null, scheme);
      isFile = scheme === "file";
      if (host == null)
        t1 = userInfo.length !== 0 || port != null || isFile;
      else
        t1 = false;
      if (t1)
        host = "";
      t1 = host == null;
      hasAuthority = !t1;
      path = P._Uri__makePath(path, 0, path == null ? 0 : path.length, pathSegments, scheme, hasAuthority);
      t2 = scheme.length === 0;
      if (t2 && t1 && !C.JSString_methods.startsWith$1(path, "/"))
        path = P._Uri__normalizeRelativePath(path, !t2 || hasAuthority);
      else
        path = P._Uri__removeDotSegments(path);
      return new P._Uri(scheme, userInfo, t1 && C.JSString_methods.startsWith$1(path, "//") ? "" : host, port, path, query, fragment);
    },
    _Uri__defaultPort(scheme) {
      if (scheme === "http")
        return 80;
      if (scheme === "https")
        return 443;
      return 0;
    },
    _Uri__compareScheme(scheme, uri) {
      var t1, i, schemeChar, uriChar, delta, lowerChar;
      for (t1 = scheme.length, i = 0; i < t1; ++i) {
        schemeChar = C.JSString_methods._codeUnitAt$1(scheme, i);
        uriChar = C.JSString_methods._codeUnitAt$1(uri, i);
        delta = schemeChar ^ uriChar;
        if (delta !== 0) {
          if (delta === 32) {
            lowerChar = uriChar | delta;
            if (97 <= lowerChar && lowerChar <= 122)
              continue;
          }
          return false;
        }
      }
      return true;
    },
    _Uri__fail(uri, index, message) {
      throw H.wrapException(P.FormatException$(message, uri, index));
    },
    _Uri__Uri$file(path, windows) {
      return windows ? P._Uri__makeWindowsFileUrl(path, false) : P._Uri__makeFileUri(path, false);
    },
    _Uri__checkNonWindowsPathReservedCharacters(segments, argumentError) {
      var t1, _i, segment, t2, t3;
      for (t1 = segments.length, _i = 0; _i < t1; ++_i) {
        segment = segments[_i];
        t2 = J.getInterceptor$asx(segment);
        t3 = t2.get$length(segment);
        if (0 > t3)
          H.throwExpression(P.RangeError$range(0, 0, t2.get$length(segment), null, null));
        if (H.stringContainsUnchecked(segment, "/", 0)) {
          t1 = P.UnsupportedError$("Illegal path character " + H.S(segment));
          throw H.wrapException(t1);
        }
      }
    },
    _Uri__checkWindowsPathReservedCharacters(segments, argumentError, firstSegment) {
      var t1, t2, t3, t4;
      for (t1 = H.SubListIterable$(segments, firstSegment, null, H._arrayInstanceType(segments)._precomputed1), t1 = new H.ListIterator(t1, t1.get$length(t1)), t2 = H._instanceType(t1)._precomputed1; t1.moveNext$0();) {
        t3 = t2._as(t1.__internal$_current);
        t4 = P.RegExp_RegExp('["*/:<>?\\\\|]', false);
        if (H.stringContainsUnchecked(t3, t4, 0))
          if (argumentError)
            throw H.wrapException(P.ArgumentError$("Illegal character in path", null));
          else
            throw H.wrapException(P.UnsupportedError$("Illegal character in path: " + t3));
      }
    },
    _Uri__checkWindowsDriveLetter(charCode, argumentError) {
      var t1,
        _s21_ = "Illegal drive letter ";
      if (!(65 <= charCode && charCode <= 90))
        t1 = 97 <= charCode && charCode <= 122;
      else
        t1 = true;
      if (t1)
        return;
      if (argumentError)
        throw H.wrapException(P.ArgumentError$(_s21_ + P.String_String$fromCharCode(charCode), null));
      else
        throw H.wrapException(P.UnsupportedError$(_s21_ + P.String_String$fromCharCode(charCode)));
    },
    _Uri__makeFileUri(path, slashTerminated) {
      var _null = null,
        segments = H._setArrayType(path.split("/"), type$.JSArray_String);
      if (C.JSString_methods.startsWith$1(path, "/"))
        return P._Uri__Uri(_null, _null, segments, "file");
      else
        return P._Uri__Uri(_null, _null, segments, _null);
    },
    _Uri__makeWindowsFileUrl(path, slashTerminated) {
      var t1, pathSegments, pathStart, hostPart, _s1_ = "\\", _null = null, _s4_ = "file";
      if (C.JSString_methods.startsWith$1(path, "\\\\?\\"))
        if (C.JSString_methods.startsWith$2(path, "UNC\\", 4))
          path = C.JSString_methods.replaceRange$3(path, 0, 7, _s1_);
        else {
          path = C.JSString_methods.substring$1(path, 4);
          if (path.length < 3 || C.JSString_methods._codeUnitAt$1(path, 1) !== 58 || C.JSString_methods._codeUnitAt$1(path, 2) !== 92)
            throw H.wrapException(P.ArgumentError$("Windows paths with \\\\?\\ prefix must be absolute", _null));
        }
      else
        path = H.stringReplaceAllUnchecked(path, "/", _s1_);
      t1 = path.length;
      if (t1 > 1 && C.JSString_methods._codeUnitAt$1(path, 1) === 58) {
        P._Uri__checkWindowsDriveLetter(C.JSString_methods._codeUnitAt$1(path, 0), true);
        if (t1 === 2 || C.JSString_methods._codeUnitAt$1(path, 2) !== 92)
          throw H.wrapException(P.ArgumentError$("Windows paths with drive letter must be absolute", _null));
        pathSegments = H._setArrayType(path.split(_s1_), type$.JSArray_String);
        P._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 1);
        return P._Uri__Uri(_null, _null, pathSegments, _s4_);
      }
      if (C.JSString_methods.startsWith$1(path, _s1_))
        if (C.JSString_methods.startsWith$2(path, _s1_, 1)) {
          pathStart = C.JSString_methods.indexOf$2(path, _s1_, 2);
          t1 = pathStart < 0;
          hostPart = t1 ? C.JSString_methods.substring$1(path, 2) : C.JSString_methods.substring$2(path, 2, pathStart);
          pathSegments = H._setArrayType((t1 ? "" : C.JSString_methods.substring$1(path, pathStart + 1)).split(_s1_), type$.JSArray_String);
          P._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 0);
          return P._Uri__Uri(hostPart, _null, pathSegments, _s4_);
        } else {
          pathSegments = H._setArrayType(path.split(_s1_), type$.JSArray_String);
          P._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 0);
          return P._Uri__Uri(_null, _null, pathSegments, _s4_);
        }
      else {
        pathSegments = H._setArrayType(path.split(_s1_), type$.JSArray_String);
        P._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 0);
        return P._Uri__Uri(_null, _null, pathSegments, _null);
      }
    },
    _Uri__makePort(port, scheme) {
      if (port != null && port === P._Uri__defaultPort(scheme))
        return null;
      return port;
    },
    _Uri__makeHost(host, start, end, strictIPv6) {
      var t1, t2, index, zoneIDstart, zoneID, i;
      if (host == null)
        return null;
      if (start === end)
        return "";
      if (C.JSString_methods.codeUnitAt$1(host, start) === 91) {
        t1 = end - 1;
        if (C.JSString_methods.codeUnitAt$1(host, t1) !== 93)
          P._Uri__fail(host, start, "Missing end `]` to match `[` in host");
        t2 = start + 1;
        index = P._Uri__checkZoneID(host, t2, t1);
        if (index < t1) {
          zoneIDstart = index + 1;
          zoneID = P._Uri__normalizeZoneID(host, C.JSString_methods.startsWith$2(host, "25", zoneIDstart) ? index + 3 : zoneIDstart, t1, "%25");
        } else
          zoneID = "";
        P.Uri_parseIPv6Address(host, t2, index);
        return C.JSString_methods.substring$2(host, start, index).toLowerCase() + zoneID + "]";
      }
      for (i = start; i < end; ++i)
        if (C.JSString_methods.codeUnitAt$1(host, i) === 58) {
          index = C.JSString_methods.indexOf$2(host, "%", start);
          index = index >= start && index < end ? index : end;
          if (index < end) {
            zoneIDstart = index + 1;
            zoneID = P._Uri__normalizeZoneID(host, C.JSString_methods.startsWith$2(host, "25", zoneIDstart) ? index + 3 : zoneIDstart, end, "%25");
          } else
            zoneID = "";
          P.Uri_parseIPv6Address(host, start, index);
          return "[" + C.JSString_methods.substring$2(host, start, index) + zoneID + "]";
        }
      return P._Uri__normalizeRegName(host, start, end);
    },
    _Uri__checkZoneID(host, start, end) {
      var index = C.JSString_methods.indexOf$2(host, "%", start);
      return index >= start && index < end ? index : end;
    },
    _Uri__normalizeZoneID(host, start, end, prefix) {
      var index, sectionStart, isNormalized, char, replacement, t1, t2, tail, sourceLength, slice,
        buffer = prefix !== "" ? new P.StringBuffer(prefix) : null;
      for (index = start, sectionStart = index, isNormalized = true; index < end;) {
        char = C.JSString_methods.codeUnitAt$1(host, index);
        if (char === 37) {
          replacement = P._Uri__normalizeEscape(host, index, true);
          t1 = replacement == null;
          if (t1 && isNormalized) {
            index += 3;
            continue;
          }
          if (buffer == null)
            buffer = new P.StringBuffer("");
          t2 = buffer._contents += C.JSString_methods.substring$2(host, sectionStart, index);
          if (t1)
            replacement = C.JSString_methods.substring$2(host, index, index + 3);
          else if (replacement === "%")
            P._Uri__fail(host, index, "ZoneID should not contain % anymore");
          buffer._contents = t2 + replacement;
          index += 3;
          sectionStart = index;
          isNormalized = true;
        } else if (char < 127 && (C.List_nxB[char >>> 4] & 1 << (char & 15)) !== 0) {
          if (isNormalized && 65 <= char && 90 >= char) {
            if (buffer == null)
              buffer = new P.StringBuffer("");
            if (sectionStart < index) {
              buffer._contents += C.JSString_methods.substring$2(host, sectionStart, index);
              sectionStart = index;
            }
            isNormalized = false;
          }
          ++index;
        } else {
          if ((char & 64512) === 55296 && index + 1 < end) {
            tail = C.JSString_methods.codeUnitAt$1(host, index + 1);
            if ((tail & 64512) === 56320) {
              char = (char & 1023) << 10 | tail & 1023 | 65536;
              sourceLength = 2;
            } else
              sourceLength = 1;
          } else
            sourceLength = 1;
          slice = C.JSString_methods.substring$2(host, sectionStart, index);
          if (buffer == null) {
            buffer = new P.StringBuffer("");
            t1 = buffer;
          } else
            t1 = buffer;
          t1._contents += slice;
          t1._contents += P._Uri__escapeChar(char);
          index += sourceLength;
          sectionStart = index;
        }
      }
      if (buffer == null)
        return C.JSString_methods.substring$2(host, start, end);
      if (sectionStart < end)
        buffer._contents += C.JSString_methods.substring$2(host, sectionStart, end);
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__normalizeRegName(host, start, end) {
      var index, sectionStart, buffer, isNormalized, char, replacement, t1, slice, t2, sourceLength, tail;
      for (index = start, sectionStart = index, buffer = null, isNormalized = true; index < end;) {
        char = C.JSString_methods.codeUnitAt$1(host, index);
        if (char === 37) {
          replacement = P._Uri__normalizeEscape(host, index, true);
          t1 = replacement == null;
          if (t1 && isNormalized) {
            index += 3;
            continue;
          }
          if (buffer == null)
            buffer = new P.StringBuffer("");
          slice = C.JSString_methods.substring$2(host, sectionStart, index);
          t2 = buffer._contents += !isNormalized ? slice.toLowerCase() : slice;
          if (t1) {
            replacement = C.JSString_methods.substring$2(host, index, index + 3);
            sourceLength = 3;
          } else if (replacement === "%") {
            replacement = "%25";
            sourceLength = 1;
          } else
            sourceLength = 3;
          buffer._contents = t2 + replacement;
          index += sourceLength;
          sectionStart = index;
          isNormalized = true;
        } else if (char < 127 && (C.List_qNA[char >>> 4] & 1 << (char & 15)) !== 0) {
          if (isNormalized && 65 <= char && 90 >= char) {
            if (buffer == null)
              buffer = new P.StringBuffer("");
            if (sectionStart < index) {
              buffer._contents += C.JSString_methods.substring$2(host, sectionStart, index);
              sectionStart = index;
            }
            isNormalized = false;
          }
          ++index;
        } else if (char <= 93 && (C.List_2Vk[char >>> 4] & 1 << (char & 15)) !== 0)
          P._Uri__fail(host, index, "Invalid character");
        else {
          if ((char & 64512) === 55296 && index + 1 < end) {
            tail = C.JSString_methods.codeUnitAt$1(host, index + 1);
            if ((tail & 64512) === 56320) {
              char = (char & 1023) << 10 | tail & 1023 | 65536;
              sourceLength = 2;
            } else
              sourceLength = 1;
          } else
            sourceLength = 1;
          slice = C.JSString_methods.substring$2(host, sectionStart, index);
          if (!isNormalized)
            slice = slice.toLowerCase();
          if (buffer == null) {
            buffer = new P.StringBuffer("");
            t1 = buffer;
          } else
            t1 = buffer;
          t1._contents += slice;
          t1._contents += P._Uri__escapeChar(char);
          index += sourceLength;
          sectionStart = index;
        }
      }
      if (buffer == null)
        return C.JSString_methods.substring$2(host, start, end);
      if (sectionStart < end) {
        slice = C.JSString_methods.substring$2(host, sectionStart, end);
        buffer._contents += !isNormalized ? slice.toLowerCase() : slice;
      }
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__makeScheme(scheme, start, end) {
      var i, containsUpperCase, codeUnit;
      if (start === end)
        return "";
      if (!P._Uri__isAlphabeticCharacter(C.JSString_methods._codeUnitAt$1(scheme, start)))
        P._Uri__fail(scheme, start, "Scheme not starting with alphabetic character");
      for (i = start, containsUpperCase = false; i < end; ++i) {
        codeUnit = C.JSString_methods._codeUnitAt$1(scheme, i);
        if (!(codeUnit < 128 && (C.List_JYB[codeUnit >>> 4] & 1 << (codeUnit & 15)) !== 0))
          P._Uri__fail(scheme, i, "Illegal scheme character");
        if (65 <= codeUnit && codeUnit <= 90)
          containsUpperCase = true;
      }
      scheme = C.JSString_methods.substring$2(scheme, start, end);
      return P._Uri__canonicalizeScheme(containsUpperCase ? scheme.toLowerCase() : scheme);
    },
    _Uri__canonicalizeScheme(scheme) {
      if (scheme === "http")
        return "http";
      if (scheme === "file")
        return "file";
      if (scheme === "https")
        return "https";
      if (scheme === "package")
        return "package";
      return scheme;
    },
    _Uri__makeUserInfo(userInfo, start, end) {
      if (userInfo == null)
        return "";
      return P._Uri__normalizeOrSubstring(userInfo, start, end, C.List_gRj, false);
    },
    _Uri__makePath(path, start, end, pathSegments, scheme, hasAuthority) {
      var result,
        isFile = scheme === "file",
        ensureLeadingSlash = isFile || hasAuthority;
      if (path == null) {
        if (pathSegments == null)
          return isFile ? "/" : "";
        result = new H.MappedListIterable(pathSegments, new P._Uri__makePath_closure(), H._arrayInstanceType(pathSegments)._eval$1("MappedListIterable<1,String>")).join$1(0, "/");
      } else if (pathSegments != null)
        throw H.wrapException(P.ArgumentError$("Both path and pathSegments specified", null));
      else
        result = P._Uri__normalizeOrSubstring(path, start, end, C.List_qg4, true);
      if (result.length === 0) {
        if (isFile)
          return "/";
      } else if (ensureLeadingSlash && !C.JSString_methods.startsWith$1(result, "/"))
        result = "/" + result;
      return P._Uri__normalizePath(result, scheme, hasAuthority);
    },
    _Uri__normalizePath(path, scheme, hasAuthority) {
      var t1 = scheme.length === 0;
      if (t1 && !hasAuthority && !C.JSString_methods.startsWith$1(path, "/"))
        return P._Uri__normalizeRelativePath(path, !t1 || hasAuthority);
      return P._Uri__removeDotSegments(path);
    },
    _Uri__makeQuery(query, start, end, queryParameters) {
      if (query != null)
        return P._Uri__normalizeOrSubstring(query, start, end, C.List_CVk, true);
      return null;
    },
    _Uri__makeFragment(fragment, start, end) {
      if (fragment == null)
        return null;
      return P._Uri__normalizeOrSubstring(fragment, start, end, C.List_CVk, true);
    },
    _Uri__normalizeEscape(source, index, lowerCase) {
      var firstDigit, secondDigit, firstDigitValue, secondDigitValue, value,
        t1 = index + 2;
      if (t1 >= source.length)
        return "%";
      firstDigit = C.JSString_methods.codeUnitAt$1(source, index + 1);
      secondDigit = C.JSString_methods.codeUnitAt$1(source, t1);
      firstDigitValue = H.hexDigitValue(firstDigit);
      secondDigitValue = H.hexDigitValue(secondDigit);
      if (firstDigitValue < 0 || secondDigitValue < 0)
        return "%";
      value = firstDigitValue * 16 + secondDigitValue;
      if (value < 127 && (C.List_nxB[C.JSInt_methods._shrOtherPositive$1(value, 4)] & 1 << (value & 15)) !== 0)
        return H.Primitives_stringFromCharCode(lowerCase && 65 <= value && 90 >= value ? (value | 32) >>> 0 : value);
      if (firstDigit >= 97 || secondDigit >= 97)
        return C.JSString_methods.substring$2(source, index, index + 3).toUpperCase();
      return null;
    },
    _Uri__escapeChar(char) {
      var codeUnits, flag, encodedBytes, index, byte,
        _s16_ = "0123456789ABCDEF";
      if (char < 128) {
        codeUnits = new Uint8Array(3);
        codeUnits[0] = 37;
        codeUnits[1] = C.JSString_methods._codeUnitAt$1(_s16_, char >>> 4);
        codeUnits[2] = C.JSString_methods._codeUnitAt$1(_s16_, char & 15);
      } else {
        if (char > 2047)
          if (char > 65535) {
            flag = 240;
            encodedBytes = 4;
          } else {
            flag = 224;
            encodedBytes = 3;
          }
        else {
          flag = 192;
          encodedBytes = 2;
        }
        codeUnits = new Uint8Array(3 * encodedBytes);
        for (index = 0; --encodedBytes, encodedBytes >= 0; flag = 128) {
          byte = C.JSInt_methods._shrReceiverPositive$1(char, 6 * encodedBytes) & 63 | flag;
          codeUnits[index] = 37;
          codeUnits[index + 1] = C.JSString_methods._codeUnitAt$1(_s16_, byte >>> 4);
          codeUnits[index + 2] = C.JSString_methods._codeUnitAt$1(_s16_, byte & 15);
          index += 3;
        }
      }
      return P.String_String$fromCharCodes(codeUnits, 0, null);
    },
    _Uri__normalizeOrSubstring(component, start, end, charTable, escapeDelimiters) {
      var t1 = P._Uri__normalize(component, start, end, charTable, escapeDelimiters);
      return t1 == null ? C.JSString_methods.substring$2(component, start, end) : t1;
    },
    _Uri__normalize(component, start, end, charTable, escapeDelimiters) {
      var t1, index, sectionStart, buffer, char, replacement, sourceLength, t2, tail, _null = null;
      for (t1 = !escapeDelimiters, index = start, sectionStart = index, buffer = _null; index < end;) {
        char = C.JSString_methods.codeUnitAt$1(component, index);
        if (char < 127 && (charTable[char >>> 4] & 1 << (char & 15)) !== 0)
          ++index;
        else {
          if (char === 37) {
            replacement = P._Uri__normalizeEscape(component, index, false);
            if (replacement == null) {
              index += 3;
              continue;
            }
            if ("%" === replacement) {
              replacement = "%25";
              sourceLength = 1;
            } else
              sourceLength = 3;
          } else if (t1 && char <= 93 && (C.List_2Vk[char >>> 4] & 1 << (char & 15)) !== 0) {
            P._Uri__fail(component, index, "Invalid character");
            sourceLength = _null;
            replacement = sourceLength;
          } else {
            if ((char & 64512) === 55296) {
              t2 = index + 1;
              if (t2 < end) {
                tail = C.JSString_methods.codeUnitAt$1(component, t2);
                if ((tail & 64512) === 56320) {
                  char = (char & 1023) << 10 | tail & 1023 | 65536;
                  sourceLength = 2;
                } else
                  sourceLength = 1;
              } else
                sourceLength = 1;
            } else
              sourceLength = 1;
            replacement = P._Uri__escapeChar(char);
          }
          if (buffer == null) {
            buffer = new P.StringBuffer("");
            t2 = buffer;
          } else
            t2 = buffer;
          t2._contents += C.JSString_methods.substring$2(component, sectionStart, index);
          t2._contents += H.S(replacement);
          index += sourceLength;
          sectionStart = index;
        }
      }
      if (buffer == null)
        return _null;
      if (sectionStart < end)
        buffer._contents += C.JSString_methods.substring$2(component, sectionStart, end);
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__mayContainDotSegments(path) {
      if (C.JSString_methods.startsWith$1(path, "."))
        return true;
      return C.JSString_methods.indexOf$1(path, "/.") !== -1;
    },
    _Uri__removeDotSegments(path) {
      var output, t1, t2, appendSlash, _i, segment;
      if (!P._Uri__mayContainDotSegments(path))
        return path;
      output = H._setArrayType([], type$.JSArray_String);
      for (t1 = path.split("/"), t2 = t1.length, appendSlash = false, _i = 0; _i < t2; ++_i) {
        segment = t1[_i];
        if (J.$eq$(segment, "..")) {
          if (output.length !== 0) {
            output.pop();
            if (output.length === 0)
              output.push("");
          }
          appendSlash = true;
        } else if ("." === segment)
          appendSlash = true;
        else {
          output.push(segment);
          appendSlash = false;
        }
      }
      if (appendSlash)
        output.push("");
      return C.JSArray_methods.join$1(output, "/");
    },
    _Uri__normalizeRelativePath(path, allowScheme) {
      var output, t1, t2, appendSlash, _i, segment;
      if (!P._Uri__mayContainDotSegments(path))
        return !allowScheme ? P._Uri__escapeScheme(path) : path;
      output = H._setArrayType([], type$.JSArray_String);
      for (t1 = path.split("/"), t2 = t1.length, appendSlash = false, _i = 0; _i < t2; ++_i) {
        segment = t1[_i];
        if (".." === segment)
          if (output.length !== 0 && C.JSArray_methods.get$last(output) !== "..") {
            output.pop();
            appendSlash = true;
          } else {
            output.push("..");
            appendSlash = false;
          }
        else if ("." === segment)
          appendSlash = true;
        else {
          output.push(segment);
          appendSlash = false;
        }
      }
      t1 = output.length;
      if (t1 !== 0)
        t1 = t1 === 1 && output[0].length === 0;
      else
        t1 = true;
      if (t1)
        return "./";
      if (appendSlash || C.JSArray_methods.get$last(output) === "..")
        output.push("");
      if (!allowScheme)
        output[0] = P._Uri__escapeScheme(output[0]);
      return C.JSArray_methods.join$1(output, "/");
    },
    _Uri__escapeScheme(path) {
      var i, char,
        t1 = path.length;
      if (t1 >= 2 && P._Uri__isAlphabeticCharacter(C.JSString_methods._codeUnitAt$1(path, 0)))
        for (i = 1; i < t1; ++i) {
          char = C.JSString_methods._codeUnitAt$1(path, i);
          if (char === 58)
            return C.JSString_methods.substring$2(path, 0, i) + "%3A" + C.JSString_methods.substring$1(path, i + 1);
          if (char > 127 || (C.List_JYB[char >>> 4] & 1 << (char & 15)) === 0)
            break;
        }
      return path;
    },
    _Uri__packageNameEnd(uri, path) {
      if (uri.isScheme$1("package") && uri._host == null)
        return P._skipPackageNameChars(path, 0, path.length);
      return -1;
    },
    _Uri__toWindowsFilePath(uri) {
      var hasDriveLetter, t2, host,
        segments = uri.get$pathSegments(),
        t1 = segments.length;
      if (t1 > 0 && J.get$length$asx(segments[0]) === 2 && J.codeUnitAt$1$s(segments[0], 1) === 58) {
        P._Uri__checkWindowsDriveLetter(J.codeUnitAt$1$s(segments[0], 0), false);
        P._Uri__checkWindowsPathReservedCharacters(segments, false, 1);
        hasDriveLetter = true;
      } else {
        P._Uri__checkWindowsPathReservedCharacters(segments, false, 0);
        hasDriveLetter = false;
      }
      t2 = uri.get$hasAbsolutePath() && !hasDriveLetter ? "" + "\\" : "";
      if (uri.get$hasAuthority()) {
        host = uri.get$host();
        if (host.length !== 0)
          t2 = t2 + "\\" + host + "\\";
      }
      t2 = P.StringBuffer__writeAll(t2, segments, "\\");
      t1 = hasDriveLetter && t1 === 1 ? t2 + "\\" : t2;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__hexCharPairToByte(s, pos) {
      var byte, i, charCode;
      for (byte = 0, i = 0; i < 2; ++i) {
        charCode = C.JSString_methods._codeUnitAt$1(s, pos + i);
        if (48 <= charCode && charCode <= 57)
          byte = byte * 16 + charCode - 48;
        else {
          charCode |= 32;
          if (97 <= charCode && charCode <= 102)
            byte = byte * 16 + charCode - 87;
          else
            throw H.wrapException(P.ArgumentError$("Invalid URL encoding", null));
        }
      }
      return byte;
    },
    _Uri__uriDecode(text, start, end, encoding, plusToSpace) {
      var simple, codeUnit, t1, bytes,
        i = start;
      while (true) {
        if (!(i < end)) {
          simple = true;
          break;
        }
        codeUnit = C.JSString_methods._codeUnitAt$1(text, i);
        if (codeUnit <= 127)
          if (codeUnit !== 37)
            t1 = false;
          else
            t1 = true;
        else
          t1 = true;
        if (t1) {
          simple = false;
          break;
        }
        ++i;
      }
      if (simple) {
        if (C.C_Utf8Codec !== encoding)
          t1 = false;
        else
          t1 = true;
        if (t1)
          return C.JSString_methods.substring$2(text, start, end);
        else
          bytes = new H.CodeUnits(C.JSString_methods.substring$2(text, start, end));
      } else {
        bytes = H._setArrayType([], type$.JSArray_int);
        for (t1 = text.length, i = start; i < end; ++i) {
          codeUnit = C.JSString_methods._codeUnitAt$1(text, i);
          if (codeUnit > 127)
            throw H.wrapException(P.ArgumentError$("Illegal percent encoding in URI", null));
          if (codeUnit === 37) {
            if (i + 3 > t1)
              throw H.wrapException(P.ArgumentError$("Truncated URI", null));
            bytes.push(P._Uri__hexCharPairToByte(text, i + 1));
            i += 2;
          } else
            bytes.push(codeUnit);
        }
      }
      return C.Utf8Decoder_false.convert$1(bytes);
    },
    _Uri__isAlphabeticCharacter(codeUnit) {
      var lowerCase = codeUnit | 32;
      return 97 <= lowerCase && lowerCase <= 122;
    },
    UriData__writeUri(mimeType, charsetName, parameters, buffer, indices) {
      var t1, slashIndex;
      if (mimeType == null || mimeType === "text/plain")
        mimeType = "";
      if (mimeType.length === 0 || mimeType === "application/octet-stream")
        t1 = buffer._contents += mimeType;
      else {
        slashIndex = P.UriData__validateMimeType(mimeType);
        if (slashIndex < 0)
          throw H.wrapException(P.ArgumentError$value(mimeType, "mimeType", "Invalid MIME type"));
        t1 = buffer._contents += P._Uri__uriEncode(C.List_qFt, C.JSString_methods.substring$2(mimeType, 0, slashIndex), C.C_Utf8Codec, false);
        buffer._contents = t1 + "/";
        t1 = buffer._contents += P._Uri__uriEncode(C.List_qFt, C.JSString_methods.substring$1(mimeType, slashIndex + 1), C.C_Utf8Codec, false);
      }
      if (charsetName != null) {
        indices.push(t1.length);
        indices.push(buffer._contents.length + 8);
        buffer._contents += ";charset=";
        buffer._contents += P._Uri__uriEncode(C.List_qFt, charsetName, C.C_Utf8Codec, false);
      }
    },
    UriData__validateMimeType(mimeType) {
      var t1, slashIndex, i;
      for (t1 = mimeType.length, slashIndex = -1, i = 0; i < t1; ++i) {
        if (C.JSString_methods._codeUnitAt$1(mimeType, i) !== 47)
          continue;
        if (slashIndex < 0) {
          slashIndex = i;
          continue;
        }
        return -1;
      }
      return slashIndex;
    },
    UriData__parse(text, start, sourceUri) {
      var t1, i, slashIndex, char, equalsIndex, lastSeparator, t2, data,
        _s17_ = "Invalid MIME type",
        indices = H._setArrayType([start - 1], type$.JSArray_int);
      for (t1 = text.length, i = start, slashIndex = -1, char = null; i < t1; ++i) {
        char = C.JSString_methods._codeUnitAt$1(text, i);
        if (char === 44 || char === 59)
          break;
        if (char === 47) {
          if (slashIndex < 0) {
            slashIndex = i;
            continue;
          }
          throw H.wrapException(P.FormatException$(_s17_, text, i));
        }
      }
      if (slashIndex < 0 && i > start)
        throw H.wrapException(P.FormatException$(_s17_, text, i));
      for (; char !== 44;) {
        indices.push(i);
        ++i;
        for (equalsIndex = -1; i < t1; ++i) {
          char = C.JSString_methods._codeUnitAt$1(text, i);
          if (char === 61) {
            if (equalsIndex < 0)
              equalsIndex = i;
          } else if (char === 59 || char === 44)
            break;
        }
        if (equalsIndex >= 0)
          indices.push(equalsIndex);
        else {
          lastSeparator = C.JSArray_methods.get$last(indices);
          if (char !== 44 || i !== lastSeparator + 7 || !C.JSString_methods.startsWith$2(text, "base64", lastSeparator + 1))
            throw H.wrapException(P.FormatException$("Expecting '='", text, i));
          break;
        }
      }
      indices.push(i);
      t2 = i + 1;
      if ((indices.length & 1) === 1)
        text = C.C_Base64Codec.normalize$3(text, t2, t1);
      else {
        data = P._Uri__normalize(text, t2, t1, C.List_CVk, true);
        if (data != null)
          text = C.JSString_methods.replaceRange$3(text, t2, t1, data);
      }
      return new P.UriData(text, indices, sourceUri);
    },
    UriData__uriEncodeBytes(canonicalTable, bytes, buffer) {
      var t1, byteOr, i, byte, t2, t3,
        _s16_ = "0123456789ABCDEF";
      for (t1 = J.getInterceptor$asx(bytes), byteOr = 0, i = 0; i < t1.get$length(bytes); ++i) {
        byte = t1.$index(bytes, i);
        byteOr |= byte;
        t2 = byte < 128 && (canonicalTable[C.JSInt_methods._shrOtherPositive$1(byte, 4)] & 1 << (byte & 15)) !== 0;
        t3 = buffer._contents;
        if (t2)
          buffer._contents = t3 + H.Primitives_stringFromCharCode(byte);
        else {
          t2 = t3 + H.Primitives_stringFromCharCode(37);
          buffer._contents = t2;
          t2 += H.Primitives_stringFromCharCode(C.JSString_methods._codeUnitAt$1(_s16_, C.JSInt_methods._shrOtherPositive$1(byte, 4)));
          buffer._contents = t2;
          buffer._contents = t2 + H.Primitives_stringFromCharCode(C.JSString_methods._codeUnitAt$1(_s16_, byte & 15));
        }
      }
      if ((byteOr & 4294967040) >>> 0 !== 0)
        for (i = 0; i < t1.get$length(bytes); ++i) {
          byte = t1.$index(bytes, i);
          if (byte < 0 || byte > 255)
            throw H.wrapException(P.ArgumentError$value(byte, "non-byte value", null));
        }
    },
    _createTables() {
      var _i, t1, t2, t3, b,
        _s77_ = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~!$&'()*+,;=",
        _s1_ = ".", _s1_0 = ":", _s1_1 = "/", _s1_2 = "?", _s1_3 = "#",
        tables = J.JSArray_JSArray$allocateGrowable(22, type$.Uint8List);
      for (_i = 0; _i < 22; ++_i)
        tables[_i] = new Uint8Array(96);
      t1 = new P._createTables_build(tables);
      t2 = new P._createTables_setChars();
      t3 = new P._createTables_setRange();
      b = t1.call$2(0, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, _s1_, 14);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 3);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(14, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, _s1_, 15);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(15, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, "%", 225);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 9);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(1, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 10);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(2, 235);
      t2.call$3(b, _s77_, 139);
      t2.call$3(b, _s1_1, 131);
      t2.call$3(b, _s1_, 146);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(3, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 68);
      t2.call$3(b, _s1_, 18);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(4, 229);
      t2.call$3(b, _s77_, 5);
      t3.call$3(b, "AZ", 229);
      t2.call$3(b, _s1_0, 102);
      t2.call$3(b, "@", 68);
      t2.call$3(b, "[", 232);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(5, 229);
      t2.call$3(b, _s77_, 5);
      t3.call$3(b, "AZ", 229);
      t2.call$3(b, _s1_0, 102);
      t2.call$3(b, "@", 68);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(6, 231);
      t3.call$3(b, "19", 7);
      t2.call$3(b, "@", 68);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(7, 231);
      t3.call$3(b, "09", 7);
      t2.call$3(b, "@", 68);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      t2.call$3(t1.call$2(8, 8), "]", 5);
      b = t1.call$2(9, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 16);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(16, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 17);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(17, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 9);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(10, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 18);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(18, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 19);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(19, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(11, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 10);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(12, 236);
      t2.call$3(b, _s77_, 12);
      t2.call$3(b, _s1_2, 12);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(13, 237);
      t2.call$3(b, _s77_, 13);
      t2.call$3(b, _s1_2, 13);
      t3.call$3(t1.call$2(20, 245), "az", 21);
      b = t1.call$2(21, 245);
      t3.call$3(b, "az", 21);
      t3.call$3(b, "09", 21);
      t2.call$3(b, "+-.", 21);
      return tables;
    },
    _scan(uri, start, end, state, indices) {
      var i, table, char, transition,
        tables = $.$get$_scannerTables();
      for (i = start; i < end; ++i) {
        table = tables[state];
        char = C.JSString_methods._codeUnitAt$1(uri, i) ^ 96;
        transition = table[char > 95 ? 31 : char];
        state = transition & 31;
        indices[transition >>> 5] = i;
      }
      return state;
    },
    _SimpleUri__packageNameEnd(uri) {
      if (uri._schemeEnd === 7 && C.JSString_methods.startsWith$1(uri._uri, "package") && uri._hostStart <= 0)
        return P._skipPackageNameChars(uri._uri, uri._pathStart, uri._queryStart);
      return -1;
    },
    _skipPackageNameChars(source, start, end) {
      var i, dots, char;
      for (i = start, dots = 0; i < end; ++i) {
        char = C.JSString_methods.codeUnitAt$1(source, i);
        if (char === 47)
          return dots !== 0 ? i : -1;
        if (char === 37 || char === 58)
          return -1;
        dots |= char ^ 46;
      }
      return -1;
    },
    NoSuchMethodError_toString_closure: function NoSuchMethodError_toString_closure(t0, t1) {
      this._box_0 = t0;
      this.sb = t1;
    },
    DateTime: function DateTime(t0, t1) {
      this._core$_value = t0;
      this.isUtc = t1;
    },
    Duration: function Duration(t0) {
      this._duration = t0;
    },
    Duration_toString_sixDigits: function Duration_toString_sixDigits() {
    },
    Duration_toString_twoDigits: function Duration_toString_twoDigits() {
    },
    Error: function Error() {
    },
    AssertionError: function AssertionError(t0) {
      this.message = t0;
    },
    TypeError: function TypeError() {
    },
    NullThrownError: function NullThrownError() {
    },
    ArgumentError: function ArgumentError(t0, t1, t2, t3) {
      var _ = this;
      _._hasValue = t0;
      _.invalidValue = t1;
      _.name = t2;
      _.message = t3;
    },
    RangeError: function RangeError(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.start = t0;
      _.end = t1;
      _._hasValue = t2;
      _.invalidValue = t3;
      _.name = t4;
      _.message = t5;
    },
    IndexError: function IndexError(t0, t1, t2, t3, t4) {
      var _ = this;
      _.length = t0;
      _._hasValue = t1;
      _.invalidValue = t2;
      _.name = t3;
      _.message = t4;
    },
    NoSuchMethodError: function NoSuchMethodError(t0, t1, t2, t3) {
      var _ = this;
      _._core$_receiver = t0;
      _._memberName = t1;
      _._core$_arguments = t2;
      _._namedArguments = t3;
    },
    UnsupportedError: function UnsupportedError(t0) {
      this.message = t0;
    },
    UnimplementedError: function UnimplementedError(t0) {
      this.message = t0;
    },
    StateError: function StateError(t0) {
      this.message = t0;
    },
    ConcurrentModificationError: function ConcurrentModificationError(t0) {
      this.modifiedObject = t0;
    },
    OutOfMemoryError: function OutOfMemoryError() {
    },
    StackOverflowError: function StackOverflowError() {
    },
    CyclicInitializationError: function CyclicInitializationError(t0) {
      this.variableName = t0;
    },
    _Exception: function _Exception(t0) {
      this.message = t0;
    },
    FormatException: function FormatException(t0, t1, t2) {
      this.message = t0;
      this.source = t1;
      this.offset = t2;
    },
    Iterable: function Iterable() {
    },
    _GeneratorIterable: function _GeneratorIterable(t0, t1, t2) {
      this.length = t0;
      this._generator = t1;
      this.$ti = t2;
    },
    Iterator: function Iterator() {
    },
    MapEntry: function MapEntry(t0, t1, t2) {
      this.key = t0;
      this.value = t1;
      this.$ti = t2;
    },
    Null: function Null() {
    },
    Object: function Object() {
    },
    _StringStackTrace: function _StringStackTrace(t0) {
      this._stackTrace = t0;
    },
    Runes: function Runes(t0) {
      this.string = t0;
    },
    RuneIterator: function RuneIterator(t0) {
      var _ = this;
      _.string = t0;
      _._nextPosition = _._position = 0;
      _._currentCodePoint = -1;
    },
    StringBuffer: function StringBuffer(t0) {
      this._contents = t0;
    },
    Uri__parseIPv4Address_error: function Uri__parseIPv4Address_error(t0) {
      this.host = t0;
    },
    Uri_parseIPv6Address_error: function Uri_parseIPv6Address_error(t0) {
      this.host = t0;
    },
    Uri_parseIPv6Address_parseHex: function Uri_parseIPv6Address_parseHex(t0, t1) {
      this.error = t0;
      this.host = t1;
    },
    _Uri: function _Uri(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.scheme = t0;
      _._userInfo = t1;
      _._host = t2;
      _._port = t3;
      _.path = t4;
      _._query = t5;
      _._fragment = t6;
      _.___Uri_hashCode = _.___Uri_pathSegments = _.___Uri__text = null;
    },
    _Uri__makePath_closure: function _Uri__makePath_closure() {
    },
    UriData: function UriData(t0, t1, t2) {
      this._text = t0;
      this._separatorIndices = t1;
      this._uriCache = t2;
    },
    _createTables_build: function _createTables_build(t0) {
      this.tables = t0;
    },
    _createTables_setChars: function _createTables_setChars() {
    },
    _createTables_setRange: function _createTables_setRange() {
    },
    _SimpleUri: function _SimpleUri(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _._uri = t0;
      _._schemeEnd = t1;
      _._hostStart = t2;
      _._portStart = t3;
      _._pathStart = t4;
      _._queryStart = t5;
      _._fragmentStart = t6;
      _._schemeCache = t7;
      _._hashCodeCache = null;
    },
    _DataUri: function _DataUri(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.scheme = t0;
      _._userInfo = t1;
      _._host = t2;
      _._port = t3;
      _.path = t4;
      _._query = t5;
      _._fragment = t6;
      _.___Uri_hashCode = _.___Uri_pathSegments = _.___Uri__text = null;
    },
    max(a, b) {
      return Math.max(H.checkNum(a), H.checkNum(b));
    },
    pow(x, exponent) {
      return Math.pow(x, exponent);
    },
    Random_Random() {
      return C.C__JSRandom;
    },
    _JSRandom: function _JSRandom() {
    },
    _convertDartFunctionFast(f) {
      var ret,
        existing = f.$dart_jsFunction;
      if (existing != null)
        return existing;
      ret = function(_call, f) {
        return function() {
          return _call(f, Array.prototype.slice.apply(arguments));
        };
      }(P._callDartFunctionFast, f);
      ret[$.$get$DART_CLOSURE_PROPERTY_NAME()] = f;
      f.$dart_jsFunction = ret;
      return ret;
    },
    _convertDartFunctionFastCaptureThis(f) {
      var ret,
        existing = f._$dart_jsFunctionCaptureThis;
      if (existing != null)
        return existing;
      ret = function(_call, f) {
        return function() {
          return _call(f, this, Array.prototype.slice.apply(arguments));
        };
      }(P._callDartFunctionFastCaptureThis, f);
      ret[$.$get$DART_CLOSURE_PROPERTY_NAME()] = f;
      f._$dart_jsFunctionCaptureThis = ret;
      return ret;
    },
    _callDartFunctionFast(callback, $arguments) {
      return P.Function_apply(callback, $arguments);
    },
    _callDartFunctionFastCaptureThis(callback, $self, $arguments) {
      var t1 = [$self];
      C.JSArray_methods.addAll$1(t1, $arguments);
      return P.Function_apply(callback, t1);
    },
    allowInterop(f) {
      if (typeof f == "function")
        return f;
      else
        return P._convertDartFunctionFast(f);
    },
    allowInteropCaptureThis(f) {
      if (typeof f == "function")
        throw H.wrapException(P.ArgumentError$("Function is already a JS function so cannot capture this.", null));
      else
        return P._convertDartFunctionFastCaptureThis(f);
    },
    callConstructor(constr, $arguments) {
      var args, factoryFunction;
      if ($arguments instanceof Array)
        switch ($arguments.length) {
          case 0:
            return new constr();
          case 1:
            return new constr($arguments[0]);
          case 2:
            return new constr($arguments[0], $arguments[1]);
          case 3:
            return new constr($arguments[0], $arguments[1], $arguments[2]);
          case 4:
            return new constr($arguments[0], $arguments[1], $arguments[2], $arguments[3]);
        }
      args = [null];
      C.JSArray_methods.addAll$1(args, $arguments);
      factoryFunction = constr.bind.apply(constr, args);
      String(factoryFunction);
      return new factoryFunction();
    }
  },
  Q = {Repl: function Repl(t0, t1, t2, t3) {
      var _ = this;
      _.prompt = t0;
      _.continuation = t1;
      _.validator = t2;
      _.__Repl__adapter = null;
      _.history = t3;
    }, alwaysValid_closure: function alwaysValid_closure() {
    },
    QueueList$(initialCapacity, $E) {
      return new Q.QueueList(P.List_List$filled(Q.QueueList__computeInitialCapacity(initialCapacity), null, false, $E._eval$1("0?")), 0, 0, $E._eval$1("QueueList<0>"));
    },
    QueueList_QueueList$from(source, $E) {
      var $length, queue, t1;
      if (type$.List_dynamic._is(source)) {
        $length = J.get$length$asx(source);
        queue = Q.QueueList$($length + 1, $E);
        J.setRange$4$ax(queue._table, 0, $length, source, 0);
        queue._tail = $length;
        return queue;
      } else {
        t1 = Q.QueueList$(null, $E);
        t1.addAll$1(0, source);
        return t1;
      }
    },
    QueueList__computeInitialCapacity(initialCapacity) {
      if (initialCapacity == null || initialCapacity < 8)
        return 8;
      ++initialCapacity;
      if ((initialCapacity & initialCapacity - 1) >>> 0 === 0)
        return initialCapacity;
      return Q.QueueList__nextPowerOf2(initialCapacity);
    },
    QueueList__nextPowerOf2(number) {
      var nextNumber;
      number = (number << 1 >>> 0) - 1;
      for (; true; number = nextNumber) {
        nextNumber = (number & number - 1) >>> 0;
        if (nextNumber === 0)
          return number;
      }
    },
    QueueList: function QueueList(t0, t1, t2, t3) {
      var _ = this;
      _._table = t0;
      _._head = t1;
      _._tail = t2;
      _.$ti = t3;
    },
    _CastQueueList: function _CastQueueList(t0, t1, t2, t3, t4) {
      var _ = this;
      _._queue_list$_delegate = t0;
      _._table = t1;
      _._head = t2;
      _._tail = t3;
      _.$ti = t4;
    },
    _QueueList_Object_ListMixin: function _QueueList_Object_ListMixin() {
    },
    StaticImport: function StaticImport(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.supports = t1;
      _.media = t2;
      _.span = t3;
    },
    ContentRule: function ContentRule(t0, t1) {
      this.$arguments = t0;
      this.span = t1;
    },
    DebugRule: function DebugRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    AsyncEnvironment$() {
      var t1 = type$.String,
        t2 = type$.Module_AsyncCallable,
        t3 = type$.AstNode,
        t4 = type$.int,
        t5 = type$.AsyncCallable,
        t6 = type$.JSArray_Map_String_AsyncCallable;
      return new Q.AsyncEnvironment(P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), null, null, H._setArrayType([], type$.JSArray_Module_AsyncCallable), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Value)], type$.JSArray_Map_String_Value), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t3)], type$.JSArray_Map_String_AstNode), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), null);
    },
    AsyncEnvironment$_(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = type$.String,
        t2 = type$.int;
      return new Q.AsyncEnvironment(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule0(environment, css, extensionStore, forwarded) {
      var t1, t2, t3, t4, t5, t6;
      if (forwarded == null)
        forwarded = C.Set_empty0;
      t1 = Q._EnvironmentModule__makeModulesByVariable0(forwarded);
      t2 = Q._EnvironmentModule__memberMap0(C.JSArray_methods.get$first(environment._async_environment$_variables), forwarded.map$1$1(0, new Q._EnvironmentModule__EnvironmentModule_closure5(), type$.Map_String_Value), type$.Value);
      t3 = Q._EnvironmentModule__memberMap0(C.JSArray_methods.get$first(environment._async_environment$_variableNodes), forwarded.map$1$1(0, new Q._EnvironmentModule__EnvironmentModule_closure6(), type$.Map_String_AstNode), type$.AstNode);
      t4 = type$.Map_String_AsyncCallable;
      t5 = type$.AsyncCallable;
      t6 = Q._EnvironmentModule__memberMap0(C.JSArray_methods.get$first(environment._async_environment$_functions), forwarded.map$1$1(0, new Q._EnvironmentModule__EnvironmentModule_closure7(), t4), t5);
      t5 = Q._EnvironmentModule__memberMap0(C.JSArray_methods.get$first(environment._async_environment$_mixins), forwarded.map$1$1(0, new Q._EnvironmentModule__EnvironmentModule_closure8(), t4), t5);
      t4 = J.get$isNotEmpty$asx(css.get$children(css)) || C.JSArray_methods.any$1(environment._async_environment$_allModules, new Q._EnvironmentModule__EnvironmentModule_closure9());
      return Q._EnvironmentModule$_0(environment, css, extensionStore, t1, t2, t3, t6, t5, t4, !extensionStore.get$isEmpty(extensionStore) || C.JSArray_methods.any$1(environment._async_environment$_allModules, new Q._EnvironmentModule__EnvironmentModule_closure10()));
    },
    _EnvironmentModule__makeModulesByVariable0(forwarded) {
      var modulesByVariable, t1, t2, t3, t4, t5;
      if (forwarded.get$isEmpty(forwarded))
        return C.Map_empty3;
      modulesByVariable = P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Module_AsyncCallable);
      for (t1 = forwarded.get$iterator(forwarded); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        if (t2 instanceof Q._EnvironmentModule0) {
          for (t3 = t2._async_environment$_modulesByVariable, t3 = t3.get$values(t3), t3 = t3.get$iterator(t3); t3.moveNext$0();) {
            t4 = t3.get$current(t3);
            t5 = t4.get$variables();
            B.setAll(modulesByVariable, t5.get$keys(t5), t4);
          }
          B.setAll(modulesByVariable, J.get$keys$z(C.JSArray_methods.get$first(t2._async_environment$_environment._async_environment$_variables)), t2);
        } else {
          t3 = t2.get$variables();
          B.setAll(modulesByVariable, t3.get$keys(t3), t2);
        }
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap0(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new U.PublicMemberMapView(localMap, $V._eval$1("PublicMemberMapView<0>"));
      if (otherMaps.get$isEmpty(otherMaps))
        return localMap;
      t1 = H._setArrayType([], $V._eval$1("JSArray<Map<String,0>>"));
      for (t2 = otherMaps.get$iterator(otherMaps); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return Z.MergedMapView$(t1, type$.String, $V);
    },
    _EnvironmentModule$_0(_environment, css, extensionStore, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new Q._EnvironmentModule0(_environment._async_environment$_allModules, variables, variableNodes, functions, mixins, extensionStore, css, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    AsyncEnvironment: function AsyncEnvironment(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._async_environment$_modules = t0;
      _._async_environment$_namespaceNodes = t1;
      _._async_environment$_globalModules = t2;
      _._async_environment$_importedModules = t3;
      _._async_environment$_forwardedModules = t4;
      _._async_environment$_nestedForwardedModules = t5;
      _._async_environment$_allModules = t6;
      _._async_environment$_variables = t7;
      _._async_environment$_variableNodes = t8;
      _._async_environment$_variableIndices = t9;
      _._async_environment$_functions = t10;
      _._async_environment$_functionIndices = t11;
      _._async_environment$_mixins = t12;
      _._async_environment$_mixinIndices = t13;
      _._async_environment$_content = t14;
      _._async_environment$_inMixin = false;
      _._async_environment$_inSemiGlobalScope = true;
      _._async_environment$_lastVariableIndex = _._async_environment$_lastVariableName = null;
    },
    AsyncEnvironment_importForwards_closure: function AsyncEnvironment_importForwards_closure() {
    },
    AsyncEnvironment_importForwards_closure0: function AsyncEnvironment_importForwards_closure0() {
    },
    AsyncEnvironment_importForwards_closure1: function AsyncEnvironment_importForwards_closure1() {
    },
    AsyncEnvironment__getVariableFromGlobalModule_closure: function AsyncEnvironment__getVariableFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure: function AsyncEnvironment_setVariable_closure(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment_setVariable_closure0: function AsyncEnvironment_setVariable_closure0(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure1: function AsyncEnvironment_setVariable_closure1(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment__getFunctionFromGlobalModule_closure: function AsyncEnvironment__getFunctionFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    AsyncEnvironment__getMixinFromGlobalModule_closure: function AsyncEnvironment__getMixinFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    AsyncEnvironment_toModule_closure: function AsyncEnvironment_toModule_closure() {
    },
    AsyncEnvironment_toDummyModule_closure: function AsyncEnvironment_toDummyModule_closure() {
    },
    AsyncEnvironment__fromOneModule_closure: function AsyncEnvironment__fromOneModule_closure(t0, t1) {
      this.callback = t0;
      this.T = t1;
    },
    AsyncEnvironment__fromOneModule__closure: function AsyncEnvironment__fromOneModule__closure(t0, t1) {
      this.entry = t0;
      this.T = t1;
    },
    _EnvironmentModule0: function _EnvironmentModule0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extensionStore = t5;
      _.css = t6;
      _.transitivelyContainsCss = t7;
      _.transitivelyContainsExtensions = t8;
      _._async_environment$_environment = t9;
      _._async_environment$_modulesByVariable = t10;
    },
    _EnvironmentModule__EnvironmentModule_closure5: function _EnvironmentModule__EnvironmentModule_closure5() {
    },
    _EnvironmentModule__EnvironmentModule_closure6: function _EnvironmentModule__EnvironmentModule_closure6() {
    },
    _EnvironmentModule__EnvironmentModule_closure7: function _EnvironmentModule__EnvironmentModule_closure7() {
    },
    _EnvironmentModule__EnvironmentModule_closure8: function _EnvironmentModule__EnvironmentModule_closure8() {
    },
    _EnvironmentModule__EnvironmentModule_closure9: function _EnvironmentModule__EnvironmentModule_closure9() {
    },
    _EnvironmentModule__EnvironmentModule_closure10: function _EnvironmentModule__EnvironmentModule_closure10() {
    },
    BuiltInCallable$function($name, $arguments, callback, url) {
      return new Q.BuiltInCallable($name, H._setArrayType([new S.Tuple2(L.ScssParser$("@function " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), callback, type$.Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value)], type$.JSArray_Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value));
    },
    BuiltInCallable$mixin($name, $arguments, callback, url) {
      return new Q.BuiltInCallable($name, H._setArrayType([new S.Tuple2(L.ScssParser$("@mixin " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), new Q.BuiltInCallable$mixin_closure(callback), type$.Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value)], type$.JSArray_Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value));
    },
    BuiltInCallable$overloadedFunction($name, overloads) {
      var t2, t3, t4, t5, t6, t7,
        t1 = H._setArrayType([], type$.JSArray_Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value);
      for (t2 = overloads.get$entries(overloads), t2 = t2.get$iterator(t2), t3 = type$.Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value, t4 = type$.String, t5 = type$.VariableDeclaration; t2.moveNext$0();) {
        t6 = t2.get$current(t2);
        t7 = S.SpanScanner$("@function " + $name + "(" + H.S(t6.key) + ") {", null);
        t1.push(new S.Tuple2(new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(t4, t5), t7, C.StderrLogger_false).parseArgumentDeclaration$0(), t6.value, t3));
      }
      return new Q.BuiltInCallable($name, t1);
    },
    BuiltInCallable: function BuiltInCallable(t0, t1) {
      this.name = t0;
      this._overloads = t1;
    },
    BuiltInCallable$mixin_closure: function BuiltInCallable$mixin_closure(t0) {
      this.callback = t0;
    },
    _function5($name, $arguments, callback) {
      return Q.BuiltInCallable$function($name, $arguments, callback, "sass:meta");
    },
    global_closure26: function global_closure26() {
    },
    global_closure27: function global_closure27() {
    },
    global_closure28: function global_closure28() {
    },
    global_closure29: function global_closure29() {
    },
    local_closure: function local_closure() {
    },
    local_closure0: function local_closure0() {
    },
    local__closure: function local__closure() {
    },
    BuiltInModule$($name, functions, mixins, variables, $T) {
      var t1 = P._Uri__Uri(null, $name, null, "sass"),
        t2 = Q.BuiltInModule__callableMap(functions, $T),
        t3 = Q.BuiltInModule__callableMap(mixins, $T),
        t4 = variables == null ? C.Map_empty1 : new P.UnmodifiableMapView(variables, type$.UnmodifiableMapView_String_Value);
      return new Q.BuiltInModule(t1, t2, t3, t4, $T._eval$1("BuiltInModule<0>"));
    },
    BuiltInModule__callableMap(callables, $T) {
      var t2, _i, callable,
        t1 = type$.String;
      if (callables == null)
        t1 = P.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
      else {
        t1 = P.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
        for (t2 = callables.length, _i = 0; _i < callables.length; callables.length === t2 || (0, H.throwConcurrentModificationError)(callables), ++_i) {
          callable = callables[_i];
          t1.$indexSet(0, J.get$name$x(callable), callable);
        }
        t1 = new P.UnmodifiableMapView(t1, type$.$env_1_1_String._bind$1($T)._eval$1("UnmodifiableMapView<1,2>"));
      }
      return new P.UnmodifiableMapView(t1, type$.$env_1_1_String._bind$1($T)._eval$1("UnmodifiableMapView<1,2>"));
    },
    BuiltInModule: function BuiltInModule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.url = t0;
      _.functions = t1;
      _.mixins = t2;
      _.variables = t3;
      _.$ti = t4;
    },
    _disallowedFunctionNames_closure: function _disallowedFunctionNames_closure() {
    },
    CssParser: function CssParser(t0, t1, t2) {
      var _ = this;
      _._isUseAllowed = true;
      _._inParentheses = _._inStyleRule = _._stylesheet$_inUnknownAtRule = _._inControlDirective = _._inContentBlock = _._stylesheet$_inMixin = false;
      _._globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
    },
    AsyncEnvironment$0() {
      var t1 = type$.String,
        t2 = type$.Module_AsyncCallable_2,
        t3 = type$.AstNode_2,
        t4 = type$.int,
        t5 = type$.AsyncCallable_2,
        t6 = type$.JSArray_Map_String_AsyncCallable_2;
      return new Q.AsyncEnvironment0(P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), null, null, H._setArrayType([], type$.JSArray_Module_AsyncCallable_2), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Value_2)], type$.JSArray_Map_String_Value_2), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t3)], type$.JSArray_Map_String_AstNode_2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), H._setArrayType([P.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), P.LinkedHashMap_LinkedHashMap$_empty(t1, t4), null);
    },
    AsyncEnvironment$_0(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = type$.String,
        t2 = type$.int;
      return new Q.AsyncEnvironment0(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule2(environment, css, extensionStore, forwarded) {
      var t1, t2, t3, t4, t5, t6;
      if (forwarded == null)
        forwarded = C.Set_empty3;
      t1 = Q._EnvironmentModule__makeModulesByVariable2(forwarded);
      t2 = Q._EnvironmentModule__memberMap2(C.JSArray_methods.get$first(environment._async_environment0$_variables), forwarded.map$1$1(0, new Q._EnvironmentModule__EnvironmentModule_closure17(), type$.Map_String_Value_2), type$.Value_2);
      t3 = Q._EnvironmentModule__memberMap2(C.JSArray_methods.get$first(environment._async_environment0$_variableNodes), forwarded.map$1$1(0, new Q._EnvironmentModule__EnvironmentModule_closure18(), type$.Map_String_AstNode_2), type$.AstNode_2);
      t4 = type$.Map_String_AsyncCallable_2;
      t5 = type$.AsyncCallable_2;
      t6 = Q._EnvironmentModule__memberMap2(C.JSArray_methods.get$first(environment._async_environment0$_functions), forwarded.map$1$1(0, new Q._EnvironmentModule__EnvironmentModule_closure19(), t4), t5);
      t5 = Q._EnvironmentModule__memberMap2(C.JSArray_methods.get$first(environment._async_environment0$_mixins), forwarded.map$1$1(0, new Q._EnvironmentModule__EnvironmentModule_closure20(), t4), t5);
      t4 = J.get$isNotEmpty$asx(css.get$children(css)) || C.JSArray_methods.any$1(environment._async_environment0$_allModules, new Q._EnvironmentModule__EnvironmentModule_closure21());
      return Q._EnvironmentModule$_2(environment, css, extensionStore, t1, t2, t3, t6, t5, t4, !extensionStore.get$isEmpty(extensionStore) || C.JSArray_methods.any$1(environment._async_environment0$_allModules, new Q._EnvironmentModule__EnvironmentModule_closure22()));
    },
    _EnvironmentModule__makeModulesByVariable2(forwarded) {
      var modulesByVariable, t1, t2, t3, t4, t5;
      if (forwarded.get$isEmpty(forwarded))
        return C.Map_empty10;
      modulesByVariable = P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Module_AsyncCallable_2);
      for (t1 = forwarded.get$iterator(forwarded); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        if (t2 instanceof Q._EnvironmentModule2) {
          for (t3 = t2._async_environment0$_modulesByVariable, t3 = t3.get$values(t3), t3 = t3.get$iterator(t3); t3.moveNext$0();) {
            t4 = t3.get$current(t3);
            t5 = t4.get$variables();
            B.setAll0(modulesByVariable, t5.get$keys(t5), t4);
          }
          B.setAll0(modulesByVariable, J.get$keys$z(C.JSArray_methods.get$first(t2._async_environment0$_environment._async_environment0$_variables)), t2);
        } else {
          t3 = t2.get$variables();
          B.setAll0(modulesByVariable, t3.get$keys(t3), t2);
        }
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap2(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new U.PublicMemberMapView0(localMap, $V._eval$1("PublicMemberMapView0<0>"));
      if (otherMaps.get$isEmpty(otherMaps))
        return localMap;
      t1 = H._setArrayType([], $V._eval$1("JSArray<Map<String,0>>"));
      for (t2 = otherMaps.get$iterator(otherMaps); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return Z.MergedMapView$0(t1, type$.String, $V);
    },
    _EnvironmentModule$_2(_environment, css, extensionStore, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new Q._EnvironmentModule2(_environment._async_environment0$_allModules, variables, variableNodes, functions, mixins, extensionStore, css, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    AsyncEnvironment0: function AsyncEnvironment0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._async_environment0$_modules = t0;
      _._async_environment0$_namespaceNodes = t1;
      _._async_environment0$_globalModules = t2;
      _._async_environment0$_importedModules = t3;
      _._async_environment0$_forwardedModules = t4;
      _._async_environment0$_nestedForwardedModules = t5;
      _._async_environment0$_allModules = t6;
      _._async_environment0$_variables = t7;
      _._async_environment0$_variableNodes = t8;
      _._async_environment0$_variableIndices = t9;
      _._async_environment0$_functions = t10;
      _._async_environment0$_functionIndices = t11;
      _._async_environment0$_mixins = t12;
      _._async_environment0$_mixinIndices = t13;
      _._async_environment0$_content = t14;
      _._async_environment0$_inMixin = false;
      _._async_environment0$_inSemiGlobalScope = true;
      _._async_environment0$_lastVariableIndex = _._async_environment0$_lastVariableName = null;
    },
    AsyncEnvironment_importForwards_closure2: function AsyncEnvironment_importForwards_closure2() {
    },
    AsyncEnvironment_importForwards_closure3: function AsyncEnvironment_importForwards_closure3() {
    },
    AsyncEnvironment_importForwards_closure4: function AsyncEnvironment_importForwards_closure4() {
    },
    AsyncEnvironment__getVariableFromGlobalModule_closure0: function AsyncEnvironment__getVariableFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure2: function AsyncEnvironment_setVariable_closure2(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment_setVariable_closure3: function AsyncEnvironment_setVariable_closure3(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure4: function AsyncEnvironment_setVariable_closure4(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment__getFunctionFromGlobalModule_closure0: function AsyncEnvironment__getFunctionFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    AsyncEnvironment__getMixinFromGlobalModule_closure0: function AsyncEnvironment__getMixinFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    AsyncEnvironment_toModule_closure0: function AsyncEnvironment_toModule_closure0() {
    },
    AsyncEnvironment_toDummyModule_closure0: function AsyncEnvironment_toDummyModule_closure0() {
    },
    AsyncEnvironment__fromOneModule_closure0: function AsyncEnvironment__fromOneModule_closure0(t0, t1) {
      this.callback = t0;
      this.T = t1;
    },
    AsyncEnvironment__fromOneModule__closure0: function AsyncEnvironment__fromOneModule__closure0(t0, t1) {
      this.entry = t0;
      this.T = t1;
    },
    _EnvironmentModule2: function _EnvironmentModule2(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extensionStore = t5;
      _.css = t6;
      _.transitivelyContainsCss = t7;
      _.transitivelyContainsExtensions = t8;
      _._async_environment0$_environment = t9;
      _._async_environment0$_modulesByVariable = t10;
    },
    _EnvironmentModule__EnvironmentModule_closure17: function _EnvironmentModule__EnvironmentModule_closure17() {
    },
    _EnvironmentModule__EnvironmentModule_closure18: function _EnvironmentModule__EnvironmentModule_closure18() {
    },
    _EnvironmentModule__EnvironmentModule_closure19: function _EnvironmentModule__EnvironmentModule_closure19() {
    },
    _EnvironmentModule__EnvironmentModule_closure20: function _EnvironmentModule__EnvironmentModule_closure20() {
    },
    _EnvironmentModule__EnvironmentModule_closure21: function _EnvironmentModule__EnvironmentModule_closure21() {
    },
    _EnvironmentModule__EnvironmentModule_closure22: function _EnvironmentModule__EnvironmentModule_closure22() {
    },
    BuiltInCallable$function0($name, $arguments, callback, url) {
      return new Q.BuiltInCallable0($name, H._setArrayType([new S.Tuple2(L.ScssParser$0("@function " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), callback, type$.Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value_2)], type$.JSArray_Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value_2));
    },
    BuiltInCallable$mixin0($name, $arguments, callback, url) {
      return new Q.BuiltInCallable0($name, H._setArrayType([new S.Tuple2(L.ScssParser$0("@mixin " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), new Q.BuiltInCallable$mixin_closure0(callback), type$.Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value_2)], type$.JSArray_Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value_2));
    },
    BuiltInCallable$parsed($name, $arguments, callback) {
      return new Q.BuiltInCallable0($name, H._setArrayType([new S.Tuple2($arguments, callback, type$.Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value_2)], type$.JSArray_Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value_2));
    },
    BuiltInCallable$overloadedFunction0($name, overloads) {
      var t2, t3, t4, t5, t6, t7,
        t1 = H._setArrayType([], type$.JSArray_Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value_2);
      for (t2 = overloads.get$entries(overloads), t2 = t2.get$iterator(t2), t3 = type$.Tuple2_of_ArgumentDeclaration_and_Value_Function_List_Value_2, t4 = type$.String, t5 = type$.VariableDeclaration_2; t2.moveNext$0();) {
        t6 = t2.get$current(t2);
        t7 = S.SpanScanner$("@function " + $name + "(" + H.S(t6.key) + ") {", null);
        t1.push(new S.Tuple2(new L.ScssParser0(P.LinkedHashMap_LinkedHashMap$_empty(t4, t5), t7, C.C_StderrLogger).parseArgumentDeclaration$0(), t6.value, t3));
      }
      return new Q.BuiltInCallable0($name, t1);
    },
    BuiltInCallable0: function BuiltInCallable0(t0, t1) {
      this.name = t0;
      this._built_in$_overloads = t1;
    },
    BuiltInCallable$mixin_closure0: function BuiltInCallable$mixin_closure0(t0) {
      this.callback = t0;
    },
    BuiltInModule$0($name, functions, mixins, variables, $T) {
      var t1 = P._Uri__Uri(null, $name, null, "sass"),
        t2 = Q.BuiltInModule__callableMap0(functions, $T),
        t3 = Q.BuiltInModule__callableMap0(mixins, $T),
        t4 = variables == null ? C.Map_empty7 : new P.UnmodifiableMapView(variables, type$.UnmodifiableMapView_String_Value_2);
      return new Q.BuiltInModule0(t1, t2, t3, t4, $T._eval$1("BuiltInModule0<0>"));
    },
    BuiltInModule__callableMap0(callables, $T) {
      var t2, _i, callable,
        t1 = type$.String;
      if (callables == null)
        t1 = P.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
      else {
        t1 = P.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
        for (t2 = callables.length, _i = 0; _i < callables.length; callables.length === t2 || (0, H.throwConcurrentModificationError)(callables), ++_i) {
          callable = callables[_i];
          t1.$indexSet(0, J.get$name$x(callable), callable);
        }
        t1 = new P.UnmodifiableMapView(t1, type$.$env_1_1_String._bind$1($T)._eval$1("UnmodifiableMapView<1,2>"));
      }
      return new P.UnmodifiableMapView(t1, type$.$env_1_1_String._bind$1($T)._eval$1("UnmodifiableMapView<1,2>"));
    },
    BuiltInModule0: function BuiltInModule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.url = t0;
      _.functions = t1;
      _.mixins = t2;
      _.variables = t3;
      _.$ti = t4;
    },
    ContentRule0: function ContentRule0(t0, t1) {
      this.$arguments = t0;
      this.span = t1;
    },
    _disallowedFunctionNames_closure0: function _disallowedFunctionNames_closure0() {
    },
    CssParser0: function CssParser0(t0, t1, t2) {
      var _ = this;
      _._stylesheet0$_isUseAllowed = true;
      _._stylesheet0$_inParentheses = _._stylesheet0$_inStyleRule = _._stylesheet0$_inUnknownAtRule = _._stylesheet0$_inControlDirective = _._stylesheet0$_inContentBlock = _._stylesheet0$_inMixin = false;
      _._stylesheet0$_globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
    },
    DebugRule0: function DebugRule0(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    _function12($name, $arguments, callback) {
      return Q.BuiltInCallable$function0($name, $arguments, callback, "sass:meta");
    },
    global_closure57: function global_closure57() {
    },
    global_closure58: function global_closure58() {
    },
    global_closure59: function global_closure59() {
    },
    global_closure60: function global_closure60() {
    },
    local_closure1: function local_closure1() {
    },
    local_closure2: function local_closure2() {
    },
    local__closure0: function local__closure0() {
    },
    StaticImport0: function StaticImport0(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.supports = t1;
      _.media = t2;
      _.span = t3;
    }
  },
  R = {ModifiableCssComment: function ModifiableCssComment(t0, t1) {
      var _ = this;
      _.text = t0;
      _.span = t1;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ImportCache$(loadPaths, logger) {
      var t1 = R.ImportCache__toImporters(null, loadPaths, null),
        t2 = logger == null ? C.StderrLogger_false : logger,
        t3 = type$.Uri;
      return new R.ImportCache(t1, t2, P.LinkedHashMap_LinkedHashMap$_empty(type$.Tuple2_Uri_bool, type$.nullable_Tuple3_Importer_Uri_Uri), P.LinkedHashMap_LinkedHashMap$_empty(t3, type$.nullable_Stylesheet), P.LinkedHashMap_LinkedHashMap$_empty(t3, type$.ImporterResult));
    },
    ImportCache__toImporters(importers, loadPaths, packageConfig) {
      var t2, t3, _i, path, _null = null,
        sassPath = H._asStringQ(type$.Object._as(J.get$env$x(self.process)).SASS_PATH),
        t1 = H._setArrayType([], type$.JSArray_Importer);
      for (t2 = J.get$iterator$ax(loadPaths); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t1.push(new F.FilesystemImporter($.$get$context().absolute$7(t3, _null, _null, _null, _null, _null, _null)));
      }
      if (sassPath != null) {
        t2 = sassPath.split(J.$eq$(J.get$platform$x(self.process), "win32") ? ";" : ":");
        t3 = t2.length;
        _i = 0;
        for (; _i < t3; ++_i) {
          path = t2[_i];
          t1.push(new F.FilesystemImporter($.$get$context().absolute$7(path, _null, _null, _null, _null, _null, _null)));
        }
      }
      return t1;
    },
    ImportCache: function ImportCache(t0, t1, t2, t3, t4) {
      var _ = this;
      _._importers = t0;
      _._logger = t1;
      _._canonicalizeCache = t2;
      _._importCache = t3;
      _._resultsCache = t4;
    },
    ImportCache_canonicalize_closure: function ImportCache_canonicalize_closure(t0, t1, t2) {
      this.$this = t0;
      this.url = t1;
      this.forImport = t2;
    },
    ImportCache__canonicalize_closure: function ImportCache__canonicalize_closure(t0, t1) {
      this.importer = t0;
      this.url = t1;
    },
    ImportCache_importCanonical_closure: function ImportCache_importCanonical_closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
      _.quiet = t4;
    },
    ImportCache_humanize_closure: function ImportCache_humanize_closure(t0) {
      this.canonicalUrl = t0;
    },
    ImportCache_humanize_closure0: function ImportCache_humanize_closure0() {
    },
    ImportCache_humanize_closure1: function ImportCache_humanize_closure1() {
    },
    ForwardedModuleView_ifNecessary(inner, rule, $T) {
      var t1;
      if (rule.prefix == null)
        if (rule.shownMixinsAndFunctions == null)
          if (rule.shownVariables == null) {
            t1 = rule.hiddenMixinsAndFunctions;
            if (t1 == null)
              t1 = null;
            else {
              t1 = t1._base;
              t1 = t1.get$isEmpty(t1);
            }
            if (t1 === true) {
              t1 = rule.hiddenVariables;
              if (t1 == null)
                t1 = null;
              else {
                t1 = t1._base;
                t1 = t1.get$isEmpty(t1);
              }
              t1 = t1 === true;
            } else
              t1 = false;
          } else
            t1 = false;
        else
          t1 = false;
      else
        t1 = false;
      if (t1)
        return inner;
      else
        return R.ForwardedModuleView$(inner, rule, $T);
    },
    ForwardedModuleView$(_inner, _rule, $T) {
      var t1 = _rule.prefix,
        t2 = _rule.shownVariables,
        t3 = _rule.hiddenVariables,
        t4 = _rule.shownMixinsAndFunctions,
        t5 = _rule.hiddenMixinsAndFunctions;
      return new R.ForwardedModuleView(_inner, _rule, R.ForwardedModuleView__forwardedMap(_inner.get$variables(), t1, t2, t3, type$.Value), R.ForwardedModuleView__forwardedMap(_inner.get$variableNodes(), t1, t2, t3, type$.AstNode), R.ForwardedModuleView__forwardedMap(_inner.get$functions(_inner), t1, t4, t5, $T), R.ForwardedModuleView__forwardedMap(_inner.get$mixins(), t1, t4, t5, $T), $T._eval$1("ForwardedModuleView<0>"));
    },
    ForwardedModuleView__forwardedMap(map, prefix, safelist, blocklist, $V) {
      var t2,
        t1 = prefix == null;
      if (t1)
        if (safelist == null)
          if (blocklist != null) {
            t2 = blocklist._base;
            t2 = t2.get$isEmpty(t2);
          } else
            t2 = true;
        else
          t2 = false;
      else
        t2 = false;
      if (t2)
        return map;
      if (!t1)
        map = new F.PrefixedMapView(map, prefix, $V._eval$1("PrefixedMapView<0>"));
      if (safelist != null)
        map = new K.LimitedMapView(map, safelist._base.intersection$1(new M.MapKeySet(map, type$.MapKeySet_nullable_Object)), type$.$env_1_1_String._bind$1($V)._eval$1("LimitedMapView<1,2>"));
      else {
        if (blocklist != null) {
          t1 = blocklist._base;
          t1 = t1.get$isNotEmpty(t1);
        } else
          t1 = false;
        if (t1)
          map = K.LimitedMapView$blocklist(map, blocklist, type$.String, $V);
      }
      return map;
    },
    ForwardedModuleView: function ForwardedModuleView(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._forwarded_view$_inner = t0;
      _._rule = t1;
      _.variables = t2;
      _.variableNodes = t3;
      _.functions = t4;
      _.mixins = t5;
      _.$ti = t6;
    },
    UnprefixedMapView: function UnprefixedMapView(t0, t1, t2) {
      this._unprefixed_map_view$_map = t0;
      this._unprefixed_map_view$_prefix = t1;
      this.$ti = t2;
    },
    _UnprefixedKeys: function _UnprefixedKeys(t0) {
      this._unprefixed_map_view$_view = t0;
    },
    _UnprefixedKeys_iterator_closure: function _UnprefixedKeys_iterator_closure(t0) {
      this.$this = t0;
    },
    _UnprefixedKeys_iterator_closure0: function _UnprefixedKeys_iterator_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor$(functions, importCache, logger, nodeImporter, quietDeps, sourceMap) {
      var t1 = type$.Uri,
        t2 = type$.Module_Callable,
        t3 = H._setArrayType([], type$.JSArray_Tuple2_String_AstNode),
        t4 = logger == null ? C.StderrLogger_false : logger;
      t3 = new R._EvaluateVisitor(importCache, nodeImporter, P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Callable), P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.AstNode), t4, P.LinkedHashSet_LinkedHashSet$_empty(type$.Tuple2_String_SourceSpan), quietDeps, sourceMap, O.Environment$(), P.LinkedHashSet_LinkedHashSet$_empty(t1), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.nullable_AstNode), t3, C.Configuration_Map_empty);
      t3._EvaluateVisitor$6$functions$importCache$logger$nodeImporter$quietDeps$sourceMap(functions, importCache, logger, nodeImporter, quietDeps, sourceMap);
      return t3;
    },
    Evaluator: function Evaluator(t0, t1) {
      this._visitor = t0;
      this._importer = t1;
    },
    _EvaluateVisitor: function _EvaluateVisitor(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._evaluate$_importCache = t0;
      _._nodeImporter = t1;
      _._builtInFunctions = t2;
      _._builtInModules = t3;
      _._modules = t4;
      _._moduleNodes = t5;
      _._evaluate$_logger = t6;
      _._warningsEmitted = t7;
      _._quietDeps = t8;
      _._sourceMap = t9;
      _._environment = t10;
      _._declarationName = _.__parent = _._mediaQueries = _._styleRuleIgnoringAtRoot = null;
      _._member = "root stylesheet";
      _._importSpan = _._callableNode = null;
      _._inKeyframes = _._atRootExcludingStyleRule = _._inUnknownAtRule = _._inFunction = false;
      _._loadedUrls = t11;
      _._activeModules = t12;
      _._stack = t13;
      _._importer = null;
      _._inDependency = false;
      _.__extensionStore = _._outOfOrderImports = _.__endOfImports = _.__root = _.__stylesheet = null;
      _._configuration = t14;
    },
    _EvaluateVisitor_closure: function _EvaluateVisitor_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure0: function _EvaluateVisitor_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure1: function _EvaluateVisitor_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure2: function _EvaluateVisitor_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure3: function _EvaluateVisitor_closure3(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure4: function _EvaluateVisitor_closure4(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure5: function _EvaluateVisitor_closure5(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure6: function _EvaluateVisitor_closure6(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure1: function _EvaluateVisitor__closure1(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure7: function _EvaluateVisitor_closure7(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure8: function _EvaluateVisitor_closure8(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure: function _EvaluateVisitor__closure(t0, t1, t2) {
      this.values = t0;
      this.span = t1;
      this.callableNode = t2;
    },
    _EvaluateVisitor__closure0: function _EvaluateVisitor__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure: function _EvaluateVisitor_run_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor_runExpression_closure: function _EvaluateVisitor_runExpression_closure(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.expression = t2;
    },
    _EvaluateVisitor_runExpression__closure: function _EvaluateVisitor_runExpression__closure(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor_runStatement_closure: function _EvaluateVisitor_runStatement_closure(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.statement = t2;
    },
    _EvaluateVisitor_runStatement__closure: function _EvaluateVisitor_runStatement__closure(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor__withWarnCallback_closure: function _EvaluateVisitor__withWarnCallback_closure(t0, t1) {
      this.$this = t0;
      this.nodeWithSpan = t1;
    },
    _EvaluateVisitor__loadModule_closure: function _EvaluateVisitor__loadModule_closure(t0, t1) {
      this.callback = t0;
      this.builtInModule = t1;
    },
    _EvaluateVisitor__loadModule_closure0: function _EvaluateVisitor__loadModule_closure0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeWithSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__loadModule__closure: function _EvaluateVisitor__loadModule__closure(t0, t1) {
      this.$this = t0;
      this.message = t1;
    },
    _EvaluateVisitor__execute_closure: function _EvaluateVisitor__execute_closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.stylesheet = t2;
      _.extensionStore = t3;
      _.configuration = t4;
      _.css = t5;
    },
    _EvaluateVisitor__combineCss_closure: function _EvaluateVisitor__combineCss_closure() {
    },
    _EvaluateVisitor__combineCss_closure0: function _EvaluateVisitor__combineCss_closure0(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_closure1: function _EvaluateVisitor__combineCss_closure1() {
    },
    _EvaluateVisitor__extendModules_closure: function _EvaluateVisitor__extendModules_closure(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure0: function _EvaluateVisitor__extendModules_closure0() {
    },
    _EvaluateVisitor__topologicalModules_visitModule: function _EvaluateVisitor__topologicalModules_visitModule(t0, t1) {
      this.seen = t0;
      this.sorted = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure: function _EvaluateVisitor_visitAtRootRule_closure(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure0: function _EvaluateVisitor_visitAtRootRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure1: function _EvaluateVisitor_visitAtRootRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure: function _EvaluateVisitor__scopeForAtRoot_closure(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure0: function _EvaluateVisitor__scopeForAtRoot_closure0(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure1: function _EvaluateVisitor__scopeForAtRoot_closure1(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure: function _EvaluateVisitor__scopeForAtRoot__closure(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure2: function _EvaluateVisitor__scopeForAtRoot_closure2(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure3: function _EvaluateVisitor__scopeForAtRoot_closure3() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure4: function _EvaluateVisitor__scopeForAtRoot_closure4(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure: function _EvaluateVisitor_visitContentRule_closure(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure: function _EvaluateVisitor_visitDeclaration_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitDeclaration_closure0: function _EvaluateVisitor_visitDeclaration_closure0(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitEachRule_closure: function _EvaluateVisitor_visitEachRule_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure0: function _EvaluateVisitor_visitEachRule_closure0(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure1: function _EvaluateVisitor_visitEachRule_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure: function _EvaluateVisitor_visitEachRule__closure(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure: function _EvaluateVisitor_visitEachRule___closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitExtendRule_closure: function _EvaluateVisitor_visitExtendRule_closure(t0, t1) {
      this.$this = t0;
      this.targetText = t1;
    },
    _EvaluateVisitor_visitAtRule_closure: function _EvaluateVisitor_visitAtRule_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure0: function _EvaluateVisitor_visitAtRule_closure0(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule__closure: function _EvaluateVisitor_visitAtRule__closure(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule_closure1: function _EvaluateVisitor_visitAtRule_closure1() {
    },
    _EvaluateVisitor_visitForRule_closure: function _EvaluateVisitor_visitForRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure0: function _EvaluateVisitor_visitForRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure1: function _EvaluateVisitor_visitForRule_closure1(t0) {
      this.fromNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure2: function _EvaluateVisitor_visitForRule_closure2(t0, t1) {
      this.toNumber = t0;
      this.fromNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure3: function _EvaluateVisitor_visitForRule_closure3(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
      _.fromNumber = t5;
    },
    _EvaluateVisitor_visitForRule__closure: function _EvaluateVisitor_visitForRule__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure: function _EvaluateVisitor_visitForwardRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure0: function _EvaluateVisitor_visitForwardRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIfRule_closure: function _EvaluateVisitor_visitIfRule_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitIfRule__closure: function _EvaluateVisitor_visitIfRule__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure: function _EvaluateVisitor__visitDynamicImport_closure(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure: function _EvaluateVisitor__visitDynamicImport__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport__closure0: function _EvaluateVisitor__visitDynamicImport__closure0() {
    },
    _EvaluateVisitor__visitDynamicImport__closure1: function _EvaluateVisitor__visitDynamicImport__closure1() {
    },
    _EvaluateVisitor__visitDynamicImport__closure2: function _EvaluateVisitor__visitDynamicImport__closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.result = t1;
      _.stylesheet = t2;
      _.loadsUserDefinedModules = t3;
      _.environment = t4;
      _.children = t5;
    },
    _EvaluateVisitor__visitStaticImport_closure: function _EvaluateVisitor__visitStaticImport_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure: function _EvaluateVisitor_visitIncludeRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure0: function _EvaluateVisitor_visitIncludeRule_closure0(t0) {
      this.node = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure2: function _EvaluateVisitor_visitIncludeRule_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure1: function _EvaluateVisitor_visitIncludeRule_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.nodeWithSpan = t3;
    },
    _EvaluateVisitor_visitIncludeRule__closure: function _EvaluateVisitor_visitIncludeRule__closure(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitIncludeRule___closure: function _EvaluateVisitor_visitIncludeRule___closure(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitIncludeRule____closure: function _EvaluateVisitor_visitIncludeRule____closure(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure: function _EvaluateVisitor_visitMediaRule_closure(t0, t1) {
      this.$this = t0;
      this.queries = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure0: function _EvaluateVisitor_visitMediaRule_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitMediaRule__closure: function _EvaluateVisitor_visitMediaRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure: function _EvaluateVisitor_visitMediaRule___closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure1: function _EvaluateVisitor_visitMediaRule_closure1(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor__visitMediaQueries_closure: function _EvaluateVisitor__visitMediaQueries_closure(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure: function _EvaluateVisitor_visitStyleRule_closure(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure0: function _EvaluateVisitor_visitStyleRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure1: function _EvaluateVisitor_visitStyleRule_closure1() {
    },
    _EvaluateVisitor_visitStyleRule_closure2: function _EvaluateVisitor_visitStyleRule_closure2(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure3: function _EvaluateVisitor_visitStyleRule_closure3(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure4: function _EvaluateVisitor_visitStyleRule_closure4(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure: function _EvaluateVisitor_visitStyleRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure5: function _EvaluateVisitor_visitStyleRule_closure5() {
    },
    _EvaluateVisitor_visitSupportsRule_closure: function _EvaluateVisitor_visitSupportsRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure: function _EvaluateVisitor_visitSupportsRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure0: function _EvaluateVisitor_visitSupportsRule_closure0() {
    },
    _EvaluateVisitor_visitVariableDeclaration_closure: function _EvaluateVisitor_visitVariableDeclaration_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.override = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure0: function _EvaluateVisitor_visitVariableDeclaration_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure1: function _EvaluateVisitor_visitVariableDeclaration_closure1(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure: function _EvaluateVisitor_visitUseRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure: function _EvaluateVisitor_visitWarnRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure: function _EvaluateVisitor_visitWhileRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure: function _EvaluateVisitor_visitWhileRule__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure: function _EvaluateVisitor_visitBinaryOperationExpression_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure_recommendation: function _EvaluateVisitor_visitBinaryOperationExpression_closure_recommendation() {
    },
    _EvaluateVisitor_visitVariableExpression_closure: function _EvaluateVisitor_visitVariableExpression_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitUnaryOperationExpression_closure: function _EvaluateVisitor_visitUnaryOperationExpression_closure(t0, t1) {
      this.node = t0;
      this.operand = t1;
    },
    _EvaluateVisitor__visitCalculationValue_closure: function _EvaluateVisitor__visitCalculationValue_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.inMinMax = t2;
    },
    _EvaluateVisitor_visitListExpression_closure: function _EvaluateVisitor_visitListExpression_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure: function _EvaluateVisitor_visitFunctionExpression_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitFunctionExpression_closure0: function _EvaluateVisitor_visitFunctionExpression_closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitInterpolatedFunctionExpression_closure: function _EvaluateVisitor_visitInterpolatedFunctionExpression_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.$function = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure: function _EvaluateVisitor__runUserDefinedCallable_closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure: function _EvaluateVisitor__runUserDefinedCallable__closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure: function _EvaluateVisitor__runUserDefinedCallable___closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure: function _EvaluateVisitor__runUserDefinedCallable____closure() {
    },
    _EvaluateVisitor__runFunctionCallable_closure: function _EvaluateVisitor__runFunctionCallable_closure(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure: function _EvaluateVisitor__runBuiltInCallable_closure(t0, t1, t2) {
      this.overload = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure0: function _EvaluateVisitor__runBuiltInCallable_closure0(t0, t1) {
      this.callback = t0;
      this.evaluated = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure1: function _EvaluateVisitor__runBuiltInCallable_closure1() {
    },
    _EvaluateVisitor__evaluateArguments_closure: function _EvaluateVisitor__evaluateArguments_closure() {
    },
    _EvaluateVisitor__evaluateArguments_closure0: function _EvaluateVisitor__evaluateArguments_closure0(t0, t1) {
      this.$this = t0;
      this.restNodeForSpan = t1;
    },
    _EvaluateVisitor__evaluateArguments_closure1: function _EvaluateVisitor__evaluateArguments_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.namedNodes = t3;
    },
    _EvaluateVisitor__evaluateArguments_closure2: function _EvaluateVisitor__evaluateArguments_closure2() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure: function _EvaluateVisitor__evaluateMacroArguments_closure(t0) {
      this.restArgs = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure0: function _EvaluateVisitor__evaluateMacroArguments_closure0(t0, t1, t2) {
      this.$this = t0;
      this.restNodeForSpan = t1;
      this.restArgs = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure1: function _EvaluateVisitor__evaluateMacroArguments_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.restArgs = t3;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure2: function _EvaluateVisitor__evaluateMacroArguments_closure2(t0, t1, t2) {
      this.$this = t0;
      this.keywordRestNodeForSpan = t1;
      this.keywordRestArgs = t2;
    },
    _EvaluateVisitor__addRestMap_closure: function _EvaluateVisitor__addRestMap_closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.values = t1;
      _.convert = t2;
      _.expressionNode = t3;
      _.map = t4;
      _.nodeWithSpan = t5;
    },
    _EvaluateVisitor__verifyArguments_closure: function _EvaluateVisitor__verifyArguments_closure(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitStringExpression_closure: function _EvaluateVisitor_visitStringExpression_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitCssAtRule_closure: function _EvaluateVisitor_visitCssAtRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure0: function _EvaluateVisitor_visitCssAtRule_closure0() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure: function _EvaluateVisitor_visitCssKeyframeBlock_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure0: function _EvaluateVisitor_visitCssKeyframeBlock_closure0() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure: function _EvaluateVisitor_visitCssMediaRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure0: function _EvaluateVisitor_visitCssMediaRule_closure0(t0, t1, t2) {
      this.$this = t0;
      this.mergedQueries = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssMediaRule__closure: function _EvaluateVisitor_visitCssMediaRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure: function _EvaluateVisitor_visitCssMediaRule___closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure1: function _EvaluateVisitor_visitCssMediaRule_closure1(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure: function _EvaluateVisitor_visitCssStyleRule_closure(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure: function _EvaluateVisitor_visitCssStyleRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure0: function _EvaluateVisitor_visitCssStyleRule_closure0() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure: function _EvaluateVisitor_visitCssSupportsRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure: function _EvaluateVisitor_visitCssSupportsRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure0: function _EvaluateVisitor_visitCssSupportsRule_closure0() {
    },
    _EvaluateVisitor__performInterpolation_closure: function _EvaluateVisitor__performInterpolation_closure(t0, t1, t2) {
      this.$this = t0;
      this.warnForColor = t1;
      this.interpolation = t2;
    },
    _EvaluateVisitor__serialize_closure: function _EvaluateVisitor__serialize_closure(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__expressionNode_closure: function _EvaluateVisitor__expressionNode_closure(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor__withoutSlash_recommendation: function _EvaluateVisitor__withoutSlash_recommendation() {
    },
    _EvaluateVisitor__stackFrame_closure: function _EvaluateVisitor__stackFrame_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__stackTrace_closure: function _EvaluateVisitor__stackTrace_closure(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor: function _ImportedCssVisitor(t0) {
      this._visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure: function _ImportedCssVisitor_visitCssAtRule_closure() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure: function _ImportedCssVisitor_visitCssMediaRule_closure(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure: function _ImportedCssVisitor_visitCssStyleRule_closure() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure: function _ImportedCssVisitor_visitCssSupportsRule_closure() {
    },
    _ArgumentResults: function _ArgumentResults(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.positionalNodes = t1;
      _.named = t2;
      _.namedNodes = t3;
      _.separator = t4;
    },
    _LoadedStylesheet: function _LoadedStylesheet(t0, t1, t2) {
      this.stylesheet = t0;
      this.importer = t1;
      this.isDependency = t2;
    },
    RateLimit__debounceAggregate(_this, duration, collect, leading, trailing, $T, $S) {
      var t1 = {};
      t1.soFar = t1.timer = null;
      t1.emittedLatestAsLeading = t1.shouldClose = t1.hasPending = false;
      return L.TransformByHandlers_transformByHandlers(_this, new R.RateLimit__debounceAggregate_closure(t1, $S, collect, false, duration, true, $T), new R.RateLimit__debounceAggregate_closure0(t1, true, $S), $T, $S);
    },
    _collect($event, soFar, $T) {
      var t1 = soFar == null ? H._setArrayType([], $T._eval$1("JSArray<0>")) : soFar;
      J.add$1$ax(t1, $event);
      return t1;
    },
    RateLimit__debounceAggregate_closure: function RateLimit__debounceAggregate_closure(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._box_0 = t0;
      _.S = t1;
      _.collect = t2;
      _.leading = t3;
      _.duration = t4;
      _.trailing = t5;
      _.T = t6;
    },
    RateLimit__debounceAggregate_closure_emit: function RateLimit__debounceAggregate_closure_emit(t0, t1, t2) {
      this._box_0 = t0;
      this.sink = t1;
      this.S = t2;
    },
    RateLimit__debounceAggregate__closure: function RateLimit__debounceAggregate__closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.trailing = t1;
      _.emit = t2;
      _.sink = t3;
    },
    RateLimit__debounceAggregate_closure0: function RateLimit__debounceAggregate_closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.trailing = t1;
      this.S = t2;
    },
    ModifiableCssComment0: function ModifiableCssComment0(t0, t1) {
      var _ = this;
      _.text = t0;
      _.span = t1;
      _._node2$_indexInParent = _._node2$_parent = null;
      _.isGroupEnd = false;
    },
    _EvaluateVisitor$1(functions, importCache, logger, nodeImporter, quietDeps, sourceMap) {
      var t4, t5,
        t1 = type$.Uri,
        t2 = type$.Module_Callable_2,
        t3 = H._setArrayType([], type$.JSArray_Tuple2_String_AstNode_2);
      if (nodeImporter == null)
        t4 = importCache == null ? R.ImportCache$none(logger) : importCache;
      else
        t4 = null;
      t5 = logger == null ? C.C_StderrLogger : logger;
      t3 = new R._EvaluateVisitor1(t4, nodeImporter, P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Callable_2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.AstNode_2), t5, P.LinkedHashSet_LinkedHashSet$_empty(type$.Tuple2_String_SourceSpan), quietDeps, sourceMap, O.Environment$0(), P.LinkedHashSet_LinkedHashSet$_empty(t1), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.nullable_AstNode_2), t3, C.Configuration_Map_empty0);
      t3._EvaluateVisitor$6$functions$importCache$logger$nodeImporter$quietDeps$sourceMap1(functions, importCache, logger, nodeImporter, quietDeps, sourceMap);
      return t3;
    },
    _EvaluateVisitor1: function _EvaluateVisitor1(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._evaluate0$_importCache = t0;
      _._evaluate0$_nodeImporter = t1;
      _._evaluate0$_builtInFunctions = t2;
      _._evaluate0$_builtInModules = t3;
      _._evaluate0$_modules = t4;
      _._evaluate0$_moduleNodes = t5;
      _._evaluate0$_logger = t6;
      _._evaluate0$_warningsEmitted = t7;
      _._evaluate0$_quietDeps = t8;
      _._evaluate0$_sourceMap = t9;
      _._evaluate0$_environment = t10;
      _._evaluate0$_declarationName = _._evaluate0$__parent = _._evaluate0$_mediaQueries = _._evaluate0$_styleRuleIgnoringAtRoot = null;
      _._evaluate0$_member = "root stylesheet";
      _._evaluate0$_importSpan = _._evaluate0$_callableNode = null;
      _._evaluate0$_inKeyframes = _._evaluate0$_atRootExcludingStyleRule = _._evaluate0$_inUnknownAtRule = _._evaluate0$_inFunction = false;
      _._evaluate0$_loadedUrls = t11;
      _._evaluate0$_activeModules = t12;
      _._evaluate0$_stack = t13;
      _._evaluate0$_importer = null;
      _._evaluate0$_inDependency = false;
      _._evaluate0$__extensionStore = _._evaluate0$_outOfOrderImports = _._evaluate0$__endOfImports = _._evaluate0$__root = _._evaluate0$__stylesheet = null;
      _._evaluate0$_configuration = t14;
    },
    _EvaluateVisitor_closure19: function _EvaluateVisitor_closure19(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure20: function _EvaluateVisitor_closure20(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure21: function _EvaluateVisitor_closure21(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure22: function _EvaluateVisitor_closure22(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure23: function _EvaluateVisitor_closure23(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure24: function _EvaluateVisitor_closure24(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure25: function _EvaluateVisitor_closure25(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure26: function _EvaluateVisitor_closure26(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure7: function _EvaluateVisitor__closure7(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure27: function _EvaluateVisitor_closure27(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure28: function _EvaluateVisitor_closure28(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure5: function _EvaluateVisitor__closure5(t0, t1, t2) {
      this.values = t0;
      this.span = t1;
      this.callableNode = t2;
    },
    _EvaluateVisitor__closure6: function _EvaluateVisitor__closure6(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure1: function _EvaluateVisitor_run_closure1(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor__withWarnCallback_closure1: function _EvaluateVisitor__withWarnCallback_closure1(t0, t1) {
      this.$this = t0;
      this.nodeWithSpan = t1;
    },
    _EvaluateVisitor__loadModule_closure3: function _EvaluateVisitor__loadModule_closure3(t0, t1) {
      this.callback = t0;
      this.builtInModule = t1;
    },
    _EvaluateVisitor__loadModule_closure4: function _EvaluateVisitor__loadModule_closure4(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeWithSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__loadModule__closure1: function _EvaluateVisitor__loadModule__closure1(t0, t1) {
      this.$this = t0;
      this.message = t1;
    },
    _EvaluateVisitor__execute_closure1: function _EvaluateVisitor__execute_closure1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.stylesheet = t2;
      _.extensionStore = t3;
      _.configuration = t4;
      _.css = t5;
    },
    _EvaluateVisitor__combineCss_closure5: function _EvaluateVisitor__combineCss_closure5() {
    },
    _EvaluateVisitor__combineCss_closure6: function _EvaluateVisitor__combineCss_closure6(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_closure7: function _EvaluateVisitor__combineCss_closure7() {
    },
    _EvaluateVisitor__extendModules_closure3: function _EvaluateVisitor__extendModules_closure3(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure4: function _EvaluateVisitor__extendModules_closure4() {
    },
    _EvaluateVisitor__topologicalModules_visitModule1: function _EvaluateVisitor__topologicalModules_visitModule1(t0, t1) {
      this.seen = t0;
      this.sorted = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure5: function _EvaluateVisitor_visitAtRootRule_closure5(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure6: function _EvaluateVisitor_visitAtRootRule_closure6(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure7: function _EvaluateVisitor_visitAtRootRule_closure7(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure11: function _EvaluateVisitor__scopeForAtRoot_closure11(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure12: function _EvaluateVisitor__scopeForAtRoot_closure12(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure13: function _EvaluateVisitor__scopeForAtRoot_closure13(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure1: function _EvaluateVisitor__scopeForAtRoot__closure1(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure14: function _EvaluateVisitor__scopeForAtRoot_closure14(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure15: function _EvaluateVisitor__scopeForAtRoot_closure15() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure16: function _EvaluateVisitor__scopeForAtRoot_closure16(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure1: function _EvaluateVisitor_visitContentRule_closure1(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure3: function _EvaluateVisitor_visitDeclaration_closure3(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitDeclaration_closure4: function _EvaluateVisitor_visitDeclaration_closure4(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitEachRule_closure5: function _EvaluateVisitor_visitEachRule_closure5(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure6: function _EvaluateVisitor_visitEachRule_closure6(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure7: function _EvaluateVisitor_visitEachRule_closure7(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure1: function _EvaluateVisitor_visitEachRule__closure1(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure1: function _EvaluateVisitor_visitEachRule___closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitExtendRule_closure1: function _EvaluateVisitor_visitExtendRule_closure1(t0, t1) {
      this.$this = t0;
      this.targetText = t1;
    },
    _EvaluateVisitor_visitAtRule_closure5: function _EvaluateVisitor_visitAtRule_closure5(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure6: function _EvaluateVisitor_visitAtRule_closure6(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule__closure1: function _EvaluateVisitor_visitAtRule__closure1(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule_closure7: function _EvaluateVisitor_visitAtRule_closure7() {
    },
    _EvaluateVisitor_visitForRule_closure9: function _EvaluateVisitor_visitForRule_closure9(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure10: function _EvaluateVisitor_visitForRule_closure10(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure11: function _EvaluateVisitor_visitForRule_closure11(t0) {
      this.fromNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure12: function _EvaluateVisitor_visitForRule_closure12(t0, t1) {
      this.toNumber = t0;
      this.fromNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure13: function _EvaluateVisitor_visitForRule_closure13(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
      _.fromNumber = t5;
    },
    _EvaluateVisitor_visitForRule__closure1: function _EvaluateVisitor_visitForRule__closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure3: function _EvaluateVisitor_visitForwardRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure4: function _EvaluateVisitor_visitForwardRule_closure4(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIfRule_closure1: function _EvaluateVisitor_visitIfRule_closure1(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitIfRule__closure1: function _EvaluateVisitor_visitIfRule__closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure1: function _EvaluateVisitor__visitDynamicImport_closure1(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure7: function _EvaluateVisitor__visitDynamicImport__closure7(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport__closure8: function _EvaluateVisitor__visitDynamicImport__closure8() {
    },
    _EvaluateVisitor__visitDynamicImport__closure9: function _EvaluateVisitor__visitDynamicImport__closure9() {
    },
    _EvaluateVisitor__visitDynamicImport__closure10: function _EvaluateVisitor__visitDynamicImport__closure10(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.result = t1;
      _.stylesheet = t2;
      _.loadsUserDefinedModules = t3;
      _.environment = t4;
      _.children = t5;
    },
    _EvaluateVisitor__visitStaticImport_closure1: function _EvaluateVisitor__visitStaticImport_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure7: function _EvaluateVisitor_visitIncludeRule_closure7(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure8: function _EvaluateVisitor_visitIncludeRule_closure8(t0) {
      this.node = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure10: function _EvaluateVisitor_visitIncludeRule_closure10(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure9: function _EvaluateVisitor_visitIncludeRule_closure9(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.nodeWithSpan = t3;
    },
    _EvaluateVisitor_visitIncludeRule__closure1: function _EvaluateVisitor_visitIncludeRule__closure1(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitIncludeRule___closure1: function _EvaluateVisitor_visitIncludeRule___closure1(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitIncludeRule____closure1: function _EvaluateVisitor_visitIncludeRule____closure1(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure5: function _EvaluateVisitor_visitMediaRule_closure5(t0, t1) {
      this.$this = t0;
      this.queries = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure6: function _EvaluateVisitor_visitMediaRule_closure6(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitMediaRule__closure1: function _EvaluateVisitor_visitMediaRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure1: function _EvaluateVisitor_visitMediaRule___closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure7: function _EvaluateVisitor_visitMediaRule_closure7(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor__visitMediaQueries_closure1: function _EvaluateVisitor__visitMediaQueries_closure1(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure13: function _EvaluateVisitor_visitStyleRule_closure13(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure14: function _EvaluateVisitor_visitStyleRule_closure14(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure15: function _EvaluateVisitor_visitStyleRule_closure15() {
    },
    _EvaluateVisitor_visitStyleRule_closure16: function _EvaluateVisitor_visitStyleRule_closure16(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure17: function _EvaluateVisitor_visitStyleRule_closure17(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure18: function _EvaluateVisitor_visitStyleRule_closure18(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure1: function _EvaluateVisitor_visitStyleRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure19: function _EvaluateVisitor_visitStyleRule_closure19() {
    },
    _EvaluateVisitor_visitSupportsRule_closure3: function _EvaluateVisitor_visitSupportsRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure1: function _EvaluateVisitor_visitSupportsRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure4: function _EvaluateVisitor_visitSupportsRule_closure4() {
    },
    _EvaluateVisitor_visitVariableDeclaration_closure5: function _EvaluateVisitor_visitVariableDeclaration_closure5(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.override = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure6: function _EvaluateVisitor_visitVariableDeclaration_closure6(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure7: function _EvaluateVisitor_visitVariableDeclaration_closure7(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure1: function _EvaluateVisitor_visitUseRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure1: function _EvaluateVisitor_visitWarnRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure1: function _EvaluateVisitor_visitWhileRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure1: function _EvaluateVisitor_visitWhileRule__closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure1: function _EvaluateVisitor_visitBinaryOperationExpression_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure_recommendation1: function _EvaluateVisitor_visitBinaryOperationExpression_closure_recommendation1() {
    },
    _EvaluateVisitor_visitVariableExpression_closure1: function _EvaluateVisitor_visitVariableExpression_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitUnaryOperationExpression_closure1: function _EvaluateVisitor_visitUnaryOperationExpression_closure1(t0, t1) {
      this.node = t0;
      this.operand = t1;
    },
    _EvaluateVisitor__visitCalculationValue_closure1: function _EvaluateVisitor__visitCalculationValue_closure1(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.inMinMax = t2;
    },
    _EvaluateVisitor_visitListExpression_closure1: function _EvaluateVisitor_visitListExpression_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure3: function _EvaluateVisitor_visitFunctionExpression_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitFunctionExpression_closure4: function _EvaluateVisitor_visitFunctionExpression_closure4(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitInterpolatedFunctionExpression_closure1: function _EvaluateVisitor_visitInterpolatedFunctionExpression_closure1(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.$function = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure1: function _EvaluateVisitor__runUserDefinedCallable_closure1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure1: function _EvaluateVisitor__runUserDefinedCallable__closure1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure1: function _EvaluateVisitor__runUserDefinedCallable___closure1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure1: function _EvaluateVisitor__runUserDefinedCallable____closure1() {
    },
    _EvaluateVisitor__runFunctionCallable_closure1: function _EvaluateVisitor__runFunctionCallable_closure1(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure5: function _EvaluateVisitor__runBuiltInCallable_closure5(t0, t1, t2) {
      this.overload = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure6: function _EvaluateVisitor__runBuiltInCallable_closure6(t0, t1) {
      this.callback = t0;
      this.evaluated = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure7: function _EvaluateVisitor__runBuiltInCallable_closure7() {
    },
    _EvaluateVisitor__evaluateArguments_closure7: function _EvaluateVisitor__evaluateArguments_closure7() {
    },
    _EvaluateVisitor__evaluateArguments_closure8: function _EvaluateVisitor__evaluateArguments_closure8(t0, t1) {
      this.$this = t0;
      this.restNodeForSpan = t1;
    },
    _EvaluateVisitor__evaluateArguments_closure9: function _EvaluateVisitor__evaluateArguments_closure9(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.namedNodes = t3;
    },
    _EvaluateVisitor__evaluateArguments_closure10: function _EvaluateVisitor__evaluateArguments_closure10() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure7: function _EvaluateVisitor__evaluateMacroArguments_closure7(t0) {
      this.restArgs = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure8: function _EvaluateVisitor__evaluateMacroArguments_closure8(t0, t1, t2) {
      this.$this = t0;
      this.restNodeForSpan = t1;
      this.restArgs = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure9: function _EvaluateVisitor__evaluateMacroArguments_closure9(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.restArgs = t3;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure10: function _EvaluateVisitor__evaluateMacroArguments_closure10(t0, t1, t2) {
      this.$this = t0;
      this.keywordRestNodeForSpan = t1;
      this.keywordRestArgs = t2;
    },
    _EvaluateVisitor__addRestMap_closure1: function _EvaluateVisitor__addRestMap_closure1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.values = t1;
      _.convert = t2;
      _.expressionNode = t3;
      _.map = t4;
      _.nodeWithSpan = t5;
    },
    _EvaluateVisitor__verifyArguments_closure1: function _EvaluateVisitor__verifyArguments_closure1(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitStringExpression_closure1: function _EvaluateVisitor_visitStringExpression_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitCssAtRule_closure3: function _EvaluateVisitor_visitCssAtRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure4: function _EvaluateVisitor_visitCssAtRule_closure4() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure3: function _EvaluateVisitor_visitCssKeyframeBlock_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure4: function _EvaluateVisitor_visitCssKeyframeBlock_closure4() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure5: function _EvaluateVisitor_visitCssMediaRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure6: function _EvaluateVisitor_visitCssMediaRule_closure6(t0, t1, t2) {
      this.$this = t0;
      this.mergedQueries = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssMediaRule__closure1: function _EvaluateVisitor_visitCssMediaRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure1: function _EvaluateVisitor_visitCssMediaRule___closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure7: function _EvaluateVisitor_visitCssMediaRule_closure7(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure3: function _EvaluateVisitor_visitCssStyleRule_closure3(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure1: function _EvaluateVisitor_visitCssStyleRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure4: function _EvaluateVisitor_visitCssStyleRule_closure4() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure3: function _EvaluateVisitor_visitCssSupportsRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure1: function _EvaluateVisitor_visitCssSupportsRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure4: function _EvaluateVisitor_visitCssSupportsRule_closure4() {
    },
    _EvaluateVisitor__performInterpolation_closure1: function _EvaluateVisitor__performInterpolation_closure1(t0, t1, t2) {
      this.$this = t0;
      this.warnForColor = t1;
      this.interpolation = t2;
    },
    _EvaluateVisitor__serialize_closure1: function _EvaluateVisitor__serialize_closure1(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__expressionNode_closure1: function _EvaluateVisitor__expressionNode_closure1(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor__withoutSlash_recommendation1: function _EvaluateVisitor__withoutSlash_recommendation1() {
    },
    _EvaluateVisitor__stackFrame_closure1: function _EvaluateVisitor__stackFrame_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__stackTrace_closure1: function _EvaluateVisitor__stackTrace_closure1(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor1: function _ImportedCssVisitor1(t0) {
      this._evaluate0$_visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure1: function _ImportedCssVisitor_visitCssAtRule_closure1() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure1: function _ImportedCssVisitor_visitCssMediaRule_closure1(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure1: function _ImportedCssVisitor_visitCssStyleRule_closure1() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure1: function _ImportedCssVisitor_visitCssSupportsRule_closure1() {
    },
    _ArgumentResults1: function _ArgumentResults1(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.positionalNodes = t1;
      _.named = t2;
      _.namedNodes = t3;
      _.separator = t4;
    },
    _LoadedStylesheet1: function _LoadedStylesheet1(t0, t1, t2) {
      this.stylesheet = t0;
      this.importer = t1;
      this.isDependency = t2;
    },
    ForwardedModuleView_ifNecessary0(inner, rule, $T) {
      var t1;
      if (rule.prefix == null)
        if (rule.shownMixinsAndFunctions == null)
          if (rule.shownVariables == null) {
            t1 = rule.hiddenMixinsAndFunctions;
            if (t1 == null)
              t1 = null;
            else {
              t1 = t1._base;
              t1 = t1.get$isEmpty(t1);
            }
            if (t1 === true) {
              t1 = rule.hiddenVariables;
              if (t1 == null)
                t1 = null;
              else {
                t1 = t1._base;
                t1 = t1.get$isEmpty(t1);
              }
              t1 = t1 === true;
            } else
              t1 = false;
          } else
            t1 = false;
        else
          t1 = false;
      else
        t1 = false;
      if (t1)
        return inner;
      else
        return R.ForwardedModuleView$0(inner, rule, $T);
    },
    ForwardedModuleView$0(_inner, _rule, $T) {
      var t1 = _rule.prefix,
        t2 = _rule.shownVariables,
        t3 = _rule.hiddenVariables,
        t4 = _rule.shownMixinsAndFunctions,
        t5 = _rule.hiddenMixinsAndFunctions;
      return new R.ForwardedModuleView0(_inner, _rule, R.ForwardedModuleView__forwardedMap0(_inner.get$variables(), t1, t2, t3, type$.Value_2), R.ForwardedModuleView__forwardedMap0(_inner.get$variableNodes(), t1, t2, t3, type$.AstNode_2), R.ForwardedModuleView__forwardedMap0(_inner.get$functions(_inner), t1, t4, t5, $T), R.ForwardedModuleView__forwardedMap0(_inner.get$mixins(), t1, t4, t5, $T), $T._eval$1("ForwardedModuleView0<0>"));
    },
    ForwardedModuleView__forwardedMap0(map, prefix, safelist, blocklist, $V) {
      var t2,
        t1 = prefix == null;
      if (t1)
        if (safelist == null)
          if (blocklist != null) {
            t2 = blocklist._base;
            t2 = t2.get$isEmpty(t2);
          } else
            t2 = true;
        else
          t2 = false;
      else
        t2 = false;
      if (t2)
        return map;
      if (!t1)
        map = new F.PrefixedMapView0(map, prefix, $V._eval$1("PrefixedMapView0<0>"));
      if (safelist != null)
        map = new K.LimitedMapView0(map, safelist._base.intersection$1(new M.MapKeySet(map, type$.MapKeySet_nullable_Object)), type$.$env_1_1_String._bind$1($V)._eval$1("LimitedMapView0<1,2>"));
      else {
        if (blocklist != null) {
          t1 = blocklist._base;
          t1 = t1.get$isNotEmpty(t1);
        } else
          t1 = false;
        if (t1)
          map = K.LimitedMapView$blocklist0(map, blocklist, type$.String, $V);
      }
      return map;
    },
    ForwardedModuleView0: function ForwardedModuleView0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._forwarded_view0$_inner = t0;
      _._forwarded_view0$_rule = t1;
      _.variables = t2;
      _.variableNodes = t3;
      _.functions = t4;
      _.mixins = t5;
      _.$ti = t6;
    },
    ImportCache$none(logger) {
      var t1 = logger == null ? C.C_StderrLogger : logger,
        t2 = type$.Uri;
      return new R.ImportCache0(t1, P.LinkedHashMap_LinkedHashMap$_empty(type$.Tuple2_Uri_bool, type$.nullable_Tuple3_Importer_Uri_Uri_2), P.LinkedHashMap_LinkedHashMap$_empty(t2, type$.nullable_Stylesheet_2), P.LinkedHashMap_LinkedHashMap$_empty(t2, type$.ImporterResult_2));
    },
    ImportCache0: function ImportCache0(t0, t1, t2, t3) {
      var _ = this;
      _._import_cache$_logger = t0;
      _._import_cache$_canonicalizeCache = t1;
      _._import_cache$_importCache = t2;
      _._import_cache$_resultsCache = t3;
    },
    ImportCache_canonicalize_closure0: function ImportCache_canonicalize_closure0(t0, t1, t2) {
      this.$this = t0;
      this.url = t1;
      this.forImport = t2;
    },
    ImportCache__canonicalize_closure0: function ImportCache__canonicalize_closure0(t0, t1) {
      this.importer = t0;
      this.url = t1;
    },
    ImportCache_importCanonical_closure0: function ImportCache_importCanonical_closure0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
      _.quiet = t4;
    },
    ImportCache_humanize_closure2: function ImportCache_humanize_closure2(t0) {
      this.canonicalUrl = t0;
    },
    ImportCache_humanize_closure3: function ImportCache_humanize_closure3() {
    },
    ImportCache_humanize_closure4: function ImportCache_humanize_closure4() {
    },
    RenderOptions: function RenderOptions() {
    },
    _translateReturnValue(val) {
      if (type$.Future_dynamic._is(val))
        return M.futureToPromise(val, type$.dynamic);
      else
        return val;
    },
    main0() {
      new Uint8Array(0);
      J.set$render$x(self.exports, P.allowInterop(B.node___render$closure()));
      J.set$renderSync$x(self.exports, P.allowInterop(B.node___renderSync$closure()));
      J.set$info$x(self.exports, "dart-sass\t1.42.1\t(Sass Compiler)\t[Dart]\ndart2js\t2.14.2\t(Dart Compiler)\t[Dart]");
      J.set$types$x(self.exports, {Boolean: $.$get$booleanConstructor(), Color: $.$get$colorConstructor(), List: $.$get$listConstructor(), Map: $.$get$mapConstructor(), Null: $.$get$nullConstructor(), Number: $.$get$numberConstructor(), String: $.$get$stringConstructor(), Error: self.Error});
      J.set$NULL$x(self.exports, C.C__SassNull);
      J.set$TRUE$x(self.exports, C.SassBoolean_true);
      J.set$FALSE$x(self.exports, C.SassBoolean_false);
      J.set$cli_pkg_main_0_$x(self.exports, R._wrapMain(U.sass__main$closure()));
    },
    _wrapMain(main) {
      if (type$.dynamic_Function._is(main))
        return P.allowInterop(new R._wrapMain_closure(main));
      else
        return P.allowInterop(new R._wrapMain_closure0(main));
    },
    _Exports: function _Exports() {
    },
    _wrapMain_closure: function _wrapMain_closure(t0) {
      this.main = t0;
    },
    _wrapMain_closure0: function _wrapMain_closure0(t0) {
      this.main = t0;
    },
    UnprefixedMapView0: function UnprefixedMapView0(t0, t1, t2) {
      this._unprefixed_map_view0$_map = t0;
      this._unprefixed_map_view0$_prefix = t1;
      this.$ti = t2;
    },
    _UnprefixedKeys0: function _UnprefixedKeys0(t0) {
      this._unprefixed_map_view0$_view = t0;
    },
    _UnprefixedKeys_iterator_closure1: function _UnprefixedKeys_iterator_closure1(t0) {
      this.$this = t0;
    },
    _UnprefixedKeys_iterator_closure2: function _UnprefixedKeys_iterator_closure2(t0) {
      this.$this = t0;
    }
  },
  S = {VariableExpression: function VariableExpression(t0, t1, t2) {
      this.namespace = t0;
      this.name = t1;
      this.span = t2;
    },
    ComplexSelector$(components, lineBreak) {
      var t1 = P.List_List$unmodifiable(components, type$.ComplexSelectorComponent);
      if (t1.length === 0)
        H.throwExpression(P.ArgumentError$("components may not be empty.", null));
      return new S.ComplexSelector(t1, lineBreak);
    },
    ComplexSelector: function ComplexSelector(t0, t1) {
      var _ = this;
      _.components = t0;
      _.lineBreak = t1;
      _.__ComplexSelector_isInvisible = _._complex$_maxSpecificity = _._minSpecificity = null;
    },
    ComplexSelector_isInvisible_closure: function ComplexSelector_isInvisible_closure() {
    },
    Combinator: function Combinator(t0) {
      this._complex$_text = t0;
    },
    AsyncBuiltInCallable$mixin($name, $arguments, callback, url) {
      return new S.AsyncBuiltInCallable($name, L.ScssParser$("@mixin " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), new S.AsyncBuiltInCallable$mixin_closure(callback));
    },
    AsyncBuiltInCallable: function AsyncBuiltInCallable(t0, t1, t2) {
      this.name = t0;
      this._async_built_in$_arguments = t1;
      this._async_built_in$_callback = t2;
    },
    AsyncBuiltInCallable$mixin_closure: function AsyncBuiltInCallable$mixin_closure(t0) {
      this.callback = t0;
    },
    Extension: function Extension(t0, t1, t2, t3, t4) {
      var _ = this;
      _.extender = t0;
      _.target = t1;
      _.mediaContext = t2;
      _.isOptional = t3;
      _.span = t4;
    },
    Extender: function Extender(t0, t1, t2) {
      var _ = this;
      _.selector = t0;
      _.isOriginal = t1;
      _._extension = null;
      _.span = t2;
    },
    StderrLogger: function StderrLogger(t0) {
      this.color = t0;
    },
    ComplexSassNumber$(value, numeratorUnits, denominatorUnits) {
      var t1 = type$.String;
      return new S.ComplexSassNumber(P.List_List$unmodifiable(numeratorUnits, t1), P.List_List$unmodifiable(denominatorUnits, t1), value, null);
    },
    ComplexSassNumber: function ComplexSassNumber(t0, t1, t2, t3) {
      var _ = this;
      _.numeratorUnits = t0;
      _.denominatorUnits = t1;
      _.value = t2;
      _.asSlash = t3;
    },
    SpanScanner$(string, sourceUrl) {
      var t2,
        t1 = Y.SourceFile$fromString(string, sourceUrl);
      if (sourceUrl == null)
        t2 = null;
      else
        t2 = typeof sourceUrl == "string" ? P.Uri_parse(sourceUrl) : type$.Uri._as(sourceUrl);
      return new S.SpanScanner(t1, t2, string);
    },
    SpanScanner: function SpanScanner(t0, t1, t2) {
      var _ = this;
      _._sourceFile = t0;
      _.sourceUrl = t1;
      _.string = t2;
      _._string_scanner$_position = 0;
      _._lastMatchPosition = _._lastMatch = null;
    },
    _SpanScannerState: function _SpanScannerState(t0, t1) {
      this._scanner = t0;
      this.position = t1;
    },
    Tuple2: function Tuple2(t0, t1, t2) {
      this.item1 = t0;
      this.item2 = t1;
      this.$ti = t2;
    },
    Tuple3: function Tuple3(t0, t1, t2, t3) {
      var _ = this;
      _.item1 = t0;
      _.item2 = t1;
      _.item3 = t2;
      _.$ti = t3;
    },
    AsyncBuiltInCallable$mixin0($name, $arguments, callback, url) {
      return new S.AsyncBuiltInCallable0($name, L.ScssParser$0("@mixin " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), new S.AsyncBuiltInCallable$mixin_closure0(callback));
    },
    AsyncBuiltInCallable0: function AsyncBuiltInCallable0(t0, t1, t2) {
      this.name = t0;
      this._async_built_in0$_arguments = t1;
      this._async_built_in0$_callback = t2;
    },
    AsyncBuiltInCallable$mixin_closure0: function AsyncBuiltInCallable$mixin_closure0(t0) {
      this.callback = t0;
    },
    ComplexSassNumber$0(value, numeratorUnits, denominatorUnits) {
      var t1 = type$.String;
      return new S.ComplexSassNumber0(P.List_List$unmodifiable(numeratorUnits, t1), P.List_List$unmodifiable(denominatorUnits, t1), value, null);
    },
    ComplexSassNumber0: function ComplexSassNumber0(t0, t1, t2, t3) {
      var _ = this;
      _.numeratorUnits = t0;
      _.denominatorUnits = t1;
      _.value = t2;
      _.asSlash = t3;
    },
    ComplexSelector$0(components, lineBreak) {
      var t1 = P.List_List$unmodifiable(components, type$.ComplexSelectorComponent_2);
      if (t1.length === 0)
        H.throwExpression(P.ArgumentError$("components may not be empty.", null));
      return new S.ComplexSelector0(t1, lineBreak);
    },
    ComplexSelector0: function ComplexSelector0(t0, t1) {
      var _ = this;
      _.components = t0;
      _.lineBreak = t1;
      _._complex0$__ComplexSelector_isInvisible = _._complex0$_maxSpecificity = _._complex0$_minSpecificity = null;
    },
    ComplexSelector_isInvisible_closure0: function ComplexSelector_isInvisible_closure0() {
    },
    Combinator0: function Combinator0(t0) {
      this._complex0$_text = t0;
    },
    Extension0: function Extension0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.extender = t0;
      _.target = t1;
      _.mediaContext = t2;
      _.isOptional = t3;
      _.span = t4;
    },
    Extender0: function Extender0(t0, t1, t2) {
      var _ = this;
      _.selector = t0;
      _.isOriginal = t1;
      _._extension$_extension = null;
      _.span = t2;
    },
    StderrLogger0: function StderrLogger0() {
    },
    VariableExpression0: function VariableExpression0(t0, t1, t2) {
      this.namespace = t0;
      this.name = t1;
      this.span = t2;
    }
  },
  T = {NumberExpression: function NumberExpression(t0, t1, t2) {
      this.value = t0;
      this.unit = t1;
      this.span = t2;
    }, ParenthesizedExpression: function ParenthesizedExpression(t0, t1) {
      this.expression = t0;
      this.span = t1;
    }, SelectorExpression: function SelectorExpression(t0) {
      this.span = t0;
    },
    MixinRule$($name, $arguments, children, span, comment) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new T.MixinRule($name, $arguments, span, t1, t2);
    },
    MixinRule: function MixinRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.__MixinRule_hasContent = null;
      _.name = t0;
      _.$arguments = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    _HasContentVisitor: function _HasContentVisitor() {
    },
    UseRule: function UseRule(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.namespace = t1;
      _.configuration = t2;
      _.span = t3;
    },
    Selector: function Selector() {
    },
    _prependParent(compound) {
      var t2, _null = null,
        t1 = compound.components,
        first = C.JSArray_methods.get$first(t1);
      if (first instanceof N.UniversalSelector)
        return _null;
      if (first instanceof F.TypeSelector) {
        t2 = first.name;
        if (t2.namespace != null)
          return _null;
        t2 = H._setArrayType([new M.ParentSelector(t2.name)], type$.JSArray_SimpleSelector);
        C.JSArray_methods.addAll$1(t2, H.SubListIterable$(t1, 1, _null, H._arrayInstanceType(t1)._precomputed1));
        return X.CompoundSelector$(t2);
      } else {
        t2 = H._setArrayType([new M.ParentSelector(_null)], type$.JSArray_SimpleSelector);
        C.JSArray_methods.addAll$1(t2, t1);
        return X.CompoundSelector$(t2);
      }
    },
    _function0($name, $arguments, callback) {
      return Q.BuiltInCallable$function($name, $arguments, callback, "sass:selector");
    },
    _nest_closure: function _nest_closure() {
    },
    _nest__closure: function _nest__closure(t0) {
      this._box_0 = t0;
    },
    _nest__closure0: function _nest__closure0() {
    },
    _append_closure: function _append_closure() {
    },
    _append__closure: function _append__closure() {
    },
    _append__closure0: function _append__closure0() {
    },
    _append___closure: function _append___closure(t0) {
      this.parent = t0;
    },
    _extend_closure: function _extend_closure() {
    },
    _replace_closure: function _replace_closure() {
    },
    _unify_closure: function _unify_closure() {
    },
    _isSuperselector_closure: function _isSuperselector_closure() {
    },
    _simpleSelectors_closure: function _simpleSelectors_closure() {
    },
    _simpleSelectors__closure: function _simpleSelectors__closure() {
    },
    _parse_closure: function _parse_closure() {
    },
    TrackingLogger: function TrackingLogger(t0) {
      this._tracking$_logger = t0;
      this._emittedDebug = this._emittedWarning = false;
    },
    SelectorParser$(contents, allowParent, allowPlaceholder, logger, url) {
      var t1 = S.SpanScanner$(contents, url);
      return new T.SelectorParser(allowParent, allowPlaceholder, t1, logger == null ? C.StderrLogger_false : logger);
    },
    SelectorParser: function SelectorParser(t0, t1, t2, t3) {
      var _ = this;
      _._allowParent = t0;
      _._allowPlaceholder = t1;
      _.scanner = t2;
      _.logger = t3;
    },
    SelectorParser_parse_closure: function SelectorParser_parse_closure(t0) {
      this.$this = t0;
    },
    SelectorParser_parseCompoundSelector_closure: function SelectorParser_parseCompoundSelector_closure(t0) {
      this.$this = t0;
    },
    SassNumber_SassNumber(value, unit) {
      return unit == null ? new N.UnitlessSassNumber(value, null) : new L.SingleUnitSassNumber(unit, value, null);
    },
    SassNumber_SassNumber$withUnits(value, denominatorUnits, numeratorUnits) {
      var t1, t2;
      if (denominatorUnits == null || J.get$isEmpty$asx(denominatorUnits)) {
        t1 = J.getInterceptor$asx(numeratorUnits);
        t2 = t1.get$isEmpty(numeratorUnits);
        if (t2)
          return new N.UnitlessSassNumber(value, null);
        else if (t1.get$length(numeratorUnits) === 1)
          return new L.SingleUnitSassNumber(t1.$index(numeratorUnits, 0), value, null);
        else
          return S.ComplexSassNumber$(value, P.List_List$unmodifiable(numeratorUnits, type$.String), C.List_empty);
      } else {
        t1 = J.get$isEmpty$asx(numeratorUnits);
        t1 = t1 ? C.List_empty : P.List_List$unmodifiable(numeratorUnits, type$.String);
        return S.ComplexSassNumber$(value, t1, P.List_List$unmodifiable(denominatorUnits, type$.String));
      }
    },
    SassNumber: function SassNumber() {
    },
    SassNumber__coerceOrConvertValue__compatibilityException: function SassNumber__coerceOrConvertValue__compatibilityException(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.other = t1;
      _.otherName = t2;
      _.otherHasUnits = t3;
      _.name = t4;
      _.newNumerators = t5;
      _.newDenominators = t6;
    },
    SassNumber__coerceOrConvertValue_closure: function SassNumber__coerceOrConvertValue_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.newNumerator = t2;
    },
    SassNumber__coerceOrConvertValue_closure0: function SassNumber__coerceOrConvertValue_closure0(t0) {
      this._compatibilityException = t0;
    },
    SassNumber__coerceOrConvertValue_closure1: function SassNumber__coerceOrConvertValue_closure1(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.newDenominator = t2;
    },
    SassNumber__coerceOrConvertValue_closure2: function SassNumber__coerceOrConvertValue_closure2(t0) {
      this._compatibilityException = t0;
    },
    SassNumber_plus_closure: function SassNumber_plus_closure() {
    },
    SassNumber_minus_closure: function SassNumber_minus_closure() {
    },
    SassNumber_multiplyUnits_closure: function SassNumber_multiplyUnits_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.numerator = t2;
    },
    SassNumber_multiplyUnits_closure0: function SassNumber_multiplyUnits_closure0(t0, t1) {
      this.newNumerators = t0;
      this.numerator = t1;
    },
    SassNumber_multiplyUnits_closure1: function SassNumber_multiplyUnits_closure1(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.numerator = t2;
    },
    SassNumber_multiplyUnits_closure2: function SassNumber_multiplyUnits_closure2(t0, t1) {
      this.newNumerators = t0;
      this.numerator = t1;
    },
    SassNumber__areAnyConvertible_closure: function SassNumber__areAnyConvertible_closure(t0) {
      this.units2 = t0;
    },
    SassNumber__canonicalizeUnitList_closure: function SassNumber__canonicalizeUnitList_closure() {
    },
    SassNumber__canonicalMultiplier_closure: function SassNumber__canonicalMultiplier_closure(t0) {
      this.$this = t0;
    },
    SingleMapping_SingleMapping$fromEntries(entries) {
      var lines, t1, t2, urls, names, files, targetEntries, t3, t4, lineNum, _i, sourceEntry, t5, t6, sourceUrl, t7, urlId,
        sourceEntries = J.toList$0$ax(entries);
      C.JSArray_methods.sort$0(sourceEntries);
      lines = H._setArrayType([], type$.JSArray_TargetLineEntry);
      t1 = type$.String;
      t2 = type$.int;
      urls = P.LinkedHashMap_LinkedHashMap$_empty(t1, t2);
      names = P.LinkedHashMap_LinkedHashMap$_empty(t1, t2);
      files = P.LinkedHashMap_LinkedHashMap$_empty(t2, type$.SourceFile);
      targetEntries = H._Cell$();
      for (t2 = sourceEntries.length, t3 = type$.JSArray_TargetEntry, t4 = targetEntries.__late_helper$_name, lineNum = null, _i = 0; _i < sourceEntries.length; sourceEntries.length === t2 || (0, H.throwConcurrentModificationError)(sourceEntries), ++_i) {
        sourceEntry = sourceEntries[_i];
        if (lineNum == null || sourceEntry.target.line > lineNum) {
          lineNum = sourceEntry.target.line;
          t5 = H._setArrayType([], t3);
          targetEntries._value = t5;
          lines.push(new T.TargetLineEntry(lineNum, t5));
        }
        t5 = sourceEntry.source;
        t6 = t5.file;
        sourceUrl = t6.url;
        t7 = sourceUrl == null ? "" : sourceUrl.toString$0(0);
        urlId = urls.putIfAbsent$2(t7, new T.SingleMapping_SingleMapping$fromEntries_closure(urls));
        files.putIfAbsent$2(urlId, new T.SingleMapping_SingleMapping$fromEntries_closure0(sourceEntry));
        t7 = targetEntries._value;
        if (t7 === targetEntries)
          H.throwExpression(H.LateError$localNI(t4));
        t5 = t5.offset;
        J.add$1$ax(t7, new T.TargetEntry(sourceEntry.target.column, urlId, t6.getLine$1(t5), t6.getColumn$1(t5), null));
      }
      t2 = urls.get$values(urls).map$1$1(0, new T.SingleMapping_SingleMapping$fromEntries_closure1(files), type$.nullable_SourceFile).toList$0(0);
      t3 = urls.get$keys(urls).toList$0(0);
      t4 = names.get$keys(names);
      return new T.SingleMapping(t3, P.List_List$of(t4, true, H._instanceType(t4)._eval$1("Iterable.E")), t2, lines, null, P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.dynamic));
    },
    Mapping: function Mapping() {
    },
    SingleMapping: function SingleMapping(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.urls = t0;
      _.names = t1;
      _.files = t2;
      _.lines = t3;
      _.targetUrl = t4;
      _.sourceRoot = null;
      _.extensions = t5;
    },
    SingleMapping_SingleMapping$fromEntries_closure: function SingleMapping_SingleMapping$fromEntries_closure(t0) {
      this.urls = t0;
    },
    SingleMapping_SingleMapping$fromEntries_closure0: function SingleMapping_SingleMapping$fromEntries_closure0(t0) {
      this.sourceEntry = t0;
    },
    SingleMapping_SingleMapping$fromEntries_closure1: function SingleMapping_SingleMapping$fromEntries_closure1(t0) {
      this.files = t0;
    },
    SingleMapping_toJson_closure: function SingleMapping_toJson_closure() {
    },
    SingleMapping_toJson_closure0: function SingleMapping_toJson_closure0(t0) {
      this.result = t0;
    },
    TargetLineEntry: function TargetLineEntry(t0, t1) {
      this.line = t0;
      this.entries = t1;
    },
    TargetEntry: function TargetEntry(t0, t1, t2, t3, t4) {
      var _ = this;
      _.column = t0;
      _.sourceUrlId = t1;
      _.sourceLine = t2;
      _.sourceColumn = t3;
      _.sourceNameId = t4;
    },
    LazyTrace: function LazyTrace(t0) {
      this._thunk = t0;
      this.__LazyTrace__trace = null;
    },
    LazyTrace_terse_closure: function LazyTrace_terse_closure(t0) {
      this.$this = t0;
    },
    MixinRule$0($name, $arguments, children, span, comment) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new T.MixinRule0($name, $arguments, span, t1, t2);
    },
    MixinRule0: function MixinRule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _._mixin_rule$__MixinRule_hasContent = null;
      _.name = t0;
      _.$arguments = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    _HasContentVisitor0: function _HasContentVisitor0() {
    },
    NumberExpression0: function NumberExpression0(t0, t1, t2) {
      this.value = t0;
      this.unit = t1;
      this.span = t2;
    },
    _parseNumber(value, unit) {
      var invalidUnit, operands, t1, numerator, denominator, numeratorUnits, denominatorUnits;
      if (unit == null || unit.length === 0)
        return new N.UnitlessSassNumber0(value, null);
      if (!J.contains$1$asx(unit, "*") && !C.JSString_methods.contains$1(unit, "/"))
        return new L.SingleUnitSassNumber0(unit, value, null);
      invalidUnit = new P.ArgumentError(true, unit, "unit", "is invalid.");
      operands = unit.split("/");
      t1 = operands.length;
      if (t1 > 2)
        throw H.wrapException(invalidUnit);
      numerator = operands[0];
      denominator = t1 === 1 ? null : operands[1];
      t1 = type$.JSArray_String;
      numeratorUnits = numerator.length === 0 ? H._setArrayType([], t1) : H._setArrayType(numerator.split("*"), t1);
      if (C.JSArray_methods.any$1(numeratorUnits, new T._parseNumber_closure()))
        throw H.wrapException(invalidUnit);
      denominatorUnits = denominator == null ? H._setArrayType([], t1) : H._setArrayType(denominator.split("*"), t1);
      if (C.JSArray_methods.any$1(denominatorUnits, new T._parseNumber_closure0()))
        throw H.wrapException(invalidUnit);
      return T.SassNumber_SassNumber$withUnits0(value, denominatorUnits, numeratorUnits);
    },
    _NodeSassNumber: function _NodeSassNumber() {
    },
    numberConstructor_closure: function numberConstructor_closure() {
    },
    numberConstructor_closure0: function numberConstructor_closure0() {
    },
    numberConstructor_closure1: function numberConstructor_closure1() {
    },
    numberConstructor_closure2: function numberConstructor_closure2() {
    },
    numberConstructor_closure3: function numberConstructor_closure3() {
    },
    numberConstructor_closure4: function numberConstructor_closure4() {
    },
    _parseNumber_closure: function _parseNumber_closure() {
    },
    _parseNumber_closure0: function _parseNumber_closure0() {
    },
    SassNumber_SassNumber0(value, unit) {
      return unit == null ? new N.UnitlessSassNumber0(value, null) : new L.SingleUnitSassNumber0(unit, value, null);
    },
    SassNumber_SassNumber$withUnits0(value, denominatorUnits, numeratorUnits) {
      var t1, t2;
      if (denominatorUnits == null || J.get$isEmpty$asx(denominatorUnits)) {
        t1 = J.getInterceptor$asx(numeratorUnits);
        t2 = t1.get$isEmpty(numeratorUnits);
        if (t2)
          return new N.UnitlessSassNumber0(value, null);
        else if (t1.get$length(numeratorUnits) === 1)
          return new L.SingleUnitSassNumber0(t1.$index(numeratorUnits, 0), value, null);
        else
          return S.ComplexSassNumber$0(value, P.List_List$unmodifiable(numeratorUnits, type$.String), C.List_empty);
      } else {
        t1 = J.get$isEmpty$asx(numeratorUnits);
        t1 = t1 ? C.List_empty : P.List_List$unmodifiable(numeratorUnits, type$.String);
        return S.ComplexSassNumber$0(value, t1, P.List_List$unmodifiable(denominatorUnits, type$.String));
      }
    },
    SassNumber0: function SassNumber0() {
    },
    SassNumber__coerceOrConvertValue__compatibilityException0: function SassNumber__coerceOrConvertValue__compatibilityException0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.other = t1;
      _.otherName = t2;
      _.otherHasUnits = t3;
      _.name = t4;
      _.newNumerators = t5;
      _.newDenominators = t6;
    },
    SassNumber__coerceOrConvertValue_closure3: function SassNumber__coerceOrConvertValue_closure3(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.newNumerator = t2;
    },
    SassNumber__coerceOrConvertValue_closure4: function SassNumber__coerceOrConvertValue_closure4(t0) {
      this._compatibilityException = t0;
    },
    SassNumber__coerceOrConvertValue_closure5: function SassNumber__coerceOrConvertValue_closure5(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.newDenominator = t2;
    },
    SassNumber__coerceOrConvertValue_closure6: function SassNumber__coerceOrConvertValue_closure6(t0) {
      this._compatibilityException = t0;
    },
    SassNumber_plus_closure0: function SassNumber_plus_closure0() {
    },
    SassNumber_minus_closure0: function SassNumber_minus_closure0() {
    },
    SassNumber_multiplyUnits_closure3: function SassNumber_multiplyUnits_closure3(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.numerator = t2;
    },
    SassNumber_multiplyUnits_closure4: function SassNumber_multiplyUnits_closure4(t0, t1) {
      this.newNumerators = t0;
      this.numerator = t1;
    },
    SassNumber_multiplyUnits_closure5: function SassNumber_multiplyUnits_closure5(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.numerator = t2;
    },
    SassNumber_multiplyUnits_closure6: function SassNumber_multiplyUnits_closure6(t0, t1) {
      this.newNumerators = t0;
      this.numerator = t1;
    },
    SassNumber__areAnyConvertible_closure0: function SassNumber__areAnyConvertible_closure0(t0) {
      this.units2 = t0;
    },
    SassNumber__canonicalizeUnitList_closure0: function SassNumber__canonicalizeUnitList_closure0() {
    },
    SassNumber__canonicalMultiplier_closure0: function SassNumber__canonicalMultiplier_closure0(t0) {
      this.$this = t0;
    },
    ParenthesizedExpression0: function ParenthesizedExpression0(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    Selector0: function Selector0() {
    },
    SelectorExpression0: function SelectorExpression0(t0) {
      this.span = t0;
    },
    _prependParent0(compound) {
      var t2, _null = null,
        t1 = compound.components,
        first = C.JSArray_methods.get$first(t1);
      if (first instanceof N.UniversalSelector0)
        return _null;
      if (first instanceof F.TypeSelector0) {
        t2 = first.name;
        if (t2.namespace != null)
          return _null;
        t2 = H._setArrayType([new M.ParentSelector0(t2.name)], type$.JSArray_SimpleSelector_2);
        C.JSArray_methods.addAll$1(t2, H.SubListIterable$(t1, 1, _null, H._arrayInstanceType(t1)._precomputed1));
        return X.CompoundSelector$0(t2);
      } else {
        t2 = H._setArrayType([new M.ParentSelector0(_null)], type$.JSArray_SimpleSelector_2);
        C.JSArray_methods.addAll$1(t2, t1);
        return X.CompoundSelector$0(t2);
      }
    },
    _function7($name, $arguments, callback) {
      return Q.BuiltInCallable$function0($name, $arguments, callback, "sass:selector");
    },
    _nest_closure0: function _nest_closure0() {
    },
    _nest__closure1: function _nest__closure1(t0) {
      this._box_0 = t0;
    },
    _nest__closure2: function _nest__closure2() {
    },
    _append_closure1: function _append_closure1() {
    },
    _append__closure1: function _append__closure1() {
    },
    _append__closure2: function _append__closure2() {
    },
    _append___closure0: function _append___closure0(t0) {
      this.parent = t0;
    },
    _extend_closure0: function _extend_closure0() {
    },
    _replace_closure0: function _replace_closure0() {
    },
    _unify_closure0: function _unify_closure0() {
    },
    _isSuperselector_closure0: function _isSuperselector_closure0() {
    },
    _simpleSelectors_closure0: function _simpleSelectors_closure0() {
    },
    _simpleSelectors__closure0: function _simpleSelectors__closure0() {
    },
    _parse_closure0: function _parse_closure0() {
    },
    SelectorParser$0(contents, allowParent, allowPlaceholder, logger, url) {
      var t1 = S.SpanScanner$(contents, url);
      return new T.SelectorParser0(allowParent, allowPlaceholder, t1, logger == null ? C.C_StderrLogger : logger);
    },
    SelectorParser0: function SelectorParser0(t0, t1, t2, t3) {
      var _ = this;
      _._selector$_allowParent = t0;
      _._selector$_allowPlaceholder = t1;
      _.scanner = t2;
      _.logger = t3;
    },
    SelectorParser_parse_closure0: function SelectorParser_parse_closure0(t0) {
      this.$this = t0;
    },
    SelectorParser_parseCompoundSelector_closure0: function SelectorParser_parseCompoundSelector_closure0(t0) {
      this.$this = t0;
    },
    UseRule0: function UseRule0(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.namespace = t1;
      _.configuration = t2;
      _.span = t3;
    },
    isWhitespace(character) {
      return character === 32 || character === 9 || character === 10 || character === 13 || character === 12;
    },
    isNewline(character) {
      return character === 10 || character === 13 || character === 12;
    },
    isAlphabetic0(character) {
      var t1;
      if (!(character >= 97 && character <= 122))
        t1 = character >= 65 && character <= 90;
      else
        t1 = true;
      return t1;
    },
    isDigit(character) {
      return character != null && character >= 48 && character <= 57;
    },
    isHex(character) {
      if (character == null)
        return false;
      if (T.isDigit(character))
        return true;
      if (character >= 97 && character <= 102)
        return true;
      if (character >= 65 && character <= 70)
        return true;
      return false;
    },
    asHex(character) {
      if (character <= 57)
        return character - 48;
      if (character <= 70)
        return 10 + character - 65;
      return 10 + character - 97;
    },
    hexCharFor(number) {
      return number < 10 ? 48 + number : 87 + number;
    },
    opposite(character) {
      switch (character) {
        case 40:
          return 41;
        case 123:
          return 125;
        case 91:
          return 93;
        default:
          throw H.wrapException(P.ArgumentError$('"' + P.String_String$fromCharCode(character) + "\" isn't a brace-like character.", null));
      }
    },
    characterEqualsIgnoreCase(character1, character2) {
      var upperCase1;
      if (character1 === character2)
        return true;
      if ((character1 ^ character2) >>> 0 !== 32)
        return false;
      upperCase1 = (character1 & 4294967263) >>> 0;
      return upperCase1 >= 65 && upperCase1 <= 90;
    },
    fuzzyHashCode(number) {
      return number == 1 / 0 || number == -1 / 0 || isNaN(number) ? C.JSNumber_methods.get$hashCode(number) : C.JSInt_methods.get$hashCode(C.JSNumber_methods.round$0(number * $.$get$_inverseEpsilon()));
    },
    fuzzyLessThan(number1, number2) {
      return number1 < number2 && !(Math.abs(number1 - number2) < $.$get$epsilon());
    },
    fuzzyLessThanOrEquals(number1, number2) {
      return number1 < number2 || Math.abs(number1 - number2) < $.$get$epsilon();
    },
    fuzzyGreaterThan(number1, number2) {
      return number1 > number2 && !(Math.abs(number1 - number2) < $.$get$epsilon());
    },
    fuzzyGreaterThanOrEquals(number1, number2) {
      return number1 > number2 || Math.abs(number1 - number2) < $.$get$epsilon();
    },
    fuzzyIsInt(number) {
      if (number == 1 / 0 || number == -1 / 0 || isNaN(number))
        return false;
      if (H._isInt(number))
        return true;
      return Math.abs(C.JSNumber_methods.$mod(Math.abs(number - 0.5), 1) - 0.5) < $.$get$epsilon();
    },
    fuzzyRound(number) {
      var t1;
      if (number > 0) {
        t1 = C.JSNumber_methods.$mod(number, 1);
        return t1 < 0.5 && !(Math.abs(t1 - 0.5) < $.$get$epsilon()) ? C.JSNumber_methods.floor$0(number) : C.JSNumber_methods.ceil$0(number);
      } else {
        t1 = C.JSNumber_methods.$mod(number, 1);
        return t1 < 0.5 || Math.abs(t1 - 0.5) < $.$get$epsilon() ? C.JSNumber_methods.floor$0(number) : C.JSNumber_methods.ceil$0(number);
      }
    },
    fuzzyCheckRange(number, min, max) {
      var t1 = $.$get$epsilon();
      if (Math.abs(number - min) < t1)
        return min;
      if (Math.abs(number - max) < t1)
        return max;
      if (number > min && number < max)
        return number;
      return null;
    },
    fuzzyAssertRange(number, min, max, $name) {
      var result = T.fuzzyCheckRange(number, min, max);
      if (result != null)
        return result;
      throw H.wrapException(P.RangeError$range(number, min, max, $name, "must be between " + min + " and " + max));
    },
    isWhitespace0(character) {
      return character === 32 || character === 9 || character === 10 || character === 13 || character === 12;
    },
    isNewline0(character) {
      return character === 10 || character === 13 || character === 12;
    },
    isAlphabetic1(character) {
      var t1;
      if (!(character >= 97 && character <= 122))
        t1 = character >= 65 && character <= 90;
      else
        t1 = true;
      return t1;
    },
    isDigit0(character) {
      return character != null && character >= 48 && character <= 57;
    },
    isHex0(character) {
      if (character == null)
        return false;
      if (T.isDigit0(character))
        return true;
      if (character >= 97 && character <= 102)
        return true;
      if (character >= 65 && character <= 70)
        return true;
      return false;
    },
    asHex0(character) {
      if (character <= 57)
        return character - 48;
      if (character <= 70)
        return 10 + character - 65;
      return 10 + character - 97;
    },
    hexCharFor0(number) {
      return number < 10 ? 48 + number : 87 + number;
    },
    opposite0(character) {
      switch (character) {
        case 40:
          return 41;
        case 123:
          return 125;
        case 91:
          return 93;
        default:
          throw H.wrapException(P.ArgumentError$('"' + P.String_String$fromCharCode(character) + "\" isn't a brace-like character.", null));
      }
    },
    characterEqualsIgnoreCase0(character1, character2) {
      var upperCase1;
      if (character1 === character2)
        return true;
      if ((character1 ^ character2) >>> 0 !== 32)
        return false;
      upperCase1 = (character1 & 4294967263) >>> 0;
      return upperCase1 >= 65 && upperCase1 <= 90;
    },
    fuzzyHashCode0(number) {
      return number == 1 / 0 || number == -1 / 0 || isNaN(number) ? C.JSNumber_methods.get$hashCode(number) : C.JSInt_methods.get$hashCode(C.JSNumber_methods.round$0(number * $.$get$_inverseEpsilon0()));
    },
    fuzzyLessThan0(number1, number2) {
      return number1 < number2 && !(Math.abs(number1 - number2) < $.$get$epsilon0());
    },
    fuzzyLessThanOrEquals0(number1, number2) {
      return number1 < number2 || Math.abs(number1 - number2) < $.$get$epsilon0();
    },
    fuzzyGreaterThan0(number1, number2) {
      return number1 > number2 && !(Math.abs(number1 - number2) < $.$get$epsilon0());
    },
    fuzzyGreaterThanOrEquals0(number1, number2) {
      return number1 > number2 || Math.abs(number1 - number2) < $.$get$epsilon0();
    },
    fuzzyIsInt0(number) {
      if (number == 1 / 0 || number == -1 / 0 || isNaN(number))
        return false;
      if (H._isInt(number))
        return true;
      return Math.abs(C.JSNumber_methods.$mod(Math.abs(number - 0.5), 1) - 0.5) < $.$get$epsilon0();
    },
    fuzzyRound0(number) {
      var t1;
      if (number > 0) {
        t1 = C.JSNumber_methods.$mod(number, 1);
        return t1 < 0.5 && !(Math.abs(t1 - 0.5) < $.$get$epsilon0()) ? C.JSNumber_methods.floor$0(number) : C.JSNumber_methods.ceil$0(number);
      } else {
        t1 = C.JSNumber_methods.$mod(number, 1);
        return t1 < 0.5 || Math.abs(t1 - 0.5) < $.$get$epsilon0() ? C.JSNumber_methods.floor$0(number) : C.JSNumber_methods.ceil$0(number);
      }
    },
    fuzzyCheckRange0(number, min, max) {
      var t1 = $.$get$epsilon0();
      if (Math.abs(number - min) < t1)
        return min;
      if (Math.abs(number - max) < t1)
        return max;
      if (number > min && number < max)
        return number;
      return null;
    },
    fuzzyAssertRange0(number, min, max, $name) {
      var result = T.fuzzyCheckRange0(number, min, max);
      if (result != null)
        return result;
      throw H.wrapException(P.RangeError$range(number, min, max, $name, "must be between " + min + " and " + max));
    }
  },
  U = {DefaultEquality: function DefaultEquality() {
    }, IterableEquality: function IterableEquality() {
    }, ListEquality: function ListEquality() {
    }, _MapEntry: function _MapEntry(t0, t1, t2) {
      this.equality = t0;
      this.key = t1;
      this.value = t2;
    }, MapEquality: function MapEquality() {
    },
    ModifiableCssAtRule$($name, span, childless, value) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new U.ModifiableCssAtRule($name, value, childless, span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssAtRule: function ModifiableCssAtRule(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.isChildless = t2;
      _.span = t3;
      _.children = t4;
      _._children = t5;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssKeyframeBlock$(selector, span) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new U.ModifiableCssKeyframeBlock(selector, span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssKeyframeBlock: function ModifiableCssKeyframeBlock(t0, t1, t2, t3) {
      var _ = this;
      _.selector = t0;
      _.span = t1;
      _.children = t2;
      _._children = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    AtRule$($name, span, children, value) {
      var t1 = children == null ? null : P.List_List$unmodifiable(children, type$.Statement),
        t2 = t1 == null ? null : C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new U.AtRule($name, value, span, t1, t2 === true);
    },
    AtRule: function AtRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    SupportsOperation: function SupportsOperation(t0, t1, t2, t3) {
      var _ = this;
      _.left = t0;
      _.right = t1;
      _.operator = t2;
      _.span = t3;
    },
    _compileStylesheet(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset) {
      var serializeResult = N.serialize(R._EvaluateVisitor$(functions, importCache, logger, nodeImporter, quietDeps, sourceMap).run$2(0, importer, stylesheet).stylesheet, charset, indentWidth, false, lineFeed, sourceMap, style, true),
        resultSourceMap = serializeResult.sourceMap;
      if (resultSourceMap != null && true)
        B.mapInPlace(resultSourceMap.urls, new U._compileStylesheet_closure(stylesheet, importCache));
      return new U.CompileResult(serializeResult);
    },
    _compileStylesheet_closure: function _compileStylesheet_closure(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    CompileResult: function CompileResult(t0) {
      this._serialize = t0;
    },
    SassParser: function SassParser(t0, t1, t2) {
      var _ = this;
      _._currentIndentation = 0;
      _._spaces = _._nextIndentationEnd = _._nextIndentation = null;
      _._isUseAllowed = true;
      _._inParentheses = _._inStyleRule = _._stylesheet$_inUnknownAtRule = _._inControlDirective = _._inContentBlock = _._stylesheet$_inMixin = false;
      _._globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
    },
    SassParser_children_closure: function SassParser_children_closure(t0, t1, t2) {
      this.$this = t0;
      this.child = t1;
      this.children = t2;
    },
    MultiDirWatcher: function MultiDirWatcher(t0, t1, t2) {
      this._watchers = t0;
      this._group = t1;
      this._poll = t2;
    },
    PublicMemberMapView: function PublicMemberMapView(t0, t1) {
      this._public_member_map_view$_inner = t0;
      this.$ti = t1;
    },
    Highlighter$(span, color) {
      var t1 = U.Highlighter__collateLines(H._setArrayType([U._Highlight$(span, null, true)], type$.JSArray__Highlight)),
        t2 = new U.Highlighter_closure(color).call$0(),
        t3 = C.JSInt_methods.toString$0(C.JSArray_methods.get$last(t1).number + 1),
        t4 = U.Highlighter__contiguous(t1) ? 0 : 3,
        t5 = H._arrayInstanceType(t1);
      return new U.Highlighter(t1, t2, null, 1 + Math.max(t3.length, t4), new H.MappedListIterable(t1, new U.Highlighter$__closure(), t5._eval$1("MappedListIterable<1,int>")).reduce$1(0, C.CONSTANT), !B.isAllTheSame(new H.MappedListIterable(t1, new U.Highlighter$__closure0(), t5._eval$1("MappedListIterable<1,Object?>"))), new P.StringBuffer(""));
    },
    Highlighter$multiple(primarySpan, primaryLabel, secondarySpans, color, primaryColor, secondaryColor) {
      var t2, t3, t4, t5, t6,
        t1 = H._setArrayType([U._Highlight$(primarySpan, primaryLabel, true)], type$.JSArray__Highlight);
      for (t2 = secondarySpans.get$entries(secondarySpans), t2 = t2.get$iterator(t2); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t1.push(U._Highlight$(t3.key, t3.value, false));
      }
      t1 = U.Highlighter__collateLines(t1);
      if (color)
        t2 = "\x1b[31m";
      else
        t2 = null;
      if (color)
        t3 = "\x1b[34m";
      else
        t3 = null;
      t4 = C.JSInt_methods.toString$0(C.JSArray_methods.get$last(t1).number + 1);
      t5 = U.Highlighter__contiguous(t1) ? 0 : 3;
      t6 = H._arrayInstanceType(t1);
      return new U.Highlighter(t1, t2, t3, 1 + Math.max(t4.length, t5), new H.MappedListIterable(t1, new U.Highlighter$__closure(), t6._eval$1("MappedListIterable<1,int>")).reduce$1(0, C.CONSTANT), !B.isAllTheSame(new H.MappedListIterable(t1, new U.Highlighter$__closure0(), t6._eval$1("MappedListIterable<1,Object?>"))), new P.StringBuffer(""));
    },
    Highlighter__contiguous(lines) {
      var i, thisLine, nextLine;
      for (i = 0; i < lines.length - 1;) {
        thisLine = lines[i];
        ++i;
        nextLine = lines[i];
        if (thisLine.number + 1 !== nextLine.number && J.$eq$(thisLine.url, nextLine.url))
          return false;
      }
      return true;
    },
    Highlighter__collateLines(highlights) {
      var t1, t2,
        highlightsByUrl = Y.groupBy(highlights, new U.Highlighter__collateLines_closure(), type$._Highlight, type$.nullable_Uri);
      for (t1 = highlightsByUrl.get$values(highlightsByUrl), t1 = t1.get$iterator(t1); t1.moveNext$0();)
        J.sort$1$ax(t1.get$current(t1), new U.Highlighter__collateLines_closure0());
      t1 = highlightsByUrl.get$values(highlightsByUrl);
      t2 = H._instanceType(t1)._eval$1("ExpandIterable<Iterable.E,_Line>");
      return P.List_List$of(new H.ExpandIterable(t1, new U.Highlighter__collateLines_closure1(), t2), true, t2._eval$1("Iterable.E"));
    },
    _Highlight$(span, label, primary) {
      return new U._Highlight(new U._Highlight_closure(span).call$0(), primary, label);
    },
    _Highlight__normalizeNewlines(span) {
      var endOffset, t1, i, t2, t3, t4,
        text = span.get$text();
      if (!C.JSString_methods.contains$1(text, "\r\n"))
        return span;
      endOffset = span.get$end(span).get$offset();
      for (t1 = text.length - 1, i = 0; i < t1; ++i)
        if (C.JSString_methods._codeUnitAt$1(text, i) === 13 && C.JSString_methods._codeUnitAt$1(text, i + 1) === 10)
          --endOffset;
      t1 = span.get$start(span);
      t2 = span.get$sourceUrl(span);
      t3 = span.get$end(span).get$line();
      t2 = V.SourceLocation$(endOffset, span.get$end(span).get$column(), t3, t2);
      t3 = H.stringReplaceAllUnchecked(text, "\r\n", "\n");
      t4 = span.get$context(span);
      return X.SourceSpanWithContext$(t1, t2, t3, H.stringReplaceAllUnchecked(t4, "\r\n", "\n"));
    },
    _Highlight__normalizeTrailingNewline(span) {
      var context, text, start, end, t1, t2, t3;
      if (!C.JSString_methods.endsWith$1(span.get$context(span), "\n"))
        return span;
      if (C.JSString_methods.endsWith$1(span.get$text(), "\n\n"))
        return span;
      context = C.JSString_methods.substring$2(span.get$context(span), 0, span.get$context(span).length - 1);
      text = span.get$text();
      start = span.get$start(span);
      end = span.get$end(span);
      if (C.JSString_methods.endsWith$1(span.get$text(), "\n")) {
        t1 = B.findLineStart(span.get$context(span), span.get$text(), span.get$start(span).get$column());
        t1.toString;
        t1 = t1 + span.get$start(span).get$column() + span.get$length(span) === span.get$context(span).length;
      } else
        t1 = false;
      if (t1) {
        text = C.JSString_methods.substring$2(span.get$text(), 0, span.get$text().length - 1);
        if (text.length === 0)
          end = start;
        else {
          t1 = span.get$end(span).get$offset();
          t2 = span.get$sourceUrl(span);
          t3 = span.get$end(span).get$line();
          end = V.SourceLocation$(t1 - 1, U._Highlight__lastLineLength(context), t3 - 1, t2);
          start = span.get$start(span).get$offset() === span.get$end(span).get$offset() ? end : span.get$start(span);
        }
      }
      return X.SourceSpanWithContext$(start, end, text, context);
    },
    _Highlight__normalizeEndOfLine(span) {
      var text, t1, t2, t3, t4;
      if (span.get$end(span).get$column() !== 0)
        return span;
      if (span.get$end(span).get$line() === span.get$start(span).get$line())
        return span;
      text = C.JSString_methods.substring$2(span.get$text(), 0, span.get$text().length - 1);
      t1 = span.get$start(span);
      t2 = span.get$end(span).get$offset();
      t3 = span.get$sourceUrl(span);
      t4 = span.get$end(span).get$line();
      t3 = V.SourceLocation$(t2 - 1, text.length - C.JSString_methods.lastIndexOf$1(text, "\n") - 1, t4 - 1, t3);
      return X.SourceSpanWithContext$(t1, t3, text, C.JSString_methods.endsWith$1(span.get$context(span), "\n") ? C.JSString_methods.substring$2(span.get$context(span), 0, span.get$context(span).length - 1) : span.get$context(span));
    },
    _Highlight__lastLineLength(text) {
      var t1 = text.length;
      if (t1 === 0)
        return 0;
      else if (C.JSString_methods.codeUnitAt$1(text, t1 - 1) === 10)
        return t1 === 1 ? 0 : t1 - C.JSString_methods.lastIndexOf$2(text, "\n", t1 - 2) - 1;
      else
        return t1 - C.JSString_methods.lastIndexOf$1(text, "\n") - 1;
    },
    Highlighter: function Highlighter(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._lines = t0;
      _._primaryColor = t1;
      _._secondaryColor = t2;
      _._paddingBeforeSidebar = t3;
      _._maxMultilineSpans = t4;
      _._multipleFiles = t5;
      _._highlighter$_buffer = t6;
    },
    Highlighter_closure: function Highlighter_closure(t0) {
      this.color = t0;
    },
    Highlighter$__closure: function Highlighter$__closure() {
    },
    Highlighter$___closure: function Highlighter$___closure() {
    },
    Highlighter$__closure0: function Highlighter$__closure0() {
    },
    Highlighter__collateLines_closure: function Highlighter__collateLines_closure() {
    },
    Highlighter__collateLines_closure0: function Highlighter__collateLines_closure0() {
    },
    Highlighter__collateLines_closure1: function Highlighter__collateLines_closure1() {
    },
    Highlighter__collateLines__closure: function Highlighter__collateLines__closure(t0) {
      this.line = t0;
    },
    Highlighter_highlight_closure: function Highlighter_highlight_closure() {
    },
    Highlighter__writeFileStart_closure: function Highlighter__writeFileStart_closure(t0) {
      this.$this = t0;
    },
    Highlighter__writeMultilineHighlights_closure: function Highlighter__writeMultilineHighlights_closure(t0, t1, t2) {
      this.$this = t0;
      this.startLine = t1;
      this.line = t2;
    },
    Highlighter__writeMultilineHighlights_closure0: function Highlighter__writeMultilineHighlights_closure0(t0, t1) {
      this.$this = t0;
      this.highlight = t1;
    },
    Highlighter__writeMultilineHighlights_closure1: function Highlighter__writeMultilineHighlights_closure1(t0) {
      this.$this = t0;
    },
    Highlighter__writeMultilineHighlights_closure2: function Highlighter__writeMultilineHighlights_closure2(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.current = t2;
      _.startLine = t3;
      _.line = t4;
      _.highlight = t5;
      _.endLine = t6;
    },
    Highlighter__writeMultilineHighlights__closure: function Highlighter__writeMultilineHighlights__closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    Highlighter__writeMultilineHighlights__closure0: function Highlighter__writeMultilineHighlights__closure0(t0, t1) {
      this.$this = t0;
      this.vertical = t1;
    },
    Highlighter__writeHighlightedText_closure: function Highlighter__writeHighlightedText_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.text = t1;
      _.startColumn = t2;
      _.endColumn = t3;
    },
    Highlighter__writeIndicator_closure: function Highlighter__writeIndicator_closure(t0, t1, t2) {
      this.$this = t0;
      this.line = t1;
      this.highlight = t2;
    },
    Highlighter__writeIndicator_closure0: function Highlighter__writeIndicator_closure0(t0, t1, t2) {
      this.$this = t0;
      this.line = t1;
      this.highlight = t2;
    },
    Highlighter__writeIndicator_closure1: function Highlighter__writeIndicator_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.coversWholeLine = t1;
      _.line = t2;
      _.highlight = t3;
    },
    Highlighter__writeSidebar_closure: function Highlighter__writeSidebar_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.end = t2;
    },
    _Highlight: function _Highlight(t0, t1, t2) {
      this.span = t0;
      this.isPrimary = t1;
      this.label = t2;
    },
    _Highlight_closure: function _Highlight_closure(t0) {
      this.span = t0;
    },
    _Line: function _Line(t0, t1, t2, t3) {
      var _ = this;
      _.text = t0;
      _.number = t1;
      _.url = t2;
      _.highlights = t3;
    },
    Chain_Chain$parse(chain) {
      var t1, t2,
        _s51_ = string$.x3d_____;
      if (chain.length === 0)
        return new U.Chain(P.List_List$unmodifiable(H._setArrayType([], type$.JSArray_Trace), type$.Trace));
      t1 = $.$get$vmChainGap();
      if (C.JSString_methods.contains$1(chain, t1)) {
        t1 = C.JSString_methods.split$1(chain, t1);
        t2 = H._arrayInstanceType(t1);
        return new U.Chain(P.List_List$unmodifiable(new H.MappedIterable(new H.WhereIterable(t1, new U.Chain_Chain$parse_closure(), t2._eval$1("WhereIterable<1>")), new U.Chain_Chain$parse_closure0(), t2._eval$1("MappedIterable<1,Trace>")), type$.Trace));
      }
      if (!C.JSString_methods.contains$1(chain, _s51_))
        return new U.Chain(P.List_List$unmodifiable(H._setArrayType([Y.Trace_Trace$parse(chain)], type$.JSArray_Trace), type$.Trace));
      return new U.Chain(P.List_List$unmodifiable(new H.MappedListIterable(H._setArrayType(chain.split(_s51_), type$.JSArray_String), new U.Chain_Chain$parse_closure1(), type$.MappedListIterable_String_Trace), type$.Trace));
    },
    Chain: function Chain(t0) {
      this.traces = t0;
    },
    Chain_Chain$parse_closure: function Chain_Chain$parse_closure() {
    },
    Chain_Chain$parse_closure0: function Chain_Chain$parse_closure0() {
    },
    Chain_Chain$parse_closure1: function Chain_Chain$parse_closure1() {
    },
    Chain_toTrace_closure: function Chain_toTrace_closure() {
    },
    Chain_toString_closure0: function Chain_toString_closure0() {
    },
    Chain_toString__closure0: function Chain_toString__closure0() {
    },
    Chain_toString_closure: function Chain_toString_closure(t0) {
      this.longest = t0;
    },
    Chain_toString__closure: function Chain_toString__closure(t0) {
      this.longest = t0;
    },
    ModifiableCssAtRule$0($name, span, childless, value) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode_2);
      return new U.ModifiableCssAtRule0($name, value, childless, span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode_2), t1);
    },
    ModifiableCssAtRule0: function ModifiableCssAtRule0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.isChildless = t2;
      _.span = t3;
      _.children = t4;
      _._node2$_children = t5;
      _._node2$_indexInParent = _._node2$_parent = null;
      _.isGroupEnd = false;
    },
    AtRule$0($name, span, children, value) {
      var t1 = children == null ? null : P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = t1 == null ? null : C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new U.AtRule0($name, value, span, t1, t2 === true);
    },
    AtRule0: function AtRule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    _compileStylesheet1(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset) {
      var evaluateResult = R._EvaluateVisitor$1(functions, importCache, logger, nodeImporter, quietDeps, sourceMap).run$2(0, importer, stylesheet),
        serializeResult = N.serialize0(evaluateResult.stylesheet, charset, indentWidth, false, lineFeed, sourceMap, style, useSpaces),
        resultSourceMap = serializeResult.sourceMap;
      if (resultSourceMap != null && importCache != null)
        B.mapInPlace0(resultSourceMap.urls, new U._compileStylesheet_closure1(stylesheet, importCache));
      return new U.CompileResult0(evaluateResult, serializeResult);
    },
    _compileStylesheet_closure1: function _compileStylesheet_closure1(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    CompileResult0: function CompileResult0(t0, t1) {
      this._evaluate = t0;
      this._compile_result$_serialize = t1;
    },
    ModifiableCssKeyframeBlock$0(selector, span) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode_2);
      return new U.ModifiableCssKeyframeBlock0(selector, span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode_2), t1);
    },
    ModifiableCssKeyframeBlock0: function ModifiableCssKeyframeBlock0(t0, t1, t2, t3) {
      var _ = this;
      _.selector = t0;
      _.span = t1;
      _.children = t2;
      _._node2$_children = t3;
      _._node2$_indexInParent = _._node2$_parent = null;
      _.isGroupEnd = false;
    },
    SupportsOperation0: function SupportsOperation0(t0, t1, t2, t3) {
      var _ = this;
      _.left = t0;
      _.right = t1;
      _.operator = t2;
      _.span = t3;
    },
    PublicMemberMapView0: function PublicMemberMapView0(t0, t1) {
      this._public_member_map_view0$_inner = t0;
      this.$ti = t1;
    },
    RenderResult: function RenderResult() {
    },
    RenderResultStats: function RenderResultStats() {
    },
    main(args) {
      return U.main$body(args);
    },
    main$body(args) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.void),
        $async$returnValue, $async$handler = 2, $async$currentError, $async$next = [], printError, graph, source, destination, error, stackTrace, error0, stackTrace0, path, error1, error2, stackTrace1, buffer, options, t1, t2, t3, exception, _box_0, $async$exception, $async$exception1, $async$temp1;
      var $async$main = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1) {
          $async$currentError = $async$result;
          $async$goto = $async$handler;
        }
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              _box_0 = {};
              _box_0.printedError = false;
              printError = new U.main_printError(_box_0);
              _box_0.options = null;
              $async$handler = 4;
              options = B.ExecutableOptions_ExecutableOptions$parse(args);
              _box_0.options = options;
              t1 = options._options;
              $._glyphs = !(t1.wasParsed$1("unicode") ? H._asBool(t1.$index(0, "unicode")) : $._glyphs !== C.C_AsciiGlyphSet) ? C.C_AsciiGlyphSet : C.C_UnicodeGlyphSet;
              $async$goto = H._asBool(_box_0.options._options.$index(0, "version")) ? 7 : 8;
              break;
            case 7:
              // then
              $async$temp1 = P;
              $async$goto = 9;
              return P._asyncAwait(U._loadVersion(), $async$main);
            case 9:
              // returning from await.
              $async$temp1.print($async$result);
              J.set$exitCode$x(self.process, 0);
              // goto return
              $async$goto = 1;
              break;
            case 8:
              // join
              $async$goto = _box_0.options.get$interactive() ? 10 : 11;
              break;
            case 10:
              // then
              $async$goto = 12;
              return P._asyncAwait(Y.repl(_box_0.options), $async$main);
            case 12:
              // returning from await.
              // goto return
              $async$goto = 1;
              break;
            case 11:
              // join
              t1 = type$.List_String._as(_box_0.options._options.$index(0, "load-path"));
              t2 = _box_0.options;
              t3 = type$.Uri;
              graph = new M.StylesheetGraph(P.LinkedHashMap_LinkedHashMap$_empty(t3, type$.StylesheetNode), R.ImportCache$(t1, H._asBool(t2._options.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(t2.get$color())), P.LinkedHashMap_LinkedHashMap$_empty(t3, type$.DateTime));
              $async$goto = H._asBool(_box_0.options._options.$index(0, "watch")) ? 13 : 14;
              break;
            case 13:
              // then
              $async$goto = 15;
              return P._asyncAwait(A.watch(_box_0.options, graph), $async$main);
            case 15:
              // returning from await.
              // goto return
              $async$goto = 1;
              break;
            case 14:
              // join
              t1 = _box_0.options, t1._ensureSources$0(), t1 = t1._sourcesToDestinations, t1 = J.get$iterator$ax(t1.get$keys(t1));
            case 16:
              // for condition
              if (!t1.moveNext$0()) {
                // goto after for
                $async$goto = 17;
                break;
              }
              source = t1.get$current(t1);
              t2 = _box_0.options;
              t2._ensureSources$0();
              destination = t2._sourcesToDestinations.$index(0, source);
              $async$handler = 19;
              t2 = _box_0.options;
              $async$goto = 22;
              return P._asyncAwait(D.compileStylesheet(t2, graph, source, destination, H._asBool(t2._options.$index(0, "update"))), $async$main);
            case 22:
              // returning from await.
              $async$handler = 4;
              // goto after finally
              $async$goto = 21;
              break;
            case 19:
              // catch
              $async$handler = 18;
              $async$exception = $async$currentError;
              t2 = H.unwrapException($async$exception);
              if (t2 instanceof E.SassException) {
                error = t2;
                stackTrace = H.getTraceFromException($async$exception);
                new U.main_closure(_box_0, destination).call$0();
                t2 = _box_0.options._options;
                if (!t2._parser.options._map.containsKey$1("color"))
                  H.throwExpression(P.ArgumentError$('Could not find an option named "color".', null));
                t2 = t2._parsed.containsKey$1("color") ? H._asBool(t2.$index(0, "color")) : J.$eq$(self.process.stdout.isTTY, true);
                t2 = J.toString$1$color$(error, t2);
                t3 = H._asBool(_box_0.options._options.$index(0, "trace")) ? stackTrace : null;
                printError.call$2(t2, t3);
                if (J.get$exitCode$x(self.process) !== 66)
                  J.set$exitCode$x(self.process, 65);
                if (H._asBool(_box_0.options._options.$index(0, "stop-on-error"))) {
                  // goto return
                  $async$goto = 1;
                  break;
                }
              } else if (t2 instanceof B.FileSystemException) {
                error0 = t2;
                stackTrace0 = H.getTraceFromException($async$exception);
                path = error0.path;
                t2 = path == null ? error0.message : "Error reading " + $.$get$context().relative$2$from(path, null) + ": " + error0.message + ".";
                t3 = H._asBool(_box_0.options._options.$index(0, "trace")) ? stackTrace0 : null;
                printError.call$2(t2, t3);
                J.set$exitCode$x(self.process, 66);
                if (H._asBool(_box_0.options._options.$index(0, "stop-on-error"))) {
                  // goto return
                  $async$goto = 1;
                  break;
                }
              } else
                throw $async$exception;
              // goto after finally
              $async$goto = 21;
              break;
            case 18:
              // uncaught
              // goto catch
              $async$goto = 4;
              break;
            case 21:
              // after finally
              // goto for condition
              $async$goto = 16;
              break;
            case 17:
              // after for
              $async$handler = 2;
              // goto after finally
              $async$goto = 6;
              break;
            case 4:
              // catch
              $async$handler = 3;
              $async$exception1 = $async$currentError;
              t1 = H.unwrapException($async$exception1);
              if (t1 instanceof B.UsageException) {
                error1 = t1;
                P.print(error1.message + "\n");
                P.print("Usage: sass <input.scss> [output.css]\n       sass <input.scss>:<output.css> <input/>:<output/> <dir/>\n");
                t1 = $.$get$ExecutableOptions__parser();
                P.print(new G._Usage(t1._optionsAndSeparators, new P.StringBuffer(""), t1.usageLineLength).generate$0());
                J.set$exitCode$x(self.process, 64);
              } else {
                error2 = t1;
                stackTrace1 = H.getTraceFromException($async$exception1);
                buffer = new P.StringBuffer("");
                t1 = _box_0.options;
                if (t1 != null && t1.get$color())
                  buffer._contents += "\x1b[31m\x1b[1m";
                buffer._contents += "Unexpected exception:";
                t1 = _box_0.options;
                if (t1 != null && t1.get$color())
                  buffer._contents += "\x1b[0m";
                buffer._contents += "\n";
                buffer._contents += H.S(error2) + "\n";
                t1 = buffer._contents;
                printError.call$2(t1.charCodeAt(0) == 0 ? t1 : t1, stackTrace1);
                J.set$exitCode$x(self.process, 255);
              }
              // goto after finally
              $async$goto = 6;
              break;
            case 3:
              // uncaught
              // goto rethrow
              $async$goto = 2;
              break;
            case 6:
              // after finally
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
            case 2:
              // rethrow
              return P._asyncRethrow($async$currentError, $async$completer);
          }
      });
      return P._asyncStartSync($async$main, $async$completer);
    },
    _loadVersion() {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.String),
        $async$returnValue;
      var $async$_loadVersion = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              $async$returnValue = "1.42.1 compiled with dart2js 2.14.2";
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$_loadVersion, $async$completer);
    },
    main_printError: function main_printError(t0) {
      this._box_0 = t0;
    },
    main_closure: function main_closure(t0, t1) {
      this._box_0 = t0;
      this.destination = t1;
    },
    SassParser0: function SassParser0(t0, t1, t2) {
      var _ = this;
      _._sass0$_currentIndentation = 0;
      _._sass0$_spaces = _._sass0$_nextIndentationEnd = _._sass0$_nextIndentation = null;
      _._stylesheet0$_isUseAllowed = true;
      _._stylesheet0$_inParentheses = _._stylesheet0$_inStyleRule = _._stylesheet0$_inUnknownAtRule = _._stylesheet0$_inControlDirective = _._stylesheet0$_inContentBlock = _._stylesheet0$_inMixin = false;
      _._stylesheet0$_globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
    },
    SassParser_children_closure0: function SassParser_children_closure0(t0, t1, t2) {
      this.$this = t0;
      this.child = t1;
      this.children = t2;
    }
  },
  V = {ArgResults: function ArgResults(t0, t1, t2, t3) {
      var _ = this;
      _._parser = t0;
      _._parsed = t1;
      _.name = t2;
      _.rest = t3;
    }, ErrorResult: function ErrorResult(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
    }, BufferModule: function BufferModule() {
    }, BufferConstants: function BufferConstants() {
    }, Buffer: function Buffer() {
    },
    ModifiableCssStylesheet$(span) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new V.ModifiableCssStylesheet(span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssStylesheet: function ModifiableCssStylesheet(t0, t1, t2) {
      var _ = this;
      _.span = t0;
      _.children = t1;
      _._children = t2;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    CssStylesheet: function CssStylesheet(t0, t1) {
      this.children = t0;
      this.span = t1;
    },
    AtRootQuery: function AtRootQuery(t0, t1, t2, t3) {
      var _ = this;
      _.include = t0;
      _.names = t1;
      _._all = t2;
      _._at_root_query$_rule = t3;
    },
    BinaryOperationExpression: function BinaryOperationExpression(t0, t1, t2, t3) {
      var _ = this;
      _.operator = t0;
      _.left = t1;
      _.right = t2;
      _.allowsSlash = t3;
    },
    BinaryOperator: function BinaryOperator(t0, t1, t2) {
      this.name = t0;
      this.operator = t1;
      this.precedence = t2;
    },
    CalculationExpression__verifyArguments($arguments) {
      return P.List_List$unmodifiable(new H.MappedListIterable($arguments, new V.CalculationExpression__verifyArguments_closure(), H._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Expression);
    },
    CalculationExpression__verify(expression) {
      var t1,
        _s29_ = "Invalid calculation argument ";
      if (expression instanceof T.NumberExpression)
        return;
      if (expression instanceof V.CalculationExpression)
        return;
      if (expression instanceof S.VariableExpression)
        return;
      if (expression instanceof F.FunctionExpression)
        return;
      if (expression instanceof L.IfExpression)
        return;
      if (expression instanceof D.StringExpression) {
        if (expression.hasQuotes)
          throw H.wrapException(P.ArgumentError$(_s29_ + expression.toString$0(0) + ".", null));
      } else if (expression instanceof T.ParenthesizedExpression)
        V.CalculationExpression__verify(expression.expression);
      else if (expression instanceof V.BinaryOperationExpression) {
        V.CalculationExpression__verify(expression.left);
        V.CalculationExpression__verify(expression.right);
        t1 = expression.operator;
        if (t1 === C.BinaryOperator_AcR0)
          return;
        if (t1 === C.BinaryOperator_iyO)
          return;
        if (t1 === C.BinaryOperator_O1M)
          return;
        if (t1 === C.BinaryOperator_RTB)
          return;
        throw H.wrapException(P.ArgumentError$(_s29_ + expression.toString$0(0) + ".", null));
      } else
        throw H.wrapException(P.ArgumentError$(_s29_ + expression.toString$0(0) + ".", null));
    },
    CalculationExpression: function CalculationExpression(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.span = t2;
    },
    CalculationExpression__verifyArguments_closure: function CalculationExpression__verifyArguments_closure() {
    },
    AtRootRule$(children, span, query) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new V.AtRootRule(query, span, t1, t2);
    },
    AtRootRule: function AtRootRule(t0, t1, t2, t3) {
      var _ = this;
      _.query = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    EachRule$(variables, list, children, span) {
      var t1 = P.List_List$unmodifiable(variables, type$.String),
        t2 = P.List_List$unmodifiable(children, type$.Statement),
        t3 = C.JSArray_methods.any$1(t2, new M.ParentStatement_closure());
      return new V.EachRule(t1, list, span, t2, t3);
    },
    EachRule: function EachRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.variables = t0;
      _.list = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    EachRule_toString_closure: function EachRule_toString_closure() {
    },
    IfClause$(expression, children) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement);
      return new V.IfClause(expression, t1, C.JSArray_methods.any$1(t1, new V.IfRuleClause$__closure()));
    },
    ElseClause$(children) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement);
      return new V.ElseClause(t1, C.JSArray_methods.any$1(t1, new V.IfRuleClause$__closure()));
    },
    IfRule: function IfRule(t0, t1, t2) {
      this.clauses = t0;
      this.lastClause = t1;
      this.span = t2;
    },
    IfRule_toString_closure: function IfRule_toString_closure(t0) {
      this.first = t0;
    },
    IfRuleClause: function IfRuleClause() {
    },
    IfRuleClause$__closure: function IfRuleClause$__closure() {
    },
    IfRuleClause$___closure: function IfRuleClause$___closure() {
    },
    IfClause: function IfClause(t0, t1, t2) {
      this.expression = t0;
      this.children = t1;
      this.hasDeclarations = t2;
    },
    ElseClause: function ElseClause(t0, t1) {
      this.children = t0;
      this.hasDeclarations = t1;
    },
    Stylesheet$(children, span) {
      var t1 = H._setArrayType([], type$.JSArray_UseRule),
        t2 = H._setArrayType([], type$.JSArray_ForwardRule),
        t3 = P.List_List$unmodifiable(children, type$.Statement),
        t4 = C.JSArray_methods.any$1(t3, new M.ParentStatement_closure());
      t1 = new V.Stylesheet(span, false, t1, t2, t3, t4);
      t1.Stylesheet$internal$3$plainCss(children, span, false);
      return t1;
    },
    Stylesheet$internal(children, span, plainCss) {
      var t1 = H._setArrayType([], type$.JSArray_UseRule),
        t2 = H._setArrayType([], type$.JSArray_ForwardRule),
        t3 = P.List_List$unmodifiable(children, type$.Statement),
        t4 = C.JSArray_methods.any$1(t3, new M.ParentStatement_closure());
      t1 = new V.Stylesheet(span, plainCss, t1, t2, t3, t4);
      t1.Stylesheet$internal$3$plainCss(children, span, plainCss);
      return t1;
    },
    Stylesheet_Stylesheet$parse(contents, syntax, logger, url) {
      var t1, t2;
      switch (syntax) {
        case C.Syntax_Sass:
          t1 = S.SpanScanner$(contents, url);
          t2 = logger == null ? C.StderrLogger_false : logger;
          return new U.SassParser(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.VariableDeclaration), t1, t2).parse$0();
        case C.Syntax_SCSS:
          return L.ScssParser$(contents, logger, url).parse$0();
        case C.Syntax_CSS:
          t1 = S.SpanScanner$(contents, url);
          t2 = logger == null ? C.StderrLogger_false : logger;
          return new Q.CssParser(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.VariableDeclaration), t1, t2).parse$0();
        default:
          throw H.wrapException(P.ArgumentError$("Unknown syntax " + syntax.toString$0(0) + ".", null));
      }
    },
    Stylesheet: function Stylesheet(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.span = t0;
      _.plainCss = t1;
      _._uses = t2;
      _._forwards = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    AtRootQueryParser: function AtRootQueryParser(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    AtRootQueryParser_parse_closure: function AtRootQueryParser_parse_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser: function StylesheetParser() {
    },
    StylesheetParser_parse_closure: function StylesheetParser_parse_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parse__closure: function StylesheetParser_parse__closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parse__closure0: function StylesheetParser_parse__closure0() {
    },
    StylesheetParser_parseArgumentDeclaration_closure: function StylesheetParser_parseArgumentDeclaration_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parseVariableDeclaration_closure: function StylesheetParser_parseVariableDeclaration_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parseUseRule_closure: function StylesheetParser_parseUseRule_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__parseSingleProduction_closure: function StylesheetParser__parseSingleProduction_closure(t0, t1, t2) {
      this.$this = t0;
      this.production = t1;
      this.T = t2;
    },
    StylesheetParser__statement_closure: function StylesheetParser__statement_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_variableDeclarationWithoutNamespace_closure: function StylesheetParser_variableDeclarationWithoutNamespace_closure(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    StylesheetParser_variableDeclarationWithoutNamespace_closure0: function StylesheetParser_variableDeclarationWithoutNamespace_closure0(t0) {
      this.declaration = t0;
    },
    StylesheetParser__declarationOrBuffer_closure: function StylesheetParser__declarationOrBuffer_closure(t0) {
      this.name = t0;
    },
    StylesheetParser__declarationOrBuffer_closure0: function StylesheetParser__declarationOrBuffer_closure0(t0, t1) {
      this._box_0 = t0;
      this.name = t1;
    },
    StylesheetParser__styleRule_closure: function StylesheetParser__styleRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.wasInStyleRule = t2;
      _.start = t3;
    },
    StylesheetParser__propertyOrVariableDeclaration_closure: function StylesheetParser__propertyOrVariableDeclaration_closure(t0) {
      this._box_0 = t0;
    },
    StylesheetParser__propertyOrVariableDeclaration_closure0: function StylesheetParser__propertyOrVariableDeclaration_closure0(t0, t1) {
      this._box_0 = t0;
      this.value = t1;
    },
    StylesheetParser__atRootRule_closure: function StylesheetParser__atRootRule_closure(t0) {
      this.query = t0;
    },
    StylesheetParser__atRootRule_closure0: function StylesheetParser__atRootRule_closure0() {
    },
    StylesheetParser__eachRule_closure: function StylesheetParser__eachRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.wasInControlDirective = t1;
      _.variables = t2;
      _.list = t3;
    },
    StylesheetParser__functionRule_closure: function StylesheetParser__functionRule_closure(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.precedingComment = t2;
    },
    StylesheetParser__forRule_closure: function StylesheetParser__forRule_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser__forRule_closure0: function StylesheetParser__forRule_closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.wasInControlDirective = t2;
      _.variable = t3;
      _.from = t4;
      _.to = t5;
    },
    StylesheetParser__memberList_closure: function StylesheetParser__memberList_closure(t0, t1, t2) {
      this.$this = t0;
      this.variables = t1;
      this.identifiers = t2;
    },
    StylesheetParser__includeRule_closure: function StylesheetParser__includeRule_closure(t0) {
      this.contentArguments_ = t0;
    },
    StylesheetParser_mediaRule_closure: function StylesheetParser_mediaRule_closure(t0) {
      this.query = t0;
    },
    StylesheetParser__mixinRule_closure: function StylesheetParser__mixinRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.name = t1;
      _.$arguments = t2;
      _.precedingComment = t3;
    },
    StylesheetParser_mozDocumentRule_closure: function StylesheetParser_mozDocumentRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.name = t2;
      _.value = t3;
    },
    StylesheetParser_supportsRule_closure: function StylesheetParser_supportsRule_closure(t0) {
      this.condition = t0;
    },
    StylesheetParser__whileRule_closure: function StylesheetParser__whileRule_closure(t0, t1, t2) {
      this.$this = t0;
      this.wasInControlDirective = t1;
      this.condition = t2;
    },
    StylesheetParser_unknownAtRule_closure: function StylesheetParser_unknownAtRule_closure(t0, t1) {
      this._box_0 = t0;
      this.name = t1;
    },
    StylesheetParser_expression_resetState: function StylesheetParser_expression_resetState(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.start = t2;
    },
    StylesheetParser_expression_resolveOneOperation: function StylesheetParser_expression_resolveOneOperation(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser_expression_resolveOperations: function StylesheetParser_expression_resolveOperations(t0, t1) {
      this._box_0 = t0;
      this.resolveOneOperation = t1;
    },
    StylesheetParser_expression_addSingleExpression: function StylesheetParser_expression_addSingleExpression(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.resetState = t2;
      _.resolveOperations = t3;
    },
    StylesheetParser_expression_addOperator: function StylesheetParser_expression_addOperator(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.resolveOneOperation = t2;
    },
    StylesheetParser_expression_resolveSpaceExpressions: function StylesheetParser_expression_resolveSpaceExpressions(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.resolveOperations = t2;
    },
    StylesheetParser__expressionUntilComma_closure: function StylesheetParser__expressionUntilComma_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__unicodeRange_closure: function StylesheetParser__unicodeRange_closure() {
    },
    StylesheetParser__unicodeRange_closure0: function StylesheetParser__unicodeRange_closure0() {
    },
    StylesheetParser_namespacedExpression_closure: function StylesheetParser_namespacedExpression_closure(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    StylesheetParser_trySpecialFunction_closure: function StylesheetParser_trySpecialFunction_closure() {
    },
    StylesheetParser__expressionUntilComparison_closure: function StylesheetParser__expressionUntilComparison_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__publicIdentifier_closure: function StylesheetParser__publicIdentifier_closure(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    SassCalculation_calc(argument) {
      argument = V.SassCalculation__simplify(argument);
      if (argument instanceof T.SassNumber)
        return argument;
      if (argument instanceof V.SassCalculation)
        return argument;
      return new V.SassCalculation("calc", P.List_List$unmodifiable([argument], type$.Object));
    },
    SassCalculation_min($arguments) {
      var minimum, _i, arg, t2,
        args = P.List_List$unmodifiable(new H.MappedListIterable($arguments, V.calculation_SassCalculation__simplify$closure(), H._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw H.wrapException(P.ArgumentError$("min() must have at least one argument.", null));
      for (minimum = null, _i = 0; _i < t1; ++_i) {
        arg = args[_i];
        if (arg instanceof T.SassNumber)
          t2 = minimum != null && !minimum.isComparableTo$1(arg);
        else
          t2 = true;
        if (t2) {
          minimum = null;
          break;
        } else if (minimum == null || minimum.greaterThan$1(arg).value)
          minimum = arg;
      }
      if (minimum != null)
        return minimum;
      V.SassCalculation__verifyCompatibleNumbers(args);
      return new V.SassCalculation("min", args);
    },
    SassCalculation_max($arguments) {
      var maximum, _i, arg, t2,
        args = P.List_List$unmodifiable(new H.MappedListIterable($arguments, V.calculation_SassCalculation__simplify$closure(), H._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw H.wrapException(P.ArgumentError$("max() must have at least one argument.", null));
      for (maximum = null, _i = 0; _i < t1; ++_i) {
        arg = args[_i];
        if (arg instanceof T.SassNumber)
          t2 = maximum != null && !maximum.isComparableTo$1(arg);
        else
          t2 = true;
        if (t2) {
          maximum = null;
          break;
        } else if (maximum == null || maximum.lessThan$1(arg).value)
          maximum = arg;
      }
      if (maximum != null)
        return maximum;
      V.SassCalculation__verifyCompatibleNumbers(args);
      return new V.SassCalculation("max", args);
    },
    SassCalculation_clamp(min, value, max) {
      var t1, args;
      if (value == null && max != null)
        throw H.wrapException(P.ArgumentError$("If value is null, max must also be null.", null));
      min = V.SassCalculation__simplify(min);
      value = X.NullableExtension_andThen(value, V.calculation_SassCalculation__simplify$closure());
      max = X.NullableExtension_andThen(max, V.calculation_SassCalculation__simplify$closure());
      if (min instanceof T.SassNumber && value instanceof T.SassNumber && max instanceof T.SassNumber && min.hasCompatibleUnits$1(value) && min.hasCompatibleUnits$1(max)) {
        if (value.lessThanOrEquals$1(min).value)
          return min;
        if (value.greaterThanOrEquals$1(max).value)
          return max;
        return value;
      }
      t1 = [min];
      if (value != null)
        t1.push(value);
      if (max != null)
        t1.push(max);
      args = P.List_List$unmodifiable(t1, type$.Object);
      V.SassCalculation__verifyCompatibleNumbers(args);
      V.SassCalculation__verifyLength(args, 3);
      return new V.SassCalculation("clamp", args);
    },
    SassCalculation_operateInternal(operator, left, right, inMinMax) {
      var t1, t2;
      left = V.SassCalculation__simplify(left);
      right = V.SassCalculation__simplify(right);
      t1 = operator === C.CalculationOperator_Iem;
      if (t1 || operator === C.CalculationOperator_uti) {
        if (left instanceof T.SassNumber)
          if (right instanceof T.SassNumber)
            t2 = inMinMax ? left.isComparableTo$1(right) : left.hasCompatibleUnits$1(right);
          else
            t2 = false;
        else
          t2 = false;
        if (t2)
          return t1 ? left.plus$1(right) : left.minus$1(right);
        V.SassCalculation__verifyCompatibleNumbers(H._setArrayType([left, right], type$.JSArray_Object));
        if (right instanceof T.SassNumber) {
          t2 = right.value;
          t2 = t2 < 0 && !(Math.abs(t2 - 0) < $.$get$epsilon());
        } else
          t2 = false;
        if (t2) {
          right = right.times$1(new N.UnitlessSassNumber(-1, null));
          operator = t1 ? C.CalculationOperator_uti : C.CalculationOperator_Iem;
        }
        return new V.CalculationOperation(operator, left, right);
      } else if (left instanceof T.SassNumber && right instanceof T.SassNumber)
        return operator === C.CalculationOperator_Dih ? left.times$1(right) : left.dividedBy$1(right);
      else
        return new V.CalculationOperation(operator, left, right);
    },
    SassCalculation__simplify(arg) {
      var _s32_ = " can't be used in a calculation.";
      if (arg instanceof T.SassNumber || arg instanceof V.CalculationInterpolation || arg instanceof V.CalculationOperation)
        return arg;
      else if (arg instanceof D.SassString) {
        if (!arg.hasQuotes)
          return arg;
        throw H.wrapException(V.SassCalculation__exception("Quoted string " + arg.toString$0(0) + _s32_));
      } else if (arg instanceof V.SassCalculation)
        return arg.name === "calc" ? arg.$arguments[0] : arg;
      else if (arg instanceof F.Value)
        throw H.wrapException(V.SassCalculation__exception("Value " + arg.toString$0(0) + _s32_));
      else
        throw H.wrapException(P.ArgumentError$("Unexpected calculation argument " + H.S(arg) + ".", null));
    },
    SassCalculation__verifyCompatibleNumbers(args) {
      var t1, _i, t2, arg, i, number1, j, number2;
      for (t1 = args.length, _i = 0; t2 = args.length, _i < t2; args.length === t1 || (0, H.throwConcurrentModificationError)(args), ++_i) {
        arg = args[_i];
        if (!(arg instanceof T.SassNumber))
          continue;
        if (J.get$length$asx(arg.get$numeratorUnits()) > 1 || arg.get$denominatorUnits().length !== 0)
          throw H.wrapException(V.SassCalculation__exception("Number " + arg.toString$0(0) + " isn't compatible with CSS calculations."));
      }
      for (t1 = t2, i = 0; i < t1 - 1; ++i) {
        number1 = args[i];
        if (!(number1 instanceof T.SassNumber))
          continue;
        for (j = i + 1; t1 = args.length, j < t1; ++j) {
          number2 = args[j];
          if (!(number2 instanceof T.SassNumber))
            continue;
          if (number1.hasPossiblyCompatibleUnits$1(number2))
            continue;
          throw H.wrapException(V.SassCalculation__exception(number1.toString$0(0) + " and " + number2.toString$0(0) + " are incompatible."));
        }
      }
    },
    SassCalculation__verifyLength(args, expectedLength) {
      var t1 = args.length;
      if (t1 === expectedLength)
        return;
      if (C.JSArray_methods.any$1(args, new V.SassCalculation__verifyLength_closure()))
        return;
      throw H.wrapException(V.SassCalculation__exception("" + expectedLength + " arguments required, but only " + t1 + " " + B.pluralize("was", t1, "were") + " passed."));
    },
    SassCalculation__exception(message) {
      return new E.SassScriptException(message);
    },
    SassCalculation: function SassCalculation(t0, t1) {
      this.name = t0;
      this.$arguments = t1;
    },
    SassCalculation__verifyLength_closure: function SassCalculation__verifyLength_closure() {
    },
    CalculationOperation: function CalculationOperation(t0, t1, t2) {
      this.operator = t0;
      this.left = t1;
      this.right = t2;
    },
    CalculationOperator: function CalculationOperator(t0, t1, t2) {
      this.name = t0;
      this.operator = t1;
      this.precedence = t2;
    },
    CalculationInterpolation: function CalculationInterpolation(t0) {
      this.value = t0;
    },
    cloneCssStylesheet(stylesheet, extensionStore) {
      var result = extensionStore.clone$0();
      return new S.Tuple2(new V._CloneCssVisitor(result.item2)._visitChildren$2(V.ModifiableCssStylesheet$(stylesheet.get$span()), stylesheet), result.item1, type$.Tuple2_ModifiableCssStylesheet_ExtensionStore);
    },
    _CloneCssVisitor: function _CloneCssVisitor(t0) {
      this._oldToNewSelectors = t0;
    },
    SourceLocation$(offset, column, line, sourceUrl) {
      if (offset < 0)
        H.throwExpression(P.RangeError$("Offset may not be negative, was " + offset + "."));
      else if (line < 0)
        H.throwExpression(P.RangeError$("Line may not be negative, was " + line + "."));
      else if (column < 0)
        H.throwExpression(P.RangeError$("Column may not be negative, was " + column + "."));
      return new V.SourceLocation(sourceUrl, offset, line, column);
    },
    SourceLocation: function SourceLocation(t0, t1, t2, t3) {
      var _ = this;
      _.sourceUrl = t0;
      _.offset = t1;
      _.line = t2;
      _.column = t3;
    },
    SourceSpanBase: function SourceSpanBase() {
    },
    AtRootQueryParser0: function AtRootQueryParser0(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    AtRootQueryParser_parse_closure0: function AtRootQueryParser_parse_closure0(t0) {
      this.$this = t0;
    },
    AtRootQuery0: function AtRootQuery0(t0, t1, t2, t3) {
      var _ = this;
      _.include = t0;
      _.names = t1;
      _._at_root_query0$_all = t2;
      _._at_root_query0$_rule = t3;
    },
    AtRootRule$0(children, span, query) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new V.AtRootRule0(query, span, t1, t2);
    },
    AtRootRule0: function AtRootRule0(t0, t1, t2, t3) {
      var _ = this;
      _.query = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    BinaryOperationExpression0: function BinaryOperationExpression0(t0, t1, t2, t3) {
      var _ = this;
      _.operator = t0;
      _.left = t1;
      _.right = t2;
      _.allowsSlash = t3;
    },
    BinaryOperator0: function BinaryOperator0(t0, t1, t2) {
      this.name = t0;
      this.operator = t1;
      this.precedence = t2;
    },
    CalculationExpression__verifyArguments0($arguments) {
      return P.List_List$unmodifiable(new H.MappedListIterable($arguments, new V.CalculationExpression__verifyArguments_closure0(), H._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Expression_2);
    },
    CalculationExpression__verify0(expression) {
      var t1,
        _s29_ = "Invalid calculation argument ";
      if (expression instanceof T.NumberExpression0)
        return;
      if (expression instanceof V.CalculationExpression0)
        return;
      if (expression instanceof S.VariableExpression0)
        return;
      if (expression instanceof F.FunctionExpression0)
        return;
      if (expression instanceof L.IfExpression0)
        return;
      if (expression instanceof D.StringExpression0) {
        if (expression.hasQuotes)
          throw H.wrapException(P.ArgumentError$(_s29_ + expression.toString$0(0) + ".", null));
      } else if (expression instanceof T.ParenthesizedExpression0)
        V.CalculationExpression__verify0(expression.expression);
      else if (expression instanceof V.BinaryOperationExpression0) {
        V.CalculationExpression__verify0(expression.left);
        V.CalculationExpression__verify0(expression.right);
        t1 = expression.operator;
        if (t1 === C.BinaryOperator_AcR2)
          return;
        if (t1 === C.BinaryOperator_iyO0)
          return;
        if (t1 === C.BinaryOperator_O1M0)
          return;
        if (t1 === C.BinaryOperator_RTB0)
          return;
        throw H.wrapException(P.ArgumentError$(_s29_ + expression.toString$0(0) + ".", null));
      } else
        throw H.wrapException(P.ArgumentError$(_s29_ + expression.toString$0(0) + ".", null));
    },
    CalculationExpression0: function CalculationExpression0(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.span = t2;
    },
    CalculationExpression__verifyArguments_closure0: function CalculationExpression__verifyArguments_closure0() {
    },
    SassCalculation_calc0(argument) {
      argument = V.SassCalculation__simplify0(argument);
      if (argument instanceof T.SassNumber0)
        return argument;
      if (argument instanceof V.SassCalculation0)
        return argument;
      return new V.SassCalculation0("calc", P.List_List$unmodifiable([argument], type$.Object));
    },
    SassCalculation_min0($arguments) {
      var minimum, _i, arg, t2,
        args = P.List_List$unmodifiable(new H.MappedListIterable($arguments, V.calculation0_SassCalculation__simplify$closure(), H._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw H.wrapException(P.ArgumentError$("min() must have at least one argument.", null));
      for (minimum = null, _i = 0; _i < t1; ++_i) {
        arg = args[_i];
        if (arg instanceof T.SassNumber0)
          t2 = minimum != null && !minimum.isComparableTo$1(arg);
        else
          t2 = true;
        if (t2) {
          minimum = null;
          break;
        } else if (minimum == null || minimum.greaterThan$1(arg).value)
          minimum = arg;
      }
      if (minimum != null)
        return minimum;
      V.SassCalculation__verifyCompatibleNumbers0(args);
      return new V.SassCalculation0("min", args);
    },
    SassCalculation_max0($arguments) {
      var maximum, _i, arg, t2,
        args = P.List_List$unmodifiable(new H.MappedListIterable($arguments, V.calculation0_SassCalculation__simplify$closure(), H._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw H.wrapException(P.ArgumentError$("max() must have at least one argument.", null));
      for (maximum = null, _i = 0; _i < t1; ++_i) {
        arg = args[_i];
        if (arg instanceof T.SassNumber0)
          t2 = maximum != null && !maximum.isComparableTo$1(arg);
        else
          t2 = true;
        if (t2) {
          maximum = null;
          break;
        } else if (maximum == null || maximum.lessThan$1(arg).value)
          maximum = arg;
      }
      if (maximum != null)
        return maximum;
      V.SassCalculation__verifyCompatibleNumbers0(args);
      return new V.SassCalculation0("max", args);
    },
    SassCalculation_clamp0(min, value, max) {
      var t1, args;
      if (value == null && max != null)
        throw H.wrapException(P.ArgumentError$("If value is null, max must also be null.", null));
      min = V.SassCalculation__simplify0(min);
      value = X.NullableExtension_andThen0(value, V.calculation0_SassCalculation__simplify$closure());
      max = X.NullableExtension_andThen0(max, V.calculation0_SassCalculation__simplify$closure());
      if (min instanceof T.SassNumber0 && value instanceof T.SassNumber0 && max instanceof T.SassNumber0 && min.hasCompatibleUnits$1(value) && min.hasCompatibleUnits$1(max)) {
        if (value.lessThanOrEquals$1(min).value)
          return min;
        if (value.greaterThanOrEquals$1(max).value)
          return max;
        return value;
      }
      t1 = [min];
      if (value != null)
        t1.push(value);
      if (max != null)
        t1.push(max);
      args = P.List_List$unmodifiable(t1, type$.Object);
      V.SassCalculation__verifyCompatibleNumbers0(args);
      V.SassCalculation__verifyLength0(args, 3);
      return new V.SassCalculation0("clamp", args);
    },
    SassCalculation_operateInternal0(operator, left, right, inMinMax) {
      var t1, t2;
      left = V.SassCalculation__simplify0(left);
      right = V.SassCalculation__simplify0(right);
      t1 = operator === C.CalculationOperator_Iem0;
      if (t1 || operator === C.CalculationOperator_uti0) {
        if (left instanceof T.SassNumber0)
          if (right instanceof T.SassNumber0)
            t2 = inMinMax ? left.isComparableTo$1(right) : left.hasCompatibleUnits$1(right);
          else
            t2 = false;
        else
          t2 = false;
        if (t2)
          return t1 ? left.plus$1(right) : left.minus$1(right);
        V.SassCalculation__verifyCompatibleNumbers0(H._setArrayType([left, right], type$.JSArray_Object));
        if (right instanceof T.SassNumber0) {
          t2 = right.value;
          t2 = t2 < 0 && !(Math.abs(t2 - 0) < $.$get$epsilon0());
        } else
          t2 = false;
        if (t2) {
          right = right.times$1(new N.UnitlessSassNumber0(-1, null));
          operator = t1 ? C.CalculationOperator_uti0 : C.CalculationOperator_Iem0;
        }
        return new V.CalculationOperation0(operator, left, right);
      } else if (left instanceof T.SassNumber0 && right instanceof T.SassNumber0)
        return operator === C.CalculationOperator_Dih0 ? left.times$1(right) : left.dividedBy$1(right);
      else
        return new V.CalculationOperation0(operator, left, right);
    },
    SassCalculation__simplify0(arg) {
      var _s32_ = " can't be used in a calculation.";
      if (arg instanceof T.SassNumber0 || arg instanceof V.CalculationInterpolation0 || arg instanceof V.CalculationOperation0)
        return arg;
      else if (arg instanceof D.SassString0) {
        if (!arg.hasQuotes)
          return arg;
        throw H.wrapException(V.SassCalculation__exception0("Quoted string " + arg.toString$0(0) + _s32_));
      } else if (arg instanceof V.SassCalculation0)
        return arg.name === "calc" ? arg.$arguments[0] : arg;
      else if (arg instanceof F.Value0)
        throw H.wrapException(V.SassCalculation__exception0("Value " + arg.toString$0(0) + _s32_));
      else
        throw H.wrapException(P.ArgumentError$("Unexpected calculation argument " + H.S(arg) + ".", null));
    },
    SassCalculation__verifyCompatibleNumbers0(args) {
      var t1, _i, t2, arg, i, number1, j, number2;
      for (t1 = args.length, _i = 0; t2 = args.length, _i < t2; args.length === t1 || (0, H.throwConcurrentModificationError)(args), ++_i) {
        arg = args[_i];
        if (!(arg instanceof T.SassNumber0))
          continue;
        if (J.get$length$asx(arg.get$numeratorUnits()) > 1 || arg.get$denominatorUnits().length !== 0)
          throw H.wrapException(V.SassCalculation__exception0("Number " + arg.toString$0(0) + " isn't compatible with CSS calculations."));
      }
      for (t1 = t2, i = 0; i < t1 - 1; ++i) {
        number1 = args[i];
        if (!(number1 instanceof T.SassNumber0))
          continue;
        for (j = i + 1; t1 = args.length, j < t1; ++j) {
          number2 = args[j];
          if (!(number2 instanceof T.SassNumber0))
            continue;
          if (number1.hasPossiblyCompatibleUnits$1(number2))
            continue;
          throw H.wrapException(V.SassCalculation__exception0(number1.toString$0(0) + " and " + number2.toString$0(0) + " are incompatible."));
        }
      }
    },
    SassCalculation__verifyLength0(args, expectedLength) {
      var t1 = args.length;
      if (t1 === expectedLength)
        return;
      if (C.JSArray_methods.any$1(args, new V.SassCalculation__verifyLength_closure0()))
        return;
      throw H.wrapException(V.SassCalculation__exception0("" + expectedLength + " arguments required, but only " + t1 + " " + B.pluralize0("was", t1, "were") + " passed."));
    },
    SassCalculation__exception0(message) {
      return new E.SassScriptException0(message);
    },
    SassCalculation0: function SassCalculation0(t0, t1) {
      this.name = t0;
      this.$arguments = t1;
    },
    SassCalculation__verifyLength_closure0: function SassCalculation__verifyLength_closure0() {
    },
    CalculationOperation0: function CalculationOperation0(t0, t1, t2) {
      this.operator = t0;
      this.left = t1;
      this.right = t2;
    },
    CalculationOperator0: function CalculationOperator0(t0, t1, t2) {
      this.name = t0;
      this.operator = t1;
      this.precedence = t2;
    },
    CalculationInterpolation0: function CalculationInterpolation0(t0) {
      this.value = t0;
    },
    cloneCssStylesheet0(stylesheet, extensionStore) {
      var result = extensionStore.clone$0();
      return new S.Tuple2(new V._CloneCssVisitor0(result.item2)._clone_css$_visitChildren$2(V.ModifiableCssStylesheet$0(stylesheet.get$span()), stylesheet), result.item1, type$.Tuple2_ModifiableCssStylesheet_ExtensionStore_2);
    },
    _CloneCssVisitor0: function _CloneCssVisitor0(t0) {
      this._clone_css$_oldToNewSelectors = t0;
    },
    EachRule$0(variables, list, children, span) {
      var t1 = P.List_List$unmodifiable(variables, type$.String),
        t2 = P.List_List$unmodifiable(children, type$.Statement_2),
        t3 = C.JSArray_methods.any$1(t2, new M.ParentStatement_closure0());
      return new V.EachRule0(t1, list, span, t2, t3);
    },
    EachRule0: function EachRule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.variables = t0;
      _.list = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    EachRule_toString_closure0: function EachRule_toString_closure0() {
    },
    IfClause$0(expression, children) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2);
      return new V.IfClause0(expression, t1, C.JSArray_methods.any$1(t1, new V.IfRuleClause$__closure0()));
    },
    ElseClause$0(children) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2);
      return new V.ElseClause0(t1, C.JSArray_methods.any$1(t1, new V.IfRuleClause$__closure0()));
    },
    IfRule0: function IfRule0(t0, t1, t2) {
      this.clauses = t0;
      this.lastClause = t1;
      this.span = t2;
    },
    IfRule_toString_closure0: function IfRule_toString_closure0(t0) {
      this.first = t0;
    },
    IfRuleClause0: function IfRuleClause0() {
    },
    IfRuleClause$__closure0: function IfRuleClause$__closure0() {
    },
    IfRuleClause$___closure0: function IfRuleClause$___closure0() {
    },
    IfClause0: function IfClause0(t0, t1, t2) {
      this.expression = t0;
      this.children = t1;
      this.hasDeclarations = t2;
    },
    ElseClause0: function ElseClause0(t0, t1) {
      this.children = t0;
      this.hasDeclarations = t1;
    },
    CssStylesheet0: function CssStylesheet0(t0, t1) {
      this.children = t0;
      this.span = t1;
    },
    ModifiableCssStylesheet$0(span) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode_2);
      return new V.ModifiableCssStylesheet0(span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode_2), t1);
    },
    ModifiableCssStylesheet0: function ModifiableCssStylesheet0(t0, t1, t2) {
      var _ = this;
      _.span = t0;
      _.children = t1;
      _._node2$_children = t2;
      _._node2$_indexInParent = _._node2$_parent = null;
      _.isGroupEnd = false;
    },
    StylesheetParser0: function StylesheetParser0() {
    },
    StylesheetParser_parse_closure0: function StylesheetParser_parse_closure0(t0) {
      this.$this = t0;
    },
    StylesheetParser_parse__closure1: function StylesheetParser_parse__closure1(t0) {
      this.$this = t0;
    },
    StylesheetParser_parse__closure2: function StylesheetParser_parse__closure2() {
    },
    StylesheetParser_parseArgumentDeclaration_closure0: function StylesheetParser_parseArgumentDeclaration_closure0(t0) {
      this.$this = t0;
    },
    StylesheetParser__parseSingleProduction_closure0: function StylesheetParser__parseSingleProduction_closure0(t0, t1, t2) {
      this.$this = t0;
      this.production = t1;
      this.T = t2;
    },
    StylesheetParser_parseSignature_closure: function StylesheetParser_parseSignature_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__statement_closure0: function StylesheetParser__statement_closure0(t0) {
      this.$this = t0;
    },
    StylesheetParser_variableDeclarationWithoutNamespace_closure1: function StylesheetParser_variableDeclarationWithoutNamespace_closure1(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    StylesheetParser_variableDeclarationWithoutNamespace_closure2: function StylesheetParser_variableDeclarationWithoutNamespace_closure2(t0) {
      this.declaration = t0;
    },
    StylesheetParser__declarationOrBuffer_closure1: function StylesheetParser__declarationOrBuffer_closure1(t0) {
      this.name = t0;
    },
    StylesheetParser__declarationOrBuffer_closure2: function StylesheetParser__declarationOrBuffer_closure2(t0, t1) {
      this._box_0 = t0;
      this.name = t1;
    },
    StylesheetParser__styleRule_closure0: function StylesheetParser__styleRule_closure0(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.wasInStyleRule = t2;
      _.start = t3;
    },
    StylesheetParser__propertyOrVariableDeclaration_closure1: function StylesheetParser__propertyOrVariableDeclaration_closure1(t0) {
      this._box_0 = t0;
    },
    StylesheetParser__propertyOrVariableDeclaration_closure2: function StylesheetParser__propertyOrVariableDeclaration_closure2(t0, t1) {
      this._box_0 = t0;
      this.value = t1;
    },
    StylesheetParser__atRootRule_closure1: function StylesheetParser__atRootRule_closure1(t0) {
      this.query = t0;
    },
    StylesheetParser__atRootRule_closure2: function StylesheetParser__atRootRule_closure2() {
    },
    StylesheetParser__eachRule_closure0: function StylesheetParser__eachRule_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.wasInControlDirective = t1;
      _.variables = t2;
      _.list = t3;
    },
    StylesheetParser__functionRule_closure0: function StylesheetParser__functionRule_closure0(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.precedingComment = t2;
    },
    StylesheetParser__forRule_closure1: function StylesheetParser__forRule_closure1(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser__forRule_closure2: function StylesheetParser__forRule_closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.wasInControlDirective = t2;
      _.variable = t3;
      _.from = t4;
      _.to = t5;
    },
    StylesheetParser__memberList_closure0: function StylesheetParser__memberList_closure0(t0, t1, t2) {
      this.$this = t0;
      this.variables = t1;
      this.identifiers = t2;
    },
    StylesheetParser__includeRule_closure0: function StylesheetParser__includeRule_closure0(t0) {
      this.contentArguments_ = t0;
    },
    StylesheetParser_mediaRule_closure0: function StylesheetParser_mediaRule_closure0(t0) {
      this.query = t0;
    },
    StylesheetParser__mixinRule_closure0: function StylesheetParser__mixinRule_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.name = t1;
      _.$arguments = t2;
      _.precedingComment = t3;
    },
    StylesheetParser_mozDocumentRule_closure0: function StylesheetParser_mozDocumentRule_closure0(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.name = t2;
      _.value = t3;
    },
    StylesheetParser_supportsRule_closure0: function StylesheetParser_supportsRule_closure0(t0) {
      this.condition = t0;
    },
    StylesheetParser__whileRule_closure0: function StylesheetParser__whileRule_closure0(t0, t1, t2) {
      this.$this = t0;
      this.wasInControlDirective = t1;
      this.condition = t2;
    },
    StylesheetParser_unknownAtRule_closure0: function StylesheetParser_unknownAtRule_closure0(t0, t1) {
      this._box_0 = t0;
      this.name = t1;
    },
    StylesheetParser_expression_resetState0: function StylesheetParser_expression_resetState0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.start = t2;
    },
    StylesheetParser_expression_resolveOneOperation0: function StylesheetParser_expression_resolveOneOperation0(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser_expression_resolveOperations0: function StylesheetParser_expression_resolveOperations0(t0, t1) {
      this._box_0 = t0;
      this.resolveOneOperation = t1;
    },
    StylesheetParser_expression_addSingleExpression0: function StylesheetParser_expression_addSingleExpression0(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.resetState = t2;
      _.resolveOperations = t3;
    },
    StylesheetParser_expression_addOperator0: function StylesheetParser_expression_addOperator0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.resolveOneOperation = t2;
    },
    StylesheetParser_expression_resolveSpaceExpressions0: function StylesheetParser_expression_resolveSpaceExpressions0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.resolveOperations = t2;
    },
    StylesheetParser__expressionUntilComma_closure0: function StylesheetParser__expressionUntilComma_closure0(t0) {
      this.$this = t0;
    },
    StylesheetParser__unicodeRange_closure1: function StylesheetParser__unicodeRange_closure1() {
    },
    StylesheetParser__unicodeRange_closure2: function StylesheetParser__unicodeRange_closure2() {
    },
    StylesheetParser_namespacedExpression_closure0: function StylesheetParser_namespacedExpression_closure0(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    StylesheetParser_trySpecialFunction_closure0: function StylesheetParser_trySpecialFunction_closure0() {
    },
    StylesheetParser__expressionUntilComparison_closure0: function StylesheetParser__expressionUntilComparison_closure0(t0) {
      this.$this = t0;
    },
    StylesheetParser__publicIdentifier_closure0: function StylesheetParser__publicIdentifier_closure0(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    Stylesheet$internal0(children, span, plainCss) {
      var t1 = H._setArrayType([], type$.JSArray_UseRule_2),
        t2 = H._setArrayType([], type$.JSArray_ForwardRule_2),
        t3 = P.List_List$unmodifiable(children, type$.Statement_2),
        t4 = C.JSArray_methods.any$1(t3, new M.ParentStatement_closure0());
      t1 = new V.Stylesheet0(span, plainCss, t1, t2, t3, t4);
      t1.Stylesheet$internal$3$plainCss0(children, span, plainCss);
      return t1;
    },
    Stylesheet_Stylesheet$parse0(contents, syntax, logger, url) {
      var t1, t2;
      switch (syntax) {
        case C.Syntax_Sass0:
          t1 = S.SpanScanner$(contents, url);
          t2 = logger == null ? C.C_StderrLogger : logger;
          return new U.SassParser0(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.VariableDeclaration_2), t1, t2).parse$0();
        case C.Syntax_SCSS0:
          return L.ScssParser$0(contents, logger, url).parse$0();
        case C.Syntax_CSS0:
          t1 = S.SpanScanner$(contents, url);
          t2 = logger == null ? C.C_StderrLogger : logger;
          return new Q.CssParser0(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.VariableDeclaration_2), t1, t2).parse$0();
        default:
          throw H.wrapException(P.ArgumentError$("Unknown syntax " + syntax.toString$0(0) + ".", null));
      }
    },
    Stylesheet0: function Stylesheet0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.span = t0;
      _.plainCss = t1;
      _._stylesheet1$_uses = t2;
      _._stylesheet1$_forwards = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    SpanExtensions_trimLeft(_this) {
      var t5,
        t1 = _this._file$_start,
        t2 = _this._end,
        t3 = _this.file._decodedChars,
        t4 = t3.length,
        start = 0;
      while (true) {
        t5 = C.JSString_methods._codeUnitAt$1(P.String_String$fromCharCodes(new Uint32Array(t3.subarray(t1, H._checkValidRange(t1, t2, t4))), 0, null), start);
        if (!(t5 === 32 || t5 === 9 || t5 === 10 || t5 === 13 || t5 === 12))
          break;
        ++start;
      }
      return Y.FileSpanExtension_subspan(_this, start, null);
    },
    SpanExtensions_trimRight(_this) {
      var t5,
        t1 = _this._file$_start,
        t2 = _this._end,
        t3 = _this.file._decodedChars,
        end = P.String_String$fromCharCodes(C.NativeUint32List_methods.sublist$2(t3, t1, t2), 0, null).length - 1,
        t4 = t3.length;
      while (true) {
        t5 = C.JSString_methods.codeUnitAt$1(P.String_String$fromCharCodes(new Uint32Array(t3.subarray(t1, H._checkValidRange(t1, t2, t4))), 0, null), end);
        if (!(t5 === 32 || t5 === 9 || t5 === 10 || t5 === 13 || t5 === 12))
          break;
        --end;
      }
      return Y.FileSpanExtension_subspan(_this, 0, end + 1);
    },
    SpanExtensions_trimLeft0(_this) {
      var t5,
        t1 = _this._file$_start,
        t2 = _this._end,
        t3 = _this.file._decodedChars,
        t4 = t3.length,
        start = 0;
      while (true) {
        t5 = C.JSString_methods._codeUnitAt$1(P.String_String$fromCharCodes(new Uint32Array(t3.subarray(t1, H._checkValidRange(t1, t2, t4))), 0, null), start);
        if (!(t5 === 32 || t5 === 9 || t5 === 10 || t5 === 13 || t5 === 12))
          break;
        ++start;
      }
      return Y.FileSpanExtension_subspan(_this, start, null);
    },
    SpanExtensions_trimRight0(_this) {
      var t5,
        t1 = _this._file$_start,
        t2 = _this._end,
        t3 = _this.file._decodedChars,
        end = P.String_String$fromCharCodes(C.NativeUint32List_methods.sublist$2(t3, t1, t2), 0, null).length - 1,
        t4 = t3.length;
      while (true) {
        t5 = C.JSString_methods.codeUnitAt$1(P.String_String$fromCharCodes(new Uint32Array(t3.subarray(t1, H._checkValidRange(t1, t2, t4))), 0, null), end);
        if (!(t5 === 32 || t5 === 9 || t5 === 10 || t5 === 13 || t5 === 12))
          break;
        --end;
      }
      return Y.FileSpanExtension_subspan(_this, 0, end + 1);
    }
  },
  X = {NodeJsError: function NodeJsError() {
    }, JsAssertionError: function JsAssertionError() {
    }, JsRangeError: function JsRangeError() {
    }, JsReferenceError: function JsReferenceError() {
    }, JsSyntaxError: function JsSyntaxError() {
    }, JsTypeError: function JsTypeError() {
    }, JsSystemError: function JsSystemError() {
    }, Process: function Process() {
    }, CPUUsage: function CPUUsage() {
    }, Release: function Release() {
    },
    ParsedPath_ParsedPath$parse(path, style) {
      var t1, parts, separators, start, i,
        root = style.getRoot$1(path),
        isRootRelative = style.isRootRelative$1(path);
      if (root != null)
        path = C.JSString_methods.substring$1(path, root.length);
      t1 = type$.JSArray_String;
      parts = H._setArrayType([], t1);
      separators = H._setArrayType([], t1);
      t1 = path.length;
      if (t1 !== 0 && style.isSeparator$1(C.JSString_methods._codeUnitAt$1(path, 0))) {
        separators.push(path[0]);
        start = 1;
      } else {
        separators.push("");
        start = 0;
      }
      for (i = start; i < t1; ++i)
        if (style.isSeparator$1(C.JSString_methods._codeUnitAt$1(path, i))) {
          parts.push(C.JSString_methods.substring$2(path, start, i));
          separators.push(path[i]);
          start = i + 1;
        }
      if (start < t1) {
        parts.push(C.JSString_methods.substring$1(path, start));
        separators.push("");
      }
      return new X.ParsedPath(style, root, isRootRelative, parts, separators);
    },
    ParsedPath: function ParsedPath(t0, t1, t2, t3, t4) {
      var _ = this;
      _.style = t0;
      _.root = t1;
      _.isRootRelative = t2;
      _.parts = t3;
      _.separators = t4;
    },
    ParsedPath__splitExtension_closure: function ParsedPath__splitExtension_closure() {
    },
    ParsedPath__splitExtension_closure0: function ParsedPath__splitExtension_closure0() {
    },
    PathException$(message) {
      return new X.PathException(message);
    },
    PathException: function PathException(t0) {
      this.message = t0;
    },
    ModifiableCssStyleRule$(selector, span, originalSelector) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new X.ModifiableCssStyleRule(selector, originalSelector, span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssStyleRule: function ModifiableCssStyleRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.selector = t0;
      _.originalSelector = t1;
      _.span = t2;
      _.children = t3;
      _._children = t4;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ArgumentInvocation$empty(span) {
      return new X.ArgumentInvocation(C.List_empty7, C.Map_empty2, null, null, span);
    },
    ArgumentInvocation: function ArgumentInvocation(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.named = t1;
      _.rest = t2;
      _.keywordRest = t3;
      _.span = t4;
    },
    UnaryOperationExpression: function UnaryOperationExpression(t0, t1, t2) {
      this.operator = t0;
      this.operand = t1;
      this.span = t2;
    },
    UnaryOperator: function UnaryOperator(t0, t1) {
      this.name = t0;
      this.operator = t1;
    },
    Interpolation$(contents, span) {
      var t1 = new X.Interpolation(P.List_List$unmodifiable(contents, type$.Object), span);
      t1.Interpolation$2(contents, span);
      return t1;
    },
    Interpolation: function Interpolation(t0, t1) {
      this.contents = t0;
      this.span = t1;
    },
    Interpolation_toString_closure: function Interpolation_toString_closure() {
    },
    ExtendRule: function ExtendRule(t0, t1, t2) {
      this.selector = t0;
      this.isOptional = t1;
      this.span = t2;
    },
    StyleRule$(selector, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new X.StyleRule(selector, span, t1, t2);
    },
    StyleRule: function StyleRule(t0, t1, t2, t3) {
      var _ = this;
      _.selector = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    SupportsInterpolation: function SupportsInterpolation(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    ClassSelector: function ClassSelector(t0) {
      this.name = t0;
    },
    CompoundSelector$(components) {
      var t1 = P.List_List$unmodifiable(components, type$.SimpleSelector);
      if (t1.length === 0)
        H.throwExpression(P.ArgumentError$("components may not be empty.", null));
      return new X.CompoundSelector(t1);
    },
    CompoundSelector: function CompoundSelector(t0) {
      this.components = t0;
      this._maxSpecificity = this._compound$_minSpecificity = null;
    },
    CompoundSelector_isInvisible_closure: function CompoundSelector_isInvisible_closure() {
    },
    compileAsync(path, charset, importCache, logger, quietDeps, sourceMap, style, syntax, verbose) {
      return X.compileAsync$body(path, charset, importCache, logger, quietDeps, sourceMap, style, syntax, verbose);
    },
    compileAsync$body(path, charset, importCache, logger, quietDeps, sourceMap, style, syntax, verbose) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.CompileResult),
        $async$returnValue, t1, terseLogger, t2, stylesheet, result;
      var $async$compileAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              if (!verbose) {
                t1 = logger == null ? new S.StderrLogger(false) : logger;
                terseLogger = new Y.TerseLogger(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.int), t1);
                logger = terseLogger;
              } else
                terseLogger = null;
              t1 = syntax === M.Syntax_forPath(path);
              $async$goto = t1 ? 3 : 5;
              break;
            case 3:
              // then
              t1 = $.$get$context();
              t2 = t1.absolute$7(".", null, null, null, null, null, null);
              $async$goto = 6;
              return P._asyncAwait(importCache.importCanonical$3$originalUrl(new F.FilesystemImporter(t2), t1.toUri$1(J.$eq$(J.get$platform$x(self.process), "win32") || J.$eq$(J.get$platform$x(self.process), "darwin") ? F._realCasePath(t1.absolute$7(t1.normalize$1(path), null, null, null, null, null, null)) : t1.canonicalize$1(path)), t1.toUri$1(path)), $async$compileAsync);
            case 6:
              // returning from await.
              t2 = $async$result;
              t2.toString;
              stylesheet = t2;
              // goto join
              $async$goto = 4;
              break;
            case 5:
              // else
              t1 = B.readFile(path);
              t2 = $.$get$context();
              stylesheet = V.Stylesheet_Stylesheet$parse(t1, syntax, logger, t2.toUri$1(path));
              t1 = t2;
            case 4:
              // join
              $async$goto = 7;
              return P._asyncAwait(X._compileStylesheet0(stylesheet, logger, importCache, null, new F.FilesystemImporter(t1.absolute$7(".", null, null, null, null, null, null)), null, style, true, null, null, quietDeps, sourceMap, charset), $async$compileAsync);
            case 7:
              // returning from await.
              result = $async$result;
              if (terseLogger != null)
                terseLogger.summarize$1$node(false);
              $async$returnValue = result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$compileAsync, $async$completer);
    },
    compileStringAsync(source, charset, importCache, importer, logger, quietDeps, sourceMap, style, syntax, verbose) {
      return X.compileStringAsync$body(source, charset, importCache, importer, logger, quietDeps, sourceMap, style, syntax, verbose);
    },
    compileStringAsync$body(source, charset, importCache, importer, logger, quietDeps, sourceMap, style, syntax, verbose) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.CompileResult),
        $async$returnValue, t1, terseLogger, stylesheet, result;
      var $async$compileStringAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              if (!verbose) {
                t1 = logger == null ? new S.StderrLogger(false) : logger;
                terseLogger = new Y.TerseLogger(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.int), t1);
                logger = terseLogger;
              } else
                terseLogger = null;
              stylesheet = V.Stylesheet_Stylesheet$parse(source, syntax, logger, null);
              $async$goto = 3;
              return P._asyncAwait(X._compileStylesheet0(stylesheet, logger, importCache, null, importer, null, style, true, null, null, quietDeps, sourceMap, charset), $async$compileStringAsync);
            case 3:
              // returning from await.
              result = $async$result;
              if (terseLogger != null)
                terseLogger.summarize$1$node(false);
              $async$returnValue = result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$compileStringAsync, $async$completer);
    },
    _compileStylesheet0(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.CompileResult),
        $async$returnValue, serializeResult, resultSourceMap, $async$temp1;
      var $async$_compileStylesheet0 = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              $async$temp1 = N;
              $async$goto = 3;
              return P._asyncAwait(E._EvaluateVisitor$0(functions, importCache, logger, nodeImporter, quietDeps, sourceMap).run$2(0, importer, stylesheet), $async$_compileStylesheet0);
            case 3:
              // returning from await.
              serializeResult = $async$temp1.serialize($async$result.stylesheet, charset, indentWidth, false, lineFeed, sourceMap, style, true);
              resultSourceMap = serializeResult.sourceMap;
              if (resultSourceMap != null && true)
                B.mapInPlace(resultSourceMap.urls, new X._compileStylesheet_closure0(stylesheet, importCache));
              $async$returnValue = new U.CompileResult(serializeResult);
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$_compileStylesheet0, $async$completer);
    },
    _compileStylesheet_closure0: function _compileStylesheet_closure0(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    ExtensionStore__extendOrReplace(selector, source, targets, mode, span) {
      var t1, t2, t3, t4, t5, t6, t7, t8, t9, _i, complex, t10, t11, t12, _i0, simple, t13, _i1, t14, t15,
        extender = X.ExtensionStore$_mode(mode);
      if (!selector.get$isInvisible())
        extender._originals.addAll$1(0, selector.components);
      for (t1 = targets.components, t2 = t1.length, t3 = source.components, t4 = t3.length, t5 = type$.ComplexSelector, t6 = type$.Extension, t7 = type$.CompoundSelector, t8 = type$.SimpleSelector, t9 = type$.Map_ComplexSelector_Extension, _i = 0; _i < t2; ++_i) {
        complex = t1[_i];
        t10 = complex.components;
        if (t10.length !== 1)
          throw H.wrapException(E.SassScriptException$("Can't extend complex selector " + H.S(complex) + "."));
        t11 = P.LinkedHashMap_LinkedHashMap$_empty(t8, t9);
        for (t10 = t7._as(C.JSArray_methods.get$first(t10)).components, t12 = t10.length, _i0 = 0; _i0 < t12; ++_i0) {
          simple = t10[_i0];
          t13 = P.LinkedHashMap_LinkedHashMap$_empty(t5, t6);
          for (_i1 = 0; _i1 < t4; ++_i1) {
            complex = t3[_i1];
            if (complex._complex$_maxSpecificity == null)
              complex._computeSpecificity$0();
            complex._complex$_maxSpecificity.toString;
            t14 = new S.Extender(complex, false, span);
            t15 = new S.Extension(t14, simple, null, true, span);
            t14._extension = t15;
            t13.$indexSet(0, complex, t15);
          }
          t11.$indexSet(0, simple, t13);
        }
        selector = extender._extendList$3(selector, span, t11);
      }
      return selector;
    },
    ExtensionStore$() {
      var t1 = type$.SimpleSelector;
      return new X.ExtensionStore(P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Set_ModifiableCssValue_SelectorList), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Map_ComplexSelector_Extension), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.List_Extension), P.LinkedHashMap_LinkedHashMap$_empty(type$.ModifiableCssValue_SelectorList, type$.List_CssMediaQuery), P._LinkedIdentityHashMap__LinkedIdentityHashMap$es6(t1, type$.int), new P._LinkedIdentityHashSet(type$._LinkedIdentityHashSet_ComplexSelector), C.ExtendMode_normal);
    },
    ExtensionStore$_mode(_mode) {
      var t1 = type$.SimpleSelector;
      return new X.ExtensionStore(P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Set_ModifiableCssValue_SelectorList), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Map_ComplexSelector_Extension), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.List_Extension), P.LinkedHashMap_LinkedHashMap$_empty(type$.ModifiableCssValue_SelectorList, type$.List_CssMediaQuery), P._LinkedIdentityHashMap__LinkedIdentityHashMap$es6(t1, type$.int), new P._LinkedIdentityHashSet(type$._LinkedIdentityHashSet_ComplexSelector), _mode);
    },
    ExtensionStore: function ExtensionStore(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._selectors = t0;
      _._extensions = t1;
      _._extensionsByExtender = t2;
      _._mediaContexts = t3;
      _._sourceSpecificity = t4;
      _._originals = t5;
      _._mode = t6;
    },
    ExtensionStore_extensionsWhereTarget_closure: function ExtensionStore_extensionsWhereTarget_closure() {
    },
    ExtensionStore__registerSelector_closure: function ExtensionStore__registerSelector_closure() {
    },
    ExtensionStore_addExtension_closure: function ExtensionStore_addExtension_closure() {
    },
    ExtensionStore_addExtension_closure0: function ExtensionStore_addExtension_closure0() {
    },
    ExtensionStore_addExtension_closure1: function ExtensionStore_addExtension_closure1(t0) {
      this.complex = t0;
    },
    ExtensionStore__extendExistingExtensions_closure: function ExtensionStore__extendExistingExtensions_closure() {
    },
    ExtensionStore__extendExistingExtensions_closure0: function ExtensionStore__extendExistingExtensions_closure0() {
    },
    ExtensionStore_addExtensions_closure: function ExtensionStore_addExtensions_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    ExtensionStore_addExtensions__closure1: function ExtensionStore_addExtensions__closure1(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.existingSources = t1;
      _.extensionsForTarget = t2;
      _.selectorsForTarget = t3;
      _.target = t4;
    },
    ExtensionStore_addExtensions___closure: function ExtensionStore_addExtensions___closure() {
    },
    ExtensionStore_addExtensions_closure0: function ExtensionStore_addExtensions_closure0(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    ExtensionStore_addExtensions__closure: function ExtensionStore_addExtensions__closure(t0, t1) {
      this.$this = t0;
      this.newExtensions = t1;
    },
    ExtensionStore_addExtensions__closure0: function ExtensionStore_addExtensions__closure0(t0, t1) {
      this.$this = t0;
      this.newExtensions = t1;
    },
    ExtensionStore__extendComplex_closure: function ExtensionStore__extendComplex_closure(t0) {
      this.complex = t0;
    },
    ExtensionStore__extendComplex_closure0: function ExtensionStore__extendComplex_closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.complex = t2;
    },
    ExtensionStore__extendComplex__closure: function ExtensionStore__extendComplex__closure() {
    },
    ExtensionStore__extendComplex__closure0: function ExtensionStore__extendComplex__closure0(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.complex = t2;
      _.path = t3;
    },
    ExtensionStore__extendComplex___closure: function ExtensionStore__extendComplex___closure() {
    },
    ExtensionStore__extendCompound_closure: function ExtensionStore__extendCompound_closure(t0) {
      this.mediaQueryContext = t0;
    },
    ExtensionStore__extendCompound_closure0: function ExtensionStore__extendCompound_closure0(t0, t1) {
      this._box_1 = t0;
      this.mediaQueryContext = t1;
    },
    ExtensionStore__extendCompound__closure: function ExtensionStore__extendCompound__closure() {
    },
    ExtensionStore__extendCompound__closure0: function ExtensionStore__extendCompound__closure0(t0) {
      this._box_0 = t0;
    },
    ExtensionStore__extendCompound_closure1: function ExtensionStore__extendCompound_closure1() {
    },
    ExtensionStore__extendCompound_closure2: function ExtensionStore__extendCompound_closure2() {
    },
    ExtensionStore__extendCompound_closure3: function ExtensionStore__extendCompound_closure3(t0) {
      this.original = t0;
    },
    ExtensionStore__extendSimple_withoutPseudo: function ExtensionStore__extendSimple_withoutPseudo(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.extensions = t1;
      _.targetsUsed = t2;
      _.simpleSpan = t3;
    },
    ExtensionStore__extendSimple_closure: function ExtensionStore__extendSimple_closure(t0, t1, t2) {
      this.$this = t0;
      this.withoutPseudo = t1;
      this.simpleSpan = t2;
    },
    ExtensionStore__extendSimple_closure0: function ExtensionStore__extendSimple_closure0() {
    },
    ExtensionStore__extendPseudo_closure: function ExtensionStore__extendPseudo_closure() {
    },
    ExtensionStore__extendPseudo_closure0: function ExtensionStore__extendPseudo_closure0() {
    },
    ExtensionStore__extendPseudo_closure1: function ExtensionStore__extendPseudo_closure1() {
    },
    ExtensionStore__extendPseudo_closure2: function ExtensionStore__extendPseudo_closure2(t0) {
      this.pseudo = t0;
    },
    ExtensionStore__extendPseudo_closure3: function ExtensionStore__extendPseudo_closure3(t0) {
      this.pseudo = t0;
    },
    ExtensionStore__trim_closure: function ExtensionStore__trim_closure(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    ExtensionStore__trim_closure0: function ExtensionStore__trim_closure0(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    ExtensionStore_clone_closure: function ExtensionStore_clone_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.newSelectors = t1;
      _.oldToNewSelectors = t2;
      _.newMediaContexts = t3;
    },
    SourceSpanWithContext$(start, end, text, _context) {
      var t1 = new X.SourceSpanWithContext(_context, start, end, text);
      t1.SourceSpanBase$3(start, end, text);
      if (!C.JSString_methods.contains$1(_context, text))
        H.throwExpression(P.ArgumentError$('The context line "' + _context + '" must contain "' + text + '".', null));
      if (B.findLineStart(_context, text, start.get$column()) == null)
        H.throwExpression(P.ArgumentError$('The span text "' + text + '" must start at column ' + (start.get$column() + 1) + ' in a line within "' + _context + '".', null));
      return t1;
    },
    SourceSpanWithContext: function SourceSpanWithContext(t0, t1, t2, t3) {
      var _ = this;
      _._context = t0;
      _.start = t1;
      _.end = t2;
      _.text = t3;
    },
    StringScanner$(string, position, sourceUrl) {
      var t1;
      if (sourceUrl == null)
        t1 = null;
      else
        t1 = typeof sourceUrl == "string" ? P.Uri_parse(sourceUrl) : type$.Uri._as(sourceUrl);
      return new X.StringScanner(t1, string);
    },
    StringScanner: function StringScanner(t0, t1) {
      var _ = this;
      _.sourceUrl = t0;
      _.string = t1;
      _._string_scanner$_position = 0;
      _._lastMatchPosition = _._lastMatch = null;
    },
    ArgumentInvocation$empty0(span) {
      return new X.ArgumentInvocation0(C.List_empty17, C.Map_empty8, null, null, span);
    },
    ArgumentInvocation0: function ArgumentInvocation0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.named = t1;
      _.rest = t2;
      _.keywordRest = t3;
      _.span = t4;
    },
    compileAsync0(path, charset, functions, indentWidth, lineFeed, nodeImporter, quietDeps, sourceMap, style, syntax, useSpaces, verbose) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.CompileResult_2),
        $async$returnValue, terseLogger, logger, t1, t2, t3, stylesheet, result;
      var $async$compileAsync0 = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              if (!verbose) {
                terseLogger = new Y.TerseLogger0(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.int), new S.StderrLogger0());
                logger = terseLogger;
              } else {
                logger = null;
                terseLogger = null;
              }
              t1 = B.readFile0(path);
              t2 = syntax == null ? M.Syntax_forPath0(path) : syntax;
              t3 = $.$get$context();
              stylesheet = V.Stylesheet_Stylesheet$parse0(t1, t2, logger, t3.toUri$1(path));
              t1 = t3;
              $async$goto = 3;
              return P._asyncAwait(X._compileStylesheet2(stylesheet, logger, null, nodeImporter, new F.FilesystemImporter0(t1.absolute$7(".", null, null, null, null, null, null)), functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset), $async$compileAsync0);
            case 3:
              // returning from await.
              result = $async$result;
              if (terseLogger != null)
                terseLogger.summarize$1$node(true);
              $async$returnValue = result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$compileAsync0, $async$completer);
    },
    compileStringAsync0(source, charset, functions, indentWidth, lineFeed, nodeImporter, quietDeps, sourceMap, style, syntax, url, useSpaces, verbose) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.CompileResult_2),
        $async$returnValue, terseLogger, logger, stylesheet, t1, result;
      var $async$compileStringAsync0 = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              if (!verbose) {
                terseLogger = new Y.TerseLogger0(P.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.int), new S.StderrLogger0());
                logger = terseLogger;
              } else {
                logger = null;
                terseLogger = null;
              }
              stylesheet = V.Stylesheet_Stylesheet$parse0(source, syntax == null ? C.Syntax_SCSS0 : syntax, logger, url);
              t1 = $.$get$context().absolute$7(".", null, null, null, null, null, null);
              $async$goto = 3;
              return P._asyncAwait(X._compileStylesheet2(stylesheet, logger, null, nodeImporter, new F.FilesystemImporter0(t1), functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset), $async$compileStringAsync0);
            case 3:
              // returning from await.
              result = $async$result;
              if (terseLogger != null)
                terseLogger.summarize$1$node(true);
              $async$returnValue = result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$compileStringAsync0, $async$completer);
    },
    _compileStylesheet2(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.CompileResult_2),
        $async$returnValue, evaluateResult, serializeResult, resultSourceMap;
      var $async$_compileStylesheet2 = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              $async$goto = 3;
              return P._asyncAwait(E._EvaluateVisitor$2(functions, importCache, logger, nodeImporter, quietDeps, sourceMap).run$2(0, importer, stylesheet), $async$_compileStylesheet2);
            case 3:
              // returning from await.
              evaluateResult = $async$result;
              serializeResult = N.serialize0(evaluateResult.stylesheet, charset, indentWidth, false, lineFeed, sourceMap, style, useSpaces);
              resultSourceMap = serializeResult.sourceMap;
              if (resultSourceMap != null && importCache != null)
                B.mapInPlace0(resultSourceMap.urls, new X._compileStylesheet_closure2(stylesheet, importCache));
              $async$returnValue = new U.CompileResult0(evaluateResult, serializeResult);
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$_compileStylesheet2, $async$completer);
    },
    _compileStylesheet_closure2: function _compileStylesheet_closure2(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    ClassSelector0: function ClassSelector0(t0) {
      this.name = t0;
    },
    CompoundSelector$0(components) {
      var t1 = P.List_List$unmodifiable(components, type$.SimpleSelector_2);
      if (t1.length === 0)
        H.throwExpression(P.ArgumentError$("components may not be empty.", null));
      return new X.CompoundSelector0(t1);
    },
    CompoundSelector0: function CompoundSelector0(t0) {
      this.components = t0;
      this._compound0$_maxSpecificity = this._compound0$_minSpecificity = null;
    },
    CompoundSelector_isInvisible_closure0: function CompoundSelector_isInvisible_closure0() {
    },
    ExtendRule0: function ExtendRule0(t0, t1, t2) {
      this.selector = t0;
      this.isOptional = t1;
      this.span = t2;
    },
    ExtensionStore__extendOrReplace0(selector, source, targets, mode, span) {
      var t1, t2, t3, t4, t5, t6, t7, t8, t9, _i, complex, t10, t11, t12, _i0, simple, t13, _i1, t14, t15,
        extender = X.ExtensionStore$_mode0(mode);
      if (!selector.get$isInvisible())
        extender._extension_store$_originals.addAll$1(0, selector.components);
      for (t1 = targets.components, t2 = t1.length, t3 = source.components, t4 = t3.length, t5 = type$.ComplexSelector_2, t6 = type$.Extension_2, t7 = type$.CompoundSelector_2, t8 = type$.SimpleSelector_2, t9 = type$.Map_ComplexSelector_Extension_2, _i = 0; _i < t2; ++_i) {
        complex = t1[_i];
        t10 = complex.components;
        if (t10.length !== 1)
          throw H.wrapException(E.SassScriptException$0("Can't extend complex selector " + H.S(complex) + "."));
        t11 = P.LinkedHashMap_LinkedHashMap$_empty(t8, t9);
        for (t10 = t7._as(C.JSArray_methods.get$first(t10)).components, t12 = t10.length, _i0 = 0; _i0 < t12; ++_i0) {
          simple = t10[_i0];
          t13 = P.LinkedHashMap_LinkedHashMap$_empty(t5, t6);
          for (_i1 = 0; _i1 < t4; ++_i1) {
            complex = t3[_i1];
            if (complex._complex0$_maxSpecificity == null)
              complex._complex0$_computeSpecificity$0();
            complex._complex0$_maxSpecificity.toString;
            t14 = new S.Extender0(complex, false, span);
            t15 = new S.Extension0(t14, simple, null, true, span);
            t14._extension$_extension = t15;
            t13.$indexSet(0, complex, t15);
          }
          t11.$indexSet(0, simple, t13);
        }
        selector = extender._extension_store$_extendList$3(selector, span, t11);
      }
      return selector;
    },
    ExtensionStore$0() {
      var t1 = type$.SimpleSelector_2;
      return new X.ExtensionStore0(P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Set_ModifiableCssValue_SelectorList_2), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Map_ComplexSelector_Extension_2), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.List_Extension_2), P.LinkedHashMap_LinkedHashMap$_empty(type$.ModifiableCssValue_SelectorList_2, type$.List_CssMediaQuery_2), P._LinkedIdentityHashMap__LinkedIdentityHashMap$es6(t1, type$.int), new P._LinkedIdentityHashSet(type$._LinkedIdentityHashSet_ComplexSelector_2), C.ExtendMode_normal0);
    },
    ExtensionStore$_mode0(_mode) {
      var t1 = type$.SimpleSelector_2;
      return new X.ExtensionStore0(P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Set_ModifiableCssValue_SelectorList_2), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Map_ComplexSelector_Extension_2), P.LinkedHashMap_LinkedHashMap$_empty(t1, type$.List_Extension_2), P.LinkedHashMap_LinkedHashMap$_empty(type$.ModifiableCssValue_SelectorList_2, type$.List_CssMediaQuery_2), P._LinkedIdentityHashMap__LinkedIdentityHashMap$es6(t1, type$.int), new P._LinkedIdentityHashSet(type$._LinkedIdentityHashSet_ComplexSelector_2), _mode);
    },
    ExtensionStore0: function ExtensionStore0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._extension_store$_selectors = t0;
      _._extension_store$_extensions = t1;
      _._extension_store$_extensionsByExtender = t2;
      _._extension_store$_mediaContexts = t3;
      _._extension_store$_sourceSpecificity = t4;
      _._extension_store$_originals = t5;
      _._extension_store$_mode = t6;
    },
    ExtensionStore_extensionsWhereTarget_closure0: function ExtensionStore_extensionsWhereTarget_closure0() {
    },
    ExtensionStore__registerSelector_closure0: function ExtensionStore__registerSelector_closure0() {
    },
    ExtensionStore_addExtension_closure2: function ExtensionStore_addExtension_closure2() {
    },
    ExtensionStore_addExtension_closure3: function ExtensionStore_addExtension_closure3() {
    },
    ExtensionStore_addExtension_closure4: function ExtensionStore_addExtension_closure4(t0) {
      this.complex = t0;
    },
    ExtensionStore__extendExistingExtensions_closure1: function ExtensionStore__extendExistingExtensions_closure1() {
    },
    ExtensionStore__extendExistingExtensions_closure2: function ExtensionStore__extendExistingExtensions_closure2() {
    },
    ExtensionStore_addExtensions_closure1: function ExtensionStore_addExtensions_closure1(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    ExtensionStore_addExtensions__closure4: function ExtensionStore_addExtensions__closure4(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.existingSources = t1;
      _.extensionsForTarget = t2;
      _.selectorsForTarget = t3;
      _.target = t4;
    },
    ExtensionStore_addExtensions___closure0: function ExtensionStore_addExtensions___closure0() {
    },
    ExtensionStore_addExtensions_closure2: function ExtensionStore_addExtensions_closure2(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    ExtensionStore_addExtensions__closure2: function ExtensionStore_addExtensions__closure2(t0, t1) {
      this.$this = t0;
      this.newExtensions = t1;
    },
    ExtensionStore_addExtensions__closure3: function ExtensionStore_addExtensions__closure3(t0, t1) {
      this.$this = t0;
      this.newExtensions = t1;
    },
    ExtensionStore__extendComplex_closure1: function ExtensionStore__extendComplex_closure1(t0) {
      this.complex = t0;
    },
    ExtensionStore__extendComplex_closure2: function ExtensionStore__extendComplex_closure2(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.complex = t2;
    },
    ExtensionStore__extendComplex__closure1: function ExtensionStore__extendComplex__closure1() {
    },
    ExtensionStore__extendComplex__closure2: function ExtensionStore__extendComplex__closure2(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.complex = t2;
      _.path = t3;
    },
    ExtensionStore__extendComplex___closure0: function ExtensionStore__extendComplex___closure0() {
    },
    ExtensionStore__extendCompound_closure4: function ExtensionStore__extendCompound_closure4(t0) {
      this.mediaQueryContext = t0;
    },
    ExtensionStore__extendCompound_closure5: function ExtensionStore__extendCompound_closure5(t0, t1) {
      this._box_1 = t0;
      this.mediaQueryContext = t1;
    },
    ExtensionStore__extendCompound__closure1: function ExtensionStore__extendCompound__closure1() {
    },
    ExtensionStore__extendCompound__closure2: function ExtensionStore__extendCompound__closure2(t0) {
      this._box_0 = t0;
    },
    ExtensionStore__extendCompound_closure6: function ExtensionStore__extendCompound_closure6() {
    },
    ExtensionStore__extendCompound_closure7: function ExtensionStore__extendCompound_closure7() {
    },
    ExtensionStore__extendCompound_closure8: function ExtensionStore__extendCompound_closure8(t0) {
      this.original = t0;
    },
    ExtensionStore__extendSimple_withoutPseudo0: function ExtensionStore__extendSimple_withoutPseudo0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.extensions = t1;
      _.targetsUsed = t2;
      _.simpleSpan = t3;
    },
    ExtensionStore__extendSimple_closure1: function ExtensionStore__extendSimple_closure1(t0, t1, t2) {
      this.$this = t0;
      this.withoutPseudo = t1;
      this.simpleSpan = t2;
    },
    ExtensionStore__extendSimple_closure2: function ExtensionStore__extendSimple_closure2() {
    },
    ExtensionStore__extendPseudo_closure4: function ExtensionStore__extendPseudo_closure4() {
    },
    ExtensionStore__extendPseudo_closure5: function ExtensionStore__extendPseudo_closure5() {
    },
    ExtensionStore__extendPseudo_closure6: function ExtensionStore__extendPseudo_closure6() {
    },
    ExtensionStore__extendPseudo_closure7: function ExtensionStore__extendPseudo_closure7(t0) {
      this.pseudo = t0;
    },
    ExtensionStore__extendPseudo_closure8: function ExtensionStore__extendPseudo_closure8(t0) {
      this.pseudo = t0;
    },
    ExtensionStore__trim_closure1: function ExtensionStore__trim_closure1(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    ExtensionStore__trim_closure2: function ExtensionStore__trim_closure2(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    ExtensionStore_clone_closure0: function ExtensionStore_clone_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.newSelectors = t1;
      _.oldToNewSelectors = t2;
      _.newMediaContexts = t3;
    },
    Interpolation$0(contents, span) {
      var t1 = new X.Interpolation0(P.List_List$unmodifiable(contents, type$.Object), span);
      t1.Interpolation$20(contents, span);
      return t1;
    },
    Interpolation0: function Interpolation0(t0, t1) {
      this.contents = t0;
      this.span = t1;
    },
    Interpolation_toString_closure0: function Interpolation_toString_closure0() {
    },
    SupportsInterpolation0: function SupportsInterpolation0(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    ModifiableCssStyleRule$0(selector, span, originalSelector) {
      var t1 = H._setArrayType([], type$.JSArray_ModifiableCssNode_2);
      return new X.ModifiableCssStyleRule0(selector, originalSelector, span, new P.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode_2), t1);
    },
    ModifiableCssStyleRule0: function ModifiableCssStyleRule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.selector = t0;
      _.originalSelector = t1;
      _.span = t2;
      _.children = t3;
      _._node2$_children = t4;
      _._node2$_indexInParent = _._node2$_parent = null;
      _.isGroupEnd = false;
    },
    StyleRule$0(selector, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new X.StyleRule0(selector, span, t1, t2);
    },
    StyleRule0: function StyleRule0(t0, t1, t2, t3) {
      var _ = this;
      _.selector = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    UnaryOperationExpression0: function UnaryOperationExpression0(t0, t1, t2) {
      this.operator = t0;
      this.operand = t1;
      this.span = t2;
    },
    UnaryOperator0: function UnaryOperator0(t0, t1) {
      this.name = t0;
      this.operator = t1;
    },
    NullableExtension_andThen(_this, fn) {
      return _this == null ? null : fn.call$1(_this);
    },
    SetExtension_removeNull(_this, $T) {
      _this.remove$1(0, null);
      return P.Set_castFrom(_this, _this.get$_newSimilarSet(), H._instanceType(_this)._precomputed1, $T);
    },
    NullableExtension_andThen0(_this, fn) {
      return _this == null ? null : fn.call$1(_this);
    }
  },
  Y = {StreamCompleter: function StreamCompleter(t0, t1) {
      this._stream_completer$_stream = t0;
      this.$ti = t1;
    }, _CompleterStream: function _CompleterStream(t0) {
      this._sourceStream = this._stream_completer$_controller = null;
      this.$ti = t0;
    }, Modules: function Modules() {
    }, Module1: function Module1() {
    }, Net: function Net() {
    }, Socket: function Socket() {
    }, NetAddress: function NetAddress() {
    }, NetServer: function NetServer() {
    },
    ContentBlock$($arguments, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new Y.ContentBlock("@content", $arguments, span, t1, t2);
    },
    ContentBlock: function ContentBlock(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.$arguments = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    WarnRule: function WarnRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    SupportsAnything: function SupportsAnything(t0, t1) {
      this.contents = t0;
      this.span = t1;
    },
    unifyComplex(complexes) {
      var t2, unifiedBase, base, t3, t4, _i, complexesWithoutBases,
        t1 = J.getInterceptor$asx(complexes);
      if (t1.get$length(complexes) === 1)
        return complexes;
      for (t2 = t1.get$iterator(complexes), unifiedBase = null; t2.moveNext$0();) {
        base = J.get$last$ax(t2.get$current(t2));
        if (!(base instanceof X.CompoundSelector))
          return null;
        if (unifiedBase == null)
          unifiedBase = base.components;
        else
          for (t3 = base.components, t4 = t3.length, _i = 0; _i < t4; ++_i) {
            unifiedBase = t3[_i].unify$1(unifiedBase);
            if (unifiedBase == null)
              return null;
          }
      }
      t1 = t1.map$1$1(complexes, new Y.unifyComplex_closure(), type$.List_ComplexSelectorComponent);
      complexesWithoutBases = P.List_List$of(t1, true, t1.$ti._eval$1("ListIterable.E"));
      t1 = C.JSArray_methods.get$last(complexesWithoutBases);
      unifiedBase.toString;
      J.add$1$ax(t1, X.CompoundSelector$(unifiedBase));
      return Y.weave(complexesWithoutBases);
    },
    unifyCompound(compound1, compound2) {
      var t1, result, _i, unified;
      for (t1 = compound1.length, result = compound2, _i = 0; _i < t1; ++_i, result = unified) {
        unified = compound1[_i].unify$1(result);
        if (unified == null)
          return null;
      }
      return X.CompoundSelector$(result);
    },
    unifyUniversalAndElement(selector1, selector2) {
      var namespace1, name1, t1, namespace2, name2, namespace, $name, _null = null,
        _s45_ = string$.must_b;
      if (selector1 instanceof N.UniversalSelector) {
        namespace1 = selector1.namespace;
        name1 = _null;
      } else if (selector1 instanceof F.TypeSelector) {
        t1 = selector1.name;
        namespace1 = t1.namespace;
        name1 = t1.name;
      } else
        throw H.wrapException(P.ArgumentError$value(selector1, "selector1", _s45_));
      if (selector2 instanceof N.UniversalSelector) {
        namespace2 = selector2.namespace;
        name2 = _null;
      } else if (selector2 instanceof F.TypeSelector) {
        t1 = selector2.name;
        namespace2 = t1.namespace;
        name2 = t1.name;
      } else
        throw H.wrapException(P.ArgumentError$value(selector2, "selector2", _s45_));
      if (namespace1 == namespace2 || namespace2 === "*")
        namespace = namespace1;
      else {
        if (namespace1 !== "*")
          return _null;
        namespace = namespace2;
      }
      if (name1 == name2 || name2 == null)
        $name = name1;
      else {
        if (!(name1 == null || name1 === "*"))
          return _null;
        $name = name2;
      }
      return $name == null ? new N.UniversalSelector(namespace) : new F.TypeSelector(new D.QualifiedName($name, namespace));
    },
    weave(complexes) {
      var t2, t3, t4, t5, target, _i, parents, newPrefixes, parentPrefixes, t6,
        t1 = type$.JSArray_List_ComplexSelectorComponent,
        prefixes = H._setArrayType([J.toList$0$ax(C.JSArray_methods.get$first(complexes))], t1);
      for (t2 = H.SubListIterable$(complexes, 1, null, H._arrayInstanceType(complexes)._precomputed1), t2 = new H.ListIterator(t2, t2.get$length(t2)), t3 = H._instanceType(t2)._precomputed1; t2.moveNext$0();) {
        t4 = t3._as(t2.__internal$_current);
        t5 = J.getInterceptor$asx(t4);
        if (t5.get$isEmpty(t4))
          continue;
        target = t5.get$last(t4);
        if (t5.get$length(t4) === 1) {
          for (t4 = prefixes.length, _i = 0; _i < prefixes.length; prefixes.length === t4 || (0, H.throwConcurrentModificationError)(prefixes), ++_i)
            J.add$1$ax(prefixes[_i], target);
          continue;
        }
        parents = t5.take$1(t4, t5.get$length(t4) - 1).toList$0(0);
        newPrefixes = H._setArrayType([], t1);
        for (t4 = prefixes.length, _i = 0; _i < prefixes.length; prefixes.length === t4 || (0, H.throwConcurrentModificationError)(prefixes), ++_i) {
          parentPrefixes = Y._weaveParents(prefixes[_i], parents);
          if (parentPrefixes == null)
            continue;
          for (t5 = parentPrefixes.get$iterator(parentPrefixes); t5.moveNext$0();) {
            t6 = t5.get$current(t5);
            J.add$1$ax(t6, target);
            newPrefixes.push(t6);
          }
        }
        prefixes = newPrefixes;
      }
      return prefixes;
    },
    _weaveParents(parents1, parents2) {
      var finalCombinators, root1, root2, root, groups1, groups2, lcs, t2, choices, t3, _i, group, t4, t5, _null = null,
        t1 = type$.ComplexSelectorComponent,
        queue1 = P.ListQueue_ListQueue$of(parents1, t1),
        queue2 = P.ListQueue_ListQueue$of(parents2, t1),
        initialCombinators = Y._mergeInitialCombinators(queue1, queue2);
      if (initialCombinators == null)
        return _null;
      finalCombinators = Y._mergeFinalCombinators(queue1, queue2, _null);
      if (finalCombinators == null)
        return _null;
      root1 = Y._firstIfRoot(queue1);
      root2 = Y._firstIfRoot(queue2);
      t1 = root1 != null;
      if (t1 && root2 != null) {
        root = Y.unifyCompound(root1.components, root2.components);
        if (root == null)
          return _null;
        queue1.addFirst$1(root);
        queue2.addFirst$1(root);
      } else if (t1)
        queue2.addFirst$1(root1);
      else if (root2 != null)
        queue1.addFirst$1(root2);
      groups1 = Y._groupSelectors(queue1);
      groups2 = Y._groupSelectors(queue2);
      t1 = type$.List_ComplexSelectorComponent;
      lcs = B.longestCommonSubsequence(groups2, groups1, new Y._weaveParents_closure(), t1);
      t2 = type$.JSArray_Iterable_ComplexSelectorComponent;
      choices = H._setArrayType([H._setArrayType([initialCombinators], t2)], type$.JSArray_List_Iterable_ComplexSelectorComponent);
      for (t3 = lcs.length, _i = 0; _i < lcs.length; lcs.length === t3 || (0, H.throwConcurrentModificationError)(lcs), ++_i) {
        group = lcs[_i];
        t4 = Y._chunks(groups1, groups2, new Y._weaveParents_closure0(group), t1);
        t5 = H._arrayInstanceType(t4)._eval$1("MappedListIterable<1,Iterable<ComplexSelectorComponent>>");
        choices.push(P.List_List$of(new H.MappedListIterable(t4, new Y._weaveParents_closure1(), t5), true, t5._eval$1("ListIterable.E")));
        choices.push(H._setArrayType([group], t2));
        groups1.removeFirst$0();
        groups2.removeFirst$0();
      }
      t2 = Y._chunks(groups1, groups2, new Y._weaveParents_closure2(), t1);
      t3 = H._arrayInstanceType(t2)._eval$1("MappedListIterable<1,Iterable<ComplexSelectorComponent>>");
      choices.push(P.List_List$of(new H.MappedListIterable(t2, new Y._weaveParents_closure3(), t3), true, t3._eval$1("ListIterable.E")));
      C.JSArray_methods.addAll$1(choices, finalCombinators);
      return J.map$1$1$ax(Y.paths(new H.WhereIterable(choices, new Y._weaveParents_closure4(), type$.WhereIterable_List_Iterable_ComplexSelectorComponent), type$.Iterable_ComplexSelectorComponent), new Y._weaveParents_closure5(), t1);
    },
    _firstIfRoot(queue) {
      var first;
      if (queue._collection$_head === queue._collection$_tail)
        return null;
      first = queue.get$first(queue);
      if (first instanceof X.CompoundSelector) {
        if (!Y._hasRoot(first))
          return null;
        queue.removeFirst$0();
        return first;
      } else
        return null;
    },
    _mergeInitialCombinators(components1, components2) {
      var t4, combinators2, lcs,
        t1 = type$.JSArray_Combinator,
        combinators1 = H._setArrayType([], t1),
        t2 = type$.Combinator,
        t3 = components1.$ti._precomputed1;
      while (true) {
        if (!components1.get$isEmpty(components1)) {
          t4 = components1._collection$_head;
          if (t4 === components1._collection$_tail)
            H.throwExpression(H.IterableElementError_noElement());
          t4 = t3._as(components1._collection$_table[t4]) instanceof S.Combinator;
        } else
          t4 = false;
        if (!t4)
          break;
        combinators1.push(t2._as(components1.removeFirst$0()));
      }
      combinators2 = H._setArrayType([], t1);
      t1 = components2.$ti._precomputed1;
      while (true) {
        if (!components2.get$isEmpty(components2)) {
          t3 = components2._collection$_head;
          if (t3 === components2._collection$_tail)
            H.throwExpression(H.IterableElementError_noElement());
          t3 = t1._as(components2._collection$_table[t3]) instanceof S.Combinator;
        } else
          t3 = false;
        if (!t3)
          break;
        combinators2.push(t2._as(components2.removeFirst$0()));
      }
      lcs = B.longestCommonSubsequence(combinators1, combinators2, null, t2);
      if (C.C_ListEquality.equals$2(0, lcs, combinators1))
        return combinators2;
      if (C.C_ListEquality.equals$2(0, lcs, combinators2))
        return combinators1;
      return null;
    },
    _mergeFinalCombinators(components1, components2, result) {
      var t1, combinators1, t2, combinators2, lcs, combinator1, combinator2, compound1, compound2, choices, unified, followingSiblingSelector, nextSiblingSelector, _null = null;
      if (result == null)
        result = Q.QueueList$(_null, type$.List_List_ComplexSelectorComponent);
      if (components1._collection$_head === components1._collection$_tail || !(components1.get$last(components1) instanceof S.Combinator))
        t1 = components2._collection$_head === components2._collection$_tail || !(components2.get$last(components2) instanceof S.Combinator);
      else
        t1 = false;
      if (t1)
        return result;
      t1 = type$.JSArray_Combinator;
      combinators1 = H._setArrayType([], t1);
      t2 = type$.Combinator;
      while (true) {
        if (!(!components1.get$isEmpty(components1) && components1.get$last(components1) instanceof S.Combinator))
          break;
        combinators1.push(t2._as(components1.removeLast$0(0)));
      }
      combinators2 = H._setArrayType([], t1);
      while (true) {
        if (!(!components2.get$isEmpty(components2) && components2.get$last(components2) instanceof S.Combinator))
          break;
        combinators2.push(t2._as(components2.removeLast$0(0)));
      }
      t1 = combinators1.length;
      if (t1 > 1 || combinators2.length > 1) {
        lcs = B.longestCommonSubsequence(combinators1, combinators2, _null, t2);
        if (C.C_ListEquality.equals$2(0, lcs, combinators1))
          result.addFirst$1(H._setArrayType([P.List_List$of(new H.ReversedListIterable(combinators2, type$.ReversedListIterable_Combinator), true, type$.ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
        else if (C.C_ListEquality.equals$2(0, lcs, combinators2))
          result.addFirst$1(H._setArrayType([P.List_List$of(new H.ReversedListIterable(combinators1, type$.ReversedListIterable_Combinator), true, type$.ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
        else
          return _null;
        return result;
      }
      combinator1 = t1 === 0 ? _null : C.JSArray_methods.get$first(combinators1);
      combinator2 = combinators2.length === 0 ? _null : C.JSArray_methods.get$first(combinators2);
      t1 = combinator1 != null;
      if (t1 && combinator2 != null) {
        t1 = type$.CompoundSelector;
        compound1 = t1._as(components1.removeLast$0(0));
        compound2 = t1._as(components2.removeLast$0(0));
        t1 = combinator1 === C.Combinator_CzM;
        if (t1 && combinator2 === C.Combinator_CzM)
          if (Y.compoundIsSuperselector(compound1, compound2, _null))
            result.addFirst$1(H._setArrayType([H._setArrayType([compound2, C.Combinator_CzM], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
          else {
            t1 = type$.JSArray_ComplexSelectorComponent;
            t2 = type$.JSArray_List_ComplexSelectorComponent;
            if (Y.compoundIsSuperselector(compound2, compound1, _null))
              result.addFirst$1(H._setArrayType([H._setArrayType([compound1, C.Combinator_CzM], t1)], t2));
            else {
              choices = H._setArrayType([H._setArrayType([compound1, C.Combinator_CzM, compound2, C.Combinator_CzM], t1), H._setArrayType([compound2, C.Combinator_CzM, compound1, C.Combinator_CzM], t1)], t2);
              unified = Y.unifyCompound(compound1.components, compound2.components);
              if (unified != null)
                choices.push(H._setArrayType([unified, C.Combinator_CzM], t1));
              result.addFirst$1(choices);
            }
          }
        else {
          if (!(t1 && combinator2 === C.Combinator_uzg))
            t2 = combinator1 === C.Combinator_uzg && combinator2 === C.Combinator_CzM;
          else
            t2 = true;
          if (t2) {
            followingSiblingSelector = t1 ? compound1 : compound2;
            nextSiblingSelector = t1 ? compound2 : compound1;
            t1 = type$.JSArray_ComplexSelectorComponent;
            t2 = type$.JSArray_List_ComplexSelectorComponent;
            if (Y.compoundIsSuperselector(followingSiblingSelector, nextSiblingSelector, _null))
              result.addFirst$1(H._setArrayType([H._setArrayType([nextSiblingSelector, C.Combinator_uzg], t1)], t2));
            else {
              unified = Y.unifyCompound(compound1.components, compound2.components);
              t2 = H._setArrayType([H._setArrayType([followingSiblingSelector, C.Combinator_CzM, nextSiblingSelector, C.Combinator_uzg], t1)], t2);
              if (unified != null)
                t2.push(H._setArrayType([unified, C.Combinator_uzg], t1));
              result.addFirst$1(t2);
            }
          } else {
            if (combinator1 === C.Combinator_sgq)
              t2 = combinator2 === C.Combinator_uzg || combinator2 === C.Combinator_CzM;
            else
              t2 = false;
            if (t2) {
              result.addFirst$1(H._setArrayType([H._setArrayType([compound2, combinator2], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
              components1._add$1(compound1);
              components1._add$1(C.Combinator_sgq);
            } else {
              if (combinator2 === C.Combinator_sgq)
                t1 = combinator1 === C.Combinator_uzg || t1;
              else
                t1 = false;
              if (t1) {
                result.addFirst$1(H._setArrayType([H._setArrayType([compound1, combinator1], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
                components2._add$1(compound2);
                components2._add$1(C.Combinator_sgq);
              } else if (combinator1 === combinator2) {
                unified = Y.unifyCompound(compound1.components, compound2.components);
                if (unified == null)
                  return _null;
                result.addFirst$1(H._setArrayType([H._setArrayType([unified, combinator1], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
              } else
                return _null;
            }
          }
        }
        return Y._mergeFinalCombinators(components1, components2, result);
      } else if (t1) {
        if (combinator1 === C.Combinator_sgq)
          if (!components2.get$isEmpty(components2)) {
            t1 = type$.CompoundSelector;
            t1 = Y.compoundIsSuperselector(t1._as(components2.get$last(components2)), t1._as(components1.get$last(components1)), _null);
          } else
            t1 = false;
        else
          t1 = false;
        if (t1)
          components2.removeLast$0(0);
        result.addFirst$1(H._setArrayType([H._setArrayType([components1.removeLast$0(0), combinator1], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
        return Y._mergeFinalCombinators(components1, components2, result);
      } else {
        if (combinator2 === C.Combinator_sgq)
          if (!components1.get$isEmpty(components1)) {
            t1 = type$.CompoundSelector;
            t1 = Y.compoundIsSuperselector(t1._as(components1.get$last(components1)), t1._as(components2.get$last(components2)), _null);
          } else
            t1 = false;
        else
          t1 = false;
        if (t1)
          components1.removeLast$0(0);
        t1 = components2.removeLast$0(0);
        combinator2.toString;
        result.addFirst$1(H._setArrayType([H._setArrayType([t1, combinator2], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
        return Y._mergeFinalCombinators(components1, components2, result);
      }
    },
    _mustUnify(complex1, complex2) {
      var t2, t3, t4,
        t1 = P.LinkedHashSet_LinkedHashSet$_empty(type$.SimpleSelector);
      for (t2 = J.get$iterator$ax(complex1); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3 instanceof X.CompoundSelector)
          for (t3 = C.JSArray_methods.get$iterator(t3.components), t4 = new H.WhereIterator(t3, Y.functions___isUnique$closure()); t4.moveNext$0();)
            t1.add$1(0, t3.get$current(t3));
      }
      if (t1._collection$_length === 0)
        return false;
      return J.any$1$ax(complex2, new Y._mustUnify_closure(t1));
    },
    _isUnique(simple) {
      var t1;
      if (!(simple instanceof N.IDSelector))
        t1 = simple instanceof D.PseudoSelector && !simple.isClass;
      else
        t1 = true;
      return t1;
    },
    _chunks(queue1, queue2, done, $T) {
      var chunk2, t2,
        t1 = $T._eval$1("JSArray<0>"),
        chunk1 = H._setArrayType([], t1);
      for (; !done.call$1(queue1);)
        chunk1.push(queue1.removeFirst$0());
      chunk2 = H._setArrayType([], t1);
      for (; !done.call$1(queue2);)
        chunk2.push(queue2.removeFirst$0());
      t1 = chunk1.length === 0;
      if (t1 && chunk2.length === 0)
        return H._setArrayType([], $T._eval$1("JSArray<List<0>>"));
      if (t1)
        return H._setArrayType([chunk2], $T._eval$1("JSArray<List<0>>"));
      if (chunk2.length === 0)
        return H._setArrayType([chunk1], $T._eval$1("JSArray<List<0>>"));
      t1 = P.List_List$of(chunk1, true, $T);
      C.JSArray_methods.addAll$1(t1, chunk2);
      t2 = P.List_List$of(chunk2, true, $T);
      C.JSArray_methods.addAll$1(t2, chunk1);
      return H._setArrayType([t1, t2], $T._eval$1("JSArray<List<0>>"));
    },
    paths(choices, $T) {
      return J.fold$2$ax(choices, H._setArrayType([H._setArrayType([], $T._eval$1("JSArray<0>"))], $T._eval$1("JSArray<List<0>>")), new Y.paths_closure($T));
    },
    _groupSelectors(complex) {
      var t1, t2, group, t3, t4,
        groups = Q.QueueList$(null, type$.List_ComplexSelectorComponent),
        iterator = P._ListQueueIterator$(complex);
      if (!iterator.moveNext$0())
        return groups;
      t1 = H._instanceType(iterator)._precomputed1;
      t2 = type$.JSArray_ComplexSelectorComponent;
      group = H._setArrayType([t1._as(iterator._collection$_current)], t2);
      groups._queue_list$_add$1(group);
      for (; iterator.moveNext$0();) {
        t3 = C.JSArray_methods.get$last(group) instanceof S.Combinator || t1._as(iterator._collection$_current) instanceof S.Combinator;
        t4 = iterator._collection$_current;
        if (t3)
          group.push(t1._as(t4));
        else {
          group = H._setArrayType([t1._as(t4)], t2);
          groups._queue_list$_add$1(group);
        }
      }
      return groups;
    },
    _hasRoot(compound) {
      return C.JSArray_methods.any$1(compound.components, new Y._hasRoot_closure());
    },
    listIsSuperselector(list1, list2) {
      return C.JSArray_methods.every$1(list2, new Y.listIsSuperselector_closure(list1));
    },
    complexIsParentSuperselector(complex1, complex2) {
      var t2, base,
        t1 = J.getInterceptor$ax(complex1);
      if (t1.get$first(complex1) instanceof S.Combinator)
        return false;
      t2 = J.getInterceptor$ax(complex2);
      if (t2.get$first(complex2) instanceof S.Combinator)
        return false;
      if (t1.get$length(complex1) > t2.get$length(complex2))
        return false;
      base = X.CompoundSelector$(H._setArrayType([new N.PlaceholderSelector("<temp>")], type$.JSArray_SimpleSelector));
      t1 = type$.ComplexSelectorComponent;
      t2 = P.List_List$of(complex1, true, t1);
      t2.push(base);
      t1 = P.List_List$of(complex2, true, t1);
      t1.push(base);
      return Y.complexIsSuperselector(t2, t1);
    },
    complexIsSuperselector(complex1, complex2) {
      var t1, t2, t3, i1, i2, remaining1, remaining2, t4, t5, t6, afterSuperselector, afterSuperselector0, compound2, i10, combinator1, combinator2;
      if (C.JSArray_methods.get$last(complex1) instanceof S.Combinator)
        return false;
      if (C.JSArray_methods.get$last(complex2) instanceof S.Combinator)
        return false;
      for (t1 = H._arrayInstanceType(complex2), t2 = t1._precomputed1, t1 = t1._eval$1("SubListIterable<1>"), t3 = type$.CompoundSelector, i1 = 0, i2 = 0; true;) {
        remaining1 = complex1.length - i1;
        remaining2 = complex2.length - i2;
        if (remaining1 === 0 || remaining2 === 0)
          return false;
        if (remaining1 > remaining2)
          return false;
        t4 = complex1[i1];
        if (t4 instanceof S.Combinator)
          return false;
        if (complex2[i2] instanceof S.Combinator)
          return false;
        t3._as(t4);
        if (remaining1 === 1) {
          t5 = t3._as(C.JSArray_methods.get$last(complex2));
          t6 = complex2.length - 1;
          t3 = new H.SubListIterable(complex2, 0, t6, t1);
          t3.SubListIterable$3(complex2, 0, t6, t2);
          return Y.compoundIsSuperselector(t4, t5, t3.skip$1(0, i2));
        }
        afterSuperselector = i2 + 1;
        for (afterSuperselector0 = afterSuperselector; afterSuperselector0 < complex2.length; ++afterSuperselector0) {
          t5 = afterSuperselector0 - 1;
          compound2 = complex2[t5];
          if (compound2 instanceof X.CompoundSelector) {
            t6 = new H.SubListIterable(complex2, 0, t5, t1);
            t6.SubListIterable$3(complex2, 0, t5, t2);
            if (Y.compoundIsSuperselector(t4, compound2, t6.skip$1(0, afterSuperselector)))
              break;
          }
        }
        if (afterSuperselector0 === complex2.length)
          return false;
        i10 = i1 + 1;
        combinator1 = complex1[i10];
        combinator2 = complex2[afterSuperselector0];
        if (combinator1 instanceof S.Combinator) {
          if (!(combinator2 instanceof S.Combinator))
            return false;
          if (combinator1 === C.Combinator_CzM) {
            if (combinator2 === C.Combinator_sgq)
              return false;
          } else if (combinator2 !== combinator1)
            return false;
          if (remaining1 === 3 && remaining2 > 3)
            return false;
          i1 += 2;
          i2 = afterSuperselector0 + 1;
        } else {
          if (combinator2 instanceof S.Combinator) {
            if (combinator2 !== C.Combinator_sgq)
              return false;
            i2 = afterSuperselector0 + 1;
          } else
            i2 = afterSuperselector0;
          i1 = i10;
        }
      }
    },
    compoundIsSuperselector(compound1, compound2, parents) {
      var t1, t2, _i, simple1, simple2;
      for (t1 = compound1.components, t2 = t1.length, _i = 0; _i < t2; ++_i) {
        simple1 = t1[_i];
        if (simple1 instanceof D.PseudoSelector && simple1.selector != null) {
          if (!Y._selectorPseudoIsSuperselector(simple1, compound2, parents))
            return false;
        } else if (!Y._simpleIsSuperselectorOfCompound(simple1, compound2))
          return false;
      }
      for (t1 = compound2.components, t2 = t1.length, _i = 0; _i < t2; ++_i) {
        simple2 = t1[_i];
        if (simple2 instanceof D.PseudoSelector && !simple2.isClass && simple2.selector == null && !Y._simpleIsSuperselectorOfCompound(simple2, compound1))
          return false;
      }
      return true;
    },
    _simpleIsSuperselectorOfCompound(simple, compound) {
      return C.JSArray_methods.any$1(compound.components, new Y._simpleIsSuperselectorOfCompound_closure(simple));
    },
    _selectorPseudoIsSuperselector(pseudo1, compound2, parents) {
      var selector1_ = pseudo1.selector;
      if (selector1_ == null)
        throw H.wrapException(P.ArgumentError$("Selector " + pseudo1.toString$0(0) + " must have a selector argument.", null));
      switch (pseudo1.normalizedName) {
        case "is":
        case "matches":
        case "any":
          return Y._selectorPseudoArgs(compound2, pseudo1.name, true).any$1(0, new Y._selectorPseudoIsSuperselector_closure(selector1_)) || C.JSArray_methods.any$1(selector1_.components, new Y._selectorPseudoIsSuperselector_closure0(parents, compound2));
        case "has":
        case "host":
        case "host-context":
          return Y._selectorPseudoArgs(compound2, pseudo1.name, true).any$1(0, new Y._selectorPseudoIsSuperselector_closure1(selector1_));
        case "slotted":
          return Y._selectorPseudoArgs(compound2, pseudo1.name, false).any$1(0, new Y._selectorPseudoIsSuperselector_closure2(selector1_));
        case "not":
          return C.JSArray_methods.every$1(selector1_.components, new Y._selectorPseudoIsSuperselector_closure3(compound2, pseudo1));
        case "current":
          return Y._selectorPseudoArgs(compound2, pseudo1.name, true).any$1(0, new Y._selectorPseudoIsSuperselector_closure4(selector1_));
        case "nth-child":
        case "nth-last-child":
          return C.JSArray_methods.any$1(compound2.components, new Y._selectorPseudoIsSuperselector_closure5(pseudo1, selector1_));
        default:
          throw H.wrapException("unreachable");
      }
    },
    _selectorPseudoArgs(compound, $name, isClass) {
      var t1 = type$.WhereTypeIterable_PseudoSelector;
      return A.IterableNullableExtension_whereNotNull(new H.MappedIterable(new H.WhereIterable(new H.WhereTypeIterable(compound.components, t1), new Y._selectorPseudoArgs_closure(isClass, $name), t1._eval$1("WhereIterable<Iterable.E>")), new Y._selectorPseudoArgs_closure0(), t1._eval$1("MappedIterable<Iterable.E,SelectorList?>")), type$.SelectorList);
    },
    unifyComplex_closure: function unifyComplex_closure() {
    },
    _weaveParents_closure: function _weaveParents_closure() {
    },
    _weaveParents_closure0: function _weaveParents_closure0(t0) {
      this.group = t0;
    },
    _weaveParents_closure1: function _weaveParents_closure1() {
    },
    _weaveParents__closure1: function _weaveParents__closure1() {
    },
    _weaveParents_closure2: function _weaveParents_closure2() {
    },
    _weaveParents_closure3: function _weaveParents_closure3() {
    },
    _weaveParents__closure0: function _weaveParents__closure0() {
    },
    _weaveParents_closure4: function _weaveParents_closure4() {
    },
    _weaveParents_closure5: function _weaveParents_closure5() {
    },
    _weaveParents__closure: function _weaveParents__closure() {
    },
    _mustUnify_closure: function _mustUnify_closure(t0) {
      this.uniqueSelectors = t0;
    },
    _mustUnify__closure: function _mustUnify__closure(t0) {
      this.uniqueSelectors = t0;
    },
    paths_closure: function paths_closure(t0) {
      this.T = t0;
    },
    paths__closure: function paths__closure(t0, t1) {
      this.paths = t0;
      this.T = t1;
    },
    paths___closure: function paths___closure(t0, t1) {
      this.option = t0;
      this.T = t1;
    },
    _hasRoot_closure: function _hasRoot_closure() {
    },
    listIsSuperselector_closure: function listIsSuperselector_closure(t0) {
      this.list1 = t0;
    },
    listIsSuperselector__closure: function listIsSuperselector__closure(t0) {
      this.complex1 = t0;
    },
    _simpleIsSuperselectorOfCompound_closure: function _simpleIsSuperselectorOfCompound_closure(t0) {
      this.simple = t0;
    },
    _simpleIsSuperselectorOfCompound__closure: function _simpleIsSuperselectorOfCompound__closure(t0) {
      this.simple = t0;
    },
    _selectorPseudoIsSuperselector_closure: function _selectorPseudoIsSuperselector_closure(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure0: function _selectorPseudoIsSuperselector_closure0(t0, t1) {
      this.parents = t0;
      this.compound2 = t1;
    },
    _selectorPseudoIsSuperselector_closure1: function _selectorPseudoIsSuperselector_closure1(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure2: function _selectorPseudoIsSuperselector_closure2(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure3: function _selectorPseudoIsSuperselector_closure3(t0, t1) {
      this.compound2 = t0;
      this.pseudo1 = t1;
    },
    _selectorPseudoIsSuperselector__closure: function _selectorPseudoIsSuperselector__closure(t0, t1) {
      this.complex = t0;
      this.pseudo1 = t1;
    },
    _selectorPseudoIsSuperselector___closure: function _selectorPseudoIsSuperselector___closure(t0) {
      this.simple2 = t0;
    },
    _selectorPseudoIsSuperselector___closure0: function _selectorPseudoIsSuperselector___closure0(t0) {
      this.simple2 = t0;
    },
    _selectorPseudoIsSuperselector_closure4: function _selectorPseudoIsSuperselector_closure4(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure5: function _selectorPseudoIsSuperselector_closure5(t0, t1) {
      this.pseudo1 = t0;
      this.selector1 = t1;
    },
    _selectorPseudoArgs_closure: function _selectorPseudoArgs_closure(t0, t1) {
      this.isClass = t0;
      this.name = t1;
    },
    _selectorPseudoArgs_closure0: function _selectorPseudoArgs_closure0() {
    },
    currentCallableSpan() {
      var node = $.Zone__current.$index(0, C.Symbol__currentCallableNode);
      if (type$.AstNode._is(node))
        return node.get$span();
      throw H.wrapException(P.StateError$(string$.curren));
    },
    globalFunctions_closure: function globalFunctions_closure() {
    },
    TerseLogger: function TerseLogger(t0, t1) {
      this._warningCounts = t0;
      this._inner = t1;
    },
    TerseLogger_summarize_closure: function TerseLogger_summarize_closure() {
    },
    TerseLogger_summarize_closure0: function TerseLogger_summarize_closure0() {
    },
    Chokidar: function Chokidar() {
    },
    ChokidarOptions: function ChokidarOptions() {
    },
    ChokidarWatcher: function ChokidarWatcher() {
    },
    SourceFile$fromString(text, url) {
      var t1 = new H.CodeUnits(text),
        t2 = H._setArrayType([0], type$.JSArray_int),
        t3 = typeof url == "string" ? P.Uri_parse(url) : type$.nullable_Uri._as(url);
      t2 = new Y.SourceFile(t3, t2, new Uint32Array(H._ensureNativeList(t1.toList$0(t1))));
      t2.SourceFile$decoded$2$url(t1, url);
      return t2;
    },
    SourceFile$decoded(decodedChars, url) {
      var t1 = H._setArrayType([0], type$.JSArray_int),
        t2 = typeof url == "string" ? P.Uri_parse(url) : type$.nullable_Uri._as(url);
      t1 = new Y.SourceFile(t2, t1, new Uint32Array(H._ensureNativeList(J.toList$0$ax(decodedChars))));
      t1.SourceFile$decoded$2$url(decodedChars, url);
      return t1;
    },
    FileLocation$_(file, offset) {
      if (offset < 0)
        H.throwExpression(P.RangeError$("Offset may not be negative, was " + offset + "."));
      else if (offset > file._decodedChars.length)
        H.throwExpression(P.RangeError$("Offset " + offset + string$.x20must_ + file.get$length(file) + "."));
      return new Y.FileLocation(file, offset);
    },
    _FileSpan$(file, _start, _end) {
      if (_end < _start)
        H.throwExpression(P.ArgumentError$("End " + _end + " must come after start " + _start + ".", null));
      else if (_end > file._decodedChars.length)
        H.throwExpression(P.RangeError$("End " + _end + string$.x20must_ + file.get$length(file) + "."));
      else if (_start < 0)
        H.throwExpression(P.RangeError$("Start may not be negative, was " + _start + "."));
      return new Y._FileSpan(file, _start, _end);
    },
    FileSpanExtension_subspan(_this, start, end) {
      var startOffset,
        t1 = _this._end,
        t2 = _this._file$_start,
        t3 = t1 - t2;
      P.RangeError_checkValidRange(start, end, t3);
      if (start === 0)
        t3 = end == null || end === t3;
      else
        t3 = false;
      if (t3)
        return _this;
      t3 = _this.file;
      startOffset = Y.FileLocation$_(t3, t2).offset;
      t1 = end == null ? Y.FileLocation$_(t3, t1).offset : startOffset + end;
      return t3.span$2(startOffset + start, t1);
    },
    SourceFile: function SourceFile(t0, t1, t2) {
      var _ = this;
      _.url = t0;
      _._lineStarts = t1;
      _._decodedChars = t2;
      _._cachedLine = null;
    },
    FileLocation: function FileLocation(t0, t1) {
      this.file = t0;
      this.offset = t1;
    },
    _FileSpan: function _FileSpan(t0, t1, t2) {
      this.file = t0;
      this._file$_start = t1;
      this._end = t2;
    },
    SourceSpanMixin: function SourceSpanMixin() {
    },
    Trace_Trace$from(trace) {
      if (type$.Trace._is(trace))
        return trace;
      if (trace instanceof U.Chain)
        return trace.toTrace$0();
      return new T.LazyTrace(new Y.Trace_Trace$from_closure(trace));
    },
    Trace_Trace$parse(trace) {
      var error, t1, exception;
      try {
        if (trace.length === 0) {
          t1 = Y.Trace$(H._setArrayType([], type$.JSArray_Frame), null);
          return t1;
        }
        if (C.JSString_methods.contains$1(trace, $.$get$_v8Trace())) {
          t1 = Y.Trace$parseV8(trace);
          return t1;
        }
        if (C.JSString_methods.contains$1(trace, "\tat ")) {
          t1 = Y.Trace$parseJSCore(trace);
          return t1;
        }
        if (C.JSString_methods.contains$1(trace, $.$get$_firefoxSafariTrace()) || C.JSString_methods.contains$1(trace, $.$get$_firefoxEvalTrace())) {
          t1 = Y.Trace$parseFirefox(trace);
          return t1;
        }
        if (C.JSString_methods.contains$1(trace, string$.x3d_____)) {
          t1 = U.Chain_Chain$parse(trace).toTrace$0();
          return t1;
        }
        if (C.JSString_methods.contains$1(trace, $.$get$_friendlyTrace())) {
          t1 = Y.Trace$parseFriendly(trace);
          return t1;
        }
        t1 = Y.Trace$parseVM(trace);
        return t1;
      } catch (exception) {
        t1 = H.unwrapException(exception);
        if (type$.FormatException._is(t1)) {
          error = t1;
          throw H.wrapException(P.FormatException$(J.get$message$x(error) + "\nStack trace:\n" + trace, null, null));
        } else
          throw exception;
      }
    },
    Trace$parseVM(trace) {
      var t1 = P.List_List$unmodifiable(Y.Trace__parseVM(trace), type$.Frame);
      return new Y.Trace(t1, new P._StringStackTrace(trace));
    },
    Trace__parseVM(trace) {
      var $frames,
        t1 = C.JSString_methods.trim$0(trace),
        t2 = $.$get$vmChainGap(),
        t3 = type$.WhereIterable_String,
        lines = new H.WhereIterable(H._setArrayType(H.stringReplaceAllUnchecked(t1, t2, "").split("\n"), type$.JSArray_String), new Y.Trace__parseVM_closure(), t3);
      if (!lines.get$iterator(lines).moveNext$0())
        return H._setArrayType([], type$.JSArray_Frame);
      t1 = H.TakeIterable_TakeIterable(lines, lines.get$length(lines) - 1, t3._eval$1("Iterable.E"));
      t1 = H.MappedIterable_MappedIterable(t1, new Y.Trace__parseVM_closure0(), H._instanceType(t1)._eval$1("Iterable.E"), type$.Frame);
      $frames = P.List_List$of(t1, true, H._instanceType(t1)._eval$1("Iterable.E"));
      if (!J.endsWith$1$s(lines.get$last(lines), ".da"))
        C.JSArray_methods.add$1($frames, A.Frame_Frame$parseVM(lines.get$last(lines)));
      return $frames;
    },
    Trace$parseV8(trace) {
      var t1 = H.SubListIterable$(H._setArrayType(trace.split("\n"), type$.JSArray_String), 1, null, type$.String).super$Iterable$skipWhile(0, new Y.Trace$parseV8_closure()),
        t2 = type$.Frame;
      t2 = P.List_List$unmodifiable(H.MappedIterable_MappedIterable(t1, new Y.Trace$parseV8_closure0(), t1.$ti._eval$1("Iterable.E"), t2), t2);
      return new Y.Trace(t2, new P._StringStackTrace(trace));
    },
    Trace$parseJSCore(trace) {
      var t1 = P.List_List$unmodifiable(new H.MappedIterable(new H.WhereIterable(H._setArrayType(trace.split("\n"), type$.JSArray_String), new Y.Trace$parseJSCore_closure(), type$.WhereIterable_String), new Y.Trace$parseJSCore_closure0(), type$.MappedIterable_String_Frame), type$.Frame);
      return new Y.Trace(t1, new P._StringStackTrace(trace));
    },
    Trace$parseFirefox(trace) {
      var t1 = P.List_List$unmodifiable(new H.MappedIterable(new H.WhereIterable(H._setArrayType(C.JSString_methods.trim$0(trace).split("\n"), type$.JSArray_String), new Y.Trace$parseFirefox_closure(), type$.WhereIterable_String), new Y.Trace$parseFirefox_closure0(), type$.MappedIterable_String_Frame), type$.Frame);
      return new Y.Trace(t1, new P._StringStackTrace(trace));
    },
    Trace$parseFriendly(trace) {
      var t1 = trace.length === 0 ? H._setArrayType([], type$.JSArray_Frame) : new H.MappedIterable(new H.WhereIterable(H._setArrayType(C.JSString_methods.trim$0(trace).split("\n"), type$.JSArray_String), new Y.Trace$parseFriendly_closure(), type$.WhereIterable_String), new Y.Trace$parseFriendly_closure0(), type$.MappedIterable_String_Frame);
      t1 = P.List_List$unmodifiable(t1, type$.Frame);
      return new Y.Trace(t1, new P._StringStackTrace(trace));
    },
    Trace$($frames, original) {
      var t1 = P.List_List$unmodifiable($frames, type$.Frame);
      return new Y.Trace(t1, new P._StringStackTrace(original == null ? "" : original));
    },
    Trace: function Trace(t0, t1) {
      this.frames = t0;
      this.original = t1;
    },
    Trace_Trace$from_closure: function Trace_Trace$from_closure(t0) {
      this.trace = t0;
    },
    Trace__parseVM_closure: function Trace__parseVM_closure() {
    },
    Trace__parseVM_closure0: function Trace__parseVM_closure0() {
    },
    Trace$parseV8_closure: function Trace$parseV8_closure() {
    },
    Trace$parseV8_closure0: function Trace$parseV8_closure0() {
    },
    Trace$parseJSCore_closure: function Trace$parseJSCore_closure() {
    },
    Trace$parseJSCore_closure0: function Trace$parseJSCore_closure0() {
    },
    Trace$parseFirefox_closure: function Trace$parseFirefox_closure() {
    },
    Trace$parseFirefox_closure0: function Trace$parseFirefox_closure0() {
    },
    Trace$parseFriendly_closure: function Trace$parseFriendly_closure() {
    },
    Trace$parseFriendly_closure0: function Trace$parseFriendly_closure0() {
    },
    Trace_terse_closure: function Trace_terse_closure() {
    },
    Trace_foldFrames_closure: function Trace_foldFrames_closure(t0) {
      this.oldPredicate = t0;
    },
    Trace_foldFrames_closure0: function Trace_foldFrames_closure0(t0) {
      this._box_0 = t0;
    },
    Trace_toString_closure0: function Trace_toString_closure0() {
    },
    Trace_toString_closure: function Trace_toString_closure(t0) {
      this.longest = t0;
    },
    SupportsAnything0: function SupportsAnything0(t0, t1) {
      this.contents = t0;
      this.span = t1;
    },
    Chokidar0: function Chokidar0() {
    },
    ChokidarOptions0: function ChokidarOptions0() {
    },
    ChokidarWatcher0: function ChokidarWatcher0() {
    },
    ContentBlock$0($arguments, children, span) {
      var t1 = P.List_List$unmodifiable(children, type$.Statement_2),
        t2 = C.JSArray_methods.any$1(t1, new M.ParentStatement_closure0());
      return new Y.ContentBlock0("@content", $arguments, span, t1, t2);
    },
    ContentBlock0: function ContentBlock0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.$arguments = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    unifyComplex0(complexes) {
      var t2, unifiedBase, base, t3, t4, _i, complexesWithoutBases,
        t1 = J.getInterceptor$asx(complexes);
      if (t1.get$length(complexes) === 1)
        return complexes;
      for (t2 = t1.get$iterator(complexes), unifiedBase = null; t2.moveNext$0();) {
        base = J.get$last$ax(t2.get$current(t2));
        if (!(base instanceof X.CompoundSelector0))
          return null;
        if (unifiedBase == null)
          unifiedBase = base.components;
        else
          for (t3 = base.components, t4 = t3.length, _i = 0; _i < t4; ++_i) {
            unifiedBase = t3[_i].unify$1(unifiedBase);
            if (unifiedBase == null)
              return null;
          }
      }
      t1 = t1.map$1$1(complexes, new Y.unifyComplex_closure0(), type$.List_ComplexSelectorComponent_2);
      complexesWithoutBases = P.List_List$of(t1, true, t1.$ti._eval$1("ListIterable.E"));
      t1 = C.JSArray_methods.get$last(complexesWithoutBases);
      unifiedBase.toString;
      J.add$1$ax(t1, X.CompoundSelector$0(unifiedBase));
      return Y.weave0(complexesWithoutBases);
    },
    unifyCompound0(compound1, compound2) {
      var t1, result, _i, unified;
      for (t1 = compound1.length, result = compound2, _i = 0; _i < t1; ++_i, result = unified) {
        unified = compound1[_i].unify$1(result);
        if (unified == null)
          return null;
      }
      return X.CompoundSelector$0(result);
    },
    unifyUniversalAndElement0(selector1, selector2) {
      var namespace1, name1, t1, namespace2, name2, namespace, $name, _null = null,
        _s45_ = string$.must_b;
      if (selector1 instanceof N.UniversalSelector0) {
        namespace1 = selector1.namespace;
        name1 = _null;
      } else if (selector1 instanceof F.TypeSelector0) {
        t1 = selector1.name;
        namespace1 = t1.namespace;
        name1 = t1.name;
      } else
        throw H.wrapException(P.ArgumentError$value(selector1, "selector1", _s45_));
      if (selector2 instanceof N.UniversalSelector0) {
        namespace2 = selector2.namespace;
        name2 = _null;
      } else if (selector2 instanceof F.TypeSelector0) {
        t1 = selector2.name;
        namespace2 = t1.namespace;
        name2 = t1.name;
      } else
        throw H.wrapException(P.ArgumentError$value(selector2, "selector2", _s45_));
      if (namespace1 == namespace2 || namespace2 === "*")
        namespace = namespace1;
      else {
        if (namespace1 !== "*")
          return _null;
        namespace = namespace2;
      }
      if (name1 == name2 || name2 == null)
        $name = name1;
      else {
        if (!(name1 == null || name1 === "*"))
          return _null;
        $name = name2;
      }
      return $name == null ? new N.UniversalSelector0(namespace) : new F.TypeSelector0(new D.QualifiedName0($name, namespace));
    },
    weave0(complexes) {
      var t2, t3, t4, t5, target, _i, parents, newPrefixes, parentPrefixes, t6,
        t1 = type$.JSArray_List_ComplexSelectorComponent_2,
        prefixes = H._setArrayType([J.toList$0$ax(C.JSArray_methods.get$first(complexes))], t1);
      for (t2 = H.SubListIterable$(complexes, 1, null, H._arrayInstanceType(complexes)._precomputed1), t2 = new H.ListIterator(t2, t2.get$length(t2)), t3 = H._instanceType(t2)._precomputed1; t2.moveNext$0();) {
        t4 = t3._as(t2.__internal$_current);
        t5 = J.getInterceptor$asx(t4);
        if (t5.get$isEmpty(t4))
          continue;
        target = t5.get$last(t4);
        if (t5.get$length(t4) === 1) {
          for (t4 = prefixes.length, _i = 0; _i < prefixes.length; prefixes.length === t4 || (0, H.throwConcurrentModificationError)(prefixes), ++_i)
            J.add$1$ax(prefixes[_i], target);
          continue;
        }
        parents = t5.take$1(t4, t5.get$length(t4) - 1).toList$0(0);
        newPrefixes = H._setArrayType([], t1);
        for (t4 = prefixes.length, _i = 0; _i < prefixes.length; prefixes.length === t4 || (0, H.throwConcurrentModificationError)(prefixes), ++_i) {
          parentPrefixes = Y._weaveParents0(prefixes[_i], parents);
          if (parentPrefixes == null)
            continue;
          for (t5 = parentPrefixes.get$iterator(parentPrefixes); t5.moveNext$0();) {
            t6 = t5.get$current(t5);
            J.add$1$ax(t6, target);
            newPrefixes.push(t6);
          }
        }
        prefixes = newPrefixes;
      }
      return prefixes;
    },
    _weaveParents0(parents1, parents2) {
      var finalCombinators, root1, root2, root, groups1, groups2, lcs, t2, choices, t3, _i, group, t4, t5, _null = null,
        t1 = type$.ComplexSelectorComponent_2,
        queue1 = P.ListQueue_ListQueue$of(parents1, t1),
        queue2 = P.ListQueue_ListQueue$of(parents2, t1),
        initialCombinators = Y._mergeInitialCombinators0(queue1, queue2);
      if (initialCombinators == null)
        return _null;
      finalCombinators = Y._mergeFinalCombinators0(queue1, queue2, _null);
      if (finalCombinators == null)
        return _null;
      root1 = Y._firstIfRoot0(queue1);
      root2 = Y._firstIfRoot0(queue2);
      t1 = root1 != null;
      if (t1 && root2 != null) {
        root = Y.unifyCompound0(root1.components, root2.components);
        if (root == null)
          return _null;
        queue1.addFirst$1(root);
        queue2.addFirst$1(root);
      } else if (t1)
        queue2.addFirst$1(root1);
      else if (root2 != null)
        queue1.addFirst$1(root2);
      groups1 = Y._groupSelectors0(queue1);
      groups2 = Y._groupSelectors0(queue2);
      t1 = type$.List_ComplexSelectorComponent_2;
      lcs = B.longestCommonSubsequence0(groups2, groups1, new Y._weaveParents_closure6(), t1);
      t2 = type$.JSArray_Iterable_ComplexSelectorComponent_2;
      choices = H._setArrayType([H._setArrayType([initialCombinators], t2)], type$.JSArray_List_Iterable_ComplexSelectorComponent_2);
      for (t3 = lcs.length, _i = 0; _i < lcs.length; lcs.length === t3 || (0, H.throwConcurrentModificationError)(lcs), ++_i) {
        group = lcs[_i];
        t4 = Y._chunks0(groups1, groups2, new Y._weaveParents_closure7(group), t1);
        t5 = H._arrayInstanceType(t4)._eval$1("MappedListIterable<1,Iterable<ComplexSelectorComponent0>>");
        choices.push(P.List_List$of(new H.MappedListIterable(t4, new Y._weaveParents_closure8(), t5), true, t5._eval$1("ListIterable.E")));
        choices.push(H._setArrayType([group], t2));
        groups1.removeFirst$0();
        groups2.removeFirst$0();
      }
      t2 = Y._chunks0(groups1, groups2, new Y._weaveParents_closure9(), t1);
      t3 = H._arrayInstanceType(t2)._eval$1("MappedListIterable<1,Iterable<ComplexSelectorComponent0>>");
      choices.push(P.List_List$of(new H.MappedListIterable(t2, new Y._weaveParents_closure10(), t3), true, t3._eval$1("ListIterable.E")));
      C.JSArray_methods.addAll$1(choices, finalCombinators);
      return J.map$1$1$ax(Y.paths0(new H.WhereIterable(choices, new Y._weaveParents_closure11(), type$.WhereIterable_List_Iterable_ComplexSelectorComponent_2), type$.Iterable_ComplexSelectorComponent_2), new Y._weaveParents_closure12(), t1);
    },
    _firstIfRoot0(queue) {
      var first;
      if (queue._collection$_head === queue._collection$_tail)
        return null;
      first = queue.get$first(queue);
      if (first instanceof X.CompoundSelector0) {
        if (!Y._hasRoot0(first))
          return null;
        queue.removeFirst$0();
        return first;
      } else
        return null;
    },
    _mergeInitialCombinators0(components1, components2) {
      var t4, combinators2, lcs,
        t1 = type$.JSArray_Combinator_2,
        combinators1 = H._setArrayType([], t1),
        t2 = type$.Combinator_2,
        t3 = components1.$ti._precomputed1;
      while (true) {
        if (!components1.get$isEmpty(components1)) {
          t4 = components1._collection$_head;
          if (t4 === components1._collection$_tail)
            H.throwExpression(H.IterableElementError_noElement());
          t4 = t3._as(components1._collection$_table[t4]) instanceof S.Combinator0;
        } else
          t4 = false;
        if (!t4)
          break;
        combinators1.push(t2._as(components1.removeFirst$0()));
      }
      combinators2 = H._setArrayType([], t1);
      t1 = components2.$ti._precomputed1;
      while (true) {
        if (!components2.get$isEmpty(components2)) {
          t3 = components2._collection$_head;
          if (t3 === components2._collection$_tail)
            H.throwExpression(H.IterableElementError_noElement());
          t3 = t1._as(components2._collection$_table[t3]) instanceof S.Combinator0;
        } else
          t3 = false;
        if (!t3)
          break;
        combinators2.push(t2._as(components2.removeFirst$0()));
      }
      lcs = B.longestCommonSubsequence0(combinators1, combinators2, null, t2);
      if (C.C_ListEquality.equals$2(0, lcs, combinators1))
        return combinators2;
      if (C.C_ListEquality.equals$2(0, lcs, combinators2))
        return combinators1;
      return null;
    },
    _mergeFinalCombinators0(components1, components2, result) {
      var t1, combinators1, t2, combinators2, lcs, combinator1, combinator2, compound1, compound2, choices, unified, followingSiblingSelector, nextSiblingSelector, _null = null;
      if (result == null)
        result = Q.QueueList$(_null, type$.List_List_ComplexSelectorComponent_2);
      if (components1._collection$_head === components1._collection$_tail || !(components1.get$last(components1) instanceof S.Combinator0))
        t1 = components2._collection$_head === components2._collection$_tail || !(components2.get$last(components2) instanceof S.Combinator0);
      else
        t1 = false;
      if (t1)
        return result;
      t1 = type$.JSArray_Combinator_2;
      combinators1 = H._setArrayType([], t1);
      t2 = type$.Combinator_2;
      while (true) {
        if (!(!components1.get$isEmpty(components1) && components1.get$last(components1) instanceof S.Combinator0))
          break;
        combinators1.push(t2._as(components1.removeLast$0(0)));
      }
      combinators2 = H._setArrayType([], t1);
      while (true) {
        if (!(!components2.get$isEmpty(components2) && components2.get$last(components2) instanceof S.Combinator0))
          break;
        combinators2.push(t2._as(components2.removeLast$0(0)));
      }
      t1 = combinators1.length;
      if (t1 > 1 || combinators2.length > 1) {
        lcs = B.longestCommonSubsequence0(combinators1, combinators2, _null, t2);
        if (C.C_ListEquality.equals$2(0, lcs, combinators1))
          result.addFirst$1(H._setArrayType([P.List_List$of(new H.ReversedListIterable(combinators2, type$.ReversedListIterable_Combinator_2), true, type$.ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
        else if (C.C_ListEquality.equals$2(0, lcs, combinators2))
          result.addFirst$1(H._setArrayType([P.List_List$of(new H.ReversedListIterable(combinators1, type$.ReversedListIterable_Combinator_2), true, type$.ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
        else
          return _null;
        return result;
      }
      combinator1 = t1 === 0 ? _null : C.JSArray_methods.get$first(combinators1);
      combinator2 = combinators2.length === 0 ? _null : C.JSArray_methods.get$first(combinators2);
      t1 = combinator1 != null;
      if (t1 && combinator2 != null) {
        t1 = type$.CompoundSelector_2;
        compound1 = t1._as(components1.removeLast$0(0));
        compound2 = t1._as(components2.removeLast$0(0));
        t1 = combinator1 === C.Combinator_CzM0;
        if (t1 && combinator2 === C.Combinator_CzM0)
          if (Y.compoundIsSuperselector0(compound1, compound2, _null))
            result.addFirst$1(H._setArrayType([H._setArrayType([compound2, C.Combinator_CzM0], type$.JSArray_ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
          else {
            t1 = type$.JSArray_ComplexSelectorComponent_2;
            t2 = type$.JSArray_List_ComplexSelectorComponent_2;
            if (Y.compoundIsSuperselector0(compound2, compound1, _null))
              result.addFirst$1(H._setArrayType([H._setArrayType([compound1, C.Combinator_CzM0], t1)], t2));
            else {
              choices = H._setArrayType([H._setArrayType([compound1, C.Combinator_CzM0, compound2, C.Combinator_CzM0], t1), H._setArrayType([compound2, C.Combinator_CzM0, compound1, C.Combinator_CzM0], t1)], t2);
              unified = Y.unifyCompound0(compound1.components, compound2.components);
              if (unified != null)
                choices.push(H._setArrayType([unified, C.Combinator_CzM0], t1));
              result.addFirst$1(choices);
            }
          }
        else {
          if (!(t1 && combinator2 === C.Combinator_uzg0))
            t2 = combinator1 === C.Combinator_uzg0 && combinator2 === C.Combinator_CzM0;
          else
            t2 = true;
          if (t2) {
            followingSiblingSelector = t1 ? compound1 : compound2;
            nextSiblingSelector = t1 ? compound2 : compound1;
            t1 = type$.JSArray_ComplexSelectorComponent_2;
            t2 = type$.JSArray_List_ComplexSelectorComponent_2;
            if (Y.compoundIsSuperselector0(followingSiblingSelector, nextSiblingSelector, _null))
              result.addFirst$1(H._setArrayType([H._setArrayType([nextSiblingSelector, C.Combinator_uzg0], t1)], t2));
            else {
              unified = Y.unifyCompound0(compound1.components, compound2.components);
              t2 = H._setArrayType([H._setArrayType([followingSiblingSelector, C.Combinator_CzM0, nextSiblingSelector, C.Combinator_uzg0], t1)], t2);
              if (unified != null)
                t2.push(H._setArrayType([unified, C.Combinator_uzg0], t1));
              result.addFirst$1(t2);
            }
          } else {
            if (combinator1 === C.Combinator_sgq0)
              t2 = combinator2 === C.Combinator_uzg0 || combinator2 === C.Combinator_CzM0;
            else
              t2 = false;
            if (t2) {
              result.addFirst$1(H._setArrayType([H._setArrayType([compound2, combinator2], type$.JSArray_ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
              components1._add$1(compound1);
              components1._add$1(C.Combinator_sgq0);
            } else {
              if (combinator2 === C.Combinator_sgq0)
                t1 = combinator1 === C.Combinator_uzg0 || t1;
              else
                t1 = false;
              if (t1) {
                result.addFirst$1(H._setArrayType([H._setArrayType([compound1, combinator1], type$.JSArray_ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
                components2._add$1(compound2);
                components2._add$1(C.Combinator_sgq0);
              } else if (combinator1 === combinator2) {
                unified = Y.unifyCompound0(compound1.components, compound2.components);
                if (unified == null)
                  return _null;
                result.addFirst$1(H._setArrayType([H._setArrayType([unified, combinator1], type$.JSArray_ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
              } else
                return _null;
            }
          }
        }
        return Y._mergeFinalCombinators0(components1, components2, result);
      } else if (t1) {
        if (combinator1 === C.Combinator_sgq0)
          if (!components2.get$isEmpty(components2)) {
            t1 = type$.CompoundSelector_2;
            t1 = Y.compoundIsSuperselector0(t1._as(components2.get$last(components2)), t1._as(components1.get$last(components1)), _null);
          } else
            t1 = false;
        else
          t1 = false;
        if (t1)
          components2.removeLast$0(0);
        result.addFirst$1(H._setArrayType([H._setArrayType([components1.removeLast$0(0), combinator1], type$.JSArray_ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
        return Y._mergeFinalCombinators0(components1, components2, result);
      } else {
        if (combinator2 === C.Combinator_sgq0)
          if (!components1.get$isEmpty(components1)) {
            t1 = type$.CompoundSelector_2;
            t1 = Y.compoundIsSuperselector0(t1._as(components1.get$last(components1)), t1._as(components2.get$last(components2)), _null);
          } else
            t1 = false;
        else
          t1 = false;
        if (t1)
          components1.removeLast$0(0);
        t1 = components2.removeLast$0(0);
        combinator2.toString;
        result.addFirst$1(H._setArrayType([H._setArrayType([t1, combinator2], type$.JSArray_ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
        return Y._mergeFinalCombinators0(components1, components2, result);
      }
    },
    _mustUnify0(complex1, complex2) {
      var t2, t3, t4,
        t1 = P.LinkedHashSet_LinkedHashSet$_empty(type$.SimpleSelector_2);
      for (t2 = J.get$iterator$ax(complex1); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3 instanceof X.CompoundSelector0)
          for (t3 = C.JSArray_methods.get$iterator(t3.components), t4 = new H.WhereIterator(t3, Y.functions0___isUnique$closure()); t4.moveNext$0();)
            t1.add$1(0, t3.get$current(t3));
      }
      if (t1._collection$_length === 0)
        return false;
      return J.any$1$ax(complex2, new Y._mustUnify_closure0(t1));
    },
    _isUnique0(simple) {
      var t1;
      if (!(simple instanceof N.IDSelector0))
        t1 = simple instanceof D.PseudoSelector0 && !simple.isClass;
      else
        t1 = true;
      return t1;
    },
    _chunks0(queue1, queue2, done, $T) {
      var chunk2, t2,
        t1 = $T._eval$1("JSArray<0>"),
        chunk1 = H._setArrayType([], t1);
      for (; !done.call$1(queue1);)
        chunk1.push(queue1.removeFirst$0());
      chunk2 = H._setArrayType([], t1);
      for (; !done.call$1(queue2);)
        chunk2.push(queue2.removeFirst$0());
      t1 = chunk1.length === 0;
      if (t1 && chunk2.length === 0)
        return H._setArrayType([], $T._eval$1("JSArray<List<0>>"));
      if (t1)
        return H._setArrayType([chunk2], $T._eval$1("JSArray<List<0>>"));
      if (chunk2.length === 0)
        return H._setArrayType([chunk1], $T._eval$1("JSArray<List<0>>"));
      t1 = P.List_List$of(chunk1, true, $T);
      C.JSArray_methods.addAll$1(t1, chunk2);
      t2 = P.List_List$of(chunk2, true, $T);
      C.JSArray_methods.addAll$1(t2, chunk1);
      return H._setArrayType([t1, t2], $T._eval$1("JSArray<List<0>>"));
    },
    paths0(choices, $T) {
      return J.fold$2$ax(choices, H._setArrayType([H._setArrayType([], $T._eval$1("JSArray<0>"))], $T._eval$1("JSArray<List<0>>")), new Y.paths_closure0($T));
    },
    _groupSelectors0(complex) {
      var t1, t2, group, t3, t4,
        groups = Q.QueueList$(null, type$.List_ComplexSelectorComponent_2),
        iterator = P._ListQueueIterator$(complex);
      if (!iterator.moveNext$0())
        return groups;
      t1 = H._instanceType(iterator)._precomputed1;
      t2 = type$.JSArray_ComplexSelectorComponent_2;
      group = H._setArrayType([t1._as(iterator._collection$_current)], t2);
      groups._queue_list$_add$1(group);
      for (; iterator.moveNext$0();) {
        t3 = C.JSArray_methods.get$last(group) instanceof S.Combinator0 || t1._as(iterator._collection$_current) instanceof S.Combinator0;
        t4 = iterator._collection$_current;
        if (t3)
          group.push(t1._as(t4));
        else {
          group = H._setArrayType([t1._as(t4)], t2);
          groups._queue_list$_add$1(group);
        }
      }
      return groups;
    },
    _hasRoot0(compound) {
      return C.JSArray_methods.any$1(compound.components, new Y._hasRoot_closure0());
    },
    listIsSuperselector0(list1, list2) {
      return C.JSArray_methods.every$1(list2, new Y.listIsSuperselector_closure0(list1));
    },
    complexIsParentSuperselector0(complex1, complex2) {
      var t2, base,
        t1 = J.getInterceptor$ax(complex1);
      if (t1.get$first(complex1) instanceof S.Combinator0)
        return false;
      t2 = J.getInterceptor$ax(complex2);
      if (t2.get$first(complex2) instanceof S.Combinator0)
        return false;
      if (t1.get$length(complex1) > t2.get$length(complex2))
        return false;
      base = X.CompoundSelector$0(H._setArrayType([new N.PlaceholderSelector0("<temp>")], type$.JSArray_SimpleSelector_2));
      t1 = type$.ComplexSelectorComponent_2;
      t2 = P.List_List$of(complex1, true, t1);
      t2.push(base);
      t1 = P.List_List$of(complex2, true, t1);
      t1.push(base);
      return Y.complexIsSuperselector0(t2, t1);
    },
    complexIsSuperselector0(complex1, complex2) {
      var t1, t2, t3, i1, i2, remaining1, remaining2, t4, t5, t6, afterSuperselector, afterSuperselector0, compound2, i10, combinator1, combinator2;
      if (C.JSArray_methods.get$last(complex1) instanceof S.Combinator0)
        return false;
      if (C.JSArray_methods.get$last(complex2) instanceof S.Combinator0)
        return false;
      for (t1 = H._arrayInstanceType(complex2), t2 = t1._precomputed1, t1 = t1._eval$1("SubListIterable<1>"), t3 = type$.CompoundSelector_2, i1 = 0, i2 = 0; true;) {
        remaining1 = complex1.length - i1;
        remaining2 = complex2.length - i2;
        if (remaining1 === 0 || remaining2 === 0)
          return false;
        if (remaining1 > remaining2)
          return false;
        t4 = complex1[i1];
        if (t4 instanceof S.Combinator0)
          return false;
        if (complex2[i2] instanceof S.Combinator0)
          return false;
        t3._as(t4);
        if (remaining1 === 1) {
          t5 = t3._as(C.JSArray_methods.get$last(complex2));
          t6 = complex2.length - 1;
          t3 = new H.SubListIterable(complex2, 0, t6, t1);
          t3.SubListIterable$3(complex2, 0, t6, t2);
          return Y.compoundIsSuperselector0(t4, t5, t3.skip$1(0, i2));
        }
        afterSuperselector = i2 + 1;
        for (afterSuperselector0 = afterSuperselector; afterSuperselector0 < complex2.length; ++afterSuperselector0) {
          t5 = afterSuperselector0 - 1;
          compound2 = complex2[t5];
          if (compound2 instanceof X.CompoundSelector0) {
            t6 = new H.SubListIterable(complex2, 0, t5, t1);
            t6.SubListIterable$3(complex2, 0, t5, t2);
            if (Y.compoundIsSuperselector0(t4, compound2, t6.skip$1(0, afterSuperselector)))
              break;
          }
        }
        if (afterSuperselector0 === complex2.length)
          return false;
        i10 = i1 + 1;
        combinator1 = complex1[i10];
        combinator2 = complex2[afterSuperselector0];
        if (combinator1 instanceof S.Combinator0) {
          if (!(combinator2 instanceof S.Combinator0))
            return false;
          if (combinator1 === C.Combinator_CzM0) {
            if (combinator2 === C.Combinator_sgq0)
              return false;
          } else if (combinator2 !== combinator1)
            return false;
          if (remaining1 === 3 && remaining2 > 3)
            return false;
          i1 += 2;
          i2 = afterSuperselector0 + 1;
        } else {
          if (combinator2 instanceof S.Combinator0) {
            if (combinator2 !== C.Combinator_sgq0)
              return false;
            i2 = afterSuperselector0 + 1;
          } else
            i2 = afterSuperselector0;
          i1 = i10;
        }
      }
    },
    compoundIsSuperselector0(compound1, compound2, parents) {
      var t1, t2, _i, simple1, simple2;
      for (t1 = compound1.components, t2 = t1.length, _i = 0; _i < t2; ++_i) {
        simple1 = t1[_i];
        if (simple1 instanceof D.PseudoSelector0 && simple1.selector != null) {
          if (!Y._selectorPseudoIsSuperselector0(simple1, compound2, parents))
            return false;
        } else if (!Y._simpleIsSuperselectorOfCompound0(simple1, compound2))
          return false;
      }
      for (t1 = compound2.components, t2 = t1.length, _i = 0; _i < t2; ++_i) {
        simple2 = t1[_i];
        if (simple2 instanceof D.PseudoSelector0 && !simple2.isClass && simple2.selector == null && !Y._simpleIsSuperselectorOfCompound0(simple2, compound1))
          return false;
      }
      return true;
    },
    _simpleIsSuperselectorOfCompound0(simple, compound) {
      return C.JSArray_methods.any$1(compound.components, new Y._simpleIsSuperselectorOfCompound_closure0(simple));
    },
    _selectorPseudoIsSuperselector0(pseudo1, compound2, parents) {
      var selector1_ = pseudo1.selector;
      if (selector1_ == null)
        throw H.wrapException(P.ArgumentError$("Selector " + pseudo1.toString$0(0) + " must have a selector argument.", null));
      switch (pseudo1.normalizedName) {
        case "is":
        case "matches":
        case "any":
          return Y._selectorPseudoArgs0(compound2, pseudo1.name, true).any$1(0, new Y._selectorPseudoIsSuperselector_closure6(selector1_)) || C.JSArray_methods.any$1(selector1_.components, new Y._selectorPseudoIsSuperselector_closure7(parents, compound2));
        case "has":
        case "host":
        case "host-context":
          return Y._selectorPseudoArgs0(compound2, pseudo1.name, true).any$1(0, new Y._selectorPseudoIsSuperselector_closure8(selector1_));
        case "slotted":
          return Y._selectorPseudoArgs0(compound2, pseudo1.name, false).any$1(0, new Y._selectorPseudoIsSuperselector_closure9(selector1_));
        case "not":
          return C.JSArray_methods.every$1(selector1_.components, new Y._selectorPseudoIsSuperselector_closure10(compound2, pseudo1));
        case "current":
          return Y._selectorPseudoArgs0(compound2, pseudo1.name, true).any$1(0, new Y._selectorPseudoIsSuperselector_closure11(selector1_));
        case "nth-child":
        case "nth-last-child":
          return C.JSArray_methods.any$1(compound2.components, new Y._selectorPseudoIsSuperselector_closure12(pseudo1, selector1_));
        default:
          throw H.wrapException("unreachable");
      }
    },
    _selectorPseudoArgs0(compound, $name, isClass) {
      var t1 = type$.WhereTypeIterable_PseudoSelector_2;
      return A.IterableNullableExtension_whereNotNull(new H.MappedIterable(new H.WhereIterable(new H.WhereTypeIterable(compound.components, t1), new Y._selectorPseudoArgs_closure1(isClass, $name), t1._eval$1("WhereIterable<Iterable.E>")), new Y._selectorPseudoArgs_closure2(), t1._eval$1("MappedIterable<Iterable.E,SelectorList0?>")), type$.SelectorList_2);
    },
    unifyComplex_closure0: function unifyComplex_closure0() {
    },
    _weaveParents_closure6: function _weaveParents_closure6() {
    },
    _weaveParents_closure7: function _weaveParents_closure7(t0) {
      this.group = t0;
    },
    _weaveParents_closure8: function _weaveParents_closure8() {
    },
    _weaveParents__closure4: function _weaveParents__closure4() {
    },
    _weaveParents_closure9: function _weaveParents_closure9() {
    },
    _weaveParents_closure10: function _weaveParents_closure10() {
    },
    _weaveParents__closure3: function _weaveParents__closure3() {
    },
    _weaveParents_closure11: function _weaveParents_closure11() {
    },
    _weaveParents_closure12: function _weaveParents_closure12() {
    },
    _weaveParents__closure2: function _weaveParents__closure2() {
    },
    _mustUnify_closure0: function _mustUnify_closure0(t0) {
      this.uniqueSelectors = t0;
    },
    _mustUnify__closure0: function _mustUnify__closure0(t0) {
      this.uniqueSelectors = t0;
    },
    paths_closure0: function paths_closure0(t0) {
      this.T = t0;
    },
    paths__closure0: function paths__closure0(t0, t1) {
      this.paths = t0;
      this.T = t1;
    },
    paths___closure0: function paths___closure0(t0, t1) {
      this.option = t0;
      this.T = t1;
    },
    _hasRoot_closure0: function _hasRoot_closure0() {
    },
    listIsSuperselector_closure0: function listIsSuperselector_closure0(t0) {
      this.list1 = t0;
    },
    listIsSuperselector__closure0: function listIsSuperselector__closure0(t0) {
      this.complex1 = t0;
    },
    _simpleIsSuperselectorOfCompound_closure0: function _simpleIsSuperselectorOfCompound_closure0(t0) {
      this.simple = t0;
    },
    _simpleIsSuperselectorOfCompound__closure0: function _simpleIsSuperselectorOfCompound__closure0(t0) {
      this.simple = t0;
    },
    _selectorPseudoIsSuperselector_closure6: function _selectorPseudoIsSuperselector_closure6(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure7: function _selectorPseudoIsSuperselector_closure7(t0, t1) {
      this.parents = t0;
      this.compound2 = t1;
    },
    _selectorPseudoIsSuperselector_closure8: function _selectorPseudoIsSuperselector_closure8(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure9: function _selectorPseudoIsSuperselector_closure9(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure10: function _selectorPseudoIsSuperselector_closure10(t0, t1) {
      this.compound2 = t0;
      this.pseudo1 = t1;
    },
    _selectorPseudoIsSuperselector__closure0: function _selectorPseudoIsSuperselector__closure0(t0, t1) {
      this.complex = t0;
      this.pseudo1 = t1;
    },
    _selectorPseudoIsSuperselector___closure1: function _selectorPseudoIsSuperselector___closure1(t0) {
      this.simple2 = t0;
    },
    _selectorPseudoIsSuperselector___closure2: function _selectorPseudoIsSuperselector___closure2(t0) {
      this.simple2 = t0;
    },
    _selectorPseudoIsSuperselector_closure11: function _selectorPseudoIsSuperselector_closure11(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure12: function _selectorPseudoIsSuperselector_closure12(t0, t1) {
      this.pseudo1 = t0;
      this.selector1 = t1;
    },
    _selectorPseudoArgs_closure1: function _selectorPseudoArgs_closure1(t0, t1) {
      this.isClass = t0;
      this.name = t1;
    },
    _selectorPseudoArgs_closure2: function _selectorPseudoArgs_closure2() {
    },
    currentCallableSpan0() {
      var node = $.Zone__current.$index(0, C.Symbol__currentCallableNode);
      if (type$.AstNode_2._is(node))
        return node.get$span();
      throw H.wrapException(P.StateError$(string$.curren));
    },
    globalFunctions_closure0: function globalFunctions_closure0() {
    },
    TerseLogger0: function TerseLogger0(t0, t1) {
      this._terse$_warningCounts = t0;
      this._terse$_inner = t1;
    },
    TerseLogger_summarize_closure1: function TerseLogger_summarize_closure1() {
    },
    TerseLogger_summarize_closure2: function TerseLogger_summarize_closure2() {
    },
    WarnRule0: function WarnRule0(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    mergeMaps(map1, map2, $K, $V) {
      var result = P.LinkedHashMap_LinkedHashMap$of(map1, $K, $V);
      result.addAll$1(0, map2);
      return result;
    },
    groupBy(values, key, $S, $T) {
      var t1, t2, _i, element, t3, t4,
        map = P.LinkedHashMap_LinkedHashMap$_empty($T, $S._eval$1("List<0>"));
      for (t1 = values.length, t2 = $S._eval$1("JSArray<0>"), _i = 0; _i < values.length; values.length === t1 || (0, H.throwConcurrentModificationError)(values), ++_i) {
        element = values[_i];
        t3 = key.call$1(element);
        t4 = map.$index(0, t3);
        if (t4 == null) {
          t4 = H._setArrayType([], t2);
          map.$indexSet(0, t3, t4);
          t3 = t4;
        } else
          t3 = t4;
        t3.push(element);
      }
      return map;
    },
    minBy(values, orderBy) {
      var t1, t2, minValue, minOrderBy, element, elementOrderBy;
      for (t1 = new H.MappedIterator(J.get$iterator$ax(values.__internal$_iterable), values._f), t2 = H._instanceType(t1)._rest[1], minValue = null, minOrderBy = null; t1.moveNext$0();) {
        element = t2._as(t1.__internal$_current);
        elementOrderBy = orderBy.call$1(element);
        if (minOrderBy == null || B.defaultCompare(elementOrderBy, minOrderBy) < 0) {
          minOrderBy = elementOrderBy;
          minValue = element;
        }
      }
      return minValue;
    },
    repl(options) {
      return Y.repl$body(options);
    },
    repl$body(options) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(type$.void),
        $async$handler = 1, $async$currentError, $async$next = [], repl, logger, evaluator, line, declaration, error, stackTrace, t4, t5, t6, t7, t8, line0, toZone, exception, t1, t2, t3, repl0;
      var $async$repl = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1) {
          $async$currentError = $async$result;
          $async$goto = $async$handler;
        }
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = H._setArrayType([], type$.JSArray_String);
              t2 = C.JSString_methods.$mul(" ", 3);
              t3 = $.$get$alwaysValid();
              repl0 = new Q.Repl(">> ", t2, t3, t1);
              repl0.__Repl__adapter = new B.ReplAdapter(repl0);
              repl = repl0;
              t1 = options._options;
              logger = new T.TrackingLogger(H._asBool(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color()));
              t2 = $.$get$context().absolute$7(".", null, null, null, null, null, null);
              evaluator = new R.Evaluator(R._EvaluateVisitor$(null, R.ImportCache$(type$.List_String._as(t1.$index(0, "load-path")), logger), logger, null, false, false), new F.FilesystemImporter(t2));
              t2 = repl.__Repl__adapter;
              t1 = new P._StreamIterator(H.checkNotNullable((t2 == null ? H.throwExpression(H.LateError$fieldNI("_adapter")) : t2).runAsync$0(), "stream", type$.Object));
              $async$handler = 2;
              t2 = type$.Expression, t3 = type$.String, t4 = type$.VariableDeclaration;
            case 5:
              // for condition
              $async$goto = 7;
              return P._asyncAwait(t1.moveNext$0(), $async$repl);
            case 7:
              // returning from await.
              if (!$async$result) {
                // goto after for
                $async$goto = 6;
                break;
              }
              line = t1.get$current(t1);
              if (J.trim$0$s(line).length === 0) {
                // goto for condition
                $async$goto = 5;
                break;
              }
              try {
                if (J.startsWith$1$s(line, "@")) {
                  t5 = evaluator;
                  t6 = logger;
                  t7 = S.SpanScanner$(line, null);
                  if (t6 == null)
                    t6 = C.StderrLogger_false;
                  t6 = new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(t3, t4), t7, t6).parseUseRule$0();
                  t5._visitor.runStatement$2(t5._importer, t6);
                  // goto for condition
                  $async$goto = 5;
                  break;
                }
                t5 = S.SpanScanner$(line, null);
                if (new G.Parser(t5, C.StderrLogger_false)._isVariableDeclarationLike$0()) {
                  t5 = logger;
                  t6 = S.SpanScanner$(line, null);
                  if (t5 == null)
                    t5 = C.StderrLogger_false;
                  declaration = new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(t3, t4), t6, t5).parseVariableDeclaration$0();
                  t5 = evaluator;
                  t5._visitor.runStatement$2(t5._importer, declaration);
                  t5 = evaluator;
                  t6 = declaration.name;
                  t7 = declaration.span;
                  t8 = declaration.namespace;
                  line0 = t5._visitor.runExpression$2(t5._importer, new S.VariableExpression(t8, t6, t7)).toString$0(0);
                  toZone = $.printToZone;
                  if (toZone == null)
                    H.printString(line0);
                  else
                    toZone.call$1(line0);
                } else {
                  t5 = evaluator;
                  t6 = logger;
                  t7 = S.SpanScanner$(line, null);
                  if (t6 == null)
                    t6 = C.StderrLogger_false;
                  t6 = new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(t3, t4), t7, t6);
                  t6 = t6._parseSingleProduction$1$1(t6.get$expression(), t2);
                  line0 = t5._visitor.runExpression$2(t5._importer, t6).toString$0(0);
                  toZone = $.printToZone;
                  if (toZone == null)
                    H.printString(line0);
                  else
                    toZone.call$1(line0);
                }
              } catch (exception) {
                t5 = H.unwrapException(exception);
                if (t5 instanceof E.SassException) {
                  error = t5;
                  stackTrace = H.getTraceFromException(exception);
                  Y._logError(error, stackTrace, line, repl, options, logger);
                } else
                  throw exception;
              }
              // goto for condition
              $async$goto = 5;
              break;
            case 6:
              // after for
              $async$next.push(4);
              // goto finally
              $async$goto = 3;
              break;
            case 2:
              // uncaught
              $async$next = [1];
            case 3:
              // finally
              $async$handler = 1;
              $async$goto = 8;
              return P._asyncAwait(t1.cancel$0(), $async$repl);
            case 8:
              // returning from await.
              // goto the next finally handler
              $async$goto = $async$next.pop();
              break;
            case 4:
              // after finally
              // implicit return
              return P._asyncReturn(null, $async$completer);
            case 1:
              // rethrow
              return P._asyncRethrow($async$currentError, $async$completer);
          }
      });
      return P._asyncStartSync($async$repl, $async$completer);
    },
    _logError(error, stackTrace, line, repl, options, logger) {
      var t1, t2, spacesBeforeError;
      if (G.SourceSpanException.prototype.get$span.call(error).file.url == null)
        if (!H._asBool(options._options.$index(0, "quiet")))
          t1 = logger._emittedDebug || logger._emittedWarning;
        else
          t1 = false;
      else
        t1 = true;
      if (t1) {
        P.print(error.toString$1$color(0, options.get$color()));
        return;
      }
      t1 = options.get$color() ? "" + "\x1b[31m" : "";
      t2 = G.SourceSpanException.prototype.get$span.call(error);
      t2 = Y.FileLocation$_(t2.file, t2._file$_start);
      spacesBeforeError = repl.prompt.length + t2.file.getColumn$1(t2.offset);
      if (options.get$color()) {
        t2 = G.SourceSpanException.prototype.get$span.call(error);
        t2 = Y.FileLocation$_(t2.file, t2._file$_start);
        t2 = t2.file.getColumn$1(t2.offset) < line.length;
      } else
        t2 = false;
      if (t2) {
        t1 += "\x1b[1F\x1b[" + spacesBeforeError + "C";
        t2 = G.SourceSpanException.prototype.get$span.call(error);
        t2 = t1 + (P.String_String$fromCharCodes(C.NativeUint32List_methods.sublist$2(t2.file._decodedChars, t2._file$_start, t2._end), 0, null) + "\n");
        t1 = t2;
      }
      t1 += C.JSString_methods.$mul(" ", spacesBeforeError);
      t2 = G.SourceSpanException.prototype.get$span.call(error);
      t2 = t1 + (C.JSString_methods.$mul("^", Math.max(1, t2._end - t2._file$_start)) + "\n");
      t1 = options.get$color() ? t2 + "\x1b[0m" : t2;
      t1 += "Error: " + error._span_exception$_message + "\n";
      if (H._asBool(options._options.$index(0, "trace")))
        t1 += Y.Trace_Trace$from(stackTrace).get$terse().toString$0(0);
      P.print(C.JSString_methods.trimRight$0(t1.charCodeAt(0) == 0 ? t1 : t1));
    }
  },
  Z = {
    ArgParserException$(message, commands) {
      return new Z.ArgParserException(commands == null ? C.List_empty : P.List_List$unmodifiable(commands, type$.String), message, null, null);
    },
    ArgParserException: function ArgParserException(t0, t1, t2, t3) {
      var _ = this;
      _.commands = t0;
      _.message = t1;
      _.source = t2;
      _.offset = t3;
    },
    Argument: function Argument(t0, t1, t2) {
      this.name = t0;
      this.defaultValue = t1;
      this.span = t2;
    },
    ConfiguredVariable: function ConfiguredVariable(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.expression = t1;
      _.isGuarded = t2;
      _.span = t3;
    },
    BooleanExpression: function BooleanExpression(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    VariableDeclaration$($name, expression, span, comment, global, guarded, namespace) {
      if (namespace != null && global)
        H.throwExpression(P.ArgumentError$(string$.Other_, null));
      return new Z.VariableDeclaration(namespace, $name, expression, guarded, global, span);
    },
    VariableDeclaration: function VariableDeclaration(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.expression = t2;
      _.isGuarded = t3;
      _.isGlobal = t4;
      _.span = t5;
    },
    ConfiguredValue: function ConfiguredValue(t0, t1, t2) {
      this.value = t0;
      this.configurationSpan = t1;
      this.assignmentNode = t2;
    },
    InterpolationBuffer: function InterpolationBuffer(t0, t1) {
      this._interpolation_buffer$_text = t0;
      this._interpolation_buffer$_contents = t1;
    },
    RenderContext: function RenderContext() {
    },
    RenderContextOptions: function RenderContextOptions() {
    },
    RenderContextResult: function RenderContextResult() {
    },
    RenderContextResultStats: function RenderContextResultStats() {
    },
    MergedMapView$(maps, $K, $V) {
      var t1 = $K._eval$1("@<0>")._bind$1($V);
      t1 = new Z.MergedMapView(P.LinkedHashMap_LinkedHashMap$_empty($K, t1._eval$1("Map<1,2>")), t1._eval$1("MergedMapView<1,2>"));
      t1.MergedMapView$1(maps, $K, $V);
      return t1;
    },
    MergedMapView: function MergedMapView(t0, t1) {
      this._mapsByKey = t0;
      this.$ti = t1;
    },
    SassBoolean: function SassBoolean(t0) {
      this.value = t0;
    },
    LineScanner$(string) {
      return new Z.LineScanner(null, string);
    },
    LineScanner: function LineScanner(t0, t1) {
      var _ = this;
      _._line_scanner$_column = _._line_scanner$_line = 0;
      _.sourceUrl = t0;
      _.string = t1;
      _._string_scanner$_position = 0;
      _._lastMatchPosition = _._lastMatch = null;
    },
    Argument0: function Argument0(t0, t1, t2) {
      this.name = t0;
      this.defaultValue = t1;
      this.span = t2;
    },
    BooleanExpression0: function BooleanExpression0(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    booleanConstructor_closure: function booleanConstructor_closure() {
    },
    booleanConstructor__closure: function booleanConstructor__closure() {
    },
    booleanConstructor__closure0: function booleanConstructor__closure0() {
    },
    SassBoolean0: function SassBoolean0(t0) {
      this.value = t0;
    },
    ConfiguredValue0: function ConfiguredValue0(t0, t1, t2) {
      this.value = t0;
      this.configurationSpan = t1;
      this.assignmentNode = t2;
    },
    ConfiguredVariable0: function ConfiguredVariable0(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.expression = t1;
      _.isGuarded = t2;
      _.span = t3;
    },
    InterpolationBuffer0: function InterpolationBuffer0(t0, t1) {
      this._interpolation_buffer0$_text = t0;
      this._interpolation_buffer0$_contents = t1;
    },
    MergedMapView$0(maps, $K, $V) {
      var t1 = $K._eval$1("@<0>")._bind$1($V);
      t1 = new Z.MergedMapView0(P.LinkedHashMap_LinkedHashMap$_empty($K, t1._eval$1("Map<1,2>")), t1._eval$1("MergedMapView0<1,2>"));
      t1.MergedMapView$10(maps, $K, $V);
      return t1;
    },
    MergedMapView0: function MergedMapView0(t0, t1) {
      this._merged_map_view$_mapsByKey = t0;
      this.$ti = t1;
    },
    RenderContext0: function RenderContext0() {
    },
    RenderContextOptions0: function RenderContextOptions0() {
    },
    RenderContextResult0: function RenderContextResult0() {
    },
    RenderContextResultStats0: function RenderContextResultStats0() {
    },
    VariableDeclaration$0($name, expression, span, comment, global, guarded, namespace) {
      if (namespace != null && global)
        H.throwExpression(P.ArgumentError$(string$.Other_, null));
      return new Z.VariableDeclaration0(namespace, $name, expression, guarded, global, span);
    },
    VariableDeclaration0: function VariableDeclaration0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.expression = t2;
      _.isGuarded = t3;
      _.isGlobal = t4;
      _.span = t5;
    }
  };
  var holders = [A, B, C, D, E, F, G, H, J, K, L, M, N, O, P, Q, R, S, T, U, V, X, Y, Z];
  hunkHelpers.setFunctionNamesIfNecessary(holders);
  var $ = {};
  H.JS_CONST.prototype = {};
  J.Interceptor.prototype = {
    $eq(receiver, other) {
      return receiver === other;
    },
    get$hashCode(receiver) {
      return H.Primitives_objectHashCode(receiver);
    },
    toString$0(receiver) {
      return "Instance of '" + H.Primitives_objectTypeName(receiver) + "'";
    },
    noSuchMethod$1(receiver, invocation) {
      throw H.wrapException(P.NoSuchMethodError$(receiver, invocation.get$memberName(), invocation.get$positionalArguments(), invocation.get$namedArguments()));
    }
  };
  J.JSBool.prototype = {
    toString$0(receiver) {
      return String(receiver);
    },
    get$hashCode(receiver) {
      return receiver ? 519018 : 218159;
    },
    $isbool: 1
  };
  J.JSNull.prototype = {
    $eq(receiver, other) {
      return null == other;
    },
    toString$0(receiver) {
      return "null";
    },
    get$hashCode(receiver) {
      return 0;
    },
    get$runtimeType(receiver) {
      return C.Type_Null_Yyn;
    },
    $isNull: 1
  };
  J.JavaScriptObject.prototype = {
    get$hashCode(receiver) {
      return 0;
    },
    toString$0(receiver) {
      return String(receiver);
    },
    $isJsSystemError: 1,
    $is_NodeSassColor: 1,
    $isFiber: 1,
    $isJSFunction0: 1,
    $isNodeImporterResult0: 1,
    $is_NodeSassList: 1,
    $is_NodeSassMap: 1,
    $is_NodeSassNumber: 1,
    $isRenderContextOptions0: 1,
    $isRenderOptions: 1,
    $isRenderResult: 1,
    $is_NodeSassString: 1,
    get$isTTY(obj) {
      return obj.isTTY;
    },
    get$write(obj) {
      return obj.write;
    },
    write$1(receiver, p0) {
      return receiver.write(p0);
    },
    createInterface$1(receiver, p0) {
      return receiver.createInterface(p0);
    },
    on$2(receiver, p0, p1) {
      return receiver.on(p0, p1);
    },
    get$close(obj) {
      return obj.close;
    },
    close$0(receiver) {
      return receiver.close();
    },
    setPrompt$1(receiver, p0) {
      return receiver.setPrompt(p0);
    },
    get$length(obj) {
      return obj.length;
    },
    toString$0(receiver) {
      return receiver.toString();
    },
    clear$0(receiver) {
      return receiver.clear();
    },
    existsSync$1(receiver, p0) {
      return receiver.existsSync(p0);
    },
    mkdirSync$1(receiver, p0) {
      return receiver.mkdirSync(p0);
    },
    readdirSync$1(receiver, p0) {
      return receiver.readdirSync(p0);
    },
    readFileSync$2(receiver, p0, p1) {
      return receiver.readFileSync(p0, p1);
    },
    statSync$1(receiver, p0) {
      return receiver.statSync(p0);
    },
    unlinkSync$1(receiver, p0) {
      return receiver.unlinkSync(p0);
    },
    watch$2(receiver, p0, p1) {
      return receiver.watch(p0, p1);
    },
    writeFileSync$2(receiver, p0, p1) {
      return receiver.writeFileSync(p0, p1);
    },
    get$path(obj) {
      return obj.path;
    },
    isDirectory$0(receiver) {
      return receiver.isDirectory();
    },
    isFile$0(receiver) {
      return receiver.isFile();
    },
    get$mtime(obj) {
      return obj.mtime;
    },
    getTime$0(receiver) {
      return receiver.getTime();
    },
    get$message(obj) {
      return obj.message;
    },
    message$1(receiver, p0) {
      return receiver.message(p0);
    },
    get$code(obj) {
      return obj.code;
    },
    get$syscall(obj) {
      return obj.syscall;
    },
    get$env(obj) {
      return obj.env;
    },
    get$exitCode(obj) {
      return obj.exitCode;
    },
    set$exitCode(obj, v) {
      return obj.exitCode = v;
    },
    get$platform(obj) {
      return obj.platform;
    },
    get$stderr(obj) {
      return obj.stderr;
    },
    get$stdin(obj) {
      return obj.stdin;
    },
    get$name(obj) {
      return obj.name;
    },
    call$2(receiver, p0, p1) {
      return receiver.call(p0, p1);
    },
    call$1(receiver, p0) {
      return receiver.call(p0);
    },
    call$0(receiver) {
      return receiver.call();
    },
    call$3$1(receiver, p0) {
      return receiver.call(p0);
    },
    call$2$1(receiver, p0) {
      return receiver.call(p0);
    },
    call$1$1(receiver, p0) {
      return receiver.call(p0);
    },
    call$3(receiver, p0, p1, p2) {
      return receiver.call(p0, p1, p2);
    },
    call$3$3(receiver, p0, p1, p2) {
      return receiver.call(p0, p1, p2);
    },
    call$2$2(receiver, p0, p1) {
      return receiver.call(p0, p1);
    },
    call$1$0(receiver) {
      return receiver.call();
    },
    call$2$0(receiver) {
      return receiver.call();
    },
    call$2$3(receiver, p0, p1, p2) {
      return receiver.call(p0, p1, p2);
    },
    call$1$2(receiver, p0, p1) {
      return receiver.call(p0, p1);
    },
    apply$2(receiver, p0, p1) {
      return receiver.apply(p0, p1);
    },
    get$file(obj) {
      return obj.file;
    },
    get$contents(obj) {
      return obj.contents;
    },
    get$options(obj) {
      return obj.options;
    },
    get$data(obj) {
      return obj.data;
    },
    get$includePaths(obj) {
      return obj.includePaths;
    },
    get$indentType(obj) {
      return obj.indentType;
    },
    get$indentWidth(obj) {
      return obj.indentWidth;
    },
    get$linefeed(obj) {
      return obj.linefeed;
    },
    set$context(obj, v) {
      return obj.context = v;
    },
    get$dartValue(obj) {
      return obj.dartValue;
    },
    set$dartValue(obj, v) {
      return obj.dartValue = v;
    },
    set$render(obj, v) {
      return obj.render = v;
    },
    set$renderSync(obj, v) {
      return obj.renderSync = v;
    },
    set$info(obj, v) {
      return obj.info = v;
    },
    set$types(obj, v) {
      return obj.types = v;
    },
    set$NULL(obj, v) {
      return obj.NULL = v;
    },
    set$TRUE(obj, v) {
      return obj.TRUE = v;
    },
    set$FALSE(obj, v) {
      return obj.FALSE = v;
    },
    get$current(obj) {
      return obj.current;
    },
    yield$0(receiver) {
      return receiver.yield();
    },
    run$1$1(receiver, p0) {
      return receiver.run(p0);
    },
    run$1(receiver, p0) {
      return receiver.run(p0);
    },
    run$0(receiver) {
      return receiver.run();
    },
    get$importer(obj) {
      return obj.importer;
    },
    get$functions(obj) {
      return obj.functions;
    },
    get$indentedSyntax(obj) {
      return obj.indentedSyntax;
    },
    get$omitSourceMapUrl(obj) {
      return obj.omitSourceMapUrl;
    },
    get$outFile(obj) {
      return obj.outFile;
    },
    get$outputStyle(obj) {
      return obj.outputStyle;
    },
    get$fiber(obj) {
      return obj.fiber;
    },
    get$sourceMap(obj) {
      return obj.sourceMap;
    },
    get$sourceMapContents(obj) {
      return obj.sourceMapContents;
    },
    get$sourceMapEmbed(obj) {
      return obj.sourceMapEmbed;
    },
    get$sourceMapRoot(obj) {
      return obj.sourceMapRoot;
    },
    get$quietDeps(obj) {
      return obj.quietDeps;
    },
    get$verbose(obj) {
      return obj.verbose;
    },
    get$charset(obj) {
      return obj.charset;
    },
    set$cli_pkg_main_0_(obj, v) {
      return obj.cli_pkg_main_0_ = v;
    }
  };
  J.PlainJavaScriptObject.prototype = {};
  J.UnknownJavaScriptObject.prototype = {};
  J.JavaScriptFunction.prototype = {
    toString$0(receiver) {
      var dartClosure = receiver[$.$get$DART_CLOSURE_PROPERTY_NAME()];
      if (dartClosure == null)
        return this.super$JavaScriptObject$toString(receiver);
      return "JavaScript function for " + H.S(J.toString$0$(dartClosure));
    },
    $isFunction: 1
  };
  J.JSArray.prototype = {
    cast$1$0(receiver, $R) {
      return new H.CastList(receiver, H._arrayInstanceType(receiver)._eval$1("@<1>")._bind$1($R)._eval$1("CastList<1,2>"));
    },
    add$1(receiver, value) {
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("add"));
      receiver.push(value);
    },
    removeAt$1(receiver, index) {
      var t1;
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("removeAt"));
      t1 = receiver.length;
      if (index >= t1)
        throw H.wrapException(P.RangeError$value(index, null, null));
      return receiver.splice(index, 1)[0];
    },
    insert$2(receiver, index, value) {
      var t1;
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("insert"));
      t1 = receiver.length;
      if (index > t1)
        throw H.wrapException(P.RangeError$value(index, null, null));
      receiver.splice(index, 0, value);
    },
    insertAll$2(receiver, index, iterable) {
      var insertionLength, end;
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("insertAll"));
      P.RangeError_checkValueInInterval(index, 0, receiver.length, "index");
      if (!type$.EfficientLengthIterable_dynamic._is(iterable))
        iterable = J.toList$0$ax(iterable);
      insertionLength = J.get$length$asx(iterable);
      receiver.length = receiver.length + insertionLength;
      end = index + insertionLength;
      this.setRange$4(receiver, end, receiver.length, receiver, index);
      this.setRange$3(receiver, index, end, iterable);
    },
    removeLast$0(receiver) {
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("removeLast"));
      if (receiver.length === 0)
        throw H.wrapException(H.diagnoseIndexError(receiver, -1));
      return receiver.pop();
    },
    _removeWhere$2(receiver, test, removeMatching) {
      var i, element, t1, retained = [],
        end = receiver.length;
      for (i = 0; i < end; ++i) {
        element = receiver[i];
        if (!test.call$1(element))
          retained.push(element);
        if (receiver.length !== end)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      t1 = retained.length;
      if (t1 === end)
        return;
      this.set$length(receiver, t1);
      for (i = 0; i < retained.length; ++i)
        receiver[i] = retained[i];
    },
    where$1(receiver, f) {
      return new H.WhereIterable(receiver, f, H._arrayInstanceType(receiver)._eval$1("WhereIterable<1>"));
    },
    expand$1$1(receiver, f, $T) {
      return new H.ExpandIterable(receiver, f, H._arrayInstanceType(receiver)._eval$1("@<1>")._bind$1($T)._eval$1("ExpandIterable<1,2>"));
    },
    addAll$1(receiver, collection) {
      var t1;
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("addAll"));
      if (Array.isArray(collection)) {
        this._addAllFromArray$1(receiver, collection);
        return;
      }
      for (t1 = J.get$iterator$ax(collection); t1.moveNext$0();)
        receiver.push(t1.get$current(t1));
    },
    _addAllFromArray$1(receiver, array) {
      var i,
        len = array.length;
      if (len === 0)
        return;
      if (receiver === array)
        throw H.wrapException(P.ConcurrentModificationError$(receiver));
      for (i = 0; i < len; ++i)
        receiver.push(array[i]);
    },
    map$1$1(receiver, f, $T) {
      return new H.MappedListIterable(receiver, f, H._arrayInstanceType(receiver)._eval$1("@<1>")._bind$1($T)._eval$1("MappedListIterable<1,2>"));
    },
    join$1(receiver, separator) {
      var i,
        list = P.List_List$filled(receiver.length, "", false, type$.String);
      for (i = 0; i < receiver.length; ++i)
        list[i] = H.S(receiver[i]);
      return list.join(separator);
    },
    join$0($receiver) {
      return this.join$1($receiver, "");
    },
    take$1(receiver, n) {
      return H.SubListIterable$(receiver, 0, H.checkNotNullable(n, "count", type$.int), H._arrayInstanceType(receiver)._precomputed1);
    },
    skip$1(receiver, n) {
      return H.SubListIterable$(receiver, n, null, H._arrayInstanceType(receiver)._precomputed1);
    },
    fold$1$2(receiver, initialValue, combine) {
      var value, i,
        $length = receiver.length;
      for (value = initialValue, i = 0; i < $length; ++i) {
        value = combine.call$2(value, receiver[i]);
        if (receiver.length !== $length)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      return value;
    },
    fold$2($receiver, initialValue, combine) {
      return this.fold$1$2($receiver, initialValue, combine, type$.dynamic);
    },
    elementAt$1(receiver, index) {
      return receiver[index];
    },
    sublist$2(receiver, start, end) {
      var end0 = receiver.length;
      if (start > end0)
        throw H.wrapException(P.RangeError$range(start, 0, end0, "start", null));
      if (end == null)
        end = end0;
      else if (end < start || end > end0)
        throw H.wrapException(P.RangeError$range(end, start, end0, "end", null));
      if (start === end)
        return H._setArrayType([], H._arrayInstanceType(receiver));
      return H._setArrayType(receiver.slice(start, end), H._arrayInstanceType(receiver));
    },
    sublist$1($receiver, start) {
      return this.sublist$2($receiver, start, null);
    },
    getRange$2(receiver, start, end) {
      P.RangeError_checkValidRange(start, end, receiver.length);
      return H.SubListIterable$(receiver, start, end, H._arrayInstanceType(receiver)._precomputed1);
    },
    get$first(receiver) {
      if (receiver.length > 0)
        return receiver[0];
      throw H.wrapException(H.IterableElementError_noElement());
    },
    get$last(receiver) {
      var t1 = receiver.length;
      if (t1 > 0)
        return receiver[t1 - 1];
      throw H.wrapException(H.IterableElementError_noElement());
    },
    get$single(receiver) {
      var t1 = receiver.length;
      if (t1 === 1)
        return receiver[0];
      if (t1 === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      throw H.wrapException(H.IterableElementError_tooMany());
    },
    removeRange$2(receiver, start, end) {
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("removeRange"));
      P.RangeError_checkValidRange(start, end, receiver.length);
      receiver.splice(start, end - start);
    },
    setRange$4(receiver, start, end, iterable, skipCount) {
      var $length, otherList, otherStart, t1, i;
      if (!!receiver.immutable$list)
        H.throwExpression(P.UnsupportedError$("setRange"));
      P.RangeError_checkValidRange(start, end, receiver.length);
      $length = end - start;
      if ($length === 0)
        return;
      P.RangeError_checkNotNegative(skipCount, "skipCount");
      if (type$.List_dynamic._is(iterable)) {
        otherList = iterable;
        otherStart = skipCount;
      } else {
        otherList = J.skip$1$ax(iterable, skipCount).toList$1$growable(0, false);
        otherStart = 0;
      }
      t1 = J.getInterceptor$asx(otherList);
      if (otherStart + $length > t1.get$length(otherList))
        throw H.wrapException(H.IterableElementError_tooFew());
      if (otherStart < start)
        for (i = $length - 1; i >= 0; --i)
          receiver[start + i] = t1.$index(otherList, otherStart + i);
      else
        for (i = 0; i < $length; ++i)
          receiver[start + i] = t1.$index(otherList, otherStart + i);
    },
    setRange$3($receiver, start, end, iterable) {
      return this.setRange$4($receiver, start, end, iterable, 0);
    },
    fillRange$3(receiver, start, end, fillValue) {
      var i;
      if (!!receiver.immutable$list)
        H.throwExpression(P.UnsupportedError$("fill range"));
      P.RangeError_checkValidRange(start, end, receiver.length);
      H._arrayInstanceType(receiver)._precomputed1._as(fillValue);
      for (i = start; i < end; ++i)
        receiver[i] = fillValue;
    },
    any$1(receiver, test) {
      var i,
        end = receiver.length;
      for (i = 0; i < end; ++i) {
        if (test.call$1(receiver[i]))
          return true;
        if (receiver.length !== end)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      return false;
    },
    every$1(receiver, test) {
      var i,
        end = receiver.length;
      for (i = 0; i < end; ++i) {
        if (!test.call$1(receiver[i]))
          return false;
        if (receiver.length !== end)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      return true;
    },
    get$reversed(receiver) {
      return new H.ReversedListIterable(receiver, H._arrayInstanceType(receiver)._eval$1("ReversedListIterable<1>"));
    },
    sort$1(receiver, compare) {
      if (!!receiver.immutable$list)
        H.throwExpression(P.UnsupportedError$("sort"));
      H.Sort_sort(receiver, compare == null ? J._interceptors_JSArray__compareAny$closure() : compare);
    },
    sort$0($receiver) {
      return this.sort$1($receiver, null);
    },
    indexOf$1(receiver, element) {
      var i,
        $length = receiver.length;
      if (0 >= $length)
        return -1;
      for (i = 0; i < $length; ++i)
        if (J.$eq$(receiver[i], element))
          return i;
      return -1;
    },
    contains$1(receiver, other) {
      var i;
      for (i = 0; i < receiver.length; ++i)
        if (J.$eq$(receiver[i], other))
          return true;
      return false;
    },
    get$isEmpty(receiver) {
      return receiver.length === 0;
    },
    get$isNotEmpty(receiver) {
      return receiver.length !== 0;
    },
    toString$0(receiver) {
      return P.IterableBase_iterableToFullString(receiver, "[", "]");
    },
    toList$1$growable(receiver, growable) {
      var t1 = H._setArrayType(receiver.slice(0), H._arrayInstanceType(receiver));
      return t1;
    },
    toList$0($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    toSet$0(receiver) {
      return P.LinkedHashSet_LinkedHashSet$from(receiver, H._arrayInstanceType(receiver)._precomputed1);
    },
    get$iterator(receiver) {
      return new J.ArrayIterator(receiver, receiver.length);
    },
    get$hashCode(receiver) {
      return H.Primitives_objectHashCode(receiver);
    },
    get$length(receiver) {
      return receiver.length;
    },
    set$length(receiver, newLength) {
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("set length"));
      if (newLength < 0)
        throw H.wrapException(P.RangeError$range(newLength, 0, null, "newLength", null));
      if (newLength > receiver.length)
        H._arrayInstanceType(receiver)._precomputed1._as(null);
      receiver.length = newLength;
    },
    $index(receiver, index) {
      if (index >= receiver.length || index < 0)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      return receiver[index];
    },
    $indexSet(receiver, index, value) {
      if (!!receiver.immutable$list)
        H.throwExpression(P.UnsupportedError$("indexed set"));
      if (index >= receiver.length || index < 0)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      receiver[index] = value;
    },
    $add(receiver, other) {
      var t1 = P.List_List$of(receiver, true, H._arrayInstanceType(receiver)._precomputed1);
      this.addAll$1(t1, other);
      return t1;
    },
    indexWhere$1(receiver, test) {
      var i;
      if (0 >= receiver.length)
        return -1;
      for (i = 0; i < receiver.length; ++i)
        if (test.call$1(receiver[i]))
          return i;
      return -1;
    },
    $isEfficientLengthIterable: 1,
    $isIterable: 1,
    $isList: 1
  };
  J.JSUnmodifiableArray.prototype = {};
  J.ArrayIterator.prototype = {
    get$current(_) {
      return H._instanceType(this)._precomputed1._as(this._current);
    },
    moveNext$0() {
      var t2, _this = this,
        t1 = _this._iterable,
        $length = t1.length;
      if (_this._length !== $length)
        throw H.wrapException(H.throwConcurrentModificationError(t1));
      t2 = _this._index;
      if (t2 >= $length) {
        _this._current = null;
        return false;
      }
      _this._current = t1[t2];
      _this._index = t2 + 1;
      return true;
    }
  };
  J.JSNumber.prototype = {
    compareTo$1(receiver, b) {
      var bIsNegative;
      if (receiver < b)
        return -1;
      else if (receiver > b)
        return 1;
      else if (receiver === b) {
        if (receiver === 0) {
          bIsNegative = this.get$isNegative(b);
          if (this.get$isNegative(receiver) === bIsNegative)
            return 0;
          if (this.get$isNegative(receiver))
            return -1;
          return 1;
        }
        return 0;
      } else if (isNaN(receiver)) {
        if (isNaN(b))
          return 0;
        return 1;
      } else
        return -1;
    },
    get$isNegative(receiver) {
      return receiver === 0 ? 1 / receiver < 0 : receiver < 0;
    },
    ceil$0(receiver) {
      var truncated, d;
      if (receiver >= 0) {
        if (receiver <= 2147483647) {
          truncated = receiver | 0;
          return receiver === truncated ? truncated : truncated + 1;
        }
      } else if (receiver >= -2147483648)
        return receiver | 0;
      d = Math.ceil(receiver);
      if (isFinite(d))
        return d;
      throw H.wrapException(P.UnsupportedError$("" + receiver + ".ceil()"));
    },
    floor$0(receiver) {
      var truncated, d;
      if (receiver >= 0) {
        if (receiver <= 2147483647)
          return receiver | 0;
      } else if (receiver >= -2147483648) {
        truncated = receiver | 0;
        return receiver === truncated ? truncated : truncated - 1;
      }
      d = Math.floor(receiver);
      if (isFinite(d))
        return d;
      throw H.wrapException(P.UnsupportedError$("" + receiver + ".floor()"));
    },
    round$0(receiver) {
      if (receiver > 0) {
        if (receiver !== 1 / 0)
          return Math.round(receiver);
      } else if (receiver > -1 / 0)
        return 0 - Math.round(0 - receiver);
      throw H.wrapException(P.UnsupportedError$("" + receiver + ".round()"));
    },
    clamp$2(receiver, lowerLimit, upperLimit) {
      if (C.JSInt_methods.compareTo$1(lowerLimit, upperLimit) > 0)
        throw H.wrapException(H.argumentErrorValue(lowerLimit));
      if (this.compareTo$1(receiver, lowerLimit) < 0)
        return lowerLimit;
      if (this.compareTo$1(receiver, upperLimit) > 0)
        return upperLimit;
      return receiver;
    },
    toRadixString$1(receiver, radix) {
      var result, match, exponent, t1;
      if (radix < 2 || radix > 36)
        throw H.wrapException(P.RangeError$range(radix, 2, 36, "radix", null));
      result = receiver.toString(radix);
      if (C.JSString_methods.codeUnitAt$1(result, result.length - 1) !== 41)
        return result;
      match = /^([\da-z]+)(?:\.([\da-z]+))?\(e\+(\d+)\)$/.exec(result);
      if (match == null)
        H.throwExpression(P.UnsupportedError$("Unexpected toString result: " + result));
      result = match[1];
      exponent = +match[3];
      t1 = match[2];
      if (t1 != null) {
        result += t1;
        exponent -= t1.length;
      }
      return result + C.JSString_methods.$mul("0", exponent);
    },
    toString$0(receiver) {
      if (receiver === 0 && 1 / receiver < 0)
        return "-0.0";
      else
        return "" + receiver;
    },
    get$hashCode(receiver) {
      var absolute, floorLog2, factor, scaled,
        intValue = receiver | 0;
      if (receiver === intValue)
        return intValue & 536870911;
      absolute = Math.abs(receiver);
      floorLog2 = Math.log(absolute) / 0.6931471805599453 | 0;
      factor = Math.pow(2, floorLog2);
      scaled = absolute < 1 ? absolute / factor : factor / absolute;
      return ((scaled * 9007199254740992 | 0) + (scaled * 3542243181176521 | 0)) * 599197 + floorLog2 * 1259 & 536870911;
    },
    $add(receiver, other) {
      return receiver + other;
    },
    $mod(receiver, other) {
      var result = receiver % other;
      if (result === 0)
        return 0;
      if (result > 0)
        return result;
      if (other < 0)
        return result - other;
      else
        return result + other;
    },
    $tdiv(receiver, other) {
      if ((receiver | 0) === receiver)
        if (other >= 1 || other < -1)
          return receiver / other | 0;
      return this._tdivSlow$1(receiver, other);
    },
    _tdivFast$1(receiver, other) {
      return (receiver | 0) === receiver ? receiver / other | 0 : this._tdivSlow$1(receiver, other);
    },
    _tdivSlow$1(receiver, other) {
      var quotient = receiver / other;
      if (quotient >= -2147483648 && quotient <= 2147483647)
        return quotient | 0;
      if (quotient > 0) {
        if (quotient !== 1 / 0)
          return Math.floor(quotient);
      } else if (quotient > -1 / 0)
        return Math.ceil(quotient);
      throw H.wrapException(P.UnsupportedError$("Result of truncating division is " + H.S(quotient) + ": " + H.S(receiver) + " ~/ " + other));
    },
    _shrOtherPositive$1(receiver, other) {
      var t1;
      if (receiver > 0)
        t1 = this._shrBothPositive$1(receiver, other);
      else {
        t1 = other > 31 ? 31 : other;
        t1 = receiver >> t1 >>> 0;
      }
      return t1;
    },
    _shrReceiverPositive$1(receiver, other) {
      if (0 > other)
        throw H.wrapException(H.argumentErrorValue(other));
      return this._shrBothPositive$1(receiver, other);
    },
    _shrBothPositive$1(receiver, other) {
      return other > 31 ? 0 : receiver >>> other;
    },
    $isComparable: 1,
    $isdouble: 1,
    $isnum: 1
  };
  J.JSInt.prototype = {$isint: 1};
  J.JSNumNotInt.prototype = {};
  J.JSString.prototype = {
    codeUnitAt$1(receiver, index) {
      if (index < 0)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      if (index >= receiver.length)
        H.throwExpression(H.diagnoseIndexError(receiver, index));
      return receiver.charCodeAt(index);
    },
    _codeUnitAt$1(receiver, index) {
      if (index >= receiver.length)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      return receiver.charCodeAt(index);
    },
    allMatches$2(receiver, string, start) {
      var t1 = string.length;
      if (start > t1)
        throw H.wrapException(P.RangeError$range(start, 0, t1, null, null));
      return new H._StringAllMatchesIterable(string, receiver, start);
    },
    allMatches$1($receiver, string) {
      return this.allMatches$2($receiver, string, 0);
    },
    matchAsPrefix$2(receiver, string, start) {
      var t1, i, _null = null;
      if (start < 0 || start > string.length)
        throw H.wrapException(P.RangeError$range(start, 0, string.length, _null, _null));
      t1 = receiver.length;
      if (start + t1 > string.length)
        return _null;
      for (i = 0; i < t1; ++i)
        if (this.codeUnitAt$1(string, start + i) !== this._codeUnitAt$1(receiver, i))
          return _null;
      return new H.StringMatch(start, receiver);
    },
    $add(receiver, other) {
      return receiver + other;
    },
    endsWith$1(receiver, other) {
      var otherLength = other.length,
        t1 = receiver.length;
      if (otherLength > t1)
        return false;
      return other === this.substring$1(receiver, t1 - otherLength);
    },
    replaceFirst$2(receiver, from, to) {
      P.RangeError_checkValueInInterval(0, 0, receiver.length, "startIndex");
      return H.stringReplaceFirstUnchecked(receiver, from, to, 0);
    },
    split$1(receiver, pattern) {
      if (typeof pattern == "string")
        return H._setArrayType(receiver.split(pattern), type$.JSArray_String);
      else if (pattern instanceof H.JSSyntaxRegExp && pattern.get$_nativeAnchoredVersion().exec("").length - 2 === 0)
        return H._setArrayType(receiver.split(pattern._nativeRegExp), type$.JSArray_String);
      else
        return this._defaultSplit$1(receiver, pattern);
    },
    replaceRange$3(receiver, start, end, replacement) {
      var e = P.RangeError_checkValidRange(start, end, receiver.length);
      return H.stringReplaceRangeUnchecked(receiver, start, e, replacement);
    },
    _defaultSplit$1(receiver, pattern) {
      var t1, start, $length, match, matchStart, matchEnd,
        result = H._setArrayType([], type$.JSArray_String);
      for (t1 = J.allMatches$1$s(pattern, receiver), t1 = t1.get$iterator(t1), start = 0, $length = 1; t1.moveNext$0();) {
        match = t1.get$current(t1);
        matchStart = match.get$start(match);
        matchEnd = match.get$end(match);
        $length = matchEnd - matchStart;
        if ($length === 0 && start === matchStart)
          continue;
        result.push(this.substring$2(receiver, start, matchStart));
        start = matchEnd;
      }
      if (start < receiver.length || $length > 0)
        result.push(this.substring$1(receiver, start));
      return result;
    },
    startsWith$2(receiver, pattern, index) {
      var endIndex;
      if (index < 0 || index > receiver.length)
        throw H.wrapException(P.RangeError$range(index, 0, receiver.length, null, null));
      if (typeof pattern == "string") {
        endIndex = index + pattern.length;
        if (endIndex > receiver.length)
          return false;
        return pattern === receiver.substring(index, endIndex);
      }
      return J.matchAsPrefix$2$s(pattern, receiver, index) != null;
    },
    startsWith$1($receiver, pattern) {
      return this.startsWith$2($receiver, pattern, 0);
    },
    substring$2(receiver, start, end) {
      return receiver.substring(start, P.RangeError_checkValidRange(start, end, receiver.length));
    },
    substring$1($receiver, start) {
      return this.substring$2($receiver, start, null);
    },
    trim$0(receiver) {
      var startIndex, t1, endIndex0,
        result = receiver.trim(),
        endIndex = result.length;
      if (endIndex === 0)
        return result;
      if (this._codeUnitAt$1(result, 0) === 133) {
        startIndex = J.JSString__skipLeadingWhitespace(result, 1);
        if (startIndex === endIndex)
          return "";
      } else
        startIndex = 0;
      t1 = endIndex - 1;
      endIndex0 = this.codeUnitAt$1(result, t1) === 133 ? J.JSString__skipTrailingWhitespace(result, t1) : endIndex;
      if (startIndex === 0 && endIndex0 === endIndex)
        return result;
      return result.substring(startIndex, endIndex0);
    },
    trimRight$0(receiver) {
      var result, endIndex, t1;
      if (typeof receiver.trimRight != "undefined") {
        result = receiver.trimRight();
        endIndex = result.length;
        if (endIndex === 0)
          return result;
        t1 = endIndex - 1;
        if (this.codeUnitAt$1(result, t1) === 133)
          endIndex = J.JSString__skipTrailingWhitespace(result, t1);
      } else {
        endIndex = J.JSString__skipTrailingWhitespace(receiver, receiver.length);
        result = receiver;
      }
      if (endIndex === result.length)
        return result;
      if (endIndex === 0)
        return "";
      return result.substring(0, endIndex);
    },
    $mul(receiver, times) {
      var s, result;
      if (0 >= times)
        return "";
      if (times === 1 || receiver.length === 0)
        return receiver;
      if (times !== times >>> 0)
        throw H.wrapException(C.C_OutOfMemoryError);
      for (s = receiver, result = ""; true;) {
        if ((times & 1) === 1)
          result = s + result;
        times = times >>> 1;
        if (times === 0)
          break;
        s += s;
      }
      return result;
    },
    padLeft$2(receiver, width, padding) {
      var delta = width - receiver.length;
      if (delta <= 0)
        return receiver;
      return this.$mul(padding, delta) + receiver;
    },
    padRight$1(receiver, width) {
      var delta = width - receiver.length;
      if (delta <= 0)
        return receiver;
      return receiver + this.$mul(" ", delta);
    },
    indexOf$2(receiver, pattern, start) {
      var t1;
      if (start < 0 || start > receiver.length)
        throw H.wrapException(P.RangeError$range(start, 0, receiver.length, null, null));
      t1 = receiver.indexOf(pattern, start);
      return t1;
    },
    indexOf$1($receiver, pattern) {
      return this.indexOf$2($receiver, pattern, 0);
    },
    lastIndexOf$2(receiver, pattern, start) {
      var t1, t2, i;
      if (start == null)
        start = receiver.length;
      else if (start < 0 || start > receiver.length)
        throw H.wrapException(P.RangeError$range(start, 0, receiver.length, null, null));
      if (typeof pattern == "string") {
        t1 = pattern.length;
        t2 = receiver.length;
        if (start + t1 > t2)
          start = t2 - t1;
        return receiver.lastIndexOf(pattern, start);
      }
      for (t1 = J.getInterceptor$s(pattern), i = start; i >= 0; --i)
        if (t1.matchAsPrefix$2(pattern, receiver, i) != null)
          return i;
      return -1;
    },
    lastIndexOf$1($receiver, pattern) {
      return this.lastIndexOf$2($receiver, pattern, null);
    },
    contains$2(receiver, other, startIndex) {
      var t1 = receiver.length;
      if (startIndex > t1)
        throw H.wrapException(P.RangeError$range(startIndex, 0, t1, null, null));
      return H.stringContainsUnchecked(receiver, other, startIndex);
    },
    contains$1($receiver, other) {
      return this.contains$2($receiver, other, 0);
    },
    get$isNotEmpty(receiver) {
      return receiver.length !== 0;
    },
    compareTo$1(receiver, other) {
      var t1;
      if (receiver === other)
        t1 = 0;
      else
        t1 = receiver < other ? -1 : 1;
      return t1;
    },
    toString$0(receiver) {
      return receiver;
    },
    get$hashCode(receiver) {
      var t1, hash, i;
      for (t1 = receiver.length, hash = 0, i = 0; i < t1; ++i) {
        hash = hash + receiver.charCodeAt(i) & 536870911;
        hash = hash + ((hash & 524287) << 10) & 536870911;
        hash ^= hash >> 6;
      }
      hash = hash + ((hash & 67108863) << 3) & 536870911;
      hash ^= hash >> 11;
      return hash + ((hash & 16383) << 15) & 536870911;
    },
    get$length(receiver) {
      return receiver.length;
    },
    $isComparable: 1,
    $isString: 1
  };
  H._CastIterableBase.prototype = {
    get$iterator(_) {
      var t1 = H._instanceType(this);
      return new H.CastIterator(J.get$iterator$ax(this.get$_source()), t1._eval$1("@<1>")._bind$1(t1._rest[1])._eval$1("CastIterator<1,2>"));
    },
    get$length(_) {
      return J.get$length$asx(this.get$_source());
    },
    get$isEmpty(_) {
      return J.get$isEmpty$asx(this.get$_source());
    },
    get$isNotEmpty(_) {
      return J.get$isNotEmpty$asx(this.get$_source());
    },
    skip$1(_, count) {
      var t1 = H._instanceType(this);
      return H.CastIterable_CastIterable(J.skip$1$ax(this.get$_source(), count), t1._precomputed1, t1._rest[1]);
    },
    take$1(_, count) {
      var t1 = H._instanceType(this);
      return H.CastIterable_CastIterable(J.take$1$ax(this.get$_source(), count), t1._precomputed1, t1._rest[1]);
    },
    elementAt$1(_, index) {
      return H._instanceType(this)._rest[1]._as(J.elementAt$1$ax(this.get$_source(), index));
    },
    get$first(_) {
      return H._instanceType(this)._rest[1]._as(J.get$first$ax(this.get$_source()));
    },
    get$last(_) {
      return H._instanceType(this)._rest[1]._as(J.get$last$ax(this.get$_source()));
    },
    get$single(_) {
      return H._instanceType(this)._rest[1]._as(J.get$single$ax(this.get$_source()));
    },
    contains$1(_, other) {
      return J.contains$1$asx(this.get$_source(), other);
    },
    toString$0(_) {
      return J.toString$0$(this.get$_source());
    }
  };
  H.CastIterator.prototype = {
    moveNext$0() {
      return this._source.moveNext$0();
    },
    get$current(_) {
      var t1 = this._source;
      return this.$ti._rest[1]._as(t1.get$current(t1));
    }
  };
  H.CastIterable.prototype = {
    get$_source() {
      return this._source;
    }
  };
  H._EfficientLengthCastIterable.prototype = {$isEfficientLengthIterable: 1};
  H._CastListBase.prototype = {
    $index(_, index) {
      return this.$ti._rest[1]._as(J.$index$asx(this._source, index));
    },
    $indexSet(_, index, value) {
      J.$indexSet$ax(this._source, index, this.$ti._precomputed1._as(value));
    },
    set$length(_, $length) {
      J.set$length$asx(this._source, $length);
    },
    add$1(_, value) {
      J.add$1$ax(this._source, this.$ti._precomputed1._as(value));
    },
    sort$1(_, compare) {
      var t1 = compare == null ? null : new H._CastListBase_sort_closure(this, compare);
      J.sort$1$ax(this._source, t1);
    },
    getRange$2(_, start, end) {
      var t1 = this.$ti;
      return H.CastIterable_CastIterable(J.getRange$2$ax(this._source, start, end), t1._precomputed1, t1._rest[1]);
    },
    setRange$4(_, start, end, iterable, skipCount) {
      var t1 = this.$ti;
      J.setRange$4$ax(this._source, start, end, H.CastIterable_CastIterable(iterable, t1._rest[1], t1._precomputed1), skipCount);
    },
    fillRange$3(_, start, end, fillValue) {
      J.fillRange$3$ax(this._source, start, end, this.$ti._precomputed1._as(fillValue));
    },
    $isEfficientLengthIterable: 1,
    $isList: 1
  };
  H._CastListBase_sort_closure.prototype = {
    call$2(v1, v2) {
      var t1 = this.$this.$ti._rest[1];
      return this.compare.call$2(t1._as(v1), t1._as(v2));
    },
    $signature() {
      return this.$this.$ti._eval$1("int(1,1)");
    }
  };
  H.CastList.prototype = {
    cast$1$0(_, $R) {
      return new H.CastList(this._source, this.$ti._eval$1("@<1>")._bind$1($R)._eval$1("CastList<1,2>"));
    },
    get$_source() {
      return this._source;
    }
  };
  H.CastSet.prototype = {
    add$1(_, value) {
      return this._source.add$1(0, this.$ti._precomputed1._as(value));
    },
    addAll$1(_, elements) {
      var t1 = this.$ti;
      this._source.addAll$1(0, H.CastIterable_CastIterable(elements, t1._rest[1], t1._precomputed1));
    },
    difference$1(other) {
      var t1, _this = this;
      if (_this._emptySet != null)
        return _this._conditionalAdd$2(other, false);
      t1 = _this.$ti;
      return new H.CastSet(_this._source.difference$1(other), null, t1._eval$1("@<1>")._bind$1(t1._rest[1])._eval$1("CastSet<1,2>"));
    },
    _conditionalAdd$2(other, otherContains) {
      var t3, castElement,
        emptySet = this._emptySet,
        t1 = this.$ti,
        t2 = t1._rest[1],
        result = emptySet == null ? P.LinkedHashSet_LinkedHashSet(t2) : emptySet.call$1$0(t2);
      for (t2 = this._source, t2 = t2.get$iterator(t2), t3 = other._source, t1 = t1._rest[1]; t2.moveNext$0();) {
        castElement = t1._as(t2.get$current(t2));
        if (otherContains === t3.contains$1(0, castElement))
          result.add$1(0, castElement);
      }
      return result;
    },
    toSet$0(_) {
      var emptySet = this._emptySet,
        t1 = this.$ti._rest[1],
        result = emptySet == null ? P.LinkedHashSet_LinkedHashSet(t1) : emptySet.call$1$0(t1);
      result.addAll$1(0, this);
      return result;
    },
    $isEfficientLengthIterable: 1,
    $isSet: 1,
    get$_source() {
      return this._source;
    }
  };
  H.CastMap.prototype = {
    cast$2$0(_, RK, RV) {
      var t1 = this.$ti;
      return new H.CastMap(this._source, t1._eval$1("@<1>")._bind$1(t1._rest[1])._bind$1(RK)._bind$1(RV)._eval$1("CastMap<1,2,3,4>"));
    },
    containsKey$1(key) {
      return this._source.containsKey$1(key);
    },
    $index(_, key) {
      return this.$ti._eval$1("4?")._as(this._source.$index(0, key));
    },
    $indexSet(_, key, value) {
      var t1 = this.$ti;
      this._source.$indexSet(0, t1._precomputed1._as(key), t1._rest[1]._as(value));
    },
    addAll$1(_, other) {
      var t1 = this.$ti;
      this._source.addAll$1(0, new H.CastMap(other, t1._eval$1("@<3>")._bind$1(t1._rest[3])._bind$1(t1._precomputed1)._bind$1(t1._rest[1])._eval$1("CastMap<1,2,3,4>")));
    },
    remove$1(_, key) {
      return this.$ti._eval$1("4?")._as(this._source.remove$1(0, key));
    },
    forEach$1(_, f) {
      this._source.forEach$1(0, new H.CastMap_forEach_closure(this, f));
    },
    get$keys(_) {
      var t1 = this._source,
        t2 = this.$ti;
      return H.CastIterable_CastIterable(t1.get$keys(t1), t2._precomputed1, t2._rest[2]);
    },
    get$values(_) {
      var t1 = this._source,
        t2 = this.$ti;
      return H.CastIterable_CastIterable(t1.get$values(t1), t2._rest[1], t2._rest[3]);
    },
    get$length(_) {
      var t1 = this._source;
      return t1.get$length(t1);
    },
    get$isEmpty(_) {
      var t1 = this._source;
      return t1.get$isEmpty(t1);
    },
    get$isNotEmpty(_) {
      var t1 = this._source;
      return t1.get$isNotEmpty(t1);
    },
    get$entries(_) {
      var t1 = this._source;
      return t1.get$entries(t1).map$1$1(0, new H.CastMap_entries_closure(this), this.$ti._eval$1("MapEntry<3,4>"));
    }
  };
  H.CastMap_forEach_closure.prototype = {
    call$2(key, value) {
      var t1 = this.$this.$ti;
      this.f.call$2(t1._rest[2]._as(key), t1._rest[3]._as(value));
    },
    $signature() {
      return this.$this.$ti._eval$1("~(1,2)");
    }
  };
  H.CastMap_entries_closure.prototype = {
    call$1(e) {
      var t1 = this.$this.$ti,
        t2 = t1._rest[3];
      return new P.MapEntry(t1._rest[2]._as(e.key), t2._as(e.value), t1._eval$1("@<3>")._bind$1(t2)._eval$1("MapEntry<1,2>"));
    },
    $signature() {
      return this.$this.$ti._eval$1("MapEntry<3,4>(MapEntry<1,2>)");
    }
  };
  H.LateError.prototype = {
    toString$0(_) {
      var t1 = "LateInitializationError: " + this._message;
      return t1;
    }
  };
  H.CodeUnits.prototype = {
    get$length(_) {
      return this._string.length;
    },
    $index(_, i) {
      return C.JSString_methods.codeUnitAt$1(this._string, i);
    }
  };
  H.nullFuture_closure.prototype = {
    call$0() {
      return P.Future_Future$value(null, type$.Null);
    },
    $signature: 2
  };
  H.EfficientLengthIterable.prototype = {};
  H.ListIterable.prototype = {
    get$iterator(_) {
      return new H.ListIterator(this, this.get$length(this));
    },
    get$isEmpty(_) {
      return this.get$length(this) === 0;
    },
    get$first(_) {
      if (this.get$length(this) === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      return this.elementAt$1(0, 0);
    },
    get$last(_) {
      var _this = this;
      if (_this.get$length(_this) === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      return _this.elementAt$1(0, _this.get$length(_this) - 1);
    },
    get$single(_) {
      var _this = this;
      if (_this.get$length(_this) === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      if (_this.get$length(_this) > 1)
        throw H.wrapException(H.IterableElementError_tooMany());
      return _this.elementAt$1(0, 0);
    },
    contains$1(_, element) {
      var i, _this = this,
        $length = _this.get$length(_this);
      for (i = 0; i < $length; ++i) {
        if (J.$eq$(_this.elementAt$1(0, i), element))
          return true;
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return false;
    },
    any$1(_, test) {
      var i, _this = this,
        $length = _this.get$length(_this);
      for (i = 0; i < $length; ++i) {
        if (test.call$1(_this.elementAt$1(0, i)))
          return true;
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return false;
    },
    join$1(_, separator) {
      var first, t1, i, _this = this,
        $length = _this.get$length(_this);
      if (separator.length !== 0) {
        if ($length === 0)
          return "";
        first = H.S(_this.elementAt$1(0, 0));
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
        for (t1 = first, i = 1; i < $length; ++i) {
          t1 = t1 + separator + H.S(_this.elementAt$1(0, i));
          if ($length !== _this.get$length(_this))
            throw H.wrapException(P.ConcurrentModificationError$(_this));
        }
        return t1.charCodeAt(0) == 0 ? t1 : t1;
      } else {
        for (i = 0, t1 = ""; i < $length; ++i) {
          t1 += H.S(_this.elementAt$1(0, i));
          if ($length !== _this.get$length(_this))
            throw H.wrapException(P.ConcurrentModificationError$(_this));
        }
        return t1.charCodeAt(0) == 0 ? t1 : t1;
      }
    },
    join$0($receiver) {
      return this.join$1($receiver, "");
    },
    where$1(_, test) {
      return this.super$Iterable$where(0, test);
    },
    map$1$1(_, toElement, $T) {
      return new H.MappedListIterable(this, toElement, H._instanceType(this)._eval$1("@<ListIterable.E>")._bind$1($T)._eval$1("MappedListIterable<1,2>"));
    },
    reduce$1(_, combine) {
      var value, i, _this = this,
        $length = _this.get$length(_this);
      if ($length === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      value = _this.elementAt$1(0, 0);
      for (i = 1; i < $length; ++i) {
        value = combine.call$2(value, _this.elementAt$1(0, i));
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return value;
    },
    fold$1$2(_, initialValue, combine) {
      var value, i, _this = this,
        $length = _this.get$length(_this);
      for (value = initialValue, i = 0; i < $length; ++i) {
        value = combine.call$2(value, _this.elementAt$1(0, i));
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return value;
    },
    fold$2($receiver, initialValue, combine) {
      return this.fold$1$2($receiver, initialValue, combine, type$.dynamic);
    },
    skip$1(_, count) {
      return H.SubListIterable$(this, count, null, H._instanceType(this)._eval$1("ListIterable.E"));
    },
    take$1(_, count) {
      return H.SubListIterable$(this, 0, H.checkNotNullable(count, "count", type$.int), H._instanceType(this)._eval$1("ListIterable.E"));
    },
    toList$1$growable(_, growable) {
      return P.List_List$of(this, true, H._instanceType(this)._eval$1("ListIterable.E"));
    },
    toList$0($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    toSet$0(_) {
      var i, _this = this,
        result = P.LinkedHashSet_LinkedHashSet(H._instanceType(_this)._eval$1("ListIterable.E"));
      for (i = 0; i < _this.get$length(_this); ++i)
        result.add$1(0, _this.elementAt$1(0, i));
      return result;
    }
  };
  H.SubListIterable.prototype = {
    SubListIterable$3(_iterable, _start, _endOrLength, $E) {
      var endOrLength,
        t1 = this._start;
      P.RangeError_checkNotNegative(t1, "start");
      endOrLength = this._endOrLength;
      if (endOrLength != null) {
        P.RangeError_checkNotNegative(endOrLength, "end");
        if (t1 > endOrLength)
          throw H.wrapException(P.RangeError$range(t1, 0, endOrLength, "start", null));
      }
    },
    get$_endIndex() {
      var $length = J.get$length$asx(this.__internal$_iterable),
        endOrLength = this._endOrLength;
      if (endOrLength == null || endOrLength > $length)
        return $length;
      return endOrLength;
    },
    get$_startIndex() {
      var $length = J.get$length$asx(this.__internal$_iterable),
        t1 = this._start;
      if (t1 > $length)
        return $length;
      return t1;
    },
    get$length(_) {
      var endOrLength,
        $length = J.get$length$asx(this.__internal$_iterable),
        t1 = this._start;
      if (t1 >= $length)
        return 0;
      endOrLength = this._endOrLength;
      if (endOrLength == null || endOrLength >= $length)
        return $length - t1;
      return endOrLength - t1;
    },
    elementAt$1(_, index) {
      var _this = this,
        realIndex = _this.get$_startIndex() + index;
      if (index < 0 || realIndex >= _this.get$_endIndex())
        throw H.wrapException(P.IndexError$(index, _this, "index", null, null));
      return J.elementAt$1$ax(_this.__internal$_iterable, realIndex);
    },
    skip$1(_, count) {
      var newStart, endOrLength, _this = this;
      P.RangeError_checkNotNegative(count, "count");
      newStart = _this._start + count;
      endOrLength = _this._endOrLength;
      if (endOrLength != null && newStart >= endOrLength)
        return new H.EmptyIterable(_this.$ti._eval$1("EmptyIterable<1>"));
      return H.SubListIterable$(_this.__internal$_iterable, newStart, endOrLength, _this.$ti._precomputed1);
    },
    take$1(_, count) {
      var endOrLength, t1, newEnd, _this = this;
      P.RangeError_checkNotNegative(count, "count");
      endOrLength = _this._endOrLength;
      t1 = _this._start;
      newEnd = t1 + count;
      if (endOrLength == null)
        return H.SubListIterable$(_this.__internal$_iterable, t1, newEnd, _this.$ti._precomputed1);
      else {
        if (endOrLength < newEnd)
          return _this;
        return H.SubListIterable$(_this.__internal$_iterable, t1, newEnd, _this.$ti._precomputed1);
      }
    },
    toList$1$growable(_, growable) {
      var $length, result, i, _this = this,
        start = _this._start,
        t1 = _this.__internal$_iterable,
        t2 = J.getInterceptor$asx(t1),
        end = t2.get$length(t1),
        endOrLength = _this._endOrLength;
      if (endOrLength != null && endOrLength < end)
        end = endOrLength;
      $length = end - start;
      if ($length <= 0) {
        t1 = _this.$ti._precomputed1;
        return growable ? J.JSArray_JSArray$growable(0, t1) : J.JSArray_JSArray$fixed(0, t1);
      }
      result = P.List_List$filled($length, t2.elementAt$1(t1, start), growable, _this.$ti._precomputed1);
      for (i = 1; i < $length; ++i) {
        result[i] = t2.elementAt$1(t1, start + i);
        if (t2.get$length(t1) < end)
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return result;
    },
    toList$0($receiver) {
      return this.toList$1$growable($receiver, true);
    }
  };
  H.ListIterator.prototype = {
    get$current(_) {
      return H._instanceType(this)._precomputed1._as(this.__internal$_current);
    },
    moveNext$0() {
      var t3, _this = this,
        t1 = _this.__internal$_iterable,
        t2 = J.getInterceptor$asx(t1),
        $length = t2.get$length(t1);
      if (_this.__internal$_length !== $length)
        throw H.wrapException(P.ConcurrentModificationError$(t1));
      t3 = _this.__internal$_index;
      if (t3 >= $length) {
        _this.__internal$_current = null;
        return false;
      }
      _this.__internal$_current = t2.elementAt$1(t1, t3);
      ++_this.__internal$_index;
      return true;
    }
  };
  H.MappedIterable.prototype = {
    get$iterator(_) {
      return new H.MappedIterator(J.get$iterator$ax(this.__internal$_iterable), this._f);
    },
    get$length